#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import logging

from terra_object import TerraObject
from manager import Manager


log = logging.getLogger("terra.core.task")


class Task(TerraObject):
    terra_task_type = "Task"


class TaskController(TerraObject):
    terra_type = "TaskController"

    def __init__(self, task, parent, multitask=None):
        TerraObject.__init__(self)
        self.task = task
        self.parent = parent
        self.multitask = multitask

    # FIXME: maybe add some base methods here

    def __str__(self):
        return "%s(task=%r, parent=%s, multitask=%s)" % \
               (self.__class__.__name__, self.task,
                bool(self.parent), bool(self.multitask))

    __repr__ = __str__


def _task_controller_type_from_string(task_type):
    task_name = task_type
    if task_type.startswith("Task/"):
        task_name = task_type[5:]

    return "TaskController/%s" % task_name


def _get_parent_type(type_name):
    try:
        type_name = type_name[:type_name.rindex("/")]
    except ValueError:
        return None

    return type_name


def get_task_controller_for_task(task, parent, multitask=None):
    mger = Manager()
    type_name = _task_controller_type_from_string(task.terra_task_type)

    while type_name:
        log.debug("looking for TASK controller with filter %r ...", type_name)

        try:
            cls = mger.get_class(type_name)
            log.debug("found TASK controller with filter %r!", type_name)
            taskcont = cls(task, parent, multitask)
            return taskcont
        except ValueError:
            pass

        type_name = _get_parent_type(type_name)

    return None
