/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.11-snapshot-c38d259c1879 on Sun Aug 29 15:17:09 2010
 *
 * Copyright (c) 2010 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 40 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 39 "sipQtCoreQDate.cpp"

#line 41 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 43 "sipQtCoreQDate.cpp"
#line 40 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 46 "sipQtCoreQDate.cpp"
#line 44 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
#include <QHash>

#if PY_VERSION_HEX >= 0x02040000
#include <datetime.h>
#endif
#line 53 "sipQtCoreQDate.cpp"


extern "C" {static PyObject *meth_QDate_toPyDate(PyObject *, PyObject *);}
static PyObject *meth_QDate_toPyDate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            PyObject * sipRes = 0;

#line 117 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
        if (!PyDateTimeAPI)
            PyDateTime_IMPORT;
        
        // Convert to a Python date object.
        sipRes = PyDate_FromDate(sipCpp->year(), sipCpp->month(), sipCpp->day());
#line 74 "sipQtCoreQDate.cpp"

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_toPyDate, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_isNull(PyObject *, PyObject *);}
static PyObject *meth_QDate_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_isNull, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_isValid(PyObject *, PyObject *);}
static PyObject *meth_QDate_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isValid();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int a0;
        int a1;
        int a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "iii", &a0, &a1, &a2))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QDate::isValid(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_isValid, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_year(PyObject *, PyObject *);}
static PyObject *meth_QDate_year(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->year();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_year, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_month(PyObject *, PyObject *);}
static PyObject *meth_QDate_month(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->month();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_month, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_day(PyObject *, PyObject *);}
static PyObject *meth_QDate_day(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->day();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_day, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_dayOfWeek(PyObject *, PyObject *);}
static PyObject *meth_QDate_dayOfWeek(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->dayOfWeek();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_dayOfWeek, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_dayOfYear(PyObject *, PyObject *);}
static PyObject *meth_QDate_dayOfYear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->dayOfYear();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_dayOfYear, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_daysInMonth(PyObject *, PyObject *);}
static PyObject *meth_QDate_daysInMonth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->daysInMonth();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_daysInMonth, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_daysInYear(PyObject *, PyObject *);}
static PyObject *meth_QDate_daysInYear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->daysInYear();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_daysInYear, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_weekNumber(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDate_weekNumber(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QDate *sipCpp;

        static const char *sipKwdList[] = {
            sipName_yearNumber,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->weekNumber(&a0);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(ii)",sipRes,a0);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_weekNumber, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_shortMonthName(PyObject *, PyObject *);}
static PyObject *meth_QDate_shortMonthName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "i", &a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::shortMonthName(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    {
        int a0;
        QDate::MonthNameType a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "iE", &a0, sipType_QDate_MonthNameType, &a1))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::shortMonthName(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_shortMonthName, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_shortDayName(PyObject *, PyObject *);}
static PyObject *meth_QDate_shortDayName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "i", &a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::shortDayName(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    {
        int a0;
        QDate::MonthNameType a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "iE", &a0, sipType_QDate_MonthNameType, &a1))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::shortDayName(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_shortDayName, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_longMonthName(PyObject *, PyObject *);}
static PyObject *meth_QDate_longMonthName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "i", &a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::longMonthName(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    {
        int a0;
        QDate::MonthNameType a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "iE", &a0, sipType_QDate_MonthNameType, &a1))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::longMonthName(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_longMonthName, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_longDayName(PyObject *, PyObject *);}
static PyObject *meth_QDate_longDayName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "i", &a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::longDayName(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    {
        int a0;
        QDate::MonthNameType a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "iE", &a0, sipType_QDate_MonthNameType, &a1))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QDate::longDayName(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_longDayName, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_toString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDate_toString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        Qt::DateFormat a0 = Qt::TextDate;
        QDate *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|E", &sipSelf, sipType_QDate, &sipCpp, sipType_Qt_DateFormat, &a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->toString(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        QDate *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "BJ1", &sipSelf, sipType_QDate, &sipCpp, sipType_QString,&a0, &a0State))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->toString(*a0));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_toString, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_setYMD(PyObject *, PyObject *);}
static PyObject *meth_QDate_setYMD(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1;
        int a2;
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Biii", &sipSelf, sipType_QDate, &sipCpp, &a0, &a1, &a2))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->setYMD(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_setYMD, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_addDays(PyObject *, PyObject *);}
static PyObject *meth_QDate_addDays(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDate, &sipCpp, &a0))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(sipCpp->addDays(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_addDays, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_addMonths(PyObject *, PyObject *);}
static PyObject *meth_QDate_addMonths(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDate, &sipCpp, &a0))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(sipCpp->addMonths(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_addMonths, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_addYears(PyObject *, PyObject *);}
static PyObject *meth_QDate_addYears(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDate, &sipCpp, &a0))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(sipCpp->addYears(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_addYears, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_daysTo(PyObject *, PyObject *);}
static PyObject *meth_QDate_daysTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QDate * a0;
        int a0State = 0;
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDate, &sipCpp, sipType_QDate, &a0, &a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->daysTo(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDate *>(a0),sipType_QDate,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_daysTo, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_currentDate(PyObject *, PyObject *);}
static PyObject *meth_QDate_currentDate(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(QDate::currentDate());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_currentDate, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_fromString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDate_fromString(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        Qt::DateFormat a1 = Qt::TextDate;

        static const char *sipKwdList[] = {
            NULL,
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1|E", sipType_QString,&a0, &a0State, sipType_Qt_DateFormat, &a1))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(QDate::fromString(*a0,a1));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return sipConvertFromNewType(sipRes,sipType_QDate,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        const QString * a1;
        int a1State = 0;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "J1J1", sipType_QString,&a0, &a0State, sipType_QString,&a1, &a1State))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(QDate::fromString(*a0,*a1));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);
            sipReleaseType(const_cast<QString *>(a1),sipType_QString,a1State);

            return sipConvertFromNewType(sipRes,sipType_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_fromString, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_isLeapYear(PyObject *, PyObject *);}
static PyObject *meth_QDate_isLeapYear(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "i", &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QDate::isLeapYear(a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_isLeapYear, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_gregorianToJulian(PyObject *, PyObject *);}
static PyObject *meth_QDate_gregorianToJulian(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1;
        int a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "iii", &a0, &a1, &a2))
        {
            uint sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QDate::gregorianToJulian(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_gregorianToJulian, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_julianToGregorian(PyObject *, PyObject *);}
static PyObject *meth_QDate_julianToGregorian(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        uint a0;
        int a1;
        int a2;
        int a3;

        if (sipParseArgs(&sipParseErr, sipArgs, "u", &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            QDate::julianToGregorian(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(iii)",a1,a2,a3);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_julianToGregorian, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_fromJulianDay(PyObject *, PyObject *);}
static PyObject *meth_QDate_fromJulianDay(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "i", &a0))
        {
            QDate *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDate(QDate::fromJulianDay(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QDate,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_fromJulianDay, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_toJulianDay(PyObject *, PyObject *);}
static PyObject *meth_QDate_toJulianDay(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->toJulianDay();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_toJulianDay, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_setDate(PyObject *, PyObject *);}
static PyObject *meth_QDate_setDate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1;
        int a2;
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Biii", &sipSelf, sipType_QDate, &sipCpp, &a0, &a1, &a2))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->setDate(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_setDate, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QDate_getDate(PyObject *, PyObject *);}
static PyObject *meth_QDate_getDate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1;
        int a2;
        QDate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDate, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->getDate(&a0,&a1,&a2);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(iii)",a0,a1,a2);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QDate, sipName_getDate, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_QDate___ge__(PyObject *,PyObject *);}
static PyObject *slot_QDate___ge__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator>=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDate *>(a0),sipType_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,ge_slot,sipType_QDate,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDate___gt__(PyObject *,PyObject *);}
static PyObject *slot_QDate___gt__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator>(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDate *>(a0),sipType_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,gt_slot,sipType_QDate,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDate___le__(PyObject *,PyObject *);}
static PyObject *slot_QDate___le__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator<=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDate *>(a0),sipType_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,le_slot,sipType_QDate,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDate___lt__(PyObject *,PyObject *);}
static PyObject *slot_QDate___lt__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator<(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDate *>(a0),sipType_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,lt_slot,sipType_QDate,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDate___ne__(PyObject *,PyObject *);}
static PyObject *slot_QDate___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator!=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDate *>(a0),sipType_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipType_QDate,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QDate___eq__(PyObject *,PyObject *);}
static PyObject *slot_QDate___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDate, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QDate::operator==(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDate *>(a0),sipType_QDate,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipType_QDate,sipSelf,sipArg);
}


extern "C" {static int slot_QDate___bool__(PyObject *);}
static int slot_QDate___bool__(PyObject *sipSelf)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 128 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
        sipRes = !sipCpp->isNull();
#line 1252 "sipQtCoreQDate.cpp"

            return sipRes;
        }
    }
}


extern "C" {static long slot_QDate___hash__(PyObject *);}
static long slot_QDate___hash__(PyObject *sipSelf)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return 0;


    {
        {
            long sipRes = 0;

#line 103 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
        if (sipIsAPIEnabled("QDate", 2, 0))
        {
            sipRes = qHash(sipCpp->toString(Qt::ISODate));
        }
        else
        {
            // Mimic Python's default behavour.
            sipRes = _Py_HashPointer(sipSelf);
        }
#line 1283 "sipQtCoreQDate.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QDate___repr__(PyObject *);}
static PyObject *slot_QDate___repr__(PyObject *sipSelf)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDate));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 91 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
        sipRes =
        #if PY_MAJOR_VERSION >= 3
            PyUnicode_FromFormat
        #else
            PyString_FromFormat
        #endif
                ("PyQt4.QtCore.QDate(%i, %i, %i)", sipCpp->year(),
                 sipCpp->month(), sipCpp->day());
#line 1313 "sipQtCoreQDate.cpp"

            return sipRes;
        }
    }
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QDate(void *, const sipTypeDef *);}
static void *cast_QDate(void *ptr, const sipTypeDef *targetType)
{
    if (targetType == sipType_QDate)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QDate(void *, int);}
static void release_QDate(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QDate *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QDate(void *);}
static PyObject *pickle_QDate(void *sipCppV)
{
    QDate *sipCpp = reinterpret_cast<QDate *>(sipCppV);
    PyObject *sipRes;

#line 83 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
    sipRes = Py_BuildValue((char *)"iii", sipCpp->year(), sipCpp->month(), sipCpp->day());
#line 1352 "sipQtCoreQDate.cpp"

    return sipRes;
}


extern "C" {static void assign_QDate(void *, SIP_SSIZE_T, const void *);}
static void assign_QDate(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast<QDate *>(sipDst)[sipDstIdx] = *reinterpret_cast<const QDate *>(sipSrc);
}


extern "C" {static void *array_QDate(SIP_SSIZE_T);}
static void *array_QDate(SIP_SSIZE_T sipNrElem)
{
    return new QDate[sipNrElem];
}


extern "C" {static void *copy_QDate(const void *, SIP_SSIZE_T);}
static void *copy_QDate(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new QDate(reinterpret_cast<const QDate *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QDate(sipSimpleWrapper *);}
static void dealloc_QDate(sipSimpleWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QDate(sipGetAddress(sipSelf),0);
    }
}


extern "C" {static void *init_QDate(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_QDate(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    QDate *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDate();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        int a0;
        int a1;
        int a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "iii", &a0, &a1, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDate(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QDate * a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J1", sipType_QDate, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QDate(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QDate *>(a0),sipType_QDate,a0State);

            return sipCpp;
        }
    }

    return NULL;
}


extern "C" {static int convertTo_QDate(PyObject *, void **, int *, PyObject *);}
static int convertTo_QDate(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
    QDate **sipCppPtr = reinterpret_cast<QDate **>(sipCppPtrV);

#line 52 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qdatetime.sip"
#if PY_VERSION_HEX >= 0x02040000
    if (!PyDateTimeAPI)
        PyDateTime_IMPORT;
#endif

// Allow a Python date object whenever a QDate is expected.

if (sipIsErr == NULL)
    return (
#if PY_VERSION_HEX >= 0x02040000
            PyDate_Check(sipPy) ||
#endif
            sipCanConvertToType(sipPy, sipType_QDate, SIP_NO_CONVERTORS));

#if PY_VERSION_HEX >= 0x02040000
if (PyDate_Check(sipPy))
{
    *sipCppPtr = new QDate(PyDateTime_GET_YEAR(sipPy),
                           PyDateTime_GET_MONTH(sipPy),
                           PyDateTime_GET_DAY(sipPy));

    return sipGetState(sipTransferObj);
}
#endif

*sipCppPtr = reinterpret_cast<QDate *>(sipConvertToType(sipPy, sipType_QDate, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

return 0;
#line 1473 "sipQtCoreQDate.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QDate[] = {
    {(void *)slot_QDate___ge__, ge_slot},
    {(void *)slot_QDate___gt__, gt_slot},
    {(void *)slot_QDate___le__, le_slot},
    {(void *)slot_QDate___lt__, lt_slot},
    {(void *)slot_QDate___ne__, ne_slot},
    {(void *)slot_QDate___eq__, eq_slot},
    {(void *)slot_QDate___bool__, bool_slot},
    {(void *)slot_QDate___hash__, hash_slot},
    {(void *)slot_QDate___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QDate[] = {
    {SIP_MLNAME_CAST(sipName_addDays), meth_QDate_addDays, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_addMonths), meth_QDate_addMonths, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_addYears), meth_QDate_addYears, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_currentDate), meth_QDate_currentDate, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_day), meth_QDate_day, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_dayOfWeek), meth_QDate_dayOfWeek, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_dayOfYear), meth_QDate_dayOfYear, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_daysInMonth), meth_QDate_daysInMonth, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_daysInYear), meth_QDate_daysInYear, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_daysTo), meth_QDate_daysTo, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_fromJulianDay), meth_QDate_fromJulianDay, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_fromString), (PyCFunction)meth_QDate_fromString, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_getDate), meth_QDate_getDate, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_gregorianToJulian), meth_QDate_gregorianToJulian, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_isLeapYear), meth_QDate_isLeapYear, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_isNull), meth_QDate_isNull, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_isValid), meth_QDate_isValid, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_julianToGregorian), meth_QDate_julianToGregorian, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_longDayName), meth_QDate_longDayName, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_longMonthName), meth_QDate_longMonthName, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_month), meth_QDate_month, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setDate), meth_QDate_setDate, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setYMD), meth_QDate_setYMD, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_shortDayName), meth_QDate_shortDayName, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_shortMonthName), meth_QDate_shortMonthName, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toJulianDay), meth_QDate_toJulianDay, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toPyDate), meth_QDate_toPyDate, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toString), (PyCFunction)meth_QDate_toString, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_weekNumber), (PyCFunction)meth_QDate_weekNumber, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_year), meth_QDate_year, METH_VARARGS, NULL}
};

static sipEnumMemberDef enummembers_QDate[] = {
    {sipName_DateFormat, QDate::DateFormat, 43},
    {sipName_StandaloneFormat, QDate::StandaloneFormat, 43},
};


pyqt4ClassTypeDef sipTypeDef_QtCore_QDate = {
{
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_QDate,
        {0}
    },
    {
        sipNameNr_QDate,
        {0, 0, 1},
        30, methods_QDate,
        2, enummembers_QDate,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    0,
    sipNameNr_PyQt4_QtCore_pyqtWrapperType,
    sipNameNr_sip_simplewrapper,
    0,
    slots_QDate,
    init_QDate,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_QDate,
    assign_QDate,
    array_QDate,
    copy_QDate,
    release_QDate,
    cast_QDate,
    convertTo_QDate,
    0,
    pickle_QDate
},
    0,
    0,
    0
};
