/*
 * Interface wrapper code.
 *
 * Generated by SIP snapshot-4.10.2-275fa5a54910 on Thu May 20 13:18:49 2010
 *
 * Copyright (c) 2010 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 45 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qquaternion.sip"
#include <qquaternion.h>
#line 39 "sipQtGuiQQuaternion.cpp"

#line 45 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qvector3d.sip"
#include <qvector3d.h>
#line 43 "sipQtGuiQQuaternion.cpp"
#line 45 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qvector4d.sip"
#include <qvector4d.h>
#line 46 "sipQtGuiQQuaternion.cpp"


extern "C" {static PyObject *meth_QQuaternion_length(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_length(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->length();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_length, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_lengthSquared(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_lengthSquared(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lengthSquared();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_lengthSquared, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_normalized(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_normalized(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion(sipCpp->normalized());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_normalized, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_normalize(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_normalize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->normalize();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_normalize, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_rotatedVector(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_rotatedVector(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QQuaternion, &sipCpp, sipType_QVector3D, &a0))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D(sipCpp->rotatedVector(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_rotatedVector, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_fromAxisAndAngle(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_fromAxisAndAngle(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        qreal a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9f", sipType_QVector3D, &a0, &a1))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion(QQuaternion::fromAxisAndAngle(*a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    {
        qreal a0;
        qreal a1;
        qreal a2;
        qreal a3;

        if (sipParseArgs(&sipParseErr, sipArgs, "ffff", &a0, &a1, &a2, &a3))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion(QQuaternion::fromAxisAndAngle(a0,a1,a2,a3));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_fromAxisAndAngle, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_slerp(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_slerp(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QQuaternion * a0;
        const QQuaternion * a1;
        qreal a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9f", sipType_QQuaternion, &a0, sipType_QQuaternion, &a1, &a2))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion(QQuaternion::slerp(*a0,*a1,a2));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_slerp, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_nlerp(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_nlerp(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QQuaternion * a0;
        const QQuaternion * a1;
        qreal a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9f", sipType_QQuaternion, &a0, sipType_QQuaternion, &a1, &a2))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion(QQuaternion::nlerp(*a0,*a1,a2));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_nlerp, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_isNull(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_isNull, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_isIdentity(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_isIdentity(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isIdentity();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_isIdentity, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_x(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_x(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->x();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_x, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_y(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_y(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->y();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_y, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_z(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_z(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->z();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_z, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_scalar(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_scalar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->scalar();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_scalar, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_setX(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_setX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qreal a0;
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QQuaternion, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setX(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_setX, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_setY(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_setY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qreal a0;
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QQuaternion, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setY(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_setY, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_setZ(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_setZ(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qreal a0;
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QQuaternion, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setZ(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_setZ, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_setScalar(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_setScalar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qreal a0;
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QQuaternion, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setScalar(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_setScalar, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_conjugate(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_conjugate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion(sipCpp->conjugate());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_conjugate, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_setVector(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_setVector(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QQuaternion, &sipCpp, sipType_QVector3D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setVector(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        qreal a0;
        qreal a1;
        qreal a2;
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bfff", &sipSelf, sipType_QQuaternion, &sipCpp, &a0, &a1, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setVector(a0,a1,a2);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_setVector, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_vector(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_vector(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D(sipCpp->vector());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_vector, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QQuaternion_toVector4D(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_toVector4D(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            QVector4D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector4D(sipCpp->toVector4D());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector4D,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_toVector4D, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_QQuaternion___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QQuaternion___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QQuaternion *sipCpp = reinterpret_cast<QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QQuaternion * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QQuaternion, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator==((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,eq_slot,sipType_QQuaternion,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QQuaternion___mul__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QQuaternion___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
        const QQuaternion * a0;
        const QQuaternion * a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QQuaternion, &a0, sipType_QQuaternion, &a1))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion((*a0 * *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    {
        qreal a0;
        const QQuaternion * a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "fJ9", &a0, sipType_QQuaternion, &a1))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion((a0 * *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    {
        const QQuaternion * a0;
        qreal a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QQuaternion, &a0, &a1))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion((*a0 * a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,mul_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QQuaternion___div__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QQuaternion___div__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
        const QQuaternion * a0;
        qreal a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QQuaternion, &a0, &a1))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion((*a0 / a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,div_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QQuaternion___add__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QQuaternion___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
        const QQuaternion * a0;
        const QQuaternion * a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QQuaternion, &a0, sipType_QQuaternion, &a1))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion((*a0 + *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,add_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QQuaternion___sub__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QQuaternion___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
        const QQuaternion * a0;
        const QQuaternion * a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QQuaternion, &a0, sipType_QQuaternion, &a1))
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion((*a0 - *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,sub_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QQuaternion___neg__(PyObject *sipSelf);}
static PyObject *slot_QQuaternion___neg__(PyObject *sipSelf)
{
    QQuaternion *sipCpp = reinterpret_cast<QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return 0;


    {
        {
            QQuaternion *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QQuaternion(-(*sipCpp));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,NULL);
        }
    }
}


extern "C" {static PyObject *slot_QQuaternion___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QQuaternion___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QQuaternion *sipCpp = reinterpret_cast<QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QQuaternion * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QQuaternion, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator!=((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,ne_slot,sipType_QQuaternion,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QQuaternion___idiv__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QQuaternion___idiv__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QQuaternion)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QQuaternion *sipCpp = reinterpret_cast<QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        qreal a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QQuaternion::operator/=(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QQuaternion___imul__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QQuaternion___imul__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QQuaternion)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QQuaternion *sipCpp = reinterpret_cast<QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        qreal a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QQuaternion::operator*=(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const QQuaternion * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QQuaternion, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QQuaternion::operator*=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QQuaternion___isub__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QQuaternion___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QQuaternion)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QQuaternion *sipCpp = reinterpret_cast<QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QQuaternion * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QQuaternion, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QQuaternion::operator-=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QQuaternion___iadd__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QQuaternion___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QQuaternion)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QQuaternion *sipCpp = reinterpret_cast<QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QQuaternion * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QQuaternion, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QQuaternion::operator+=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QQuaternion___repr__(PyObject *sipSelf);}
static PyObject *slot_QQuaternion___repr__(PyObject *sipSelf)
{
    QQuaternion *sipCpp = reinterpret_cast<QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 60 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qquaternion.sip"
        PyObject *scalar = PyFloat_FromDouble(sipCpp->scalar());
        PyObject *x = PyFloat_FromDouble(sipCpp->x());
        PyObject *y = PyFloat_FromDouble(sipCpp->y());
        PyObject *z = PyFloat_FromDouble(sipCpp->z());
        
        if (scalar && x && y && z)
        {
        #if PY_MAJOR_VERSION >= 3
            sipRes = PyUnicode_FromFormat("PyQt4.QtGui.QQuaternion(%R, %R, %R, %R)",
                    scalar, x, y, z);
        #else
            sipRes = PyString_FromString("PyQt4.QtGui.QQuaternion(");
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(scalar));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(x));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(y));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(z));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        #endif
        }
        
        Py_XDECREF(scalar);
        Py_XDECREF(x);
        Py_XDECREF(y);
        Py_XDECREF(z);
#line 1149 "sipQtGuiQQuaternion.cpp"

            return sipRes;
        }
    }
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QQuaternion(void *, const sipTypeDef *);}
static void *cast_QQuaternion(void *ptr, const sipTypeDef *targetType)
{
    if (targetType == sipType_QQuaternion)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QQuaternion(void *, int);}
static void release_QQuaternion(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QQuaternion *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QQuaternion(void *);}
static PyObject *pickle_QQuaternion(void *sipCppV)
{
    QQuaternion *sipCpp = reinterpret_cast<QQuaternion *>(sipCppV);
    PyObject *sipRes;

#line 49 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qquaternion.sip"
    sipRes = Py_BuildValue((char *)"dddd", sipCpp->scalar(), sipCpp->x(),
            sipCpp->y(), sipCpp->z());
#line 1189 "sipQtGuiQQuaternion.cpp"

    return sipRes;
}


extern "C" {static void assign_QQuaternion(void *, SIP_SSIZE_T, const void *);}
static void assign_QQuaternion(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast<QQuaternion *>(sipDst)[sipDstIdx] = *reinterpret_cast<const QQuaternion *>(sipSrc);
}


extern "C" {static void *array_QQuaternion(SIP_SSIZE_T);}
static void *array_QQuaternion(SIP_SSIZE_T sipNrElem)
{
    return new QQuaternion[sipNrElem];
}


extern "C" {static void *copy_QQuaternion(const void *, SIP_SSIZE_T);}
static void *copy_QQuaternion(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new QQuaternion(reinterpret_cast<const QQuaternion *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QQuaternion(sipSimpleWrapper *);}
static void dealloc_QQuaternion(sipSimpleWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QQuaternion(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QQuaternion(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_QQuaternion(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    QQuaternion *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QQuaternion();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        qreal a0;
        qreal a1;
        qreal a2;
        qreal a3;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "ffff", &a0, &a1, &a2, &a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QQuaternion(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        qreal a0;
        const QVector3D * a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "fJ9", &a0, sipType_QVector3D, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QQuaternion(a0,*a1);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QVector4D * a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_QVector4D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QQuaternion(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QQuaternion * a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_QQuaternion, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QQuaternion(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QQuaternion[] = {
    {(void *)slot_QQuaternion___eq__, eq_slot},
    {(void *)slot_QQuaternion___mul__, mul_slot},
    {(void *)slot_QQuaternion___div__, div_slot},
    {(void *)slot_QQuaternion___add__, add_slot},
    {(void *)slot_QQuaternion___sub__, sub_slot},
    {(void *)slot_QQuaternion___neg__, neg_slot},
    {(void *)slot_QQuaternion___ne__, ne_slot},
    {(void *)slot_QQuaternion___idiv__, idiv_slot},
    {(void *)slot_QQuaternion___imul__, imul_slot},
    {(void *)slot_QQuaternion___isub__, isub_slot},
    {(void *)slot_QQuaternion___iadd__, iadd_slot},
    {(void *)slot_QQuaternion___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QQuaternion[] = {
    {SIP_MLNAME_CAST(sipName_conjugate), meth_QQuaternion_conjugate, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_fromAxisAndAngle), meth_QQuaternion_fromAxisAndAngle, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_isIdentity), meth_QQuaternion_isIdentity, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_isNull), meth_QQuaternion_isNull, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_length), meth_QQuaternion_length, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_lengthSquared), meth_QQuaternion_lengthSquared, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_nlerp), meth_QQuaternion_nlerp, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_normalize), meth_QQuaternion_normalize, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_normalized), meth_QQuaternion_normalized, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_rotatedVector), meth_QQuaternion_rotatedVector, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_scalar), meth_QQuaternion_scalar, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setScalar), meth_QQuaternion_setScalar, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setVector), meth_QQuaternion_setVector, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setX), meth_QQuaternion_setX, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setY), meth_QQuaternion_setY, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setZ), meth_QQuaternion_setZ, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_slerp), meth_QQuaternion_slerp, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toVector4D), meth_QQuaternion_toVector4D, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_vector), meth_QQuaternion_vector, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_x), meth_QQuaternion_x, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_y), meth_QQuaternion_y, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_z), meth_QQuaternion_z, METH_VARARGS, NULL}
};


pyqt4ClassTypeDef sipTypeDef_QtGui_QQuaternion = {
{
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_QQuaternion,
        {0}
    },
    {
        sipNameNr_QQuaternion,
        {0, 0, 1},
        22, methods_QQuaternion,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    0,
    sipNameNr_PyQt4_QtCore_pyqtWrapperType,
    sipNameNr_sip_simplewrapper,
    0,
    slots_QQuaternion,
    init_QQuaternion,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_QQuaternion,
    assign_QQuaternion,
    array_QQuaternion,
    copy_QQuaternion,
    release_QQuaternion,
    cast_QQuaternion,
    0,
    0,
    pickle_QQuaternion
},
    0,
    0,
    0
};
