# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.40
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info
if version_info >= (3,0,0):
    new_instancemethod = lambda func, inst, cls: _Box2D.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Box2D', [dirname(__file__)])
        except ImportError:
            import _Box2D
            return _Box2D
        if fp is not None:
            try:
                _mod = imp.load_module('_Box2D', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _Box2D = swig_import_helper()
    del swig_import_helper
else:
    import _Box2D
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


def _swig_setattr_nondynamic_method(set):
    def set_attr(self,name,value):
        if (name == "thisown"): return self.this.own(value)
        if hasattr(self,name) or (name == "this"):
            set(self,name,value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


try:
    import weakref
    weakref_proxy = weakref.proxy
except:
    weakref_proxy = lambda x: x



def __b2PythonJointPointerEquals__(*args):
  return _Box2D.__b2PythonJointPointerEquals__(*args)
__b2PythonJointPointerEquals__ = _Box2D.__b2PythonJointPointerEquals__

def __b2PythonBodyPointerEquals__(*args):
  return _Box2D.__b2PythonBodyPointerEquals__(*args)
__b2PythonBodyPointerEquals__ = _Box2D.__b2PythonBodyPointerEquals__

def __b2PythonShapePointerEquals__(*args):
  return _Box2D.__b2PythonShapePointerEquals__(*args)
__b2PythonShapePointerEquals__ = _Box2D.__b2PythonShapePointerEquals__

def __b2PythonControllerPointerEquals__(*args):
  return _Box2D.__b2PythonControllerPointerEquals__(*args)
__b2PythonControllerPointerEquals__ = _Box2D.__b2PythonControllerPointerEquals__
class b2PickleError (Exception): pass

def _pickle_fix_value_load(lists, value):
    """
    Returns the appropriate object (a b2Body, b2Shape, b2Joint, b2Controller)
    based on the indices in the passed-in dictionary.
    """
    bodyList, jointList, controllerList=lists
    
    if not isinstance(value, dict):
        return value
    elif 'pickle_type' not in value:
        return value

    # Depending on the type, use the right list
    if value['pickle_type']=='b2Body':
        return bodyList[ value['body'] ]

    elif value['pickle_type']=='b2Shape':
        body  = bodyList[ value['body'] ]
        shape = body.shapeList[ value['shape'] ]
        return shape

    elif value['pickle_type']=='b2Joint':
        return jointList[ value['joint'] ]

    elif value['pickle_type']=='b2Controller':
        return controllerList[ value['controller'] ]

    return value

def _pickle_fix_value_save(lists, value):
    """
    Fixes: b2Body, b2Shape, b2Joint, b2Controller

    In place of an unpicklable b2Body outside of a world, use a dictionary with
    an index to the appropriate place in the world.
    """
    bodyList, jointList, controllerList=lists

    if isinstance(value, b2Body):
        value = { 'pickle_type' : 'b2Body', 'body' : bodyList.index(value) }
    elif isinstance(value, b2Shape):
        body = value.GetBody()
        shapeID = body.shapeList.index(value)
        value = { 'pickle_type' : 'b2Shape', 'body': bodyList.index(body), 'shape' : shapeID}
    elif isinstance(value, b2Joint):
        value = { 'pickle_type' : 'b2Joint',  'joint': jointList.index(value) }
    elif isinstance(value, b2Controller):
        value = { 'pickle_type' : 'b2Controller', 'controller' : controllerList.index(value)}

    return value

def pickle_fix(world, var, func='save', lists=None):
    """
    Fix variables so that they may be pickled (or loaded from a pickled state).
    You cannot save a b2Body by itself, but if passed in with the world, it's possible
    to pickle it.

    So, be sure to use this on your box2d-related variables before and after pickling.

    e.g.,
    + Save:
      my_pickled_vars = box2d.pickle_fix(myworld, my_vars, 'save')
      pickle.dump([myworld, my_pickled_vars], open(fn, 'wb'))

    + Load
      world, my_pickled_vars = pickle.load(open(fn, 'rb'))
      myworld = world._pickle_finalize()
      my_vars=box2d.pickle_fix(myworld, my_pickled_vars, 'load')

    For an actual implementation of pickling, see the testbed (main test and test_pickle).
    """
    if func=='save':
        fix_function=_pickle_fix_value_save
    elif func=='load':
        fix_function=_pickle_fix_value_load
    else:
        raise ValueError('Expected func in ("save", "load")')

    if not lists:
        # these lists are all created dynamically, so do this once
        lists=[world.bodyList, world.jointList, world.controllerList]

    if isinstance(var, (list, tuple)):
        # Create a new list/tuple and fix each item
        new_list=[pickle_fix(world, value, func, lists) for value in var]
        if isinstance(var, tuple):
            # If it was originally a tuple, make this new list a tuple
            new_list=tuple(new_list)
        return new_list
    elif isinstance(var, dict):
        if func=='load' and 'pickle_type' in var:
            # Loading a dictionary placeholder for an object
            return fix_function(lists, var)

        # Create a new dictionary and fix each item
        new_dict={}
        for var, value in list(var.items()):
            new_dict[var]=pickle_fix(world, value, func, lists)
        return new_dict
    else:
        # Not a dictionary/list, so it is probably just a normal value. 
        # Fix and return it.
        ret= fix_function(lists, var)
        return ret

# -- unpicklable object --
def no_pickle(self):
    raise b2PickleError('Cannot pickle this object. Pickle the typecasted object: object.getAsType()')

# -- generic get and set state --
def _generic_setstate(self, dict):
    """
    Takes each variable=value pair in the dictionary and
    sets the attributes based on them
    """
    self.__init__()
    for key, value in dict.items():
        setattr(self, key, value)

def _generic_getstate(self, additional_ignore=[]):
    """
    Returns a dictionary representation of self, with 
     dict(var=value [, ...])

    additional_ignore can be specified to ignore certain
    properties. 
    """
    ignore_properties = ['thisown', 'this', 'next', 'prev', 
                         'world', 'coreVertices', 'normals']
    if additional_ignore:
        ignore_properties += additional_ignore

    vars = [v for v in dir(self.__class__) 
        if isinstance(getattr(self.__class__, v), property) 
            and v not in ignore_properties]
    return dict((var, getattr(self, var)) for var in vars)

# -- factory output -- (i.e., b2Body, 
def _pickle_factory_set(self, data):
    """
    The factory output cannot be created just yet,
    so store the necessary information to create it later.
    """
    self.__pickle_data__ = data

# -- factory output finalizing (loading)
def _pickle_finalize(self, world=None, body=None):
    """
    Finalize one of the outputs that we previously set as a 
    dictionary.
    """
    if not hasattr(self, '__pickle_data__'):
        raise b2PickleError("Invalid object passed to _pickle_finalize")

    # At this point, 'self' is invalid on the SWIG-end of things.
    # __init__ has not been called, so it only exists on the Python-end.

    # The previously saved-data
    data = self.__pickle_data__
    
    # These types are what are passed in:
    #                 create_function          output          input
    pairs = [ (lambda w,b,v: w.CreateBody(v) , b2Body        , b2BodyDef),
              (lambda w,b,v: b.CreateShape(v), b2PolygonShape, b2PolygonDef),
              (lambda w,b,v: b.CreateShape(v), b2CircleShape , b2CircleDef),
              (lambda w,b,v: b.CreateShape(v), b2EdgeChainDef, b2EdgeChainDef),
            ]
    
    createfcn = None

    # Create a new instance of the definition so that it may re-create
    # the object.
    for fcn, output, input in pairs:
        if isinstance(self, output):
            self = eval(input())
            createfcn=fcn
            break

    if not createfcn:
        raise b2PickleError("Invalid object passed to _pickle_finalize")

    # A few things exist that cannot be set in the definition and can only
    # be set after the object is created. Check for these and then set them
    # after if necessary.
    do_after_classes=(b2Body, b2Shape, list)
    do_after_props  =['linearVelocity', 'angularVelocity', 'isSleeping']
    finalize_after = []
    
    if isinstance(self, (b2PolygonDef, b2EdgeChainDef)):
        # Polygon/edge shape. Set their vertices first, as normally they would
        # be put in the 'do after' section
        self.vertices = data['vertices']
        del data['vertices']

    for var in data:
        value = data[var]
        if isinstance(value, do_after_classes) or var in do_after_props:
            # Set these after creation
            finalize_after.append( (var, value) )
        elif hasattr(self, var):
            setattr(self, var, value)

    # Create the actual object (not just the definition)
    self = createfcn(world, body, self)

    # If we just created a body, set that for the upcoming recursion.
    # Finalizing the shape will require that this be set.
    if isinstance(self, b2Body):
        body = self

    for var, value in finalize_after:
        if var == 'shapeList':
            # A shapelist is a special case, do it separately
            _pickle_finalize_shapelist(world, body, value)
        elif var == 'isSleeping':
            # Sleeping is only modifiable by functions, and as such is a special case
            if value:
                self.PutToSleep()
            else:
                self.WakeUp()
        elif hasattr(self, var):
            # The attribute exists, so set it.
            if hasattr(value, '_pickle_finalize'):
                # But first finalize it if necessary.
                value=_pickle_finalize(value,world,body)
            setattr(self, var, value)

    return self

# -- custom handlers --
def _pickle_finalize_controller(data, world):
    """
    Finalize a controller. It's mostly standard, just
    requires a custom bodyList.
    """
    defn = globals()["b2%sControllerDef" % data['_type']] ()

    bodyList  = world.bodyList
    for var in data:
        value = data[var]
        if hasattr(defn, var):
            setattr(defn, var, value)

    # Create the controller
    controller = world.CreateController(defn)

    # And now add the bodies to it
    for body in data['bodyList']:
        try:
            real_body = bodyList[ int(body) ]
        except:
            raise b2PickleError('World not initialized properly; unable to create controller')
        controller.AddBody(real_body)

    return controller

def _pickle_finalize_joint(data, world):
    """
    Finalize a joint.
    The bodies and joints need to be retrieved from the world list
    in order to make the joint.
    """

    defn = globals()["b2%sJointDef" % data['_type']] ()

    body_names  = ['body1' , 'body2' ]
    joint_names = ['joint1', 'joint2']

    bodyList  = world.bodyList
    jointList = world.jointList

    for var in data:
        value = data[var]

        if var=='localXAxis1': 
            var = 'localAxis1' # single rename necessary

        if not hasattr(defn, var):
            continue

        if var in body_names:
            # Set the body based on the global body list
            try:
                value = bodyList[ int(value) ]
            except:
                raise b2PickleError('World not initialized properly; unable to create joint')
        elif var in joint_names:
            # Set the joint based on the global joint list
            try:
                value = jointList[ int(value) ]
            except:
                raise b2PickleError('World not initialized properly; unable to create joint')

        # Set the value
        setattr(defn, var, value)

    return world.CreateJoint(defn)

def _pickle_finalize_shapelist(world, body, shapelist):
    """
    Finalize the shape list for a body.
    Only reason this has to be implemented separately is because of the
    way edge chains are implemented.
    """
    for s in shapelist:
        if isinstance(s, dict):
            # Special case, an edge shape. pickled as a
            # dictionary. Create a fake definition and finalize it.
            temp=b2EdgeChainDef()
            temp.__pickle_data__=s
            _pickle_finalize(temp, world, body)
        else:
            s._pickle_finalize(world, body)

def _pickle_finalize_world(self):
    """
    Finalize a b2World.
    """
    if not hasattr(self, '__pickle_data__'):
        raise b2PickleError('Finalizing a world that was not loaded?')

    data = self.__pickle_data__
    
    # Create the world. Only 3 parameters to deal with.
    world = b2World(data['worldAABB'], data['gravity'], data['doSleep'])

    # First, deal with the ground body. It cannot be taken care of as a
    # normal body since we do not create it; the constructor of the world
    # on the C++-side creates it.
    gb_data = data['groundBody'].__pickle_data__

    # Finalize its shapelist
    _pickle_finalize_shapelist(world, world.groundBody, gb_data['shapeList'])

    # And then go through each variable, setting the properties
    for var in list(gb_data.keys()):
        value = gb_data[var]
        if isinstance(value, (b2Shape)) or var=='shapeList':
            pass
        elif hasattr(world.groundBody, var):
            try:
                setattr(world.groundBody, var, value)
            except AttributeError:
                pass

    # Finalize each body
    for body in data['bodyList']:
        body._pickle_finalize(world)

    # Finalize each joint
    for joint in data['jointList']:
        _pickle_finalize_joint(joint, world)

    # Finalize each controller
    for controller in data['controllerList']:
        _pickle_finalize_controller(controller, world)

    # And that is it. :)
    return world

def _pickle_body_getstate(self):
    """
    Everything is essentially generic_getstate,
     except for edge shape handling.

    TODO: I can see a possible issue in this if joints are used on
    an edge shape or a body with edge shapes and other shapes.
    The shape list order could be improperly recreated. We'll see
    if anything happens...
    """

    def get_edge_vertices_and_shapes(shape):
        """
        Determine whether or not the edge is a loop.
        Also, return each shape that this passes through.
        Then return the vertices.

        Returns is_loop, shapes, vertices
        """

        vertices = []
        shapes   = []
        edge     = shape
        while edge:
            shapes.append(edge)
            vertices.append( edge.vertex1 )
            last=edge.vertex2

            # Go to the next edge
            edge=edge.next
            if edge==shape: # A loop
                return True, shapes, vertices

        # Not a loop
        vertices.append( last )
        return False, shapes, vertices
        
    # Get all the basic attributes except for shapeList
    ret = _generic_getstate(self, ['shapeList'])
    
    # Now check each shape in the list
    ret['shapeList']=[]
    handled_edges = []
    for shape in self.shapeList:
        if isinstance(shape, b2EdgeShape):
            if shape in handled_edges:
                # This edge was already added from another one
                # because they were linked together.
                continue

            is_loop, shapes, vertices=get_edge_vertices_and_shapes(shape)
            handled_edges.extend(shapes)

            # Create a dictionary for this edge shape
            # (to be finalized in _pickle_finalize_shapelist when loaded)
            shape_info = _generic_getstate(shape, ['vertices','length','coreVertex1','coreVertex2'])
            shape_info['isALoop'] =is_loop
            shape_info['vertices']=vertices
            ret['shapeList'].append(shape_info)
        else:
            # Regular shapes need no extra processing
            ret['shapeList'].append(shape)
    return ret

def _pickle_get_b2world(self):
    """
    Get the state of the world.
    """

    # The basic properties first
    vars = ['worldAABB', 'gravity', 'doSleep', 'groundBody']
    data=dict((var, getattr(self, var)) for var in vars)

    # Now the body list (excepting the ground body)
    data['bodyList']=self.bodyList[1:]

    # Add all joints, ensuring to downcast to the appropriate type
    jointList = []
    for joint in self.jointList:
        joint=joint.getAsType()
        jointList.append( joint.__getstate__(self) )
    data['jointList']=jointList

    # Add all controllers, ensuring to downcast to the appropriate type
    controllerList = []
    for controller in self.controllerList:
        controller=controller.getAsType()
        controllerList.append( controller.__getstate__(self) )
    data['controllerList']=controllerList

    return data

def _pickle_get_controller(self, world=None):
    """
    Get the state of a controller
    """
    if not world:
        raise b2PickleError("Controllers can't be saved without the world itself")

    ignore_prop =['thisown', 'this', 'bodyList']
    defn = globals()[ "%sDef" % self.__class__.__name__ ]

    # Take the available variables in the _definition_
    # and then create a dictionary
    vars = [v for v in dir(defn) 
        if isinstance(getattr(defn, v), property) 
            and v not in ignore_prop]

    ret=dict((var, getattr(self, var)) for var in vars)

    # Set the type, so we know how to recreate it
    ret['_type'] = self.typeName()

    # Then use indices into the world body list to store 
    # the bodies controlled by this controller
    main_bodyList = world.bodyList
    ctrl_bodyList = self.bodyList
    ret['bodyList']=[main_bodyList.index(body) for body in ctrl_bodyList]
    return ret

def _pickle_get_joint(self, world=None):
    """
    Get the state of a joint.
    """
    if not world:
        raise b2PickleError("Joints can't be saved without the world itself")

    # Take the available variables in the _definition_
    # and then create a dictionary
    ignore_prop =['thisown', 'this', 'world', 'type']
    defn = globals()[ "%sDef" % self.__class__.__name__ ]
    vars = [v for v in dir(defn) 
        if isinstance(getattr(defn, v), property) 
            and v not in ignore_prop]

    # A single rename is necessary. If localAxis1 (definition) exists,
    # rename it to localXAxis1 (joint)
    if 'localAxis1' in vars: # prismatic, line joints
        vars.remove('localAxis1')
        vars.append('localXAxis1')

    ret=dict((var, getattr(self, var)) for var in vars)
    ret['_type'] = self.typeName()

    # Recreate the body/joint lists.
    bodyList = world.bodyList
    jointList= world.jointList
    for key, value in ret.items():
        if isinstance(value, b2Body):
            ret[key]=bodyList.index(value)
        elif isinstance(value, b2Joint):
            ret[key]=jointList.index(value)

    return ret


def b2ShapeCompare(a, b):
    if not isinstance(a, b2Shape) or not isinstance(b, b2Shape):
        return False
    return __b2PythonShapePointerEquals__(a, b)
def b2BodyCompare(a, b):
    if not isinstance(a, b2Body) or not isinstance(b, b2Body):
        return False
    return __b2PythonBodyPointerEquals__(a, b)
def b2JointCompare(a, b):
    if not isinstance(a, b2Joint) or not isinstance(b, b2Joint):
        return False
    return __b2PythonJointPointerEquals__(a, b)
def b2ControllerCompare(a, b):
    if not isinstance(a, b2Controller) or not isinstance(b, b2Controller):
        return False
    return __b2PythonControllerPointerEquals__(a, b)


def b2Alloc(*args):
  """
    b2Alloc(int32 size) -> void

    Implement this function to use your own memory allocator.
    """
  return _Box2D.b2Alloc(*args)

def b2Free(*args):
  """
    b2Free(void mem)

    If you implement b2Alloc, you should also implement this function.
    """
  return _Box2D.b2Free(*args)
class b2Version(object):
    """Version numbering scheme. See http://en.wikipedia.org/wiki/Software_versioning"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    major = _swig_property(_Box2D.b2Version_major_get, _Box2D.b2Version_major_set)
    minor = _swig_property(_Box2D.b2Version_minor_get, _Box2D.b2Version_minor_set)
    revision = _swig_property(_Box2D.b2Version_revision_get, _Box2D.b2Version_revision_set)
    def __repr__(self):
     return """b2Version(
       major    = %s,
       minor    = %s,
       revision = %s)"""% tuple(str(a) for a in\
      (self.major,self.minor,self.revision))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2Version"""
        _Box2D.b2Version_swiginit(self,_Box2D.new_b2Version())
    __swig_destroy__ = _Box2D.delete_b2Version
b2Version_swigregister = _Box2D.b2Version_swigregister
b2Version_swigregister(b2Version)
cvar = _Box2D.cvar
b2_pi = cvar.b2_pi
b2_maxManifoldPoints = cvar.b2_maxManifoldPoints
b2_maxPolygonVertices = cvar.b2_maxPolygonVertices
b2_maxProxies = cvar.b2_maxProxies
b2_maxPairs = cvar.b2_maxPairs
b2_linearSlop = cvar.b2_linearSlop
b2_angularSlop = cvar.b2_angularSlop
b2_toiSlop = cvar.b2_toiSlop
b2_maxTOIContactsPerIsland = cvar.b2_maxTOIContactsPerIsland
b2_maxTOIJointsPerIsland = cvar.b2_maxTOIJointsPerIsland
b2_velocityThreshold = cvar.b2_velocityThreshold
b2_maxLinearCorrection = cvar.b2_maxLinearCorrection
b2_maxAngularCorrection = cvar.b2_maxAngularCorrection
b2_maxLinearVelocity = cvar.b2_maxLinearVelocity
b2_maxLinearVelocitySquared = cvar.b2_maxLinearVelocitySquared
b2_maxAngularVelocity = cvar.b2_maxAngularVelocity
b2_maxAngularVelocitySquared = cvar.b2_maxAngularVelocitySquared
b2_contactBaumgarte = cvar.b2_contactBaumgarte
b2_timeToSleep = cvar.b2_timeToSleep
b2_linearSleepTolerance = cvar.b2_linearSleepTolerance
b2_angularSleepTolerance = cvar.b2_angularSleepTolerance


def b2MixFriction(*args):
  """
    b2MixFriction(float32 friction1, float32 friction2) -> float32

    Friction mixing law. Feel free to customize this.
    """
  return _Box2D.b2MixFriction(*args)

def b2MixRestitution(*args):
  """
    b2MixRestitution(float32 restitution1, float32 restitution2) -> float32

    Restitution mixing law. Feel free to customize this.
    """
  return _Box2D.b2MixRestitution(*args)

def b2IsValid(*args):
  """
    b2IsValid(float32 x) -> bool

    This function is used to ensure that a floating point number is not a NaN or infinity.
    """
  return _Box2D.b2IsValid(*args)

def b2InvSqrt(*args):
  """
    b2InvSqrt(float32 x) -> float32

    This is a approximate yet fast inverse square-root.
    """
  return _Box2D.b2InvSqrt(*args)
class b2Vec2(object):
    """A 2D column vector."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def SetZero(self):
        """
        SetZero(self)

        Set this vector to all zeros.
        """
        return _Box2D.b2Vec2_SetZero(self)

    def Set(self, *args):
        """
        Set(self, float32 x_, float32 y_)

        Set this vector to some specified coordinates.
        """
        return _Box2D.b2Vec2_Set(self, *args)

    def __neg__(self):
        """__neg__(self) -> b2Vec2"""
        return _Box2D.b2Vec2___neg__(self)

    def add_vector(self, *args):
        """add_vector(self, b2Vec2 v)"""
        return _Box2D.b2Vec2_add_vector(self, *args)

    def sub_vector(self, *args):
        """sub_vector(self, b2Vec2 v)"""
        return _Box2D.b2Vec2_sub_vector(self, *args)

    def mul_float(self, *args):
        """mul_float(self, float32 a)"""
        return _Box2D.b2Vec2_mul_float(self, *args)

    def Length(self):
        """
        Length(self) -> float32

        Get the length of this vector (the norm).
        """
        return _Box2D.b2Vec2_Length(self)

    def LengthSquared(self):
        """
        LengthSquared(self) -> float32

        Get the length squared. For performance, use this instead of  b2Vec2::Length(if possible).
        """
        return _Box2D.b2Vec2_LengthSquared(self)

    def Normalize(self):
        """
        Normalize(self) -> float32

        Convert this vector into a unit vector. Returns the length.
        """
        return _Box2D.b2Vec2_Normalize(self)

    def IsValid(self):
        """
        IsValid(self) -> bool

        Does this vector contain finite coordinates?
        """
        return _Box2D.b2Vec2_IsValid(self)

    x = _swig_property(_Box2D.b2Vec2_x_get, _Box2D.b2Vec2_x_set)
    y = _swig_property(_Box2D.b2Vec2_y_get, _Box2D.b2Vec2_y_set)
    def __repr__(self):
     return """b2Vec2(
       x         = %s,
       y         = %s,
       IsValid() = %s)"""% tuple(str(a) for a in\
      (self.x,self.y,self.IsValid()))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self, *args): 
        """
        __init__(self) -> b2Vec2
        __init__(self, float32 x, float32 y) -> b2Vec2
        __init__(self, b2Vec2 other) -> b2Vec2

        Construct using coordinates.
        """
        _Box2D.b2Vec2_swiginit(self,_Box2D.new_b2Vec2(*args))
    __iter__ = lambda self: iter( (self.x, self.y) )
    def __repr__(self):
        return "b2Vec2(%g,%g)" % (self.x, self.y)
    def tuple(self):
        """
        Return the vector as a tuple (x,y)
        """
        return tuple(self)
    def fromTuple(self, tuple):
        """
        *DEPRECATED*
        Set the vector to the values found in the tuple (x,y)
        You should use:
            value = b2Vec2(*tuple)
        """
        self.x, self.y = tuple
        return self
    def copy(self):
        """
        Return a copy of the vector.
        Remember that the following:
            a = b2Vec2()
            b = a
        Does not copy the vector itself, but b now refers to a.
        """
        return b2Vec2(self.x, self.y)
    def __iadd__(self, other):
        self.add_vector(other)
        return self
    def __isub__(self, other):
        self.sub_vector(other)
        return self
    def __imul__(self, a):
        self.mul_float(a)
        return self
    def __idiv__(self, a):
        self.div_float(a)
        return self
    def dot(self, v):
        """
        Dot product with v (list/tuple or b2Vec2)
        """
        if isinstance(v, (list, tuple)):
            return self.x*v[0] + self.y*v[1]
        else:
            return self.x*v.x + self.y*v.y


    def __div__(self, *args):
        """__div__(self, float32 a) -> b2Vec2"""
        return _Box2D.b2Vec2___div__(self, *args)

    def __mul__(self, *args):
        """__mul__(self, float32 a) -> b2Vec2"""
        return _Box2D.b2Vec2___mul__(self, *args)

    def __add__(self, *args):
        """__add__(self, b2Vec2 other) -> b2Vec2"""
        return _Box2D.b2Vec2___add__(self, *args)

    def __sub__(self, *args):
        """__sub__(self, b2Vec2 other) -> b2Vec2"""
        return _Box2D.b2Vec2___sub__(self, *args)

    def __rmul__(self, *args):
        """__rmul__(self, float32 a) -> b2Vec2"""
        return _Box2D.b2Vec2___rmul__(self, *args)

    def __rdiv__(self, *args):
        """__rdiv__(self, float32 a) -> b2Vec2"""
        return _Box2D.b2Vec2___rdiv__(self, *args)

    def div_float(self, *args):
        """div_float(self, float32 a)"""
        return _Box2D.b2Vec2_div_float(self, *args)

    __swig_destroy__ = _Box2D.delete_b2Vec2
b2Vec2.SetZero = new_instancemethod(_Box2D.b2Vec2_SetZero,None,b2Vec2)
b2Vec2.Set = new_instancemethod(_Box2D.b2Vec2_Set,None,b2Vec2)
b2Vec2.__neg__ = new_instancemethod(_Box2D.b2Vec2___neg__,None,b2Vec2)
b2Vec2.add_vector = new_instancemethod(_Box2D.b2Vec2_add_vector,None,b2Vec2)
b2Vec2.sub_vector = new_instancemethod(_Box2D.b2Vec2_sub_vector,None,b2Vec2)
b2Vec2.mul_float = new_instancemethod(_Box2D.b2Vec2_mul_float,None,b2Vec2)
b2Vec2.Length = new_instancemethod(_Box2D.b2Vec2_Length,None,b2Vec2)
b2Vec2.LengthSquared = new_instancemethod(_Box2D.b2Vec2_LengthSquared,None,b2Vec2)
b2Vec2.Normalize = new_instancemethod(_Box2D.b2Vec2_Normalize,None,b2Vec2)
b2Vec2.IsValid = new_instancemethod(_Box2D.b2Vec2_IsValid,None,b2Vec2)
b2Vec2.__div__ = new_instancemethod(_Box2D.b2Vec2___div__,None,b2Vec2)
b2Vec2.__mul__ = new_instancemethod(_Box2D.b2Vec2___mul__,None,b2Vec2)
b2Vec2.__add__ = new_instancemethod(_Box2D.b2Vec2___add__,None,b2Vec2)
b2Vec2.__sub__ = new_instancemethod(_Box2D.b2Vec2___sub__,None,b2Vec2)
b2Vec2.__rmul__ = new_instancemethod(_Box2D.b2Vec2___rmul__,None,b2Vec2)
b2Vec2.__rdiv__ = new_instancemethod(_Box2D.b2Vec2___rdiv__,None,b2Vec2)
b2Vec2.div_float = new_instancemethod(_Box2D.b2Vec2_div_float,None,b2Vec2)
b2Vec2_swigregister = _Box2D.b2Vec2_swigregister
b2Vec2_swigregister(b2Vec2)

class b2Vec3(object):
    """A 2D column vector with 3 elements."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> b2Vec3
        __init__(self, float32 x, float32 y, float32 z) -> b2Vec3

        Construct using coordinates.
        """
        _Box2D.b2Vec3_swiginit(self,_Box2D.new_b2Vec3(*args))
    def SetZero(self):
        """
        SetZero(self)

        Set this vector to all zeros.
        """
        return _Box2D.b2Vec3_SetZero(self)

    def Set(self, *args):
        """
        Set(self, float32 x_, float32 y_, float32 z_)

        Set this vector to some specified coordinates.
        """
        return _Box2D.b2Vec3_Set(self, *args)

    def __neg__(self):
        """__neg__(self) -> b2Vec3"""
        return _Box2D.b2Vec3___neg__(self)

    def __iadd__(self, *args):
        """__iadd__(self, b2Vec3 v)"""
        return _Box2D.b2Vec3___iadd__(self, *args)

    def __isub__(self, *args):
        """__isub__(self, b2Vec3 v)"""
        return _Box2D.b2Vec3___isub__(self, *args)

    def __imul__(self, *args):
        """__imul__(self, float32 s)"""
        return _Box2D.b2Vec3___imul__(self, *args)

    x = _swig_property(_Box2D.b2Vec3_x_get, _Box2D.b2Vec3_x_set)
    y = _swig_property(_Box2D.b2Vec3_y_get, _Box2D.b2Vec3_y_set)
    z = _swig_property(_Box2D.b2Vec3_z_get, _Box2D.b2Vec3_z_set)
    def __repr__(self):
     return """b2Vec3(
       x = %s,
       y = %s,
       z = %s)"""% tuple(str(a) for a in\
      (self.x,self.y,self.z))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2Vec3
b2Vec3.SetZero = new_instancemethod(_Box2D.b2Vec3_SetZero,None,b2Vec3)
b2Vec3.Set = new_instancemethod(_Box2D.b2Vec3_Set,None,b2Vec3)
b2Vec3.__neg__ = new_instancemethod(_Box2D.b2Vec3___neg__,None,b2Vec3)
b2Vec3.__iadd__ = new_instancemethod(_Box2D.b2Vec3___iadd__,None,b2Vec3)
b2Vec3.__isub__ = new_instancemethod(_Box2D.b2Vec3___isub__,None,b2Vec3)
b2Vec3.__imul__ = new_instancemethod(_Box2D.b2Vec3___imul__,None,b2Vec3)
b2Vec3_swigregister = _Box2D.b2Vec3_swigregister
b2Vec3_swigregister(b2Vec3)

class b2Mat22(object):
    """A 2-by-2 matrix. Stored in column-major order."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> b2Mat22
        __init__(self, b2Vec2 c1, b2Vec2 c2) -> b2Mat22
        __init__(self, float32 a11, float32 a12, float32 a21, float32 a22) -> b2Mat22
        __init__(self, float32 angle) -> b2Mat22

        Construct this matrix using an angle. This matrix becomes an orthonormal rotation matrix.
        """
        _Box2D.b2Mat22_swiginit(self,_Box2D.new_b2Mat22(*args))
    def Set(self, *args):
        """
        Set(self, b2Vec2 c1, b2Vec2 c2)
        Set(self, float32 angle)

        Initialize this matrix using an angle. This matrix becomes an orthonormal rotation matrix.
        """
        return _Box2D.b2Mat22_Set(self, *args)

    def SetIdentity(self):
        """
        SetIdentity(self)

        Set this to the identity matrix.
        """
        return _Box2D.b2Mat22_SetIdentity(self)

    def SetZero(self):
        """
        SetZero(self)

        Set this matrix to all zeros.
        """
        return _Box2D.b2Mat22_SetZero(self)

    def GetAngle(self):
        """
        GetAngle(self) -> float32

        Extract the angle from this matrix (assumed to be a rotation matrix).
        """
        return _Box2D.b2Mat22_GetAngle(self)

    def GetInverse(self):
        """GetInverse(self) -> b2Mat22"""
        return _Box2D.b2Mat22_GetInverse(self)

    def Solve(self, *args):
        """
        Solve(self, b2Vec2 b) -> b2Vec2

        Solve A * x = b, where b is a column vector. This is more efficient than computing the inverse in one-shot cases.
        """
        return _Box2D.b2Mat22_Solve(self, *args)

    col1 = _swig_property(_Box2D.b2Mat22_col1_get, _Box2D.b2Mat22_col1_set)
    col2 = _swig_property(_Box2D.b2Mat22_col2_get, _Box2D.b2Mat22_col2_set)
    def __repr__(self):
     return """b2Mat22(
       col1       = %s,
       col2       = %s,
       GetAngle() = %s)"""% tuple(str(a) for a in\
      (self.col1,self.col2,self.GetAngle()))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2Mat22
b2Mat22.Set = new_instancemethod(_Box2D.b2Mat22_Set,None,b2Mat22)
b2Mat22.SetIdentity = new_instancemethod(_Box2D.b2Mat22_SetIdentity,None,b2Mat22)
b2Mat22.SetZero = new_instancemethod(_Box2D.b2Mat22_SetZero,None,b2Mat22)
b2Mat22.GetAngle = new_instancemethod(_Box2D.b2Mat22_GetAngle,None,b2Mat22)
b2Mat22.GetInverse = new_instancemethod(_Box2D.b2Mat22_GetInverse,None,b2Mat22)
b2Mat22.Solve = new_instancemethod(_Box2D.b2Mat22_Solve,None,b2Mat22)
b2Mat22_swigregister = _Box2D.b2Mat22_swigregister
b2Mat22_swigregister(b2Mat22)

class b2Mat33(object):
    """A 3-by-3 matrix. Stored in column-major order."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> b2Mat33
        __init__(self, b2Vec3 c1, b2Vec3 c2, b2Vec3 c3) -> b2Mat33

        Construct this matrix using columns.
        """
        _Box2D.b2Mat33_swiginit(self,_Box2D.new_b2Mat33(*args))
    def SetZero(self):
        """
        SetZero(self)

        Set this matrix to all zeros.
        """
        return _Box2D.b2Mat33_SetZero(self)

    def Solve33(self, *args):
        """
        Solve33(self, b2Vec3 b) -> b2Vec3

        Solve A * x = b, where b is a column vector. This is more efficient than computing the inverse in one-shot cases.

        Solve A * x = b, where b is a column vector. This is more efficient than computing the inverse in one-shot cases.
        """
        return _Box2D.b2Mat33_Solve33(self, *args)

    def Solve22(self, *args):
        """
        Solve22(self, b2Vec2 b) -> b2Vec2

        Solve A * x = b, where b is a column vector. This is more efficient than computing the inverse in one-shot cases. Solve only the upper 2-by-2 matrix equation.

        Solve A * x = b, where b is a column vector. This is more efficient than computing the inverse in one-shot cases.
        """
        return _Box2D.b2Mat33_Solve22(self, *args)

    col1 = _swig_property(_Box2D.b2Mat33_col1_get, _Box2D.b2Mat33_col1_set)
    col2 = _swig_property(_Box2D.b2Mat33_col2_get, _Box2D.b2Mat33_col2_set)
    col3 = _swig_property(_Box2D.b2Mat33_col3_get, _Box2D.b2Mat33_col3_set)
    def __repr__(self):
     return """b2Mat33(
       col1 = %s,
       col2 = %s,
       col3 = %s)"""% tuple(str(a) for a in\
      (self.col1,self.col2,self.col3))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2Mat33
b2Mat33.SetZero = new_instancemethod(_Box2D.b2Mat33_SetZero,None,b2Mat33)
b2Mat33.Solve33 = new_instancemethod(_Box2D.b2Mat33_Solve33,None,b2Mat33)
b2Mat33.Solve22 = new_instancemethod(_Box2D.b2Mat33_Solve22,None,b2Mat33)
b2Mat33_swigregister = _Box2D.b2Mat33_swigregister
b2Mat33_swigregister(b2Mat33)

class b2XForm(object):
    """A transform contains translation and rotation. It is used to represent the position and orientation of rigid frames."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> b2XForm
        __init__(self, b2Vec2 position, b2Mat22 R) -> b2XForm

        Initialize using a position vector and a rotation matrix.
        """
        _Box2D.b2XForm_swiginit(self,_Box2D.new_b2XForm(*args))
    def SetIdentity(self):
        """
        SetIdentity(self)

        Set this to the identity transform.
        """
        return _Box2D.b2XForm_SetIdentity(self)

    position = _swig_property(_Box2D.b2XForm_position_get, _Box2D.b2XForm_position_set)
    R = _swig_property(_Box2D.b2XForm_R_get, _Box2D.b2XForm_R_set)
    def __repr__(self):
     return """b2XForm(
       R        = %s,
       position = %s)"""% tuple(str(a) for a in\
      (self.R,self.position))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2XForm
b2XForm.SetIdentity = new_instancemethod(_Box2D.b2XForm_SetIdentity,None,b2XForm)
b2XForm_swigregister = _Box2D.b2XForm_swigregister
b2XForm_swigregister(b2XForm)

class b2Sweep(object):
    """This describes the motion of a body/shape for TOI computation. Shapes are defined with respect to the body origin, which may no coincide with the center of mass. However, to support dynamics we must interpolate the center of mass position."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def GetXForm(self, *args):
        """
        GetXForm(self, b2XForm xf, float32 t)

        Get the interpolated transform at a specific time.

        Parameters:
        -----------

        t: the normalized time in [0,1].
        """
        return _Box2D.b2Sweep_GetXForm(self, *args)

    def Advance(self, *args):
        """
        Advance(self, float32 t)

        Advance the sweep forward, yielding a new initial state.

        Parameters:
        -----------

        t: the new initial time.
        """
        return _Box2D.b2Sweep_Advance(self, *args)

    localCenter = _swig_property(_Box2D.b2Sweep_localCenter_get, _Box2D.b2Sweep_localCenter_set)
    c0 = _swig_property(_Box2D.b2Sweep_c0_get, _Box2D.b2Sweep_c0_set)
    c = _swig_property(_Box2D.b2Sweep_c_get, _Box2D.b2Sweep_c_set)
    a0 = _swig_property(_Box2D.b2Sweep_a0_get, _Box2D.b2Sweep_a0_set)
    a = _swig_property(_Box2D.b2Sweep_a_get, _Box2D.b2Sweep_a_set)
    t0 = _swig_property(_Box2D.b2Sweep_t0_get, _Box2D.b2Sweep_t0_set)
    def __repr__(self):
     return """b2Sweep(
       a           = %s,
       a0          = %s,
       c           = %s,
       c0          = %s,
       localCenter = %s,
       t0          = %s)"""% tuple(str(a) for a in\
      (self.a,self.a0,self.c,self.c0,self.localCenter,self.t0))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2Sweep"""
        _Box2D.b2Sweep_swiginit(self,_Box2D.new_b2Sweep())
    __swig_destroy__ = _Box2D.delete_b2Sweep
b2Sweep.GetXForm = new_instancemethod(_Box2D.b2Sweep_GetXForm,None,b2Sweep)
b2Sweep.Advance = new_instancemethod(_Box2D.b2Sweep_Advance,None,b2Sweep)
b2Sweep_swigregister = _Box2D.b2Sweep_swigregister
b2Sweep_swigregister(b2Sweep)


def b2equ(*args):
  """b2equ(b2Vec2 a, b2Vec2 b) -> bool"""
  return _Box2D.b2equ(*args)

def b2DistanceSquared(*args):
  """b2DistanceSquared(b2Vec2 a, b2Vec2 b) -> float32"""
  return _Box2D.b2DistanceSquared(*args)

def b2Min(*args):
  """b2Min(b2Vec2 a, b2Vec2 b) -> b2Vec2"""
  return _Box2D.b2Min(*args)

def b2Max(*args):
  """b2Max(b2Vec2 a, b2Vec2 b) -> b2Vec2"""
  return _Box2D.b2Max(*args)

def b2Clamp(*args):
  """b2Clamp(b2Vec2 a, b2Vec2 low, b2Vec2 high) -> b2Vec2"""
  return _Box2D.b2Clamp(*args)

def b2NextPowerOfTwo(*args):
  """
    b2NextPowerOfTwo(uint32 x) -> uint32

    "Next Largest Power of 2 Given a binary integer value x, the next largest power of 2 can be computed by a SWAR algorithm that recursively "folds" the upper bits into the lower bits. This process yields a bit vector with the same most significant 1 as x, but all 1's below it. Adding 1 to that value yields the next largest power of 2. For a 32-bit value:"
    """
  return _Box2D.b2NextPowerOfTwo(*args)

def b2IsPowerOfTwo(*args):
  """b2IsPowerOfTwo(uint32 x) -> bool"""
  return _Box2D.b2IsPowerOfTwo(*args)
e_unknownJoint = _Box2D.e_unknownJoint
e_revoluteJoint = _Box2D.e_revoluteJoint
e_prismaticJoint = _Box2D.e_prismaticJoint
e_distanceJoint = _Box2D.e_distanceJoint
e_pulleyJoint = _Box2D.e_pulleyJoint
e_mouseJoint = _Box2D.e_mouseJoint
e_gearJoint = _Box2D.e_gearJoint
e_lineJoint = _Box2D.e_lineJoint
e_inactiveLimit = _Box2D.e_inactiveLimit
e_atLowerLimit = _Box2D.e_atLowerLimit
e_atUpperLimit = _Box2D.e_atUpperLimit
e_equalLimits = _Box2D.e_equalLimits
class b2Jacobian(object):
    """Proxy of C++ b2Jacobian class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    linear1 = _swig_property(_Box2D.b2Jacobian_linear1_get, _Box2D.b2Jacobian_linear1_set)
    angular1 = _swig_property(_Box2D.b2Jacobian_angular1_get, _Box2D.b2Jacobian_angular1_set)
    linear2 = _swig_property(_Box2D.b2Jacobian_linear2_get, _Box2D.b2Jacobian_linear2_set)
    angular2 = _swig_property(_Box2D.b2Jacobian_angular2_get, _Box2D.b2Jacobian_angular2_set)
    def SetZero(self):
        """SetZero(self)"""
        return _Box2D.b2Jacobian_SetZero(self)

    def Set(self, *args):
        """Set(self, b2Vec2 x1, float32 a1, b2Vec2 x2, float32 a2)"""
        return _Box2D.b2Jacobian_Set(self, *args)

    def Compute(self, *args):
        """Compute(self, b2Vec2 x1, float32 a1, b2Vec2 x2, float32 a2) -> float32"""
        return _Box2D.b2Jacobian_Compute(self, *args)

    def __repr__(self):
     return """b2Jacobian(
       angular1 = %s,
       angular2 = %s,
       linear1  = %s,
       linear2  = %s)"""% tuple(str(a) for a in\
      (self.angular1,self.angular2,self.linear1,self.linear2))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2Jacobian"""
        _Box2D.b2Jacobian_swiginit(self,_Box2D.new_b2Jacobian())
    __swig_destroy__ = _Box2D.delete_b2Jacobian
b2Jacobian.SetZero = new_instancemethod(_Box2D.b2Jacobian_SetZero,None,b2Jacobian)
b2Jacobian.Set = new_instancemethod(_Box2D.b2Jacobian_Set,None,b2Jacobian)
b2Jacobian.Compute = new_instancemethod(_Box2D.b2Jacobian_Compute,None,b2Jacobian)
b2Jacobian_swigregister = _Box2D.b2Jacobian_swigregister
b2Jacobian_swigregister(b2Jacobian)
b2Vec2_zero = cvar.b2Vec2_zero
b2Mat22_identity = cvar.b2Mat22_identity
b2XForm_identity = cvar.b2XForm_identity

def b2mul(*args):
  """
    b2mul(float32 s, b2Vec2 a) -> b2Vec2
    b2mul(float32 s, b2Vec3 a) -> b2Vec3
    """
  return _Box2D.b2mul(*args)

def b2sub(*args):
  """
    b2sub(b2Vec2 a, b2Vec2 b) -> b2Vec2
    b2sub(b2Vec3 a, b2Vec3 b) -> b2Vec3
    """
  return _Box2D.b2sub(*args)

def b2Dot(*args):
  """
    b2Dot(b2Vec2 a, b2Vec2 b) -> float32
    b2Dot(b2Vec3 a, b2Vec3 b) -> float32

    Perform the dot product on two vectors.
    """
  return _Box2D.b2Dot(*args)

def b2Cross(*args):
  """
    b2Cross(b2Vec2 a, b2Vec2 b) -> float32
    b2Cross(b2Vec2 a, float32 s) -> b2Vec2
    b2Cross(float32 s, b2Vec2 a) -> b2Vec2
    b2Cross(b2Vec3 a, b2Vec3 b) -> b2Vec3

    Perform the cross product on two vectors.
    """
  return _Box2D.b2Cross(*args)

def b2add(*args):
  """
    b2add(b2Vec2 a, b2Vec2 b) -> b2Vec2
    b2add(b2Vec3 a, b2Vec3 b) -> b2Vec3
    b2add(b2Mat22 A, b2Mat22 B) -> b2Mat22
    """
  return _Box2D.b2add(*args)

def b2Mul(*args):
  """
    b2Mul(b2Mat22 A, b2Vec2 v) -> b2Vec2
    b2Mul(b2Mat22 A, b2Mat22 B) -> b2Mat22
    b2Mul(b2Mat33 A, b2Vec3 v) -> b2Vec3
    b2Mul(b2XForm T, b2Vec2 v) -> b2Vec2

    Multiply a matrix times a vector.
    """
  return _Box2D.b2Mul(*args)

def b2MulT(*args):
  """
    b2MulT(b2Mat22 A, b2Vec2 v) -> b2Vec2
    b2MulT(b2Mat22 A, b2Mat22 B) -> b2Mat22
    b2MulT(b2XForm T, b2Vec2 v) -> b2Vec2

    Multiply a matrix transpose times a vector. If a rotation matrix is provided, then this transforms the vector from one frame to another (inverse transform).
    """
  return _Box2D.b2MulT(*args)

def b2Abs(*args):
  """
    b2Abs(float32 a) -> float32
    b2Abs(b2Vec2 a) -> b2Vec2
    b2Abs(b2Mat22 A) -> b2Mat22
    """
  return _Box2D.b2Abs(*args)

class b2JointEdge(object):
    """A joint edge is used to connect bodies and joints together in a joint graph where each body is a node and each joint is an edge. A joint edge belongs to a doubly linked list maintained in each attached body. Each joint has two joint nodes, one for each attached body."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    other = _swig_property(_Box2D.b2JointEdge_other_get, _Box2D.b2JointEdge_other_set)
    joint = _swig_property(_Box2D.b2JointEdge_joint_get, _Box2D.b2JointEdge_joint_set)
    prev = _swig_property(_Box2D.b2JointEdge_prev_get, _Box2D.b2JointEdge_prev_set)
    next = _swig_property(_Box2D.b2JointEdge_next_get, _Box2D.b2JointEdge_next_set)
    def __repr__(self):
     return """b2JointEdge(
       joint = %s,
       other = %s)"""% tuple(str(a) for a in\
      (self.joint,self.other))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2JointEdge"""
        _Box2D.b2JointEdge_swiginit(self,_Box2D.new_b2JointEdge())
    __swig_destroy__ = _Box2D.delete_b2JointEdge
b2JointEdge_swigregister = _Box2D.b2JointEdge_swigregister
b2JointEdge_swigregister(b2JointEdge)

class b2JointDef(object):
    """Joint definitions are used to construct joints."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2JointDef

        Joint definitions are used to construct joints.
        """
        _Box2D.b2JointDef_swiginit(self,_Box2D.new_b2JointDef())
    type = _swig_property(_Box2D.b2JointDef_type_get, _Box2D.b2JointDef_type_set)
    body1 = _swig_property(_Box2D.b2JointDef_body1_get, _Box2D.b2JointDef_body1_set)
    body2 = _swig_property(_Box2D.b2JointDef_body2_get, _Box2D.b2JointDef_body2_set)
    collideConnected = _swig_property(_Box2D.b2JointDef_collideConnected_get, _Box2D.b2JointDef_collideConnected_set)
    def __repr__(self):
     return """b2JointDef(
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       type             = %s,
       userData         = %s)"""% tuple(str(a) for a in\
      (self.body1,self.body2,self.collideConnected,self.type,self.userData))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def GetUserData(self):
        """GetUserData(self) -> PyObject"""
        return _Box2D.b2JointDef_GetUserData(self)

    def SetUserData(self, *args):
        """SetUserData(self, PyObject data)"""
        return _Box2D.b2JointDef_SetUserData(self, *args)

    def ClearUserData(self):
        """ClearUserData(self)"""
        return _Box2D.b2JointDef_ClearUserData(self)

    userData = property(GetUserData, SetUserData)
    def __del__(self):
        self.ClearUserData()

    def typeName(self):
        """
        Return the name of the joint from:
         Unknown, Mouse, Gear, Distance, Prismatic, Pulley, Revolute
        """
        types = { e_unknownJoint  : "Unknown",
                  e_mouseJoint    : "Mouse", 
                  e_gearJoint     : "Gear",
                  e_distanceJoint : "Distance",
                  e_prismaticJoint: "Prismatic",
                  e_pulleyJoint   : "Pulley",
                  e_revoluteJoint : "Revolute",
                  e_lineJoint     : "Line" }
        return types[self.type]

    __swig_destroy__ = _Box2D.delete_b2JointDef
b2JointDef.GetUserData = new_instancemethod(_Box2D.b2JointDef_GetUserData,None,b2JointDef)
b2JointDef.SetUserData = new_instancemethod(_Box2D.b2JointDef_SetUserData,None,b2JointDef)
b2JointDef.ClearUserData = new_instancemethod(_Box2D.b2JointDef_ClearUserData,None,b2JointDef)
b2JointDef_swigregister = _Box2D.b2JointDef_swigregister
b2JointDef_swigregister(b2JointDef)

class b2Joint(object):
    """The base joint class. Joints are used to constraint two bodies together in various fashions. Some joints also feature limits and motors."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    def GetType(self):
        """
        GetType(self) -> b2JointType

        Get the type of the concrete joint.
        """
        return _Box2D.b2Joint_GetType(self)

    def GetBody1(self):
        """
        GetBody1(self) -> b2Body

        Get the first body attached to this joint.
        """
        return _Box2D.b2Joint_GetBody1(self)

    def GetBody2(self):
        """
        GetBody2(self) -> b2Body

        Get the second body attached to this joint.
        """
        return _Box2D.b2Joint_GetBody2(self)

    def GetAnchor1(self):
        """
        GetAnchor1(self) -> b2Vec2

        Get the anchor point on body1 in world coordinates.
        """
        return _Box2D.b2Joint_GetAnchor1(self)

    def GetAnchor2(self):
        """
        GetAnchor2(self) -> b2Vec2

        Get the anchor point on body2 in world coordinates.
        """
        return _Box2D.b2Joint_GetAnchor2(self)

    def GetReactionForce(self, *args):
        """
        GetReactionForce(self, float32 inv_dt) -> b2Vec2

        Get the reaction force on body2 at the joint anchor.
        """
        return _Box2D.b2Joint_GetReactionForce(self, *args)

    def GetReactionTorque(self, *args):
        """
        GetReactionTorque(self, float32 inv_dt) -> float32

        Get the reaction torque on body2.
        """
        return _Box2D.b2Joint_GetReactionTorque(self, *args)

    def GetNext(self):
        """
        GetNext(self) -> b2Joint

        Get the next joint the world joint list.
        """
        return _Box2D.b2Joint_GetNext(self)

    def GetCollideConnected(self):
        """
        GetCollideConnected(self) -> bool

        Get whether or not joint bodies can collide.
        """
        return _Box2D.b2Joint_GetCollideConnected(self)

    def __repr__(self):
     return """b2Joint(
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       type             = %s,
       userData         = %s,
       GetAnchor1()     = %s,
       GetAnchor2()     = %s)"""% tuple(str(a) for a in\
      (self.body1,self.body2,self.collideConnected,self.type,self.userData,self.GetAnchor1(),self.GetAnchor2()))

    __getstate__=no_pickle
    __setstate__=_generic_setstate

    def GetUserData(self):
        """
        GetUserData(self) -> PyObject

        Get the user data pointer.
        """
        return _Box2D.b2Joint_GetUserData(self)

    def SetUserData(self, *args):
        """
        SetUserData(self, PyObject data)

        Set the user data pointer.
        """
        return _Box2D.b2Joint_SetUserData(self, *args)

    def ClearUserData(self):
        """ClearUserData(self)"""
        return _Box2D.b2Joint_ClearUserData(self)

    userData = property(GetUserData, SetUserData)

    def __hash__(self):
        """__hash__(self) -> long"""
        return _Box2D.b2Joint___hash__(self)

    __eq__ = b2JointCompare
    __ne__ = lambda self,other: not b2JointCompare(self,other)
    type    =property(GetType    , None)
    body1   =property(GetBody1   , None)
    body2   =property(GetBody2   , None)
    collideConnected=property(GetCollideConnected, None)
    def typeName(self):
        """
        Return the name of the joint from:
         Unknown, Mouse, Gear, Distance, Prismatic, Pulley, Revolute
        """
        types = { e_unknownJoint  : "Unknown",
                  e_mouseJoint    : "Mouse", 
                  e_gearJoint     : "Gear",
                  e_distanceJoint : "Distance",
                  e_prismaticJoint: "Prismatic",
                  e_pulleyJoint   : "Pulley",
                  e_revoluteJoint : "Revolute",
                  e_lineJoint     : "Line" }
        return types[self.GetType()]
    def getAsType(self):
        """
        Return a typecasted version of the joint
        """
        return (getattr(self, "as%sJoint" % self.typeName())) ()

    def asMouseJoint(self):
        """asMouseJoint(self) -> b2MouseJoint"""
        return _Box2D.b2Joint_asMouseJoint(self)

    def asGearJoint(self):
        """asGearJoint(self) -> b2GearJoint"""
        return _Box2D.b2Joint_asGearJoint(self)

    def asDistanceJoint(self):
        """asDistanceJoint(self) -> b2DistanceJoint"""
        return _Box2D.b2Joint_asDistanceJoint(self)

    def asPrismaticJoint(self):
        """asPrismaticJoint(self) -> b2PrismaticJoint"""
        return _Box2D.b2Joint_asPrismaticJoint(self)

    def asPulleyJoint(self):
        """asPulleyJoint(self) -> b2PulleyJoint"""
        return _Box2D.b2Joint_asPulleyJoint(self)

    def asRevoluteJoint(self):
        """asRevoluteJoint(self) -> b2RevoluteJoint"""
        return _Box2D.b2Joint_asRevoluteJoint(self)

    def asLineJoint(self):
        """asLineJoint(self) -> b2LineJoint"""
        return _Box2D.b2Joint_asLineJoint(self)

b2Joint.GetType = new_instancemethod(_Box2D.b2Joint_GetType,None,b2Joint)
b2Joint.GetBody1 = new_instancemethod(_Box2D.b2Joint_GetBody1,None,b2Joint)
b2Joint.GetBody2 = new_instancemethod(_Box2D.b2Joint_GetBody2,None,b2Joint)
b2Joint.GetAnchor1 = new_instancemethod(_Box2D.b2Joint_GetAnchor1,None,b2Joint)
b2Joint.GetAnchor2 = new_instancemethod(_Box2D.b2Joint_GetAnchor2,None,b2Joint)
b2Joint.GetReactionForce = new_instancemethod(_Box2D.b2Joint_GetReactionForce,None,b2Joint)
b2Joint.GetReactionTorque = new_instancemethod(_Box2D.b2Joint_GetReactionTorque,None,b2Joint)
b2Joint.GetNext = new_instancemethod(_Box2D.b2Joint_GetNext,None,b2Joint)
b2Joint.GetCollideConnected = new_instancemethod(_Box2D.b2Joint_GetCollideConnected,None,b2Joint)
b2Joint.GetUserData = new_instancemethod(_Box2D.b2Joint_GetUserData,None,b2Joint)
b2Joint.SetUserData = new_instancemethod(_Box2D.b2Joint_SetUserData,None,b2Joint)
b2Joint.ClearUserData = new_instancemethod(_Box2D.b2Joint_ClearUserData,None,b2Joint)
b2Joint.__hash__ = new_instancemethod(_Box2D.b2Joint___hash__,None,b2Joint)
b2Joint.asMouseJoint = new_instancemethod(_Box2D.b2Joint_asMouseJoint,None,b2Joint)
b2Joint.asGearJoint = new_instancemethod(_Box2D.b2Joint_asGearJoint,None,b2Joint)
b2Joint.asDistanceJoint = new_instancemethod(_Box2D.b2Joint_asDistanceJoint,None,b2Joint)
b2Joint.asPrismaticJoint = new_instancemethod(_Box2D.b2Joint_asPrismaticJoint,None,b2Joint)
b2Joint.asPulleyJoint = new_instancemethod(_Box2D.b2Joint_asPulleyJoint,None,b2Joint)
b2Joint.asRevoluteJoint = new_instancemethod(_Box2D.b2Joint_asRevoluteJoint,None,b2Joint)
b2Joint.asLineJoint = new_instancemethod(_Box2D.b2Joint_asLineJoint,None,b2Joint)
b2Joint_swigregister = _Box2D.b2Joint_swigregister
b2Joint_swigregister(b2Joint)


def __b2ComputeCentroid(*args):
  """__b2ComputeCentroid(b2Vec2 vs, int32 count) -> b2Vec2"""
  return _Box2D.__b2ComputeCentroid(*args)

def __b2ComputeOBB(*args):
  """__b2ComputeOBB(b2OBB obb, b2Vec2 vs, int32 count) -> bool"""
  return _Box2D.__b2ComputeOBB(*args)
RAND_LIMIT = _Box2D.RAND_LIMIT
B2_FLT_EPSILON = 1.192092896e-07
FLT_EPSILON = B2_FLT_EPSILON
B2_FLT_MAX     = 3.402823466e+38
cvars = ('b2_minPulleyLength','b2Contact_s_initialized','b2Contact_s_registers','b2_maxStackEntries','b2_stackSize',
         'b2_chunkArrayIncrement','b2_blockSizes','b2_maxBlockSize','b2_chunkSize','b2_defaultFilter','b2BroadPhase_s_validate',
         'b2_nullEdge','b2_invalid','b2_tableMask','b2_tableCapacity','b2_nullProxy','b2_nullPair','b2_nullFeature','b2XForm_identity',
         'b2Mat22_identity','b2Vec2_zero','b2_version','b2_byteCount','b2_angularSleepTolerance','b2_linearSleepTolerance',
         'b2_timeToSleep','b2_contactBaumgarte','b2_maxAngularVelocitySquared','b2_maxAngularVelocity','b2_maxLinearVelocitySquared',
         'b2_maxLinearVelocity','b2_maxAngularCorrection','b2_maxLinearCorrection','b2_velocityThreshold','b2_maxTOIJointsPerIsland',
         'b2_maxTOIContactsPerIsland','b2_toiSlop','b2_angularSlop','b2_linearSlop','b2_maxPairs','b2_maxProxies','b2_maxPolygonVertices',
         'b2_maxManifoldPoints','b2_pi')

def b2PythonComputeCentroid(pd):
    """
        Computes the centroid of the polygon shape definition, pd.
        Raises ValueError on an invalid vertex count or a small area.

        Ported from the Box2D C++ code.
    """
    count = pd.vertexCount

    if count < 3:
        raise ValueError("ComputeCentroid: vertex count < 3")

    c = b2Vec2(0.0, 0.0)
    area = 0.0

    # pRef is the reference point for forming triangles.
    # It's location doesn't change the result (except for rounding error).
    pRef = b2Vec2(0.0, 0.0)

    inv3 = 1.0 / 3.0

    for i in range(count):
        # Triangle vertices.
        p1 = pRef
        p2 = pd.getVertex(i)
        if i + 1 < count: 
            p3 = pd.getVertex(i+1)
        else: p3 = pd.getVertex(0)

        e1 = p2 - p1
        e2 = p3 - p1

        D = b2Cross(e1, e2)

        triangleArea = 0.5 * D
        area += triangleArea

        # Area weighted centroid
        c += triangleArea * inv3 * (p1 + p2 + p3)

    # Centroid
    if area <= FLT_EPSILON:
        raise ValueError("ComputeCentroid: area <= FLT_EPSILON")

    return c / area


def collideCircleParticle(*args):
  """
    collideCircleParticle(b2CircleShape circle, b2Vec2 ppos) -> PyObject

    For liquid simulation. Checks if a particle
    would collide with the specified circle.

    """
  return _Box2D.collideCircleParticle(*args)

def b2CollidePolyParticle(*args):
  """
    b2CollidePolyParticle(b2PolygonShape polygon, b2Vec2 ppos, float32 pradius) -> PyObject

    For liquid simulation. Checks if a particle
    would collide with the specified polygon.

    """
  return _Box2D.b2CollidePolyParticle(*args)
def b2PythonCheckPolygonDef(pd):
    """
        Checks the Polygon definition to see if upon creation it will cause an assertion.
        Raises ValueError if an assertion would be raised.

        Ported from the Box2D C++ code for CreateShape(). The C++ version is now
        included as it's more accurate, please use b2CheckPolygonDef instead.
    """

    if pd.vertexCount < 3 or pd.vertexCount >= b2_maxPolygonVertices:
        raise ValueError("Invalid vertexCount")

    threshold = FLT_EPSILON * FLT_EPSILON
    verts = pd.getVertices_b2Vec2()
    normals = []
    v0 = verts[0]
    for i in range(pd.vertexCount):
        if i == pd.vertexCount-1:
            v1 = verts[0]
        else: v1 = verts[i+1]
        edge=v1 - v0
        if edge.LengthSquared() < threshold:
            raise ValueError("edge.LengthSquared < FLT_EPSILON**2" )
        normals.append( b2Cross(edge, 1.0) )
        normals[-1].Normalize()
        v0=v1

    centroid = b2PythonComputeCentroid(pd)

    d=b2Vec2()
    for i in range(pd.vertexCount):
        i1 = i - 1 
        if i1 < 0: i1 = pd.vertexCount - 1
        i2 = i
        n1 = normals[i1]
        n2 = normals[i2]
        v = verts[i] - centroid

        d.x = b2Dot(n1, v) - b2_toiSlop
        d.y = b2Dot(n2, v) - b2_toiSlop

        # Shifting the edge inward by b2_toiSlop should
        # not cause the plane to pass the centroid.

        # Your shape has a radius/extent less than b2_toiSlop.
        if d.x < 0.0 or d.y <= 0.0: 
            raise ValueError("Your shape has a radius/extent less than b2_toiSlop.")

        A = b2Mat22()
        A.col1.x = n1.x; A.col2.x = n1.y
        A.col1.y = n2.x; A.col2.y = n2.y
        #coreVertices[i] = A.Solve(d) + m_centroid

    return True


class b2ContactID(object):
    """Proxy of C++ b2ContactID class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    key = _swig_property(_Box2D.b2ContactID_key_get, _Box2D.b2ContactID_key_set)
    def __repr__(self):
     return """b2ContactID(
       features = %s,
       key      = %s)"""% tuple(str(a) for a in\
      (self.features,self.key))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    features = _swig_property(_Box2D.b2ContactID_features_get)
    def __init__(self): 
        """__init__(self) -> b2ContactID"""
        _Box2D.b2ContactID_swiginit(self,_Box2D.new_b2ContactID())
    __swig_destroy__ = _Box2D.delete_b2ContactID
b2ContactID_swigregister = _Box2D.b2ContactID_swigregister
b2ContactID_swigregister(b2ContactID)

def b2Distance(*args):
  """
    b2Distance(b2Vec2 a, b2Vec2 b) -> float32
    b2Distance(b2Shape shape1, b2XForm xf1, b2Shape shape2, b2XForm xf2) -> PyObject

    Compute the distance between two shapes and the closest points. 
    the distance between the shapes or zero if they are overlapped/touching.
    """
  return _Box2D.b2Distance(*args)

def b2AABBOverlaps(*args):
  """
    b2AABBOverlaps(b2AABB aabb, b2Vec2 point) -> bool
    b2AABBOverlaps(b2AABB aabb, b2AABB aabb2) -> bool

    Checks if two AABBs overlap, or if a point
        lies in an AABB
        
        b2AABBOverlaps(AABB1, [AABB2/point])
        
    """
  return _Box2D.b2AABBOverlaps(*args)

def b2CheckPolygonDef(*args):
  """
    b2CheckPolygonDef(b2PolygonDef poly, bool additional_checks = True) -> bool
    b2CheckPolygonDef(b2PolygonDef poly) -> bool

    Checks the Polygon definition to see if upon creation it will cause an assertion.
    Raises ValueError if an assertion would be raised.

    b2PolygonDef* poly     - the polygon definition
    bool additional_checks - whether or not to run additional checks

    Additional checking: usually only in DEBUG mode on the C++ code.

    While shapes that pass this test can be created without assertions,
    they will ultimately create unexpected behavior. It's recommended
    to _not_ use any polygon that fails this test.

    """
  return _Box2D.b2CheckPolygonDef(*args)

def b2Random(*args):
  """
    b2Random() -> float32
    b2Random(float32 lo, float32 hi) -> float32

    Random floating point number in range [lo, hi]. With no arguments, returns one in -1,1.
    """
  return _Box2D.b2Random(*args)
b2_nullFeature = cvar.b2_nullFeature

class b2ContactID_features(object):
    """Proxy of C++ b2ContactID_features class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __repr__(self):
     return """b2ContactID_features(
       flip           = %s,
       incidentEdge   = %s,
       incidentVertex = %s,
       referenceEdge  = %s)"""% tuple(str(a) for a in\
      (self.flip,self.incidentEdge,self.incidentVertex,self.referenceEdge))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    referenceEdge = _swig_property(_Box2D.b2ContactID_features_referenceEdge_get, _Box2D.b2ContactID_features_referenceEdge_set)
    incidentEdge = _swig_property(_Box2D.b2ContactID_features_incidentEdge_get, _Box2D.b2ContactID_features_incidentEdge_set)
    incidentVertex = _swig_property(_Box2D.b2ContactID_features_incidentVertex_get, _Box2D.b2ContactID_features_incidentVertex_set)
    flip = _swig_property(_Box2D.b2ContactID_features_flip_get, _Box2D.b2ContactID_features_flip_set)
    def __init__(self): 
        """__init__(self) -> b2ContactID_features"""
        _Box2D.b2ContactID_features_swiginit(self,_Box2D.new_b2ContactID_features())
    __swig_destroy__ = _Box2D.delete_b2ContactID_features
b2ContactID_features_swigregister = _Box2D.b2ContactID_features_swigregister
b2ContactID_features_swigregister(b2ContactID_features)

class b2ManifoldPoint(object):
    """A manifold point is a contact point belonging to a contact manifold. It holds details related to the geometry and dynamics of the contact points. The point is stored in local coordinates because CCD requires sub-stepping in which the separation is stale."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    localPoint1 = _swig_property(_Box2D.b2ManifoldPoint_localPoint1_get, _Box2D.b2ManifoldPoint_localPoint1_set)
    localPoint2 = _swig_property(_Box2D.b2ManifoldPoint_localPoint2_get, _Box2D.b2ManifoldPoint_localPoint2_set)
    separation = _swig_property(_Box2D.b2ManifoldPoint_separation_get, _Box2D.b2ManifoldPoint_separation_set)
    normalImpulse = _swig_property(_Box2D.b2ManifoldPoint_normalImpulse_get, _Box2D.b2ManifoldPoint_normalImpulse_set)
    tangentImpulse = _swig_property(_Box2D.b2ManifoldPoint_tangentImpulse_get, _Box2D.b2ManifoldPoint_tangentImpulse_set)
    id = _swig_property(_Box2D.b2ManifoldPoint_id_get, _Box2D.b2ManifoldPoint_id_set)
    def __repr__(self):
     return """b2ManifoldPoint(
       id             = %s,
       localPoint1    = %s,
       localPoint2    = %s,
       normalImpulse  = %s,
       separation     = %s,
       tangentImpulse = %s)"""% tuple(str(a) for a in\
      (self.id,self.localPoint1,self.localPoint2,self.normalImpulse,self.separation,self.tangentImpulse))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2ManifoldPoint"""
        _Box2D.b2ManifoldPoint_swiginit(self,_Box2D.new_b2ManifoldPoint())
    __swig_destroy__ = _Box2D.delete_b2ManifoldPoint
b2ManifoldPoint_swigregister = _Box2D.b2ManifoldPoint_swigregister
b2ManifoldPoint_swigregister(b2ManifoldPoint)

class b2Manifold(object):
    """A manifold for two touching convex shapes."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    points = _swig_property(_Box2D.b2Manifold_points_get, _Box2D.b2Manifold_points_set)
    normal = _swig_property(_Box2D.b2Manifold_normal_get, _Box2D.b2Manifold_normal_set)
    pointCount = _swig_property(_Box2D.b2Manifold_pointCount_get, _Box2D.b2Manifold_pointCount_set)
    def __repr__(self):
     return """b2Manifold(
       normal     = %s,
       pointCount = %s,
       points     = %s)"""% tuple(str(a) for a in\
      (self.normal,self.pointCount,self.points))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2Manifold"""
        _Box2D.b2Manifold_swiginit(self,_Box2D.new_b2Manifold())
    __swig_destroy__ = _Box2D.delete_b2Manifold
b2Manifold_swigregister = _Box2D.b2Manifold_swigregister
b2Manifold_swigregister(b2Manifold)

class b2Segment(object):
    """A line segment."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def TestSegment(self, *args):
        """
        TestSegment(self, float32 _lambda, b2Vec2 normal, b2Segment segment, 
            float32 maxLambda) -> bool

        Ray cast against this segment with another segment.
        """
        return _Box2D.b2Segment_TestSegment(self, *args)

    p1 = _swig_property(_Box2D.b2Segment_p1_get, _Box2D.b2Segment_p1_set)
    p2 = _swig_property(_Box2D.b2Segment_p2_get, _Box2D.b2Segment_p2_set)
    def __repr__(self):
     return """b2Segment(
       p1 = %s,
       p2 = %s)"""% tuple(str(a) for a in\
      (self.p1,self.p2))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2Segment"""
        _Box2D.b2Segment_swiginit(self,_Box2D.new_b2Segment())
    __swig_destroy__ = _Box2D.delete_b2Segment
b2Segment.TestSegment = new_instancemethod(_Box2D.b2Segment_TestSegment,None,b2Segment)
b2Segment_swigregister = _Box2D.b2Segment_swigregister
b2Segment_swigregister(b2Segment)

class b2AABB(object):
    """An axis aligned bounding box."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def IsValid(self):
        """
        IsValid(self) -> bool

        Verify that the bounds are sorted.
        """
        return _Box2D.b2AABB_IsValid(self)

    lowerBound = _swig_property(_Box2D.b2AABB_lowerBound_get, _Box2D.b2AABB_lowerBound_set)
    upperBound = _swig_property(_Box2D.b2AABB_upperBound_get, _Box2D.b2AABB_upperBound_set)
    def __repr__(self):
     return """b2AABB(
       lowerBound = %s,
       upperBound = %s,
       IsValid()  = %s)"""% tuple(str(a) for a in\
      (self.lowerBound,self.upperBound,self.IsValid()))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2AABB"""
        _Box2D.b2AABB_swiginit(self,_Box2D.new_b2AABB())
    __swig_destroy__ = _Box2D.delete_b2AABB
b2AABB.IsValid = new_instancemethod(_Box2D.b2AABB_IsValid,None,b2AABB)
b2AABB_swigregister = _Box2D.b2AABB_swigregister
b2AABB_swigregister(b2AABB)

class b2OBB(object):
    """An oriented bounding box."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    R = _swig_property(_Box2D.b2OBB_R_get, _Box2D.b2OBB_R_set)
    center = _swig_property(_Box2D.b2OBB_center_get, _Box2D.b2OBB_center_set)
    extents = _swig_property(_Box2D.b2OBB_extents_get, _Box2D.b2OBB_extents_set)
    def __repr__(self):
     return """b2OBB(
       R       = %s,
       center  = %s,
       extents = %s)"""% tuple(str(a) for a in\
      (self.R,self.center,self.extents))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2OBB"""
        _Box2D.b2OBB_swiginit(self,_Box2D.new_b2OBB())
    __swig_destroy__ = _Box2D.delete_b2OBB
b2OBB_swigregister = _Box2D.b2OBB_swigregister
b2OBB_swigregister(b2OBB)


def b2CollideCircles(*args):
  """
    b2CollideCircles(b2Manifold manifold, b2CircleShape circle1, b2XForm xf1, 
        b2CircleShape circle2, b2XForm xf2)

    Compute the collision manifold between two circles.
    """
  return _Box2D.b2CollideCircles(*args)

def b2CollidePolygonAndCircle(*args):
  """
    b2CollidePolygonAndCircle(b2Manifold manifold, b2PolygonShape polygon, b2XForm xf1, 
        b2CircleShape circle, b2XForm xf2)

    Compute the collision manifold between a polygon and a circle.
    """
  return _Box2D.b2CollidePolygonAndCircle(*args)

def b2CollidePolygons(*args):
  """
    b2CollidePolygons(b2Manifold manifold, b2PolygonShape polygon1, b2XForm xf1, 
        b2PolygonShape polygon2, b2XForm xf2)

    Compute the collision manifold between two circles.
    """
  return _Box2D.b2CollidePolygons(*args)

def __b2Distance__(*args):
  """
    __b2Distance__(b2Vec2 x1, b2Vec2 x2, b2Shape shape1, b2XForm xf1, 
        b2Shape shape2, b2XForm xf2) -> float32

    Compute the distance between two shapes and the closest points. 
    the distance between the shapes or zero if they are overlapped/touching.
    """
  return _Box2D.__b2Distance__(*args)

def b2TimeOfImpact(*args):
  """
    b2TimeOfImpact(b2Shape shape1, b2Sweep sweep1, b2Shape shape2, b2Sweep sweep2) -> float32

    Compute the time when two shapes begin to touch or touch at a closer distance. 
    WARNING: 
    the sweeps must have the same time interval.

    the fraction between [0,1] in which the shapes first touch. fraction=0 means the shapes begin touching/overlapped, and fraction=1 means the shapes don't touch.
    """
  return _Box2D.b2TimeOfImpact(*args)

def b2TestOverlap(*args):
  """b2TestOverlap(b2AABB a, b2AABB b) -> bool"""
  return _Box2D.b2TestOverlap(*args)
class b2MassData(object):
    """This holds the mass data computed for a shape."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    mass = _swig_property(_Box2D.b2MassData_mass_get, _Box2D.b2MassData_mass_set)
    center = _swig_property(_Box2D.b2MassData_center_get, _Box2D.b2MassData_center_set)
    I = _swig_property(_Box2D.b2MassData_I_get, _Box2D.b2MassData_I_set)
    def __repr__(self):
     return """b2MassData(
       I      = %s,
       center = %s,
       mass   = %s)"""% tuple(str(a) for a in\
      (self.I,self.center,self.mass))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2MassData"""
        _Box2D.b2MassData_swiginit(self,_Box2D.new_b2MassData())
    __swig_destroy__ = _Box2D.delete_b2MassData
b2MassData_swigregister = _Box2D.b2MassData_swigregister
b2MassData_swigregister(b2MassData)

class b2FilterData(object):
    """This holds contact filtering data."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    categoryBits = _swig_property(_Box2D.b2FilterData_categoryBits_get, _Box2D.b2FilterData_categoryBits_set)
    maskBits = _swig_property(_Box2D.b2FilterData_maskBits_get, _Box2D.b2FilterData_maskBits_set)
    groupIndex = _swig_property(_Box2D.b2FilterData_groupIndex_get, _Box2D.b2FilterData_groupIndex_set)
    def __repr__(self):
     return """b2FilterData(
       categoryBits = %s,
       groupIndex   = %s,
       maskBits     = %s)"""% tuple(str(a) for a in\
      (self.categoryBits,self.groupIndex,self.maskBits))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2FilterData"""
        _Box2D.b2FilterData_swiginit(self,_Box2D.new_b2FilterData())
    __swig_destroy__ = _Box2D.delete_b2FilterData
b2FilterData_swigregister = _Box2D.b2FilterData_swigregister
b2FilterData_swigregister(b2FilterData)

e_unknownShape = _Box2D.e_unknownShape
e_circleShape = _Box2D.e_circleShape
e_polygonShape = _Box2D.e_polygonShape
e_edgeShape = _Box2D.e_edgeShape
e_shapeTypeCount = _Box2D.e_shapeTypeCount
e_startsInsideCollide = _Box2D.e_startsInsideCollide
e_missCollide = _Box2D.e_missCollide
e_hitCollide = _Box2D.e_hitCollide
class b2ShapeDef(object):
    """A shape definition is used to construct a shape. This class defines an abstract shape definition. You can reuse shape definitions safely."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2ShapeDef

        The constructor sets the default shape definition values.
        """
        _Box2D.b2ShapeDef_swiginit(self,_Box2D.new_b2ShapeDef())
    __swig_destroy__ = _Box2D.delete_b2ShapeDef
    type = _swig_property(_Box2D.b2ShapeDef_type_get, _Box2D.b2ShapeDef_type_set)
    friction = _swig_property(_Box2D.b2ShapeDef_friction_get, _Box2D.b2ShapeDef_friction_set)
    restitution = _swig_property(_Box2D.b2ShapeDef_restitution_get, _Box2D.b2ShapeDef_restitution_set)
    density = _swig_property(_Box2D.b2ShapeDef_density_get, _Box2D.b2ShapeDef_density_set)
    isSensor = _swig_property(_Box2D.b2ShapeDef_isSensor_get, _Box2D.b2ShapeDef_isSensor_set)
    filter = _swig_property(_Box2D.b2ShapeDef_filter_get, _Box2D.b2ShapeDef_filter_set)
    def __repr__(self):
     return """b2ShapeDef(
       density     = %s,
       filter      = %s,
       friction    = %s,
       isSensor    = %s,
       restitution = %s,
       type        = %s,
       userData    = %s)"""% tuple(str(a) for a in\
      (self.density,self.filter,self.friction,self.isSensor,self.restitution,self.type,self.userData))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def GetUserData(self):
        """GetUserData(self) -> PyObject"""
        return _Box2D.b2ShapeDef_GetUserData(self)

    def SetUserData(self, *args):
        """SetUserData(self, PyObject data)"""
        return _Box2D.b2ShapeDef_SetUserData(self, *args)

    def ClearUserData(self):
        """ClearUserData(self)"""
        return _Box2D.b2ShapeDef_ClearUserData(self)

    userData = property(GetUserData, SetUserData)
    def __del__(self):
        self.ClearUserData()

b2ShapeDef.GetUserData = new_instancemethod(_Box2D.b2ShapeDef_GetUserData,None,b2ShapeDef)
b2ShapeDef.SetUserData = new_instancemethod(_Box2D.b2ShapeDef_SetUserData,None,b2ShapeDef)
b2ShapeDef.ClearUserData = new_instancemethod(_Box2D.b2ShapeDef_ClearUserData,None,b2ShapeDef)
b2ShapeDef_swigregister = _Box2D.b2ShapeDef_swigregister
b2ShapeDef_swigregister(b2ShapeDef)

class b2Shape(object):
    """
    A shape is used for collision detection. Shapes are created in  b2World. You can use shape for collision detection before they are attached to the world. 
    WARNING: 
    you cannot reuse shapes.
    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    def GetType(self):
        """
        GetType(self) -> b2ShapeType

        Get the type of this shape. You can use this to down cast to the concrete shape. 
        the shape type.
        """
        return _Box2D.b2Shape_GetType(self)

    def IsSensor(self):
        """
        IsSensor(self) -> bool

        Is this shape a sensor (non-solid)? 
        the true if the shape is a sensor.
        """
        return _Box2D.b2Shape_IsSensor(self)

    def SetSensor(self, *args):
        """SetSensor(self, bool sensor)"""
        return _Box2D.b2Shape_SetSensor(self, *args)

    def SetFilterData(self, *args):
        """
        SetFilterData(self, b2FilterData filter)

        Set the contact filtering data. You must call  b2World::Refilterto correct existing contacts/non-contacts.
        """
        return _Box2D.b2Shape_SetFilterData(self, *args)

    def GetFilterData(self):
        """
        GetFilterData(self) -> b2FilterData

        Get the contact filtering data.
        """
        return _Box2D.b2Shape_GetFilterData(self)

    def GetBody(self):
        """
        GetBody(self) -> b2Body

        Get the parent body of this shape. This is NULL if the shape is not attached. 
        the parent body.
        """
        return _Box2D.b2Shape_GetBody(self)

    def GetNext(self):
        """
        GetNext(self) -> b2Shape

        Get the next shape in the parent body's shape list. 
        the next shape.
        """
        return _Box2D.b2Shape_GetNext(self)

    def TestPoint(self, *args):
        """
        TestPoint(self, b2XForm xf, b2Vec2 p) -> bool

        Test a point for containment in this shape. This only works for convex shapes.

        Parameters:
        -----------

        xf: the shape world transform.

        p: a point in world coordinates.
        """
        return _Box2D.b2Shape_TestPoint(self, *args)

    def ComputeAABB(self, *args):
        """
        ComputeAABB(self, b2AABB aabb, b2XForm xf)

        Given a transform, compute the associated axis aligned bounding box for this shape.

        Parameters:
        -----------

        aabb: returns the axis aligned box.

        xf: the world transform of the shape.
        """
        return _Box2D.b2Shape_ComputeAABB(self, *args)

    def ComputeSweptAABB(self, *args):
        """
        ComputeSweptAABB(self, b2AABB aabb, b2XForm xf1, b2XForm xf2)

        Given two transforms, compute the associated swept axis aligned bounding box for this shape.

        Parameters:
        -----------

        aabb: returns the axis aligned box.

        xf1: the starting shape world transform.

        xf2: the ending shape world transform.
        """
        return _Box2D.b2Shape_ComputeSweptAABB(self, *args)

    def ComputeMass(self, *args):
        """
        ComputeMass(self, b2MassData massData)

        Compute the mass properties of this shape using its dimensions and density. The inertia tensor is computed about the local origin, not the centroid.

        Parameters:
        -----------

        massData: returns the mass data for this shape.
        """
        return _Box2D.b2Shape_ComputeMass(self, *args)

    def ComputeSubmergedArea(self, *args):
        """
        ComputeSubmergedArea(self, b2Vec2 normal, float32 offset, b2XForm xf, b2Vec2 c) -> float32

        Compute the volume and centroid of this shape intersected with a half plane

        Parameters:
        -----------

        normal: the surface normal

        offset: the surface offset along normal

        xf: the shape transform

        c: returns the centroid

        the total volume less than offset along normal
        """
        return _Box2D.b2Shape_ComputeSubmergedArea(self, *args)

    def GetSweepRadius(self):
        """
        GetSweepRadius(self) -> float32

        Get the maximum radius about the parent body's center of mass.
        """
        return _Box2D.b2Shape_GetSweepRadius(self)

    def GetFriction(self):
        """
        GetFriction(self) -> float32

        Get the coefficient of friction.
        """
        return _Box2D.b2Shape_GetFriction(self)

    def SetFriction(self, *args):
        """
        SetFriction(self, float32 friction)

        Set the coefficient of friction.
        """
        return _Box2D.b2Shape_SetFriction(self, *args)

    def GetRestitution(self):
        """
        GetRestitution(self) -> float32

        Get the coefficient of restitution.
        """
        return _Box2D.b2Shape_GetRestitution(self)

    def SetRestitution(self, *args):
        """
        SetRestitution(self, float32 restitution)

        Set the coefficient of restitution.
        """
        return _Box2D.b2Shape_SetRestitution(self, *args)

    def GetDensity(self):
        """
        GetDensity(self) -> float32

        Get the density of the shape.
        """
        return _Box2D.b2Shape_GetDensity(self)

    def SetDensity(self, *args):
        """
        SetDensity(self, float32 density)

        Set the density of the shape.
        """
        return _Box2D.b2Shape_SetDensity(self, *args)

    def __repr__(self):
     return """b2Shape(
       density          = %s,
       filter           = %s,
       friction         = %s,
       restitution      = %s,
       userData         = %s,
       GetBody()        = %s,
       GetFilterData()  = %s,
       GetSweepRadius() = %s,
       GetType()        = %s,
       IsSensor()       = %s)"""% tuple(str(a) for a in\
      (self.density,self.filter,self.friction,self.restitution,self.userData,self.GetBody(),self.GetFilterData(),self.GetSweepRadius(),self.GetType(),self.IsSensor()))

    __getstate__=no_pickle
    __setstate__=_generic_setstate

    def GetUserData(self):
        """
        GetUserData(self) -> PyObject

        Get the user data that was assigned in the shape definition. Use this to store your application specific data.
        """
        return _Box2D.b2Shape_GetUserData(self)

    def SetUserData(self, *args):
        """
        SetUserData(self, PyObject data)

        Set the user data. Use this to store your application specific data.
        """
        return _Box2D.b2Shape_SetUserData(self, *args)

    def ClearUserData(self):
        """ClearUserData(self)"""
        return _Box2D.b2Shape_ClearUserData(self)

    userData = property(GetUserData, SetUserData)

    def __hash__(self):
        """__hash__(self) -> long"""
        return _Box2D.b2Shape___hash__(self)

    def TestSegment(self, *args):
        """
        TestSegment(self, b2XForm xf, float32 _lambda, b2Vec2 normal, b2Segment segment, 
            float32 maxLambda) -> b2SegmentCollide
        TestSegment(self, b2XForm xf, b2Segment segment, float32 maxLambda) -> PyObject

        Perform a ray cast against this shape.

        Parameters:
        -----------

        xf: 
        the shape world transform.

        lambda: 
        returns the hit fraction. You can use this to compute the contact point p = (1 - lambda) * segment.p1 + lambda * segment.p2.

        normal: 
        returns the normal at the contact point. If there is no intersection, the normal is not set.

        segment: 
        defines the begin and end point of the ray cast.

        maxLambda: 
        a number typically in the range [0,1].
        """
        return _Box2D.b2Shape_TestSegment(self, *args)

    filter     = property(GetFilterData, SetFilterData)
    friction   = property(GetFriction, SetFriction)
    restitution= property(GetRestitution, SetRestitution)
    density    = property(GetDensity, SetDensity)
    isSensor   = property(IsSensor, None) # for symmetry with defn + pickling
    __eq__ = b2ShapeCompare
    __ne__ = lambda self,other: not b2ShapeCompare(self,other)
    def typeName(self):
        types = {  e_unknownShape   : "Unknown",
                    e_circleShape   : "Circle",
                    e_polygonShape  : "Polygon",
                    e_edgeShape     : "Edge",
                    e_shapeTypeCount: "ShapeType" }
        return types[self.GetType()]
    def getAsType(self):
        """Return a typecasted version of the shape"""
        return (getattr(self, "as%s" % self.typeName())) ()

    def asCircle(self):
        """asCircle(self) -> b2CircleShape"""
        return _Box2D.b2Shape_asCircle(self)

    def asPolygon(self):
        """asPolygon(self) -> b2PolygonShape"""
        return _Box2D.b2Shape_asPolygon(self)

    def asEdge(self):
        """asEdge(self) -> b2EdgeShape"""
        return _Box2D.b2Shape_asEdge(self)

b2Shape.GetType = new_instancemethod(_Box2D.b2Shape_GetType,None,b2Shape)
b2Shape.IsSensor = new_instancemethod(_Box2D.b2Shape_IsSensor,None,b2Shape)
b2Shape.SetSensor = new_instancemethod(_Box2D.b2Shape_SetSensor,None,b2Shape)
b2Shape.SetFilterData = new_instancemethod(_Box2D.b2Shape_SetFilterData,None,b2Shape)
b2Shape.GetFilterData = new_instancemethod(_Box2D.b2Shape_GetFilterData,None,b2Shape)
b2Shape.GetBody = new_instancemethod(_Box2D.b2Shape_GetBody,None,b2Shape)
b2Shape.GetNext = new_instancemethod(_Box2D.b2Shape_GetNext,None,b2Shape)
b2Shape.TestPoint = new_instancemethod(_Box2D.b2Shape_TestPoint,None,b2Shape)
b2Shape.ComputeAABB = new_instancemethod(_Box2D.b2Shape_ComputeAABB,None,b2Shape)
b2Shape.ComputeSweptAABB = new_instancemethod(_Box2D.b2Shape_ComputeSweptAABB,None,b2Shape)
b2Shape.ComputeMass = new_instancemethod(_Box2D.b2Shape_ComputeMass,None,b2Shape)
b2Shape.ComputeSubmergedArea = new_instancemethod(_Box2D.b2Shape_ComputeSubmergedArea,None,b2Shape)
b2Shape.GetSweepRadius = new_instancemethod(_Box2D.b2Shape_GetSweepRadius,None,b2Shape)
b2Shape.GetFriction = new_instancemethod(_Box2D.b2Shape_GetFriction,None,b2Shape)
b2Shape.SetFriction = new_instancemethod(_Box2D.b2Shape_SetFriction,None,b2Shape)
b2Shape.GetRestitution = new_instancemethod(_Box2D.b2Shape_GetRestitution,None,b2Shape)
b2Shape.SetRestitution = new_instancemethod(_Box2D.b2Shape_SetRestitution,None,b2Shape)
b2Shape.GetDensity = new_instancemethod(_Box2D.b2Shape_GetDensity,None,b2Shape)
b2Shape.SetDensity = new_instancemethod(_Box2D.b2Shape_SetDensity,None,b2Shape)
b2Shape.GetUserData = new_instancemethod(_Box2D.b2Shape_GetUserData,None,b2Shape)
b2Shape.SetUserData = new_instancemethod(_Box2D.b2Shape_SetUserData,None,b2Shape)
b2Shape.ClearUserData = new_instancemethod(_Box2D.b2Shape_ClearUserData,None,b2Shape)
b2Shape.__hash__ = new_instancemethod(_Box2D.b2Shape___hash__,None,b2Shape)
b2Shape.TestSegment = new_instancemethod(_Box2D.b2Shape_TestSegment,None,b2Shape)
b2Shape.asCircle = new_instancemethod(_Box2D.b2Shape_asCircle,None,b2Shape)
b2Shape.asPolygon = new_instancemethod(_Box2D.b2Shape_asPolygon,None,b2Shape)
b2Shape.asEdge = new_instancemethod(_Box2D.b2Shape_asEdge,None,b2Shape)
b2Shape_swigregister = _Box2D.b2Shape_swigregister
b2Shape_swigregister(b2Shape)

class b2CircleDef(b2ShapeDef):
    """This structure is used to build circle shapes."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2CircleDef

        This structure is used to build circle shapes.
        """
        _Box2D.b2CircleDef_swiginit(self,_Box2D.new_b2CircleDef())
    localPosition = _swig_property(_Box2D.b2CircleDef_localPosition_get, _Box2D.b2CircleDef_localPosition_set)
    radius = _swig_property(_Box2D.b2CircleDef_radius_get, _Box2D.b2CircleDef_radius_set)
    def __repr__(self):
     return """b2CircleDef(
       density       = %s,
       filter        = %s,
       friction      = %s,
       isSensor      = %s,
       localPosition = %s,
       radius        = %s,
       restitution   = %s,
       type          = %s,
       userData      = %s)"""% tuple(str(a) for a in\
      (self.density,self.filter,self.friction,self.isSensor,self.localPosition,self.radius,self.restitution,self.type,self.userData))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2CircleDef
b2CircleDef_swigregister = _Box2D.b2CircleDef_swigregister
b2CircleDef_swigregister(b2CircleDef)

class b2CircleShape(b2Shape):
    """A circle shape."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def GetLocalPosition(self):
        """
        GetLocalPosition(self) -> b2Vec2

        Get the local position of this circle in its parent body.
        """
        return _Box2D.b2CircleShape_GetLocalPosition(self)

    def GetRadius(self):
        """
        GetRadius(self) -> float32

        Get the radius of this circle.
        """
        return _Box2D.b2CircleShape_GetRadius(self)

    def __repr__(self):
     return """b2CircleShape(
       density          = %s,
       filter           = %s,
       friction         = %s,
       localPosition    = %s,
       radius           = %s,
       restitution      = %s,
       userData         = %s,
       GetBody()        = %s,
       GetFilterData()  = %s,
       GetSweepRadius() = %s,
       GetType()        = %s,
       IsSensor()       = %s)"""% tuple(str(a) for a in\
      (self.density,self.filter,self.friction,self.localPosition,self.radius,self.restitution,self.userData,self.GetBody(),self.GetFilterData(),self.GetSweepRadius(),self.GetType(),self.IsSensor()))

    __getstate__=_generic_getstate
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize

    __eq__ = b2ShapeCompare
    __ne__ = lambda self,other: not b2ShapeCompare(self,other)
    radius = property(GetRadius, None)
    localPosition = property(GetLocalPosition, None)

    __swig_destroy__ = _Box2D.delete_b2CircleShape
b2CircleShape.GetLocalPosition = new_instancemethod(_Box2D.b2CircleShape_GetLocalPosition,None,b2CircleShape)
b2CircleShape.GetRadius = new_instancemethod(_Box2D.b2CircleShape_GetRadius,None,b2CircleShape)
b2CircleShape_swigregister = _Box2D.b2CircleShape_swigregister
b2CircleShape_swigregister(b2CircleShape)

class b2PolygonDef(b2ShapeDef):
    """Convex polygon. The vertices must be in CCW order for a right-handed coordinate system with the z-axis coming out of the screen."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2PolygonDef

        Convex polygon. The vertices must be in CCW order for a right-handed coordinate system with the z-axis coming out of the screen.
        """
        _Box2D.b2PolygonDef_swiginit(self,_Box2D.new_b2PolygonDef())
    def SetAsBox(self, *args):
        """
        SetAsBox(self, float32 hx, float32 hy)
        SetAsBox(self, float32 hx, float32 hy, b2Vec2 center, float32 angle)

        Build vertices to represent an oriented box.

        Parameters:
        -----------

        hx: the half-width.

        hy: the half-height.

        center: 
        the center of the box in local coordinates.

        angle: 
        the rotation of the box in local coordinates.
        """
        return _Box2D.b2PolygonDef_SetAsBox(self, *args)

    vertexCount = _swig_property(_Box2D.b2PolygonDef_vertexCount_get, _Box2D.b2PolygonDef_vertexCount_set)
    def __repr__(self):
     return """b2PolygonDef(
       density     = %s,
       filter      = %s,
       friction    = %s,
       isSensor    = %s,
       restitution = %s,
       type        = %s,
       userData    = %s,
       vertexCount = %s,
       vertices    = %s)"""% tuple(str(a) for a in\
      (self.density,self.filter,self.friction,self.isSensor,self.restitution,self.type,self.userData,self.vertexCount,self.vertices))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __repr__(self):
        return "b2PolygonDef(vertices: %s count: %d)" % (self.vertices, self.vertexCount)
    def checkValues(self):
        return b2CheckPolygonDef(self)
    def getVertices_tuple(self):
        """Returns all of the vertices as a list of tuples [ (x1,y1), (x2,y2) ... (xN,yN) ]"""
        vertices = []
        for i in range(0, self.vertexCount):
            vertices.append( (self.getVertex(i).x, self.getVertex(i).y ) )
        return vertices
    def getVertices_b2Vec2(self):
        """Returns all of the vertices as a list of b2Vec2's [ (x1,y1), (x2,y2) ... (xN,yN) ]"""
        vertices = []
        for i in range(0, self.vertexCount):
            vertices.append(self.getVertex(i))
        return vertices
    def setVertices(self, vertices):
        """Sets all of the vertices given a tuple 
            in the format ( (x1,y1), (x2,y2) ... (xN,yN) )
            where each vertex is a list/tuple/b2Vec2"""
        if len(vertices) > b2_maxPolygonVertices:
            raise ValueError()
        self.vertexCount = len(vertices)
        for i in range(0, self.vertexCount):
            self.setVertex(i, vertices[i]) # possible on pyBox2D >= r2.0.2b1
    setVertices_tuple = setVertices  # pre 202b1 compatibility
    setVertices_b2Vec2 = setVertices # pre 202b1 compatibility
    vertices = property(getVertices_tuple, setVertices)


    def getVertex(self, *args):
        """getVertex(self, uint16 vnum) -> b2Vec2"""
        return _Box2D.b2PolygonDef_getVertex(self, *args)

    def setVertex(self, *args):
        """
        setVertex(self, uint16 vnum, b2Vec2 value)
        setVertex(self, uint16 vnum, float32 x, float32 y)
        """
        return _Box2D.b2PolygonDef_setVertex(self, *args)

    __swig_destroy__ = _Box2D.delete_b2PolygonDef
b2PolygonDef.SetAsBox = new_instancemethod(_Box2D.b2PolygonDef_SetAsBox,None,b2PolygonDef)
b2PolygonDef.getVertex = new_instancemethod(_Box2D.b2PolygonDef_getVertex,None,b2PolygonDef)
b2PolygonDef.setVertex = new_instancemethod(_Box2D.b2PolygonDef_setVertex,None,b2PolygonDef)
b2PolygonDef_swigregister = _Box2D.b2PolygonDef_swigregister
b2PolygonDef_swigregister(b2PolygonDef)

class b2PolygonShape(b2Shape):
    """A convex polygon."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def GetOBB(self):
        """
        GetOBB(self) -> b2OBB

        Get the oriented bounding box relative to the parent body.
        """
        return _Box2D.b2PolygonShape_GetOBB(self)

    def GetCentroid(self):
        """
        GetCentroid(self) -> b2Vec2

        Get local centroid relative to the parent body.
        """
        return _Box2D.b2PolygonShape_GetCentroid(self)

    def GetVertexCount(self):
        """
        GetVertexCount(self) -> int32

        Get the vertex count.
        """
        return _Box2D.b2PolygonShape_GetVertexCount(self)

    def GetCoreVertices(self):
        """
        GetCoreVertices(self) -> b2Vec2

        Get the core vertices in local coordinates. These vertices represent a smaller polygon that is used for time of impact computations.
        """
        return _Box2D.b2PolygonShape_GetCoreVertices(self)

    def GetFirstVertex(self, *args):
        """
        GetFirstVertex(self, b2XForm xf) -> b2Vec2

        Get the first vertex and apply the supplied transform.
        """
        return _Box2D.b2PolygonShape_GetFirstVertex(self, *args)

    def Centroid(self, *args):
        """
        Centroid(self, b2XForm xf) -> b2Vec2

        Get the centroid and apply the supplied transform.
        """
        return _Box2D.b2PolygonShape_Centroid(self, *args)

    def Support(self, *args):
        """
        Support(self, b2XForm xf, b2Vec2 d) -> b2Vec2

        Get the support point in the given world direction. Use the supplied transform.
        """
        return _Box2D.b2PolygonShape_Support(self, *args)

    def __repr__(self):
     return """b2PolygonShape(
       coreVertices     = %s,
       density          = %s,
       filter           = %s,
       friction         = %s,
       normals          = %s,
       restitution      = %s,
       userData         = %s,
       vertices         = %s,
       GetBody()        = %s,
       GetCentroid()    = %s,
       GetFilterData()  = %s,
       GetOBB()         = %s,
       GetSweepRadius() = %s,
       GetType()        = %s,
       GetVertexCount() = %s,
       IsSensor()       = %s)"""% tuple(str(a) for a in\
      (self.coreVertices,self.density,self.filter,self.friction,self.normals,self.restitution,self.userData,self.vertices,self.GetBody(),self.GetCentroid(),self.GetFilterData(),self.GetOBB(),self.GetSweepRadius(),self.GetType(),self.GetVertexCount(),self.IsSensor()))

    __getstate__=_generic_getstate
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize

    __eq__ = b2ShapeCompare
    __ne__ = lambda self,other: not b2ShapeCompare(self,other)
    def __repr__(self):
        return "b2PolygonShape(vertices: %s count: %d)" % (self.getVertices_tuple(), self.GetVertexCount())
    def getCoreVertices_tuple(self):
        """Returns all of the core vertices as a list of tuples [ (x1,y1), (x2,y2) ... (xN,yN) ]"""
        vertices = []
        for i in range(0, self.GetVertexCount()):
            vertices.append( (self.getCoreVertex(i).x, self.getCoreVertex(i).y ) )
        return vertices
    def getCoreVertices_b2Vec2(self):
        """Returns all of the core vertices as a list of b2Vec2's [ (x1,y1), (x2,y2) ... (xN,yN) ]"""
        vertices = []
        for i in range(0, self.GetVertexCount()):
            vertices.append(self.getCoreVertex(i))
        return vertices
    def getVertices_tuple(self):
        """Returns all of the vertices as a list of tuples [ (x1,y1), (x2,y2) ... (xN,yN) ]"""
        vertices = []
        for i in range(0, self.GetVertexCount()):
            vertices.append( (self.getVertex(i).x, self.getVertex(i).y ) )
        return vertices
    def getVertices_b2Vec2(self):
        """Returns all of the vertices as a list of b2Vec2's [ (x1,y1), (x2,y2) ... (xN,yN) ]"""
        vertices = []
        for i in range(0, self.GetVertexCount()):
            vertices.append(self.getVertex(i))
        return vertices
    def getNormals_tuple(self):
        """Returns all of the normals as a list of tuples [ (x1,y1), (x2,y2) ... (xN,yN) ]"""
        vertices = []
        for i in range(0, self.GetVertexCount()):
            vertices.append( (self.getNormal(i).x, self.getNormal(i).y ) )
        return vertices
    def getNormals_b2Vec2(self):
        """Returns all of the normals as a list of b2Vec2's [ (x1,y1), (x2,y2) ... (xN,yN) ]"""
        vertices = []
        for i in range(0, self.GetVertexCount()):
            vertices.append(self.getNormal(i))
        return vertices
    def __iter__(self):
        """
        Iterates over the vertices in the polygon
        """
        for v in self.vertices:
            yield v

    vertices = property(getVertices_tuple, None)
    coreVertices = property(getCoreVertices_tuple, None)
    normals = property(getNormals_tuple, None)

    def getVertex(self, *args):
        """getVertex(self, uint16 vnum) -> b2Vec2"""
        return _Box2D.b2PolygonShape_getVertex(self, *args)

    def getCoreVertex(self, *args):
        """getCoreVertex(self, uint16 vnum) -> b2Vec2"""
        return _Box2D.b2PolygonShape_getCoreVertex(self, *args)

    def getNormal(self, *args):
        """getNormal(self, uint16 vnum) -> b2Vec2"""
        return _Box2D.b2PolygonShape_getNormal(self, *args)

    __swig_destroy__ = _Box2D.delete_b2PolygonShape
b2PolygonShape.GetOBB = new_instancemethod(_Box2D.b2PolygonShape_GetOBB,None,b2PolygonShape)
b2PolygonShape.GetCentroid = new_instancemethod(_Box2D.b2PolygonShape_GetCentroid,None,b2PolygonShape)
b2PolygonShape.GetVertexCount = new_instancemethod(_Box2D.b2PolygonShape_GetVertexCount,None,b2PolygonShape)
b2PolygonShape.GetCoreVertices = new_instancemethod(_Box2D.b2PolygonShape_GetCoreVertices,None,b2PolygonShape)
b2PolygonShape.GetFirstVertex = new_instancemethod(_Box2D.b2PolygonShape_GetFirstVertex,None,b2PolygonShape)
b2PolygonShape.Centroid = new_instancemethod(_Box2D.b2PolygonShape_Centroid,None,b2PolygonShape)
b2PolygonShape.Support = new_instancemethod(_Box2D.b2PolygonShape_Support,None,b2PolygonShape)
b2PolygonShape.getVertex = new_instancemethod(_Box2D.b2PolygonShape_getVertex,None,b2PolygonShape)
b2PolygonShape.getCoreVertex = new_instancemethod(_Box2D.b2PolygonShape_getCoreVertex,None,b2PolygonShape)
b2PolygonShape.getNormal = new_instancemethod(_Box2D.b2PolygonShape_getNormal,None,b2PolygonShape)
b2PolygonShape_swigregister = _Box2D.b2PolygonShape_swigregister
b2PolygonShape_swigregister(b2PolygonShape)

class b2EdgeChainDef(b2ShapeDef):
    """This structure is used to build edge shapes."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2EdgeChainDef

        This structure is used to build edge shapes.
        """
        _Box2D.b2EdgeChainDef_swiginit(self,_Box2D.new_b2EdgeChainDef())
    vertexCount = _swig_property(_Box2D.b2EdgeChainDef_vertexCount_get, _Box2D.b2EdgeChainDef_vertexCount_set)
    isALoop = _swig_property(_Box2D.b2EdgeChainDef_isALoop_get, _Box2D.b2EdgeChainDef_isALoop_set)
    def __repr__(self):
     return """b2EdgeChainDef(
       density     = %s,
       filter      = %s,
       friction    = %s,
       isALoop     = %s,
       isSensor    = %s,
       restitution = %s,
       type        = %s,
       userData    = %s,
       vertexCount = %s,
       vertices    = %s)"""% tuple(str(a) for a in\
      (self.density,self.filter,self.friction,self.isALoop,self.isSensor,self.restitution,self.type,self.userData,self.vertexCount,self.vertices))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __repr__(self):
        return "b2EdgeDef(vertices: %s count: %d)" % (self.getVertices_tuple(), self.vertexCount)
    def __del__(self):
        """Cleans up by freeing the allocated vertex array"""
        super(b2EdgeChainDef, self).__del__()
        self._cleanUp()
    def getVertices_tuple(self):
        """Returns all of the vertices as a list of tuples [ (x1,y1), (x2,y2) ... (xN,yN) ]"""
        vertices = []
        for i in range(0, self.vertexCount):
            vertices.append( (self.getVertex(i).x, self.getVertex(i).y ) )
        return vertices
    def getVertices_b2Vec2(self):
        """Returns all of the vertices as a list of b2Vec2's [ (x1,y1), (x2,y2) ... (xN,yN) ]"""
        vertices = []
        for i in range(0, self.vertexCount):
            vertices.append(self.getVertex(i))
        return vertices
    def setVertices(self, vertices):
        """Sets all of the vertices given a tuple 
            in the format ( (x1,y1), (x2,y2) ... (xN,yN) )
            where each vertex is either a list/tuple/b2Vec2"""
        self._allocateVertices(len(vertices))
        for i in range(0, self.vertexCount):
            self.setVertex(i, vertices[i])
    setVertices_tuple = setVertices  # pre 202b1 compatibility
    setVertices_b2Vec2 = setVertices # pre 202b1 compatibility
    vertices = property(getVertices_tuple, setVertices)


    def _cleanUp(self):
        """_cleanUp(self)"""
        return _Box2D.b2EdgeChainDef__cleanUp(self)

    def _allocateVertices(self, *args):
        """_allocateVertices(self, uint16 _count)"""
        return _Box2D.b2EdgeChainDef__allocateVertices(self, *args)

    def getVertex(self, *args):
        """getVertex(self, uint16 vnum) -> b2Vec2"""
        return _Box2D.b2EdgeChainDef_getVertex(self, *args)

    def setVertex(self, *args):
        """
        setVertex(self, uint16 vnum, b2Vec2 value)
        setVertex(self, uint16 vnum, float32 x, float32 y)
        """
        return _Box2D.b2EdgeChainDef_setVertex(self, *args)

    __swig_destroy__ = _Box2D.delete_b2EdgeChainDef
b2EdgeChainDef._cleanUp = new_instancemethod(_Box2D.b2EdgeChainDef__cleanUp,None,b2EdgeChainDef)
b2EdgeChainDef._allocateVertices = new_instancemethod(_Box2D.b2EdgeChainDef__allocateVertices,None,b2EdgeChainDef)
b2EdgeChainDef.getVertex = new_instancemethod(_Box2D.b2EdgeChainDef_getVertex,None,b2EdgeChainDef)
b2EdgeChainDef.setVertex = new_instancemethod(_Box2D.b2EdgeChainDef_setVertex,None,b2EdgeChainDef)
b2EdgeChainDef_swigregister = _Box2D.b2EdgeChainDef_swigregister
b2EdgeChainDef_swigregister(b2EdgeChainDef)

class b2EdgeShape(b2Shape):
    """The edge shape."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def GetLength(self):
        """
        GetLength(self) -> float32

        Linear distance from vertex1 to vertex2:.
        """
        return _Box2D.b2EdgeShape_GetLength(self)

    def GetVertex1(self):
        """
        GetVertex1(self) -> b2Vec2

        Local position of vertex in parent body.
        """
        return _Box2D.b2EdgeShape_GetVertex1(self)

    def GetVertex2(self):
        """
        GetVertex2(self) -> b2Vec2

        Local position of vertex in parent body.
        """
        return _Box2D.b2EdgeShape_GetVertex2(self)

    def GetCoreVertex1(self):
        """
        GetCoreVertex1(self) -> b2Vec2

        "Core" vertex with TOI slop for b2Distance functions:
        """
        return _Box2D.b2EdgeShape_GetCoreVertex1(self)

    def GetCoreVertex2(self):
        """
        GetCoreVertex2(self) -> b2Vec2

        "Core" vertex with TOI slop for b2Distance functions:
        """
        return _Box2D.b2EdgeShape_GetCoreVertex2(self)

    def GetNormalVector(self):
        """
        GetNormalVector(self) -> b2Vec2

        Perpendicular unit vector point, pointing from the solid side to the empty side:.
        """
        return _Box2D.b2EdgeShape_GetNormalVector(self)

    def GetDirectionVector(self):
        """
        GetDirectionVector(self) -> b2Vec2

        Parallel unit vector, pointing from vertex1 to vertex2:.
        """
        return _Box2D.b2EdgeShape_GetDirectionVector(self)

    def GetCorner1Vector(self):
        """GetCorner1Vector(self) -> b2Vec2"""
        return _Box2D.b2EdgeShape_GetCorner1Vector(self)

    def GetCorner2Vector(self):
        """GetCorner2Vector(self) -> b2Vec2"""
        return _Box2D.b2EdgeShape_GetCorner2Vector(self)

    def Corner1IsConvex(self):
        """Corner1IsConvex(self) -> bool"""
        return _Box2D.b2EdgeShape_Corner1IsConvex(self)

    def Corner2IsConvex(self):
        """Corner2IsConvex(self) -> bool"""
        return _Box2D.b2EdgeShape_Corner2IsConvex(self)

    def GetFirstVertex(self, *args):
        """GetFirstVertex(self, b2XForm xf) -> b2Vec2"""
        return _Box2D.b2EdgeShape_GetFirstVertex(self, *args)

    def Support(self, *args):
        """Support(self, b2XForm xf, b2Vec2 d) -> b2Vec2"""
        return _Box2D.b2EdgeShape_Support(self, *args)

    def GetNextEdge(self):
        """
        GetNextEdge(self) -> b2EdgeShape

        Get the next edge in the chain.
        """
        return _Box2D.b2EdgeShape_GetNextEdge(self)

    def GetPrevEdge(self):
        """
        GetPrevEdge(self) -> b2EdgeShape

        Get the previous edge in the chain.
        """
        return _Box2D.b2EdgeShape_GetPrevEdge(self)

    def SetPrevEdge(self, *args):
        """SetPrevEdge(self, b2EdgeShape edge, b2Vec2 core, b2Vec2 cornerDir, bool convex)"""
        return _Box2D.b2EdgeShape_SetPrevEdge(self, *args)

    def SetNextEdge(self, *args):
        """SetNextEdge(self, b2EdgeShape edge, b2Vec2 core, b2Vec2 cornerDir, bool convex)"""
        return _Box2D.b2EdgeShape_SetNextEdge(self, *args)

    def __repr__(self):
     return """b2EdgeShape(
       density              = %s,
       filter               = %s,
       friction             = %s,
       restitution          = %s,
       userData             = %s,
       GetBody()            = %s,
       GetCoreVertex1()     = %s,
       GetCoreVertex2()     = %s,
       GetCorner1Vector()   = %s,
       GetCorner2Vector()   = %s,
       GetDirectionVector() = %s,
       GetFilterData()      = %s,
       GetLength()          = %s,
       GetNormalVector()    = %s,
       GetSweepRadius()     = %s,
       GetType()            = %s,
       GetVertex1()         = %s,
       GetVertex2()         = %s,
       IsSensor()           = %s)"""% tuple(str(a) for a in\
      (self.density,self.filter,self.friction,self.restitution,self.userData,self.GetBody(),self.GetCoreVertex1(),self.GetCoreVertex2(),self.GetCorner1Vector(),self.GetCorner2Vector(),self.GetDirectionVector(),self.GetFilterData(),self.GetLength(),self.GetNormalVector(),self.GetSweepRadius(),self.GetType(),self.GetVertex1(),self.GetVertex2(),self.IsSensor()))

    __getstate__=_generic_getstate
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize

    def GetVertices(self):
        vertices = []
        edge = self
        while edge:
            vertices.append( edge.vertex1 )
            last = edge.vertex2
            edge=edge.next
            if edge==self: # a loop
                vertices.extend( [edge.vertex1, edge.vertex2] )
                return vertices
        vertices.append( last )
        return vertices

    length      = property(GetLength,      None)
    vertex1     = property(GetVertex1,     None)
    vertex2     = property(GetVertex2,     None)
    coreVertex1 = property(GetCoreVertex1, None)
    coreVertex2 = property(GetCoreVertex2, None)
    next        = property(GetNextEdge,    None)
    prev        = property(GetPrevEdge,    None)

    __swig_destroy__ = _Box2D.delete_b2EdgeShape
b2EdgeShape.GetLength = new_instancemethod(_Box2D.b2EdgeShape_GetLength,None,b2EdgeShape)
b2EdgeShape.GetVertex1 = new_instancemethod(_Box2D.b2EdgeShape_GetVertex1,None,b2EdgeShape)
b2EdgeShape.GetVertex2 = new_instancemethod(_Box2D.b2EdgeShape_GetVertex2,None,b2EdgeShape)
b2EdgeShape.GetCoreVertex1 = new_instancemethod(_Box2D.b2EdgeShape_GetCoreVertex1,None,b2EdgeShape)
b2EdgeShape.GetCoreVertex2 = new_instancemethod(_Box2D.b2EdgeShape_GetCoreVertex2,None,b2EdgeShape)
b2EdgeShape.GetNormalVector = new_instancemethod(_Box2D.b2EdgeShape_GetNormalVector,None,b2EdgeShape)
b2EdgeShape.GetDirectionVector = new_instancemethod(_Box2D.b2EdgeShape_GetDirectionVector,None,b2EdgeShape)
b2EdgeShape.GetCorner1Vector = new_instancemethod(_Box2D.b2EdgeShape_GetCorner1Vector,None,b2EdgeShape)
b2EdgeShape.GetCorner2Vector = new_instancemethod(_Box2D.b2EdgeShape_GetCorner2Vector,None,b2EdgeShape)
b2EdgeShape.Corner1IsConvex = new_instancemethod(_Box2D.b2EdgeShape_Corner1IsConvex,None,b2EdgeShape)
b2EdgeShape.Corner2IsConvex = new_instancemethod(_Box2D.b2EdgeShape_Corner2IsConvex,None,b2EdgeShape)
b2EdgeShape.GetFirstVertex = new_instancemethod(_Box2D.b2EdgeShape_GetFirstVertex,None,b2EdgeShape)
b2EdgeShape.Support = new_instancemethod(_Box2D.b2EdgeShape_Support,None,b2EdgeShape)
b2EdgeShape.GetNextEdge = new_instancemethod(_Box2D.b2EdgeShape_GetNextEdge,None,b2EdgeShape)
b2EdgeShape.GetPrevEdge = new_instancemethod(_Box2D.b2EdgeShape_GetPrevEdge,None,b2EdgeShape)
b2EdgeShape.SetPrevEdge = new_instancemethod(_Box2D.b2EdgeShape_SetPrevEdge,None,b2EdgeShape)
b2EdgeShape.SetNextEdge = new_instancemethod(_Box2D.b2EdgeShape_SetNextEdge,None,b2EdgeShape)
b2EdgeShape_swigregister = _Box2D.b2EdgeShape_swigregister
b2EdgeShape_swigregister(b2EdgeShape)

class b2Pair(object):
    """Proxy of C++ b2Pair class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    e_pairBuffered = _Box2D.b2Pair_e_pairBuffered
    e_pairRemoved = _Box2D.b2Pair_e_pairRemoved
    e_pairFinal = _Box2D.b2Pair_e_pairFinal
    def SetBuffered(self):
        """SetBuffered(self)"""
        return _Box2D.b2Pair_SetBuffered(self)

    def ClearBuffered(self):
        """ClearBuffered(self)"""
        return _Box2D.b2Pair_ClearBuffered(self)

    def IsBuffered(self):
        """IsBuffered(self) -> bool"""
        return _Box2D.b2Pair_IsBuffered(self)

    def SetRemoved(self):
        """SetRemoved(self)"""
        return _Box2D.b2Pair_SetRemoved(self)

    def ClearRemoved(self):
        """ClearRemoved(self)"""
        return _Box2D.b2Pair_ClearRemoved(self)

    def IsRemoved(self):
        """IsRemoved(self) -> bool"""
        return _Box2D.b2Pair_IsRemoved(self)

    def SetFinal(self):
        """SetFinal(self)"""
        return _Box2D.b2Pair_SetFinal(self)

    def IsFinal(self):
        """IsFinal(self) -> bool"""
        return _Box2D.b2Pair_IsFinal(self)

    proxyId1 = _swig_property(_Box2D.b2Pair_proxyId1_get, _Box2D.b2Pair_proxyId1_set)
    proxyId2 = _swig_property(_Box2D.b2Pair_proxyId2_get, _Box2D.b2Pair_proxyId2_set)
    next = _swig_property(_Box2D.b2Pair_next_get, _Box2D.b2Pair_next_set)
    status = _swig_property(_Box2D.b2Pair_status_get, _Box2D.b2Pair_status_set)
    def __repr__(self):
     return """b2Pair(
       proxyId1       = %s,
       proxyId2       = %s,
       status         = %s,
       userData       = %s,
       IsBuffered()   = %s,
       IsFinal()      = %s,
       IsRemoved()    = %s,
       e_pairBuffered = %s,
       e_pairFinal    = %s,
       e_pairRemoved  = %s)"""% tuple(str(a) for a in\
      (self.proxyId1,self.proxyId2,self.status,self.userData,self.IsBuffered(),self.IsFinal(),self.IsRemoved(),self.e_pairBuffered,self.e_pairFinal,self.e_pairRemoved))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2Pair"""
        _Box2D.b2Pair_swiginit(self,_Box2D.new_b2Pair())
    __swig_destroy__ = _Box2D.delete_b2Pair
b2Pair.SetBuffered = new_instancemethod(_Box2D.b2Pair_SetBuffered,None,b2Pair)
b2Pair.ClearBuffered = new_instancemethod(_Box2D.b2Pair_ClearBuffered,None,b2Pair)
b2Pair.IsBuffered = new_instancemethod(_Box2D.b2Pair_IsBuffered,None,b2Pair)
b2Pair.SetRemoved = new_instancemethod(_Box2D.b2Pair_SetRemoved,None,b2Pair)
b2Pair.ClearRemoved = new_instancemethod(_Box2D.b2Pair_ClearRemoved,None,b2Pair)
b2Pair.IsRemoved = new_instancemethod(_Box2D.b2Pair_IsRemoved,None,b2Pair)
b2Pair.SetFinal = new_instancemethod(_Box2D.b2Pair_SetFinal,None,b2Pair)
b2Pair.IsFinal = new_instancemethod(_Box2D.b2Pair_IsFinal,None,b2Pair)
b2Pair_swigregister = _Box2D.b2Pair_swigregister
b2Pair_swigregister(b2Pair)
b2_nullPair = cvar.b2_nullPair
b2_nullProxy = cvar.b2_nullProxy
b2_tableCapacity = cvar.b2_tableCapacity
b2_tableMask = cvar.b2_tableMask

class b2BufferedPair(object):
    """Proxy of C++ b2BufferedPair class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    proxyId1 = _swig_property(_Box2D.b2BufferedPair_proxyId1_get, _Box2D.b2BufferedPair_proxyId1_set)
    proxyId2 = _swig_property(_Box2D.b2BufferedPair_proxyId2_get, _Box2D.b2BufferedPair_proxyId2_set)
    def __repr__(self):
     return """b2BufferedPair(
       proxyId1 = %s,
       proxyId2 = %s)"""% tuple(str(a) for a in\
      (self.proxyId1,self.proxyId2))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2BufferedPair"""
        _Box2D.b2BufferedPair_swiginit(self,_Box2D.new_b2BufferedPair())
    __swig_destroy__ = _Box2D.delete_b2BufferedPair
b2BufferedPair_swigregister = _Box2D.b2BufferedPair_swigregister
b2BufferedPair_swigregister(b2BufferedPair)

class b2PairCallback(object):
    """Proxy of C++ b2PairCallback class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Box2D.delete_b2PairCallback
    def PairAdded(self, *args):
        """PairAdded(self, void proxyUserData1, void proxyUserData2) -> void"""
        return _Box2D.b2PairCallback_PairAdded(self, *args)

    def PairRemoved(self, *args):
        """PairRemoved(self, void proxyUserData1, void proxyUserData2, void pairUserData)"""
        return _Box2D.b2PairCallback_PairRemoved(self, *args)

    def __repr__(self):
     return "b2PairCallback()"

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

b2PairCallback.PairAdded = new_instancemethod(_Box2D.b2PairCallback_PairAdded,None,b2PairCallback)
b2PairCallback.PairRemoved = new_instancemethod(_Box2D.b2PairCallback_PairRemoved,None,b2PairCallback)
b2PairCallback_swigregister = _Box2D.b2PairCallback_swigregister
b2PairCallback_swigregister(b2PairCallback)

class b2PairManager(object):
    """Proxy of C++ b2PairManager class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> b2PairManager"""
        _Box2D.b2PairManager_swiginit(self,_Box2D.new_b2PairManager())
    def Initialize(self, *args):
        """Initialize(self, b2BroadPhase broadPhase, b2PairCallback callback)"""
        return _Box2D.b2PairManager_Initialize(self, *args)

    def AddBufferedPair(self, *args):
        """AddBufferedPair(self, int32 proxyId1, int32 proxyId2)"""
        return _Box2D.b2PairManager_AddBufferedPair(self, *args)

    def RemoveBufferedPair(self, *args):
        """RemoveBufferedPair(self, int32 proxyId1, int32 proxyId2)"""
        return _Box2D.b2PairManager_RemoveBufferedPair(self, *args)

    def Commit(self):
        """Commit(self)"""
        return _Box2D.b2PairManager_Commit(self)

    broadPhase = _swig_property(_Box2D.b2PairManager_broadPhase_get, _Box2D.b2PairManager_broadPhase_set)
    callback = _swig_property(_Box2D.b2PairManager_callback_get, _Box2D.b2PairManager_callback_set)
    pairs = _swig_property(_Box2D.b2PairManager_pairs_get, _Box2D.b2PairManager_pairs_set)
    freePair = _swig_property(_Box2D.b2PairManager_freePair_get, _Box2D.b2PairManager_freePair_set)
    pairCount = _swig_property(_Box2D.b2PairManager_pairCount_get, _Box2D.b2PairManager_pairCount_set)
    pairBuffer = _swig_property(_Box2D.b2PairManager_pairBuffer_get, _Box2D.b2PairManager_pairBuffer_set)
    pairBufferCount = _swig_property(_Box2D.b2PairManager_pairBufferCount_get, _Box2D.b2PairManager_pairBufferCount_set)
    hashTable = _swig_property(_Box2D.b2PairManager_hashTable_get, _Box2D.b2PairManager_hashTable_set)
    def __repr__(self):
     return """b2PairManager(
       broadPhase      = %s,
       callback        = %s,
       freePair        = %s,
       hashTable       = %s,
       pairBuffer      = %s,
       pairBufferCount = %s,
       pairCount       = %s,
       pairs           = %s)"""% tuple(str(a) for a in\
      (self.broadPhase,self.callback,self.freePair,self.hashTable,self.pairBuffer,self.pairBufferCount,self.pairCount,self.pairs))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2PairManager
b2PairManager.Initialize = new_instancemethod(_Box2D.b2PairManager_Initialize,None,b2PairManager)
b2PairManager.AddBufferedPair = new_instancemethod(_Box2D.b2PairManager_AddBufferedPair,None,b2PairManager)
b2PairManager.RemoveBufferedPair = new_instancemethod(_Box2D.b2PairManager_RemoveBufferedPair,None,b2PairManager)
b2PairManager.Commit = new_instancemethod(_Box2D.b2PairManager_Commit,None,b2PairManager)
b2PairManager_swigregister = _Box2D.b2PairManager_swigregister
b2PairManager_swigregister(b2PairManager)

class b2Bound(object):
    """Proxy of C++ b2Bound class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def IsLower(self):
        """IsLower(self) -> bool"""
        return _Box2D.b2Bound_IsLower(self)

    def IsUpper(self):
        """IsUpper(self) -> bool"""
        return _Box2D.b2Bound_IsUpper(self)

    value = _swig_property(_Box2D.b2Bound_value_get, _Box2D.b2Bound_value_set)
    proxyId = _swig_property(_Box2D.b2Bound_proxyId_get, _Box2D.b2Bound_proxyId_set)
    stabbingCount = _swig_property(_Box2D.b2Bound_stabbingCount_get, _Box2D.b2Bound_stabbingCount_set)
    def __repr__(self):
     return """b2Bound(
       proxyId       = %s,
       stabbingCount = %s,
       value         = %s,
       IsLower()     = %s,
       IsUpper()     = %s)"""% tuple(str(a) for a in\
      (self.proxyId,self.stabbingCount,self.value,self.IsLower(),self.IsUpper()))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2Bound"""
        _Box2D.b2Bound_swiginit(self,_Box2D.new_b2Bound())
    __swig_destroy__ = _Box2D.delete_b2Bound
b2Bound.IsLower = new_instancemethod(_Box2D.b2Bound_IsLower,None,b2Bound)
b2Bound.IsUpper = new_instancemethod(_Box2D.b2Bound_IsUpper,None,b2Bound)
b2Bound_swigregister = _Box2D.b2Bound_swigregister
b2Bound_swigregister(b2Bound)
b2_invalid = cvar.b2_invalid
b2_nullEdge = cvar.b2_nullEdge

class b2Proxy(object):
    """Proxy of C++ b2Proxy class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def GetNext(self):
        """GetNext(self) -> uint16"""
        return _Box2D.b2Proxy_GetNext(self)

    def SetNext(self, *args):
        """SetNext(self, uint16 next)"""
        return _Box2D.b2Proxy_SetNext(self, *args)

    def IsValid(self):
        """IsValid(self) -> bool"""
        return _Box2D.b2Proxy_IsValid(self)

    lowerBounds = _swig_property(_Box2D.b2Proxy_lowerBounds_get, _Box2D.b2Proxy_lowerBounds_set)
    upperBounds = _swig_property(_Box2D.b2Proxy_upperBounds_get, _Box2D.b2Proxy_upperBounds_set)
    overlapCount = _swig_property(_Box2D.b2Proxy_overlapCount_get, _Box2D.b2Proxy_overlapCount_set)
    timeStamp = _swig_property(_Box2D.b2Proxy_timeStamp_get, _Box2D.b2Proxy_timeStamp_set)
    def __repr__(self):
     return """b2Proxy(
       lowerBounds  = %s,
       overlapCount = %s,
       timeStamp    = %s,
       upperBounds  = %s,
       userData     = %s,
       IsValid()    = %s)"""% tuple(str(a) for a in\
      (self.lowerBounds,self.overlapCount,self.timeStamp,self.upperBounds,self.userData,self.IsValid()))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2Proxy"""
        _Box2D.b2Proxy_swiginit(self,_Box2D.new_b2Proxy())
    __swig_destroy__ = _Box2D.delete_b2Proxy
b2Proxy.GetNext = new_instancemethod(_Box2D.b2Proxy_GetNext,None,b2Proxy)
b2Proxy.SetNext = new_instancemethod(_Box2D.b2Proxy_SetNext,None,b2Proxy)
b2Proxy.IsValid = new_instancemethod(_Box2D.b2Proxy_IsValid,None,b2Proxy)
b2Proxy_swigregister = _Box2D.b2Proxy_swigregister
b2Proxy_swigregister(b2Proxy)

class b2BroadPhase(object):
    """Proxy of C++ b2BroadPhase class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, b2AABB worldAABB, b2PairCallback callback) -> b2BroadPhase"""
        _Box2D.b2BroadPhase_swiginit(self,_Box2D.new_b2BroadPhase(*args))
    __swig_destroy__ = _Box2D.delete_b2BroadPhase
    def InRange(self, *args):
        """InRange(self, b2AABB aabb) -> bool"""
        return _Box2D.b2BroadPhase_InRange(self, *args)

    def CreateProxy(self, *args):
        """CreateProxy(self, b2AABB aabb, void $ignore) -> uint16"""
        return _Box2D.b2BroadPhase_CreateProxy(self, *args)

    def DestroyProxy(self, *args):
        """DestroyProxy(self, int32 proxyId)"""
        return _Box2D.b2BroadPhase_DestroyProxy(self, *args)

    def MoveProxy(self, *args):
        """MoveProxy(self, int32 proxyId, b2AABB aabb)"""
        return _Box2D.b2BroadPhase_MoveProxy(self, *args)

    def Commit(self):
        """Commit(self)"""
        return _Box2D.b2BroadPhase_Commit(self)

    def GetProxy(self, *args):
        """GetProxy(self, int32 proxyId) -> b2Proxy"""
        return _Box2D.b2BroadPhase_GetProxy(self, *args)

    def Query(self, *args):
        """Query(self, b2AABB aabb, void $ignore, int32 maxCount) -> int32"""
        return _Box2D.b2BroadPhase_Query(self, *args)

    def QuerySegment(self, *args):
        """QuerySegment(self, b2Segment segment, void $ignore, int32 maxCount, SortKeyFunc sortKey) -> int32"""
        return _Box2D.b2BroadPhase_QuerySegment(self, *args)

    def Validate(self):
        """Validate(self)"""
        return _Box2D.b2BroadPhase_Validate(self)

    def ValidatePairs(self):
        """ValidatePairs(self)"""
        return _Box2D.b2BroadPhase_ValidatePairs(self)

    pairManager = _swig_property(_Box2D.b2BroadPhase_pairManager_get, _Box2D.b2BroadPhase_pairManager_set)
    proxyPool = _swig_property(_Box2D.b2BroadPhase_proxyPool_get, _Box2D.b2BroadPhase_proxyPool_set)
    freeProxy = _swig_property(_Box2D.b2BroadPhase_freeProxy_get, _Box2D.b2BroadPhase_freeProxy_set)
    bounds = _swig_property(_Box2D.b2BroadPhase_bounds_get, _Box2D.b2BroadPhase_bounds_set)
    queryResults = _swig_property(_Box2D.b2BroadPhase_queryResults_get, _Box2D.b2BroadPhase_queryResults_set)
    querySortKeys = _swig_property(_Box2D.b2BroadPhase_querySortKeys_get, _Box2D.b2BroadPhase_querySortKeys_set)
    queryResultCount = _swig_property(_Box2D.b2BroadPhase_queryResultCount_get, _Box2D.b2BroadPhase_queryResultCount_set)
    worldAABB = _swig_property(_Box2D.b2BroadPhase_worldAABB_get, _Box2D.b2BroadPhase_worldAABB_set)
    quantizationFactor = _swig_property(_Box2D.b2BroadPhase_quantizationFactor_get, _Box2D.b2BroadPhase_quantizationFactor_set)
    proxyCount = _swig_property(_Box2D.b2BroadPhase_proxyCount_get, _Box2D.b2BroadPhase_proxyCount_set)
    timeStamp = _swig_property(_Box2D.b2BroadPhase_timeStamp_get, _Box2D.b2BroadPhase_timeStamp_set)
    s_validate = _swig_property(_Box2D.b2BroadPhase_s_validate_get, _Box2D.b2BroadPhase_s_validate_set)
    def __repr__(self):
     return """b2BroadPhase(
       bounds             = %s,
       freeProxy          = %s,
       pairManager        = %s,
       proxyCount         = %s,
       proxyPool          = %s,
       quantizationFactor = %s,
       queryResultCount   = %s,
       queryResults       = %s,
       querySortKeys      = %s,
       s_validate         = %s,
       timeStamp          = %s,
       worldAABB          = %s)"""% tuple(str(a) for a in\
      (self.bounds,self.freeProxy,self.pairManager,self.proxyCount,self.proxyPool,self.quantizationFactor,self.queryResultCount,self.queryResults,self.querySortKeys,self.s_validate,self.timeStamp,self.worldAABB))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

b2BroadPhase.InRange = new_instancemethod(_Box2D.b2BroadPhase_InRange,None,b2BroadPhase)
b2BroadPhase.CreateProxy = new_instancemethod(_Box2D.b2BroadPhase_CreateProxy,None,b2BroadPhase)
b2BroadPhase.DestroyProxy = new_instancemethod(_Box2D.b2BroadPhase_DestroyProxy,None,b2BroadPhase)
b2BroadPhase.MoveProxy = new_instancemethod(_Box2D.b2BroadPhase_MoveProxy,None,b2BroadPhase)
b2BroadPhase.Commit = new_instancemethod(_Box2D.b2BroadPhase_Commit,None,b2BroadPhase)
b2BroadPhase.GetProxy = new_instancemethod(_Box2D.b2BroadPhase_GetProxy,None,b2BroadPhase)
b2BroadPhase.Query = new_instancemethod(_Box2D.b2BroadPhase_Query,None,b2BroadPhase)
b2BroadPhase.QuerySegment = new_instancemethod(_Box2D.b2BroadPhase_QuerySegment,None,b2BroadPhase)
b2BroadPhase.Validate = new_instancemethod(_Box2D.b2BroadPhase_Validate,None,b2BroadPhase)
b2BroadPhase.ValidatePairs = new_instancemethod(_Box2D.b2BroadPhase_ValidatePairs,None,b2BroadPhase)
b2BroadPhase_swigregister = _Box2D.b2BroadPhase_swigregister
b2BroadPhase_swigregister(b2BroadPhase)

class b2DestructionListener(object):
    """Joints and shapes are destroyed when their associated body is destroyed. Implement this listener so that you may nullify references to these joints and shapes."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    __swig_destroy__ = _Box2D.delete_b2DestructionListener
    def SayGoodbye(self, *args):
        """
        SayGoodbye(self, b2Joint joint)
        SayGoodbye(self, b2Shape shape)

        Called when any shape is about to be destroyed due to the destruction of its parent body.
        """
        return _Box2D.b2DestructionListener_SayGoodbye(self, *args)

    def __repr__(self):
     return "b2DestructionListener()"

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2DestructionListener"""
        if self.__class__ == b2DestructionListener:
            _self = None
        else:
            _self = self
        _Box2D.b2DestructionListener_swiginit(self,_Box2D.new_b2DestructionListener(_self, ))
    def __disown__(self):
        self.this.disown()
        _Box2D.disown_b2DestructionListener(self)
        return weakref_proxy(self)
b2DestructionListener.SayGoodbye = new_instancemethod(_Box2D.b2DestructionListener_SayGoodbye,None,b2DestructionListener)
b2DestructionListener_swigregister = _Box2D.b2DestructionListener_swigregister
b2DestructionListener_swigregister(b2DestructionListener)

class b2BoundaryListener(object):
    """This is called when a body's shape passes outside of the world boundary."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    __swig_destroy__ = _Box2D.delete_b2BoundaryListener
    def Violation(self, *args):
        """
        Violation(self, b2Body body)

        This is called for each body that leaves the world boundary. 
        WARNING: 
        you can't modify the world inside this callback.
        """
        return _Box2D.b2BoundaryListener_Violation(self, *args)

    def __repr__(self):
     return "b2BoundaryListener()"

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2BoundaryListener"""
        if self.__class__ == b2BoundaryListener:
            _self = None
        else:
            _self = self
        _Box2D.b2BoundaryListener_swiginit(self,_Box2D.new_b2BoundaryListener(_self, ))
    def __disown__(self):
        self.this.disown()
        _Box2D.disown_b2BoundaryListener(self)
        return weakref_proxy(self)
b2BoundaryListener.Violation = new_instancemethod(_Box2D.b2BoundaryListener_Violation,None,b2BoundaryListener)
b2BoundaryListener_swigregister = _Box2D.b2BoundaryListener_swigregister
b2BoundaryListener_swigregister(b2BoundaryListener)

class b2ContactFilter(object):
    """Implement this class to provide collision filtering. In other words, you can implement this class if you want finer control over contact creation."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    __swig_destroy__ = _Box2D.delete_b2ContactFilter
    def ShouldCollide(self, *args):
        """
        ShouldCollide(self, b2Shape shape1, b2Shape shape2) -> bool

        Return true if contact calculations should be performed between these two shapes. 
        WARNING: 
        for performance reasons this is only called when the AABBs begin to overlap.
        """
        return _Box2D.b2ContactFilter_ShouldCollide(self, *args)

    def RayCollide(self, *args):
        """
        RayCollide(self, void $ignore, b2Shape b2Shape) -> bool

        Return true if the given shape should be considered for ray intersection.
        """
        return _Box2D.b2ContactFilter_RayCollide(self, *args)

    def __repr__(self):
     return "b2ContactFilter()"

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2ContactFilter"""
        if self.__class__ == b2ContactFilter:
            _self = None
        else:
            _self = self
        _Box2D.b2ContactFilter_swiginit(self,_Box2D.new_b2ContactFilter(_self, ))
    def __disown__(self):
        self.this.disown()
        _Box2D.disown_b2ContactFilter(self)
        return weakref_proxy(self)
b2ContactFilter.ShouldCollide = new_instancemethod(_Box2D.b2ContactFilter_ShouldCollide,None,b2ContactFilter)
b2ContactFilter.RayCollide = new_instancemethod(_Box2D.b2ContactFilter_RayCollide,None,b2ContactFilter)
b2ContactFilter_swigregister = _Box2D.b2ContactFilter_swigregister
b2ContactFilter_swigregister(b2ContactFilter)

class b2ContactListener(object):
    """
    Implement this class to get collision results. You can use these results for things like sounds and game logic. You can also get contact results by traversing the contact lists after the time step. However, you might miss some contacts because continuous physics leads to sub-stepping. Additionally you may receive multiple callbacks for the same contact in a single time step. You should strive to make your callbacks efficient because there may be many callbacks per time step. 
    WARNING: 
    The contact separation is the last computed value.

    You cannot create/destroy Box2D entities inside these callbacks.
    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    __swig_destroy__ = _Box2D.delete_b2ContactListener
    def Add(self, *args):
        """
        Add(self, b2ContactPoint point)

        Called when a contact point is added. This includes the geometry and the forces.
        """
        return _Box2D.b2ContactListener_Add(self, *args)

    def Persist(self, *args):
        """
        Persist(self, b2ContactPoint point)

        Called when a contact point persists. This includes the geometry and the forces.
        """
        return _Box2D.b2ContactListener_Persist(self, *args)

    def Remove(self, *args):
        """
        Remove(self, b2ContactPoint point)

        Called when a contact point is removed. This includes the last computed geometry and forces.
        """
        return _Box2D.b2ContactListener_Remove(self, *args)

    def Result(self, *args):
        """
        Result(self, b2ContactResult point)

        Called after a contact point is solved.
        """
        return _Box2D.b2ContactListener_Result(self, *args)

    def __repr__(self):
     return "b2ContactListener()"

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2ContactListener"""
        if self.__class__ == b2ContactListener:
            _self = None
        else:
            _self = self
        _Box2D.b2ContactListener_swiginit(self,_Box2D.new_b2ContactListener(_self, ))
    def __disown__(self):
        self.this.disown()
        _Box2D.disown_b2ContactListener(self)
        return weakref_proxy(self)
b2ContactListener.Add = new_instancemethod(_Box2D.b2ContactListener_Add,None,b2ContactListener)
b2ContactListener.Persist = new_instancemethod(_Box2D.b2ContactListener_Persist,None,b2ContactListener)
b2ContactListener.Remove = new_instancemethod(_Box2D.b2ContactListener_Remove,None,b2ContactListener)
b2ContactListener.Result = new_instancemethod(_Box2D.b2ContactListener_Result,None,b2ContactListener)
b2ContactListener_swigregister = _Box2D.b2ContactListener_swigregister
b2ContactListener_swigregister(b2ContactListener)

class b2Color(object):
    """Color for debug drawing. Each value has the range [0,1]."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> b2Color
        __init__(self, float32 r, float32 g, float32 b) -> b2Color

        Color for debug drawing. Each value has the range [0,1].
        """
        _Box2D.b2Color_swiginit(self,_Box2D.new_b2Color(*args))
    r = _swig_property(_Box2D.b2Color_r_get, _Box2D.b2Color_r_set)
    g = _swig_property(_Box2D.b2Color_g_get, _Box2D.b2Color_g_set)
    b = _swig_property(_Box2D.b2Color_b_get, _Box2D.b2Color_b_set)
    def __repr__(self):
     return """b2Color(
       b = %s,
       g = %s,
       r = %s)"""% tuple(str(a) for a in\
      (self.b,self.g,self.r))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __iter__ = lambda self: iter((self.r, self.g, self.b)) 
     
    __swig_destroy__ = _Box2D.delete_b2Color
b2Color_swigregister = _Box2D.b2Color_swigregister
b2Color_swigregister(b2Color)

class b2DebugDraw(object):
    """Implement and register this class with a  b2Worldto provide debug drawing of physics entities in your game."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2DebugDraw

        Implement and register this class with a  b2Worldto provide debug drawing of physics entities in your game.
        """
        if self.__class__ == b2DebugDraw:
            _self = None
        else:
            _self = self
        _Box2D.b2DebugDraw_swiginit(self,_Box2D.new_b2DebugDraw(_self, ))
    __swig_destroy__ = _Box2D.delete_b2DebugDraw
    e_shapeBit = _Box2D.b2DebugDraw_e_shapeBit
    e_jointBit = _Box2D.b2DebugDraw_e_jointBit
    e_coreShapeBit = _Box2D.b2DebugDraw_e_coreShapeBit
    e_aabbBit = _Box2D.b2DebugDraw_e_aabbBit
    e_obbBit = _Box2D.b2DebugDraw_e_obbBit
    e_pairBit = _Box2D.b2DebugDraw_e_pairBit
    e_centerOfMassBit = _Box2D.b2DebugDraw_e_centerOfMassBit
    e_controllerBit = _Box2D.b2DebugDraw_e_controllerBit
    def SetFlags(self, *args):
        """
        SetFlags(self, uint32 flags)

        Set the drawing flags.
        """
        return _Box2D.b2DebugDraw_SetFlags(self, *args)

    def GetFlags(self):
        """
        GetFlags(self) -> uint32

        Get the drawing flags.
        """
        return _Box2D.b2DebugDraw_GetFlags(self)

    def AppendFlags(self, *args):
        """
        AppendFlags(self, uint32 flags)

        Append flags to the current flags.
        """
        return _Box2D.b2DebugDraw_AppendFlags(self, *args)

    def ClearFlags(self, *args):
        """
        ClearFlags(self, uint32 flags)

        Clear flags from the current flags.
        """
        return _Box2D.b2DebugDraw_ClearFlags(self, *args)

    def DrawPolygon(self, *args):
        """
        DrawPolygon(self, b2Vec2 vertices, int32 vertexCount, b2Color color)

        Draw a closed polygon provided in CCW order.
        """
        return _Box2D.b2DebugDraw_DrawPolygon(self, *args)

    def DrawSolidPolygon(self, *args):
        """
        DrawSolidPolygon(self, b2Vec2 vertices, int32 vertexCount, b2Color color)

        Draw a solid closed polygon provided in CCW order.
        """
        return _Box2D.b2DebugDraw_DrawSolidPolygon(self, *args)

    def DrawCircle(self, *args):
        """
        DrawCircle(self, b2Vec2 center, float32 radius, b2Color color)

        Draw a circle.
        """
        return _Box2D.b2DebugDraw_DrawCircle(self, *args)

    def DrawSolidCircle(self, *args):
        """
        DrawSolidCircle(self, b2Vec2 center, float32 radius, b2Vec2 axis, b2Color color)

        Draw a solid circle.
        """
        return _Box2D.b2DebugDraw_DrawSolidCircle(self, *args)

    def DrawSegment(self, *args):
        """
        DrawSegment(self, b2Vec2 p1, b2Vec2 p2, b2Color color)

        Draw a line segment.
        """
        return _Box2D.b2DebugDraw_DrawSegment(self, *args)

    def DrawXForm(self, *args):
        """
        DrawXForm(self, b2XForm xf)

        Draw a transform. Choose your own length scale.

        Parameters:
        -----------

        xf: a transform.
        """
        return _Box2D.b2DebugDraw_DrawXForm(self, *args)

    def __repr__(self):
     return """b2DebugDraw(
       GetFlags()        = %s,
       e_aabbBit         = %s,
       e_centerOfMassBit = %s,
       e_controllerBit   = %s,
       e_coreShapeBit    = %s,
       e_jointBit        = %s,
       e_obbBit          = %s,
       e_pairBit         = %s,
       e_shapeBit        = %s)"""% tuple(str(a) for a in\
      (self.GetFlags(),self.e_aabbBit,self.e_centerOfMassBit,self.e_controllerBit,self.e_coreShapeBit,self.e_jointBit,self.e_obbBit,self.e_pairBit,self.e_shapeBit))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __disown__(self):
        self.this.disown()
        _Box2D.disown_b2DebugDraw(self)
        return weakref_proxy(self)
b2DebugDraw.SetFlags = new_instancemethod(_Box2D.b2DebugDraw_SetFlags,None,b2DebugDraw)
b2DebugDraw.GetFlags = new_instancemethod(_Box2D.b2DebugDraw_GetFlags,None,b2DebugDraw)
b2DebugDraw.AppendFlags = new_instancemethod(_Box2D.b2DebugDraw_AppendFlags,None,b2DebugDraw)
b2DebugDraw.ClearFlags = new_instancemethod(_Box2D.b2DebugDraw_ClearFlags,None,b2DebugDraw)
b2DebugDraw.DrawPolygon = new_instancemethod(_Box2D.b2DebugDraw_DrawPolygon,None,b2DebugDraw)
b2DebugDraw.DrawSolidPolygon = new_instancemethod(_Box2D.b2DebugDraw_DrawSolidPolygon,None,b2DebugDraw)
b2DebugDraw.DrawCircle = new_instancemethod(_Box2D.b2DebugDraw_DrawCircle,None,b2DebugDraw)
b2DebugDraw.DrawSolidCircle = new_instancemethod(_Box2D.b2DebugDraw_DrawSolidCircle,None,b2DebugDraw)
b2DebugDraw.DrawSegment = new_instancemethod(_Box2D.b2DebugDraw_DrawSegment,None,b2DebugDraw)
b2DebugDraw.DrawXForm = new_instancemethod(_Box2D.b2DebugDraw_DrawXForm,None,b2DebugDraw)
b2DebugDraw_swigregister = _Box2D.b2DebugDraw_swigregister
b2DebugDraw_swigregister(b2DebugDraw)

class b2BlockAllocator(object):
    """Proxy of C++ b2BlockAllocator class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> b2BlockAllocator"""
        _Box2D.b2BlockAllocator_swiginit(self,_Box2D.new_b2BlockAllocator())
    __swig_destroy__ = _Box2D.delete_b2BlockAllocator
    def Allocate(self, *args):
        """Allocate(self, int32 size) -> void"""
        return _Box2D.b2BlockAllocator_Allocate(self, *args)

    def Free(self, *args):
        """Free(self, void p, int32 size)"""
        return _Box2D.b2BlockAllocator_Free(self, *args)

    def Clear(self):
        """Clear(self)"""
        return _Box2D.b2BlockAllocator_Clear(self)

    def __repr__(self):
     return "b2BlockAllocator()"

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

b2BlockAllocator.Allocate = new_instancemethod(_Box2D.b2BlockAllocator_Allocate,None,b2BlockAllocator)
b2BlockAllocator.Free = new_instancemethod(_Box2D.b2BlockAllocator_Free,None,b2BlockAllocator)
b2BlockAllocator.Clear = new_instancemethod(_Box2D.b2BlockAllocator_Clear,None,b2BlockAllocator)
b2BlockAllocator_swigregister = _Box2D.b2BlockAllocator_swigregister
b2BlockAllocator_swigregister(b2BlockAllocator)
b2_chunkSize = cvar.b2_chunkSize
b2_maxBlockSize = cvar.b2_maxBlockSize
b2_blockSizes = cvar.b2_blockSizes
b2_chunkArrayIncrement = cvar.b2_chunkArrayIncrement

class b2StackEntry(object):
    """Proxy of C++ b2StackEntry class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    data = _swig_property(_Box2D.b2StackEntry_data_get, _Box2D.b2StackEntry_data_set)
    size = _swig_property(_Box2D.b2StackEntry_size_get, _Box2D.b2StackEntry_size_set)
    usedMalloc = _swig_property(_Box2D.b2StackEntry_usedMalloc_get, _Box2D.b2StackEntry_usedMalloc_set)
    def __repr__(self):
     return """b2StackEntry(
       data       = %s,
       size       = %s,
       usedMalloc = %s)"""% tuple(str(a) for a in\
      (self.data,self.size,self.usedMalloc))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2StackEntry"""
        _Box2D.b2StackEntry_swiginit(self,_Box2D.new_b2StackEntry())
    __swig_destroy__ = _Box2D.delete_b2StackEntry
b2StackEntry_swigregister = _Box2D.b2StackEntry_swigregister
b2StackEntry_swigregister(b2StackEntry)
b2_stackSize = cvar.b2_stackSize
b2_maxStackEntries = cvar.b2_maxStackEntries

class b2StackAllocator(object):
    """Proxy of C++ b2StackAllocator class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> b2StackAllocator"""
        _Box2D.b2StackAllocator_swiginit(self,_Box2D.new_b2StackAllocator())
    __swig_destroy__ = _Box2D.delete_b2StackAllocator
    def Allocate(self, *args):
        """Allocate(self, int32 size) -> void"""
        return _Box2D.b2StackAllocator_Allocate(self, *args)

    def Free(self, *args):
        """Free(self, void p)"""
        return _Box2D.b2StackAllocator_Free(self, *args)

    def GetMaxAllocation(self):
        """GetMaxAllocation(self) -> int32"""
        return _Box2D.b2StackAllocator_GetMaxAllocation(self)

    def __repr__(self):
     return """b2StackAllocator(
       GetMaxAllocation() = %s)"""% tuple(str(a) for a in\
      (self.GetMaxAllocation()))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

b2StackAllocator.Allocate = new_instancemethod(_Box2D.b2StackAllocator_Allocate,None,b2StackAllocator)
b2StackAllocator.Free = new_instancemethod(_Box2D.b2StackAllocator_Free,None,b2StackAllocator)
b2StackAllocator.GetMaxAllocation = new_instancemethod(_Box2D.b2StackAllocator_GetMaxAllocation,None,b2StackAllocator)
b2StackAllocator_swigregister = _Box2D.b2StackAllocator_swigregister
b2StackAllocator_swigregister(b2StackAllocator)

class b2ContactRegister(object):
    """Proxy of C++ b2ContactRegister class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    createFcn = _swig_property(_Box2D.b2ContactRegister_createFcn_get, _Box2D.b2ContactRegister_createFcn_set)
    destroyFcn = _swig_property(_Box2D.b2ContactRegister_destroyFcn_get, _Box2D.b2ContactRegister_destroyFcn_set)
    primary = _swig_property(_Box2D.b2ContactRegister_primary_get, _Box2D.b2ContactRegister_primary_set)
    def __repr__(self):
     return """b2ContactRegister(
       createFcn  = %s,
       destroyFcn = %s,
       primary    = %s)"""% tuple(str(a) for a in\
      (self.createFcn,self.destroyFcn,self.primary))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2ContactRegister"""
        _Box2D.b2ContactRegister_swiginit(self,_Box2D.new_b2ContactRegister())
    __swig_destroy__ = _Box2D.delete_b2ContactRegister
b2ContactRegister_swigregister = _Box2D.b2ContactRegister_swigregister
b2ContactRegister_swigregister(b2ContactRegister)

class b2ContactEdge(object):
    """A contact edge is used to connect bodies and contacts together in a contact graph where each body is a node and each contact is an edge. A contact edge belongs to a doubly linked list maintained in each attached body. Each contact has two contact nodes, one for each attached body."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    other = _swig_property(_Box2D.b2ContactEdge_other_get, _Box2D.b2ContactEdge_other_set)
    contact = _swig_property(_Box2D.b2ContactEdge_contact_get, _Box2D.b2ContactEdge_contact_set)
    prev = _swig_property(_Box2D.b2ContactEdge_prev_get, _Box2D.b2ContactEdge_prev_set)
    next = _swig_property(_Box2D.b2ContactEdge_next_get, _Box2D.b2ContactEdge_next_set)
    def __repr__(self):
     return """b2ContactEdge(
       contact = %s,
       other   = %s)"""% tuple(str(a) for a in\
      (self.contact,self.other))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2ContactEdge"""
        _Box2D.b2ContactEdge_swiginit(self,_Box2D.new_b2ContactEdge())
    __swig_destroy__ = _Box2D.delete_b2ContactEdge
b2ContactEdge_swigregister = _Box2D.b2ContactEdge_swigregister
b2ContactEdge_swigregister(b2ContactEdge)

class b2ContactPoint(object):
    """This structure is used to report contact points."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    shape1 = _swig_property(_Box2D.b2ContactPoint_shape1_get, _Box2D.b2ContactPoint_shape1_set)
    shape2 = _swig_property(_Box2D.b2ContactPoint_shape2_get, _Box2D.b2ContactPoint_shape2_set)
    position = _swig_property(_Box2D.b2ContactPoint_position_get, _Box2D.b2ContactPoint_position_set)
    velocity = _swig_property(_Box2D.b2ContactPoint_velocity_get, _Box2D.b2ContactPoint_velocity_set)
    normal = _swig_property(_Box2D.b2ContactPoint_normal_get, _Box2D.b2ContactPoint_normal_set)
    separation = _swig_property(_Box2D.b2ContactPoint_separation_get, _Box2D.b2ContactPoint_separation_set)
    friction = _swig_property(_Box2D.b2ContactPoint_friction_get, _Box2D.b2ContactPoint_friction_set)
    restitution = _swig_property(_Box2D.b2ContactPoint_restitution_get, _Box2D.b2ContactPoint_restitution_set)
    id = _swig_property(_Box2D.b2ContactPoint_id_get, _Box2D.b2ContactPoint_id_set)
    def __repr__(self):
     return """b2ContactPoint(
       friction    = %s,
       id          = %s,
       normal      = %s,
       position    = %s,
       restitution = %s,
       separation  = %s,
       shape1      = %s,
       shape2      = %s,
       velocity    = %s)"""% tuple(str(a) for a in\
      (self.friction,self.id,self.normal,self.position,self.restitution,self.separation,self.shape1,self.shape2,self.velocity))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2ContactPoint"""
        _Box2D.b2ContactPoint_swiginit(self,_Box2D.new_b2ContactPoint())
    __swig_destroy__ = _Box2D.delete_b2ContactPoint
b2ContactPoint_swigregister = _Box2D.b2ContactPoint_swigregister
b2ContactPoint_swigregister(b2ContactPoint)

class b2ContactResult(object):
    """This structure is used to report contact point results."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    shape1 = _swig_property(_Box2D.b2ContactResult_shape1_get, _Box2D.b2ContactResult_shape1_set)
    shape2 = _swig_property(_Box2D.b2ContactResult_shape2_get, _Box2D.b2ContactResult_shape2_set)
    position = _swig_property(_Box2D.b2ContactResult_position_get, _Box2D.b2ContactResult_position_set)
    normal = _swig_property(_Box2D.b2ContactResult_normal_get, _Box2D.b2ContactResult_normal_set)
    normalImpulse = _swig_property(_Box2D.b2ContactResult_normalImpulse_get, _Box2D.b2ContactResult_normalImpulse_set)
    tangentImpulse = _swig_property(_Box2D.b2ContactResult_tangentImpulse_get, _Box2D.b2ContactResult_tangentImpulse_set)
    id = _swig_property(_Box2D.b2ContactResult_id_get, _Box2D.b2ContactResult_id_set)
    def __repr__(self):
     return """b2ContactResult(
       id             = %s,
       normal         = %s,
       normalImpulse  = %s,
       position       = %s,
       shape1         = %s,
       shape2         = %s,
       tangentImpulse = %s)"""% tuple(str(a) for a in\
      (self.id,self.normal,self.normalImpulse,self.position,self.shape1,self.shape2,self.tangentImpulse))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2ContactResult"""
        _Box2D.b2ContactResult_swiginit(self,_Box2D.new_b2ContactResult())
    __swig_destroy__ = _Box2D.delete_b2ContactResult
b2ContactResult_swigregister = _Box2D.b2ContactResult_swigregister
b2ContactResult_swigregister(b2ContactResult)

class b2Contact(object):
    """The class manages contact between two shapes. A contact exists for each overlapping AABB in the broad-phase (except if filtered). Therefore a contact object may exist that has no contact points."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    def GetManifolds(self):
        """
        GetManifolds(self) -> b2Manifold

        Get the manifold array.
        """
        return _Box2D.b2Contact_GetManifolds(self)

    def GetManifoldCount(self):
        """
        GetManifoldCount(self) -> int32

        Get the number of manifolds. This is 0 or 1 between convex shapes. This may be greater than 1 for convex-vs-concave shapes. Each manifold holds up to two contact points with a shared contact normal.
        """
        return _Box2D.b2Contact_GetManifoldCount(self)

    def IsSolid(self):
        """
        IsSolid(self) -> bool

        Is this contact solid? 
        true if this contact should generate a response.
        """
        return _Box2D.b2Contact_IsSolid(self)

    def GetNext(self):
        """
        GetNext(self) -> b2Contact

        Get the next contact in the world's contact list.
        """
        return _Box2D.b2Contact_GetNext(self)

    def GetShape1(self):
        """
        GetShape1(self) -> b2Shape

        Get the first shape in this contact.
        """
        return _Box2D.b2Contact_GetShape1(self)

    def GetShape2(self):
        """
        GetShape2(self) -> b2Shape

        Get the second shape in this contact.
        """
        return _Box2D.b2Contact_GetShape2(self)

    e_nonSolidFlag = _Box2D.b2Contact_e_nonSolidFlag
    e_slowFlag = _Box2D.b2Contact_e_slowFlag
    e_islandFlag = _Box2D.b2Contact_e_islandFlag
    e_toiFlag = _Box2D.b2Contact_e_toiFlag
    def AddType(*args):
        """
        AddType(b2ContactCreateFcn createFcn, b2ContactDestroyFcn destroyFcn, 
            b2ShapeType type1, b2ShapeType type2)
        """
        return _Box2D.b2Contact_AddType(*args)

    AddType = staticmethod(AddType)
    def InitializeRegisters():
        """InitializeRegisters()"""
        return _Box2D.b2Contact_InitializeRegisters()

    InitializeRegisters = staticmethod(InitializeRegisters)
    def Create(*args):
        """Create(b2Shape shape1, b2Shape shape2, b2BlockAllocator allocator) -> b2Contact"""
        return _Box2D.b2Contact_Create(*args)

    Create = staticmethod(Create)
    def Destroy(*args):
        """Destroy(b2Contact contact, b2BlockAllocator allocator)"""
        return _Box2D.b2Contact_Destroy(*args)

    Destroy = staticmethod(Destroy)
    __swig_destroy__ = _Box2D.delete_b2Contact
    def Update(self, *args):
        """Update(self, b2ContactListener listener)"""
        return _Box2D.b2Contact_Update(self, *args)

    def Evaluate(self, *args):
        """Evaluate(self, b2ContactListener listener)"""
        return _Box2D.b2Contact_Evaluate(self, *args)

    s_registers = _swig_property(_Box2D.b2Contact_s_registers_get, _Box2D.b2Contact_s_registers_set)
    s_initialized = _swig_property(_Box2D.b2Contact_s_initialized_get, _Box2D.b2Contact_s_initialized_set)
    flags = _swig_property(_Box2D.b2Contact_flags_get, _Box2D.b2Contact_flags_set)
    manifoldCount = _swig_property(_Box2D.b2Contact_manifoldCount_get, _Box2D.b2Contact_manifoldCount_set)
    prev = _swig_property(_Box2D.b2Contact_prev_get, _Box2D.b2Contact_prev_set)
    next = _swig_property(_Box2D.b2Contact_next_get, _Box2D.b2Contact_next_set)
    node1 = _swig_property(_Box2D.b2Contact_node1_get, _Box2D.b2Contact_node1_set)
    node2 = _swig_property(_Box2D.b2Contact_node2_get, _Box2D.b2Contact_node2_set)
    shape1 = _swig_property(_Box2D.b2Contact_shape1_get, _Box2D.b2Contact_shape1_set)
    shape2 = _swig_property(_Box2D.b2Contact_shape2_get, _Box2D.b2Contact_shape2_set)
    toi = _swig_property(_Box2D.b2Contact_toi_get, _Box2D.b2Contact_toi_set)
    def __repr__(self):
     return """b2Contact(
       flags          = %s,
       manifoldCount  = %s,
       node1          = %s,
       node2          = %s,
       s_initialized  = %s,
       s_registers    = %s,
       shape1         = %s,
       shape2         = %s,
       toi            = %s,
       GetManifolds() = %s,
       IsSolid()      = %s,
       e_islandFlag   = %s,
       e_nonSolidFlag = %s,
       e_slowFlag     = %s,
       e_toiFlag      = %s)"""% tuple(str(a) for a in\
      (self.flags,self.manifoldCount,self.node1,self.node2,self.s_initialized,self.s_registers,self.shape1,self.shape2,self.toi,self.GetManifolds(),self.IsSolid(),self.e_islandFlag,self.e_nonSolidFlag,self.e_slowFlag,self.e_toiFlag))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

b2Contact.GetManifolds = new_instancemethod(_Box2D.b2Contact_GetManifolds,None,b2Contact)
b2Contact.GetManifoldCount = new_instancemethod(_Box2D.b2Contact_GetManifoldCount,None,b2Contact)
b2Contact.IsSolid = new_instancemethod(_Box2D.b2Contact_IsSolid,None,b2Contact)
b2Contact.GetNext = new_instancemethod(_Box2D.b2Contact_GetNext,None,b2Contact)
b2Contact.GetShape1 = new_instancemethod(_Box2D.b2Contact_GetShape1,None,b2Contact)
b2Contact.GetShape2 = new_instancemethod(_Box2D.b2Contact_GetShape2,None,b2Contact)
b2Contact.Update = new_instancemethod(_Box2D.b2Contact_Update,None,b2Contact)
b2Contact.Evaluate = new_instancemethod(_Box2D.b2Contact_Evaluate,None,b2Contact)
b2Contact_swigregister = _Box2D.b2Contact_swigregister
b2Contact_swigregister(b2Contact)

def b2Contact_AddType(*args):
  """
    b2Contact_AddType(b2ContactCreateFcn createFcn, b2ContactDestroyFcn destroyFcn, 
        b2ShapeType type1, b2ShapeType type2)
    """
  return _Box2D.b2Contact_AddType(*args)

def b2Contact_InitializeRegisters():
  """b2Contact_InitializeRegisters()"""
  return _Box2D.b2Contact_InitializeRegisters()

def b2Contact_Create(*args):
  """b2Contact_Create(b2Shape shape1, b2Shape shape2, b2BlockAllocator allocator) -> b2Contact"""
  return _Box2D.b2Contact_Create(*args)

def b2Contact_Destroy(*args):
  """b2Contact_Destroy(b2Contact contact, b2BlockAllocator allocator)"""
  return _Box2D.b2Contact_Destroy(*args)

class b2NullContact(b2Contact):
    """Proxy of C++ b2NullContact class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> b2NullContact"""
        _Box2D.b2NullContact_swiginit(self,_Box2D.new_b2NullContact())
    def __repr__(self):
     return """b2NullContact(
       flags          = %s,
       manifoldCount  = %s,
       node1          = %s,
       node2          = %s,
       s_initialized  = %s,
       s_registers    = %s,
       shape1         = %s,
       shape2         = %s,
       toi            = %s,
       GetManifolds() = %s,
       IsSolid()      = %s,
       e_islandFlag   = %s,
       e_nonSolidFlag = %s,
       e_slowFlag     = %s,
       e_toiFlag      = %s)"""% tuple(str(a) for a in\
      (self.flags,self.manifoldCount,self.node1,self.node2,self.s_initialized,self.s_registers,self.shape1,self.shape2,self.toi,self.GetManifolds(),self.IsSolid(),self.e_islandFlag,self.e_nonSolidFlag,self.e_slowFlag,self.e_toiFlag))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2NullContact
b2NullContact_swigregister = _Box2D.b2NullContact_swigregister
b2NullContact_swigregister(b2NullContact)

class b2ContactManager(b2PairCallback):
    """Proxy of C++ b2ContactManager class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> b2ContactManager"""
        _Box2D.b2ContactManager_swiginit(self,_Box2D.new_b2ContactManager())
    def Destroy(self, *args):
        """Destroy(self, b2Contact c)"""
        return _Box2D.b2ContactManager_Destroy(self, *args)

    def Collide(self):
        """Collide(self)"""
        return _Box2D.b2ContactManager_Collide(self)

    world = _swig_property(_Box2D.b2ContactManager_world_get, _Box2D.b2ContactManager_world_set)
    nullContact = _swig_property(_Box2D.b2ContactManager_nullContact_get, _Box2D.b2ContactManager_nullContact_set)
    destroyImmediate = _swig_property(_Box2D.b2ContactManager_destroyImmediate_get, _Box2D.b2ContactManager_destroyImmediate_set)
    def __repr__(self):
     return """b2ContactManager(
       destroyImmediate = %s,
       nullContact      = %s,
       world            = %s)"""% tuple(str(a) for a in\
      (self.destroyImmediate,self.nullContact,self.world))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2ContactManager
b2ContactManager.Destroy = new_instancemethod(_Box2D.b2ContactManager_Destroy,None,b2ContactManager)
b2ContactManager.Collide = new_instancemethod(_Box2D.b2ContactManager_Collide,None,b2ContactManager)
b2ContactManager_swigregister = _Box2D.b2ContactManager_swigregister
b2ContactManager_swigregister(b2ContactManager)

class b2TimeStep(object):
    """Proxy of C++ b2TimeStep class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    dt = _swig_property(_Box2D.b2TimeStep_dt_get, _Box2D.b2TimeStep_dt_set)
    inv_dt = _swig_property(_Box2D.b2TimeStep_inv_dt_get, _Box2D.b2TimeStep_inv_dt_set)
    dtRatio = _swig_property(_Box2D.b2TimeStep_dtRatio_get, _Box2D.b2TimeStep_dtRatio_set)
    velocityIterations = _swig_property(_Box2D.b2TimeStep_velocityIterations_get, _Box2D.b2TimeStep_velocityIterations_set)
    positionIterations = _swig_property(_Box2D.b2TimeStep_positionIterations_get, _Box2D.b2TimeStep_positionIterations_set)
    warmStarting = _swig_property(_Box2D.b2TimeStep_warmStarting_get, _Box2D.b2TimeStep_warmStarting_set)
    def __repr__(self):
     return """b2TimeStep(
       dt                 = %s,
       dtRatio            = %s,
       inv_dt             = %s,
       positionIterations = %s,
       velocityIterations = %s,
       warmStarting       = %s)"""% tuple(str(a) for a in\
      (self.dt,self.dtRatio,self.inv_dt,self.positionIterations,self.velocityIterations,self.warmStarting))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2TimeStep"""
        _Box2D.b2TimeStep_swiginit(self,_Box2D.new_b2TimeStep())
    __swig_destroy__ = _Box2D.delete_b2TimeStep
b2TimeStep_swigregister = _Box2D.b2TimeStep_swigregister
b2TimeStep_swigregister(b2TimeStep)

class b2World(object):
    """The world class manages all physics entities, dynamic simulation, and asynchronous queries. The world also contains efficient memory management facilities."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, b2AABB worldAABB, b2Vec2 gravity, bool doSleep) -> b2World

        Construct a world object.

        Parameters:
        -----------

        worldAABB: a bounding box that completely encompasses all your shapes.

        gravity: the world gravity vector.

        doSleep: improve performance by not simulating inactive bodies.
        """
        _Box2D.b2World_swiginit(self,_Box2D.new_b2World(*args))
    __swig_destroy__ = _Box2D.delete_b2World
    def SetDestructionListener(self, *args):
        """
        SetDestructionListener(self, b2DestructionListener listener)

        Register a destruction listener.
        """
        return _Box2D.b2World_SetDestructionListener(self, *args)

    def SetBoundaryListener(self, *args):
        """
        SetBoundaryListener(self, b2BoundaryListener listener)

        Register a broad-phase boundary listener.
        """
        return _Box2D.b2World_SetBoundaryListener(self, *args)

    def SetContactFilter(self, *args):
        """
        SetContactFilter(self, b2ContactFilter filter)

        Register a contact filter to provide specific control over collision. Otherwise the default filter is used (b2_defaultFilter).
        """
        return _Box2D.b2World_SetContactFilter(self, *args)

    def SetContactListener(self, *args):
        """
        SetContactListener(self, b2ContactListener listener)

        Register a contact event listener.
        """
        return _Box2D.b2World_SetContactListener(self, *args)

    def SetDebugDraw(self, *args):
        """
        SetDebugDraw(self, b2DebugDraw debugDraw)

        Register a routine for debug drawing. The debug draw functions are called inside the  b2World::Stepmethod, so make sure your renderer is ready to consume draw commands when you call  Step().
        """
        return _Box2D.b2World_SetDebugDraw(self, *args)

    def CreateController(self, *args):
        """
        CreateController(self, b2ControllerDef _def) -> b2Controller

        Add a controller to the world.
        """
        return _Box2D.b2World_CreateController(self, *args)

    def DestroyController(self, *args):
        """
        DestroyController(self, b2Controller controller)

        Removes a controller from the world.
        """
        return _Box2D.b2World_DestroyController(self, *args)

    def GetGroundBody(self):
        """
        GetGroundBody(self) -> b2Body

        The world provides a single static ground body with no collision shapes. You can use this to simplify the creation of joints and static shapes.
        """
        return _Box2D.b2World_GetGroundBody(self)

    def Step(self, *args):
        """
        Step(self, float32 timeStep, int32 velocityIterations, int32 positionIterations)

        Take a time step. This performs collision detection, integration, and constraint solution.

        Parameters:
        -----------

        timeStep: the amount of time to simulate, this should not vary.

        velocityIterations: for the velocity constraint solver.

        positionIterations: for the position constraint solver.
        """
        return _Box2D.b2World_Step(self, *args)

    def InRange(self, *args):
        """
        InRange(self, b2AABB aabb) -> bool

        Check if the AABB is within the broadphase limits.
        """
        return _Box2D.b2World_InRange(self, *args)

    def _GetBodyList(self):
        """
        _GetBodyList(self) -> b2Body

        Get the world body list. With the returned body, use  b2Body::GetNextto get the next body in the world list. A NULL body indicates the end of the list. 
        the head of the world body list.
        """
        return _Box2D.b2World__GetBodyList(self)

    def _GetJointList(self):
        """
        _GetJointList(self) -> b2Joint

        Get the world joint list. With the returned joint, use  b2Joint::GetNextto get the next joint in the world list. A NULL joint indicates the end of the list. 
        the head of the world joint list.
        """
        return _Box2D.b2World__GetJointList(self)

    def _GetControllerList(self):
        """
        _GetControllerList(self) -> b2Controller

        Get the world controller list. With the returned controller, use  b2Controller::GetNextto get the next controller in the world list. A NULL controller indicates the end of the list. 
        the head of the world controller list.
        """
        return _Box2D.b2World__GetControllerList(self)

    def Refilter(self, *args):
        """
        Refilter(self, b2Shape shape)

        Re-filter a shape. This re-runs contact filtering on a shape.
        """
        return _Box2D.b2World_Refilter(self, *args)

    def SetWarmStarting(self, *args):
        """
        SetWarmStarting(self, bool flag)

        Enable/disable warm starting. For testing.
        """
        return _Box2D.b2World_SetWarmStarting(self, *args)

    def SetContinuousPhysics(self, *args):
        """
        SetContinuousPhysics(self, bool flag)

        Enable/disable continuous physics. For testing.
        """
        return _Box2D.b2World_SetContinuousPhysics(self, *args)

    def Validate(self):
        """
        Validate(self)

        Perform validation of internal data structures.
        """
        return _Box2D.b2World_Validate(self)

    def GetProxyCount(self):
        """
        GetProxyCount(self) -> int32

        Get the number of broad-phase proxies.
        """
        return _Box2D.b2World_GetProxyCount(self)

    def GetPairCount(self):
        """
        GetPairCount(self) -> int32

        Get the number of broad-phase pairs.
        """
        return _Box2D.b2World_GetPairCount(self)

    def GetBodyCount(self):
        """
        GetBodyCount(self) -> int32

        Get the number of bodies.
        """
        return _Box2D.b2World_GetBodyCount(self)

    def GetJointCount(self):
        """
        GetJointCount(self) -> int32

        Get the number of joints.
        """
        return _Box2D.b2World_GetJointCount(self)

    def GetContactCount(self):
        """
        GetContactCount(self) -> int32

        Get the number of contacts (each may have 0 or more contact points).
        """
        return _Box2D.b2World_GetContactCount(self)

    def GetControllerCount(self):
        """
        GetControllerCount(self) -> int32

        Get the number of controllers.
        """
        return _Box2D.b2World_GetControllerCount(self)

    def SetGravity(self, *args):
        """
        SetGravity(self, b2Vec2 gravity)

        Change the global gravity vector.
        """
        return _Box2D.b2World_SetGravity(self, *args)

    def GetGravity(self):
        """
        GetGravity(self) -> b2Vec2

        Get the global gravity vector.
        """
        return _Box2D.b2World_GetGravity(self)

    def GetWorldAABB(self):
        """
        GetWorldAABB(self) -> b2AABB

        Get the world's AABB.
        """
        return _Box2D.b2World_GetWorldAABB(self)

    def CanSleep(self):
        """
        CanSleep(self) -> bool

        Whether or not bodies can sleep.
        """
        return _Box2D.b2World_CanSleep(self)

    def __repr__(self):
     return """b2World(
       doSleep              = %s,
       gravity              = %s,
       groundBody           = %s,
       worldAABB            = %s,
       GetBodyCount()       = %s,
       GetContactCount()    = %s,
       GetControllerCount() = %s,
       GetJointCount()      = %s,
       GetPairCount()       = %s,
       GetProxyCount()      = %s)"""% tuple(str(a) for a in\
      (self.doSleep,self.gravity,self.groundBody,self.worldAABB,self.GetBodyCount(),self.GetContactCount(),self.GetControllerCount(),self.GetJointCount(),self.GetPairCount(),self.GetProxyCount()))

    __getstate__=_pickle_get_b2world
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_world

    def CreateBody(self, *args):
        """
        CreateBody(self, b2BodyDef defn) -> b2Body

        Create a rigid body given a definition. No reference to the definition is retained. 
        WARNING: 
        This function is locked during callbacks.
        """
        return _Box2D.b2World_CreateBody(self, *args)

    def CreateJoint(self, *args):
        """
        CreateJoint(self, b2JointDef defn) -> b2Joint

        Create a joint to constrain bodies together. No reference to the definition is retained. This may cause the connected bodies to cease colliding. 
        WARNING: 
        This function is locked during callbacks.
        """
        return _Box2D.b2World_CreateJoint(self, *args)

    def DestroyBody(self, *args):
        """
        DestroyBody(self, b2Body body)

        Destroy a rigid body given a definition. No reference to the definition is retained. This function is locked during callbacks. 
        WARNING: 
        This automatically deletes all associated shapes and joints.

        This function is locked during callbacks.
        """
        return _Box2D.b2World_DestroyBody(self, *args)

    def DestroyJoint(self, *args):
        """
        DestroyJoint(self, b2Joint joint)

        Destroy a joint. This may cause the connected bodies to begin colliding. 
        WARNING: 
        This function is locked during callbacks.
        """
        return _Box2D.b2World_DestroyJoint(self, *args)

    def Raycast(self, *args):
        """
        Raycast(self, b2Segment segment, b2Shape shapes, int32 maxCount, 
            bool solidShapes, void $ignore) -> int32
        Raycast(self, b2Segment segment, int32 maxCount, bool solidShapes, 
            PyObject $ignore) -> PyObject

        Query the world for all shapes that intersect a given segment. You provide a shape pointer buffer of specified size. The number of shapes found is returned, and the buffer is filled in order of intersection

        Parameters:
        -----------

        segment: 
        defines the begin and end point of the ray cast, from p1 to p2. Use b2Segment.Extend to create (semi-)infinite rays

        shapes: 
        a user allocated shape pointer array of size maxCount (or greater).

        maxCount: 
        the capacity of the shapes array

        solidShapes: 
        determines if shapes that the ray starts in are counted as hits.

        userData: 
        passed through the worlds contact filter, with method RayCollide. This can be used to filter valid shapes

        the number of shapes found
        """
        return _Box2D.b2World_Raycast(self, *args)

    def RaycastOne(self, *args):
        """
        RaycastOne(self, b2Segment segment, float32 _lambda, b2Vec2 normal, 
            bool solidShapes, void $ignore) -> b2Shape
        RaycastOne(self, b2Segment segment, bool solidShapes, PyObject $ignore) -> PyObject

        Performs a raycast as with Raycast, finding the first intersecting shape.

        Parameters:
        -----------

        segment: 
        defines the begin and end point of the ray cast, from p1 to p2. Use b2Segment.Extend to create (semi-)infinite rays

        lambda: 
        returns the hit fraction. You can use this to compute the contact point p = (1 - lambda) * segment.p1 + lambda * segment.p2.

        normal: 
        returns the normal at the contact point. If there is no intersection, the normal is not set.

        solidShapes: 
        determines if shapes that the ray starts in are counted as hits.

        the colliding shape shape, or null if not found
        """
        return _Box2D.b2World_RaycastOne(self, *args)

    def Query(self, *args):
        """
        Query(self, b2AABB aabb, b2Shape shapes, int32 maxCount) -> int32
        Query(self, b2AABB aabb, uint32 maxCount) -> PyObject

        Query the world for all shapes that potentially overlap the provided AABB. You provide a shape pointer buffer of specified size. The number of shapes found is returned.

        Parameters:
        -----------

        aabb: the query box.

        shapes: a user allocated shape pointer array of size maxCount (or greater).

        maxCount: the capacity of the shapes array.

        the number of shapes found in aabb.
        """
        return _Box2D.b2World_Query(self, *args)

    def GetJointList(self):
        """
        Get a list of the joints in this world
        """
        jointList = []
        joint = self._GetJointList()
        while joint:
            jointList.append(joint.getAsType())
            joint = joint.GetNext()
        jointList.reverse() # jointlist is in reverse order
        return jointList
    def GetBodyList(self):
        """
        Get a list of the bodies in this world
        """
        bodyList = []
        body = self._GetBodyList()
        while body:
            bodyList.append(body)
            body = body.GetNext()
        bodyList.reverse() # bodylist is in reverse order
        return bodyList
    def GetControllerList(self):
        """
        Get a list of the controllers in this world
        """
        controllerList = []
        controller = self._GetControllerList()
        while controller:
            controllerList.append(controller.getAsType())
            controller = controller.GetNext()
        controllerList.reverse() # controllerlist is in reverse order
        return controllerList

    def __iter__(self):
        """
        Iterates over the bodies in the world
        """
        for body in self.bodyList:
            yield body

    gravity   = property(GetGravity   , SetGravity)
    jointList = property(GetJointList , None)
    bodyList  = property(GetBodyList  , None)
    groundBody= property(GetGroundBody, None)
    worldAABB = property(GetWorldAABB , None)
    doSleep   = property(CanSleep     , None)
    controllerList = property(GetControllerList, None)

b2World.SetDestructionListener = new_instancemethod(_Box2D.b2World_SetDestructionListener,None,b2World)
b2World.SetBoundaryListener = new_instancemethod(_Box2D.b2World_SetBoundaryListener,None,b2World)
b2World.SetContactFilter = new_instancemethod(_Box2D.b2World_SetContactFilter,None,b2World)
b2World.SetContactListener = new_instancemethod(_Box2D.b2World_SetContactListener,None,b2World)
b2World.SetDebugDraw = new_instancemethod(_Box2D.b2World_SetDebugDraw,None,b2World)
b2World.CreateController = new_instancemethod(_Box2D.b2World_CreateController,None,b2World)
b2World.DestroyController = new_instancemethod(_Box2D.b2World_DestroyController,None,b2World)
b2World.GetGroundBody = new_instancemethod(_Box2D.b2World_GetGroundBody,None,b2World)
b2World.Step = new_instancemethod(_Box2D.b2World_Step,None,b2World)
b2World.InRange = new_instancemethod(_Box2D.b2World_InRange,None,b2World)
b2World._GetBodyList = new_instancemethod(_Box2D.b2World__GetBodyList,None,b2World)
b2World._GetJointList = new_instancemethod(_Box2D.b2World__GetJointList,None,b2World)
b2World._GetControllerList = new_instancemethod(_Box2D.b2World__GetControllerList,None,b2World)
b2World.Refilter = new_instancemethod(_Box2D.b2World_Refilter,None,b2World)
b2World.SetWarmStarting = new_instancemethod(_Box2D.b2World_SetWarmStarting,None,b2World)
b2World.SetContinuousPhysics = new_instancemethod(_Box2D.b2World_SetContinuousPhysics,None,b2World)
b2World.Validate = new_instancemethod(_Box2D.b2World_Validate,None,b2World)
b2World.GetProxyCount = new_instancemethod(_Box2D.b2World_GetProxyCount,None,b2World)
b2World.GetPairCount = new_instancemethod(_Box2D.b2World_GetPairCount,None,b2World)
b2World.GetBodyCount = new_instancemethod(_Box2D.b2World_GetBodyCount,None,b2World)
b2World.GetJointCount = new_instancemethod(_Box2D.b2World_GetJointCount,None,b2World)
b2World.GetContactCount = new_instancemethod(_Box2D.b2World_GetContactCount,None,b2World)
b2World.GetControllerCount = new_instancemethod(_Box2D.b2World_GetControllerCount,None,b2World)
b2World.SetGravity = new_instancemethod(_Box2D.b2World_SetGravity,None,b2World)
b2World.GetGravity = new_instancemethod(_Box2D.b2World_GetGravity,None,b2World)
b2World.GetWorldAABB = new_instancemethod(_Box2D.b2World_GetWorldAABB,None,b2World)
b2World.CanSleep = new_instancemethod(_Box2D.b2World_CanSleep,None,b2World)
b2World.CreateBody = new_instancemethod(_Box2D.b2World_CreateBody,None,b2World)
b2World.CreateJoint = new_instancemethod(_Box2D.b2World_CreateJoint,None,b2World)
b2World.DestroyBody = new_instancemethod(_Box2D.b2World_DestroyBody,None,b2World)
b2World.DestroyJoint = new_instancemethod(_Box2D.b2World_DestroyJoint,None,b2World)
b2World.Raycast = new_instancemethod(_Box2D.b2World_Raycast,None,b2World)
b2World.RaycastOne = new_instancemethod(_Box2D.b2World_RaycastOne,None,b2World)
b2World.Query = new_instancemethod(_Box2D.b2World_Query,None,b2World)
b2World_swigregister = _Box2D.b2World_swigregister
b2World_swigregister(b2World)

e_unknownController = _Box2D.e_unknownController
e_buoyancyController = _Box2D.e_buoyancyController
e_constantAccelController = _Box2D.e_constantAccelController
e_constantForceController = _Box2D.e_constantForceController
e_gravityController = _Box2D.e_gravityController
e_tensorDampingController = _Box2D.e_tensorDampingController
class b2ControllerEdge(object):
    """A controller edge is used to connect bodies and controllers together in a bipartite graph."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    controller = _swig_property(_Box2D.b2ControllerEdge_controller_get, _Box2D.b2ControllerEdge_controller_set)
    body = _swig_property(_Box2D.b2ControllerEdge_body_get, _Box2D.b2ControllerEdge_body_set)
    prevBody = _swig_property(_Box2D.b2ControllerEdge_prevBody_get, _Box2D.b2ControllerEdge_prevBody_set)
    nextBody = _swig_property(_Box2D.b2ControllerEdge_nextBody_get, _Box2D.b2ControllerEdge_nextBody_set)
    prevController = _swig_property(_Box2D.b2ControllerEdge_prevController_get, _Box2D.b2ControllerEdge_prevController_set)
    nextController = _swig_property(_Box2D.b2ControllerEdge_nextController_get, _Box2D.b2ControllerEdge_nextController_set)
    def __repr__(self):
     return """b2ControllerEdge(
       body       = %s,
       controller = %s)"""% tuple(str(a) for a in\
      (self.body,self.controller))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2ControllerEdge"""
        _Box2D.b2ControllerEdge_swiginit(self,_Box2D.new_b2ControllerEdge())
    __swig_destroy__ = _Box2D.delete_b2ControllerEdge
b2ControllerEdge_swigregister = _Box2D.b2ControllerEdge_swigregister
b2ControllerEdge_swigregister(b2ControllerEdge)

class b2Controller(object):
    """Base class for controllers. Controllers are a convience for encapsulating common per-step functionality."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Box2D.delete_b2Controller
    def Step(self, *args):
        """
        Step(self, b2TimeStep step)

        Controllers override this to implement per-step functionality.
        """
        return _Box2D.b2Controller_Step(self, *args)

    def Draw(self, *args):
        """
        Draw(self, b2DebugDraw debugDraw)

        Controllers override this to provide debug drawing.
        """
        return _Box2D.b2Controller_Draw(self, *args)

    def AddBody(self, *args):
        """
        AddBody(self, b2Body body)

        Adds a body to the controller list.
        """
        return _Box2D.b2Controller_AddBody(self, *args)

    def RemoveBody(self, *args):
        """
        RemoveBody(self, b2Body body)

        Removes a body from the controller list.
        """
        return _Box2D.b2Controller_RemoveBody(self, *args)

    def Clear(self):
        """
        Clear(self)

        Removes all bodies from the controller list.
        """
        return _Box2D.b2Controller_Clear(self)

    def GetType(self):
        """
        GetType(self) -> b2ControllerType

        Get the type of the controller.
        """
        return _Box2D.b2Controller_GetType(self)

    def GetNext(self):
        """
        GetNext(self) -> b2Controller

        Get the next controller in the world's body list.
        """
        return _Box2D.b2Controller_GetNext(self)

    def GetWorld(self):
        """
        GetWorld(self) -> b2World

        Get the parent world of this body.
        """
        return _Box2D.b2Controller_GetWorld(self)

    def _GetBodyList(self):
        """
        _GetBodyList(self) -> b2ControllerEdge

        Get the attached body list.
        """
        return _Box2D.b2Controller__GetBodyList(self)

    def __repr__(self):
     return "b2Controller()"

    __getstate__=no_pickle
    __setstate__=_generic_setstate

    def __hash__(self):
        """__hash__(self) -> long"""
        return _Box2D.b2Controller___hash__(self)

    def typeName(self):
        """
        Return the name of the controller from:
         Unknown, Buoyancy, ConstantAccel, ConstantForce, Gravity, TensorDamping
        """
        types = { e_unknownController       : 'Unknown',
                  e_buoyancyController      : 'Buoyancy',
                  e_constantAccelController : 'ConstantAccel',
                  e_constantForceController : 'ConstantForce',
                  e_gravityController       : 'Gravity',
                  e_tensorDampingController : 'TensorDamping' }
        return types[self.GetType()]
    def getAsType(self):
        """
        Return a typecasted version of the controller
        """
        return (getattr(self, "_as%sController" % self.typeName())) ()
    def GetBodyList(self):
        bodyList = []
        c_edge = self._GetBodyList()
        while c_edge:
            bodyList.append(c_edge.body)
            c_edge = c_edge.nextBody
        bodyList.reverse() # bodylist is in reverse order
        return bodyList

    def __iter__(self):
        """
        Iterates over the bodies in the controller
        """
        for body in self.bodyList:
            yield body

    __eq__ = b2ControllerCompare
    __ne__ = lambda self,other: not b2ControllerCompare(self,other)
    type = property(GetType, None)
    bodyList = property(GetBodyList, None)

    def _asBuoyancyController(self):
        """_asBuoyancyController(self) -> b2BuoyancyController"""
        return _Box2D.b2Controller__asBuoyancyController(self)

    def _asConstantAccelController(self):
        """_asConstantAccelController(self) -> b2ConstantAccelController"""
        return _Box2D.b2Controller__asConstantAccelController(self)

    def _asConstantForceController(self):
        """_asConstantForceController(self) -> b2ConstantForceController"""
        return _Box2D.b2Controller__asConstantForceController(self)

    def _asGravityController(self):
        """_asGravityController(self) -> b2GravityController"""
        return _Box2D.b2Controller__asGravityController(self)

    def _asTensorDampingController(self):
        """_asTensorDampingController(self) -> b2TensorDampingController"""
        return _Box2D.b2Controller__asTensorDampingController(self)

b2Controller.Step = new_instancemethod(_Box2D.b2Controller_Step,None,b2Controller)
b2Controller.Draw = new_instancemethod(_Box2D.b2Controller_Draw,None,b2Controller)
b2Controller.AddBody = new_instancemethod(_Box2D.b2Controller_AddBody,None,b2Controller)
b2Controller.RemoveBody = new_instancemethod(_Box2D.b2Controller_RemoveBody,None,b2Controller)
b2Controller.Clear = new_instancemethod(_Box2D.b2Controller_Clear,None,b2Controller)
b2Controller.GetType = new_instancemethod(_Box2D.b2Controller_GetType,None,b2Controller)
b2Controller.GetNext = new_instancemethod(_Box2D.b2Controller_GetNext,None,b2Controller)
b2Controller.GetWorld = new_instancemethod(_Box2D.b2Controller_GetWorld,None,b2Controller)
b2Controller._GetBodyList = new_instancemethod(_Box2D.b2Controller__GetBodyList,None,b2Controller)
b2Controller.__hash__ = new_instancemethod(_Box2D.b2Controller___hash__,None,b2Controller)
b2Controller._asBuoyancyController = new_instancemethod(_Box2D.b2Controller__asBuoyancyController,None,b2Controller)
b2Controller._asConstantAccelController = new_instancemethod(_Box2D.b2Controller__asConstantAccelController,None,b2Controller)
b2Controller._asConstantForceController = new_instancemethod(_Box2D.b2Controller__asConstantForceController,None,b2Controller)
b2Controller._asGravityController = new_instancemethod(_Box2D.b2Controller__asGravityController,None,b2Controller)
b2Controller._asTensorDampingController = new_instancemethod(_Box2D.b2Controller__asTensorDampingController,None,b2Controller)
b2Controller_swigregister = _Box2D.b2Controller_swigregister
b2Controller_swigregister(b2Controller)

class b2ControllerDef(object):
    """Proxy of C++ b2ControllerDef class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Box2D.delete_b2ControllerDef
    def __repr__(self):
     return "b2ControllerDef()"

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

b2ControllerDef_swigregister = _Box2D.b2ControllerDef_swigregister
b2ControllerDef_swigregister(b2ControllerDef)

class b2BodyDef(object):
    """A body definition holds all the data needed to construct a rigid body. You can safely re-use body definitions."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2BodyDef

        This constructor sets the body definition default values.
        """
        _Box2D.b2BodyDef_swiginit(self,_Box2D.new_b2BodyDef())
    massData = _swig_property(_Box2D.b2BodyDef_massData_get, _Box2D.b2BodyDef_massData_set)
    position = _swig_property(_Box2D.b2BodyDef_position_get, _Box2D.b2BodyDef_position_set)
    angle = _swig_property(_Box2D.b2BodyDef_angle_get, _Box2D.b2BodyDef_angle_set)
    linearDamping = _swig_property(_Box2D.b2BodyDef_linearDamping_get, _Box2D.b2BodyDef_linearDamping_set)
    angularDamping = _swig_property(_Box2D.b2BodyDef_angularDamping_get, _Box2D.b2BodyDef_angularDamping_set)
    allowSleep = _swig_property(_Box2D.b2BodyDef_allowSleep_get, _Box2D.b2BodyDef_allowSleep_set)
    isSleeping = _swig_property(_Box2D.b2BodyDef_isSleeping_get, _Box2D.b2BodyDef_isSleeping_set)
    fixedRotation = _swig_property(_Box2D.b2BodyDef_fixedRotation_get, _Box2D.b2BodyDef_fixedRotation_set)
    isBullet = _swig_property(_Box2D.b2BodyDef_isBullet_get, _Box2D.b2BodyDef_isBullet_set)
    def __repr__(self):
     return """b2BodyDef(
       allowSleep     = %s,
       angle          = %s,
       angularDamping = %s,
       fixedRotation  = %s,
       isBullet       = %s,
       isSleeping     = %s,
       linearDamping  = %s,
       massData       = %s,
       position       = %s,
       userData       = %s)"""% tuple(str(a) for a in\
      (self.allowSleep,self.angle,self.angularDamping,self.fixedRotation,self.isBullet,self.isSleeping,self.linearDamping,self.massData,self.position,self.userData))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def GetUserData(self):
        """GetUserData(self) -> PyObject"""
        return _Box2D.b2BodyDef_GetUserData(self)

    def SetUserData(self, *args):
        """SetUserData(self, PyObject data)"""
        return _Box2D.b2BodyDef_SetUserData(self, *args)

    def ClearUserData(self):
        """ClearUserData(self)"""
        return _Box2D.b2BodyDef_ClearUserData(self)

    userData = property(GetUserData, SetUserData)
    def __del__(self):
        self.ClearUserData()

    __swig_destroy__ = _Box2D.delete_b2BodyDef
b2BodyDef.GetUserData = new_instancemethod(_Box2D.b2BodyDef_GetUserData,None,b2BodyDef)
b2BodyDef.SetUserData = new_instancemethod(_Box2D.b2BodyDef_SetUserData,None,b2BodyDef)
b2BodyDef.ClearUserData = new_instancemethod(_Box2D.b2BodyDef_ClearUserData,None,b2BodyDef)
b2BodyDef_swigregister = _Box2D.b2BodyDef_swigregister
b2BodyDef_swigregister(b2BodyDef)

class b2Body(object):
    """A rigid body."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def SetMass(self, *args):
        """
        SetMass(self, b2MassData massData)

        Set the mass properties. Note that this changes the center of mass position. If you are not sure how to compute mass properties, use SetMassFromShapes. The inertia tensor is assumed to be relative to the center of mass.

        Parameters:
        -----------

        massData: the mass properties.
        """
        return _Box2D.b2Body_SetMass(self, *args)

    def SetMassFromShapes(self):
        """
        SetMassFromShapes(self)

        Compute the mass properties from the attached shapes. You typically call this after adding all the shapes. If you add or remove shapes later, you may want to call this again. Note that this changes the center of mass position.
        """
        return _Box2D.b2Body_SetMassFromShapes(self)

    def SetXForm(self, *args):
        """
        SetXForm(self, b2Vec2 position, float32 angle) -> bool

        Set the position of the body's origin and rotation (radians). This breaks any contacts and wakes the other bodies.

        Parameters:
        -----------

        position: the new world position of the body's origin (not necessarily the center of mass).

        angle: the new world rotation angle of the body in radians.

        false if the movement put a shape outside the world. In this case the body is automatically frozen.
        """
        return _Box2D.b2Body_SetXForm(self, *args)

    def GetXForm(self):
        """
        GetXForm(self) -> b2XForm

        Get the body transform for the body's origin. 
        the world transform of the body's origin.
        """
        return _Box2D.b2Body_GetXForm(self)

    def GetPosition(self):
        """
        GetPosition(self) -> b2Vec2

        Get the world body origin position. 
        the world position of the body's origin.
        """
        return _Box2D.b2Body_GetPosition(self)

    def GetAngle(self):
        """
        GetAngle(self) -> float32

        Get the angle in radians. 
        the current world rotation angle in radians.
        """
        return _Box2D.b2Body_GetAngle(self)

    def GetWorldCenter(self):
        """
        GetWorldCenter(self) -> b2Vec2

        Get the world position of the center of mass.
        """
        return _Box2D.b2Body_GetWorldCenter(self)

    def GetLocalCenter(self):
        """
        GetLocalCenter(self) -> b2Vec2

        Get the local position of the center of mass.
        """
        return _Box2D.b2Body_GetLocalCenter(self)

    def SetLinearVelocity(self, *args):
        """
        SetLinearVelocity(self, b2Vec2 v)

        Set the linear velocity of the center of mass.

        Parameters:
        -----------

        v: the new linear velocity of the center of mass.
        """
        return _Box2D.b2Body_SetLinearVelocity(self, *args)

    def GetLinearVelocity(self):
        """
        GetLinearVelocity(self) -> b2Vec2

        Get the linear velocity of the center of mass. 
        the linear velocity of the center of mass.
        """
        return _Box2D.b2Body_GetLinearVelocity(self)

    def SetAngularVelocity(self, *args):
        """
        SetAngularVelocity(self, float32 omega)

        Set the angular velocity.

        Parameters:
        -----------

        omega: the new angular velocity in radians/second.
        """
        return _Box2D.b2Body_SetAngularVelocity(self, *args)

    def GetAngularVelocity(self):
        """
        GetAngularVelocity(self) -> float32

        Get the angular velocity. 
        the angular velocity in radians/second.
        """
        return _Box2D.b2Body_GetAngularVelocity(self)

    def ApplyForce(self, *args):
        """
        ApplyForce(self, b2Vec2 force, b2Vec2 point)

        Apply a force at a world point. If the force is not applied at the center of mass, it will generate a torque and affect the angular velocity. This wakes up the body.

        Parameters:
        -----------

        force: the world force vector, usually in Newtons (N).

        point: the world position of the point of application.
        """
        return _Box2D.b2Body_ApplyForce(self, *args)

    def ApplyTorque(self, *args):
        """
        ApplyTorque(self, float32 torque)

        Apply a torque. This affects the angular velocity without affecting the linear velocity of the center of mass. This wakes up the body.

        Parameters:
        -----------

        torque: about the z-axis (out of the screen), usually in N-m.
        """
        return _Box2D.b2Body_ApplyTorque(self, *args)

    def ApplyImpulse(self, *args):
        """
        ApplyImpulse(self, b2Vec2 impulse, b2Vec2 point)

        Apply an impulse at a point. This immediately modifies the velocity. It also modifies the angular velocity if the point of application is not at the center of mass. This wakes up the body.

        Parameters:
        -----------

        impulse: the world impulse vector, usually in N-seconds or kg-m/s.

        point: the world position of the point of application.
        """
        return _Box2D.b2Body_ApplyImpulse(self, *args)

    def GetMass(self):
        """
        GetMass(self) -> float32

        Get the total mass of the body. 
        the mass, usually in kilograms (kg).
        """
        return _Box2D.b2Body_GetMass(self)

    def GetInertia(self):
        """
        GetInertia(self) -> float32

        Get the central rotational inertia of the body. 
        the rotational inertia, usually in kg-m^2.
        """
        return _Box2D.b2Body_GetInertia(self)

    def GetWorldPoint(self, *args):
        """
        GetWorldPoint(self, b2Vec2 localPoint) -> b2Vec2

        Get the world coordinates of a point given the local coordinates.

        Parameters:
        -----------

        localPoint: a point on the body measured relative the the body's origin.

        the same point expressed in world coordinates.
        """
        return _Box2D.b2Body_GetWorldPoint(self, *args)

    def GetWorldVector(self, *args):
        """
        GetWorldVector(self, b2Vec2 localVector) -> b2Vec2

        Get the world coordinates of a vector given the local coordinates.

        Parameters:
        -----------

        localVector: a vector fixed in the body.

        the same vector expressed in world coordinates.
        """
        return _Box2D.b2Body_GetWorldVector(self, *args)

    def GetLocalPoint(self, *args):
        """
        GetLocalPoint(self, b2Vec2 worldPoint) -> b2Vec2

        Gets a local point relative to the body's origin given a world point.

        Parameters:
        -----------

        a: point in world coordinates.

        the corresponding local point relative to the body's origin.
        """
        return _Box2D.b2Body_GetLocalPoint(self, *args)

    def GetLocalVector(self, *args):
        """
        GetLocalVector(self, b2Vec2 worldVector) -> b2Vec2

        Gets a local vector given a world vector.

        Parameters:
        -----------

        a: vector in world coordinates.

        the corresponding local vector.
        """
        return _Box2D.b2Body_GetLocalVector(self, *args)

    def GetLinearVelocityFromWorldPoint(self, *args):
        """
        GetLinearVelocityFromWorldPoint(self, b2Vec2 worldPoint) -> b2Vec2

        Get the world linear velocity of a world point attached to this body.

        Parameters:
        -----------

        a: point in world coordinates.

        the world velocity of a point.
        """
        return _Box2D.b2Body_GetLinearVelocityFromWorldPoint(self, *args)

    def GetLinearVelocityFromLocalPoint(self, *args):
        """
        GetLinearVelocityFromLocalPoint(self, b2Vec2 localPoint) -> b2Vec2

        Get the world velocity of a local point.

        Parameters:
        -----------

        a: point in local coordinates.

        the world velocity of a point.
        """
        return _Box2D.b2Body_GetLinearVelocityFromLocalPoint(self, *args)

    def GetLinearDamping(self):
        """
        GetLinearDamping(self) -> float32

        Get the linear damping.
        """
        return _Box2D.b2Body_GetLinearDamping(self)

    def SetLinearDamping(self, *args):
        """SetLinearDamping(self, float32 linearDamping)"""
        return _Box2D.b2Body_SetLinearDamping(self, *args)

    def GetAngularDamping(self):
        """
        GetAngularDamping(self) -> float32

        Get the angular damping.
        """
        return _Box2D.b2Body_GetAngularDamping(self)

    def SetAngularDamping(self, *args):
        """SetAngularDamping(self, float32 angularDamping)"""
        return _Box2D.b2Body_SetAngularDamping(self, *args)

    def IsBullet(self):
        """
        IsBullet(self) -> bool

        Is this body treated like a bullet for continuous collision detection?
        """
        return _Box2D.b2Body_IsBullet(self)

    def SetBullet(self, *args):
        """
        SetBullet(self, bool flag)

        Should this body be treated like a bullet for continuous collision detection?
        """
        return _Box2D.b2Body_SetBullet(self, *args)

    def IsFixedRotation(self):
        """IsFixedRotation(self) -> bool"""
        return _Box2D.b2Body_IsFixedRotation(self)

    def SetFixedRotation(self, *args):
        """SetFixedRotation(self, bool fixed)"""
        return _Box2D.b2Body_SetFixedRotation(self, *args)

    def IsStatic(self):
        """
        IsStatic(self) -> bool

        Is this body static (immovable)?
        """
        return _Box2D.b2Body_IsStatic(self)

    def SetStatic(self):
        """SetStatic(self)"""
        return _Box2D.b2Body_SetStatic(self)

    def IsDynamic(self):
        """
        IsDynamic(self) -> bool

        Is this body dynamic (movable)?
        """
        return _Box2D.b2Body_IsDynamic(self)

    def IsFrozen(self):
        """
        IsFrozen(self) -> bool

        Is this body frozen?
        """
        return _Box2D.b2Body_IsFrozen(self)

    def IsSleeping(self):
        """
        IsSleeping(self) -> bool

        Is this body sleeping (not simulating).
        """
        return _Box2D.b2Body_IsSleeping(self)

    def IsAllowSleeping(self):
        """IsAllowSleeping(self) -> bool"""
        return _Box2D.b2Body_IsAllowSleeping(self)

    def AllowSleeping(self, *args):
        """
        AllowSleeping(self, bool flag)

        You can disable sleeping on this body.
        """
        return _Box2D.b2Body_AllowSleeping(self, *args)

    def WakeUp(self):
        """
        WakeUp(self)

        Wake up this body so it will begin simulating.
        """
        return _Box2D.b2Body_WakeUp(self)

    def PutToSleep(self):
        """
        PutToSleep(self)

        Put this body to sleep so it will stop simulating. This also sets the velocity to zero.
        """
        return _Box2D.b2Body_PutToSleep(self)

    def _GetShapeList(self):
        """
        _GetShapeList(self) -> b2Shape

        Get the list of all shapes attached to this body.
        """
        return _Box2D.b2Body__GetShapeList(self)

    def GetJointList(self):
        """
        GetJointList(self) -> b2JointEdge

        Get the list of all joints attached to this body.
        """
        return _Box2D.b2Body_GetJointList(self)

    def GetControllerList(self):
        """
        GetControllerList(self) -> b2ControllerEdge

        Get the list of all controllers attached to this body.
        """
        return _Box2D.b2Body_GetControllerList(self)

    def GetNext(self):
        """
        GetNext(self) -> b2Body

        Get the next body in the world's body list.
        """
        return _Box2D.b2Body_GetNext(self)

    def GetWorld(self):
        """
        GetWorld(self) -> b2World

        Get the parent world of this body.
        """
        return _Box2D.b2Body_GetWorld(self)

    def __repr__(self):
     return """b2Body(
       allowSleep        = %s,
       angle             = %s,
       angularDamping    = %s,
       angularVelocity   = %s,
       fixedRotation     = %s,
       isBullet          = %s,
       isSleeping        = %s,
       linearDamping     = %s,
       linearVelocity    = %s,
       massData          = %s,
       position          = %s,
       userData          = %s,
       GetInertia()      = %s,
       GetLocalCenter()  = %s,
       GetMass()         = %s,
       GetWorldCenter()  = %s,
       GetXForm()        = %s,
       IsBullet()        = %s,
       IsDynamic()       = %s,
       IsFrozen()        = %s,
       IsFixedRotation() = %s,
       IsSleeping()      = %s,
       IsStatic()        = %s)"""% tuple(str(a) for a in\
      (self.allowSleep,self.angle,self.angularDamping,self.angularVelocity,self.fixedRotation,self.isBullet,self.isSleeping,self.linearDamping,self.linearVelocity,self.massData,self.position,self.userData,self.GetInertia(),self.GetLocalCenter(),self.GetMass(),self.GetWorldCenter(),self.GetXForm(),self.IsBullet(),self.IsDynamic(),self.IsFrozen(),self.IsFixedRotation(),self.IsSleeping(),self.IsStatic()))

    __getstate__=_pickle_body_getstate
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize

    def DestroyShape(self, *args):
        """
        DestroyShape(self, b2Shape shape)

        Destroy a shape. This removes the shape from the broad-phase and therefore destroys any contacts associated with this shape. All shapes attached to a body are implicitly destroyed when the body is destroyed.

        Parameters:
        -----------

        shape: the shape to be removed.

        WARNING: 
        This function is locked during callbacks.
        """
        return _Box2D.b2Body_DestroyShape(self, *args)

    def CreateShape(self, *args):
        """
        CreateShape(self, b2ShapeDef defn) -> b2Shape

        Creates a shape and attach it to this body.

        Parameters:
        -----------

        shapeDef: the shape definition.

        WARNING: 
        This function is locked during callbacks.
        """
        return _Box2D.b2Body_CreateShape(self, *args)

    def GetUserData(self):
        """
        GetUserData(self) -> PyObject

        Get the user data pointer that was provided in the body definition.
        """
        return _Box2D.b2Body_GetUserData(self)

    def SetUserData(self, *args):
        """
        SetUserData(self, PyObject data)

        Set the user data. Use this to store your application specific data.
        """
        return _Box2D.b2Body_SetUserData(self, *args)

    def ClearUserData(self):
        """ClearUserData(self)"""
        return _Box2D.b2Body_ClearUserData(self)

    userData = property(GetUserData, SetUserData)

    def __hash__(self):
        """__hash__(self) -> long"""
        return _Box2D.b2Body___hash__(self)

    __eq__ = b2BodyCompare
    __ne__ = lambda self,other: not b2BodyCompare(self,other)

    def setAngle(self, angle):
        """
        Set the angle without altering the position

        angle in radians.
        """
        self.SetXForm(self.position, angle)
    def setPosition(self, position):
        """
        Set the position without altering the angle
        """
        self.SetXForm(position, self.GetAngle())

    def getMassData(self):
        """
        Get a b2MassData object that represents this b2Body

        NOTE: To just get the mass, use body.mass (body.GetMass())
        """

        ret = b2MassData()
        ret.mass = self.GetMass()
        ret.I    = self.GetInertia()
        ret.center=self.GetLocalCenter()
        return ret

    def GetShapeList(self, asType=True):
        """
        Get a list of the shapes in this body

        Defaults to returning the typecasted objects.

        e.g., if there is a b2CircleShape and a b2PolygonShape:
        GetShapeList(True) = [b2CircleShape, b2PolygonShape]
        GetShapeList(False)= [b2Shape, b2Shape]
        """
        shapeList = []
        shape = self._GetShapeList()
        while shape:
            if asType:
                shape=shape.getAsType()
            shapeList.append(shape)
            shape = shape.GetNext()
        shapeList.reverse() # shapelist is in reverse order
        return shapeList

    def __iter__(self):
        """
        Iterates over the shapes in the body
        """
        for shape in self.shapeList:
            yield shape

    massData      = property(getMassData        , SetMass)
    position      = property(GetPosition        , setPosition)
    angle         = property(GetAngle           , setAngle)
    linearDamping = property(GetLinearDamping   , SetLinearDamping)
    angularDamping= property(GetAngularDamping  , SetAngularDamping)
    allowSleep    = property(IsAllowSleeping    , AllowSleeping)
    isSleeping    = property(IsSleeping         , None)
    fixedRotation = property(IsFixedRotation    , SetFixedRotation)
    isBullet      = property(IsBullet           , SetBullet)
    angularVelocity=property(GetAngularVelocity , SetAngularVelocity)
    linearVelocity =property(GetLinearVelocity  , SetLinearVelocity)
    shapeList      =property(GetShapeList       , None)

b2Body.SetMass = new_instancemethod(_Box2D.b2Body_SetMass,None,b2Body)
b2Body.SetMassFromShapes = new_instancemethod(_Box2D.b2Body_SetMassFromShapes,None,b2Body)
b2Body.SetXForm = new_instancemethod(_Box2D.b2Body_SetXForm,None,b2Body)
b2Body.GetXForm = new_instancemethod(_Box2D.b2Body_GetXForm,None,b2Body)
b2Body.GetPosition = new_instancemethod(_Box2D.b2Body_GetPosition,None,b2Body)
b2Body.GetAngle = new_instancemethod(_Box2D.b2Body_GetAngle,None,b2Body)
b2Body.GetWorldCenter = new_instancemethod(_Box2D.b2Body_GetWorldCenter,None,b2Body)
b2Body.GetLocalCenter = new_instancemethod(_Box2D.b2Body_GetLocalCenter,None,b2Body)
b2Body.SetLinearVelocity = new_instancemethod(_Box2D.b2Body_SetLinearVelocity,None,b2Body)
b2Body.GetLinearVelocity = new_instancemethod(_Box2D.b2Body_GetLinearVelocity,None,b2Body)
b2Body.SetAngularVelocity = new_instancemethod(_Box2D.b2Body_SetAngularVelocity,None,b2Body)
b2Body.GetAngularVelocity = new_instancemethod(_Box2D.b2Body_GetAngularVelocity,None,b2Body)
b2Body.ApplyForce = new_instancemethod(_Box2D.b2Body_ApplyForce,None,b2Body)
b2Body.ApplyTorque = new_instancemethod(_Box2D.b2Body_ApplyTorque,None,b2Body)
b2Body.ApplyImpulse = new_instancemethod(_Box2D.b2Body_ApplyImpulse,None,b2Body)
b2Body.GetMass = new_instancemethod(_Box2D.b2Body_GetMass,None,b2Body)
b2Body.GetInertia = new_instancemethod(_Box2D.b2Body_GetInertia,None,b2Body)
b2Body.GetWorldPoint = new_instancemethod(_Box2D.b2Body_GetWorldPoint,None,b2Body)
b2Body.GetWorldVector = new_instancemethod(_Box2D.b2Body_GetWorldVector,None,b2Body)
b2Body.GetLocalPoint = new_instancemethod(_Box2D.b2Body_GetLocalPoint,None,b2Body)
b2Body.GetLocalVector = new_instancemethod(_Box2D.b2Body_GetLocalVector,None,b2Body)
b2Body.GetLinearVelocityFromWorldPoint = new_instancemethod(_Box2D.b2Body_GetLinearVelocityFromWorldPoint,None,b2Body)
b2Body.GetLinearVelocityFromLocalPoint = new_instancemethod(_Box2D.b2Body_GetLinearVelocityFromLocalPoint,None,b2Body)
b2Body.GetLinearDamping = new_instancemethod(_Box2D.b2Body_GetLinearDamping,None,b2Body)
b2Body.SetLinearDamping = new_instancemethod(_Box2D.b2Body_SetLinearDamping,None,b2Body)
b2Body.GetAngularDamping = new_instancemethod(_Box2D.b2Body_GetAngularDamping,None,b2Body)
b2Body.SetAngularDamping = new_instancemethod(_Box2D.b2Body_SetAngularDamping,None,b2Body)
b2Body.IsBullet = new_instancemethod(_Box2D.b2Body_IsBullet,None,b2Body)
b2Body.SetBullet = new_instancemethod(_Box2D.b2Body_SetBullet,None,b2Body)
b2Body.IsFixedRotation = new_instancemethod(_Box2D.b2Body_IsFixedRotation,None,b2Body)
b2Body.SetFixedRotation = new_instancemethod(_Box2D.b2Body_SetFixedRotation,None,b2Body)
b2Body.IsStatic = new_instancemethod(_Box2D.b2Body_IsStatic,None,b2Body)
b2Body.SetStatic = new_instancemethod(_Box2D.b2Body_SetStatic,None,b2Body)
b2Body.IsDynamic = new_instancemethod(_Box2D.b2Body_IsDynamic,None,b2Body)
b2Body.IsFrozen = new_instancemethod(_Box2D.b2Body_IsFrozen,None,b2Body)
b2Body.IsSleeping = new_instancemethod(_Box2D.b2Body_IsSleeping,None,b2Body)
b2Body.IsAllowSleeping = new_instancemethod(_Box2D.b2Body_IsAllowSleeping,None,b2Body)
b2Body.AllowSleeping = new_instancemethod(_Box2D.b2Body_AllowSleeping,None,b2Body)
b2Body.WakeUp = new_instancemethod(_Box2D.b2Body_WakeUp,None,b2Body)
b2Body.PutToSleep = new_instancemethod(_Box2D.b2Body_PutToSleep,None,b2Body)
b2Body._GetShapeList = new_instancemethod(_Box2D.b2Body__GetShapeList,None,b2Body)
b2Body.GetJointList = new_instancemethod(_Box2D.b2Body_GetJointList,None,b2Body)
b2Body.GetControllerList = new_instancemethod(_Box2D.b2Body_GetControllerList,None,b2Body)
b2Body.GetNext = new_instancemethod(_Box2D.b2Body_GetNext,None,b2Body)
b2Body.GetWorld = new_instancemethod(_Box2D.b2Body_GetWorld,None,b2Body)
b2Body.DestroyShape = new_instancemethod(_Box2D.b2Body_DestroyShape,None,b2Body)
b2Body.CreateShape = new_instancemethod(_Box2D.b2Body_CreateShape,None,b2Body)
b2Body.GetUserData = new_instancemethod(_Box2D.b2Body_GetUserData,None,b2Body)
b2Body.SetUserData = new_instancemethod(_Box2D.b2Body_SetUserData,None,b2Body)
b2Body.ClearUserData = new_instancemethod(_Box2D.b2Body_ClearUserData,None,b2Body)
b2Body.__hash__ = new_instancemethod(_Box2D.b2Body___hash__,None,b2Body)
b2Body_swigregister = _Box2D.b2Body_swigregister
b2Body_swigregister(b2Body)

class b2BuoyancyController(b2Controller):
    """Calculates buoyancy forces for fluids in the form of a half plane."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    normal = _swig_property(_Box2D.b2BuoyancyController_normal_get, _Box2D.b2BuoyancyController_normal_set)
    offset = _swig_property(_Box2D.b2BuoyancyController_offset_get, _Box2D.b2BuoyancyController_offset_set)
    density = _swig_property(_Box2D.b2BuoyancyController_density_get, _Box2D.b2BuoyancyController_density_set)
    velocity = _swig_property(_Box2D.b2BuoyancyController_velocity_get, _Box2D.b2BuoyancyController_velocity_set)
    linearDrag = _swig_property(_Box2D.b2BuoyancyController_linearDrag_get, _Box2D.b2BuoyancyController_linearDrag_set)
    angularDrag = _swig_property(_Box2D.b2BuoyancyController_angularDrag_get, _Box2D.b2BuoyancyController_angularDrag_set)
    useDensity = _swig_property(_Box2D.b2BuoyancyController_useDensity_get, _Box2D.b2BuoyancyController_useDensity_set)
    useWorldGravity = _swig_property(_Box2D.b2BuoyancyController_useWorldGravity_get, _Box2D.b2BuoyancyController_useWorldGravity_set)
    gravity = _swig_property(_Box2D.b2BuoyancyController_gravity_get, _Box2D.b2BuoyancyController_gravity_set)
    def __repr__(self):
     return """b2BuoyancyController(
       angularDrag     = %s,
       density         = %s,
       gravity         = %s,
       linearDrag      = %s,
       normal          = %s,
       offset          = %s,
       useDensity      = %s,
       useWorldGravity = %s,
       velocity        = %s)"""% tuple(str(a) for a in\
      (self.angularDrag,self.density,self.gravity,self.linearDrag,self.normal,self.offset,self.useDensity,self.useWorldGravity,self.velocity))

    __getstate__=_pickle_get_controller
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_controller

    __swig_destroy__ = _Box2D.delete_b2BuoyancyController
b2BuoyancyController_swigregister = _Box2D.b2BuoyancyController_swigregister
b2BuoyancyController_swigregister(b2BuoyancyController)

class b2BuoyancyControllerDef(b2ControllerDef):
    """This class is used to build buoyancy controllers."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    normal = _swig_property(_Box2D.b2BuoyancyControllerDef_normal_get, _Box2D.b2BuoyancyControllerDef_normal_set)
    offset = _swig_property(_Box2D.b2BuoyancyControllerDef_offset_get, _Box2D.b2BuoyancyControllerDef_offset_set)
    density = _swig_property(_Box2D.b2BuoyancyControllerDef_density_get, _Box2D.b2BuoyancyControllerDef_density_set)
    velocity = _swig_property(_Box2D.b2BuoyancyControllerDef_velocity_get, _Box2D.b2BuoyancyControllerDef_velocity_set)
    linearDrag = _swig_property(_Box2D.b2BuoyancyControllerDef_linearDrag_get, _Box2D.b2BuoyancyControllerDef_linearDrag_set)
    angularDrag = _swig_property(_Box2D.b2BuoyancyControllerDef_angularDrag_get, _Box2D.b2BuoyancyControllerDef_angularDrag_set)
    useDensity = _swig_property(_Box2D.b2BuoyancyControllerDef_useDensity_get, _Box2D.b2BuoyancyControllerDef_useDensity_set)
    useWorldGravity = _swig_property(_Box2D.b2BuoyancyControllerDef_useWorldGravity_get, _Box2D.b2BuoyancyControllerDef_useWorldGravity_set)
    gravity = _swig_property(_Box2D.b2BuoyancyControllerDef_gravity_get, _Box2D.b2BuoyancyControllerDef_gravity_set)
    def __init__(self): 
        """
        __init__(self) -> b2BuoyancyControllerDef

        This class is used to build buoyancy controllers.
        """
        _Box2D.b2BuoyancyControllerDef_swiginit(self,_Box2D.new_b2BuoyancyControllerDef())
    def __repr__(self):
     return """b2BuoyancyControllerDef(
       angularDrag     = %s,
       density         = %s,
       gravity         = %s,
       linearDrag      = %s,
       normal          = %s,
       offset          = %s,
       useDensity      = %s,
       useWorldGravity = %s,
       velocity        = %s)"""% tuple(str(a) for a in\
      (self.angularDrag,self.density,self.gravity,self.linearDrag,self.normal,self.offset,self.useDensity,self.useWorldGravity,self.velocity))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2BuoyancyControllerDef
b2BuoyancyControllerDef_swigregister = _Box2D.b2BuoyancyControllerDef_swigregister
b2BuoyancyControllerDef_swigregister(b2BuoyancyControllerDef)

class b2ConstantAccelController(b2Controller):
    """Applies a force every frame."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    A = _swig_property(_Box2D.b2ConstantAccelController_A_get, _Box2D.b2ConstantAccelController_A_set)
    def __repr__(self):
     return """b2ConstantAccelController(
       A = %s)"""% tuple(str(a) for a in\
      (self.A))

    __getstate__=_pickle_get_controller
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_controller

    __swig_destroy__ = _Box2D.delete_b2ConstantAccelController
b2ConstantAccelController_swigregister = _Box2D.b2ConstantAccelController_swigregister
b2ConstantAccelController_swigregister(b2ConstantAccelController)

class b2ConstantAccelControllerDef(b2ControllerDef):
    """This class is used to build constant acceleration controllers."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    A = _swig_property(_Box2D.b2ConstantAccelControllerDef_A_get, _Box2D.b2ConstantAccelControllerDef_A_set)
    def __repr__(self):
     return """b2ConstantAccelControllerDef(
       A = %s)"""% tuple(str(a) for a in\
      (self.A))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2ConstantAccelControllerDef"""
        _Box2D.b2ConstantAccelControllerDef_swiginit(self,_Box2D.new_b2ConstantAccelControllerDef())
    __swig_destroy__ = _Box2D.delete_b2ConstantAccelControllerDef
b2ConstantAccelControllerDef_swigregister = _Box2D.b2ConstantAccelControllerDef_swigregister
b2ConstantAccelControllerDef_swigregister(b2ConstantAccelControllerDef)

class b2ConstantForceController(b2Controller):
    """Applies a force every frame."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    F = _swig_property(_Box2D.b2ConstantForceController_F_get, _Box2D.b2ConstantForceController_F_set)
    def __repr__(self):
     return """b2ConstantForceController(
       F = %s)"""% tuple(str(a) for a in\
      (self.F))

    __getstate__=_pickle_get_controller
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_controller

    __swig_destroy__ = _Box2D.delete_b2ConstantForceController
b2ConstantForceController_swigregister = _Box2D.b2ConstantForceController_swigregister
b2ConstantForceController_swigregister(b2ConstantForceController)

class b2ConstantForceControllerDef(b2ControllerDef):
    """This class is used to build constant force controllers."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    F = _swig_property(_Box2D.b2ConstantForceControllerDef_F_get, _Box2D.b2ConstantForceControllerDef_F_set)
    def __repr__(self):
     return """b2ConstantForceControllerDef(
       F = %s)"""% tuple(str(a) for a in\
      (self.F))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2ConstantForceControllerDef"""
        _Box2D.b2ConstantForceControllerDef_swiginit(self,_Box2D.new_b2ConstantForceControllerDef())
    __swig_destroy__ = _Box2D.delete_b2ConstantForceControllerDef
b2ConstantForceControllerDef_swigregister = _Box2D.b2ConstantForceControllerDef_swigregister
b2ConstantForceControllerDef_swigregister(b2ConstantForceControllerDef)

class b2GravityController(b2Controller):
    """Applies simplified gravity between every pair of bodies."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    G = _swig_property(_Box2D.b2GravityController_G_get, _Box2D.b2GravityController_G_set)
    invSqr = _swig_property(_Box2D.b2GravityController_invSqr_get, _Box2D.b2GravityController_invSqr_set)
    def __repr__(self):
     return """b2GravityController(
       G      = %s,
       invSqr = %s)"""% tuple(str(a) for a in\
      (self.G,self.invSqr))

    __getstate__=_pickle_get_controller
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_controller

    __swig_destroy__ = _Box2D.delete_b2GravityController
b2GravityController_swigregister = _Box2D.b2GravityController_swigregister
b2GravityController_swigregister(b2GravityController)

class b2GravityControllerDef(b2ControllerDef):
    """This class is used to build gravity controllers."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    G = _swig_property(_Box2D.b2GravityControllerDef_G_get, _Box2D.b2GravityControllerDef_G_set)
    invSqr = _swig_property(_Box2D.b2GravityControllerDef_invSqr_get, _Box2D.b2GravityControllerDef_invSqr_set)
    def __repr__(self):
     return """b2GravityControllerDef(
       G      = %s,
       invSqr = %s)"""% tuple(str(a) for a in\
      (self.G,self.invSqr))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2GravityControllerDef"""
        _Box2D.b2GravityControllerDef_swiginit(self,_Box2D.new_b2GravityControllerDef())
    __swig_destroy__ = _Box2D.delete_b2GravityControllerDef
b2GravityControllerDef_swigregister = _Box2D.b2GravityControllerDef_swigregister
b2GravityControllerDef_swigregister(b2GravityControllerDef)

class b2TensorDampingController(b2Controller):
    """Applies top down linear damping to the controlled bodies The damping is calculated by multiplying velocity by a matrix in local co-ordinates."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    T = _swig_property(_Box2D.b2TensorDampingController_T_get, _Box2D.b2TensorDampingController_T_set)
    maxTimestep = _swig_property(_Box2D.b2TensorDampingController_maxTimestep_get, _Box2D.b2TensorDampingController_maxTimestep_set)
    def __repr__(self):
     return """b2TensorDampingController(
       T           = %s,
       maxTimestep = %s)"""% tuple(str(a) for a in\
      (self.T,self.maxTimestep))

    __getstate__=_pickle_get_controller
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_controller

    __swig_destroy__ = _Box2D.delete_b2TensorDampingController
b2TensorDampingController_swigregister = _Box2D.b2TensorDampingController_swigregister
b2TensorDampingController_swigregister(b2TensorDampingController)

class b2TensorDampingControllerDef(b2ControllerDef):
    """This class is used to build tensor damping controllers."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    T = _swig_property(_Box2D.b2TensorDampingControllerDef_T_get, _Box2D.b2TensorDampingControllerDef_T_set)
    maxTimestep = _swig_property(_Box2D.b2TensorDampingControllerDef_maxTimestep_get, _Box2D.b2TensorDampingControllerDef_maxTimestep_set)
    def SetAxisAligned(self, *args):
        """
        SetAxisAligned(self, float32 xDamping, float32 yDamping)

        Sets damping independantly along the x and y axes.
        """
        return _Box2D.b2TensorDampingControllerDef_SetAxisAligned(self, *args)

    def __repr__(self):
     return """b2TensorDampingControllerDef(
       T           = %s,
       maxTimestep = %s)"""% tuple(str(a) for a in\
      (self.T,self.maxTimestep))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    def __init__(self): 
        """__init__(self) -> b2TensorDampingControllerDef"""
        _Box2D.b2TensorDampingControllerDef_swiginit(self,_Box2D.new_b2TensorDampingControllerDef())
    __swig_destroy__ = _Box2D.delete_b2TensorDampingControllerDef
b2TensorDampingControllerDef.SetAxisAligned = new_instancemethod(_Box2D.b2TensorDampingControllerDef_SetAxisAligned,None,b2TensorDampingControllerDef)
b2TensorDampingControllerDef_swigregister = _Box2D.b2TensorDampingControllerDef_swigregister
b2TensorDampingControllerDef_swigregister(b2TensorDampingControllerDef)

class b2DistanceJointDef(b2JointDef):
    """
    Distance joint definition. This requires defining an anchor point on both bodies and the non-zero length of the distance joint. The definition uses local anchor points so that the initial configuration can violate the constraint slightly. This helps when saving and loading a game. 
    WARNING: 
    Do not use a zero or short length.
    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2DistanceJointDef

        Distance joint definition. This requires defining an anchor point on both bodies and the non-zero length of the distance joint. The definition uses local anchor points so that the initial configuration can violate the constraint slightly. This helps when saving and loading a game. 
        WARNING: 
        Do not use a zero or short length.
        """
        _Box2D.b2DistanceJointDef_swiginit(self,_Box2D.new_b2DistanceJointDef())
    def Initialize(self, *args):
        """
        Initialize(self, b2Body body1, b2Body body2, b2Vec2 anchor1, b2Vec2 anchor2)

        Initialize the bodies, anchors, and length using the world anchors.
        """
        return _Box2D.b2DistanceJointDef_Initialize(self, *args)

    localAnchor1 = _swig_property(_Box2D.b2DistanceJointDef_localAnchor1_get, _Box2D.b2DistanceJointDef_localAnchor1_set)
    localAnchor2 = _swig_property(_Box2D.b2DistanceJointDef_localAnchor2_get, _Box2D.b2DistanceJointDef_localAnchor2_set)
    length = _swig_property(_Box2D.b2DistanceJointDef_length_get, _Box2D.b2DistanceJointDef_length_set)
    frequencyHz = _swig_property(_Box2D.b2DistanceJointDef_frequencyHz_get, _Box2D.b2DistanceJointDef_frequencyHz_set)
    dampingRatio = _swig_property(_Box2D.b2DistanceJointDef_dampingRatio_get, _Box2D.b2DistanceJointDef_dampingRatio_set)
    def __repr__(self):
     return """b2DistanceJointDef(
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       dampingRatio     = %s,
       frequencyHz      = %s,
       length           = %s,
       localAnchor1     = %s,
       localAnchor2     = %s,
       type             = %s,
       userData         = %s)"""% tuple(str(a) for a in\
      (self.body1,self.body2,self.collideConnected,self.dampingRatio,self.frequencyHz,self.length,self.localAnchor1,self.localAnchor2,self.type,self.userData))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2DistanceJointDef
b2DistanceJointDef.Initialize = new_instancemethod(_Box2D.b2DistanceJointDef_Initialize,None,b2DistanceJointDef)
b2DistanceJointDef_swigregister = _Box2D.b2DistanceJointDef_swigregister
b2DistanceJointDef_swigregister(b2DistanceJointDef)

class b2DistanceJoint(b2Joint):
    """A distance joint constrains two points on two bodies to remain at a fixed distance from each other. You can view this as a massless, rigid rod."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, b2DistanceJointDef data) -> b2DistanceJoint

        A distance joint constrains two points on two bodies to remain at a fixed distance from each other. You can view this as a massless, rigid rod.
        """
        _Box2D.b2DistanceJoint_swiginit(self,_Box2D.new_b2DistanceJoint(*args))
    def InitVelocityConstraints(self, *args):
        """InitVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2DistanceJoint_InitVelocityConstraints(self, *args)

    def SolveVelocityConstraints(self, *args):
        """SolveVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2DistanceJoint_SolveVelocityConstraints(self, *args)

    def SolvePositionConstraints(self, *args):
        """SolvePositionConstraints(self, float32 baumgarte) -> bool"""
        return _Box2D.b2DistanceJoint_SolvePositionConstraints(self, *args)

    localAnchor1 = _swig_property(_Box2D.b2DistanceJoint_localAnchor1_get, _Box2D.b2DistanceJoint_localAnchor1_set)
    localAnchor2 = _swig_property(_Box2D.b2DistanceJoint_localAnchor2_get, _Box2D.b2DistanceJoint_localAnchor2_set)
    u = _swig_property(_Box2D.b2DistanceJoint_u_get, _Box2D.b2DistanceJoint_u_set)
    frequencyHz = _swig_property(_Box2D.b2DistanceJoint_frequencyHz_get, _Box2D.b2DistanceJoint_frequencyHz_set)
    dampingRatio = _swig_property(_Box2D.b2DistanceJoint_dampingRatio_get, _Box2D.b2DistanceJoint_dampingRatio_set)
    gamma = _swig_property(_Box2D.b2DistanceJoint_gamma_get, _Box2D.b2DistanceJoint_gamma_set)
    bias = _swig_property(_Box2D.b2DistanceJoint_bias_get, _Box2D.b2DistanceJoint_bias_set)
    impulse = _swig_property(_Box2D.b2DistanceJoint_impulse_get, _Box2D.b2DistanceJoint_impulse_set)
    mass = _swig_property(_Box2D.b2DistanceJoint_mass_get, _Box2D.b2DistanceJoint_mass_set)
    length = _swig_property(_Box2D.b2DistanceJoint_length_get, _Box2D.b2DistanceJoint_length_set)
    def __repr__(self):
     return """b2DistanceJoint(
       bias             = %s,
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       dampingRatio     = %s,
       frequencyHz      = %s,
       gamma            = %s,
       impulse          = %s,
       length           = %s,
       localAnchor1     = %s,
       localAnchor2     = %s,
       mass             = %s,
       type             = %s,
       u                = %s,
       userData         = %s,
       GetAnchor1()     = %s,
       GetAnchor2()     = %s)"""% tuple(str(a) for a in\
      (self.bias,self.body1,self.body2,self.collideConnected,self.dampingRatio,self.frequencyHz,self.gamma,self.impulse,self.length,self.localAnchor1,self.localAnchor2,self.mass,self.type,self.u,self.userData,self.GetAnchor1(),self.GetAnchor2()))

    __getstate__=_pickle_get_joint
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_joint

    __swig_destroy__ = _Box2D.delete_b2DistanceJoint
b2DistanceJoint.InitVelocityConstraints = new_instancemethod(_Box2D.b2DistanceJoint_InitVelocityConstraints,None,b2DistanceJoint)
b2DistanceJoint.SolveVelocityConstraints = new_instancemethod(_Box2D.b2DistanceJoint_SolveVelocityConstraints,None,b2DistanceJoint)
b2DistanceJoint.SolvePositionConstraints = new_instancemethod(_Box2D.b2DistanceJoint_SolvePositionConstraints,None,b2DistanceJoint)
b2DistanceJoint_swigregister = _Box2D.b2DistanceJoint_swigregister
b2DistanceJoint_swigregister(b2DistanceJoint)

class b2GearJointDef(b2JointDef):
    """Gear joint definition. This definition requires two existing revolute or prismatic joints (any combination will work). The provided joints must attach a dynamic body to a static body."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2GearJointDef

        Gear joint definition. This definition requires two existing revolute or prismatic joints (any combination will work). The provided joints must attach a dynamic body to a static body.
        """
        _Box2D.b2GearJointDef_swiginit(self,_Box2D.new_b2GearJointDef())
    joint1 = _swig_property(_Box2D.b2GearJointDef_joint1_get, _Box2D.b2GearJointDef_joint1_set)
    joint2 = _swig_property(_Box2D.b2GearJointDef_joint2_get, _Box2D.b2GearJointDef_joint2_set)
    ratio = _swig_property(_Box2D.b2GearJointDef_ratio_get, _Box2D.b2GearJointDef_ratio_set)
    def __repr__(self):
     return """b2GearJointDef(
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       joint1           = %s,
       joint2           = %s,
       ratio            = %s,
       type             = %s,
       userData         = %s)"""% tuple(str(a) for a in\
      (self.body1,self.body2,self.collideConnected,self.joint1,self.joint2,self.ratio,self.type,self.userData))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2GearJointDef
b2GearJointDef_swigregister = _Box2D.b2GearJointDef_swigregister
b2GearJointDef_swigregister(b2GearJointDef)

class b2GearJoint(b2Joint):
    """
    A gear joint is used to connect two joints together. Either joint can be a revolute or prismatic joint. You specify a gear ratio to bind the motions together: coordinate1 + ratio * coordinate2 = constant The ratio can be negative or positive. If one joint is a revolute joint and the other joint is a prismatic joint, then the ratio will have units of length or units of 1/length. 
    WARNING: 
    The revolute and prismatic joints must be attached to fixed bodies (which must be body1 on those joints).
    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def GetRatio(self):
        """
        GetRatio(self) -> float32

        Get the gear ratio.
        """
        return _Box2D.b2GearJoint_GetRatio(self)

    def __init__(self, *args): 
        """
        __init__(self, b2GearJointDef data) -> b2GearJoint

        A gear joint is used to connect two joints together. Either joint can be a revolute or prismatic joint. You specify a gear ratio to bind the motions together: coordinate1 + ratio * coordinate2 = constant The ratio can be negative or positive. If one joint is a revolute joint and the other joint is a prismatic joint, then the ratio will have units of length or units of 1/length. 
        WARNING: 
        The revolute and prismatic joints must be attached to fixed bodies (which must be body1 on those joints).
        """
        _Box2D.b2GearJoint_swiginit(self,_Box2D.new_b2GearJoint(*args))
    def InitVelocityConstraints(self, *args):
        """InitVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2GearJoint_InitVelocityConstraints(self, *args)

    def SolveVelocityConstraints(self, *args):
        """SolveVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2GearJoint_SolveVelocityConstraints(self, *args)

    def SolvePositionConstraints(self, *args):
        """SolvePositionConstraints(self, float32 baumgarte) -> bool"""
        return _Box2D.b2GearJoint_SolvePositionConstraints(self, *args)

    ground1 = _swig_property(_Box2D.b2GearJoint_ground1_get, _Box2D.b2GearJoint_ground1_set)
    ground2 = _swig_property(_Box2D.b2GearJoint_ground2_get, _Box2D.b2GearJoint_ground2_set)
    revolute1 = _swig_property(_Box2D.b2GearJoint_revolute1_get, _Box2D.b2GearJoint_revolute1_set)
    prismatic1 = _swig_property(_Box2D.b2GearJoint_prismatic1_get, _Box2D.b2GearJoint_prismatic1_set)
    revolute2 = _swig_property(_Box2D.b2GearJoint_revolute2_get, _Box2D.b2GearJoint_revolute2_set)
    prismatic2 = _swig_property(_Box2D.b2GearJoint_prismatic2_get, _Box2D.b2GearJoint_prismatic2_set)
    groundAnchor1 = _swig_property(_Box2D.b2GearJoint_groundAnchor1_get, _Box2D.b2GearJoint_groundAnchor1_set)
    groundAnchor2 = _swig_property(_Box2D.b2GearJoint_groundAnchor2_get, _Box2D.b2GearJoint_groundAnchor2_set)
    localAnchor1 = _swig_property(_Box2D.b2GearJoint_localAnchor1_get, _Box2D.b2GearJoint_localAnchor1_set)
    localAnchor2 = _swig_property(_Box2D.b2GearJoint_localAnchor2_get, _Box2D.b2GearJoint_localAnchor2_set)
    J = _swig_property(_Box2D.b2GearJoint_J_get, _Box2D.b2GearJoint_J_set)
    constant = _swig_property(_Box2D.b2GearJoint_constant_get, _Box2D.b2GearJoint_constant_set)
    ratio = _swig_property(_Box2D.b2GearJoint_ratio_get, _Box2D.b2GearJoint_ratio_set)
    mass = _swig_property(_Box2D.b2GearJoint_mass_get, _Box2D.b2GearJoint_mass_set)
    impulse = _swig_property(_Box2D.b2GearJoint_impulse_get, _Box2D.b2GearJoint_impulse_set)
    def __repr__(self):
     return """b2GearJoint(
       J                = %s,
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       constant         = %s,
       ground1          = %s,
       ground2          = %s,
       groundAnchor1    = %s,
       groundAnchor2    = %s,
       impulse          = %s,
       joint1           = %s,
       joint2           = %s,
       localAnchor1     = %s,
       localAnchor2     = %s,
       mass             = %s,
       prismatic1       = %s,
       prismatic2       = %s,
       ratio            = %s,
       revolute1        = %s,
       revolute2        = %s,
       type             = %s,
       userData         = %s,
       GetAnchor1()     = %s,
       GetAnchor2()     = %s)"""% tuple(str(a) for a in\
      (self.J,self.body1,self.body2,self.collideConnected,self.constant,self.ground1,self.ground2,self.groundAnchor1,self.groundAnchor2,self.impulse,self.joint1,self.joint2,self.localAnchor1,self.localAnchor2,self.mass,self.prismatic1,self.prismatic2,self.ratio,self.revolute1,self.revolute2,self.type,self.userData,self.GetAnchor1(),self.GetAnchor2()))

    __getstate__=_pickle_get_joint
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_joint

    joint1 = property(lambda self: (self.revolute1 and self.revolute1) or self.prismatic1, None)
    joint2 = property(lambda self: (self.revolute2 and self.revolute2) or self.prismatic2, None)

    __swig_destroy__ = _Box2D.delete_b2GearJoint
b2GearJoint.GetRatio = new_instancemethod(_Box2D.b2GearJoint_GetRatio,None,b2GearJoint)
b2GearJoint.InitVelocityConstraints = new_instancemethod(_Box2D.b2GearJoint_InitVelocityConstraints,None,b2GearJoint)
b2GearJoint.SolveVelocityConstraints = new_instancemethod(_Box2D.b2GearJoint_SolveVelocityConstraints,None,b2GearJoint)
b2GearJoint.SolvePositionConstraints = new_instancemethod(_Box2D.b2GearJoint_SolvePositionConstraints,None,b2GearJoint)
b2GearJoint_swigregister = _Box2D.b2GearJoint_swigregister
b2GearJoint_swigregister(b2GearJoint)

class b2LineJointDef(b2JointDef):
    """Line joint definition. This requires defining a line of motion using an axis and an anchor point. The definition uses local anchor points and a local axis so that the initial configuration can violate the constraint slightly. The joint translation is zero when the local anchor points coincide in world space. Using local anchors and a local axis helps when saving and loading a game."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2LineJointDef

        Line joint definition. This requires defining a line of motion using an axis and an anchor point. The definition uses local anchor points and a local axis so that the initial configuration can violate the constraint slightly. The joint translation is zero when the local anchor points coincide in world space. Using local anchors and a local axis helps when saving and loading a game.
        """
        _Box2D.b2LineJointDef_swiginit(self,_Box2D.new_b2LineJointDef())
    def Initialize(self, *args):
        """
        Initialize(self, b2Body body1, b2Body body2, b2Vec2 anchor, b2Vec2 axis)

        Initialize the bodies, anchors, axis, and reference angle using the world anchor and world axis.
        """
        return _Box2D.b2LineJointDef_Initialize(self, *args)

    localAnchor1 = _swig_property(_Box2D.b2LineJointDef_localAnchor1_get, _Box2D.b2LineJointDef_localAnchor1_set)
    localAnchor2 = _swig_property(_Box2D.b2LineJointDef_localAnchor2_get, _Box2D.b2LineJointDef_localAnchor2_set)
    localAxis1 = _swig_property(_Box2D.b2LineJointDef_localAxis1_get, _Box2D.b2LineJointDef_localAxis1_set)
    enableLimit = _swig_property(_Box2D.b2LineJointDef_enableLimit_get, _Box2D.b2LineJointDef_enableLimit_set)
    lowerTranslation = _swig_property(_Box2D.b2LineJointDef_lowerTranslation_get, _Box2D.b2LineJointDef_lowerTranslation_set)
    upperTranslation = _swig_property(_Box2D.b2LineJointDef_upperTranslation_get, _Box2D.b2LineJointDef_upperTranslation_set)
    enableMotor = _swig_property(_Box2D.b2LineJointDef_enableMotor_get, _Box2D.b2LineJointDef_enableMotor_set)
    maxMotorForce = _swig_property(_Box2D.b2LineJointDef_maxMotorForce_get, _Box2D.b2LineJointDef_maxMotorForce_set)
    motorSpeed = _swig_property(_Box2D.b2LineJointDef_motorSpeed_get, _Box2D.b2LineJointDef_motorSpeed_set)
    def __repr__(self):
     return """b2LineJointDef(
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       enableLimit      = %s,
       enableMotor      = %s,
       localAnchor1     = %s,
       localAnchor2     = %s,
       localAxis1       = %s,
       lowerTranslation = %s,
       maxMotorForce    = %s,
       motorSpeed       = %s,
       type             = %s,
       upperTranslation = %s,
       userData         = %s)"""% tuple(str(a) for a in\
      (self.body1,self.body2,self.collideConnected,self.enableLimit,self.enableMotor,self.localAnchor1,self.localAnchor2,self.localAxis1,self.lowerTranslation,self.maxMotorForce,self.motorSpeed,self.type,self.upperTranslation,self.userData))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2LineJointDef
b2LineJointDef.Initialize = new_instancemethod(_Box2D.b2LineJointDef_Initialize,None,b2LineJointDef)
b2LineJointDef_swigregister = _Box2D.b2LineJointDef_swigregister
b2LineJointDef_swigregister(b2LineJointDef)

class b2LineJoint(b2Joint):
    """A line joint. This joint provides one degree of freedom: translation along an axis fixed in body1. You can use a joint limit to restrict the range of motion and a joint motor to drive the motion or to model joint friction."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def GetJointTranslation(self):
        """
        GetJointTranslation(self) -> float32

        Get the current joint translation, usually in meters.
        """
        return _Box2D.b2LineJoint_GetJointTranslation(self)

    def GetJointSpeed(self):
        """
        GetJointSpeed(self) -> float32

        Get the current joint translation speed, usually in meters per second.
        """
        return _Box2D.b2LineJoint_GetJointSpeed(self)

    def IsLimitEnabled(self):
        """
        IsLimitEnabled(self) -> bool

        Is the joint limit enabled?
        """
        return _Box2D.b2LineJoint_IsLimitEnabled(self)

    def EnableLimit(self, *args):
        """
        EnableLimit(self, bool flag)

        Enable/disable the joint limit.
        """
        return _Box2D.b2LineJoint_EnableLimit(self, *args)

    def GetLowerLimit(self):
        """
        GetLowerLimit(self) -> float32

        Get the lower joint limit, usually in meters.
        """
        return _Box2D.b2LineJoint_GetLowerLimit(self)

    def GetUpperLimit(self):
        """
        GetUpperLimit(self) -> float32

        Get the upper joint limit, usually in meters.
        """
        return _Box2D.b2LineJoint_GetUpperLimit(self)

    def SetLimits(self, *args):
        """
        SetLimits(self, float32 lower, float32 upper)

        Set the joint limits, usually in meters.
        """
        return _Box2D.b2LineJoint_SetLimits(self, *args)

    def IsMotorEnabled(self):
        """
        IsMotorEnabled(self) -> bool

        Is the joint motor enabled?
        """
        return _Box2D.b2LineJoint_IsMotorEnabled(self)

    def EnableMotor(self, *args):
        """
        EnableMotor(self, bool flag)

        Enable/disable the joint motor.
        """
        return _Box2D.b2LineJoint_EnableMotor(self, *args)

    def SetMotorSpeed(self, *args):
        """
        SetMotorSpeed(self, float32 speed)

        Set the motor speed, usually in meters per second.
        """
        return _Box2D.b2LineJoint_SetMotorSpeed(self, *args)

    def GetMotorSpeed(self):
        """
        GetMotorSpeed(self) -> float32

        Get the motor speed, usually in meters per second.
        """
        return _Box2D.b2LineJoint_GetMotorSpeed(self)

    def SetMaxMotorForce(self, *args):
        """
        SetMaxMotorForce(self, float32 force)

        Set the maximum motor force, usually in N.
        """
        return _Box2D.b2LineJoint_SetMaxMotorForce(self, *args)

    def GetMotorForce(self):
        """
        GetMotorForce(self) -> float32

        Get the current motor force, usually in N.
        """
        return _Box2D.b2LineJoint_GetMotorForce(self)

    def __init__(self, *args): 
        """
        __init__(self, b2LineJointDef _def) -> b2LineJoint

        A line joint. This joint provides one degree of freedom: translation along an axis fixed in body1. You can use a joint limit to restrict the range of motion and a joint motor to drive the motion or to model joint friction.
        """
        _Box2D.b2LineJoint_swiginit(self,_Box2D.new_b2LineJoint(*args))
    def InitVelocityConstraints(self, *args):
        """InitVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2LineJoint_InitVelocityConstraints(self, *args)

    def SolveVelocityConstraints(self, *args):
        """SolveVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2LineJoint_SolveVelocityConstraints(self, *args)

    def SolvePositionConstraints(self, *args):
        """SolvePositionConstraints(self, float32 baumgarte) -> bool"""
        return _Box2D.b2LineJoint_SolvePositionConstraints(self, *args)

    localAnchor1 = _swig_property(_Box2D.b2LineJoint_localAnchor1_get, _Box2D.b2LineJoint_localAnchor1_set)
    localAnchor2 = _swig_property(_Box2D.b2LineJoint_localAnchor2_get, _Box2D.b2LineJoint_localAnchor2_set)
    localXAxis1 = _swig_property(_Box2D.b2LineJoint_localXAxis1_get, _Box2D.b2LineJoint_localXAxis1_set)
    localYAxis1 = _swig_property(_Box2D.b2LineJoint_localYAxis1_get, _Box2D.b2LineJoint_localYAxis1_set)
    axis = _swig_property(_Box2D.b2LineJoint_axis_get, _Box2D.b2LineJoint_axis_set)
    perp = _swig_property(_Box2D.b2LineJoint_perp_get, _Box2D.b2LineJoint_perp_set)
    s1 = _swig_property(_Box2D.b2LineJoint_s1_get, _Box2D.b2LineJoint_s1_set)
    s2 = _swig_property(_Box2D.b2LineJoint_s2_get, _Box2D.b2LineJoint_s2_set)
    a1 = _swig_property(_Box2D.b2LineJoint_a1_get, _Box2D.b2LineJoint_a1_set)
    a2 = _swig_property(_Box2D.b2LineJoint_a2_get, _Box2D.b2LineJoint_a2_set)
    K = _swig_property(_Box2D.b2LineJoint_K_get, _Box2D.b2LineJoint_K_set)
    impulse = _swig_property(_Box2D.b2LineJoint_impulse_get, _Box2D.b2LineJoint_impulse_set)
    motorMass = _swig_property(_Box2D.b2LineJoint_motorMass_get, _Box2D.b2LineJoint_motorMass_set)
    motorImpulse = _swig_property(_Box2D.b2LineJoint_motorImpulse_get, _Box2D.b2LineJoint_motorImpulse_set)
    lowerTranslation = _swig_property(_Box2D.b2LineJoint_lowerTranslation_get, _Box2D.b2LineJoint_lowerTranslation_set)
    upperTranslation = _swig_property(_Box2D.b2LineJoint_upperTranslation_get, _Box2D.b2LineJoint_upperTranslation_set)
    maxMotorForce = _swig_property(_Box2D.b2LineJoint_maxMotorForce_get, _Box2D.b2LineJoint_maxMotorForce_set)
    motorSpeed = _swig_property(_Box2D.b2LineJoint_motorSpeed_get, _Box2D.b2LineJoint_motorSpeed_set)
    enableLimit = _swig_property(_Box2D.b2LineJoint_enableLimit_get, _Box2D.b2LineJoint_enableLimit_set)
    enableMotor = _swig_property(_Box2D.b2LineJoint_enableMotor_get, _Box2D.b2LineJoint_enableMotor_set)
    limitState = _swig_property(_Box2D.b2LineJoint_limitState_get, _Box2D.b2LineJoint_limitState_set)
    def __repr__(self):
     return """b2LineJoint(
       K                     = %s,
       a1                    = %s,
       a2                    = %s,
       axis                  = %s,
       body1                 = %s,
       body2                 = %s,
       collideConnected      = %s,
       enableLimit           = %s,
       enableMotor           = %s,
       impulse               = %s,
       limitState            = %s,
       localAnchor1          = %s,
       localAnchor2          = %s,
       localXAxis1           = %s,
       localYAxis1           = %s,
       lowerTranslation      = %s,
       maxMotorForce         = %s,
       motorImpulse          = %s,
       motorMass             = %s,
       motorSpeed            = %s,
       perp                  = %s,
       s1                    = %s,
       s2                    = %s,
       type                  = %s,
       upperTranslation      = %s,
       userData              = %s,
       GetAnchor1()          = %s,
       GetAnchor2()          = %s,
       GetJointSpeed()       = %s,
       GetJointTranslation() = %s,
       GetLowerLimit()       = %s,
       GetMotorForce()       = %s,
       GetUpperLimit()       = %s,
       IsLimitEnabled()      = %s,
       IsMotorEnabled()      = %s)"""% tuple(str(a) for a in\
      (self.K,self.a1,self.a2,self.axis,self.body1,self.body2,self.collideConnected,self.enableLimit,self.enableMotor,self.impulse,self.limitState,self.localAnchor1,self.localAnchor2,self.localXAxis1,self.localYAxis1,self.lowerTranslation,self.maxMotorForce,self.motorImpulse,self.motorMass,self.motorSpeed,self.perp,self.s1,self.s2,self.type,self.upperTranslation,self.userData,self.GetAnchor1(),self.GetAnchor2(),self.GetJointSpeed(),self.GetJointTranslation(),self.GetLowerLimit(),self.GetMotorForce(),self.GetUpperLimit(),self.IsLimitEnabled(),self.IsMotorEnabled()))

    __getstate__=_pickle_get_joint
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_joint

    __swig_destroy__ = _Box2D.delete_b2LineJoint
b2LineJoint.GetJointTranslation = new_instancemethod(_Box2D.b2LineJoint_GetJointTranslation,None,b2LineJoint)
b2LineJoint.GetJointSpeed = new_instancemethod(_Box2D.b2LineJoint_GetJointSpeed,None,b2LineJoint)
b2LineJoint.IsLimitEnabled = new_instancemethod(_Box2D.b2LineJoint_IsLimitEnabled,None,b2LineJoint)
b2LineJoint.EnableLimit = new_instancemethod(_Box2D.b2LineJoint_EnableLimit,None,b2LineJoint)
b2LineJoint.GetLowerLimit = new_instancemethod(_Box2D.b2LineJoint_GetLowerLimit,None,b2LineJoint)
b2LineJoint.GetUpperLimit = new_instancemethod(_Box2D.b2LineJoint_GetUpperLimit,None,b2LineJoint)
b2LineJoint.SetLimits = new_instancemethod(_Box2D.b2LineJoint_SetLimits,None,b2LineJoint)
b2LineJoint.IsMotorEnabled = new_instancemethod(_Box2D.b2LineJoint_IsMotorEnabled,None,b2LineJoint)
b2LineJoint.EnableMotor = new_instancemethod(_Box2D.b2LineJoint_EnableMotor,None,b2LineJoint)
b2LineJoint.SetMotorSpeed = new_instancemethod(_Box2D.b2LineJoint_SetMotorSpeed,None,b2LineJoint)
b2LineJoint.GetMotorSpeed = new_instancemethod(_Box2D.b2LineJoint_GetMotorSpeed,None,b2LineJoint)
b2LineJoint.SetMaxMotorForce = new_instancemethod(_Box2D.b2LineJoint_SetMaxMotorForce,None,b2LineJoint)
b2LineJoint.GetMotorForce = new_instancemethod(_Box2D.b2LineJoint_GetMotorForce,None,b2LineJoint)
b2LineJoint.InitVelocityConstraints = new_instancemethod(_Box2D.b2LineJoint_InitVelocityConstraints,None,b2LineJoint)
b2LineJoint.SolveVelocityConstraints = new_instancemethod(_Box2D.b2LineJoint_SolveVelocityConstraints,None,b2LineJoint)
b2LineJoint.SolvePositionConstraints = new_instancemethod(_Box2D.b2LineJoint_SolvePositionConstraints,None,b2LineJoint)
b2LineJoint_swigregister = _Box2D.b2LineJoint_swigregister
b2LineJoint_swigregister(b2LineJoint)

class b2MouseJointDef(b2JointDef):
    """Mouse joint definition. This requires a world target point, tuning parameters, and the time step."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2MouseJointDef

        Mouse joint definition. This requires a world target point, tuning parameters, and the time step.
        """
        _Box2D.b2MouseJointDef_swiginit(self,_Box2D.new_b2MouseJointDef())
    target = _swig_property(_Box2D.b2MouseJointDef_target_get, _Box2D.b2MouseJointDef_target_set)
    maxForce = _swig_property(_Box2D.b2MouseJointDef_maxForce_get, _Box2D.b2MouseJointDef_maxForce_set)
    frequencyHz = _swig_property(_Box2D.b2MouseJointDef_frequencyHz_get, _Box2D.b2MouseJointDef_frequencyHz_set)
    dampingRatio = _swig_property(_Box2D.b2MouseJointDef_dampingRatio_get, _Box2D.b2MouseJointDef_dampingRatio_set)
    def __repr__(self):
     return """b2MouseJointDef(
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       dampingRatio     = %s,
       frequencyHz      = %s,
       maxForce         = %s,
       target           = %s,
       type             = %s,
       userData         = %s)"""% tuple(str(a) for a in\
      (self.body1,self.body2,self.collideConnected,self.dampingRatio,self.frequencyHz,self.maxForce,self.target,self.type,self.userData))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2MouseJointDef
b2MouseJointDef_swigregister = _Box2D.b2MouseJointDef_swigregister
b2MouseJointDef_swigregister(b2MouseJointDef)

class b2MouseJoint(b2Joint):
    """A mouse joint is used to make a point on a body track a specified world point. This a soft constraint with a maximum force. This allows the constraint to stretch and without applying huge forces."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def SetTarget(self, *args):
        """
        SetTarget(self, b2Vec2 target)

        Use this to update the target point.
        """
        return _Box2D.b2MouseJoint_SetTarget(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, b2MouseJointDef _def) -> b2MouseJoint

        A mouse joint is used to make a point on a body track a specified world point. This a soft constraint with a maximum force. This allows the constraint to stretch and without applying huge forces.
        """
        _Box2D.b2MouseJoint_swiginit(self,_Box2D.new_b2MouseJoint(*args))
    def InitVelocityConstraints(self, *args):
        """InitVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2MouseJoint_InitVelocityConstraints(self, *args)

    def SolveVelocityConstraints(self, *args):
        """SolveVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2MouseJoint_SolveVelocityConstraints(self, *args)

    def SolvePositionConstraints(self, *args):
        """SolvePositionConstraints(self, float32 baumgarte) -> bool"""
        return _Box2D.b2MouseJoint_SolvePositionConstraints(self, *args)

    localAnchor = _swig_property(_Box2D.b2MouseJoint_localAnchor_get, _Box2D.b2MouseJoint_localAnchor_set)
    target = _swig_property(_Box2D.b2MouseJoint_target_get, _Box2D.b2MouseJoint_target_set)
    impulse = _swig_property(_Box2D.b2MouseJoint_impulse_get, _Box2D.b2MouseJoint_impulse_set)
    mass = _swig_property(_Box2D.b2MouseJoint_mass_get, _Box2D.b2MouseJoint_mass_set)
    C = _swig_property(_Box2D.b2MouseJoint_C_get, _Box2D.b2MouseJoint_C_set)
    maxForce = _swig_property(_Box2D.b2MouseJoint_maxForce_get, _Box2D.b2MouseJoint_maxForce_set)
    frequencyHz = _swig_property(_Box2D.b2MouseJoint_frequencyHz_get, _Box2D.b2MouseJoint_frequencyHz_set)
    dampingRatio = _swig_property(_Box2D.b2MouseJoint_dampingRatio_get, _Box2D.b2MouseJoint_dampingRatio_set)
    beta = _swig_property(_Box2D.b2MouseJoint_beta_get, _Box2D.b2MouseJoint_beta_set)
    gamma = _swig_property(_Box2D.b2MouseJoint_gamma_get, _Box2D.b2MouseJoint_gamma_set)
    def __repr__(self):
     return """b2MouseJoint(
       C                = %s,
       beta             = %s,
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       dampingRatio     = %s,
       frequencyHz      = %s,
       gamma            = %s,
       impulse          = %s,
       localAnchor      = %s,
       mass             = %s,
       maxForce         = %s,
       target           = %s,
       type             = %s,
       userData         = %s,
       GetAnchor1()     = %s,
       GetAnchor2()     = %s)"""% tuple(str(a) for a in\
      (self.C,self.beta,self.body1,self.body2,self.collideConnected,self.dampingRatio,self.frequencyHz,self.gamma,self.impulse,self.localAnchor,self.mass,self.maxForce,self.target,self.type,self.userData,self.GetAnchor1(),self.GetAnchor2()))

    __getstate__=_pickle_get_joint
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_joint

    __swig_destroy__ = _Box2D.delete_b2MouseJoint
b2MouseJoint.SetTarget = new_instancemethod(_Box2D.b2MouseJoint_SetTarget,None,b2MouseJoint)
b2MouseJoint.InitVelocityConstraints = new_instancemethod(_Box2D.b2MouseJoint_InitVelocityConstraints,None,b2MouseJoint)
b2MouseJoint.SolveVelocityConstraints = new_instancemethod(_Box2D.b2MouseJoint_SolveVelocityConstraints,None,b2MouseJoint)
b2MouseJoint.SolvePositionConstraints = new_instancemethod(_Box2D.b2MouseJoint_SolvePositionConstraints,None,b2MouseJoint)
b2MouseJoint_swigregister = _Box2D.b2MouseJoint_swigregister
b2MouseJoint_swigregister(b2MouseJoint)

class b2PrismaticJointDef(b2JointDef):
    """Prismatic joint definition. This requires defining a line of motion using an axis and an anchor point. The definition uses local anchor points and a local axis so that the initial configuration can violate the constraint slightly. The joint translation is zero when the local anchor points coincide in world space. Using local anchors and a local axis helps when saving and loading a game."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2PrismaticJointDef

        Prismatic joint definition. This requires defining a line of motion using an axis and an anchor point. The definition uses local anchor points and a local axis so that the initial configuration can violate the constraint slightly. The joint translation is zero when the local anchor points coincide in world space. Using local anchors and a local axis helps when saving and loading a game.
        """
        _Box2D.b2PrismaticJointDef_swiginit(self,_Box2D.new_b2PrismaticJointDef())
    def Initialize(self, *args):
        """
        Initialize(self, b2Body body1, b2Body body2, b2Vec2 anchor, b2Vec2 axis)

        Initialize the bodies, anchors, axis, and reference angle using the world anchor and world axis.
        """
        return _Box2D.b2PrismaticJointDef_Initialize(self, *args)

    localAnchor1 = _swig_property(_Box2D.b2PrismaticJointDef_localAnchor1_get, _Box2D.b2PrismaticJointDef_localAnchor1_set)
    localAnchor2 = _swig_property(_Box2D.b2PrismaticJointDef_localAnchor2_get, _Box2D.b2PrismaticJointDef_localAnchor2_set)
    localAxis1 = _swig_property(_Box2D.b2PrismaticJointDef_localAxis1_get, _Box2D.b2PrismaticJointDef_localAxis1_set)
    referenceAngle = _swig_property(_Box2D.b2PrismaticJointDef_referenceAngle_get, _Box2D.b2PrismaticJointDef_referenceAngle_set)
    enableLimit = _swig_property(_Box2D.b2PrismaticJointDef_enableLimit_get, _Box2D.b2PrismaticJointDef_enableLimit_set)
    lowerTranslation = _swig_property(_Box2D.b2PrismaticJointDef_lowerTranslation_get, _Box2D.b2PrismaticJointDef_lowerTranslation_set)
    upperTranslation = _swig_property(_Box2D.b2PrismaticJointDef_upperTranslation_get, _Box2D.b2PrismaticJointDef_upperTranslation_set)
    enableMotor = _swig_property(_Box2D.b2PrismaticJointDef_enableMotor_get, _Box2D.b2PrismaticJointDef_enableMotor_set)
    maxMotorForce = _swig_property(_Box2D.b2PrismaticJointDef_maxMotorForce_get, _Box2D.b2PrismaticJointDef_maxMotorForce_set)
    motorSpeed = _swig_property(_Box2D.b2PrismaticJointDef_motorSpeed_get, _Box2D.b2PrismaticJointDef_motorSpeed_set)
    def __repr__(self):
     return """b2PrismaticJointDef(
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       enableLimit      = %s,
       enableMotor      = %s,
       localAnchor1     = %s,
       localAnchor2     = %s,
       localAxis1       = %s,
       lowerTranslation = %s,
       maxMotorForce    = %s,
       motorSpeed       = %s,
       referenceAngle   = %s,
       type             = %s,
       upperTranslation = %s,
       userData         = %s)"""% tuple(str(a) for a in\
      (self.body1,self.body2,self.collideConnected,self.enableLimit,self.enableMotor,self.localAnchor1,self.localAnchor2,self.localAxis1,self.lowerTranslation,self.maxMotorForce,self.motorSpeed,self.referenceAngle,self.type,self.upperTranslation,self.userData))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2PrismaticJointDef
b2PrismaticJointDef.Initialize = new_instancemethod(_Box2D.b2PrismaticJointDef_Initialize,None,b2PrismaticJointDef)
b2PrismaticJointDef_swigregister = _Box2D.b2PrismaticJointDef_swigregister
b2PrismaticJointDef_swigregister(b2PrismaticJointDef)

class b2PrismaticJoint(b2Joint):
    """A prismatic joint. This joint provides one degree of freedom: translation along an axis fixed in body1. Relative rotation is prevented. You can use a joint limit to restrict the range of motion and a joint motor to drive the motion or to model joint friction."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def GetJointTranslation(self):
        """
        GetJointTranslation(self) -> float32

        Get the current joint translation, usually in meters.
        """
        return _Box2D.b2PrismaticJoint_GetJointTranslation(self)

    def GetJointSpeed(self):
        """
        GetJointSpeed(self) -> float32

        Get the current joint translation speed, usually in meters per second.
        """
        return _Box2D.b2PrismaticJoint_GetJointSpeed(self)

    def IsLimitEnabled(self):
        """
        IsLimitEnabled(self) -> bool

        Is the joint limit enabled?
        """
        return _Box2D.b2PrismaticJoint_IsLimitEnabled(self)

    def EnableLimit(self, *args):
        """
        EnableLimit(self, bool flag)

        Enable/disable the joint limit.
        """
        return _Box2D.b2PrismaticJoint_EnableLimit(self, *args)

    def GetLowerLimit(self):
        """
        GetLowerLimit(self) -> float32

        Get the lower joint limit, usually in meters.
        """
        return _Box2D.b2PrismaticJoint_GetLowerLimit(self)

    def GetUpperLimit(self):
        """
        GetUpperLimit(self) -> float32

        Get the upper joint limit, usually in meters.
        """
        return _Box2D.b2PrismaticJoint_GetUpperLimit(self)

    def SetLimits(self, *args):
        """
        SetLimits(self, float32 lower, float32 upper)

        Set the joint limits, usually in meters.
        """
        return _Box2D.b2PrismaticJoint_SetLimits(self, *args)

    def IsMotorEnabled(self):
        """
        IsMotorEnabled(self) -> bool

        Is the joint motor enabled?
        """
        return _Box2D.b2PrismaticJoint_IsMotorEnabled(self)

    def EnableMotor(self, *args):
        """
        EnableMotor(self, bool flag)

        Enable/disable the joint motor.
        """
        return _Box2D.b2PrismaticJoint_EnableMotor(self, *args)

    def SetMotorSpeed(self, *args):
        """
        SetMotorSpeed(self, float32 speed)

        Set the motor speed, usually in meters per second.
        """
        return _Box2D.b2PrismaticJoint_SetMotorSpeed(self, *args)

    def GetMotorSpeed(self):
        """
        GetMotorSpeed(self) -> float32

        Get the motor speed, usually in meters per second.
        """
        return _Box2D.b2PrismaticJoint_GetMotorSpeed(self)

    def SetMaxMotorForce(self, *args):
        """
        SetMaxMotorForce(self, float32 force)

        Set the maximum motor force, usually in N.
        """
        return _Box2D.b2PrismaticJoint_SetMaxMotorForce(self, *args)

    def GetMotorForce(self):
        """
        GetMotorForce(self) -> float32

        Get the current motor force, usually in N.
        """
        return _Box2D.b2PrismaticJoint_GetMotorForce(self)

    def __init__(self, *args): 
        """
        __init__(self, b2PrismaticJointDef _def) -> b2PrismaticJoint

        A prismatic joint. This joint provides one degree of freedom: translation along an axis fixed in body1. Relative rotation is prevented. You can use a joint limit to restrict the range of motion and a joint motor to drive the motion or to model joint friction.
        """
        _Box2D.b2PrismaticJoint_swiginit(self,_Box2D.new_b2PrismaticJoint(*args))
    def InitVelocityConstraints(self, *args):
        """InitVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2PrismaticJoint_InitVelocityConstraints(self, *args)

    def SolveVelocityConstraints(self, *args):
        """SolveVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2PrismaticJoint_SolveVelocityConstraints(self, *args)

    def SolvePositionConstraints(self, *args):
        """SolvePositionConstraints(self, float32 baumgarte) -> bool"""
        return _Box2D.b2PrismaticJoint_SolvePositionConstraints(self, *args)

    localAnchor1 = _swig_property(_Box2D.b2PrismaticJoint_localAnchor1_get, _Box2D.b2PrismaticJoint_localAnchor1_set)
    localAnchor2 = _swig_property(_Box2D.b2PrismaticJoint_localAnchor2_get, _Box2D.b2PrismaticJoint_localAnchor2_set)
    localXAxis1 = _swig_property(_Box2D.b2PrismaticJoint_localXAxis1_get, _Box2D.b2PrismaticJoint_localXAxis1_set)
    localYAxis1 = _swig_property(_Box2D.b2PrismaticJoint_localYAxis1_get, _Box2D.b2PrismaticJoint_localYAxis1_set)
    referenceAngle = _swig_property(_Box2D.b2PrismaticJoint_referenceAngle_get, _Box2D.b2PrismaticJoint_referenceAngle_set)
    axis = _swig_property(_Box2D.b2PrismaticJoint_axis_get, _Box2D.b2PrismaticJoint_axis_set)
    perp = _swig_property(_Box2D.b2PrismaticJoint_perp_get, _Box2D.b2PrismaticJoint_perp_set)
    s1 = _swig_property(_Box2D.b2PrismaticJoint_s1_get, _Box2D.b2PrismaticJoint_s1_set)
    s2 = _swig_property(_Box2D.b2PrismaticJoint_s2_get, _Box2D.b2PrismaticJoint_s2_set)
    a1 = _swig_property(_Box2D.b2PrismaticJoint_a1_get, _Box2D.b2PrismaticJoint_a1_set)
    a2 = _swig_property(_Box2D.b2PrismaticJoint_a2_get, _Box2D.b2PrismaticJoint_a2_set)
    K = _swig_property(_Box2D.b2PrismaticJoint_K_get, _Box2D.b2PrismaticJoint_K_set)
    impulse = _swig_property(_Box2D.b2PrismaticJoint_impulse_get, _Box2D.b2PrismaticJoint_impulse_set)
    motorMass = _swig_property(_Box2D.b2PrismaticJoint_motorMass_get, _Box2D.b2PrismaticJoint_motorMass_set)
    motorImpulse = _swig_property(_Box2D.b2PrismaticJoint_motorImpulse_get, _Box2D.b2PrismaticJoint_motorImpulse_set)
    lowerTranslation = _swig_property(_Box2D.b2PrismaticJoint_lowerTranslation_get, _Box2D.b2PrismaticJoint_lowerTranslation_set)
    upperTranslation = _swig_property(_Box2D.b2PrismaticJoint_upperTranslation_get, _Box2D.b2PrismaticJoint_upperTranslation_set)
    maxMotorForce = _swig_property(_Box2D.b2PrismaticJoint_maxMotorForce_get, _Box2D.b2PrismaticJoint_maxMotorForce_set)
    motorSpeed = _swig_property(_Box2D.b2PrismaticJoint_motorSpeed_get, _Box2D.b2PrismaticJoint_motorSpeed_set)
    enableLimit = _swig_property(_Box2D.b2PrismaticJoint_enableLimit_get, _Box2D.b2PrismaticJoint_enableLimit_set)
    enableMotor = _swig_property(_Box2D.b2PrismaticJoint_enableMotor_get, _Box2D.b2PrismaticJoint_enableMotor_set)
    limitState = _swig_property(_Box2D.b2PrismaticJoint_limitState_get, _Box2D.b2PrismaticJoint_limitState_set)
    def __repr__(self):
     return """b2PrismaticJoint(
       K                     = %s,
       a1                    = %s,
       a2                    = %s,
       axis                  = %s,
       body1                 = %s,
       body2                 = %s,
       collideConnected      = %s,
       enableLimit           = %s,
       enableMotor           = %s,
       impulse               = %s,
       limitState            = %s,
       localAnchor1          = %s,
       localAnchor2          = %s,
       localXAxis1           = %s,
       localYAxis1           = %s,
       lowerTranslation      = %s,
       maxMotorForce         = %s,
       motorImpulse          = %s,
       motorMass             = %s,
       motorSpeed            = %s,
       perp                  = %s,
       referenceAngle        = %s,
       s1                    = %s,
       s2                    = %s,
       type                  = %s,
       upperTranslation      = %s,
       userData              = %s,
       GetAnchor1()          = %s,
       GetAnchor2()          = %s,
       GetJointSpeed()       = %s,
       GetJointTranslation() = %s,
       GetLowerLimit()       = %s,
       GetMotorForce()       = %s,
       GetUpperLimit()       = %s,
       IsLimitEnabled()      = %s,
       IsMotorEnabled()      = %s)"""% tuple(str(a) for a in\
      (self.K,self.a1,self.a2,self.axis,self.body1,self.body2,self.collideConnected,self.enableLimit,self.enableMotor,self.impulse,self.limitState,self.localAnchor1,self.localAnchor2,self.localXAxis1,self.localYAxis1,self.lowerTranslation,self.maxMotorForce,self.motorImpulse,self.motorMass,self.motorSpeed,self.perp,self.referenceAngle,self.s1,self.s2,self.type,self.upperTranslation,self.userData,self.GetAnchor1(),self.GetAnchor2(),self.GetJointSpeed(),self.GetJointTranslation(),self.GetLowerLimit(),self.GetMotorForce(),self.GetUpperLimit(),self.IsLimitEnabled(),self.IsMotorEnabled()))

    __getstate__=_pickle_get_joint
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_joint

    __swig_destroy__ = _Box2D.delete_b2PrismaticJoint
b2PrismaticJoint.GetJointTranslation = new_instancemethod(_Box2D.b2PrismaticJoint_GetJointTranslation,None,b2PrismaticJoint)
b2PrismaticJoint.GetJointSpeed = new_instancemethod(_Box2D.b2PrismaticJoint_GetJointSpeed,None,b2PrismaticJoint)
b2PrismaticJoint.IsLimitEnabled = new_instancemethod(_Box2D.b2PrismaticJoint_IsLimitEnabled,None,b2PrismaticJoint)
b2PrismaticJoint.EnableLimit = new_instancemethod(_Box2D.b2PrismaticJoint_EnableLimit,None,b2PrismaticJoint)
b2PrismaticJoint.GetLowerLimit = new_instancemethod(_Box2D.b2PrismaticJoint_GetLowerLimit,None,b2PrismaticJoint)
b2PrismaticJoint.GetUpperLimit = new_instancemethod(_Box2D.b2PrismaticJoint_GetUpperLimit,None,b2PrismaticJoint)
b2PrismaticJoint.SetLimits = new_instancemethod(_Box2D.b2PrismaticJoint_SetLimits,None,b2PrismaticJoint)
b2PrismaticJoint.IsMotorEnabled = new_instancemethod(_Box2D.b2PrismaticJoint_IsMotorEnabled,None,b2PrismaticJoint)
b2PrismaticJoint.EnableMotor = new_instancemethod(_Box2D.b2PrismaticJoint_EnableMotor,None,b2PrismaticJoint)
b2PrismaticJoint.SetMotorSpeed = new_instancemethod(_Box2D.b2PrismaticJoint_SetMotorSpeed,None,b2PrismaticJoint)
b2PrismaticJoint.GetMotorSpeed = new_instancemethod(_Box2D.b2PrismaticJoint_GetMotorSpeed,None,b2PrismaticJoint)
b2PrismaticJoint.SetMaxMotorForce = new_instancemethod(_Box2D.b2PrismaticJoint_SetMaxMotorForce,None,b2PrismaticJoint)
b2PrismaticJoint.GetMotorForce = new_instancemethod(_Box2D.b2PrismaticJoint_GetMotorForce,None,b2PrismaticJoint)
b2PrismaticJoint.InitVelocityConstraints = new_instancemethod(_Box2D.b2PrismaticJoint_InitVelocityConstraints,None,b2PrismaticJoint)
b2PrismaticJoint.SolveVelocityConstraints = new_instancemethod(_Box2D.b2PrismaticJoint_SolveVelocityConstraints,None,b2PrismaticJoint)
b2PrismaticJoint.SolvePositionConstraints = new_instancemethod(_Box2D.b2PrismaticJoint_SolvePositionConstraints,None,b2PrismaticJoint)
b2PrismaticJoint_swigregister = _Box2D.b2PrismaticJoint_swigregister
b2PrismaticJoint_swigregister(b2PrismaticJoint)

class b2PulleyJointDef(b2JointDef):
    """Pulley joint definition. This requires two ground anchors, two dynamic body anchor points, max lengths for each side, and a pulley ratio."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2PulleyJointDef

        Pulley joint definition. This requires two ground anchors, two dynamic body anchor points, max lengths for each side, and a pulley ratio.
        """
        _Box2D.b2PulleyJointDef_swiginit(self,_Box2D.new_b2PulleyJointDef())
    def Initialize(self, *args):
        """
        Initialize(self, b2Body body1, b2Body body2, b2Vec2 groundAnchor1, b2Vec2 groundAnchor2, 
            b2Vec2 anchor1, b2Vec2 anchor2, 
            float32 ratio)

        Initialize the bodies, anchors, lengths, max lengths, and ratio using the world anchors.
        """
        return _Box2D.b2PulleyJointDef_Initialize(self, *args)

    groundAnchor1 = _swig_property(_Box2D.b2PulleyJointDef_groundAnchor1_get, _Box2D.b2PulleyJointDef_groundAnchor1_set)
    groundAnchor2 = _swig_property(_Box2D.b2PulleyJointDef_groundAnchor2_get, _Box2D.b2PulleyJointDef_groundAnchor2_set)
    localAnchor1 = _swig_property(_Box2D.b2PulleyJointDef_localAnchor1_get, _Box2D.b2PulleyJointDef_localAnchor1_set)
    localAnchor2 = _swig_property(_Box2D.b2PulleyJointDef_localAnchor2_get, _Box2D.b2PulleyJointDef_localAnchor2_set)
    length1 = _swig_property(_Box2D.b2PulleyJointDef_length1_get, _Box2D.b2PulleyJointDef_length1_set)
    maxLength1 = _swig_property(_Box2D.b2PulleyJointDef_maxLength1_get, _Box2D.b2PulleyJointDef_maxLength1_set)
    length2 = _swig_property(_Box2D.b2PulleyJointDef_length2_get, _Box2D.b2PulleyJointDef_length2_set)
    maxLength2 = _swig_property(_Box2D.b2PulleyJointDef_maxLength2_get, _Box2D.b2PulleyJointDef_maxLength2_set)
    ratio = _swig_property(_Box2D.b2PulleyJointDef_ratio_get, _Box2D.b2PulleyJointDef_ratio_set)
    def __repr__(self):
     return """b2PulleyJointDef(
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       groundAnchor1    = %s,
       groundAnchor2    = %s,
       length1          = %s,
       length2          = %s,
       localAnchor1     = %s,
       localAnchor2     = %s,
       maxLength1       = %s,
       maxLength2       = %s,
       ratio            = %s,
       type             = %s,
       userData         = %s)"""% tuple(str(a) for a in\
      (self.body1,self.body2,self.collideConnected,self.groundAnchor1,self.groundAnchor2,self.length1,self.length2,self.localAnchor1,self.localAnchor2,self.maxLength1,self.maxLength2,self.ratio,self.type,self.userData))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2PulleyJointDef
b2PulleyJointDef.Initialize = new_instancemethod(_Box2D.b2PulleyJointDef_Initialize,None,b2PulleyJointDef)
b2PulleyJointDef_swigregister = _Box2D.b2PulleyJointDef_swigregister
b2PulleyJointDef_swigregister(b2PulleyJointDef)
b2_minPulleyLength = cvar.b2_minPulleyLength

class b2PulleyJoint(b2Joint):
    """The pulley joint is connected to two bodies and two fixed ground points. The pulley supports a ratio such that: length1 + ratio * length2 <= constant Yes, the force transmitted is scaled by the ratio. The pulley also enforces a maximum length limit on both sides. This is useful to prevent one side of the pulley hitting the top."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def GetGroundAnchor1(self):
        """
        GetGroundAnchor1(self) -> b2Vec2

        Get the first ground anchor.
        """
        return _Box2D.b2PulleyJoint_GetGroundAnchor1(self)

    def GetGroundAnchor2(self):
        """
        GetGroundAnchor2(self) -> b2Vec2

        Get the second ground anchor.
        """
        return _Box2D.b2PulleyJoint_GetGroundAnchor2(self)

    def GetLength1(self):
        """
        GetLength1(self) -> float32

        Get the current length of the segment attached to body1.
        """
        return _Box2D.b2PulleyJoint_GetLength1(self)

    def GetLength2(self):
        """
        GetLength2(self) -> float32

        Get the current length of the segment attached to body2.
        """
        return _Box2D.b2PulleyJoint_GetLength2(self)

    def GetRatio(self):
        """
        GetRatio(self) -> float32

        Get the pulley ratio.
        """
        return _Box2D.b2PulleyJoint_GetRatio(self)

    def __init__(self, *args): 
        """
        __init__(self, b2PulleyJointDef data) -> b2PulleyJoint

        The pulley joint is connected to two bodies and two fixed ground points. The pulley supports a ratio such that: length1 + ratio * length2 <= constant Yes, the force transmitted is scaled by the ratio. The pulley also enforces a maximum length limit on both sides. This is useful to prevent one side of the pulley hitting the top.
        """
        _Box2D.b2PulleyJoint_swiginit(self,_Box2D.new_b2PulleyJoint(*args))
    def InitVelocityConstraints(self, *args):
        """InitVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2PulleyJoint_InitVelocityConstraints(self, *args)

    def SolveVelocityConstraints(self, *args):
        """SolveVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2PulleyJoint_SolveVelocityConstraints(self, *args)

    def SolvePositionConstraints(self, *args):
        """SolvePositionConstraints(self, float32 baumgarte) -> bool"""
        return _Box2D.b2PulleyJoint_SolvePositionConstraints(self, *args)

    ground = _swig_property(_Box2D.b2PulleyJoint_ground_get, _Box2D.b2PulleyJoint_ground_set)
    groundAnchor1 = _swig_property(_Box2D.b2PulleyJoint_groundAnchor1_get, _Box2D.b2PulleyJoint_groundAnchor1_set)
    groundAnchor2 = _swig_property(_Box2D.b2PulleyJoint_groundAnchor2_get, _Box2D.b2PulleyJoint_groundAnchor2_set)
    localAnchor1 = _swig_property(_Box2D.b2PulleyJoint_localAnchor1_get, _Box2D.b2PulleyJoint_localAnchor1_set)
    localAnchor2 = _swig_property(_Box2D.b2PulleyJoint_localAnchor2_get, _Box2D.b2PulleyJoint_localAnchor2_set)
    u1 = _swig_property(_Box2D.b2PulleyJoint_u1_get, _Box2D.b2PulleyJoint_u1_set)
    u2 = _swig_property(_Box2D.b2PulleyJoint_u2_get, _Box2D.b2PulleyJoint_u2_set)
    constant = _swig_property(_Box2D.b2PulleyJoint_constant_get, _Box2D.b2PulleyJoint_constant_set)
    ratio = _swig_property(_Box2D.b2PulleyJoint_ratio_get, _Box2D.b2PulleyJoint_ratio_set)
    maxLength1 = _swig_property(_Box2D.b2PulleyJoint_maxLength1_get, _Box2D.b2PulleyJoint_maxLength1_set)
    maxLength2 = _swig_property(_Box2D.b2PulleyJoint_maxLength2_get, _Box2D.b2PulleyJoint_maxLength2_set)
    pulleyMass = _swig_property(_Box2D.b2PulleyJoint_pulleyMass_get, _Box2D.b2PulleyJoint_pulleyMass_set)
    limitMass1 = _swig_property(_Box2D.b2PulleyJoint_limitMass1_get, _Box2D.b2PulleyJoint_limitMass1_set)
    limitMass2 = _swig_property(_Box2D.b2PulleyJoint_limitMass2_get, _Box2D.b2PulleyJoint_limitMass2_set)
    impulse = _swig_property(_Box2D.b2PulleyJoint_impulse_get, _Box2D.b2PulleyJoint_impulse_set)
    limitImpulse1 = _swig_property(_Box2D.b2PulleyJoint_limitImpulse1_get, _Box2D.b2PulleyJoint_limitImpulse1_set)
    limitImpulse2 = _swig_property(_Box2D.b2PulleyJoint_limitImpulse2_get, _Box2D.b2PulleyJoint_limitImpulse2_set)
    state = _swig_property(_Box2D.b2PulleyJoint_state_get, _Box2D.b2PulleyJoint_state_set)
    limitState1 = _swig_property(_Box2D.b2PulleyJoint_limitState1_get, _Box2D.b2PulleyJoint_limitState1_set)
    limitState2 = _swig_property(_Box2D.b2PulleyJoint_limitState2_get, _Box2D.b2PulleyJoint_limitState2_set)
    def __repr__(self):
     return """b2PulleyJoint(
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       constant         = %s,
       ground           = %s,
       groundAnchor1    = %s,
       groundAnchor2    = %s,
       impulse          = %s,
       length1          = %s,
       length2          = %s,
       limitImpulse1    = %s,
       limitImpulse2    = %s,
       limitMass1       = %s,
       limitMass2       = %s,
       limitState1      = %s,
       limitState2      = %s,
       localAnchor1     = %s,
       localAnchor2     = %s,
       maxLength1       = %s,
       maxLength2       = %s,
       pulleyMass       = %s,
       ratio            = %s,
       state            = %s,
       type             = %s,
       u1               = %s,
       u2               = %s,
       userData         = %s,
       GetAnchor1()     = %s,
       GetAnchor2()     = %s)"""% tuple(str(a) for a in\
      (self.body1,self.body2,self.collideConnected,self.constant,self.ground,self.groundAnchor1,self.groundAnchor2,self.impulse,self.length1,self.length2,self.limitImpulse1,self.limitImpulse2,self.limitMass1,self.limitMass2,self.limitState1,self.limitState2,self.localAnchor1,self.localAnchor2,self.maxLength1,self.maxLength2,self.pulleyMass,self.ratio,self.state,self.type,self.u1,self.u2,self.userData,self.GetAnchor1(),self.GetAnchor2()))

    __getstate__=_pickle_get_joint
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_joint

    length1 = property(GetLength1, None)
    length2 = property(GetLength2, None)

    __swig_destroy__ = _Box2D.delete_b2PulleyJoint
b2PulleyJoint.GetGroundAnchor1 = new_instancemethod(_Box2D.b2PulleyJoint_GetGroundAnchor1,None,b2PulleyJoint)
b2PulleyJoint.GetGroundAnchor2 = new_instancemethod(_Box2D.b2PulleyJoint_GetGroundAnchor2,None,b2PulleyJoint)
b2PulleyJoint.GetLength1 = new_instancemethod(_Box2D.b2PulleyJoint_GetLength1,None,b2PulleyJoint)
b2PulleyJoint.GetLength2 = new_instancemethod(_Box2D.b2PulleyJoint_GetLength2,None,b2PulleyJoint)
b2PulleyJoint.GetRatio = new_instancemethod(_Box2D.b2PulleyJoint_GetRatio,None,b2PulleyJoint)
b2PulleyJoint.InitVelocityConstraints = new_instancemethod(_Box2D.b2PulleyJoint_InitVelocityConstraints,None,b2PulleyJoint)
b2PulleyJoint.SolveVelocityConstraints = new_instancemethod(_Box2D.b2PulleyJoint_SolveVelocityConstraints,None,b2PulleyJoint)
b2PulleyJoint.SolvePositionConstraints = new_instancemethod(_Box2D.b2PulleyJoint_SolvePositionConstraints,None,b2PulleyJoint)
b2PulleyJoint_swigregister = _Box2D.b2PulleyJoint_swigregister
b2PulleyJoint_swigregister(b2PulleyJoint)

class b2RevoluteJointDef(b2JointDef):
    """Revolute joint definition. This requires defining an anchor point where the bodies are joined. The definition uses local anchor points so that the initial configuration can violate the constraint slightly. You also need to specify the initial relative angle for joint limits. This helps when saving and loading a game. The local anchor points are measured from the body's origin rather than the center of mass because: 1. you might not know where the center of mass will be. 2. if you add/remove shapes from a body and recompute the mass, the joints will be broken."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> b2RevoluteJointDef

        Revolute joint definition. This requires defining an anchor point where the bodies are joined. The definition uses local anchor points so that the initial configuration can violate the constraint slightly. You also need to specify the initial relative angle for joint limits. This helps when saving and loading a game. The local anchor points are measured from the body's origin rather than the center of mass because: 1. you might not know where the center of mass will be. 2. if you add/remove shapes from a body and recompute the mass, the joints will be broken.
        """
        _Box2D.b2RevoluteJointDef_swiginit(self,_Box2D.new_b2RevoluteJointDef())
    def Initialize(self, *args):
        """
        Initialize(self, b2Body body1, b2Body body2, b2Vec2 anchor)

        Initialize the bodies, anchors, and reference angle using the world anchor.
        """
        return _Box2D.b2RevoluteJointDef_Initialize(self, *args)

    localAnchor1 = _swig_property(_Box2D.b2RevoluteJointDef_localAnchor1_get, _Box2D.b2RevoluteJointDef_localAnchor1_set)
    localAnchor2 = _swig_property(_Box2D.b2RevoluteJointDef_localAnchor2_get, _Box2D.b2RevoluteJointDef_localAnchor2_set)
    referenceAngle = _swig_property(_Box2D.b2RevoluteJointDef_referenceAngle_get, _Box2D.b2RevoluteJointDef_referenceAngle_set)
    enableLimit = _swig_property(_Box2D.b2RevoluteJointDef_enableLimit_get, _Box2D.b2RevoluteJointDef_enableLimit_set)
    lowerAngle = _swig_property(_Box2D.b2RevoluteJointDef_lowerAngle_get, _Box2D.b2RevoluteJointDef_lowerAngle_set)
    upperAngle = _swig_property(_Box2D.b2RevoluteJointDef_upperAngle_get, _Box2D.b2RevoluteJointDef_upperAngle_set)
    enableMotor = _swig_property(_Box2D.b2RevoluteJointDef_enableMotor_get, _Box2D.b2RevoluteJointDef_enableMotor_set)
    motorSpeed = _swig_property(_Box2D.b2RevoluteJointDef_motorSpeed_get, _Box2D.b2RevoluteJointDef_motorSpeed_set)
    maxMotorTorque = _swig_property(_Box2D.b2RevoluteJointDef_maxMotorTorque_get, _Box2D.b2RevoluteJointDef_maxMotorTorque_set)
    def __repr__(self):
     return """b2RevoluteJointDef(
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       enableLimit      = %s,
       enableMotor      = %s,
       localAnchor1     = %s,
       localAnchor2     = %s,
       lowerAngle       = %s,
       maxMotorTorque   = %s,
       motorSpeed       = %s,
       referenceAngle   = %s,
       type             = %s,
       upperAngle       = %s,
       userData         = %s)"""% tuple(str(a) for a in\
      (self.body1,self.body2,self.collideConnected,self.enableLimit,self.enableMotor,self.localAnchor1,self.localAnchor2,self.lowerAngle,self.maxMotorTorque,self.motorSpeed,self.referenceAngle,self.type,self.upperAngle,self.userData))

    __getstate__=_generic_getstate
    __setstate__=_generic_setstate

    __swig_destroy__ = _Box2D.delete_b2RevoluteJointDef
b2RevoluteJointDef.Initialize = new_instancemethod(_Box2D.b2RevoluteJointDef_Initialize,None,b2RevoluteJointDef)
b2RevoluteJointDef_swigregister = _Box2D.b2RevoluteJointDef_swigregister
b2RevoluteJointDef_swigregister(b2RevoluteJointDef)

class b2RevoluteJoint(b2Joint):
    """A revolute joint constrains to bodies to share a common point while they are free to rotate about the point. The relative rotation about the shared point is the joint angle. You can limit the relative rotation with a joint limit that specifies a lower and upper angle. You can use a motor to drive the relative rotation about the shared point. A maximum motor torque is provided so that infinite forces are not generated."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def GetJointAngle(self):
        """
        GetJointAngle(self) -> float32

        Get the current joint angle in radians.
        """
        return _Box2D.b2RevoluteJoint_GetJointAngle(self)

    def GetJointSpeed(self):
        """
        GetJointSpeed(self) -> float32

        Get the current joint angle speed in radians per second.
        """
        return _Box2D.b2RevoluteJoint_GetJointSpeed(self)

    def IsLimitEnabled(self):
        """
        IsLimitEnabled(self) -> bool

        Is the joint limit enabled?
        """
        return _Box2D.b2RevoluteJoint_IsLimitEnabled(self)

    def EnableLimit(self, *args):
        """
        EnableLimit(self, bool flag)

        Enable/disable the joint limit.
        """
        return _Box2D.b2RevoluteJoint_EnableLimit(self, *args)

    def GetLowerLimit(self):
        """
        GetLowerLimit(self) -> float32

        Get the lower joint limit in radians.
        """
        return _Box2D.b2RevoluteJoint_GetLowerLimit(self)

    def GetUpperLimit(self):
        """
        GetUpperLimit(self) -> float32

        Get the upper joint limit in radians.
        """
        return _Box2D.b2RevoluteJoint_GetUpperLimit(self)

    def SetLimits(self, *args):
        """
        SetLimits(self, float32 lower, float32 upper)

        Set the joint limits in radians.
        """
        return _Box2D.b2RevoluteJoint_SetLimits(self, *args)

    def IsMotorEnabled(self):
        """
        IsMotorEnabled(self) -> bool

        Is the joint motor enabled?
        """
        return _Box2D.b2RevoluteJoint_IsMotorEnabled(self)

    def EnableMotor(self, *args):
        """
        EnableMotor(self, bool flag)

        Enable/disable the joint motor.
        """
        return _Box2D.b2RevoluteJoint_EnableMotor(self, *args)

    def SetMotorSpeed(self, *args):
        """
        SetMotorSpeed(self, float32 speed)

        Set the motor speed in radians per second.
        """
        return _Box2D.b2RevoluteJoint_SetMotorSpeed(self, *args)

    def GetMotorSpeed(self):
        """
        GetMotorSpeed(self) -> float32

        Get the motor speed in radians per second.
        """
        return _Box2D.b2RevoluteJoint_GetMotorSpeed(self)

    def SetMaxMotorTorque(self, *args):
        """
        SetMaxMotorTorque(self, float32 torque)

        Set the maximum motor torque, usually in N-m.
        """
        return _Box2D.b2RevoluteJoint_SetMaxMotorTorque(self, *args)

    def GetMotorTorque(self):
        """
        GetMotorTorque(self) -> float32

        Get the current motor torque, usually in N-m.
        """
        return _Box2D.b2RevoluteJoint_GetMotorTorque(self)

    def __init__(self, *args): 
        """
        __init__(self, b2RevoluteJointDef _def) -> b2RevoluteJoint

        A revolute joint constrains to bodies to share a common point while they are free to rotate about the point. The relative rotation about the shared point is the joint angle. You can limit the relative rotation with a joint limit that specifies a lower and upper angle. You can use a motor to drive the relative rotation about the shared point. A maximum motor torque is provided so that infinite forces are not generated.
        """
        _Box2D.b2RevoluteJoint_swiginit(self,_Box2D.new_b2RevoluteJoint(*args))
    def InitVelocityConstraints(self, *args):
        """InitVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2RevoluteJoint_InitVelocityConstraints(self, *args)

    def SolveVelocityConstraints(self, *args):
        """SolveVelocityConstraints(self, b2TimeStep step)"""
        return _Box2D.b2RevoluteJoint_SolveVelocityConstraints(self, *args)

    def SolvePositionConstraints(self, *args):
        """SolvePositionConstraints(self, float32 baumgarte) -> bool"""
        return _Box2D.b2RevoluteJoint_SolvePositionConstraints(self, *args)

    localAnchor1 = _swig_property(_Box2D.b2RevoluteJoint_localAnchor1_get, _Box2D.b2RevoluteJoint_localAnchor1_set)
    localAnchor2 = _swig_property(_Box2D.b2RevoluteJoint_localAnchor2_get, _Box2D.b2RevoluteJoint_localAnchor2_set)
    impulse = _swig_property(_Box2D.b2RevoluteJoint_impulse_get, _Box2D.b2RevoluteJoint_impulse_set)
    motorImpulse = _swig_property(_Box2D.b2RevoluteJoint_motorImpulse_get, _Box2D.b2RevoluteJoint_motorImpulse_set)
    mass = _swig_property(_Box2D.b2RevoluteJoint_mass_get, _Box2D.b2RevoluteJoint_mass_set)
    motorMass = _swig_property(_Box2D.b2RevoluteJoint_motorMass_get, _Box2D.b2RevoluteJoint_motorMass_set)
    enableMotor = _swig_property(_Box2D.b2RevoluteJoint_enableMotor_get, _Box2D.b2RevoluteJoint_enableMotor_set)
    maxMotorTorque = _swig_property(_Box2D.b2RevoluteJoint_maxMotorTorque_get, _Box2D.b2RevoluteJoint_maxMotorTorque_set)
    motorSpeed = _swig_property(_Box2D.b2RevoluteJoint_motorSpeed_get, _Box2D.b2RevoluteJoint_motorSpeed_set)
    enableLimit = _swig_property(_Box2D.b2RevoluteJoint_enableLimit_get, _Box2D.b2RevoluteJoint_enableLimit_set)
    referenceAngle = _swig_property(_Box2D.b2RevoluteJoint_referenceAngle_get, _Box2D.b2RevoluteJoint_referenceAngle_set)
    lowerAngle = _swig_property(_Box2D.b2RevoluteJoint_lowerAngle_get, _Box2D.b2RevoluteJoint_lowerAngle_set)
    upperAngle = _swig_property(_Box2D.b2RevoluteJoint_upperAngle_get, _Box2D.b2RevoluteJoint_upperAngle_set)
    limitState = _swig_property(_Box2D.b2RevoluteJoint_limitState_get, _Box2D.b2RevoluteJoint_limitState_set)
    def __repr__(self):
     return """b2RevoluteJoint(
       body1            = %s,
       body2            = %s,
       collideConnected = %s,
       enableLimit      = %s,
       enableMotor      = %s,
       impulse          = %s,
       limitState       = %s,
       localAnchor1     = %s,
       localAnchor2     = %s,
       lowerAngle       = %s,
       mass             = %s,
       maxMotorTorque   = %s,
       motorImpulse     = %s,
       motorMass        = %s,
       motorSpeed       = %s,
       referenceAngle   = %s,
       type             = %s,
       upperAngle       = %s,
       userData         = %s,
       GetAnchor1()     = %s,
       GetAnchor2()     = %s,
       GetJointAngle()  = %s,
       GetJointSpeed()  = %s,
       GetLowerLimit()  = %s,
       GetMotorTorque() = %s,
       GetUpperLimit()  = %s,
       IsLimitEnabled() = %s,
       IsMotorEnabled() = %s)"""% tuple(str(a) for a in\
      (self.body1,self.body2,self.collideConnected,self.enableLimit,self.enableMotor,self.impulse,self.limitState,self.localAnchor1,self.localAnchor2,self.lowerAngle,self.mass,self.maxMotorTorque,self.motorImpulse,self.motorMass,self.motorSpeed,self.referenceAngle,self.type,self.upperAngle,self.userData,self.GetAnchor1(),self.GetAnchor2(),self.GetJointAngle(),self.GetJointSpeed(),self.GetLowerLimit(),self.GetMotorTorque(),self.GetUpperLimit(),self.IsLimitEnabled(),self.IsMotorEnabled()))

    __getstate__=_pickle_get_joint
    __setstate__=_pickle_factory_set
    _pickle_finalize=_pickle_finalize_joint

    __swig_destroy__ = _Box2D.delete_b2RevoluteJoint
b2RevoluteJoint.GetJointAngle = new_instancemethod(_Box2D.b2RevoluteJoint_GetJointAngle,None,b2RevoluteJoint)
b2RevoluteJoint.GetJointSpeed = new_instancemethod(_Box2D.b2RevoluteJoint_GetJointSpeed,None,b2RevoluteJoint)
b2RevoluteJoint.IsLimitEnabled = new_instancemethod(_Box2D.b2RevoluteJoint_IsLimitEnabled,None,b2RevoluteJoint)
b2RevoluteJoint.EnableLimit = new_instancemethod(_Box2D.b2RevoluteJoint_EnableLimit,None,b2RevoluteJoint)
b2RevoluteJoint.GetLowerLimit = new_instancemethod(_Box2D.b2RevoluteJoint_GetLowerLimit,None,b2RevoluteJoint)
b2RevoluteJoint.GetUpperLimit = new_instancemethod(_Box2D.b2RevoluteJoint_GetUpperLimit,None,b2RevoluteJoint)
b2RevoluteJoint.SetLimits = new_instancemethod(_Box2D.b2RevoluteJoint_SetLimits,None,b2RevoluteJoint)
b2RevoluteJoint.IsMotorEnabled = new_instancemethod(_Box2D.b2RevoluteJoint_IsMotorEnabled,None,b2RevoluteJoint)
b2RevoluteJoint.EnableMotor = new_instancemethod(_Box2D.b2RevoluteJoint_EnableMotor,None,b2RevoluteJoint)
b2RevoluteJoint.SetMotorSpeed = new_instancemethod(_Box2D.b2RevoluteJoint_SetMotorSpeed,None,b2RevoluteJoint)
b2RevoluteJoint.GetMotorSpeed = new_instancemethod(_Box2D.b2RevoluteJoint_GetMotorSpeed,None,b2RevoluteJoint)
b2RevoluteJoint.SetMaxMotorTorque = new_instancemethod(_Box2D.b2RevoluteJoint_SetMaxMotorTorque,None,b2RevoluteJoint)
b2RevoluteJoint.GetMotorTorque = new_instancemethod(_Box2D.b2RevoluteJoint_GetMotorTorque,None,b2RevoluteJoint)
b2RevoluteJoint.InitVelocityConstraints = new_instancemethod(_Box2D.b2RevoluteJoint_InitVelocityConstraints,None,b2RevoluteJoint)
b2RevoluteJoint.SolveVelocityConstraints = new_instancemethod(_Box2D.b2RevoluteJoint_SolveVelocityConstraints,None,b2RevoluteJoint)
b2RevoluteJoint.SolvePositionConstraints = new_instancemethod(_Box2D.b2RevoluteJoint_SolvePositionConstraints,None,b2RevoluteJoint)
b2RevoluteJoint_swigregister = _Box2D.b2RevoluteJoint_swigregister
b2RevoluteJoint_swigregister(b2RevoluteJoint)



