/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qxmlsimplereader_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qxml.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QXmlDTDHandler * QXmlSimpleReaderWrapper::DTDHandler() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "DTDHandler"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::DTDHandler();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlDTDHandler* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.DTDHandler");
        return 0        ;
    }
    QXmlDTDHandler* cpp_result(Shiboken::Converter<QXmlDTDHandler* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QXmlSimpleReaderWrapper::QXmlSimpleReaderWrapper() : QXmlSimpleReader() {
    // ... middle
}

QXmlContentHandler * QXmlSimpleReaderWrapper::contentHandler() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contentHandler"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::contentHandler();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlContentHandler* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.contentHandler");
        return 0        ;
    }
    QXmlContentHandler* cpp_result(Shiboken::Converter<QXmlContentHandler* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QXmlDeclHandler * QXmlSimpleReaderWrapper::declHandler() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "declHandler"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::declHandler();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlDeclHandler* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.declHandler");
        return 0        ;
    }
    QXmlDeclHandler* cpp_result(Shiboken::Converter<QXmlDeclHandler* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QXmlEntityResolver * QXmlSimpleReaderWrapper::entityResolver() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "entityResolver"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::entityResolver();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlEntityResolver* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.entityResolver");
        return 0        ;
    }
    QXmlEntityResolver* cpp_result(Shiboken::Converter<QXmlEntityResolver* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QXmlErrorHandler * QXmlSimpleReaderWrapper::errorHandler() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "errorHandler"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::errorHandler();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlErrorHandler* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.errorHandler");
        return 0        ;
    }
    QXmlErrorHandler* cpp_result(Shiboken::Converter<QXmlErrorHandler* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

bool QXmlSimpleReaderWrapper::feature(const QString & name, bool * ok) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "feature"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::feature(name, ok);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));


    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PySequence_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.feature");
        return bool(0)        ;
    }
    // Begin code injection
    
    // TEMPLATE - fix_virtual_method_return_value_and_bool* - START
    AutoDecRef _py_ret_(PySequence_GetItem(py_result, 0));
    AutoDecRef _py_ok_(PySequence_GetItem(py_result, 1));
    bool cpp_result = Shiboken::Converter<bool >::toCpp(_py_ret_);
    *ok = Shiboken::Converter<bool >::toCpp(_py_ok_);
    // TEMPLATE - fix_virtual_method_return_value_and_bool* - END
    
    // End of code injection

    return cpp_result;
}

bool QXmlSimpleReaderWrapper::hasFeature(const QString & name) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasFeature"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::hasFeature(name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.hasFeature");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlSimpleReaderWrapper::hasProperty(const QString & name) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasProperty"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::hasProperty(name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.hasProperty");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QXmlLexicalHandler * QXmlSimpleReaderWrapper::lexicalHandler() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "lexicalHandler"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::lexicalHandler();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlLexicalHandler* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.lexicalHandler");
        return 0        ;
    }
    QXmlLexicalHandler* cpp_result(Shiboken::Converter<QXmlLexicalHandler* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

bool QXmlSimpleReaderWrapper::parse(const QXmlInputSource & input)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parse"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::parse(input);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlInputSource& >::toPython(input)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.parse");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlSimpleReaderWrapper::parse(const QXmlInputSource * input)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parse"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::parse(input);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlInputSource* >::toPython(input)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.parse");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlSimpleReaderWrapper::parse(const QXmlInputSource * input, bool incremental)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parse"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::parse(input, incremental);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QXmlInputSource* >::toPython(input),
        Shiboken::Converter<bool >::toPython(incremental)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.parse");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QXmlSimpleReaderWrapper::parseContinue()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parseContinue"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::parseContinue();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.parseContinue");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void * QXmlSimpleReaderWrapper::property(const QString & name, bool * ok) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "property"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::property(name, ok);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));


    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = PySequence_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlSimpleReader.property");
        return 0        ;
    }
    // Begin code injection
    
    // TEMPLATE - fix_virtual_method_return_value_and_bool* - START
    AutoDecRef _py_ret_(PySequence_GetItem(py_result, 0));
    AutoDecRef _py_ok_(PySequence_GetItem(py_result, 1));
    void * cpp_result = Shiboken::Converter<void * >::toCpp(_py_ret_);
    *ok = Shiboken::Converter<bool >::toCpp(_py_ok_);
    // TEMPLATE - fix_virtual_method_return_value_and_bool* - END
    
    // End of code injection

    return cpp_result;
}

void QXmlSimpleReaderWrapper::setContentHandler(QXmlContentHandler * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setContentHandler"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::setContentHandler(handler);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlContentHandler* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSimpleReaderWrapper::setDTDHandler(QXmlDTDHandler * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setDTDHandler"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::setDTDHandler(handler);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlDTDHandler* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSimpleReaderWrapper::setDeclHandler(QXmlDeclHandler * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setDeclHandler"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::setDeclHandler(handler);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlDeclHandler* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSimpleReaderWrapper::setEntityResolver(QXmlEntityResolver * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setEntityResolver"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::setEntityResolver(handler);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlEntityResolver* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSimpleReaderWrapper::setErrorHandler(QXmlErrorHandler * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setErrorHandler"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::setErrorHandler(handler);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlErrorHandler* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSimpleReaderWrapper::setFeature(const QString & name, bool value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setFeature"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::setFeature(name, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(name),
        Shiboken::Converter<bool >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSimpleReaderWrapper::setLexicalHandler(QXmlLexicalHandler * handler)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setLexicalHandler"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::setLexicalHandler(handler);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QXmlLexicalHandler* >::toPython(handler)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlSimpleReaderWrapper::setProperty(const QString & name, void * value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setProperty"));
    if (py_override.isNull()) {
        return this->QXmlSimpleReader::setProperty(name, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O?)",
        Shiboken::Converter<QString& >::toPython(name),
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QXmlSimpleReaderWrapper::~QXmlSimpleReaderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static PyObject*
SbkQXmlSimpleReaderFunc_DTDHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // DTDHandler()const
    QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
    QXmlDTDHandler * cpp_result = cppSelf->QXmlSimpleReader::DTDHandler();
    py_result = Shiboken::Converter<QXmlDTDHandler* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static int
SbkQXmlSimpleReader_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlSimpleReaderWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QXmlSimpleReader()
    cptr = new QXmlSimpleReaderWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQXmlSimpleReaderFunc_contentHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contentHandler()const
    QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
    QXmlContentHandler * cpp_result = cppSelf->QXmlSimpleReader::contentHandler();
    py_result = Shiboken::Converter<QXmlContentHandler* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlSimpleReaderFunc_declHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // declHandler()const
    QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
    QXmlDeclHandler * cpp_result = cppSelf->QXmlSimpleReader::declHandler();
    py_result = Shiboken::Converter<QXmlDeclHandler* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlSimpleReaderFunc_entityResolver(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // entityResolver()const
    QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
    QXmlEntityResolver * cpp_result = cppSelf->QXmlSimpleReader::entityResolver();
    py_result = Shiboken::Converter<QXmlEntityResolver* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlSimpleReaderFunc_errorHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorHandler()const
    QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
    QXmlErrorHandler * cpp_result = cppSelf->QXmlSimpleReader::errorHandler();
    py_result = Shiboken::Converter<QXmlErrorHandler* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlSimpleReaderFunc_feature(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // feature(QString,bool*)const
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_args,bool* - START
        bool ok_;
        bool retval_ = cppSelf->feature(*cpp_arg0, &ok_);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_args,bool* - END
        
        // End of code injection


    } else goto SbkQXmlSimpleReaderFunc_feature_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlSimpleReaderFunc_feature_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlSimpleReader.feature", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_hasFeature(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // hasFeature(QString)const
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlSimpleReader::hasFeature(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlSimpleReaderFunc_hasFeature_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlSimpleReaderFunc_hasFeature_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlSimpleReader.hasFeature", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_hasProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // hasProperty(QString)const
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlSimpleReader::hasProperty(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlSimpleReaderFunc_hasProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlSimpleReaderFunc_hasProperty_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlSimpleReader.hasProperty", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_lexicalHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lexicalHandler()const
    QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
    QXmlLexicalHandler * cpp_result = cppSelf->QXmlSimpleReader::lexicalHandler();
    py_result = Shiboken::Converter<QXmlLexicalHandler* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlSimpleReaderFunc_parse(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "parse", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QXmlInputSource& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlInputSource* cpp_arg0 = Shiboken::Converter<QXmlInputSource* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // parse(QXmlInputSource)
            QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlSimpleReader::parse(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // parse(const QXmlInputSource*,bool)
            QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlSimpleReader::parse(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQXmlSimpleReaderFunc_parse_TypeError;
    } else goto SbkQXmlSimpleReaderFunc_parse_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlSimpleReaderFunc_parse_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlInputSource", "PySide.QtXml.QXmlInputSource", "PySide.QtXml.QXmlInputSource, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlSimpleReader.parse", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_parseContinue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parseContinue()
    QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlSimpleReader::parseContinue();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlSimpleReaderFunc_property(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // property(QString,bool*)const
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_args,bool* - START
        bool ok_;
        void * retval_ = cppSelf->property(*cpp_arg0, &ok_);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_args,bool* - END
        
        // End of code injection


    } else goto SbkQXmlSimpleReaderFunc_property_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlSimpleReaderFunc_property_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlSimpleReader.property", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_setContentHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlContentHandler* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlContentHandler* cpp_arg0 = Shiboken::Converter<QXmlContentHandler* >::toCpp(arg);
        // setContentHandler(QXmlContentHandler*)
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlSimpleReader::setContentHandler(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQXmlSimpleReaderFunc_setContentHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSimpleReaderFunc_setContentHandler_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlContentHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlSimpleReader.setContentHandler", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_setDTDHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlDTDHandler* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlDTDHandler* cpp_arg0 = Shiboken::Converter<QXmlDTDHandler* >::toCpp(arg);
        // setDTDHandler(QXmlDTDHandler*)
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlSimpleReader::setDTDHandler(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQXmlSimpleReaderFunc_setDTDHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSimpleReaderFunc_setDTDHandler_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlDTDHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlSimpleReader.setDTDHandler", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_setDeclHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlDeclHandler* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlDeclHandler* cpp_arg0 = Shiboken::Converter<QXmlDeclHandler* >::toCpp(arg);
        // setDeclHandler(QXmlDeclHandler*)
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlSimpleReader::setDeclHandler(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQXmlSimpleReaderFunc_setDeclHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSimpleReaderFunc_setDeclHandler_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlDeclHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlSimpleReader.setDeclHandler", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_setEntityResolver(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlEntityResolver* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlEntityResolver* cpp_arg0 = Shiboken::Converter<QXmlEntityResolver* >::toCpp(arg);
        // setEntityResolver(QXmlEntityResolver*)
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlSimpleReader::setEntityResolver(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQXmlSimpleReaderFunc_setEntityResolver_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSimpleReaderFunc_setEntityResolver_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlEntityResolver", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlSimpleReader.setEntityResolver", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_setErrorHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlErrorHandler* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlErrorHandler* cpp_arg0 = Shiboken::Converter<QXmlErrorHandler* >::toCpp(arg);
        // setErrorHandler(QXmlErrorHandler*)
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlSimpleReader::setErrorHandler(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQXmlSimpleReaderFunc_setErrorHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSimpleReaderFunc_setErrorHandler_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlErrorHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlSimpleReader.setErrorHandler", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_setFeature(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFeature", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setFeature(QString,bool)
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlSimpleReader::setFeature(*cpp_arg0, cpp_arg1);
    } else goto SbkQXmlSimpleReaderFunc_setFeature_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSimpleReaderFunc_setFeature_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlSimpleReader.setFeature", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_setLexicalHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlLexicalHandler* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlLexicalHandler* cpp_arg0 = Shiboken::Converter<QXmlLexicalHandler* >::toCpp(arg);
        // setLexicalHandler(QXmlLexicalHandler*)
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlSimpleReader::setLexicalHandler(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQXmlSimpleReaderFunc_setLexicalHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSimpleReaderFunc_setLexicalHandler_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlLexicalHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlSimpleReader.setLexicalHandler", overloads);
        return 0;
}

static PyObject*
SbkQXmlSimpleReaderFunc_setProperty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setProperty", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<void * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        void * cpp_arg1 = Shiboken::Converter<void * >::toCpp(pyargs[1]);
        // setProperty(QString,void*)
        QXmlSimpleReader* cppSelf = Shiboken::Converter<QXmlSimpleReader* >::toCpp((PyObject*)self);
        cppSelf->QXmlSimpleReader::setProperty(*cpp_arg0, cpp_arg1);
    } else goto SbkQXmlSimpleReaderFunc_setProperty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSimpleReaderFunc_setProperty_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, void", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlSimpleReader.setProperty", overloads);
        return 0;
}

static PyMethodDef SbkQXmlSimpleReader_methods[] = {
    {"DTDHandler", (PyCFunction)SbkQXmlSimpleReaderFunc_DTDHandler, METH_NOARGS},
    {"contentHandler", (PyCFunction)SbkQXmlSimpleReaderFunc_contentHandler, METH_NOARGS},
    {"declHandler", (PyCFunction)SbkQXmlSimpleReaderFunc_declHandler, METH_NOARGS},
    {"entityResolver", (PyCFunction)SbkQXmlSimpleReaderFunc_entityResolver, METH_NOARGS},
    {"errorHandler", (PyCFunction)SbkQXmlSimpleReaderFunc_errorHandler, METH_NOARGS},
    {"feature", (PyCFunction)SbkQXmlSimpleReaderFunc_feature, METH_O},
    {"hasFeature", (PyCFunction)SbkQXmlSimpleReaderFunc_hasFeature, METH_O},
    {"hasProperty", (PyCFunction)SbkQXmlSimpleReaderFunc_hasProperty, METH_O},
    {"lexicalHandler", (PyCFunction)SbkQXmlSimpleReaderFunc_lexicalHandler, METH_NOARGS},
    {"parse", (PyCFunction)SbkQXmlSimpleReaderFunc_parse, METH_VARARGS},
    {"parseContinue", (PyCFunction)SbkQXmlSimpleReaderFunc_parseContinue, METH_NOARGS},
    {"property", (PyCFunction)SbkQXmlSimpleReaderFunc_property, METH_O},
    {"setContentHandler", (PyCFunction)SbkQXmlSimpleReaderFunc_setContentHandler, METH_O},
    {"setDTDHandler", (PyCFunction)SbkQXmlSimpleReaderFunc_setDTDHandler, METH_O},
    {"setDeclHandler", (PyCFunction)SbkQXmlSimpleReaderFunc_setDeclHandler, METH_O},
    {"setEntityResolver", (PyCFunction)SbkQXmlSimpleReaderFunc_setEntityResolver, METH_O},
    {"setErrorHandler", (PyCFunction)SbkQXmlSimpleReaderFunc_setErrorHandler, METH_O},
    {"setFeature", (PyCFunction)SbkQXmlSimpleReaderFunc_setFeature, METH_VARARGS},
    {"setLexicalHandler", (PyCFunction)SbkQXmlSimpleReaderFunc_setLexicalHandler, METH_O},
    {"setProperty", (PyCFunction)SbkQXmlSimpleReaderFunc_setProperty, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlSimpleReader_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QXmlSimpleReader",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QXmlSimpleReaderWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlSimpleReader_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlSimpleReader_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QXmlSimpleReader(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QXMLSIMPLEREADER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlSimpleReader_Type);

    SbkQXmlSimpleReader_Type.super.ht_type.tp_base = SbkPySide_QtXmlTypes[SBK_QXMLREADER_IDX];
    // Fill type discovery information
    SbkQXmlSimpleReader_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLREADER_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQXmlSimpleReader_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlSimpleReader_Type));
    PyModule_AddObject(module, "QXmlSimpleReader",
        ((PyObject*)&SbkQXmlSimpleReader_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlSimpleReader >("QXmlSimpleReader*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlSimpleReader >(typeid(QXmlSimpleReader).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

