/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qxmldeclhandler_wrapper.h"

// Extra includes
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QXmlDeclHandlerWrapper::QXmlDeclHandlerWrapper() : QXmlDeclHandler() {
    // ... middle
}

bool QXmlDeclHandlerWrapper::attributeDecl(const QString & eName, const QString & aName, const QString & type, const QString & valueDefault, const QString & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "attributeDecl"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlDeclHandler.attributeDecl()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOOO)",
        Shiboken::Converter<QString& >::toPython(eName),
        Shiboken::Converter<QString& >::toPython(aName),
        Shiboken::Converter<QString& >::toPython(type),
        Shiboken::Converter<QString& >::toPython(valueDefault),
        Shiboken::Converter<QString& >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDeclHandler.attributeDecl");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QString QXmlDeclHandlerWrapper::errorString() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "errorString"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlDeclHandler.errorString()' not implemented.");
        return QString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDeclHandler.errorString");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDeclHandlerWrapper::externalEntityDecl(const QString & name, const QString & publicId, const QString & systemId)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "externalEntityDecl"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlDeclHandler.externalEntityDecl()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QString& >::toPython(name),
        Shiboken::Converter<QString& >::toPython(publicId),
        Shiboken::Converter<QString& >::toPython(systemId)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDeclHandler.externalEntityDecl");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlDeclHandlerWrapper::internalEntityDecl(const QString & name, const QString & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "internalEntityDecl"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlDeclHandler.internalEntityDecl()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(name),
        Shiboken::Converter<QString& >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlDeclHandler.internalEntityDecl");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QXmlDeclHandlerWrapper::~QXmlDeclHandlerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQXmlDeclHandler_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlDeclHandlerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLDECLHANDLER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QXmlDeclHandler' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QXmlDeclHandler()
    cptr = new QXmlDeclHandlerWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQXmlDeclHandlerFunc_attributeDecl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "attributeDecl", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2]) && Shiboken::Converter<QString& >::isConvertible(pyargs[3]) && Shiboken::Converter<QString& >::isConvertible(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        std::auto_ptr<QString > cpp_arg4_auto_ptr;
        QString* cpp_arg4 = Shiboken::Converter<QString* >::toCpp(pyargs[4]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[4]))
            cpp_arg4_auto_ptr = std::auto_ptr<QString >(cpp_arg4);
        // attributeDecl(QString,QString,QString,QString,QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlDeclHandler.attributeDecl()' not implemented.");
            return 0;
        }
        QXmlDeclHandler* cppSelf = Shiboken::Converter<QXmlDeclHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->attributeDecl(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, *cpp_arg4);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDeclHandlerFunc_attributeDecl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDeclHandlerFunc_attributeDecl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDeclHandler.attributeDecl", overloads);
        return 0;
}

static PyObject*
SbkQXmlDeclHandlerFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlDeclHandler.errorString()' not implemented.");
        return 0;
    }
    QXmlDeclHandler* cppSelf = Shiboken::Converter<QXmlDeclHandler* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlDeclHandlerFunc_externalEntityDecl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "externalEntityDecl", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // externalEntityDecl(QString,QString,QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlDeclHandler.externalEntityDecl()' not implemented.");
            return 0;
        }
        QXmlDeclHandler* cppSelf = Shiboken::Converter<QXmlDeclHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->externalEntityDecl(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDeclHandlerFunc_externalEntityDecl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDeclHandlerFunc_externalEntityDecl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDeclHandler.externalEntityDecl", overloads);
        return 0;
}

static PyObject*
SbkQXmlDeclHandlerFunc_internalEntityDecl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "internalEntityDecl", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // internalEntityDecl(QString,QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlDeclHandler.internalEntityDecl()' not implemented.");
            return 0;
        }
        QXmlDeclHandler* cppSelf = Shiboken::Converter<QXmlDeclHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->internalEntityDecl(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlDeclHandlerFunc_internalEntityDecl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlDeclHandlerFunc_internalEntityDecl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlDeclHandler.internalEntityDecl", overloads);
        return 0;
}

static PyMethodDef SbkQXmlDeclHandler_methods[] = {
    {"attributeDecl", (PyCFunction)SbkQXmlDeclHandlerFunc_attributeDecl, METH_VARARGS},
    {"errorString", (PyCFunction)SbkQXmlDeclHandlerFunc_errorString, METH_NOARGS},
    {"externalEntityDecl", (PyCFunction)SbkQXmlDeclHandlerFunc_externalEntityDecl, METH_VARARGS},
    {"internalEntityDecl", (PyCFunction)SbkQXmlDeclHandlerFunc_internalEntityDecl, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlDeclHandler_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QXmlDeclHandler",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QXmlDeclHandlerWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlDeclHandler_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlDeclHandler_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQXmlDeclHandler_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQXmlDeclHandler_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QXmlDeclHandler*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QXmlDeclHandler(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QXMLDECLHANDLER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlDeclHandler_Type);

    // Fill type discovery information
    SbkQXmlDeclHandler_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQXmlDeclHandler_Type.type_discovery->addTypeDiscoveryFunction(&SbkQXmlDeclHandler_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlDeclHandler_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlDeclHandler_Type));
    PyModule_AddObject(module, "QXmlDeclHandler",
        ((PyObject*)&SbkQXmlDeclHandler_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlDeclHandler >("QXmlDeclHandler*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlDeclHandler >(typeid(QXmlDeclHandler).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

