/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qtxml_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef QtXml_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_QXmlEntityResolver(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlAttributes(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlLexicalHandler(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomNodeList(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlDeclHandler(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomNamedNodeMap(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlLocator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlReader(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlSimpleReader(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlDTDHandler(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlNamespaceSupport(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomImplementation(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlErrorHandler(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlContentHandler(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlDefaultHandler(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlInputSource(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomNode(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomElement(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomAttr(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomDocumentFragment(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomProcessingInstruction(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomNotation(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomEntity(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomDocument(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomDocumentType(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomEntityReference(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlParseException(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomCharacterData(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomText(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomCDATASection(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QDomComment(PyObject* module);

PyTypeObject** SbkPySide_QtXmlTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

extern "C" {

SHIBOKEN_QTXML_API PyMODINIT_FUNC
initQtXml()
{
    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtXml", QtXml_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtXml_IDX_COUNT];
    SbkPySide_QtXmlTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QXmlEntityResolver(module);
    init_QXmlAttributes(module);
    init_QXmlLexicalHandler(module);
    init_QDomNodeList(module);
    init_QXmlDeclHandler(module);
    init_QDomNamedNodeMap(module);
    init_QXmlLocator(module);
    init_QXmlReader(module);
    init_QXmlSimpleReader(module);
    init_QXmlDTDHandler(module);
    init_QXmlNamespaceSupport(module);
    init_QDomImplementation(module);
    init_QXmlErrorHandler(module);
    init_QXmlContentHandler(module);
    init_QXmlDefaultHandler(module);
    init_QXmlInputSource(module);
    init_QDomNode(module);
    init_QDomElement(module);
    init_QDomAttr(module);
    init_QDomDocumentFragment(module);
    init_QDomProcessingInstruction(module);
    init_QDomNotation(module);
    init_QDomEntity(module);
    init_QDomDocument(module);
    init_QDomDocumentType(module);
    init_QDomEntityReference(module);
    init_QXmlParseException(module);
    init_QDomCharacterData(module);
    init_QDomText(module);
    init_QDomCDATASection(module);
    init_QDomComment(module);


    // Initialize namespaces as uninstantiable classes in the type system

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtXml");
    }
}

} // extern "C"

