/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtwebkit_python.h"

#include "qwebsecurityorigin_wrapper.h"

// Extra includes
#include <QList>
#include <qstring.h>
#include <qstringlist.h>
#include <qwebdatabase.h>
#include <qwebsecurityorigin.h>

using namespace Shiboken;

static int
SbkQWebSecurityOrigin_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWebSecurityOrigin* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QWebSecurityOrigin", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QWebSecurityOrigin& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWebSecurityOrigin* cpp_arg0 = Shiboken::Converter<QWebSecurityOrigin* >::toCpp(pyargs[0]);
        // QWebSecurityOrigin(QWebSecurityOrigin)
        cptr = new QWebSecurityOrigin(*cpp_arg0);
    } else goto SbkQWebSecurityOrigin_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWebSecurityOrigin_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQWebSecurityOrigin_Init_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSecurityOrigin", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebSecurityOrigin", overloads);
        return -1;
}

static PyObject*
SbkQWebSecurityOriginFunc_addLocalScheme(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addLocalScheme(QString)
        QWebSecurityOrigin::addLocalScheme(*cpp_arg0);
    } else goto SbkQWebSecurityOriginFunc_addLocalScheme_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSecurityOriginFunc_addLocalScheme_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSecurityOrigin.addLocalScheme", overloads);
        return 0;
}

static PyObject*
SbkQWebSecurityOriginFunc_allOrigins(PyObject* self)
{
    PyObject* py_result = 0;

    // allOrigins()
    QList<QWebSecurityOrigin > cpp_result = QWebSecurityOrigin::allOrigins();
    py_result = Shiboken::Converter<QList<QWebSecurityOrigin > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebSecurityOriginFunc_databaseQuota(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // databaseQuota()const
    QWebSecurityOrigin* cppSelf = Shiboken::Converter<QWebSecurityOrigin* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QWebSecurityOrigin::databaseQuota();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebSecurityOriginFunc_databaseUsage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // databaseUsage()const
    QWebSecurityOrigin* cppSelf = Shiboken::Converter<QWebSecurityOrigin* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QWebSecurityOrigin::databaseUsage();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebSecurityOriginFunc_databases(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // databases()const
    QWebSecurityOrigin* cppSelf = Shiboken::Converter<QWebSecurityOrigin* >::toCpp((PyObject*)self);
    QList<QWebDatabase > cpp_result = cppSelf->QWebSecurityOrigin::databases();
    py_result = Shiboken::Converter<QList<QWebDatabase > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebSecurityOriginFunc_host(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // host()const
    QWebSecurityOrigin* cppSelf = Shiboken::Converter<QWebSecurityOrigin* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebSecurityOrigin::host();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebSecurityOriginFunc_localSchemes(PyObject* self)
{
    PyObject* py_result = 0;

    // localSchemes()
    QStringList cpp_result = QWebSecurityOrigin::localSchemes();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebSecurityOriginFunc_port(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // port()const
    QWebSecurityOrigin* cppSelf = Shiboken::Converter<QWebSecurityOrigin* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWebSecurityOrigin::port();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebSecurityOriginFunc_removeLocalScheme(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeLocalScheme(QString)
        QWebSecurityOrigin::removeLocalScheme(*cpp_arg0);
    } else goto SbkQWebSecurityOriginFunc_removeLocalScheme_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSecurityOriginFunc_removeLocalScheme_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSecurityOrigin.removeLocalScheme", overloads);
        return 0;
}

static PyObject*
SbkQWebSecurityOriginFunc_scheme(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scheme()const
    QWebSecurityOrigin* cppSelf = Shiboken::Converter<QWebSecurityOrigin* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebSecurityOrigin::scheme();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebSecurityOriginFunc_setDatabaseQuota(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setDatabaseQuota(qint64)
        QWebSecurityOrigin* cppSelf = Shiboken::Converter<QWebSecurityOrigin* >::toCpp((PyObject*)self);
        cppSelf->QWebSecurityOrigin::setDatabaseQuota(cpp_arg0);
    } else goto SbkQWebSecurityOriginFunc_setDatabaseQuota_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSecurityOriginFunc_setDatabaseQuota_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSecurityOrigin.setDatabaseQuota", overloads);
        return 0;
}

static PyMethodDef SbkQWebSecurityOrigin_methods[] = {
    {"addLocalScheme", (PyCFunction)SbkQWebSecurityOriginFunc_addLocalScheme, METH_O|METH_STATIC},
    {"allOrigins", (PyCFunction)SbkQWebSecurityOriginFunc_allOrigins, METH_NOARGS|METH_STATIC},
    {"databaseQuota", (PyCFunction)SbkQWebSecurityOriginFunc_databaseQuota, METH_NOARGS},
    {"databaseUsage", (PyCFunction)SbkQWebSecurityOriginFunc_databaseUsage, METH_NOARGS},
    {"databases", (PyCFunction)SbkQWebSecurityOriginFunc_databases, METH_NOARGS},
    {"host", (PyCFunction)SbkQWebSecurityOriginFunc_host, METH_NOARGS},
    {"localSchemes", (PyCFunction)SbkQWebSecurityOriginFunc_localSchemes, METH_NOARGS|METH_STATIC},
    {"port", (PyCFunction)SbkQWebSecurityOriginFunc_port, METH_NOARGS},
    {"removeLocalScheme", (PyCFunction)SbkQWebSecurityOriginFunc_removeLocalScheme, METH_O|METH_STATIC},
    {"scheme", (PyCFunction)SbkQWebSecurityOriginFunc_scheme, METH_NOARGS},
    {"setDatabaseQuota", (PyCFunction)SbkQWebSecurityOriginFunc_setDatabaseQuota, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebSecurityOrigin_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QWebSecurityOrigin",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QWebSecurityOrigin >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebSecurityOrigin_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWebSecurityOrigin_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QWebSecurityOrigin(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBSECURITYORIGIN_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebSecurityOrigin_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQWebSecurityOrigin_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWebSecurityOrigin_Type));
    PyModule_AddObject(module, "QWebSecurityOrigin",
        ((PyObject*)&SbkQWebSecurityOrigin_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QWebSecurityOrigin >("QWebSecurityOrigin");
    Shiboken::TypeResolver::createValueTypeResolver<QWebSecurityOrigin >(typeid(QWebSecurityOrigin).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

