/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtwebkit_python.h"

#include "qwebpluginfactory_plugin_wrapper.h"

// Extra includes

using namespace Shiboken;

// Native ---------------------------------------------------------

PluginWrapper::PluginWrapper() : QWebPluginFactory::Plugin() {
    // ... middle
}

PluginWrapper::~PluginWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQWebPluginFactory_Plugin_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    PluginWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // Plugin()
    cptr = new PluginWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyMethodDef SbkQWebPluginFactory_Plugin_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQWebPluginFactory_Plugin_get_description(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QString >::toPython(Shiboken::Converter<QWebPluginFactory::Plugin* >::toCpp((PyObject*)self)->description);
}
static int SbkQWebPluginFactory_Plugin_set_description(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'description' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QString >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'description', 'QString' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QWebPluginFactory::Plugin* >::toCpp((PyObject*)self)->description = Shiboken::Converter<QString >::toCpp(value);

    return 0;
}

static PyObject* SbkQWebPluginFactory_Plugin_get_name(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QString >::toPython(Shiboken::Converter<QWebPluginFactory::Plugin* >::toCpp((PyObject*)self)->name);
}
static int SbkQWebPluginFactory_Plugin_set_name(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'name' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QString >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'name', 'QString' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QWebPluginFactory::Plugin* >::toCpp((PyObject*)self)->name = Shiboken::Converter<QString >::toCpp(value);

    return 0;
}

// Getters and Setters for Plugin
static PyGetSetDef SbkQWebPluginFactory_Plugin_getsetlist[] = {
    {const_cast<char*>("description"), (getter)SbkQWebPluginFactory_Plugin_get_description, (setter)SbkQWebPluginFactory_Plugin_set_description},
    {const_cast<char*>("name"), (getter)SbkQWebPluginFactory_Plugin_get_name, (setter)SbkQWebPluginFactory_Plugin_set_name},
    {0}  // Sentinel
};

extern "C"
{

static void* SbkQWebPluginFactory_Plugin_ObjCopierFunc(const void* ptr){
    return new PluginWrapper(*reinterpret_cast<const QWebPluginFactory::Plugin*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebPluginFactory_Plugin_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.Plugin",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< PluginWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebPluginFactory_Plugin_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQWebPluginFactory_Plugin_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWebPluginFactory_Plugin_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQWebPluginFactory_Plugin_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQWebPluginFactory_Plugin_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQWebPluginFactory_Plugin_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QWebPluginFactory::Plugin*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QWebPluginFactory_Plugin(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_PLUGIN_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebPluginFactory_Plugin_Type);

    // Fill type discovery information
    SbkQWebPluginFactory_Plugin_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQWebPluginFactory_Plugin_Type.type_discovery->addTypeDiscoveryFunction(&SbkQWebPluginFactory_Plugin_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQWebPluginFactory_Plugin_Type) < 0)
        return;

    PyDict_SetItemString(module,"Plugin", (PyObject*)&SbkQWebPluginFactory_Plugin_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QWebPluginFactory::Plugin >("QWebPluginFactory::Plugin");
    Shiboken::TypeResolver::createValueTypeResolver<QWebPluginFactory::Plugin >(typeid(QWebPluginFactory::Plugin).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

