/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtwebkit_python.h"

#include "qwebhistory_wrapper.h"

// Extra includes
#include <QList>
#include <qdatastream.h>
#include <qwebhistory.h>

using namespace Shiboken;

static PyObject*
SbkQWebHistoryFunc_back(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // back()
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    cppSelf->QWebHistory::back();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWebHistoryFunc_backItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // backItem()const
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    QWebHistoryItem cpp_result = cppSelf->QWebHistory::backItem();
    py_result = Shiboken::Converter<QWebHistoryItem >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebHistoryFunc_backItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // backItems(int)const
        QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
        QList<QWebHistoryItem > cpp_result = cppSelf->QWebHistory::backItems(cpp_arg0);
        py_result = Shiboken::Converter<QList<QWebHistoryItem > >::toPython(cpp_result);
    } else goto SbkQWebHistoryFunc_backItems_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWebHistoryFunc_backItems_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebHistory.backItems", overloads);
        return 0;
}

static PyObject*
SbkQWebHistoryFunc_canGoBack(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canGoBack()const
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebHistory::canGoBack();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebHistoryFunc_canGoForward(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canGoForward()const
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebHistory::canGoForward();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebHistoryFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    cppSelf->QWebHistory::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWebHistoryFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWebHistory::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebHistoryFunc_currentItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentItem()const
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    QWebHistoryItem cpp_result = cppSelf->QWebHistory::currentItem();
    py_result = Shiboken::Converter<QWebHistoryItem >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebHistoryFunc_currentItemIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentItemIndex()const
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWebHistory::currentItemIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebHistoryFunc_forward(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // forward()
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    cppSelf->QWebHistory::forward();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWebHistoryFunc_forwardItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // forwardItem()const
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    QWebHistoryItem cpp_result = cppSelf->QWebHistory::forwardItem();
    py_result = Shiboken::Converter<QWebHistoryItem >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebHistoryFunc_forwardItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // forwardItems(int)const
        QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
        QList<QWebHistoryItem > cpp_result = cppSelf->QWebHistory::forwardItems(cpp_arg0);
        py_result = Shiboken::Converter<QList<QWebHistoryItem > >::toPython(cpp_result);
    } else goto SbkQWebHistoryFunc_forwardItems_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWebHistoryFunc_forwardItems_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebHistory.forwardItems", overloads);
        return 0;
}

static PyObject*
SbkQWebHistoryFunc_goToItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebHistoryItem& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebHistoryItem* cpp_arg0 = Shiboken::Converter<QWebHistoryItem* >::toCpp(arg);
        // goToItem(QWebHistoryItem)
        QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
        cppSelf->QWebHistory::goToItem(*cpp_arg0);
    } else goto SbkQWebHistoryFunc_goToItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebHistoryFunc_goToItem_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebHistoryItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebHistory.goToItem", overloads);
        return 0;
}

static PyObject*
SbkQWebHistoryFunc_itemAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemAt(int)const
        QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
        QWebHistoryItem cpp_result = cppSelf->QWebHistory::itemAt(cpp_arg0);
        py_result = Shiboken::Converter<QWebHistoryItem >::toPython(cpp_result);
    } else goto SbkQWebHistoryFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWebHistoryFunc_itemAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebHistory.itemAt", overloads);
        return 0;
}

static PyObject*
SbkQWebHistoryFunc_items(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // items()const
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    QList<QWebHistoryItem > cpp_result = cppSelf->QWebHistory::items();
    py_result = Shiboken::Converter<QList<QWebHistoryItem > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebHistoryFunc_maximumItemCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumItemCount()const
    QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWebHistory::maximumItemCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWebHistoryFunc_setMaximumItemCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaximumItemCount(int)
        QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
        cppSelf->QWebHistory::setMaximumItemCount(cpp_arg0);
    } else goto SbkQWebHistoryFunc_setMaximumItemCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebHistoryFunc_setMaximumItemCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebHistory.setMaximumItemCount", overloads);
        return 0;
}

static PyMethodDef SbkQWebHistory_methods[] = {
    {"back", (PyCFunction)SbkQWebHistoryFunc_back, METH_NOARGS},
    {"backItem", (PyCFunction)SbkQWebHistoryFunc_backItem, METH_NOARGS},
    {"backItems", (PyCFunction)SbkQWebHistoryFunc_backItems, METH_O},
    {"canGoBack", (PyCFunction)SbkQWebHistoryFunc_canGoBack, METH_NOARGS},
    {"canGoForward", (PyCFunction)SbkQWebHistoryFunc_canGoForward, METH_NOARGS},
    {"clear", (PyCFunction)SbkQWebHistoryFunc_clear, METH_NOARGS},
    {"count", (PyCFunction)SbkQWebHistoryFunc_count, METH_NOARGS},
    {"currentItem", (PyCFunction)SbkQWebHistoryFunc_currentItem, METH_NOARGS},
    {"currentItemIndex", (PyCFunction)SbkQWebHistoryFunc_currentItemIndex, METH_NOARGS},
    {"forward", (PyCFunction)SbkQWebHistoryFunc_forward, METH_NOARGS},
    {"forwardItem", (PyCFunction)SbkQWebHistoryFunc_forwardItem, METH_NOARGS},
    {"forwardItems", (PyCFunction)SbkQWebHistoryFunc_forwardItems, METH_O},
    {"goToItem", (PyCFunction)SbkQWebHistoryFunc_goToItem, METH_O},
    {"itemAt", (PyCFunction)SbkQWebHistoryFunc_itemAt, METH_O},
    {"items", (PyCFunction)SbkQWebHistoryFunc_items, METH_NOARGS},
    {"maximumItemCount", (PyCFunction)SbkQWebHistoryFunc_maximumItemCount, METH_NOARGS},
    {"setMaximumItemCount", (PyCFunction)SbkQWebHistoryFunc_setMaximumItemCount, METH_O},
    {0} // Sentinel
};

static PyObject*
SbkQWebHistoryFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQWebHistory_Check(arg) && !SbkQWebHistory_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QWebHistory) [reverse operator]
        QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQWebHistoryFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWebHistoryFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebHistory.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQWebHistoryFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQWebHistory_Check(arg) && !SbkQWebHistory_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QWebHistory&) [reverse operator]
        QWebHistory* cppSelf = Shiboken::Converter<QWebHistory* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQWebHistoryFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWebHistoryFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebHistory.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQWebHistory_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQWebHistoryFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQWebHistoryFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebHistory_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QWebHistory",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          Shiboken::SbkBaseWrapper_Dealloc_PrivateDtor,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQWebHistory_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebHistory_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QWebHistory(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBHISTORY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebHistory_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQWebHistory_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWebHistory_Type));
    PyModule_AddObject(module, "QWebHistory",
        ((PyObject*)&SbkQWebHistory_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QWebHistory >("QWebHistory*");
    Shiboken::TypeResolver::createObjectTypeResolver<QWebHistory >(typeid(QWebHistory).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

