/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtwebkit_python.h"

#include "qgraphicswebview_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicsitem.h>
#include <qgraphicslayout.h>
#include <qgraphicslayoutitem.h>
#include <qgraphicssceneevent.h>
#include <qgraphicswidget.h>
#include <qicon.h>
#include <qkeysequence.h>
#include <qnetworkrequest.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpainterpath.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwebhistory.h>
#include <qwebpage.h>
#include <qwebsettings.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsWebViewWrapper::QGraphicsWebViewWrapper(QGraphicsItem * parent) : QGraphicsWebView(parent), m_metaObject(0) {
    // ... middle
}

void QGraphicsWebViewWrapper::advance(int phase)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "advance"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::advance(phase);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        phase
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QRectF QGraphicsWebViewWrapper::boundingRect() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "boundingRect"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::boundingRect();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRectF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRectF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.boundingRect");
        return QRectF()        ;
    }
    QRectF cpp_result(Shiboken::Converter<QRectF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::changeEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::changeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWebViewWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::closeEvent(QCloseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::closeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QGraphicsWebViewWrapper::collidesWithItem(const QGraphicsItem * other, Qt::ItemSelectionMode mode) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "collidesWithItem"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::collidesWithItem(other, mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QGraphicsItem* >::toPython(other),
        Shiboken::Converter<Qt::ItemSelectionMode >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.collidesWithItem");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsWebViewWrapper::collidesWithPath(const QPainterPath & path, Qt::ItemSelectionMode mode) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "collidesWithPath"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::collidesWithPath(path, mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QPainterPath& >::toPython(path),
        Shiboken::Converter<Qt::ItemSelectionMode >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.collidesWithPath");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsWebViewWrapper::contains(const QPointF & point) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contains"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::contains(point);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPointF& >::toPython(point)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.contains");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::contextMenuEvent(QGraphicsSceneContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::dragEnterEvent(QGraphicsSceneDragDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::dragLeaveEvent(QGraphicsSceneDragDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::dragMoveEvent(QGraphicsSceneDragDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::dropEvent(QGraphicsSceneDragDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsWebViewWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsWebViewWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QGraphicsWebViewWrapper::extension(const QVariant & variant) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "extension"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::extension(variant);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QVariant& >::toPython(variant)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.extension");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsWebViewWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::grabKeyboardEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "grabKeyboardEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::grabKeyboardEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWebViewWrapper::grabMouseEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "grabMouseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::grabMouseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWebViewWrapper::hideEvent(QHideEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::hideEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWebViewWrapper::hoverEnterEvent(QGraphicsSceneHoverEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hoverEnterEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::hoverEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneHoverEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::hoverLeaveEvent(QGraphicsSceneHoverEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hoverLeaveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::hoverLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneHoverEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::hoverMoveEvent(QGraphicsSceneHoverEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hoverMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::hoverMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneHoverEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QGraphicsWebViewWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsWebViewWrapper::isObscuredBy(const QGraphicsItem * item) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isObscuredBy"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::isObscuredBy(item);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsItem* >::toPython(item)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.isObscuredBy");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QGraphicsWebViewWrapper::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemChange"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::itemChange(change, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QGraphicsItem::GraphicsItemChange >::toPython(change),
        Shiboken::Converter<QVariant& >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.itemChange");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::mouseDoubleClickEvent(QGraphicsSceneMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::mouseMoveEvent(QGraphicsSceneMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::mousePressEvent(QGraphicsSceneMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::mouseReleaseEvent(QGraphicsSceneMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::moveEvent(QGraphicsSceneMoveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::moveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneMoveEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPainterPath QGraphicsWebViewWrapper::opaqueArea() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "opaqueArea"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::opaqueArea();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPainterPath();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPainterPath >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.opaqueArea");
        return QPainterPath()        ;
    }
    QPainterPath cpp_result(Shiboken::Converter<QPainterPath >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::paint(QPainter * arg__1, const QStyleOptionGraphicsItem * options, QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paint"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::paint(arg__1, options, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QPainter* >::toPython(arg__1),
        Shiboken::Converter<QStyleOptionGraphicsItem* >::toPython(options),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::paintWindowFrame(QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintWindowFrame"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::paintWindowFrame(painter, option, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QStyleOptionGraphicsItem* >::toPython(option),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWebViewWrapper::polishEvent()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polishEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::polishEvent();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QGraphicsWebViewWrapper::propertyChange(const QString & propertyName, const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "propertyChange"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::propertyChange(propertyName, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(propertyName),
        Shiboken::Converter<QVariant& >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.propertyChange");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::resizeEvent(QGraphicsSceneResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneResizeEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QGraphicsWebViewWrapper::sceneEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sceneEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::sceneEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.sceneEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsWebViewWrapper::sceneEventFilter(QGraphicsItem * watched, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sceneEventFilter"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::sceneEventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QGraphicsItem* >::toPython(watched),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.sceneEventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::setGeometry(const QRectF & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::setGeometry(rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QRectF& >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QPainterPath QGraphicsWebViewWrapper::shape() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "shape"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::shape();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPainterPath();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPainterPath >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.shape");
        return QPainterPath()        ;
    }
    QPainterPath cpp_result(Shiboken::Converter<QPainterPath >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::showEvent(QShowEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::showEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSizeF QGraphicsWebViewWrapper::sizeHint(Qt::SizeHint which, const QSizeF & constraint) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::sizeHint(which, constraint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<Qt::SizeHint >::toPython(which),
        Shiboken::Converter<QSizeF& >::toPython(constraint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSizeF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSizeF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.sizeHint");
        return QSizeF()        ;
    }
    QSizeF cpp_result(Shiboken::Converter<QSizeF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QGraphicsWebViewWrapper::type() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "type"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::type();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.type");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsWebViewWrapper::ungrabKeyboardEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "ungrabKeyboardEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::ungrabKeyboardEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWebViewWrapper::ungrabMouseEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "ungrabMouseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::ungrabMouseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsWebViewWrapper::updateGeometry()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::updateGeometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsWebViewWrapper::wheelEvent(QGraphicsSceneWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWebView::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneWheelEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsWebViewWrapper::windowFrameEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "windowFrameEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::windowFrameEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.windowFrameEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

Qt::WindowFrameSection QGraphicsWebViewWrapper::windowFrameSectionAt(const QPointF & pos) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "windowFrameSectionAt"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::windowFrameSectionAt(pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPointF& >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return Qt::WindowFrameSection();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<Qt::WindowFrameSection >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsWebView.windowFrameSectionAt");
        return Qt::WindowFrameSection()        ;
    }
    Qt::WindowFrameSection cpp_result(Shiboken::Converter<Qt::WindowFrameSection >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QGraphicsWebViewWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGraphicsWebView::staticMetaObject);
}
    return m_metaObject;
}

int QGraphicsWebViewWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGraphicsWebView::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGraphicsWebViewWrapper::~QGraphicsWebViewWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsWebView_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsWebViewWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsWebView", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsWebView(QGraphicsItem*)
        cptr = new QGraphicsWebViewWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QGraphicsItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(pyargs[0]);
        // QGraphicsWebView(QGraphicsItem*)
        cptr = new QGraphicsWebViewWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQGraphicsWebView_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsWebView_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGraphicsWebView_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QGraphicsWebView", overloads);
        return -1;
}

static PyObject*
SbkQGraphicsWebViewFunc_back(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // back()
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsWebView::back();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsWebViewFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneContextMenuEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QGraphicsSceneContextMenuEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::contextMenuEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.contextMenuEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_dragEnterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dragEnterEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::dragEnterEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_dragEnterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_dragEnterEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.dragEnterEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_dragLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dragLeaveEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::dragLeaveEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_dragLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_dragLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.dragLeaveEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dragMoveEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::dragMoveEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.dragMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dropEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::dropEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.dropEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsWebView::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGraphicsWebViewFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsWebViewFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.event", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_findText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "findText", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // findText(QString,QFlags<QWebPage::FindFlag>)
            QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QGraphicsWebView::findText(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (SbkPySide_QtWebKit_QWebPage_FindFlag_Check(pyargs[1])) {
            QFlags<QWebPage::FindFlag> cpp_arg1 = Shiboken::Converter<QFlags<QWebPage::FindFlag> >::toCpp(pyargs[1]);
            // findText(QString,QFlags<QWebPage::FindFlag>)
            QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QGraphicsWebView::findText(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQGraphicsWebViewFunc_findText_TypeError;
    } else goto SbkQGraphicsWebViewFunc_findText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsWebViewFunc_findText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtWebKit.QWebPage.FindFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QGraphicsWebView.findText", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::focusInEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.focusInEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsWebView::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGraphicsWebViewFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsWebViewFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.focusNextPrevChild", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::focusOutEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.focusOutEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_forward(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // forward()
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsWebView::forward();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsWebViewFunc_history(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // history()const
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    QWebHistory * cpp_result = cppSelf->QGraphicsWebView::history();
    py_result = Shiboken::Converter<QWebHistory* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsWebViewFunc_hoverLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneHoverEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneHoverEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp(arg);
        // hoverLeaveEvent(QGraphicsSceneHoverEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::hoverLeaveEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_hoverLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_hoverLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneHoverEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.hoverLeaveEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_hoverMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneHoverEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneHoverEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp(arg);
        // hoverMoveEvent(QGraphicsSceneHoverEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::hoverMoveEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_hoverMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_hoverMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneHoverEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.hoverMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_icon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // icon()const
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    QIcon cpp_result = cppSelf->QGraphicsWebView::icon();
    py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsWebViewFunc_inputMethodEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputMethodEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QInputMethodEvent* cpp_arg0 = Shiboken::Converter<QInputMethodEvent* >::toCpp(arg);
        // inputMethodEvent(QInputMethodEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::inputMethodEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_inputMethodEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_inputMethodEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputMethodEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.inputMethodEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_inputMethodQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::InputMethodQuery >::isConvertible(arg)) {
        Qt::InputMethodQuery cpp_arg0 = Shiboken::Converter<Qt::InputMethodQuery >::toCpp(arg);
        // inputMethodQuery(Qt::InputMethodQuery)const
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QGraphicsWebView::inputMethodQuery(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQGraphicsWebViewFunc_inputMethodQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsWebViewFunc_inputMethodQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodQuery", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.inputMethodQuery", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_isModified(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isModified()const
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGraphicsWebView::isModified();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsWebViewFunc_itemChange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemChange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QGraphicsItem::GraphicsItemChange >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        QGraphicsItem::GraphicsItemChange cpp_arg0 = Shiboken::Converter<QGraphicsItem::GraphicsItemChange >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // itemChange(QGraphicsItem::GraphicsItemChange,QVariant)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QGraphicsWebView::itemChange(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQGraphicsWebViewFunc_itemChange_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsWebViewFunc_itemChange_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem.GraphicsItemChange, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QGraphicsWebView.itemChange", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::keyPressEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.keyPressEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_keyReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyReleaseEvent(QKeyEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::keyReleaseEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_keyReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_keyReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.keyReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_load(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "load", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QUrl& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QUrl& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // load(QUrl)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::load(*cpp_arg0);
    } else if (Shiboken::Converter<QNetworkRequest& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QNetworkRequest* cpp_arg0 = Shiboken::Converter<QNetworkRequest* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // load(QNetworkRequest,QNetworkAccessManager::Operation,QByteArray)
            QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWebView::load(*cpp_arg0);
        } else if (Shiboken::Converter<QNetworkAccessManager::Operation >::isConvertible(pyargs[1])) {
            QNetworkAccessManager::Operation cpp_arg1 = Shiboken::Converter<QNetworkAccessManager::Operation >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // load(QNetworkRequest,QNetworkAccessManager::Operation,QByteArray)
                QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsWebView::load(*cpp_arg0, cpp_arg1);
            } else if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QByteArray > cpp_arg2_auto_ptr;
                QByteArray* cpp_arg2 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg2);
                // load(QNetworkRequest,QNetworkAccessManager::Operation,QByteArray)
                QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsWebView::load(*cpp_arg0, cpp_arg1, *cpp_arg2);
            } else goto SbkQGraphicsWebViewFunc_load_TypeError;
        } else goto SbkQGraphicsWebViewFunc_load_TypeError;
    } else goto SbkQGraphicsWebViewFunc_load_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_load_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest, PySide.QtNetwork.QNetworkAccessManager.Operation = QNetworkAccessManager.GetOperation, PySide.QtCore.QByteArray = QByteArray()", "PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QGraphicsWebView.load", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::mouseDoubleClickEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QGraphicsSceneMouseEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::mouseMoveEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.mouseMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mousePressEvent(QGraphicsSceneMouseEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::mousePressEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.mousePressEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QGraphicsSceneMouseEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::mouseReleaseEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_page(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // page()const
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    QWebPage * cpp_result = cppSelf->QGraphicsWebView::page();
    py_result = Shiboken::Converter<QWebPage* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsWebViewFunc_pageAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWebPage::WebAction >::isConvertible(arg)) {
        QWebPage::WebAction cpp_arg0 = Shiboken::Converter<QWebPage::WebAction >::toCpp(arg);
        // pageAction(QWebPage::WebAction)const
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        QAction * cpp_result = cppSelf->QGraphicsWebView::pageAction(cpp_arg0);
        py_result = Shiboken::Converter<QAction* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQGraphicsWebViewFunc_pageAction_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsWebViewFunc_pageAction_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebPage.WebAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.pageAction", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_paint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "paint", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionGraphicsItem* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionGraphicsItem* cpp_arg1 = Shiboken::Converter<QStyleOptionGraphicsItem* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // paint(QPainter*,const QStyleOptionGraphicsItem*,QWidget*)
            QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWebView::paint(cpp_arg0, cpp_arg1);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            // paint(QPainter*,const QStyleOptionGraphicsItem*,QWidget*)
            QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWebView::paint(cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQGraphicsWebViewFunc_paint_TypeError;
    } else goto SbkQGraphicsWebViewFunc_paint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_paint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionGraphicsItem, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QGraphicsWebView.paint", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_reload(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reload()
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsWebView::reload();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsWebViewFunc_sceneEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // sceneEvent(QEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsWebView::sceneEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGraphicsWebViewFunc_sceneEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsWebViewFunc_sceneEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.sceneEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_setContent(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setContent", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // setContent(QByteArray,QString,QUrl)
            QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWebView::setContent(*cpp_arg0);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // setContent(QByteArray,QString,QUrl)
                QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsWebView::setContent(*cpp_arg0, *cpp_arg1);
            } else if (Shiboken::Converter<QUrl& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QUrl > cpp_arg2_auto_ptr;
                QUrl* cpp_arg2 = Shiboken::Converter<QUrl* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QUrl& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QUrl >(cpp_arg2);
                // setContent(QByteArray,QString,QUrl)
                QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsWebView::setContent(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            } else goto SbkQGraphicsWebViewFunc_setContent_TypeError;
        } else goto SbkQGraphicsWebViewFunc_setContent_TypeError;
    } else goto SbkQGraphicsWebViewFunc_setContent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_setContent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, PySide.QtCore.QString = QString(), PySide.QtCore.QUrl = QUrl()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QGraphicsWebView.setContent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setGeometry(QRectF)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::setGeometry(*cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.setGeometry", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_setHtml(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setHtml", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setHtml(QString,QUrl)
            QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWebView::setHtml(*cpp_arg0);
        } else if (Shiboken::Converter<QUrl& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
            QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QUrl& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
            // setHtml(QString,QUrl)
            QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWebView::setHtml(*cpp_arg0, *cpp_arg1);
        } else goto SbkQGraphicsWebViewFunc_setHtml_TypeError;
    } else goto SbkQGraphicsWebViewFunc_setHtml_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_setHtml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QUrl = QUrl()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QGraphicsWebView.setHtml", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_setPage(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebPage* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebPage* cpp_arg0 = Shiboken::Converter<QWebPage* >::toCpp(arg);
        // setPage(QWebPage*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::setPage(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_setPage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_setPage_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebPage", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.setPage", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_setUrl(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QUrl& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!Shiboken::Converter<QUrl& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // setUrl(QUrl)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::setUrl(*cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_setUrl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_setUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.setUrl", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_setZoomFactor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setZoomFactor(qreal)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::setZoomFactor(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_setZoomFactor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_setZoomFactor_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.setZoomFactor", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_settings(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // settings()const
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    QWebSettings * cpp_result = cppSelf->QGraphicsWebView::settings();
    py_result = Shiboken::Converter<QWebSettings* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsWebViewFunc_sizeHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sizeHint", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Qt::SizeHint >::isConvertible(pyargs[0]) && Shiboken::Converter<QSizeF& >::isConvertible(pyargs[1])) {
        Qt::SizeHint cpp_arg0 = Shiboken::Converter<Qt::SizeHint >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg1_auto_ptr;
        QSizeF* cpp_arg1 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QSizeF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg1);
        // sizeHint(Qt::SizeHint,QSizeF)const
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        QSizeF cpp_result = cppSelf->QGraphicsWebView::sizeHint(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    } else goto SbkQGraphicsWebViewFunc_sizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsWebViewFunc_sizeHint_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SizeHint, PySide.QtCore.QSizeF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QGraphicsWebView.sizeHint", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_stop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stop()
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsWebView::stop();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsWebViewFunc_title(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // title()const
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QGraphicsWebView::title();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsWebViewFunc_triggerPageAction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "triggerPageAction", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QWebPage::WebAction >::isConvertible(pyargs[0])) {
        QWebPage::WebAction cpp_arg0 = Shiboken::Converter<QWebPage::WebAction >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // triggerPageAction(QWebPage::WebAction,bool)
            QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWebView::triggerPageAction(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // triggerPageAction(QWebPage::WebAction,bool)
            QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsWebView::triggerPageAction(cpp_arg0, cpp_arg1);
        } else goto SbkQGraphicsWebViewFunc_triggerPageAction_TypeError;
    } else goto SbkQGraphicsWebViewFunc_triggerPageAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_triggerPageAction_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebPage.WebAction, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QGraphicsWebView.triggerPageAction", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_updateGeometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateGeometry()
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsWebView::updateGeometry();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsWebViewFunc_url(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // url()const
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QGraphicsWebView::url();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsWebViewFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneWheelEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneWheelEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp(arg);
        // wheelEvent(QGraphicsSceneWheelEvent*)
        QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsWebView::wheelEvent(cpp_arg0);
    } else goto SbkQGraphicsWebViewFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsWebViewFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QGraphicsWebView.wheelEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsWebViewFunc_zoomFactor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // zoomFactor()const
    QGraphicsWebView* cppSelf = Shiboken::Converter<QGraphicsWebView* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsWebView::zoomFactor();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQGraphicsWebView_methods[] = {
    {"back", (PyCFunction)SbkQGraphicsWebViewFunc_back, METH_NOARGS},
    {"contextMenuEvent", (PyCFunction)SbkQGraphicsWebViewFunc_contextMenuEvent, METH_O},
    {"dragEnterEvent", (PyCFunction)SbkQGraphicsWebViewFunc_dragEnterEvent, METH_O},
    {"dragLeaveEvent", (PyCFunction)SbkQGraphicsWebViewFunc_dragLeaveEvent, METH_O},
    {"dragMoveEvent", (PyCFunction)SbkQGraphicsWebViewFunc_dragMoveEvent, METH_O},
    {"dropEvent", (PyCFunction)SbkQGraphicsWebViewFunc_dropEvent, METH_O},
    {"event", (PyCFunction)SbkQGraphicsWebViewFunc_event, METH_O},
    {"findText", (PyCFunction)SbkQGraphicsWebViewFunc_findText, METH_VARARGS},
    {"focusInEvent", (PyCFunction)SbkQGraphicsWebViewFunc_focusInEvent, METH_O},
    {"focusNextPrevChild", (PyCFunction)SbkQGraphicsWebViewFunc_focusNextPrevChild, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQGraphicsWebViewFunc_focusOutEvent, METH_O},
    {"forward", (PyCFunction)SbkQGraphicsWebViewFunc_forward, METH_NOARGS},
    {"history", (PyCFunction)SbkQGraphicsWebViewFunc_history, METH_NOARGS},
    {"hoverLeaveEvent", (PyCFunction)SbkQGraphicsWebViewFunc_hoverLeaveEvent, METH_O},
    {"hoverMoveEvent", (PyCFunction)SbkQGraphicsWebViewFunc_hoverMoveEvent, METH_O},
    {"icon", (PyCFunction)SbkQGraphicsWebViewFunc_icon, METH_NOARGS},
    {"inputMethodEvent", (PyCFunction)SbkQGraphicsWebViewFunc_inputMethodEvent, METH_O},
    {"inputMethodQuery", (PyCFunction)SbkQGraphicsWebViewFunc_inputMethodQuery, METH_O},
    {"isModified", (PyCFunction)SbkQGraphicsWebViewFunc_isModified, METH_NOARGS},
    {"itemChange", (PyCFunction)SbkQGraphicsWebViewFunc_itemChange, METH_VARARGS},
    {"keyPressEvent", (PyCFunction)SbkQGraphicsWebViewFunc_keyPressEvent, METH_O},
    {"keyReleaseEvent", (PyCFunction)SbkQGraphicsWebViewFunc_keyReleaseEvent, METH_O},
    {"load", (PyCFunction)SbkQGraphicsWebViewFunc_load, METH_VARARGS},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQGraphicsWebViewFunc_mouseDoubleClickEvent, METH_O},
    {"mouseMoveEvent", (PyCFunction)SbkQGraphicsWebViewFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQGraphicsWebViewFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQGraphicsWebViewFunc_mouseReleaseEvent, METH_O},
    {"page", (PyCFunction)SbkQGraphicsWebViewFunc_page, METH_NOARGS},
    {"pageAction", (PyCFunction)SbkQGraphicsWebViewFunc_pageAction, METH_O},
    {"paint", (PyCFunction)SbkQGraphicsWebViewFunc_paint, METH_VARARGS},
    {"reload", (PyCFunction)SbkQGraphicsWebViewFunc_reload, METH_NOARGS},
    {"sceneEvent", (PyCFunction)SbkQGraphicsWebViewFunc_sceneEvent, METH_O},
    {"setContent", (PyCFunction)SbkQGraphicsWebViewFunc_setContent, METH_VARARGS},
    {"setGeometry", (PyCFunction)SbkQGraphicsWebViewFunc_setGeometry, METH_O},
    {"setHtml", (PyCFunction)SbkQGraphicsWebViewFunc_setHtml, METH_VARARGS},
    {"setPage", (PyCFunction)SbkQGraphicsWebViewFunc_setPage, METH_O},
    {"setUrl", (PyCFunction)SbkQGraphicsWebViewFunc_setUrl, METH_O},
    {"setZoomFactor", (PyCFunction)SbkQGraphicsWebViewFunc_setZoomFactor, METH_O},
    {"settings", (PyCFunction)SbkQGraphicsWebViewFunc_settings, METH_NOARGS},
    {"sizeHint", (PyCFunction)SbkQGraphicsWebViewFunc_sizeHint, METH_VARARGS},
    {"stop", (PyCFunction)SbkQGraphicsWebViewFunc_stop, METH_NOARGS},
    {"title", (PyCFunction)SbkQGraphicsWebViewFunc_title, METH_NOARGS},
    {"triggerPageAction", (PyCFunction)SbkQGraphicsWebViewFunc_triggerPageAction, METH_VARARGS},
    {"updateGeometry", (PyCFunction)SbkQGraphicsWebViewFunc_updateGeometry, METH_NOARGS},
    {"url", (PyCFunction)SbkQGraphicsWebViewFunc_url, METH_NOARGS},
    {"wheelEvent", (PyCFunction)SbkQGraphicsWebViewFunc_wheelEvent, METH_O},
    {"zoomFactor", (PyCFunction)SbkQGraphicsWebViewFunc_zoomFactor, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQGraphicsWebViewSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QGraphicsWebView* me = reinterpret_cast<QGraphicsWebView*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSWIDGET_IDX]))
        return static_cast<QGraphicsWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSOBJECT_IDX]))
        return static_cast<QGraphicsObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_IDX]))
        return static_cast<QGraphicsItem*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]))
        return static_cast<QGraphicsLayoutItem*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsWebView_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QGraphicsWebView",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGraphicsWebViewWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsWebView_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsWebView_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQGraphicsWebViewSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QGraphicsWebView(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QGRAPHICSWEBVIEW_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsWebView_Type);

    SbkQGraphicsWebView_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSWIDGET_IDX];
    SbkQGraphicsWebView_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQGraphicsWebView_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsWebView_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsWebView_Type));
    PyModule_AddObject(module, "QGraphicsWebView",
        ((PyObject*)&SbkQGraphicsWebView_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsWebView >("QGraphicsWebView*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsWebView >(typeid(QGraphicsWebView).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

