/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qttest_python.h"

#include "/usr/include/QtTest/qtest_gui.h"
#include "/usr/include/QtTest/qtesttouch.h"

// Global functions ------------------------------------------------------------
static PyObject*
SbkQtTestModule_pixmapsAreEqual(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "pixmapsAreEqual", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPixmap* >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPixmap* >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPixmap* >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        // pixmapsAreEqual(const QPixmap*,const QPixmap*)
        bool cpp_result = pixmapsAreEqual(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQtTestModule_pixmapsAreEqual_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQtTestModule_pixmapsAreEqual_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPixmap, PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "pixmapsAreEqual", overloads);
        return 0;
}

static PyObject*
SbkQtTestModule_qt_translateRawTouchEvent(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "qt_translateRawTouchEvent", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QTouchEvent::DeviceType >::isConvertible(pyargs[1]) && Shiboken::Converter<QList<QTouchEvent::TouchPoint >  >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        QTouchEvent::DeviceType cpp_arg1 = Shiboken::Converter<QTouchEvent::DeviceType >::toCpp(pyargs[1]);
        QList<QTouchEvent::TouchPoint >  cpp_arg2 = Shiboken::Converter<QList<QTouchEvent::TouchPoint >  >::toCpp(pyargs[2]);
        // qt_translateRawTouchEvent(QWidget*,QTouchEvent::DeviceType,QList<QTouchEvent::TouchPoint>)
        qt_translateRawTouchEvent(cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQtTestModule_qt_translateRawTouchEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtTestModule_qt_translateRawTouchEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtGui.QTouchEvent.DeviceType, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "qt_translateRawTouchEvent", overloads);
        return 0;
}

static PyObject*
SbkQtTestModule_qt_x11_wait_for_window_manager(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // qt_x11_wait_for_window_manager(QWidget*)
        qt_x11_wait_for_window_manager(cpp_arg0);
    } else goto SbkQtTestModule_qt_x11_wait_for_window_manager_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtTestModule_qt_x11_wait_for_window_manager_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "qt_x11_wait_for_window_manager", overloads);
        return 0;
}


static PyMethodDef QtTest_methods[] = {
    {"pixmapsAreEqual", (PyCFunction)SbkQtTestModule_pixmapsAreEqual, METH_VARARGS},
    {"qt_translateRawTouchEvent", (PyCFunction)SbkQtTestModule_qt_translateRawTouchEvent, METH_VARARGS},
    {"qt_x11_wait_for_window_manager", (PyCFunction)SbkQtTestModule_qt_x11_wait_for_window_manager, METH_O},
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_QTest(PyObject* module);

PyTypeObject** SbkPySide_QtTestTypes;

PyTypeObject** SbkPySide_QtGuiTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

extern "C" {

SHIBOKEN_QTTEST_API PyMODINIT_FUNC
initQtTest()
{
    if (!Shiboken::importModule("PySide.QtGui", &SbkPySide_QtGuiTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtGui");
        return;
    }

    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtTest", QtTest_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtTest_IDX_COUNT];
    SbkPySide_QtTestTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system


    // Initialize namespaces as uninstantiable classes in the type system
    init_QTest(module);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtTest");
    }
}

} // extern "C"

