/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTTEST_PYTHON_H
#define SBK_QTTEST_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>

#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTTEST_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTTEST_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTTEST_API
#endif
#endif

// Module Includes
#include <pyside_qtgui_python.h>
#include <pyside_qtcore_python.h>

// Class Includes
#include <qtest_global.h>

// Conversion Includes - Primitive Types
#include <QtConcurrentFilter>
#include <QTextDocument>

// Conversion Includes - Container Types
#include <QMap>
#include <QPair>
#include <QList>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QSet>
#include <QVector>

extern "C"
{

// Type indices
#define                                         SBK_QtTest_IDX_COUNT 0

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtTestTypes;

// Useful macros

} // extern "C"

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T

// Generated converters declarations ----------------------------------


} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_QTTEST_PYTHON_H

