/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtsvg_python.h"

#include "qsvggenerator_wrapper.h"

// Extra includes
#include <qiodevice.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSvgGeneratorWrapper::QSvgGeneratorWrapper() : QSvgGenerator() {
    // ... middle
}

int QSvgGeneratorWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QPaintDevice::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSvgGenerator.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QSvgGeneratorWrapper::metric(QPaintDevice::PaintDeviceMetric metric) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QSvgGenerator::metric(metric);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(metric)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSvgGenerator.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QPaintEngine * QSvgGeneratorWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QSvgGenerator::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSvgGenerator.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QSvgGeneratorWrapper::~QSvgGeneratorWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQSvgGenerator_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSvgGeneratorWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QSvgGenerator()
    cptr = new QSvgGeneratorWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQSvgGeneratorFunc_description(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // description()const
    QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSvgGenerator::description();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgGeneratorFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSvgGenerator::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgGeneratorFunc_metric(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::isConvertible(arg)) {
        QPaintDevice::PaintDeviceMetric cpp_arg0 = Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toCpp(arg);
        // metric(QPaintDevice::PaintDeviceMetric)const
        QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QSvgGenerator::metric(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQSvgGeneratorFunc_metric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSvgGeneratorFunc_metric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice.PaintDeviceMetric", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgGenerator.metric", overloads);
        return 0;
}

static PyObject*
SbkQSvgGeneratorFunc_outputDevice(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // outputDevice()const
    QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QSvgGenerator::outputDevice();
    py_result = Shiboken::Converter<QIODevice* >::toPython(cpp_result);

    // Ownership transferences.

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgGeneratorFunc_paintEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintEngine()const
    QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
    QPaintEngine * cpp_result = cppSelf->QSvgGenerator::paintEngine();
    py_result = Shiboken::Converter<QPaintEngine* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgGeneratorFunc_resolution(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // resolution()const
    QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSvgGenerator::resolution();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgGeneratorFunc_setDescription(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDescription(QString)
        QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
        cppSelf->QSvgGenerator::setDescription(*cpp_arg0);
    } else goto SbkQSvgGeneratorFunc_setDescription_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSvgGeneratorFunc_setDescription_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgGenerator.setDescription", overloads);
        return 0;
}

static PyObject*
SbkQSvgGeneratorFunc_setFileName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFileName(QString)
        QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
        cppSelf->QSvgGenerator::setFileName(*cpp_arg0);
    } else goto SbkQSvgGeneratorFunc_setFileName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSvgGeneratorFunc_setFileName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgGenerator.setFileName", overloads);
        return 0;
}

static PyObject*
SbkQSvgGeneratorFunc_setOutputDevice(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIODevice* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // setOutputDevice(QIODevice*)
        QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
        cppSelf->QSvgGenerator::setOutputDevice(cpp_arg0);
        Shiboken::SbkBaseWrapper_keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "setOutputDevice(QIODevice*)1", arg);
    } else goto SbkQSvgGeneratorFunc_setOutputDevice_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSvgGeneratorFunc_setOutputDevice_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgGenerator.setOutputDevice", overloads);
        return 0;
}

static PyObject*
SbkQSvgGeneratorFunc_setResolution(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setResolution(int)
        QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
        cppSelf->QSvgGenerator::setResolution(cpp_arg0);
    } else goto SbkQSvgGeneratorFunc_setResolution_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSvgGeneratorFunc_setResolution_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgGenerator.setResolution", overloads);
        return 0;
}

static PyObject*
SbkQSvgGeneratorFunc_setSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setSize(QSize)
        QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
        cppSelf->QSvgGenerator::setSize(*cpp_arg0);
    } else goto SbkQSvgGeneratorFunc_setSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSvgGeneratorFunc_setSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgGenerator.setSize", overloads);
        return 0;
}

static PyObject*
SbkQSvgGeneratorFunc_setTitle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setTitle(QString)
        QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
        cppSelf->QSvgGenerator::setTitle(*cpp_arg0);
    } else goto SbkQSvgGeneratorFunc_setTitle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSvgGeneratorFunc_setTitle_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgGenerator.setTitle", overloads);
        return 0;
}

static PyObject*
SbkQSvgGeneratorFunc_setViewBox(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setViewBox(QRect)
        QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
        cppSelf->QSvgGenerator::setViewBox(*cpp_arg0);
    } else if (Shiboken::Converter<QRectF& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!Shiboken::Converter<QRectF& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setViewBox(QRectF)
        QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
        cppSelf->QSvgGenerator::setViewBox(*cpp_arg0);
    } else goto SbkQSvgGeneratorFunc_setViewBox_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSvgGeneratorFunc_setViewBox_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSvg.QSvgGenerator.setViewBox", overloads);
        return 0;
}

static PyObject*
SbkQSvgGeneratorFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QSvgGenerator::size();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgGeneratorFunc_title(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // title()const
    QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSvgGenerator::title();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgGeneratorFunc_viewBox(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewBox()const
    QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QSvgGenerator::viewBox();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSvgGeneratorFunc_viewBoxF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewBoxF()const
    QSvgGenerator* cppSelf = Shiboken::Converter<QSvgGenerator* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QSvgGenerator::viewBoxF();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSvgGenerator_methods[] = {
    {"description", (PyCFunction)SbkQSvgGeneratorFunc_description, METH_NOARGS},
    {"fileName", (PyCFunction)SbkQSvgGeneratorFunc_fileName, METH_NOARGS},
    {"metric", (PyCFunction)SbkQSvgGeneratorFunc_metric, METH_O},
    {"outputDevice", (PyCFunction)SbkQSvgGeneratorFunc_outputDevice, METH_NOARGS},
    {"paintEngine", (PyCFunction)SbkQSvgGeneratorFunc_paintEngine, METH_NOARGS},
    {"resolution", (PyCFunction)SbkQSvgGeneratorFunc_resolution, METH_NOARGS},
    {"setDescription", (PyCFunction)SbkQSvgGeneratorFunc_setDescription, METH_O},
    {"setFileName", (PyCFunction)SbkQSvgGeneratorFunc_setFileName, METH_O},
    {"setOutputDevice", (PyCFunction)SbkQSvgGeneratorFunc_setOutputDevice, METH_O},
    {"setResolution", (PyCFunction)SbkQSvgGeneratorFunc_setResolution, METH_O},
    {"setSize", (PyCFunction)SbkQSvgGeneratorFunc_setSize, METH_O},
    {"setTitle", (PyCFunction)SbkQSvgGeneratorFunc_setTitle, METH_O},
    {"setViewBox", (PyCFunction)SbkQSvgGeneratorFunc_setViewBox, METH_O},
    {"size", (PyCFunction)SbkQSvgGeneratorFunc_size, METH_NOARGS},
    {"title", (PyCFunction)SbkQSvgGeneratorFunc_title, METH_NOARGS},
    {"viewBox", (PyCFunction)SbkQSvgGeneratorFunc_viewBox, METH_NOARGS},
    {"viewBoxF", (PyCFunction)SbkQSvgGeneratorFunc_viewBoxF, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSvgGenerator_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSvg.QSvgGenerator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSvgGeneratorWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSvgGenerator_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSvgGenerator_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QSvgGenerator(PyObject* module)
{
    SbkPySide_QtSvgTypes[SBK_QSVGGENERATOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSvgGenerator_Type);

    SbkQSvgGenerator_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX];
    // Fill type discovery information
    SbkQSvgGenerator_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSvgGenerator_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSvgGenerator_Type));
    PyModule_AddObject(module, "QSvgGenerator",
        ((PyObject*)&SbkQSvgGenerator_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QSvgGenerator >("QSvgGenerator*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSvgGenerator >(typeid(QSvgGenerator).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

