/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtsql_python.h"

#include "qsqlquerymodel_wrapper.h"

// Extra includes
#include <QList>
#include <QMap>
#include <QSize>
#include <QSqlError>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QStringList>
#include <pysideconversions.h>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatastream.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsize.h>
#include <qsqldatabase.h>
#include <qsqlerror.h>
#include <qsqlquery.h>
#include <qsqlrecord.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSqlQueryModelWrapper::QSqlQueryModelWrapper(QObject * parent) : QSqlQueryModel(parent), m_metaObject(0) {
    // ... middle
}

QModelIndex QSqlQueryModelWrapper::buddy(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "buddy"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::buddy(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.buddy");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QSqlQueryModelWrapper::canFetchMore(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canFetchMore"));
    if (py_override.isNull()) {
        return this->QSqlQueryModel::canFetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.canFetchMore");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QSqlQueryModelWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSqlQueryModelWrapper::clear()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "clear"));
    if (py_override.isNull()) {
        return this->QSqlQueryModel::clear();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QSqlQueryModelWrapper::columnCount(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "columnCount"));
    if (py_override.isNull()) {
        return this->QSqlQueryModel::columnCount(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.columnCount");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QSqlQueryModelWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSqlQueryModelWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QSqlQueryModelWrapper::data(const QModelIndex & item, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        return this->QSqlQueryModel::data(item, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oi)",
        Shiboken::Converter<QModelIndex& >::toPython(item),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.data");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QSqlQueryModelWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSqlQueryModelWrapper::dropMimeData(const QMimeData * data, Qt::DropAction action, int row, int column, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropMimeData"));
    if (py_override.isNull()) {
        return this->QAbstractTableModel::dropMimeData(data, action, row, column, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOiiO)",
        Shiboken::Converter<QMimeData* >::toPython(data),
        Shiboken::Converter<Qt::DropAction >::toPython(action),
        row,
        column,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.dropMimeData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlQueryModelWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QSqlQueryModelWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QSqlQueryModelWrapper::fetchMore(const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetchMore"));
    if (py_override.isNull()) {
        return this->QSqlQueryModel::fetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<Qt::ItemFlag> QSqlQueryModelWrapper::flags(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "flags"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::flags(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::ItemFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::ItemFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.flags");
        return QFlags<Qt::ItemFlag>()        ;
    }
    QFlags<Qt::ItemFlag> cpp_result(Shiboken::Converter<QFlags<Qt::ItemFlag> >::toCpp(py_result));
    return cpp_result;
}

QVariant QSqlQueryModelWrapper::headerData(int section, Qt::Orientation orientation, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "headerData"));
    if (py_override.isNull()) {
        return this->QSqlQueryModel::headerData(section, orientation, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iOi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.headerData");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QSqlQueryModelWrapper::index(int row, int column, const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "index"));
    if (py_override.isNull()) {
        return this->QAbstractTableModel::index(row, column, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        column,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.index");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QSqlQueryModelWrapper::insertColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertColumns"));
    if (py_override.isNull()) {
        return this->QSqlQueryModel::insertColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        column,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.insertColumns");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlQueryModelWrapper::insertRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertRows"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::insertRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.insertRows");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QMap<int, QVariant > QSqlQueryModelWrapper::itemData(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::itemData(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QMap<int, QVariant >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMap<int, QVariant > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.itemData");
        return QMap<int, QVariant >()        ;
    }
    QMap<int, QVariant > cpp_result(Shiboken::Converter<QMap<int, QVariant > >::toCpp(py_result));
    return cpp_result;
}

QList<QModelIndex > QSqlQueryModelWrapper::match(const QModelIndex & start, int role, const QVariant & value, int hits, QFlags<Qt::MatchFlag> flags) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "match"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::match(start, role, value, hits, flags);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiOiO)",
        Shiboken::Converter<QModelIndex& >::toPython(start),
        role,
        Shiboken::Converter<QVariant& >::toPython(value),
        hits,
        Shiboken::Converter<QFlags<Qt::MatchFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.match");
        return QList<QModelIndex >()        ;
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

QMimeData * QSqlQueryModelWrapper::mimeData(const QList<QModelIndex > & indexes) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::mimeData(indexes);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QList<QModelIndex >  >::toPython(indexes)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMimeData* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.mimeData");
        return 0        ;
    }
    QMimeData* cpp_result(Shiboken::Converter<QMimeData* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QStringList QSqlQueryModelWrapper::mimeTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeTypes"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::mimeTypes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.mimeTypes");
        return QStringList()        ;
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

void QSqlQueryModelWrapper::queryChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "queryChange"));
    if (py_override.isNull()) {
        return this->QSqlQueryModel::queryChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSqlQueryModelWrapper::removeColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeColumns"));
    if (py_override.isNull()) {
        return this->QSqlQueryModel::removeColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        column,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.removeColumns");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlQueryModelWrapper::removeRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeRows"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::removeRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.removeRows");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QSqlQueryModelWrapper::revert()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "revert"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::revert();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QSqlQueryModelWrapper::rowCount(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowCount"));
    if (py_override.isNull()) {
        return this->QSqlQueryModel::rowCount(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.rowCount");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QSqlQueryModelWrapper::setData(const QModelIndex & index, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::setData(index, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOi)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QVariant& >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.setData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlQueryModelWrapper::setHeaderData(int section, Qt::Orientation orientation, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setHeaderData"));
    if (py_override.isNull()) {
        return this->QSqlQueryModel::setHeaderData(section, orientation, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iOOi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        Shiboken::Converter<QVariant& >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.setHeaderData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlQueryModelWrapper::setItemData(const QModelIndex & index, const QMap<int, QVariant > & roles)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setItemData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::setItemData(index, roles);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QMap<int, QVariant >  >::toPython(roles)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.setItemData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QSqlQueryModelWrapper::sort(int column, Qt::SortOrder order)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sort"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::sort(column, order);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iO)",
        column,
        Shiboken::Converter<Qt::SortOrder >::toPython(order)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QSqlQueryModelWrapper::span(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "span"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::span(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.span");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

bool QSqlQueryModelWrapper::submit()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "submit"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::submit();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.submit");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::DropAction> QSqlQueryModelWrapper::supportedDropActions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedDropActions"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::supportedDropActions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::DropAction>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::DropAction> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlQueryModel.supportedDropActions");
        return QFlags<Qt::DropAction>()        ;
    }
    QFlags<Qt::DropAction> cpp_result(Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(py_result));
    return cpp_result;
}

void QSqlQueryModelWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSqlQueryModelWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QSqlQueryModel::staticMetaObject);
}
    return m_metaObject;
}

int QSqlQueryModelWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QSqlQueryModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSqlQueryModelWrapper::~QSqlQueryModelWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQSqlQueryModel_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSqlQueryModelWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSqlQueryModel", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QSqlQueryModel(QObject*)
        cptr = new QSqlQueryModelWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QSqlQueryModel(QObject*)
        cptr = new QSqlQueryModelWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQSqlQueryModel_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSqlQueryModel_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSqlQueryModel_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlQueryModel", overloads);
        return -1;
}

static PyObject*
SbkQSqlQueryModelFunc_canFetchMore(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // canFetchMore(QModelIndex)const
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlQueryModel::canFetchMore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // canFetchMore(QModelIndex)const
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlQueryModel::canFetchMore(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlQueryModelFunc_canFetchMore_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryModelFunc_canFetchMore_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQueryModel.canFetchMore", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
    cppSelf->QSqlQueryModel::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSqlQueryModelFunc_columnCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // columnCount(QModelIndex)const
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QSqlQueryModel::columnCount();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // columnCount(QModelIndex)const
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QSqlQueryModel::columnCount(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQSqlQueryModelFunc_columnCount_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryModelFunc_columnCount_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQueryModel.columnCount", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_data(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "data", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // data(QModelIndex,int)const
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QSqlQueryModel::data(*cpp_arg0);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // data(QModelIndex,int)const
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QSqlQueryModel::data(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else goto SbkQSqlQueryModelFunc_data_TypeError;
    } else goto SbkQSqlQueryModelFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryModelFunc_data_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int = Qt.DisplayRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlQueryModel.data", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_fetchMore(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // fetchMore(QModelIndex)
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        cppSelf->QSqlQueryModel::fetchMore();
    } else if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // fetchMore(QModelIndex)
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        cppSelf->QSqlQueryModel::fetchMore(*cpp_arg0);
    } else goto SbkQSqlQueryModelFunc_fetchMore_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlQueryModelFunc_fetchMore_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQueryModel.fetchMore", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_headerData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "headerData", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // headerData(int,Qt::Orientation,int)const
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QSqlQueryModel::headerData(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // headerData(int,Qt::Orientation,int)const
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QSqlQueryModel::headerData(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else goto SbkQSqlQueryModelFunc_headerData_TypeError;
    } else goto SbkQSqlQueryModelFunc_headerData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryModelFunc_headerData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Orientation, int = Qt.DisplayRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlQueryModel.headerData", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_indexInQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // indexInQuery(QModelIndex)const
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QSqlQueryModel::indexInQuery(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQSqlQueryModelFunc_indexInQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryModelFunc_indexInQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQueryModel.indexInQuery", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_insertColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertColumns", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // insertColumns(int,int,QModelIndex)
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSqlQueryModel::insertColumns(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // insertColumns(int,int,QModelIndex)
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSqlQueryModel::insertColumns(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQSqlQueryModelFunc_insertColumns_TypeError;
    } else goto SbkQSqlQueryModelFunc_insertColumns_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryModelFunc_insertColumns_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlQueryModel.insertColumns", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_lastError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastError()const
    QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
    QSqlError cpp_result = cppSelf->QSqlQueryModel::lastError();
    py_result = Shiboken::Converter<QSqlError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryModelFunc_query(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // query()const
    QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
    QSqlQuery cpp_result = cppSelf->QSqlQueryModel::query();
    py_result = Shiboken::Converter<QSqlQuery >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryModelFunc_queryChange(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // queryChange()
    QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
    cppSelf->QSqlQueryModel::queryChange();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSqlQueryModelFunc_record(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // record()const
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        QSqlRecord cpp_result = cppSelf->QSqlQueryModel::record();
        py_result = Shiboken::Converter<QSqlRecord >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // record(int)const
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        QSqlRecord cpp_result = cppSelf->QSqlQueryModel::record(cpp_arg0);
        py_result = Shiboken::Converter<QSqlRecord >::toPython(cpp_result);
    } else goto SbkQSqlQueryModelFunc_record_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryModelFunc_record_TypeError:
        const char* overloads[] = {"", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQueryModel.record", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_removeColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "removeColumns", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // removeColumns(int,int,QModelIndex)
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSqlQueryModel::removeColumns(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // removeColumns(int,int,QModelIndex)
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSqlQueryModel::removeColumns(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQSqlQueryModelFunc_removeColumns_TypeError;
    } else goto SbkQSqlQueryModelFunc_removeColumns_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryModelFunc_removeColumns_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlQueryModel.removeColumns", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_rowCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // rowCount(QModelIndex)const
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QSqlQueryModel::rowCount();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // rowCount(QModelIndex)const
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QSqlQueryModel::rowCount(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQSqlQueryModelFunc_rowCount_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryModelFunc_rowCount_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQueryModel.rowCount", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_setHeaderData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setHeaderData", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
        QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
        if (numArgs == 3) {
            // setHeaderData(int,Qt::Orientation,QVariant,int)
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSqlQueryModel::setHeaderData(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // setHeaderData(int,Qt::Orientation,QVariant,int)
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSqlQueryModel::setHeaderData(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQSqlQueryModelFunc_setHeaderData_TypeError;
    } else goto SbkQSqlQueryModelFunc_setHeaderData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryModelFunc_setHeaderData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Orientation, PySide.QtCore.QVariant, int = Qt.EditRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlQueryModel.setHeaderData", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_setLastError(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSqlError& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSqlError* cpp_arg0 = Shiboken::Converter<QSqlError* >::toCpp(arg);
        // setLastError(QSqlError)
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        cppSelf->QSqlQueryModel::setLastError(*cpp_arg0);
    } else goto SbkQSqlQueryModelFunc_setLastError_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlQueryModelFunc_setLastError_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlError", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQueryModel.setLastError", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryModelFunc_setQuery(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setQuery", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setQuery(QString,QSqlDatabase)
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            cppSelf->QSqlQueryModel::setQuery(*cpp_arg0);
        } else if (Shiboken::Converter<QSqlDatabase& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QSqlDatabase* cpp_arg1 = Shiboken::Converter<QSqlDatabase* >::toCpp(pyargs[1]);
            // setQuery(QString,QSqlDatabase)
            QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
            cppSelf->QSqlQueryModel::setQuery(*cpp_arg0, *cpp_arg1);
        } else goto SbkQSqlQueryModelFunc_setQuery_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QSqlQuery& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QSqlQuery > cpp_arg0_auto_ptr;
        QSqlQuery* cpp_arg0 = Shiboken::Converter<QSqlQuery* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QSqlQuery& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QSqlQuery >(cpp_arg0);
        // setQuery(QSqlQuery)
        QSqlQueryModel* cppSelf = Shiboken::Converter<QSqlQueryModel* >::toCpp((PyObject*)self);
        cppSelf->QSqlQueryModel::setQuery(*cpp_arg0);
    } else goto SbkQSqlQueryModelFunc_setQuery_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlQueryModelFunc_setQuery_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlQuery", "PySide.QtCore.QString, PySide.QtSql.QSqlDatabase = QSqlDatabase()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlQueryModel.setQuery", overloads);
        return 0;
}

static PyMethodDef SbkQSqlQueryModel_methods[] = {
    {"canFetchMore", (PyCFunction)SbkQSqlQueryModelFunc_canFetchMore, METH_NOARGS|METH_O},
    {"clear", (PyCFunction)SbkQSqlQueryModelFunc_clear, METH_NOARGS},
    {"columnCount", (PyCFunction)SbkQSqlQueryModelFunc_columnCount, METH_NOARGS|METH_O},
    {"data", (PyCFunction)SbkQSqlQueryModelFunc_data, METH_VARARGS},
    {"fetchMore", (PyCFunction)SbkQSqlQueryModelFunc_fetchMore, METH_NOARGS|METH_O},
    {"headerData", (PyCFunction)SbkQSqlQueryModelFunc_headerData, METH_VARARGS},
    {"indexInQuery", (PyCFunction)SbkQSqlQueryModelFunc_indexInQuery, METH_O},
    {"insertColumns", (PyCFunction)SbkQSqlQueryModelFunc_insertColumns, METH_VARARGS},
    {"lastError", (PyCFunction)SbkQSqlQueryModelFunc_lastError, METH_NOARGS},
    {"query", (PyCFunction)SbkQSqlQueryModelFunc_query, METH_NOARGS},
    {"queryChange", (PyCFunction)SbkQSqlQueryModelFunc_queryChange, METH_NOARGS},
    {"record", (PyCFunction)SbkQSqlQueryModelFunc_record, METH_NOARGS|METH_O},
    {"removeColumns", (PyCFunction)SbkQSqlQueryModelFunc_removeColumns, METH_VARARGS},
    {"rowCount", (PyCFunction)SbkQSqlQueryModelFunc_rowCount, METH_NOARGS|METH_O},
    {"setHeaderData", (PyCFunction)SbkQSqlQueryModelFunc_setHeaderData, METH_VARARGS},
    {"setLastError", (PyCFunction)SbkQSqlQueryModelFunc_setLastError, METH_O},
    {"setQuery", (PyCFunction)SbkQSqlQueryModelFunc_setQuery, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSqlQueryModel_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSql.QSqlQueryModel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSqlQueryModelWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSqlQueryModel_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSqlQueryModel_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QSqlQueryModel(PyObject* module)
{
    SbkPySide_QtSqlTypes[SBK_QSQLQUERYMODEL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSqlQueryModel_Type);

    SbkQSqlQueryModel_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QABSTRACTTABLEMODEL_IDX];
    // Fill type discovery information
    SbkQSqlQueryModel_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSqlQueryModel_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSqlQueryModel_Type));
    PyModule_AddObject(module, "QSqlQueryModel",
        ((PyObject*)&SbkQSqlQueryModel_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QSqlQueryModel >("QSqlQueryModel*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSqlQueryModel >(typeid(QSqlQueryModel).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

