/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtsql_python.h"

#include "qsqlquery_wrapper.h"

// Extra includes
#include <QMap>
#include <QSize>
#include <QSqlError>
#include <QSqlRecord>
#include <QStringList>
#include <qsqldatabase.h>
#include <qsqldriver.h>
#include <qsqlerror.h>
#include <qsqlquery.h>
#include <qsqlrecord.h>
#include <qsqlresult.h>
#include <qstring.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQSqlQuery_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSqlQuery* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QSqlQuery", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QSqlQuery(QString,QSqlDatabase)
        cptr = new QSqlQuery();
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QSqlQuery(QString,QSqlDatabase)
            cptr = new QSqlQuery(*cpp_arg0);
        } else if (Shiboken::Converter<QSqlDatabase >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QSqlDatabase* cpp_arg1 = Shiboken::Converter<QSqlDatabase* >::toCpp(pyargs[1]);
            // QSqlQuery(QString,QSqlDatabase)
            cptr = new QSqlQuery(*cpp_arg0, *cpp_arg1);
        } else goto SbkQSqlQuery_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QSqlResult* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSqlResult* cpp_arg0 = Shiboken::Converter<QSqlResult* >::toCpp(pyargs[0]);
        // QSqlQuery(QSqlResult*)
        cptr = new QSqlQuery(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QSqlQuery& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QSqlQuery > cpp_arg0_auto_ptr;
        QSqlQuery* cpp_arg0 = Shiboken::Converter<QSqlQuery* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QSqlQuery& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QSqlQuery >(cpp_arg0);
        // QSqlQuery(QSqlQuery)
        cptr = new QSqlQuery(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QSqlDatabase >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSqlDatabase* cpp_arg0 = Shiboken::Converter<QSqlDatabase* >::toCpp(pyargs[0]);
        // QSqlQuery(QSqlDatabase)
        cptr = new QSqlQuery(*cpp_arg0);
    } else goto SbkQSqlQuery_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSqlQuery_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSqlQuery_Init_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlDatabase", "PySide.QtSql.QSqlResult", "PySide.QtSql.QSqlQuery", "PySide.QtCore.QString = QString(), PySide.QtSql.QSqlDatabase = QSqlDatabase()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlQuery", overloads);
        return -1;
}

static PyObject*
SbkQSqlQueryFunc_addBindValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addBindValue", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QVariant& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        if (numArgs == 1) {
            // addBindValue(QVariant,QFlags<QSql::ParamTypeFlag>)
            QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
            cppSelf->QSqlQuery::addBindValue(*cpp_arg0);
        } else if (SbkPySide_QtSql_QSql_ParamTypeFlag_Check(pyargs[1])) {
            QFlags<QSql::ParamTypeFlag> cpp_arg1 = Shiboken::Converter<QFlags<QSql::ParamTypeFlag> >::toCpp(pyargs[1]);
            // addBindValue(QVariant,QFlags<QSql::ParamTypeFlag>)
            QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
            cppSelf->QSqlQuery::addBindValue(*cpp_arg0, cpp_arg1);
        } else goto SbkQSqlQueryFunc_addBindValue_TypeError;
    } else goto SbkQSqlQueryFunc_addBindValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlQueryFunc_addBindValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant, PySide.QtSql.QSql.ParamType = QSql.In", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlQuery.addBindValue", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryFunc_at(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // at()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSqlQuery::at();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_bindValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "bindValue", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        if (numArgs == 2) {
            // bindValue(int,QVariant,QFlags<QSql::ParamTypeFlag>)
            QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
            cppSelf->QSqlQuery::bindValue(cpp_arg0, *cpp_arg1);
        } else if (SbkPySide_QtSql_QSql_ParamTypeFlag_Check(pyargs[2])) {
            QFlags<QSql::ParamTypeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QSql::ParamTypeFlag> >::toCpp(pyargs[2]);
            // bindValue(int,QVariant,QFlags<QSql::ParamTypeFlag>)
            QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
            cppSelf->QSqlQuery::bindValue(cpp_arg0, *cpp_arg1, cpp_arg2);
        } else goto SbkQSqlQueryFunc_bindValue_TypeError;
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        if (numArgs == 2) {
            // bindValue(QString,QVariant,QFlags<QSql::ParamTypeFlag>)
            QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
            cppSelf->QSqlQuery::bindValue(*cpp_arg0, *cpp_arg1);
        } else if (SbkPySide_QtSql_QSql_ParamTypeFlag_Check(pyargs[2])) {
            QFlags<QSql::ParamTypeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QSql::ParamTypeFlag> >::toCpp(pyargs[2]);
            // bindValue(QString,QVariant,QFlags<QSql::ParamTypeFlag>)
            QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
            cppSelf->QSqlQuery::bindValue(*cpp_arg0, *cpp_arg1, cpp_arg2);
        } else goto SbkQSqlQueryFunc_bindValue_TypeError;
    } else goto SbkQSqlQueryFunc_bindValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlQueryFunc_bindValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QVariant, PySide.QtSql.QSql.ParamType = QSql.In", "int, PySide.QtCore.QVariant, PySide.QtSql.QSql.ParamType = QSql.In", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlQuery.bindValue", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryFunc_boundValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // boundValue(int)const
        QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QSqlQuery::boundValue(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // boundValue(QString)const
        QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QSqlQuery::boundValue(*cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQSqlQueryFunc_boundValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryFunc_boundValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQuery.boundValue", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryFunc_boundValues(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundValues()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    QMap<QString, QVariant > cpp_result = cppSelf->QSqlQuery::boundValues();
    py_result = Shiboken::Converter<QMap<QString, QVariant > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // clear()
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QSqlQuery::clear();
    thread_state_saver.restore();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSqlQueryFunc_driver(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // driver()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    const QSqlDriver * cpp_result = cppSelf->QSqlQuery::driver();
    py_result = Shiboken::Converter<QSqlDriver* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_execBatch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // execBatch(QSqlQuery::BatchExecutionMode)
        QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlQuery::execBatch();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QSqlQuery::BatchExecutionMode >::isConvertible(arg)) {
        QSqlQuery::BatchExecutionMode cpp_arg0 = Shiboken::Converter<QSqlQuery::BatchExecutionMode >::toCpp(arg);
        // execBatch(QSqlQuery::BatchExecutionMode)
        QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlQuery::execBatch(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlQueryFunc_execBatch_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryFunc_execBatch_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlQuery.BatchExecutionMode = ValuesAsRows", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQuery.execBatch", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryFunc_exec_(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // exec()
        QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSqlQuery::exec();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // exec(QString)
        QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSqlQuery::exec(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlQueryFunc_exec__TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryFunc_exec__TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQuery.exec_", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryFunc_executedQuery(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // executedQuery()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlQuery::executedQuery();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_finish(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // finish()
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    cppSelf->QSqlQuery::finish();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSqlQueryFunc_first(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // first()
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlQuery::first();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_isActive(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isActive()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlQuery::isActive();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_isForwardOnly(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isForwardOnly()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlQuery::isForwardOnly();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_isNull(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isNull(int)const
        QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlQuery::isNull(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlQueryFunc_isNull_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryFunc_isNull_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQuery.isNull", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryFunc_isSelect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSelect()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlQuery::isSelect();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlQuery::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_last(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // last()
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlQuery::last();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_lastError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastError()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    QSqlError cpp_result = cppSelf->QSqlQuery::lastError();
    py_result = Shiboken::Converter<QSqlError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_lastInsertId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastInsertId()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QSqlQuery::lastInsertId();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_lastQuery(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastQuery()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlQuery::lastQuery();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_next(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // next()
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlQuery::next();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_nextResult(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nextResult()
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlQuery::nextResult();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_numRowsAffected(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numRowsAffected()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSqlQuery::numRowsAffected();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_numericalPrecisionPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numericalPrecisionPolicy()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    QSql::NumericalPrecisionPolicy cpp_result = cppSelf->QSqlQuery::numericalPrecisionPolicy();
    py_result = Shiboken::Converter<QSql::NumericalPrecisionPolicy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_prepare(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // prepare(QString)
        QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSqlQuery::prepare(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlQueryFunc_prepare_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryFunc_prepare_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQuery.prepare", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryFunc_previous(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // previous()
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlQuery::previous();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_record(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // record()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    QSqlRecord cpp_result = cppSelf->QSqlQuery::record();
    py_result = Shiboken::Converter<QSqlRecord >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_result(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // result()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    const QSqlResult * cpp_result = cppSelf->QSqlQuery::result();
    py_result = Shiboken::Converter<QSqlResult* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_seek(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "seek", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // seek(int,bool)
            QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QSqlQuery::seek(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // seek(int,bool)
            QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QSqlQuery::seek(cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQSqlQueryFunc_seek_TypeError;
    } else goto SbkQSqlQueryFunc_seek_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryFunc_seek_TypeError:
        const char* overloads[] = {"int, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlQuery.seek", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryFunc_setForwardOnly(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setForwardOnly(bool)
        QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
        cppSelf->QSqlQuery::setForwardOnly(cpp_arg0);
    } else goto SbkQSqlQueryFunc_setForwardOnly_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlQueryFunc_setForwardOnly_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQuery.setForwardOnly", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryFunc_setNumericalPrecisionPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSql::NumericalPrecisionPolicy >::isConvertible(arg)) {
        QSql::NumericalPrecisionPolicy cpp_arg0 = Shiboken::Converter<QSql::NumericalPrecisionPolicy >::toCpp(arg);
        // setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
        QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
        cppSelf->QSqlQuery::setNumericalPrecisionPolicy(cpp_arg0);
    } else goto SbkQSqlQueryFunc_setNumericalPrecisionPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlQueryFunc_setNumericalPrecisionPolicy_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSql.NumericalPrecisionPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQuery.setNumericalPrecisionPolicy", overloads);
        return 0;
}

static PyObject*
SbkQSqlQueryFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSqlQuery::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlQueryFunc_value(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // value(int)const
        QSqlQuery* cppSelf = Shiboken::Converter<QSqlQuery* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QSqlQuery::value(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQSqlQueryFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlQueryFunc_value_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlQuery.value", overloads);
        return 0;
}

static PyMethodDef SbkQSqlQuery_methods[] = {
    {"addBindValue", (PyCFunction)SbkQSqlQueryFunc_addBindValue, METH_VARARGS},
    {"at", (PyCFunction)SbkQSqlQueryFunc_at, METH_NOARGS},
    {"bindValue", (PyCFunction)SbkQSqlQueryFunc_bindValue, METH_VARARGS},
    {"boundValue", (PyCFunction)SbkQSqlQueryFunc_boundValue, METH_O},
    {"boundValues", (PyCFunction)SbkQSqlQueryFunc_boundValues, METH_NOARGS},
    {"clear", (PyCFunction)SbkQSqlQueryFunc_clear, METH_NOARGS},
    {"driver", (PyCFunction)SbkQSqlQueryFunc_driver, METH_NOARGS},
    {"execBatch", (PyCFunction)SbkQSqlQueryFunc_execBatch, METH_NOARGS|METH_O},
    {"exec_", (PyCFunction)SbkQSqlQueryFunc_exec_, METH_NOARGS|METH_O},
    {"executedQuery", (PyCFunction)SbkQSqlQueryFunc_executedQuery, METH_NOARGS},
    {"finish", (PyCFunction)SbkQSqlQueryFunc_finish, METH_NOARGS},
    {"first", (PyCFunction)SbkQSqlQueryFunc_first, METH_NOARGS},
    {"isActive", (PyCFunction)SbkQSqlQueryFunc_isActive, METH_NOARGS},
    {"isForwardOnly", (PyCFunction)SbkQSqlQueryFunc_isForwardOnly, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQSqlQueryFunc_isNull, METH_O},
    {"isSelect", (PyCFunction)SbkQSqlQueryFunc_isSelect, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQSqlQueryFunc_isValid, METH_NOARGS},
    {"last", (PyCFunction)SbkQSqlQueryFunc_last, METH_NOARGS},
    {"lastError", (PyCFunction)SbkQSqlQueryFunc_lastError, METH_NOARGS},
    {"lastInsertId", (PyCFunction)SbkQSqlQueryFunc_lastInsertId, METH_NOARGS},
    {"lastQuery", (PyCFunction)SbkQSqlQueryFunc_lastQuery, METH_NOARGS},
    {"next", (PyCFunction)SbkQSqlQueryFunc_next, METH_NOARGS},
    {"nextResult", (PyCFunction)SbkQSqlQueryFunc_nextResult, METH_NOARGS},
    {"numRowsAffected", (PyCFunction)SbkQSqlQueryFunc_numRowsAffected, METH_NOARGS},
    {"numericalPrecisionPolicy", (PyCFunction)SbkQSqlQueryFunc_numericalPrecisionPolicy, METH_NOARGS},
    {"prepare", (PyCFunction)SbkQSqlQueryFunc_prepare, METH_O},
    {"previous", (PyCFunction)SbkQSqlQueryFunc_previous, METH_NOARGS},
    {"record", (PyCFunction)SbkQSqlQueryFunc_record, METH_NOARGS},
    {"result", (PyCFunction)SbkQSqlQueryFunc_result, METH_NOARGS},
    {"seek", (PyCFunction)SbkQSqlQueryFunc_seek, METH_VARARGS},
    {"setForwardOnly", (PyCFunction)SbkQSqlQueryFunc_setForwardOnly, METH_O},
    {"setNumericalPrecisionPolicy", (PyCFunction)SbkQSqlQueryFunc_setNumericalPrecisionPolicy, METH_O},
    {"size", (PyCFunction)SbkQSqlQueryFunc_size, METH_NOARGS},
    {"value", (PyCFunction)SbkQSqlQueryFunc_value, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSqlQuery_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSql.QSqlQuery",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSqlQuery >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSqlQuery_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSqlQuery_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BatchExecutionMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSqlQuery(PyObject* module)
{
    SbkPySide_QtSqlTypes[SBK_QSQLQUERY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSqlQuery_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSqlQuery_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSqlQuery_Type));
    PyModule_AddObject(module, "QSqlQuery",
        ((PyObject*)&SbkQSqlQuery_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: BatchExecutionMode
    SbkPySide_QtSqlTypes[SBK_QSQLQUERY_BATCHEXECUTIONMODE_IDX] = &SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_Type);
    PyDict_SetItemString(SbkQSqlQuery_Type.super.ht_type.tp_dict,
            "BatchExecutionMode",((PyObject*)&SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_Type,
        (long) QSqlQuery::ValuesAsRows, "ValuesAsRows");
    PyDict_SetItemString(SbkQSqlQuery_Type.super.ht_type.tp_dict,
        "ValuesAsRows", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_Type.tp_dict,
        "ValuesAsRows", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_Type,
        (long) QSqlQuery::ValuesAsColumns, "ValuesAsColumns");
    PyDict_SetItemString(SbkQSqlQuery_Type.super.ht_type.tp_dict,
        "ValuesAsColumns", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlQuery_BatchExecutionMode_Type.tp_dict,
        "ValuesAsColumns", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSqlQuery::BatchExecutionMode");

    Shiboken::TypeResolver::createValueTypeResolver<QSqlQuery >("QSqlQuery");
    Shiboken::TypeResolver::createValueTypeResolver<QSqlQuery >(typeid(QSqlQuery).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

