/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtsql_python.h"

#include "qsqlfield_wrapper.h"

// Extra includes
#include <qsqlfield.h>
#include <qstring.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQSqlField_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSqlField* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QSqlField", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QSqlField(QString,QVariant::Type)
        cptr = new QSqlField();
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QSqlField(QString,QVariant::Type)
            cptr = new QSqlField(*cpp_arg0);
        } else if (Shiboken::Converter<QVariant::Type >::isConvertible(pyargs[1])) {
            QVariant::Type cpp_arg1 = Shiboken::Converter<QVariant::Type >::toCpp(pyargs[1]);
            // QSqlField(QString,QVariant::Type)
            cptr = new QSqlField(*cpp_arg0, cpp_arg1);
        } else goto SbkQSqlField_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QSqlField& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSqlField* cpp_arg0 = Shiboken::Converter<QSqlField* >::toCpp(pyargs[0]);
        // QSqlField(QSqlField)
        cptr = new QSqlField(*cpp_arg0);
    } else goto SbkQSqlField_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSqlField_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSqlField_Init_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlField", "PySide.QtCore.QString = QString(), PySide.QtCore.QVariant.Type = QVariant.Invalid", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlField", overloads);
        return -1;
}

static PyObject*
SbkQSqlFieldFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    cppSelf->QSqlField::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSqlFieldFunc_defaultValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultValue()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QSqlField::defaultValue();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_isAutoValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAutoValue()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlField::isAutoValue();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_isGenerated(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isGenerated()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlField::isGenerated();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlField::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_isReadOnly(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadOnly()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlField::isReadOnly();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlField::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSqlField::length();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlField::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_precision(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // precision()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSqlField::precision();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_requiredStatus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // requiredStatus()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    QSqlField::RequiredStatus cpp_result = cppSelf->QSqlField::requiredStatus();
    py_result = Shiboken::Converter<QSqlField::RequiredStatus >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_setAutoValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoValue(bool)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setAutoValue(cpp_arg0);
    } else goto SbkQSqlFieldFunc_setAutoValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setAutoValue_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setAutoValue", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_setDefaultValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!Shiboken::Converter<QVariant& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // setDefaultValue(QVariant)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setDefaultValue(*cpp_arg0);
    } else goto SbkQSqlFieldFunc_setDefaultValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setDefaultValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setDefaultValue", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_setGenerated(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setGenerated(bool)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setGenerated(cpp_arg0);
    } else goto SbkQSqlFieldFunc_setGenerated_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setGenerated_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setGenerated", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_setLength(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setLength(int)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setLength(cpp_arg0);
    } else goto SbkQSqlFieldFunc_setLength_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setLength_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setLength", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_setName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setName(QString)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setName(*cpp_arg0);
    } else goto SbkQSqlFieldFunc_setName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setName", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_setPrecision(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPrecision(int)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setPrecision(cpp_arg0);
    } else goto SbkQSqlFieldFunc_setPrecision_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setPrecision_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setPrecision", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_setReadOnly(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setReadOnly(bool)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setReadOnly(cpp_arg0);
    } else goto SbkQSqlFieldFunc_setReadOnly_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setReadOnly_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setReadOnly", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_setRequired(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setRequired(bool)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setRequired(cpp_arg0);
    } else goto SbkQSqlFieldFunc_setRequired_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setRequired_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setRequired", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_setRequiredStatus(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSqlField::RequiredStatus >::isConvertible(arg)) {
        QSqlField::RequiredStatus cpp_arg0 = Shiboken::Converter<QSqlField::RequiredStatus >::toCpp(arg);
        // setRequiredStatus(QSqlField::RequiredStatus)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setRequiredStatus(cpp_arg0);
    } else goto SbkQSqlFieldFunc_setRequiredStatus_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setRequiredStatus_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlField.RequiredStatus", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setRequiredStatus", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_setSqlType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSqlType(int)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setSqlType(cpp_arg0);
    } else goto SbkQSqlFieldFunc_setSqlType_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setSqlType_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setSqlType", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_setType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant::Type >::isConvertible(arg)) {
        QVariant::Type cpp_arg0 = Shiboken::Converter<QVariant::Type >::toCpp(arg);
        // setType(QVariant::Type)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setType(cpp_arg0);
    } else goto SbkQSqlFieldFunc_setType_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setType_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant.Type", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setType", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_setValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!Shiboken::Converter<QVariant& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // setValue(QVariant)
        QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
        cppSelf->QSqlField::setValue(*cpp_arg0);
    } else goto SbkQSqlFieldFunc_setValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlFieldFunc_setValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlField.setValue", overloads);
        return 0;
}

static PyObject*
SbkQSqlFieldFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    QVariant::Type cpp_result = cppSelf->QSqlField::type();
    py_result = Shiboken::Converter<QVariant::Type >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_typeID(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // typeID()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSqlField::typeID();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlFieldFunc_value(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // value()const
    QSqlField* cppSelf = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QSqlField::value();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSqlField_methods[] = {
    {"clear", (PyCFunction)SbkQSqlFieldFunc_clear, METH_NOARGS},
    {"defaultValue", (PyCFunction)SbkQSqlFieldFunc_defaultValue, METH_NOARGS},
    {"isAutoValue", (PyCFunction)SbkQSqlFieldFunc_isAutoValue, METH_NOARGS},
    {"isGenerated", (PyCFunction)SbkQSqlFieldFunc_isGenerated, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQSqlFieldFunc_isNull, METH_NOARGS},
    {"isReadOnly", (PyCFunction)SbkQSqlFieldFunc_isReadOnly, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQSqlFieldFunc_isValid, METH_NOARGS},
    {"length", (PyCFunction)SbkQSqlFieldFunc_length, METH_NOARGS},
    {"name", (PyCFunction)SbkQSqlFieldFunc_name, METH_NOARGS},
    {"precision", (PyCFunction)SbkQSqlFieldFunc_precision, METH_NOARGS},
    {"requiredStatus", (PyCFunction)SbkQSqlFieldFunc_requiredStatus, METH_NOARGS},
    {"setAutoValue", (PyCFunction)SbkQSqlFieldFunc_setAutoValue, METH_O},
    {"setDefaultValue", (PyCFunction)SbkQSqlFieldFunc_setDefaultValue, METH_O},
    {"setGenerated", (PyCFunction)SbkQSqlFieldFunc_setGenerated, METH_O},
    {"setLength", (PyCFunction)SbkQSqlFieldFunc_setLength, METH_O},
    {"setName", (PyCFunction)SbkQSqlFieldFunc_setName, METH_O},
    {"setPrecision", (PyCFunction)SbkQSqlFieldFunc_setPrecision, METH_O},
    {"setReadOnly", (PyCFunction)SbkQSqlFieldFunc_setReadOnly, METH_O},
    {"setRequired", (PyCFunction)SbkQSqlFieldFunc_setRequired, METH_O},
    {"setRequiredStatus", (PyCFunction)SbkQSqlFieldFunc_setRequiredStatus, METH_O},
    {"setSqlType", (PyCFunction)SbkQSqlFieldFunc_setSqlType, METH_O},
    {"setType", (PyCFunction)SbkQSqlFieldFunc_setType, METH_O},
    {"setValue", (PyCFunction)SbkQSqlFieldFunc_setValue, METH_O},
    {"type", (PyCFunction)SbkQSqlFieldFunc_type, METH_NOARGS},
    {"typeID", (PyCFunction)SbkQSqlFieldFunc_typeID, METH_NOARGS},
    {"value", (PyCFunction)SbkQSqlFieldFunc_value, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQSqlField_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QSqlField& cpp_self = *Shiboken::Converter<QSqlField* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QSqlField& >::isConvertible(other)) {
                QSqlField* cpp_other = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQSqlField_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QSqlField& >::isConvertible(other)) {
                QSqlField* cpp_other = Shiboken::Converter<QSqlField* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQSqlField_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQSqlField_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSqlField_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSql.QSqlField",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSqlField >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQSqlField_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSqlField_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSqlField_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtSql_QSqlField_RequiredStatus_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSqlField_RequiredStatus_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSqlField_RequiredStatus_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RequiredStatus",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSqlField_RequiredStatus_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSqlField_RequiredStatus_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSqlField_RequiredStatus_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSqlField(PyObject* module)
{
    SbkPySide_QtSqlTypes[SBK_QSQLFIELD_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSqlField_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSqlField_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSqlField_Type));
    PyModule_AddObject(module, "QSqlField",
        ((PyObject*)&SbkQSqlField_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: RequiredStatus
    SbkPySide_QtSqlTypes[SBK_QSQLFIELD_REQUIREDSTATUS_IDX] = &SbkPySide_QtSql_QSqlField_RequiredStatus_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSqlField_RequiredStatus_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSqlField_RequiredStatus_Type);
    PyDict_SetItemString(SbkQSqlField_Type.super.ht_type.tp_dict,
            "RequiredStatus",((PyObject*)&SbkPySide_QtSql_QSqlField_RequiredStatus_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlField_RequiredStatus_Type,
        (long) QSqlField::Unknown, "Unknown");
    PyDict_SetItemString(SbkQSqlField_Type.super.ht_type.tp_dict,
        "Unknown", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlField_RequiredStatus_Type.tp_dict,
        "Unknown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlField_RequiredStatus_Type,
        (long) QSqlField::Optional, "Optional");
    PyDict_SetItemString(SbkQSqlField_Type.super.ht_type.tp_dict,
        "Optional", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlField_RequiredStatus_Type.tp_dict,
        "Optional", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlField_RequiredStatus_Type,
        (long) QSqlField::Required, "Required");
    PyDict_SetItemString(SbkQSqlField_Type.super.ht_type.tp_dict,
        "Required", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlField_RequiredStatus_Type.tp_dict,
        "Required", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSqlField::RequiredStatus");

    Shiboken::TypeResolver::createValueTypeResolver<QSqlField >("QSqlField");
    Shiboken::TypeResolver::createValueTypeResolver<QSqlField >(typeid(QSqlField).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

