/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtopengl_python.h"

#include "qglcontext_wrapper.h"

// Extra includes
#include <qcolor.h>
#include <qgl.h>
#include <qimage.h>
#include <qpaintdevice.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGLContextWrapper::QGLContextWrapper(const QGLFormat & format) : QGLContext(format) {
    // ... middle
}

QGLContextWrapper::QGLContextWrapper(const QGLFormat & format, QPaintDevice * device) : QGLContext(format, device) {
    // ... middle
}

bool QGLContextWrapper::chooseContext(const QGLContext * shareContext)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "chooseContext"));
    if (py_override.isNull()) {
        return this->QGLContext::chooseContext(shareContext);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGLContext* >::toPython(shareContext)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGLContext.chooseContext");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QGLContextWrapper::create(const QGLContext * shareContext)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "create"));
    if (py_override.isNull()) {
        return this->QGLContext::create(shareContext);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGLContext* >::toPython(shareContext)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGLContext.create");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

void QGLContextWrapper::doneCurrent()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "doneCurrent"));
    if (py_override.isNull()) {
        return this->QGLContext::doneCurrent();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLContextWrapper::makeCurrent()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "makeCurrent"));
    if (py_override.isNull()) {
        return this->QGLContext::makeCurrent();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLContextWrapper::swapBuffers() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "swapBuffers"));
    if (py_override.isNull()) {
        return this->QGLContext::swapBuffers();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QGLContextWrapper::~QGLContextWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQGLContext_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGLContextWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QGLContext", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (Shiboken::Converter<QGLFormat& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QGLFormat > cpp_arg0_auto_ptr;
        QGLFormat* cpp_arg0 = Shiboken::Converter<QGLFormat* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QGLFormat& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QGLFormat >(cpp_arg0);
        if (numArgs == 1) {
            // QGLContext(QGLFormat)
            cptr = new QGLContextWrapper(*cpp_arg0);
        } else if (numArgs == 2 && Shiboken::Converter<QPaintDevice* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QPaintDevice* cpp_arg1 = Shiboken::Converter<QPaintDevice* >::toCpp(pyargs[1]);
            // QGLContext(QGLFormat,QPaintDevice*)
            cptr = new QGLContextWrapper(*cpp_arg0, cpp_arg1);
        } else goto SbkQGLContext_Init_TypeError;
    } else goto SbkQGLContext_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGLContext_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGLContext_Init_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLFormat", "PySide.QtOpenGL.QGLFormat, PySide.QtGui.QPaintDevice", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLContext", overloads);
        return -1;
}

static PyObject*
SbkQGLContextFunc_areSharing(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "areSharing", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QGLContext* >::isConvertible(pyargs[0]) && Shiboken::Converter<QGLContext* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGLContext* cpp_arg0 = Shiboken::Converter<QGLContext* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QGLContext* cpp_arg1 = Shiboken::Converter<QGLContext* >::toCpp(pyargs[1]);
        // areSharing(const QGLContext*,const QGLContext*)
        bool cpp_result = QGLContext::areSharing(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGLContextFunc_areSharing_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGLContextFunc_areSharing_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLContext, PySide.QtOpenGL.QGLContext", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLContext.areSharing", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_bindTexture(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "bindTexture", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // bindTexture(QString)
        QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
        unsigned int cpp_result = cppSelf->QGLContext::bindTexture(*cpp_arg0);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        if (numArgs == 1) {
            // bindTexture(QPixmap,uint,int)
            QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
            unsigned int cpp_result = cppSelf->QGLContext::bindTexture(*cpp_arg0);
            py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // bindTexture(QPixmap,uint,int)
                QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
                unsigned int cpp_result = cppSelf->QGLContext::bindTexture(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // bindTexture(QPixmap,uint,int)
                QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
                unsigned int cpp_result = cppSelf->QGLContext::bindTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
            } else goto SbkQGLContextFunc_bindTexture_TypeError;
        } else goto SbkQGLContextFunc_bindTexture_TypeError;
    } else if (Shiboken::Converter<QImage& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // bindTexture(QImage,uint,int)
            QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
            unsigned int cpp_result = cppSelf->QGLContext::bindTexture(*cpp_arg0);
            py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // bindTexture(QImage,uint,int)
                QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
                unsigned int cpp_result = cppSelf->QGLContext::bindTexture(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // bindTexture(QImage,uint,int)
                QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
                unsigned int cpp_result = cppSelf->QGLContext::bindTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
            } else goto SbkQGLContextFunc_bindTexture_TypeError;
        } else goto SbkQGLContextFunc_bindTexture_TypeError;
    } else goto SbkQGLContextFunc_bindTexture_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGLContextFunc_bindTexture_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage, unsigned int = 0x0DE1, int = 0x1908", "PySide.QtGui.QPixmap, unsigned int = 0x0DE1, int = 0x1908", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLContext.bindTexture", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_chooseContext(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // chooseContext(const QGLContext*)
        QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGLContext::chooseContext();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QGLContext* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGLContext* cpp_arg0 = Shiboken::Converter<QGLContext* >::toCpp(arg);
        // chooseContext(const QGLContext*)
        QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGLContext::chooseContext(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGLContextFunc_chooseContext_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGLContextFunc_chooseContext_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLContext = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLContext.chooseContext", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_colorIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QColor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!Shiboken::Converter<QColor& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // colorIndex(QColor)const
        QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
        uint cpp_result = cppSelf->QGLContext::colorIndex(*cpp_arg0);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    } else goto SbkQGLContextFunc_colorIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGLContextFunc_colorIndex_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLContext.colorIndex", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_create(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // create(const QGLContext*)
        QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGLContext::create();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QGLContext* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGLContext* cpp_arg0 = Shiboken::Converter<QGLContext* >::toCpp(arg);
        // create(const QGLContext*)
        QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGLContext::create(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGLContextFunc_create_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGLContextFunc_create_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLContext = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLContext.create", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_currentContext(PyObject* self)
{
    PyObject* py_result = 0;

    // currentContext()
    const QGLContext * cpp_result = QGLContext::currentContext();
    py_result = Shiboken::Converter<QGLContext* >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLContextFunc_deleteTexture(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // deleteTexture(uint)
        QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
        cppSelf->QGLContext::deleteTexture(cpp_arg0);
    } else goto SbkQGLContextFunc_deleteTexture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLContextFunc_deleteTexture_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLContext.deleteTexture", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_device(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // device()const
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    QPaintDevice * cpp_result = cppSelf->QGLContext::device();
    py_result = Shiboken::Converter<QPaintDevice* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLContextFunc_deviceIsPixmap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // deviceIsPixmap()const
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLContext::deviceIsPixmap();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLContextFunc_doneCurrent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // doneCurrent()
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    cppSelf->QGLContext::doneCurrent();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGLContextFunc_drawTexture(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawTexture", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawTexture(QRectF,uint,uint)
            QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
            cppSelf->QGLContext::drawTexture(*cpp_arg0, cpp_arg1);
        } else if (PyNumber_Check(pyargs[2])) {
            unsigned int cpp_arg2 = Shiboken::Converter<unsigned int >::toCpp(pyargs[2]);
            // drawTexture(QRectF,uint,uint)
            QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
            cppSelf->QGLContext::drawTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQGLContextFunc_drawTexture_TypeError;
    } else if (Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawTexture(QPointF,uint,uint)
            QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
            cppSelf->QGLContext::drawTexture(*cpp_arg0, cpp_arg1);
        } else if (PyNumber_Check(pyargs[2])) {
            unsigned int cpp_arg2 = Shiboken::Converter<unsigned int >::toCpp(pyargs[2]);
            // drawTexture(QPointF,uint,uint)
            QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
            cppSelf->QGLContext::drawTexture(*cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQGLContextFunc_drawTexture_TypeError;
    } else goto SbkQGLContextFunc_drawTexture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLContextFunc_drawTexture_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, unsigned int, unsigned int = 0x0DE1", "PySide.QtCore.QRectF, unsigned int, unsigned int = 0x0DE1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLContext.drawTexture", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_format(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // format()const
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    QGLFormat cpp_result = cppSelf->QGLContext::format();
    py_result = Shiboken::Converter<QGLFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLContextFunc_initialized(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // initialized()const
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLContext::initialized();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLContextFunc_isSharing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSharing()const
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLContext::isSharing();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLContextFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLContext::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLContextFunc_makeCurrent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // makeCurrent()
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    cppSelf->QGLContext::makeCurrent();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGLContextFunc_overlayTransparentColor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // overlayTransparentColor()const
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QGLContext::overlayTransparentColor();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLContextFunc_requestedFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // requestedFormat()const
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    QGLFormat cpp_result = cppSelf->QGLContext::requestedFormat();
    py_result = Shiboken::Converter<QGLFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLContextFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    cppSelf->QGLContext::reset();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGLContextFunc_setFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGLFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QGLFormat > cpp_arg0_auto_ptr;
        QGLFormat* cpp_arg0 = Shiboken::Converter<QGLFormat* >::toCpp(arg);
        if (!Shiboken::Converter<QGLFormat& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QGLFormat >(cpp_arg0);
        // setFormat(QGLFormat)
        QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
        cppSelf->QGLContext::setFormat(*cpp_arg0);
    } else goto SbkQGLContextFunc_setFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLContextFunc_setFormat_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLContext.setFormat", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_setInitialized(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setInitialized(bool)
        QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
        cppSelf->QGLContext::setInitialized(cpp_arg0);
    } else goto SbkQGLContextFunc_setInitialized_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLContextFunc_setInitialized_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLContext.setInitialized", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_setTextureCacheLimit(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setTextureCacheLimit(int)
        QGLContext::setTextureCacheLimit(cpp_arg0);
    } else goto SbkQGLContextFunc_setTextureCacheLimit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLContextFunc_setTextureCacheLimit_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLContext.setTextureCacheLimit", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_setValid(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setValid(bool)
        QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
        cppSelf->QGLContext::setValid(cpp_arg0);
    } else goto SbkQGLContextFunc_setValid_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLContextFunc_setValid_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLContext.setValid", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_setWindowCreated(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setWindowCreated(bool)
        QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
        cppSelf->QGLContext::setWindowCreated(cpp_arg0);
    } else goto SbkQGLContextFunc_setWindowCreated_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLContextFunc_setWindowCreated_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLContext.setWindowCreated", overloads);
        return 0;
}

static PyObject*
SbkQGLContextFunc_swapBuffers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // swapBuffers()const
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    cppSelf->QGLContext::swapBuffers();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGLContextFunc_textureCacheLimit(PyObject* self)
{
    PyObject* py_result = 0;

    // textureCacheLimit()
    int cpp_result = QGLContext::textureCacheLimit();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGLContextFunc_windowCreated(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowCreated()const
    QGLContext* cppSelf = Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLContext::windowCreated();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQGLContext_methods[] = {
    {"areSharing", (PyCFunction)SbkQGLContextFunc_areSharing, METH_VARARGS|METH_STATIC},
    {"bindTexture", (PyCFunction)SbkQGLContextFunc_bindTexture, METH_VARARGS},
    {"chooseContext", (PyCFunction)SbkQGLContextFunc_chooseContext, METH_NOARGS|METH_O},
    {"colorIndex", (PyCFunction)SbkQGLContextFunc_colorIndex, METH_O},
    {"create", (PyCFunction)SbkQGLContextFunc_create, METH_NOARGS|METH_O},
    {"currentContext", (PyCFunction)SbkQGLContextFunc_currentContext, METH_NOARGS|METH_STATIC},
    {"deleteTexture", (PyCFunction)SbkQGLContextFunc_deleteTexture, METH_O},
    {"device", (PyCFunction)SbkQGLContextFunc_device, METH_NOARGS},
    {"deviceIsPixmap", (PyCFunction)SbkQGLContextFunc_deviceIsPixmap, METH_NOARGS},
    {"doneCurrent", (PyCFunction)SbkQGLContextFunc_doneCurrent, METH_NOARGS},
    {"drawTexture", (PyCFunction)SbkQGLContextFunc_drawTexture, METH_VARARGS},
    {"format", (PyCFunction)SbkQGLContextFunc_format, METH_NOARGS},
    {"initialized", (PyCFunction)SbkQGLContextFunc_initialized, METH_NOARGS},
    {"isSharing", (PyCFunction)SbkQGLContextFunc_isSharing, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQGLContextFunc_isValid, METH_NOARGS},
    {"makeCurrent", (PyCFunction)SbkQGLContextFunc_makeCurrent, METH_NOARGS},
    {"overlayTransparentColor", (PyCFunction)SbkQGLContextFunc_overlayTransparentColor, METH_NOARGS},
    {"requestedFormat", (PyCFunction)SbkQGLContextFunc_requestedFormat, METH_NOARGS},
    {"reset", (PyCFunction)SbkQGLContextFunc_reset, METH_NOARGS},
    {"setFormat", (PyCFunction)SbkQGLContextFunc_setFormat, METH_O},
    {"setInitialized", (PyCFunction)SbkQGLContextFunc_setInitialized, METH_O},
    {"setTextureCacheLimit", (PyCFunction)SbkQGLContextFunc_setTextureCacheLimit, METH_O|METH_STATIC},
    {"setValid", (PyCFunction)SbkQGLContextFunc_setValid, METH_O},
    {"setWindowCreated", (PyCFunction)SbkQGLContextFunc_setWindowCreated, METH_O},
    {"swapBuffers", (PyCFunction)SbkQGLContextFunc_swapBuffers, METH_NOARGS},
    {"textureCacheLimit", (PyCFunction)SbkQGLContextFunc_textureCacheLimit, METH_NOARGS|METH_STATIC},
    {"windowCreated", (PyCFunction)SbkQGLContextFunc_windowCreated, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQGLContext_get_currentCtx(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QGLContext* >::toPython(Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self)->currentCtx);
}
static int SbkQGLContext_set_currentCtx(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'currentCtx' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QGLContext* >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'currentCtx', 'QGLContext' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QGLContext* >::toCpp((PyObject*)self)->currentCtx = Shiboken::Converter<QGLContext* >::toCpp(value);

    Shiboken::SbkBaseWrapper_keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "currentCtx", value);

    return 0;
}

// Getters and Setters for QGLContext
static PyGetSetDef SbkQGLContext_getsetlist[] = {
    {const_cast<char*>("currentCtx"), (getter)SbkQGLContext_get_currentCtx, (setter)SbkQGLContext_set_currentCtx},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGLContext_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtOpenGL.QGLContext",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGLContextWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGLContext_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQGLContext_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGLContext_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQGLContext_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQGLContext_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QGLContext*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QGLContext(PyObject* module)
{
    SbkPySide_QtOpenGLTypes[SBK_QGLCONTEXT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGLContext_Type);

    // Fill type discovery information
    SbkQGLContext_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQGLContext_Type.type_discovery->addTypeDiscoveryFunction(&SbkQGLContext_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQGLContext_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGLContext_Type));
    PyModule_AddObject(module, "QGLContext",
        ((PyObject*)&SbkQGLContext_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGLContext >("QGLContext*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGLContext >(typeid(QGLContext).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

