/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qtnetwork_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef QtNetwork_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_QSsl(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAuthenticator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHttpHeader(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSslConfiguration(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QIPv6Address(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QNetworkAccessManager(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QNetworkCookieJar(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLocalServer(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QNetworkCookie(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractSocket(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QUdpSocket(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QNetworkReply(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSslKey(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHostAddress(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTcpServer(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QNetworkRequest(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QLocalSocket(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QTcpSocket(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSslSocket(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSslCipher(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QNetworkInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHostInfo(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QNetworkAddressEntry(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSslError(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHttpRequestHeader(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QUrlInfo(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QNetworkProxy(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHttp(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QHttpResponseHeader(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QFtp(PyObject* module);

PyTypeObject** SbkPySide_QtNetworkTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

extern "C" {

SHIBOKEN_QTNETWORK_API PyMODINIT_FUNC
initQtNetwork()
{
    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtNetwork", QtNetwork_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtNetwork_IDX_COUNT];
    SbkPySide_QtNetworkTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QAuthenticator(module);
    init_QHttpHeader(module);
    init_QSslConfiguration(module);
    init_QIPv6Address(module);
    init_QNetworkAccessManager(module);
    init_QNetworkCookieJar(module);
    init_QLocalServer(module);
    init_QNetworkCookie(module);
    init_QAbstractSocket(module);
    init_QUdpSocket(module);
    init_QNetworkReply(module);
    init_QSslKey(module);
    init_QHostAddress(module);
    init_QTcpServer(module);
    init_QNetworkRequest(module);
    init_QLocalSocket(module);
    init_QTcpSocket(module);
    init_QSslSocket(module);
    init_QSslCipher(module);
    init_QNetworkInterface(module);
    init_QHostInfo(module);
    init_QNetworkAddressEntry(module);
    init_QSslError(module);
    init_QHttpRequestHeader(module);
    init_QUrlInfo(module);
    init_QNetworkProxy(module);
    init_QHttp(module);
    init_QHttpResponseHeader(module);
    init_QFtp(module);


    // Initialize namespaces as uninstantiable classes in the type system
    init_QSsl(module);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtNetwork");
    }
}

} // extern "C"

