/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qsslcipher_wrapper.h"

// Extra includes
#include <qsslcipher.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQSslCipher_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSslCipher* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QSslCipher", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QSslCipher()
        cptr = new QSslCipher();
    } else if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QSsl::SslProtocol >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QSsl::SslProtocol cpp_arg1 = Shiboken::Converter<QSsl::SslProtocol >::toCpp(pyargs[1]);
        // QSslCipher(QString,QSsl::SslProtocol)
        cptr = new QSslCipher(*cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QSslCipher& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSslCipher* cpp_arg0 = Shiboken::Converter<QSslCipher* >::toCpp(pyargs[0]);
        // QSslCipher(QSslCipher)
        cptr = new QSslCipher(*cpp_arg0);
    } else goto SbkQSslCipher_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSslCipher_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSslCipher_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtNetwork.QSslCipher", "PySide.QtCore.QString, PySide.QtNetwork.QSsl.SslProtocol", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QSslCipher", overloads);
        return -1;
}

static PyObject*
SbkQSslCipherFunc_authenticationMethod(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // authenticationMethod()const
    QSslCipher* cppSelf = Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSslCipher::authenticationMethod();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslCipherFunc_encryptionMethod(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // encryptionMethod()const
    QSslCipher* cppSelf = Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSslCipher::encryptionMethod();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslCipherFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QSslCipher* cppSelf = Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSslCipher::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslCipherFunc_keyExchangeMethod(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // keyExchangeMethod()const
    QSslCipher* cppSelf = Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSslCipher::keyExchangeMethod();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslCipherFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QSslCipher* cppSelf = Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSslCipher::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslCipherFunc_protocol(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // protocol()const
    QSslCipher* cppSelf = Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)self);
    QSsl::SslProtocol cpp_result = cppSelf->QSslCipher::protocol();
    py_result = Shiboken::Converter<QSsl::SslProtocol >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslCipherFunc_protocolString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // protocolString()const
    QSslCipher* cppSelf = Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSslCipher::protocolString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslCipherFunc_supportedBits(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedBits()const
    QSslCipher* cppSelf = Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSslCipher::supportedBits();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSslCipherFunc_usedBits(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // usedBits()const
    QSslCipher* cppSelf = Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSslCipher::usedBits();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSslCipher_methods[] = {
    {"authenticationMethod", (PyCFunction)SbkQSslCipherFunc_authenticationMethod, METH_NOARGS},
    {"encryptionMethod", (PyCFunction)SbkQSslCipherFunc_encryptionMethod, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQSslCipherFunc_isNull, METH_NOARGS},
    {"keyExchangeMethod", (PyCFunction)SbkQSslCipherFunc_keyExchangeMethod, METH_NOARGS},
    {"name", (PyCFunction)SbkQSslCipherFunc_name, METH_NOARGS},
    {"protocol", (PyCFunction)SbkQSslCipherFunc_protocol, METH_NOARGS},
    {"protocolString", (PyCFunction)SbkQSslCipherFunc_protocolString, METH_NOARGS},
    {"supportedBits", (PyCFunction)SbkQSslCipherFunc_supportedBits, METH_NOARGS},
    {"usedBits", (PyCFunction)SbkQSslCipherFunc_usedBits, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQSslCipher_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QSslCipher& cpp_self = *Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QSslCipher& >::isConvertible(other)) {
                QSslCipher* cpp_other = Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQSslCipher_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QSslCipher& >::isConvertible(other)) {
                QSslCipher* cpp_other = Shiboken::Converter<QSslCipher* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQSslCipher_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQSslCipher_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSslCipher_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QSslCipher",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSslCipher >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQSslCipher_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSslCipher_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSslCipher_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QSslCipher(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QSSLCIPHER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSslCipher_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSslCipher_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSslCipher_Type));
    PyModule_AddObject(module, "QSslCipher",
        ((PyObject*)&SbkQSslCipher_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QSslCipher >("QSslCipher");
    Shiboken::TypeResolver::createValueTypeResolver<QSslCipher >(typeid(QSslCipher).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

