/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qssl_wrapper.h"

// Extra includes
#include <qssl.h>

using namespace Shiboken;

static PyMethodDef SbkQSsl_methods[] = {
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSsl_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QSsl",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSsl_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtNetwork_QSsl_KeyType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QSsl_KeyType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QSsl_KeyType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "KeyType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QSsl_KeyType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QSsl_KeyType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QSsl_KeyType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QSsl_KeyAlgorithm_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QSsl_KeyAlgorithm_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QSsl_KeyAlgorithm_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "KeyAlgorithm",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QSsl_KeyAlgorithm_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QSsl_KeyAlgorithm_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QSsl_KeyAlgorithm_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QSsl_SslProtocol_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QSsl_SslProtocol_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QSsl_SslProtocol_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SslProtocol",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QSsl_SslProtocol_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QSsl_SslProtocol_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QSsl_SslProtocol_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AlternateNameEntryType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QSsl_EncodingFormat_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QSsl_EncodingFormat_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QSsl_EncodingFormat_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "EncodingFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QSsl_EncodingFormat_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QSsl_EncodingFormat_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QSsl_EncodingFormat_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSsl(PyObject* module)
{
    if (PyType_Ready((PyTypeObject*)&SbkQSsl_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSsl_Type));
    PyModule_AddObject(module, "QSsl",
        ((PyObject*)&SbkQSsl_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: KeyType
    SbkPySide_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX] = &SbkPySide_QtNetwork_QSsl_KeyType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QSsl_KeyType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QSsl_KeyType_Type);
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
            "KeyType",((PyObject*)&SbkPySide_QtNetwork_QSsl_KeyType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_KeyType_Type,
        (long) QSsl::PrivateKey, "PrivateKey");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "PrivateKey", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_KeyType_Type.tp_dict,
        "PrivateKey", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_KeyType_Type,
        (long) QSsl::PublicKey, "PublicKey");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "PublicKey", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_KeyType_Type.tp_dict,
        "PublicKey", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSsl::KeyType");

    // init enum class: KeyAlgorithm
    SbkPySide_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX] = &SbkPySide_QtNetwork_QSsl_KeyAlgorithm_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QSsl_KeyAlgorithm_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QSsl_KeyAlgorithm_Type);
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
            "KeyAlgorithm",((PyObject*)&SbkPySide_QtNetwork_QSsl_KeyAlgorithm_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_KeyAlgorithm_Type,
        (long) QSsl::Rsa, "Rsa");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "Rsa", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_KeyAlgorithm_Type.tp_dict,
        "Rsa", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_KeyAlgorithm_Type,
        (long) QSsl::Dsa, "Dsa");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "Dsa", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_KeyAlgorithm_Type.tp_dict,
        "Dsa", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSsl::KeyAlgorithm");

    // init enum class: SslProtocol
    SbkPySide_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX] = &SbkPySide_QtNetwork_QSsl_SslProtocol_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QSsl_SslProtocol_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QSsl_SslProtocol_Type);
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
            "SslProtocol",((PyObject*)&SbkPySide_QtNetwork_QSsl_SslProtocol_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_SslProtocol_Type,
        (long) QSsl::SslV3, "SslV3");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "SslV3", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_SslProtocol_Type.tp_dict,
        "SslV3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_SslProtocol_Type,
        (long) QSsl::SslV2, "SslV2");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "SslV2", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_SslProtocol_Type.tp_dict,
        "SslV2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_SslProtocol_Type,
        (long) QSsl::TlsV1, "TlsV1");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "TlsV1", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_SslProtocol_Type.tp_dict,
        "TlsV1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_SslProtocol_Type,
        (long) QSsl::AnyProtocol, "AnyProtocol");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "AnyProtocol", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_SslProtocol_Type.tp_dict,
        "AnyProtocol", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_SslProtocol_Type,
        (long) QSsl::UnknownProtocol, "UnknownProtocol");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "UnknownProtocol", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_SslProtocol_Type.tp_dict,
        "UnknownProtocol", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSsl::SslProtocol");

    // init enum class: AlternateNameEntryType
    SbkPySide_QtNetworkTypes[SBK_QSSL_ALTERNATENAMEENTRYTYPE_IDX] = &SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_Type);
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
            "AlternateNameEntryType",((PyObject*)&SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_Type,
        (long) QSsl::EmailEntry, "EmailEntry");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "EmailEntry", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_Type.tp_dict,
        "EmailEntry", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_Type,
        (long) QSsl::DnsEntry, "DnsEntry");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "DnsEntry", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_Type.tp_dict,
        "DnsEntry", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSsl::AlternateNameEntryType");

    // init enum class: EncodingFormat
    SbkPySide_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX] = &SbkPySide_QtNetwork_QSsl_EncodingFormat_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QSsl_EncodingFormat_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QSsl_EncodingFormat_Type);
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
            "EncodingFormat",((PyObject*)&SbkPySide_QtNetwork_QSsl_EncodingFormat_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_EncodingFormat_Type,
        (long) QSsl::Pem, "Pem");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "Pem", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_EncodingFormat_Type.tp_dict,
        "Pem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QSsl_EncodingFormat_Type,
        (long) QSsl::Der, "Der");
    PyDict_SetItemString(SbkQSsl_Type.super.ht_type.tp_dict,
        "Der", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QSsl_EncodingFormat_Type.tp_dict,
        "Der", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSsl::EncodingFormat");

}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

