/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtnetwork_python.h"

#include "qlocalsocket_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qlocalsocket.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QLocalSocketWrapper::QLocalSocketWrapper(QObject * parent) : QLocalSocket(parent), m_metaObject(0) {
    // ... middle
}

bool QLocalSocketWrapper::atEnd() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "atEnd"));
    if (py_override.isNull()) {
        return this->QIODevice::atEnd();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.atEnd");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QLocalSocketWrapper::bytesAvailable() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesAvailable"));
    if (py_override.isNull()) {
        return this->QLocalSocket::bytesAvailable();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.bytesAvailable");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QLocalSocketWrapper::bytesToWrite() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesToWrite"));
    if (py_override.isNull()) {
        return this->QLocalSocket::bytesToWrite();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.bytesToWrite");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QLocalSocketWrapper::canReadLine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canReadLine"));
    if (py_override.isNull()) {
        return this->QLocalSocket::canReadLine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.canReadLine");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QLocalSocketWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QLocalSocketWrapper::close()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "close"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QLocalSocket::close();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLocalSocketWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLocalSocketWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QLocalSocketWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QLocalSocketWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QLocalSocketWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QLocalSocketWrapper::isSequential() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isSequential"));
    if (py_override.isNull()) {
        return this->QLocalSocket::isSequential();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.isSequential");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QLocalSocketWrapper::open(QFlags<QIODevice::OpenModeFlag> mode)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "open"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::open(mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.open");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QLocalSocketWrapper::pos() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pos"));
    if (py_override.isNull()) {
        return this->QIODevice::pos();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.pos");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QLocalSocketWrapper::readData(char * arg__1, qint64 arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readData"));
    if (py_override.isNull()) {
        return this->QLocalSocket::readData(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        arg__1,
        Shiboken::Converter<long long >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.readData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QLocalSocketWrapper::readLineData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readLineData"));
    if (py_override.isNull()) {
        return this->QIODevice::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.readLineData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QLocalSocketWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QIODevice::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.reset");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QLocalSocketWrapper::seek(qint64 pos)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "seek"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::seek(pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.seek");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QLocalSocketWrapper::size() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "size"));
    if (py_override.isNull()) {
        return this->QIODevice::size();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.size");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

void QLocalSocketWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QLocalSocketWrapper::waitForBytesWritten(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForBytesWritten"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QLocalSocket::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.waitForBytesWritten");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QLocalSocketWrapper::waitForReadyRead(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForReadyRead"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QLocalSocket::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.waitForReadyRead");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QLocalSocketWrapper::writeData(const char * arg__1, qint64 arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "writeData"));
    if (py_override.isNull()) {
        return this->QLocalSocket::writeData(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        arg__1,
        Shiboken::Converter<long long >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLocalSocket.writeData");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QLocalSocketWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QLocalSocket::staticMetaObject);
}
    return m_metaObject;
}

int QLocalSocketWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QLocalSocket::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QLocalSocketWrapper::~QLocalSocketWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQLocalSocket_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QLocalSocketWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QLocalSocket", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QLocalSocket(QObject*)
        cptr = new QLocalSocketWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QLocalSocket(QObject*)
        cptr = new QLocalSocketWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQLocalSocket_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQLocalSocket_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQLocalSocket_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QLocalSocket", overloads);
        return -1;
}

static PyObject*
SbkQLocalSocketFunc_abort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // abort()
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    cppSelf->QLocalSocket::abort();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQLocalSocketFunc_bytesAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesAvailable()const
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QLocalSocket::bytesAvailable();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLocalSocketFunc_bytesToWrite(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesToWrite()const
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QLocalSocket::bytesToWrite();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLocalSocketFunc_canReadLine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canReadLine()const
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLocalSocket::canReadLine();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLocalSocketFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // close()
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QLocalSocket::close();
    thread_state_saver.restore();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQLocalSocketFunc_connectToServer(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "connectToServer", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // connectToServer(QString,QFlags<QIODevice::OpenModeFlag>)
            QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
            cppSelf->QLocalSocket::connectToServer(*cpp_arg0);
        } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[1])) {
            QFlags<QIODevice::OpenModeFlag> cpp_arg1 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[1]);
            // connectToServer(QString,QFlags<QIODevice::OpenModeFlag>)
            QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
            cppSelf->QLocalSocket::connectToServer(*cpp_arg0, cpp_arg1);
        } else goto SbkQLocalSocketFunc_connectToServer_TypeError;
    } else goto SbkQLocalSocketFunc_connectToServer_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLocalSocketFunc_connectToServer_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QLocalSocket.connectToServer", overloads);
        return 0;
}

static PyObject*
SbkQLocalSocketFunc_disconnectFromServer(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // disconnectFromServer()
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    cppSelf->QLocalSocket::disconnectFromServer();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQLocalSocketFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    QLocalSocket::LocalSocketError cpp_result = cppSelf->QLocalSocket::error();
    py_result = Shiboken::Converter<QLocalSocket::LocalSocketError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLocalSocketFunc_flush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // flush()
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLocalSocket::flush();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLocalSocketFunc_fullServerName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fullServerName()const
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QLocalSocket::fullServerName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLocalSocketFunc_isSequential(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSequential()const
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLocalSocket::isSequential();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLocalSocketFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLocalSocket::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLocalSocketFunc_readBufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readBufferSize()const
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QLocalSocket::readBufferSize();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLocalSocketFunc_readData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "readData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // readData(char*,qint64)
        QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QLocalSocket::readData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQLocalSocketFunc_readData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQLocalSocketFunc_readData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QLocalSocket.readData", overloads);
        return 0;
}

static PyObject*
SbkQLocalSocketFunc_serverName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // serverName()const
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QLocalSocket::serverName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLocalSocketFunc_setReadBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setReadBufferSize(qint64)
        QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
        cppSelf->QLocalSocket::setReadBufferSize(cpp_arg0);
    } else goto SbkQLocalSocketFunc_setReadBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLocalSocketFunc_setReadBufferSize_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QLocalSocket.setReadBufferSize", overloads);
        return 0;
}

static PyObject*
SbkQLocalSocketFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
    QLocalSocket::LocalSocketState cpp_result = cppSelf->QLocalSocket::state();
    py_result = Shiboken::Converter<QLocalSocket::LocalSocketState >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLocalSocketFunc_waitForBytesWritten(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForBytesWritten(int)
        QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QLocalSocket::waitForBytesWritten();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForBytesWritten(int)
        QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QLocalSocket::waitForBytesWritten(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQLocalSocketFunc_waitForBytesWritten_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQLocalSocketFunc_waitForBytesWritten_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QLocalSocket.waitForBytesWritten", overloads);
        return 0;
}

static PyObject*
SbkQLocalSocketFunc_waitForConnected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForConnected(int)
        QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QLocalSocket::waitForConnected();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForConnected(int)
        QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QLocalSocket::waitForConnected(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQLocalSocketFunc_waitForConnected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQLocalSocketFunc_waitForConnected_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QLocalSocket.waitForConnected", overloads);
        return 0;
}

static PyObject*
SbkQLocalSocketFunc_waitForDisconnected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForDisconnected(int)
        QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QLocalSocket::waitForDisconnected();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForDisconnected(int)
        QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QLocalSocket::waitForDisconnected(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQLocalSocketFunc_waitForDisconnected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQLocalSocketFunc_waitForDisconnected_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QLocalSocket.waitForDisconnected", overloads);
        return 0;
}

static PyObject*
SbkQLocalSocketFunc_waitForReadyRead(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForReadyRead(int)
        QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QLocalSocket::waitForReadyRead();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForReadyRead(int)
        QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QLocalSocket::waitForReadyRead(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQLocalSocketFunc_waitForReadyRead_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQLocalSocketFunc_waitForReadyRead_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QLocalSocket.waitForReadyRead", overloads);
        return 0;
}

static PyObject*
SbkQLocalSocketFunc_writeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // writeData(const char*,qint64)
        QLocalSocket* cppSelf = Shiboken::Converter<QLocalSocket* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QLocalSocket::writeData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQLocalSocketFunc_writeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQLocalSocketFunc_writeData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QLocalSocket.writeData", overloads);
        return 0;
}

static PyMethodDef SbkQLocalSocket_methods[] = {
    {"abort", (PyCFunction)SbkQLocalSocketFunc_abort, METH_NOARGS},
    {"bytesAvailable", (PyCFunction)SbkQLocalSocketFunc_bytesAvailable, METH_NOARGS},
    {"bytesToWrite", (PyCFunction)SbkQLocalSocketFunc_bytesToWrite, METH_NOARGS},
    {"canReadLine", (PyCFunction)SbkQLocalSocketFunc_canReadLine, METH_NOARGS},
    {"close", (PyCFunction)SbkQLocalSocketFunc_close, METH_NOARGS},
    {"connectToServer", (PyCFunction)SbkQLocalSocketFunc_connectToServer, METH_VARARGS},
    {"disconnectFromServer", (PyCFunction)SbkQLocalSocketFunc_disconnectFromServer, METH_NOARGS},
    {"error", (PyCFunction)SbkQLocalSocketFunc_error, METH_NOARGS},
    {"flush", (PyCFunction)SbkQLocalSocketFunc_flush, METH_NOARGS},
    {"fullServerName", (PyCFunction)SbkQLocalSocketFunc_fullServerName, METH_NOARGS},
    {"isSequential", (PyCFunction)SbkQLocalSocketFunc_isSequential, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQLocalSocketFunc_isValid, METH_NOARGS},
    {"readBufferSize", (PyCFunction)SbkQLocalSocketFunc_readBufferSize, METH_NOARGS},
    {"readData", (PyCFunction)SbkQLocalSocketFunc_readData, METH_VARARGS},
    {"serverName", (PyCFunction)SbkQLocalSocketFunc_serverName, METH_NOARGS},
    {"setReadBufferSize", (PyCFunction)SbkQLocalSocketFunc_setReadBufferSize, METH_O},
    {"state", (PyCFunction)SbkQLocalSocketFunc_state, METH_NOARGS},
    {"waitForBytesWritten", (PyCFunction)SbkQLocalSocketFunc_waitForBytesWritten, METH_NOARGS|METH_O},
    {"waitForConnected", (PyCFunction)SbkQLocalSocketFunc_waitForConnected, METH_NOARGS|METH_O},
    {"waitForDisconnected", (PyCFunction)SbkQLocalSocketFunc_waitForDisconnected, METH_NOARGS|METH_O},
    {"waitForReadyRead", (PyCFunction)SbkQLocalSocketFunc_waitForReadyRead, METH_NOARGS|METH_O},
    {"writeData", (PyCFunction)SbkQLocalSocketFunc_writeData, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQLocalSocket_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QLocalSocket",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QLocalSocketWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQLocalSocket_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQLocalSocket_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "LocalSocketState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "LocalSocketError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QLocalSocket(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQLocalSocket_Type);

    SbkQLocalSocket_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QIODEVICE_IDX];
    // Fill type discovery information
    SbkQLocalSocket_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQLocalSocket_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQLocalSocket_Type));
    PyModule_AddObject(module, "QLocalSocket",
        ((PyObject*)&SbkQLocalSocket_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: LocalSocketState
    SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_LOCALSOCKETSTATE_IDX] = &SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type);
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
            "LocalSocketState",((PyObject*)&SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type,
        (long) QLocalSocket::UnconnectedState, "UnconnectedState");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "UnconnectedState", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type.tp_dict,
        "UnconnectedState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type,
        (long) QLocalSocket::ConnectingState, "ConnectingState");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "ConnectingState", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type.tp_dict,
        "ConnectingState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type,
        (long) QLocalSocket::ConnectedState, "ConnectedState");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "ConnectedState", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type.tp_dict,
        "ConnectedState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type,
        (long) QLocalSocket::ClosingState, "ClosingState");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "ClosingState", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Type.tp_dict,
        "ClosingState", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QLocalSocket::LocalSocketState");

    // init enum class: LocalSocketError
    SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_LOCALSOCKETERROR_IDX] = &SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type);
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
            "LocalSocketError",((PyObject*)&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type,
        (long) QLocalSocket::ConnectionRefusedError, "ConnectionRefusedError");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "ConnectionRefusedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type.tp_dict,
        "ConnectionRefusedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type,
        (long) QLocalSocket::PeerClosedError, "PeerClosedError");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "PeerClosedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type.tp_dict,
        "PeerClosedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type,
        (long) QLocalSocket::ServerNotFoundError, "ServerNotFoundError");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "ServerNotFoundError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type.tp_dict,
        "ServerNotFoundError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type,
        (long) QLocalSocket::SocketAccessError, "SocketAccessError");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "SocketAccessError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type.tp_dict,
        "SocketAccessError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type,
        (long) QLocalSocket::SocketResourceError, "SocketResourceError");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "SocketResourceError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type.tp_dict,
        "SocketResourceError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type,
        (long) QLocalSocket::SocketTimeoutError, "SocketTimeoutError");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "SocketTimeoutError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type.tp_dict,
        "SocketTimeoutError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type,
        (long) QLocalSocket::DatagramTooLargeError, "DatagramTooLargeError");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "DatagramTooLargeError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type.tp_dict,
        "DatagramTooLargeError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type,
        (long) QLocalSocket::ConnectionError, "ConnectionError");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "ConnectionError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type.tp_dict,
        "ConnectionError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type,
        (long) QLocalSocket::UnsupportedSocketOperationError, "UnsupportedSocketOperationError");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "UnsupportedSocketOperationError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type.tp_dict,
        "UnsupportedSocketOperationError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type,
        (long) QLocalSocket::UnknownSocketError, "UnknownSocketError");
    PyDict_SetItemString(SbkQLocalSocket_Type.super.ht_type.tp_dict,
        "UnknownSocketError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Type.tp_dict,
        "UnknownSocketError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QLocalSocket::LocalSocketError");

    Shiboken::TypeResolver::createObjectTypeResolver<QLocalSocket >("QLocalSocket*");
    Shiboken::TypeResolver::createObjectTypeResolver<QLocalSocket >(typeid(QLocalSocket).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

