/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTNETWORK_PYTHON_H
#define SBK_QTNETWORK_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>

#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTNETWORK_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTNETWORK_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTNETWORK_API
#endif
#endif

// Module Includes
#include <pyside_qtcore_python.h>

// Class Includes
#include <qssl.h>
#include <qauthenticator.h>
#include <qhttp.h>
#include <qsslconfiguration.h>
#include <qhostaddress.h>
#include <qnetworkaccessmanager.h>
#include <qnetworkcookiejar.h>
#include <qlocalserver.h>
#include <qnetworkcookie.h>
#include <qabstractsocket.h>
#include <qudpsocket.h>
#include <qnetworkreply.h>
#include <qsslkey.h>
#include <qhostaddress.h>
#include <qtcpserver.h>
#include <qnetworkrequest.h>
#include <qlocalsocket.h>
#include <qtcpsocket.h>
#include <qsslsocket.h>
#include <qsslcipher.h>
#include <qnetworkinterface.h>
#include <qhostinfo.h>
#include <qnetworkinterface.h>
#include <qsslerror.h>
#include <qhttp.h>
#include <qurlinfo.h>
#include <qnetworkproxy.h>
#include <qhttp.h>
#include <qhttp.h>
#include <qftp.h>

// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QVector>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QList>
#include <QMap>
#include <QSet>
#include <QPair>

extern "C"
{

// Type indices
#define SBK_QSSL_KEYTYPE_IDX                                         0
#define SBK_QSSL_KEYALGORITHM_IDX                                    1
#define SBK_QSSL_SSLPROTOCOL_IDX                                     2
#define SBK_QSSL_ALTERNATENAMEENTRYTYPE_IDX                          3
#define SBK_QSSL_ENCODINGFORMAT_IDX                                  4
#define SBK_QAUTHENTICATOR_IDX                                       5
#define SBK_QHTTPHEADER_IDX                                          6
#define SBK_QSSLCONFIGURATION_IDX                                    7
#define SBK_QIPV6ADDRESS_IDX                                         8
#define SBK_QNETWORKACCESSMANAGER_IDX                                9
#define SBK_QNETWORKACCESSMANAGER_OPERATION_IDX                      10
#define SBK_QNETWORKCOOKIEJAR_IDX                                    11
#define SBK_QLOCALSERVER_IDX                                         12
#define SBK_QNETWORKCOOKIE_IDX                                       13
#define SBK_QNETWORKCOOKIE_RAWFORM_IDX                               14
#define SBK_QABSTRACTSOCKET_IDX                                      15
#define SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX                           16
#define SBK_QABSTRACTSOCKET_SOCKETERROR_IDX                          17
#define SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX                 18
#define SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX                          19
#define SBK_QUDPSOCKET_IDX                                           20
#define SBK_QUDPSOCKET_BINDFLAG_IDX                                  21
#define SBK_QFLAGS_QUDPSOCKET_BINDFLAG__IDX                          22
#define SBK_QNETWORKREPLY_IDX                                        23
#define SBK_QNETWORKREPLY_NETWORKERROR_IDX                           24
#define SBK_QSSLKEY_IDX                                              25
#define SBK_QHOSTADDRESS_IDX                                         26
#define SBK_QHOSTADDRESS_SPECIALADDRESS_IDX                          27
#define SBK_QTCPSERVER_IDX                                           28
#define SBK_QNETWORKREQUEST_IDX                                      29
#define SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX                     30
#define SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX                         31
#define SBK_QNETWORKREQUEST_ATTRIBUTE_IDX                            32
#define SBK_QLOCALSOCKET_IDX                                         33
#define SBK_QLOCALSOCKET_LOCALSOCKETSTATE_IDX                        34
#define SBK_QLOCALSOCKET_LOCALSOCKETERROR_IDX                        35
#define SBK_QTCPSOCKET_IDX                                           36
#define SBK_QSSLSOCKET_IDX                                           37
#define SBK_QSSLSOCKET_SSLMODE_IDX                                   38
#define SBK_QSSLSOCKET_PEERVERIFYMODE_IDX                            39
#define SBK_QSSLCIPHER_IDX                                           40
#define SBK_QNETWORKINTERFACE_IDX                                    41
#define SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX                      42
#define SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG__IDX              43
#define SBK_QHOSTINFO_IDX                                            44
#define SBK_QHOSTINFO_HOSTINFOERROR_IDX                              45
#define SBK_QNETWORKADDRESSENTRY_IDX                                 46
#define SBK_QSSLERROR_IDX                                            47
#define SBK_QSSLERROR_SSLERROR_IDX                                   48
#define SBK_QHTTPREQUESTHEADER_IDX                                   49
#define SBK_QURLINFO_IDX                                             50
#define SBK_QURLINFO_PERMISSIONSPEC_IDX                              51
#define SBK_QNETWORKPROXY_IDX                                        52
#define SBK_QNETWORKPROXY_PROXYTYPE_IDX                              53
#define SBK_QNETWORKPROXY_CAPABILITY_IDX                             54
#define SBK_QHTTP_IDX                                                55
#define SBK_QHTTP_ERROR_IDX                                          56
#define SBK_QHTTP_CONNECTIONMODE_IDX                                 57
#define SBK_QHTTP_STATE_IDX                                          58
#define SBK_QHTTPRESPONSEHEADER_IDX                                  59
#define SBK_QFTP_IDX                                                 60
#define SBK_QFTP_TRANSFERTYPE_IDX                                    61
#define SBK_QFTP_ERROR_IDX                                           62
#define SBK_QFTP_COMMAND_IDX                                         63
#define SBK_QFTP_TRANSFERMODE_IDX                                    64
#define SBK_QFTP_STATE_IDX                                           65
#define SBK_QtNetwork_IDX_COUNT                                      66

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtNetworkTypes;

// Useful macros
#define SbkPySide_QtNetwork_QSsl_KeyType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX])
#define SbkPySide_QtNetwork_QSsl_KeyType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX])

#define SbkPySide_QtNetwork_QSsl_KeyAlgorithm_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX])
#define SbkPySide_QtNetwork_QSsl_KeyAlgorithm_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX])

#define SbkPySide_QtNetwork_QSsl_SslProtocol_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX])
#define SbkPySide_QtNetwork_QSsl_SslProtocol_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX])

#define SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSL_ALTERNATENAMEENTRYTYPE_IDX])
#define SbkPySide_QtNetwork_QSsl_AlternateNameEntryType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSL_ALTERNATENAMEENTRYTYPE_IDX])

#define SbkPySide_QtNetwork_QSsl_EncodingFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])
#define SbkPySide_QtNetwork_QSsl_EncodingFormat_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])

#define SbkQAuthenticator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX])
#define SbkQAuthenticator_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX])
#define SbkQHttpHeader_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTPHEADER_IDX])
#define SbkQHttpHeader_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTPHEADER_IDX])
#define SbkQSslConfiguration_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX])
#define SbkQSslConfiguration_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX])
#define SbkQIPv6Address_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX])
#define SbkQIPv6Address_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX])
#define SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX])
#define SbkPySide_QtNetwork_QNetworkAccessManager_Operation_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX])

#define SbkQNetworkAccessManager_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX])
#define SbkQNetworkAccessManager_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX])
#define SbkQNetworkCookieJar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKCOOKIEJAR_IDX])
#define SbkQNetworkCookieJar_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKCOOKIEJAR_IDX])
#define SbkQLocalServer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QLOCALSERVER_IDX])
#define SbkQLocalServer_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QLOCALSERVER_IDX])
#define SbkPySide_QtNetwork_QNetworkCookie_RawForm_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKCOOKIE_RAWFORM_IDX])
#define SbkPySide_QtNetwork_QNetworkCookie_RawForm_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKCOOKIE_RAWFORM_IDX])

#define SbkQNetworkCookie_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKCOOKIE_IDX])
#define SbkQNetworkCookie_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKCOOKIE_IDX])
#define SbkPySide_QtNetwork_QAbstractSocket_SocketType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX])
#define SbkPySide_QtNetwork_QAbstractSocket_SocketType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX])

#define SbkPySide_QtNetwork_QAbstractSocket_SocketError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX])
#define SbkPySide_QtNetwork_QAbstractSocket_SocketError_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX])

#define SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX])
#define SbkPySide_QtNetwork_QAbstractSocket_NetworkLayerProtocol_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX])

#define SbkPySide_QtNetwork_QAbstractSocket_SocketState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX])
#define SbkPySide_QtNetwork_QAbstractSocket_SocketState_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX])

#define SbkQAbstractSocket_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX])
#define SbkQAbstractSocket_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX])
#define SbkPySide_QtNetwork_QUdpSocket_BindFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QUDPSOCKET_BINDFLAG_IDX])
#define SbkPySide_QtNetwork_QUdpSocket_BindFlag_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QUDPSOCKET_BINDFLAG_IDX])
#define SbkPySide_QtNetwork_QUdpSocket_BindMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFLAGS_QUDPSOCKET_BINDFLAG__IDX])
#define SbkPySide_QtNetwork_QUdpSocket_BindMode_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFLAGS_QUDPSOCKET_BINDFLAG__IDX])

#define SbkQUdpSocket_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QUDPSOCKET_IDX])
#define SbkQUdpSocket_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QUDPSOCKET_IDX])
#define SbkPySide_QtNetwork_QNetworkReply_NetworkError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREPLY_NETWORKERROR_IDX])
#define SbkPySide_QtNetwork_QNetworkReply_NetworkError_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREPLY_NETWORKERROR_IDX])

#define SbkQNetworkReply_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREPLY_IDX])
#define SbkQNetworkReply_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREPLY_IDX])
#define SbkQSslKey_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLKEY_IDX])
#define SbkQSslKey_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLKEY_IDX])
#define SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX])
#define SbkPySide_QtNetwork_QHostAddress_SpecialAddress_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX])

#define SbkQHostAddress_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHOSTADDRESS_IDX])
#define SbkQHostAddress_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHOSTADDRESS_IDX])
#define SbkQTcpServer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QTCPSERVER_IDX])
#define SbkQTcpServer_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QTCPSERVER_IDX])
#define SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX])
#define SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX])

#define SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX])
#define SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX])

#define SbkPySide_QtNetwork_QNetworkRequest_Attribute_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX])
#define SbkPySide_QtNetwork_QNetworkRequest_Attribute_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX])

#define SbkQNetworkRequest_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX])
#define SbkQNetworkRequest_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX])
#define SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_LOCALSOCKETSTATE_IDX])
#define SbkPySide_QtNetwork_QLocalSocket_LocalSocketState_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_LOCALSOCKETSTATE_IDX])

#define SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_LOCALSOCKETERROR_IDX])
#define SbkPySide_QtNetwork_QLocalSocket_LocalSocketError_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_LOCALSOCKETERROR_IDX])

#define SbkQLocalSocket_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_IDX])
#define SbkQLocalSocket_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_IDX])
#define SbkQTcpSocket_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QTCPSOCKET_IDX])
#define SbkQTcpSocket_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QTCPSOCKET_IDX])
#define SbkPySide_QtNetwork_QSslSocket_SslMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_SSLMODE_IDX])
#define SbkPySide_QtNetwork_QSslSocket_SslMode_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_SSLMODE_IDX])

#define SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_PEERVERIFYMODE_IDX])
#define SbkPySide_QtNetwork_QSslSocket_PeerVerifyMode_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_PEERVERIFYMODE_IDX])

#define SbkQSslSocket_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_IDX])
#define SbkQSslSocket_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_IDX])
#define SbkQSslCipher_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLCIPHER_IDX])
#define SbkQSslCipher_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLCIPHER_IDX])
#define SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX])
#define SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlag_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX])
#define SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG__IDX])
#define SbkPySide_QtNetwork_QNetworkInterface_InterfaceFlags_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG__IDX])

#define SbkQNetworkInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX])
#define SbkQNetworkInterface_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX])
#define SbkPySide_QtNetwork_QHostInfo_HostInfoError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX])
#define SbkPySide_QtNetwork_QHostInfo_HostInfoError_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX])

#define SbkQHostInfo_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHOSTINFO_IDX])
#define SbkQHostInfo_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHOSTINFO_IDX])
#define SbkQNetworkAddressEntry_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX])
#define SbkQNetworkAddressEntry_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX])
#define SbkPySide_QtNetwork_QSslError_SslError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX])
#define SbkPySide_QtNetwork_QSslError_SslError_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX])

#define SbkQSslError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLERROR_IDX])
#define SbkQSslError_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QSSLERROR_IDX])
#define SbkQHttpRequestHeader_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTPREQUESTHEADER_IDX])
#define SbkQHttpRequestHeader_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTPREQUESTHEADER_IDX])
#define SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QURLINFO_PERMISSIONSPEC_IDX])
#define SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QURLINFO_PERMISSIONSPEC_IDX])

#define SbkQUrlInfo_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QURLINFO_IDX])
#define SbkQUrlInfo_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QURLINFO_IDX])
#define SbkPySide_QtNetwork_QNetworkProxy_ProxyType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX])
#define SbkPySide_QtNetwork_QNetworkProxy_ProxyType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX])

#define SbkPySide_QtNetwork_QNetworkProxy_Capability_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX])
#define SbkPySide_QtNetwork_QNetworkProxy_Capability_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX])

#define SbkQNetworkProxy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_IDX])
#define SbkQNetworkProxy_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_IDX])
#define SbkPySide_QtNetwork_QHttp_Error_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTP_ERROR_IDX])
#define SbkPySide_QtNetwork_QHttp_Error_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTP_ERROR_IDX])

#define SbkPySide_QtNetwork_QHttp_ConnectionMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTP_CONNECTIONMODE_IDX])
#define SbkPySide_QtNetwork_QHttp_ConnectionMode_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTP_CONNECTIONMODE_IDX])

#define SbkPySide_QtNetwork_QHttp_State_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTP_STATE_IDX])
#define SbkPySide_QtNetwork_QHttp_State_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTP_STATE_IDX])

#define SbkQHttp_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTP_IDX])
#define SbkQHttp_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTP_IDX])
#define SbkQHttpResponseHeader_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTPRESPONSEHEADER_IDX])
#define SbkQHttpResponseHeader_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QHTTPRESPONSEHEADER_IDX])
#define SbkPySide_QtNetwork_QFtp_TransferType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_TRANSFERTYPE_IDX])
#define SbkPySide_QtNetwork_QFtp_TransferType_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_TRANSFERTYPE_IDX])

#define SbkPySide_QtNetwork_QFtp_Error_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_ERROR_IDX])
#define SbkPySide_QtNetwork_QFtp_Error_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_ERROR_IDX])

#define SbkPySide_QtNetwork_QFtp_Command_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_COMMAND_IDX])
#define SbkPySide_QtNetwork_QFtp_Command_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_COMMAND_IDX])

#define SbkPySide_QtNetwork_QFtp_TransferMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_TRANSFERMODE_IDX])
#define SbkPySide_QtNetwork_QFtp_TransferMode_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_TRANSFERMODE_IDX])

#define SbkPySide_QtNetwork_QFtp_State_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_STATE_IDX])
#define SbkPySide_QtNetwork_QFtp_State_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_STATE_IDX])

#define SbkQFtp_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_IDX])
#define SbkQFtp_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtNetworkTypes[SBK_QFTP_IDX])

} // extern "C"

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<>
inline PyTypeObject* SbkType<QSsl::KeyType >() { return SbkPySide_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX]; }
template<>
inline PyTypeObject* SbkType<QSsl::KeyAlgorithm >() { return SbkPySide_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX]; }
template<>
inline PyTypeObject* SbkType<QSsl::SslProtocol >() { return SbkPySide_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX]; }
template<>
inline PyTypeObject* SbkType<QSsl::AlternateNameEntryType >() { return SbkPySide_QtNetworkTypes[SBK_QSSL_ALTERNATENAMEENTRYTYPE_IDX]; }
template<>
inline PyTypeObject* SbkType<QSsl::EncodingFormat >() { return SbkPySide_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX]; }
template<>
inline PyTypeObject* SbkType<QAuthenticator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX]); }
template<>
inline PyTypeObject* SbkType<QHttpHeader >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QHTTPHEADER_IDX]); }
template<>
inline PyTypeObject* SbkType<QSslConfiguration >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]); }
template<>
inline PyTypeObject* SbkType<QIPv6Address >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX]); }
template<>
inline PyTypeObject* SbkType<QNetworkAccessManager::Operation >() { return SbkPySide_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX]; }
template<>
inline PyTypeObject* SbkType<QNetworkAccessManager >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX]); }
template<>
inline PyTypeObject* SbkType<QNetworkCookieJar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QNETWORKCOOKIEJAR_IDX]); }
template<>
inline PyTypeObject* SbkType<QLocalServer >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QLOCALSERVER_IDX]); }
template<>
inline PyTypeObject* SbkType<QNetworkCookie::RawForm >() { return SbkPySide_QtNetworkTypes[SBK_QNETWORKCOOKIE_RAWFORM_IDX]; }
template<>
inline PyTypeObject* SbkType<QNetworkCookie >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QNETWORKCOOKIE_IDX]); }
template<>
inline PyTypeObject* SbkType<QAbstractSocket::SocketType >() { return SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX]; }
template<>
inline PyTypeObject* SbkType<QAbstractSocket::SocketError >() { return SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX]; }
template<>
inline PyTypeObject* SbkType<QAbstractSocket::NetworkLayerProtocol >() { return SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX]; }
template<>
inline PyTypeObject* SbkType<QAbstractSocket::SocketState >() { return SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX]; }
template<>
inline PyTypeObject* SbkType<QAbstractSocket >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX]); }
template<>
inline PyTypeObject* SbkType<QUdpSocket::BindFlag >() { return SbkPySide_QtNetworkTypes[SBK_QUDPSOCKET_BINDFLAG_IDX]; }
template<>
inline PyTypeObject* SbkType<QFlags<QUdpSocket::BindFlag> >() { return SbkPySide_QtNetworkTypes[SBK_QFLAGS_QUDPSOCKET_BINDFLAG__IDX]; }
template<>
inline PyTypeObject* SbkType<QUdpSocket >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QUDPSOCKET_IDX]); }
template<>
inline PyTypeObject* SbkType<QNetworkReply::NetworkError >() { return SbkPySide_QtNetworkTypes[SBK_QNETWORKREPLY_NETWORKERROR_IDX]; }
template<>
inline PyTypeObject* SbkType<QNetworkReply >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]); }
template<>
inline PyTypeObject* SbkType<QSslKey >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QSSLKEY_IDX]); }
template<>
inline PyTypeObject* SbkType<QHostAddress::SpecialAddress >() { return SbkPySide_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX]; }
template<>
inline PyTypeObject* SbkType<QHostAddress >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]); }
template<>
inline PyTypeObject* SbkType<QTcpServer >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QTCPSERVER_IDX]); }
template<>
inline PyTypeObject* SbkType<QNetworkRequest::CacheLoadControl >() { return SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX]; }
template<>
inline PyTypeObject* SbkType<QNetworkRequest::KnownHeaders >() { return SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX]; }
template<>
inline PyTypeObject* SbkType<QNetworkRequest::Attribute >() { return SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX]; }
template<>
inline PyTypeObject* SbkType<QNetworkRequest >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]); }
template<>
inline PyTypeObject* SbkType<QLocalSocket::LocalSocketState >() { return SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_LOCALSOCKETSTATE_IDX]; }
template<>
inline PyTypeObject* SbkType<QLocalSocket::LocalSocketError >() { return SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_LOCALSOCKETERROR_IDX]; }
template<>
inline PyTypeObject* SbkType<QLocalSocket >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QLOCALSOCKET_IDX]); }
template<>
inline PyTypeObject* SbkType<QTcpSocket >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QTCPSOCKET_IDX]); }
template<>
inline PyTypeObject* SbkType<QSslSocket::SslMode >() { return SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_SSLMODE_IDX]; }
template<>
inline PyTypeObject* SbkType<QSslSocket::PeerVerifyMode >() { return SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_PEERVERIFYMODE_IDX]; }
template<>
inline PyTypeObject* SbkType<QSslSocket >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QSSLSOCKET_IDX]); }
template<>
inline PyTypeObject* SbkType<QSslCipher >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QSSLCIPHER_IDX]); }
template<>
inline PyTypeObject* SbkType<QNetworkInterface::InterfaceFlag >() { return SbkPySide_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX]; }
template<>
inline PyTypeObject* SbkType<QFlags<QNetworkInterface::InterfaceFlag> >() { return SbkPySide_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG__IDX]; }
template<>
inline PyTypeObject* SbkType<QNetworkInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]); }
template<>
inline PyTypeObject* SbkType<QHostInfo::HostInfoError >() { return SbkPySide_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX]; }
template<>
inline PyTypeObject* SbkType<QHostInfo >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QHOSTINFO_IDX]); }
template<>
inline PyTypeObject* SbkType<QNetworkAddressEntry >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]); }
template<>
inline PyTypeObject* SbkType<QSslError::SslError >() { return SbkPySide_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX]; }
template<>
inline PyTypeObject* SbkType<QSslError >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QSSLERROR_IDX]); }
template<>
inline PyTypeObject* SbkType<QHttpRequestHeader >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QHTTPREQUESTHEADER_IDX]); }
template<>
inline PyTypeObject* SbkType<QUrlInfo::PermissionSpec >() { return SbkPySide_QtNetworkTypes[SBK_QURLINFO_PERMISSIONSPEC_IDX]; }
template<>
inline PyTypeObject* SbkType<QUrlInfo >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QURLINFO_IDX]); }
template<>
inline PyTypeObject* SbkType<QNetworkProxy::ProxyType >() { return SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX]; }
template<>
inline PyTypeObject* SbkType<QNetworkProxy::Capability >() { return SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX]; }
template<>
inline PyTypeObject* SbkType<QNetworkProxy >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]); }
template<>
inline PyTypeObject* SbkType<QHttp::Error >() { return SbkPySide_QtNetworkTypes[SBK_QHTTP_ERROR_IDX]; }
template<>
inline PyTypeObject* SbkType<QHttp::ConnectionMode >() { return SbkPySide_QtNetworkTypes[SBK_QHTTP_CONNECTIONMODE_IDX]; }
template<>
inline PyTypeObject* SbkType<QHttp::State >() { return SbkPySide_QtNetworkTypes[SBK_QHTTP_STATE_IDX]; }
template<>
inline PyTypeObject* SbkType<QHttp >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QHTTP_IDX]); }
template<>
inline PyTypeObject* SbkType<QHttpResponseHeader >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QHTTPRESPONSEHEADER_IDX]); }
template<>
inline PyTypeObject* SbkType<QFtp::TransferType >() { return SbkPySide_QtNetworkTypes[SBK_QFTP_TRANSFERTYPE_IDX]; }
template<>
inline PyTypeObject* SbkType<QFtp::Error >() { return SbkPySide_QtNetworkTypes[SBK_QFTP_ERROR_IDX]; }
template<>
inline PyTypeObject* SbkType<QFtp::Command >() { return SbkPySide_QtNetworkTypes[SBK_QFTP_COMMAND_IDX]; }
template<>
inline PyTypeObject* SbkType<QFtp::TransferMode >() { return SbkPySide_QtNetworkTypes[SBK_QFTP_TRANSFERMODE_IDX]; }
template<>
inline PyTypeObject* SbkType<QFtp::State >() { return SbkPySide_QtNetworkTypes[SBK_QFTP_STATE_IDX]; }
template<>
inline PyTypeObject* SbkType<QFtp >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtNetworkTypes[SBK_QFTP_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QSsl::KeyType > : EnumConverter<QSsl::KeyType >
{
};

template<>
struct Converter<QSsl::KeyAlgorithm > : EnumConverter<QSsl::KeyAlgorithm >
{
};

template<>
struct Converter<QSsl::SslProtocol > : EnumConverter<QSsl::SslProtocol >
{
};

template<>
struct Converter<QSsl::AlternateNameEntryType > : EnumConverter<QSsl::AlternateNameEntryType >
{
};

template<>
struct Converter<QSsl::EncodingFormat > : EnumConverter<QSsl::EncodingFormat >
{
};

template<>
struct Converter<QAuthenticator > : ValueTypeConverter<QAuthenticator >
{
};

template<>
struct Converter<QHttpHeader* > : ObjectTypeConverter<QHttpHeader >
{
};

template<>
struct Converter<QHttpHeader& > : ObjectTypeReferenceConverter<QHttpHeader >
{
};


template<>
struct Converter<QSslConfiguration > : ValueTypeConverter<QSslConfiguration >
{
};

template <>
struct SbkTypeInfo<QIPv6Address >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QIPv6Address > : ValueTypeConverter<QIPv6Address >
{
};

template<>
struct Converter<QNetworkAccessManager::Operation > : EnumConverter<QNetworkAccessManager::Operation >
{
};

template<>
struct Converter<QNetworkAccessManager* > : ObjectTypeConverter<QNetworkAccessManager >
{
};

template<>
struct Converter<QNetworkAccessManager& > : ObjectTypeReferenceConverter<QNetworkAccessManager >
{
};


template<>
struct Converter<QNetworkCookieJar* > : ObjectTypeConverter<QNetworkCookieJar >
{
};

template<>
struct Converter<QNetworkCookieJar& > : ObjectTypeReferenceConverter<QNetworkCookieJar >
{
};


template<>
struct Converter<QLocalServer* > : ObjectTypeConverter<QLocalServer >
{
};

template<>
struct Converter<QLocalServer& > : ObjectTypeReferenceConverter<QLocalServer >
{
};


template<>
struct Converter<QNetworkCookie::RawForm > : EnumConverter<QNetworkCookie::RawForm >
{
};

template<>
struct Converter<QNetworkCookie > : ValueTypeConverter<QNetworkCookie >
{
};

template<>
struct Converter<QAbstractSocket::SocketType > : EnumConverter<QAbstractSocket::SocketType >
{
};

template<>
struct Converter<QAbstractSocket::SocketError > : EnumConverter<QAbstractSocket::SocketError >
{
};

template<>
struct Converter<QAbstractSocket::NetworkLayerProtocol > : EnumConverter<QAbstractSocket::NetworkLayerProtocol >
{
};

template<>
struct Converter<QAbstractSocket::SocketState > : EnumConverter<QAbstractSocket::SocketState >
{
};

template<>
struct Converter<QAbstractSocket* > : ObjectTypeConverter<QAbstractSocket >
{
};

template<>
struct Converter<QAbstractSocket& > : ObjectTypeReferenceConverter<QAbstractSocket >
{
};


template<>
struct Converter<QUdpSocket::BindFlag > : EnumConverter<QUdpSocket::BindFlag >
{
};
template<>
struct Converter<QFlags<QUdpSocket::BindFlag> > : EnumConverter<QFlags<QUdpSocket::BindFlag> >
{
};

template<>
struct Converter<QUdpSocket* > : ObjectTypeConverter<QUdpSocket >
{
};

template<>
struct Converter<QUdpSocket& > : ObjectTypeReferenceConverter<QUdpSocket >
{
};


template<>
struct Converter<QNetworkReply::NetworkError > : EnumConverter<QNetworkReply::NetworkError >
{
};

template<>
struct Converter<QNetworkReply* > : ObjectTypeConverter<QNetworkReply >
{
};

template<>
struct Converter<QNetworkReply& > : ObjectTypeReferenceConverter<QNetworkReply >
{
};


template<>
struct Converter<QSslKey > : ValueTypeConverter<QSslKey >
{
};

template<>
struct Converter<QHostAddress::SpecialAddress > : EnumConverter<QHostAddress::SpecialAddress >
{
};

template<>
struct Converter<QHostAddress > : ValueTypeConverter<QHostAddress >
{
    static QHostAddress toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QTcpServer* > : ObjectTypeConverter<QTcpServer >
{
};

template<>
struct Converter<QTcpServer& > : ObjectTypeReferenceConverter<QTcpServer >
{
};


template<>
struct Converter<QNetworkRequest::CacheLoadControl > : EnumConverter<QNetworkRequest::CacheLoadControl >
{
};

template<>
struct Converter<QNetworkRequest::KnownHeaders > : EnumConverter<QNetworkRequest::KnownHeaders >
{
};

template<>
struct Converter<QNetworkRequest::Attribute > : EnumConverter<QNetworkRequest::Attribute >
{
};

template<>
struct Converter<QNetworkRequest > : ValueTypeConverter<QNetworkRequest >
{
};

template<>
struct Converter<QLocalSocket::LocalSocketState > : EnumConverter<QLocalSocket::LocalSocketState >
{
};

template<>
struct Converter<QLocalSocket::LocalSocketError > : EnumConverter<QLocalSocket::LocalSocketError >
{
};

template<>
struct Converter<QLocalSocket* > : ObjectTypeConverter<QLocalSocket >
{
};

template<>
struct Converter<QLocalSocket& > : ObjectTypeReferenceConverter<QLocalSocket >
{
};


template<>
struct Converter<QTcpSocket* > : ObjectTypeConverter<QTcpSocket >
{
};

template<>
struct Converter<QTcpSocket& > : ObjectTypeReferenceConverter<QTcpSocket >
{
};


template<>
struct Converter<QSslSocket::SslMode > : EnumConverter<QSslSocket::SslMode >
{
};

template<>
struct Converter<QSslSocket::PeerVerifyMode > : EnumConverter<QSslSocket::PeerVerifyMode >
{
};

template<>
struct Converter<QSslSocket* > : ObjectTypeConverter<QSslSocket >
{
};

template<>
struct Converter<QSslSocket& > : ObjectTypeReferenceConverter<QSslSocket >
{
};


template<>
struct Converter<QSslCipher > : ValueTypeConverter<QSslCipher >
{
};

template<>
struct Converter<QNetworkInterface::InterfaceFlag > : EnumConverter<QNetworkInterface::InterfaceFlag >
{
};
template<>
struct Converter<QFlags<QNetworkInterface::InterfaceFlag> > : EnumConverter<QFlags<QNetworkInterface::InterfaceFlag> >
{
};

template<>
struct Converter<QNetworkInterface > : ValueTypeConverter<QNetworkInterface >
{
};

template<>
struct Converter<QHostInfo::HostInfoError > : EnumConverter<QHostInfo::HostInfoError >
{
};

template<>
struct Converter<QHostInfo > : ValueTypeConverter<QHostInfo >
{
    static QHostInfo toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QNetworkAddressEntry > : ValueTypeConverter<QNetworkAddressEntry >
{
};

template<>
struct Converter<QSslError::SslError > : EnumConverter<QSslError::SslError >
{
};

template<>
struct Converter<QSslError > : ValueTypeConverter<QSslError >
{
    static QSslError toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template <>
struct SbkTypeInfo<QHttpRequestHeader >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QHttpRequestHeader > : ValueTypeConverter<QHttpRequestHeader >
{
    static QHttpRequestHeader toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QUrlInfo::PermissionSpec > : EnumConverter<QUrlInfo::PermissionSpec >
{
};

template <>
struct SbkTypeInfo<QUrlInfo >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QUrlInfo > : ValueTypeConverter<QUrlInfo >
{
};

template<>
struct Converter<QNetworkProxy::ProxyType > : EnumConverter<QNetworkProxy::ProxyType >
{
};

template<>
struct Converter<QNetworkProxy::Capability > : EnumConverter<QNetworkProxy::Capability >
{
};

template<>
struct Converter<QNetworkProxy > : ValueTypeConverter<QNetworkProxy >
{
    static QNetworkProxy toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QHttp::Error > : EnumConverter<QHttp::Error >
{
};

template<>
struct Converter<QHttp::ConnectionMode > : EnumConverter<QHttp::ConnectionMode >
{
};

template<>
struct Converter<QHttp::State > : EnumConverter<QHttp::State >
{
};

template<>
struct Converter<QHttp* > : ObjectTypeConverter<QHttp >
{
};

template<>
struct Converter<QHttp& > : ObjectTypeReferenceConverter<QHttp >
{
};


template <>
struct SbkTypeInfo<QHttpResponseHeader >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QHttpResponseHeader > : ValueTypeConverter<QHttpResponseHeader >
{
    static QHttpResponseHeader toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QFtp::TransferType > : EnumConverter<QFtp::TransferType >
{
};

template<>
struct Converter<QFtp::Error > : EnumConverter<QFtp::Error >
{
};

template<>
struct Converter<QFtp::Command > : EnumConverter<QFtp::Command >
{
};

template<>
struct Converter<QFtp::TransferMode > : EnumConverter<QFtp::TransferMode >
{
};

template<>
struct Converter<QFtp::State > : EnumConverter<QFtp::State >
{
};

template<>
struct Converter<QFtp* > : ObjectTypeConverter<QFtp >
{
};

template<>
struct Converter<QFtp& > : ObjectTypeReferenceConverter<QFtp >
{
};



} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------

inline bool Shiboken::Converter<QHostAddress >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QHostAddress >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QHostAddress >());
    return Shiboken::Converter<QHostAddress::SpecialAddress >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QHostAddress Shiboken::Converter<QHostAddress >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QHostAddress)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QHostAddress >());
        if (Shiboken::Converter<QHostAddress::SpecialAddress >::isConvertible(pyobj))
            return QHostAddress(Shiboken::Converter<QHostAddress::SpecialAddress >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QHostAddress* cptr = reinterpret_cast<QHostAddress*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QHostAddress > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QHostInfo >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QHostInfo >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QHostInfo >());
    return PyInt_Check(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QHostInfo Shiboken::Converter<QHostInfo >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QHostInfo)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QHostInfo >());
        if (PyInt_Check(pyobj))
            return QHostInfo(Shiboken::Converter<int >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QHostInfo* cptr = reinterpret_cast<QHostInfo*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QHostInfo > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QHostInfo* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QSslError >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QSslError >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QSslError >());
    return Shiboken::Converter<QSslError::SslError >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QSslError Shiboken::Converter<QSslError >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QSslError)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QSslError >());
        if (Shiboken::Converter<QSslError::SslError >::isConvertible(pyobj))
            return QSslError(Shiboken::Converter<QSslError::SslError >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QSslError* cptr = reinterpret_cast<QSslError*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QSslError > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QSslError* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QHttpRequestHeader >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QHttpRequestHeader >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QHttpRequestHeader >());
    return Shiboken::Converter<QString& >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QHttpRequestHeader Shiboken::Converter<QHttpRequestHeader >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QHttpRequestHeader)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QHttpRequestHeader >());
        if (Shiboken::Converter<QString& >::isConvertible(pyobj))
            return QHttpRequestHeader(Shiboken::Converter<QString& >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QHttpRequestHeader* cptr = reinterpret_cast<QHttpRequestHeader*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QHttpRequestHeader > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QHttpRequestHeader* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QNetworkProxy >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QNetworkProxy >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QNetworkProxy >());
    return Shiboken::Converter<QNetworkProxy::ProxyType >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QNetworkProxy Shiboken::Converter<QNetworkProxy >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QNetworkProxy)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QNetworkProxy >());
        if (Shiboken::Converter<QNetworkProxy::ProxyType >::isConvertible(pyobj))
            return QNetworkProxy(Shiboken::Converter<QNetworkProxy::ProxyType >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QNetworkProxy* cptr = reinterpret_cast<QNetworkProxy*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QNetworkProxy > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QNetworkProxy* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QHttpResponseHeader >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QHttpResponseHeader >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QHttpResponseHeader >());
    return Shiboken::Converter<QString& >::isConvertible(pyobj)
         || PyInt_Check(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QHttpResponseHeader Shiboken::Converter<QHttpResponseHeader >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QHttpResponseHeader)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QHttpResponseHeader >());
        if (Shiboken::Converter<QString& >::isConvertible(pyobj))
            return QHttpResponseHeader(Shiboken::Converter<QString& >::toCpp(pyobj));
        else if (PyInt_Check(pyobj))
            return QHttpResponseHeader(Shiboken::Converter<int >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QHttpResponseHeader* cptr = reinterpret_cast<QHttpResponseHeader*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QHttpResponseHeader > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QHttpResponseHeader* >::toCpp((PyObject*)pyobj);
}


#endif // SBK_QTNETWORK_PYTHON_H

