/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qwidget_wrapper.h"

// Extra includes
#include <QIcon>
#include <QList>
#include <QMessageBox>
#include "glue/qwidget_glue.h"
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QWidgetWrapper::QWidgetWrapper(QWidget * parent, QFlags<Qt::WindowType> f) : QWidget(parent, f), m_metaObject(0) {
    // ... middle
}

void QWidgetWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWidgetWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWidgetWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QWidget::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QWidgetWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QWidget.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QWidgetWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWidgetWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QWidgetWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QWidget::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QWidget.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QWidgetWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QWidget.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QWidgetWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QWidgetWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QWidget.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QWidgetWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QWidgetWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QWidget.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QWidgetWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QWidgetWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QWidget.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QWidgetWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWidgetWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QWidgetWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QWidget.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QWidgetWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QWidget.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QWidgetWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QWidgetWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QWidget.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QWidgetWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QWidget::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWidgetWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QWidgetWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QWidget.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QWidgetWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWidgetWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWidgetWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QWidgetWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QWidget::staticMetaObject);
}
    return m_metaObject;
}

int QWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QWidgetWrapper::~QWidgetWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQWidget_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWidgetWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]);
    if (type != myType) {
        type->mi_init = myType->mi_init;
        type->mi_offsets = myType->mi_offsets;
        type->mi_specialcast = myType->mi_specialcast;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QWidget", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QWidget(QWidget*,QFlags<Qt::WindowType>)
        cptr = new QWidgetWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QWidget(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QWidgetWrapper(cpp_arg0);
            Shiboken::setParent(pyargs[0], self);
        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // QWidget(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QWidgetWrapper(cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[0], self);
        } else goto SbkQWidget_Init_TypeError;
    } else goto SbkQWidget_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWidget_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQWidget_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget", overloads);
        return -1;
}

static PyObject*
SbkQWidgetFunc_acceptDrops(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // acceptDrops()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::acceptDrops();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_accessibleDescription(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // accessibleDescription()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWidget::accessibleDescription();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_accessibleName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // accessibleName()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWidget::accessibleName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_actionEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QActionEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QActionEvent* cpp_arg0 = Shiboken::Converter<QActionEvent* >::toCpp(arg);
        // actionEvent(QActionEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::actionEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_actionEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_actionEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QActionEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.actionEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_actions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // actions()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QList<QAction * > cpp_result = cppSelf->QWidget::actions();
    py_result = Shiboken::Converter<QList<QAction * > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_activateWindow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // activateWindow()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::activateWindow();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_addAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAction* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(arg);
        // addAction(QAction*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::addAction(cpp_arg0);
    } else goto SbkQWidgetFunc_addAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_addAction_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.addAction", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_addActions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QAction * > >::isConvertible(arg)) {
        QList<QAction * > cpp_arg0 = Shiboken::Converter<QList<QAction * > >::toCpp(arg);
        // addActions(QList<QAction*>)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::addActions(cpp_arg0);
    } else goto SbkQWidgetFunc_addActions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_addActions_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.addActions", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_adjustSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // adjustSize()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::adjustSize();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_autoFillBackground(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoFillBackground()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::autoFillBackground();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_backgroundRole(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // backgroundRole()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QPalette::ColorRole cpp_result = cppSelf->QWidget::backgroundRole();
    py_result = Shiboken::Converter<QPalette::ColorRole >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_baseSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // baseSize()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWidget::baseSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::changeEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.changeEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_childAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "childAt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // childAt(int,int)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QWidget::childAt(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // childAt(QPoint)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QWidget::childAt(*cpp_arg0);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQWidgetFunc_childAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_childAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.childAt", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_childrenRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // childrenRect()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QWidget::childrenRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_childrenRegion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // childrenRegion()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QRegion cpp_result = cppSelf->QWidget::childrenRegion();
    py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_clearFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearFocus()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::clearFocus();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_clearMask(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearMask()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::clearMask();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // close()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::close();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_closeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCloseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QCloseEvent* cpp_arg0 = Shiboken::Converter<QCloseEvent* >::toCpp(arg);
        // closeEvent(QCloseEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::closeEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_closeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_closeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCloseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.closeEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_contentsMargins(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contentsMargins()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QMargins cpp_result = cppSelf->QWidget::contentsMargins();
    py_result = Shiboken::Converter<QMargins >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_contentsRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contentsRect()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QWidget::contentsRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QContextMenuEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QContextMenuEvent* cpp_arg0 = Shiboken::Converter<QContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QContextMenuEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::contextMenuEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.contextMenuEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_contextMenuPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contextMenuPolicy()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    Qt::ContextMenuPolicy cpp_result = cppSelf->QWidget::contextMenuPolicy();
    py_result = Shiboken::Converter<Qt::ContextMenuPolicy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_createWinId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // createWinId()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::createWinId();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_cursor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cursor()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QCursor cpp_result = cppSelf->QWidget::cursor();
    py_result = Shiboken::Converter<QCursor >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_destroy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "destroy", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // destroy(bool,bool)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::destroy();
    } else if (PyNumber_Check(pyargs[0])) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // destroy(bool,bool)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::destroy(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // destroy(bool,bool)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::destroy(cpp_arg0, cpp_arg1);
        } else goto SbkQWidgetFunc_destroy_TypeError;
    } else goto SbkQWidgetFunc_destroy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_destroy_TypeError:
        const char* overloads[] = {"bool = true, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.destroy", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_devType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // devType()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWidget::devType();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_dragEnterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragEnterEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragEnterEvent* cpp_arg0 = Shiboken::Converter<QDragEnterEvent* >::toCpp(arg);
        // dragEnterEvent(QDragEnterEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::dragEnterEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_dragEnterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_dragEnterEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragEnterEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.dragEnterEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_dragLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragLeaveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragLeaveEvent* cpp_arg0 = Shiboken::Converter<QDragLeaveEvent* >::toCpp(arg);
        // dragLeaveEvent(QDragLeaveEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::dragLeaveEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_dragLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_dragLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragLeaveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.dragLeaveEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragMoveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragMoveEvent* cpp_arg0 = Shiboken::Converter<QDragMoveEvent* >::toCpp(arg);
        // dragMoveEvent(QDragMoveEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::dragMoveEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.dragMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // dropEvent(QDropEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::dropEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.dropEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_effectiveWinId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // effectiveWinId()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    WId cpp_result = cppSelf->QWidget::effectiveWinId();
    py_result = Shiboken::Converter<unsigned long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_ensurePolished(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // ensurePolished()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::ensurePolished();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_enterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // enterEvent(QEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::enterEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_enterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_enterEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.enterEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWidget::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.event", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::focusInEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.focusInEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_focusNextChild(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // focusNextChild()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::focusNextChild();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWidget::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.focusNextPrevChild", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::focusOutEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.focusOutEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_focusPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // focusPolicy()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    Qt::FocusPolicy cpp_result = cppSelf->QWidget::focusPolicy();
    py_result = Shiboken::Converter<Qt::FocusPolicy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_focusPreviousChild(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // focusPreviousChild()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::focusPreviousChild();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_focusProxy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // focusProxy()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QWidget::focusProxy();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_focusWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // focusWidget()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QWidget::focusWidget();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    const QFont & cpp_result = cppSelf->QWidget::font();
    py_result = Shiboken::Converter<QFont& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_foregroundRole(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // foregroundRole()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QPalette::ColorRole cpp_result = cppSelf->QWidget::foregroundRole();
    py_result = Shiboken::Converter<QPalette::ColorRole >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_frameGeometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // frameGeometry()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QWidget::frameGeometry();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_frameSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // frameSize()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWidget::frameSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_geometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // geometry()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    const QRect & cpp_result = cppSelf->QWidget::geometry();
    py_result = Shiboken::Converter<QRect& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_grabGesture(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "grabGesture", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Qt::GestureType >::isConvertible(pyargs[0])) {
        Qt::GestureType cpp_arg0 = Shiboken::Converter<Qt::GestureType >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // grabGesture(Qt::GestureType,QFlags<Qt::GestureFlag>)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::grabGesture(cpp_arg0);
        } else if (SbkPySide_QtCore_Qt_GestureFlag_Check(pyargs[1])) {
            QFlags<Qt::GestureFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::GestureFlag> >::toCpp(pyargs[1]);
            // grabGesture(Qt::GestureType,QFlags<Qt::GestureFlag>)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::grabGesture(cpp_arg0, cpp_arg1);
        } else goto SbkQWidgetFunc_grabGesture_TypeError;
    } else goto SbkQWidgetFunc_grabGesture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_grabGesture_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.GestureType, PySide.QtCore.Qt.GestureFlags = Qt.GestureFlags()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.grabGesture", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_grabKeyboard(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // grabKeyboard()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::grabKeyboard();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_grabMouse(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // grabMouse()
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::grabMouse();
    } else if (Shiboken::Converter<QCursor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QCursor > cpp_arg0_auto_ptr;
        QCursor* cpp_arg0 = Shiboken::Converter<QCursor* >::toCpp(arg);
        if (!Shiboken::Converter<QCursor& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QCursor >(cpp_arg0);
        // grabMouse(QCursor)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::grabMouse(*cpp_arg0);
    } else goto SbkQWidgetFunc_grabMouse_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_grabMouse_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QCursor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.grabMouse", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_grabShortcut(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "grabShortcut", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QKeySequence& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QKeySequence > cpp_arg0_auto_ptr;
        QKeySequence* cpp_arg0 = Shiboken::Converter<QKeySequence* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QKeySequence& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg0);
        if (numArgs == 1) {
            // grabShortcut(QKeySequence,Qt::ShortcutContext)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QWidget::grabShortcut(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::ShortcutContext >::isConvertible(pyargs[1])) {
            Qt::ShortcutContext cpp_arg1 = Shiboken::Converter<Qt::ShortcutContext >::toCpp(pyargs[1]);
            // grabShortcut(QKeySequence,Qt::ShortcutContext)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QWidget::grabShortcut(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQWidgetFunc_grabShortcut_TypeError;
    } else goto SbkQWidgetFunc_grabShortcut_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_grabShortcut_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeySequence, PySide.QtCore.Qt.ShortcutContext = Qt.WindowShortcut", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.grabShortcut", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_graphicsEffect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // graphicsEffect()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QGraphicsEffect * cpp_result = cppSelf->QWidget::graphicsEffect();
    py_result = Shiboken::Converter<QGraphicsEffect* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_graphicsProxyWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // graphicsProxyWidget()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QGraphicsProxyWidget * cpp_result = cppSelf->QWidget::graphicsProxyWidget();
    py_result = Shiboken::Converter<QGraphicsProxyWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_hasFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasFocus()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::hasFocus();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_hasMouseTracking(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasMouseTracking()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::hasMouseTracking();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWidget::height();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_heightForWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // heightForWidth(int)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QWidget::heightForWidth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_heightForWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_heightForWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.heightForWidth", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_hide(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // hide()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::hide();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_hideEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHideEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QHideEvent* cpp_arg0 = Shiboken::Converter<QHideEvent* >::toCpp(arg);
        // hideEvent(QHideEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::hideEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_hideEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_hideEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QHideEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.hideEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_inputContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // inputContext()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QInputContext * cpp_result = cppSelf->QWidget::inputContext();
    py_result = Shiboken::Converter<QInputContext* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_inputMethodEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputMethodEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QInputMethodEvent* cpp_arg0 = Shiboken::Converter<QInputMethodEvent* >::toCpp(arg);
        // inputMethodEvent(QInputMethodEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::inputMethodEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_inputMethodEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_inputMethodEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputMethodEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.inputMethodEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_inputMethodHints(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // inputMethodHints()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QFlags<Qt::InputMethodHint> cpp_result = cppSelf->QWidget::inputMethodHints();
    py_result = Shiboken::Converter<QFlags<Qt::InputMethodHint> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_inputMethodQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::InputMethodQuery >::isConvertible(arg)) {
        Qt::InputMethodQuery cpp_arg0 = Shiboken::Converter<Qt::InputMethodQuery >::toCpp(arg);
        // inputMethodQuery(Qt::InputMethodQuery)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QWidget::inputMethodQuery(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_inputMethodQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_inputMethodQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodQuery", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.inputMethodQuery", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_insertAction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertAction", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAction* >::isConvertible(pyargs[0]) && Shiboken::Converter<QAction* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAction* cpp_arg1 = Shiboken::Converter<QAction* >::toCpp(pyargs[1]);
        // insertAction(QAction*,QAction*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::insertAction(cpp_arg0, cpp_arg1);
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQWidgetFunc_insertAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_insertAction_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction, PySide.QtGui.QAction", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.insertAction", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_insertActions(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertActions", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAction* >::isConvertible(pyargs[0]) && Shiboken::Converter<QList<QAction * > >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(pyargs[0]);
        QList<QAction * > cpp_arg1 = Shiboken::Converter<QList<QAction * > >::toCpp(pyargs[1]);
        // insertActions(QAction*,QList<QAction*>)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::insertActions(cpp_arg0, cpp_arg1);
    } else goto SbkQWidgetFunc_insertActions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_insertActions_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.insertActions", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_isActiveWindow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isActiveWindow()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isActiveWindow();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_isAncestorOf(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // isAncestorOf(const QWidget*)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWidget::isAncestorOf(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_isAncestorOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_isAncestorOf_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.isAncestorOf", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_isEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEnabled()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_isEnabledTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // isEnabledTo(QWidget*)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWidget::isEnabledTo(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_isEnabledTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_isEnabledTo_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.isEnabledTo", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_isFullScreen(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFullScreen()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isFullScreen();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_isHidden(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isHidden()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isHidden();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_isLeftToRight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isLeftToRight()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isLeftToRight();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_isMaximized(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isMaximized()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isMaximized();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_isMinimized(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isMinimized()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isMinimized();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_isModal(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isModal()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isModal();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_isRightToLeft(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRightToLeft()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isRightToLeft();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_isVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isVisible()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isVisible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_isVisibleTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // isVisibleTo(QWidget*)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWidget::isVisibleTo(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_isVisibleTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_isVisibleTo_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.isVisibleTo", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_isWindow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isWindow()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isWindow();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_isWindowModified(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isWindowModified()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::isWindowModified();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::keyPressEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.keyPressEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_keyReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyReleaseEvent(QKeyEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::keyReleaseEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_keyReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_keyReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.keyReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_keyboardGrabber(PyObject* self)
{
    PyObject* py_result = 0;

    // keyboardGrabber()
    QWidget * cpp_result = QWidget::keyboardGrabber();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_languageChange(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // languageChange()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::languageChange();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_layout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // layout()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QLayout * cpp_result = cppSelf->QWidget::layout();
    py_result = Shiboken::Converter<QLayout* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_layoutDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // layoutDirection()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    Qt::LayoutDirection cpp_result = cppSelf->QWidget::layoutDirection();
    py_result = Shiboken::Converter<Qt::LayoutDirection >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_leaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // leaveEvent(QEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::leaveEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_leaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_leaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.leaveEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_locale(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // locale()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QLocale cpp_result = cppSelf->QWidget::locale();
    py_result = Shiboken::Converter<QLocale >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_lower(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // lower()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::lower();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_mapFrom(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "mapFrom", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg1_auto_ptr;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPoint >(cpp_arg1);
        // mapFrom(QWidget*,QPoint)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        QPoint cpp_result = cppSelf->QWidget::mapFrom(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_mapFrom_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_mapFrom_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.mapFrom", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_mapFromGlobal(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // mapFromGlobal(QPoint)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        QPoint cpp_result = cppSelf->QWidget::mapFromGlobal(*cpp_arg0);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_mapFromGlobal_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_mapFromGlobal_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.mapFromGlobal", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_mapFromParent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // mapFromParent(QPoint)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        QPoint cpp_result = cppSelf->QWidget::mapFromParent(*cpp_arg0);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_mapFromParent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_mapFromParent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.mapFromParent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_mapTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "mapTo", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg1_auto_ptr;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPoint >(cpp_arg1);
        // mapTo(QWidget*,QPoint)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        QPoint cpp_result = cppSelf->QWidget::mapTo(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_mapTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_mapTo_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.mapTo", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_mapToGlobal(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // mapToGlobal(QPoint)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        QPoint cpp_result = cppSelf->QWidget::mapToGlobal(*cpp_arg0);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_mapToGlobal_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_mapToGlobal_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.mapToGlobal", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_mapToParent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // mapToParent(QPoint)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        QPoint cpp_result = cppSelf->QWidget::mapToParent(*cpp_arg0);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_mapToParent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_mapToParent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.mapToParent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_mask(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mask()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QRegion cpp_result = cppSelf->QWidget::mask();
    py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_maximumHeight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumHeight()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWidget::maximumHeight();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_maximumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumSize()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWidget::maximumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_maximumWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumWidth()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWidget::maximumWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_metric(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::isConvertible(arg)) {
        QPaintDevice::PaintDeviceMetric cpp_arg0 = Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toCpp(arg);
        // metric(QPaintDevice::PaintDeviceMetric)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QWidget::metric(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_metric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_metric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice.PaintDeviceMetric", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.metric", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_minimumHeight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumHeight()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWidget::minimumHeight();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_minimumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSize()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWidget::minimumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_minimumSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSizeHint()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWidget::minimumSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_minimumWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumWidth()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWidget::minimumWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QMouseEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::mouseDoubleClickEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_mouseGrabber(PyObject* self)
{
    PyObject* py_result = 0;

    // mouseGrabber()
    QWidget * cpp_result = QWidget::mouseGrabber();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::mouseMoveEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.mouseMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::mousePressEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.mousePressEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::mouseReleaseEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_move(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "move", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // move(int,int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::move(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // move(QPoint)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::move(*cpp_arg0);
    } else goto SbkQWidgetFunc_move_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_move_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.move", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_moveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMoveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMoveEvent* cpp_arg0 = Shiboken::Converter<QMoveEvent* >::toCpp(arg);
        // moveEvent(QMoveEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::moveEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_moveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_moveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.moveEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_nativeParentWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nativeParentWidget()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QWidget::nativeParentWidget();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_nextInFocusChain(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nextInFocusChain()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QWidget::nextInFocusChain();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_normalGeometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // normalGeometry()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QWidget::normalGeometry();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_overrideWindowFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_WindowType_Check(arg)) {
        QFlags<Qt::WindowType> cpp_arg0 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(arg);
        // overrideWindowFlags(QFlags<Qt::WindowType>)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::overrideWindowFlags(cpp_arg0);
    } else goto SbkQWidgetFunc_overrideWindowFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_overrideWindowFlags_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.WindowFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.overrideWindowFlags", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_overrideWindowState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_WindowState_Check(arg)) {
        QFlags<Qt::WindowState> cpp_arg0 = Shiboken::Converter<QFlags<Qt::WindowState> >::toCpp(arg);
        // overrideWindowState(QFlags<Qt::WindowState>)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::overrideWindowState(cpp_arg0);
    } else goto SbkQWidgetFunc_overrideWindowState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_overrideWindowState_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.WindowStates", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.overrideWindowState", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_paintEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintEngine()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QPaintEngine * cpp_result = cppSelf->QWidget::paintEngine();
    py_result = Shiboken::Converter<QPaintEngine* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::paintEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.paintEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_palette(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // palette()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    const QPalette & cpp_result = cppSelf->QWidget::palette();
    py_result = Shiboken::Converter<QPalette& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_parentWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parentWidget()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QWidget::parentWidget();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);

    // Ownership transferences.
    SbkBaseWrapper_setOwnership(py_result, true);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QWidget::pos();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_previousInFocusChain(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // previousInFocusChain()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QWidget::previousInFocusChain();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_raise_(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // raise()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::raise();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_rect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rect()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QWidget::rect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_releaseKeyboard(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // releaseKeyboard()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::releaseKeyboard();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_releaseMouse(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // releaseMouse()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::releaseMouse();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_releaseShortcut(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // releaseShortcut(int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::releaseShortcut(cpp_arg0);
    } else goto SbkQWidgetFunc_releaseShortcut_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_releaseShortcut_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.releaseShortcut", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_removeAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAction* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(arg);
        // removeAction(QAction*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::removeAction(cpp_arg0);
    } else goto SbkQWidgetFunc_removeAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_removeAction_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.removeAction", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_render(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "render", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg1_auto_ptr;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPoint >(cpp_arg1);
        if (numArgs == 2) {
            // render(QPainter*,QPoint,QRegion,QFlags<QWidget::RenderFlag>)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::render(cpp_arg0, *cpp_arg1);
        } else if (Shiboken::Converter<QRegion& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QRegion > cpp_arg2_auto_ptr;
            QRegion* cpp_arg2 = Shiboken::Converter<QRegion* >::toCpp(pyargs[2]);
            if (!Shiboken::Converter<QRegion& >::isConvertible(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QRegion >(cpp_arg2);
            if (numArgs == 3) {
                // render(QPainter*,QPoint,QRegion,QFlags<QWidget::RenderFlag>)
                QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
                cppSelf->QWidget::render(cpp_arg0, *cpp_arg1, *cpp_arg2);
            } else if (SbkPySide_QtGui_QWidget_RenderFlag_Check(pyargs[3])) {
                QFlags<QWidget::RenderFlag> cpp_arg3 = Shiboken::Converter<QFlags<QWidget::RenderFlag> >::toCpp(pyargs[3]);
                // render(QPainter*,QPoint,QRegion,QFlags<QWidget::RenderFlag>)
                QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
                cppSelf->QWidget::render(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
            } else goto SbkQWidgetFunc_render_TypeError;
        } else goto SbkQWidgetFunc_render_TypeError;
    } else if (Shiboken::Converter<QPaintDevice* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPaintDevice* cpp_arg0 = Shiboken::Converter<QPaintDevice* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // render(QPaintDevice*,QPoint,QRegion,QFlags<QWidget::RenderFlag>)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::render(cpp_arg0);
        } else if (Shiboken::Converter<QPoint& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QPoint > cpp_arg1_auto_ptr;
            QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPoint >(cpp_arg1);
            if (numArgs == 2) {
                // render(QPaintDevice*,QPoint,QRegion,QFlags<QWidget::RenderFlag>)
                QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
                cppSelf->QWidget::render(cpp_arg0, *cpp_arg1);
            } else if (Shiboken::Converter<QRegion& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QRegion > cpp_arg2_auto_ptr;
                QRegion* cpp_arg2 = Shiboken::Converter<QRegion* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QRegion& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QRegion >(cpp_arg2);
                if (numArgs == 3) {
                    // render(QPaintDevice*,QPoint,QRegion,QFlags<QWidget::RenderFlag>)
                    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
                    cppSelf->QWidget::render(cpp_arg0, *cpp_arg1, *cpp_arg2);
                } else if (SbkPySide_QtGui_QWidget_RenderFlag_Check(pyargs[3])) {
                    QFlags<QWidget::RenderFlag> cpp_arg3 = Shiboken::Converter<QFlags<QWidget::RenderFlag> >::toCpp(pyargs[3]);
                    // render(QPaintDevice*,QPoint,QRegion,QFlags<QWidget::RenderFlag>)
                    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
                    cppSelf->QWidget::render(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                } else goto SbkQWidgetFunc_render_TypeError;
            } else goto SbkQWidgetFunc_render_TypeError;
        } else goto SbkQWidgetFunc_render_TypeError;
    } else goto SbkQWidgetFunc_render_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_render_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice, PySide.QtCore.QPoint = QPoint(), PySide.QtGui.QRegion = QRegion(), PySide.QtGui.QWidget.RenderFlags = QWidget.RenderFlags(DrawWindowBackground | DrawChildren)", "PySide.QtGui.QPainter, PySide.QtCore.QPoint, PySide.QtGui.QRegion = QRegion(), PySide.QtGui.QWidget.RenderFlags = QWidget.RenderFlags(DrawWindowBackground | DrawChildren)", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.render", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_repaint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQWidgetFunc_repaint_TypeError;

    if (!PyArg_UnpackTuple(args, "repaint", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 0) {
        // repaint()
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::repaint();
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // repaint(int,int,int,int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::repaint(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (numArgs == 1 && Shiboken::Converter<QRect& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // repaint(QRect)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::repaint(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QRegion& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRegion& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // repaint(QRegion)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::repaint(*cpp_arg0);
    } else goto SbkQWidgetFunc_repaint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_repaint_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QRect", "PySide.QtGui.QRegion", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.repaint", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_resetInputContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resetInputContext()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::resetInputContext();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_resize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "resize", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // resize(int,int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::resize(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QSize& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // resize(QSize)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::resize(*cpp_arg0);
    } else goto SbkQWidgetFunc_resize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_resize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.resize", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::resizeEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.resizeEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_restoreGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // restoreGeometry(QByteArray)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWidget::restoreGeometry(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_restoreGeometry_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_restoreGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.restoreGeometry", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_saveGeometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // saveGeometry()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QWidget::saveGeometry();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_scroll(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "scroll", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // scroll(int,int)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::scroll(cpp_arg0, cpp_arg1);
        } else if (numArgs == 3 && Shiboken::Converter<QRect& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
            // scroll(int,int,QRect)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::scroll(cpp_arg0, cpp_arg1, *cpp_arg2);
        } else goto SbkQWidgetFunc_scroll_TypeError;
    } else goto SbkQWidgetFunc_scroll_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_scroll_TypeError:
        const char* overloads[] = {"int, int", "int, int, PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.scroll", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setAcceptDrops(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAcceptDrops(bool)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setAcceptDrops(cpp_arg0);
    } else goto SbkQWidgetFunc_setAcceptDrops_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setAcceptDrops_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setAcceptDrops", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setAccessibleDescription(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setAccessibleDescription(QString)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setAccessibleDescription(*cpp_arg0);
    } else goto SbkQWidgetFunc_setAccessibleDescription_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setAccessibleDescription_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setAccessibleDescription", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setAccessibleName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setAccessibleName(QString)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setAccessibleName(*cpp_arg0);
    } else goto SbkQWidgetFunc_setAccessibleName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setAccessibleName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setAccessibleName", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setAttribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAttribute", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Qt::WidgetAttribute >::isConvertible(pyargs[0])) {
        Qt::WidgetAttribute cpp_arg0 = Shiboken::Converter<Qt::WidgetAttribute >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setAttribute(Qt::WidgetAttribute,bool)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::setAttribute(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setAttribute(Qt::WidgetAttribute,bool)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::setAttribute(cpp_arg0, cpp_arg1);
        } else goto SbkQWidgetFunc_setAttribute_TypeError;
    } else goto SbkQWidgetFunc_setAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.WidgetAttribute, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setAttribute", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setAutoFillBackground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoFillBackground(bool)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setAutoFillBackground(cpp_arg0);
    } else goto SbkQWidgetFunc_setAutoFillBackground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setAutoFillBackground_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setAutoFillBackground", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setBackgroundRole(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPalette::ColorRole >::isConvertible(arg)) {
        QPalette::ColorRole cpp_arg0 = Shiboken::Converter<QPalette::ColorRole >::toCpp(arg);
        // setBackgroundRole(QPalette::ColorRole)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setBackgroundRole(cpp_arg0);
    } else goto SbkQWidgetFunc_setBackgroundRole_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setBackgroundRole_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette.ColorRole", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setBackgroundRole", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setBaseSize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setBaseSize", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setBaseSize(int,int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setBaseSize(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QSize& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // setBaseSize(QSize)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setBaseSize(*cpp_arg0);
    } else goto SbkQWidgetFunc_setBaseSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setBaseSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setBaseSize", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setContentsMargins(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQWidgetFunc_setContentsMargins_TypeError;

    if (!PyArg_UnpackTuple(args, "setContentsMargins", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // setContentsMargins(int,int,int,int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setContentsMargins(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (numArgs == 1 && Shiboken::Converter<QMargins& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMargins* cpp_arg0 = Shiboken::Converter<QMargins* >::toCpp(pyargs[0]);
        // setContentsMargins(QMargins)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setContentsMargins(*cpp_arg0);
    } else goto SbkQWidgetFunc_setContentsMargins_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setContentsMargins_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMargins", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setContentsMargins", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setContextMenuPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::ContextMenuPolicy >::isConvertible(arg)) {
        Qt::ContextMenuPolicy cpp_arg0 = Shiboken::Converter<Qt::ContextMenuPolicy >::toCpp(arg);
        // setContextMenuPolicy(Qt::ContextMenuPolicy)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setContextMenuPolicy(cpp_arg0);
    } else goto SbkQWidgetFunc_setContextMenuPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setContextMenuPolicy_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ContextMenuPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setContextMenuPolicy", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setCursor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCursor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QCursor > cpp_arg0_auto_ptr;
        QCursor* cpp_arg0 = Shiboken::Converter<QCursor* >::toCpp(arg);
        if (!Shiboken::Converter<QCursor& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QCursor >(cpp_arg0);
        // setCursor(QCursor)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setCursor(*cpp_arg0);
    } else goto SbkQWidgetFunc_setCursor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCursor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setCursor", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setDisabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDisabled(bool)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setDisabled(cpp_arg0);
    } else goto SbkQWidgetFunc_setDisabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setDisabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setDisabled", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setEnabled(bool)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setEnabled(cpp_arg0);
    } else goto SbkQWidgetFunc_setEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setEnabled", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setFixedHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setFixedHeight(int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setFixedHeight(cpp_arg0);
    } else goto SbkQWidgetFunc_setFixedHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setFixedHeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setFixedHeight", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setFixedSize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFixedSize", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setFixedSize(int,int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setFixedSize(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QSize& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // setFixedSize(QSize)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setFixedSize(*cpp_arg0);
    } else goto SbkQWidgetFunc_setFixedSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setFixedSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setFixedSize", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setFixedWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setFixedWidth(int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setFixedWidth(cpp_arg0);
    } else goto SbkQWidgetFunc_setFixedWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setFixedWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setFixedWidth", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setFocus(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // setFocus()
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setFocus();
    } else if (Shiboken::Converter<Qt::FocusReason >::isConvertible(arg)) {
        Qt::FocusReason cpp_arg0 = Shiboken::Converter<Qt::FocusReason >::toCpp(arg);
        // setFocus(Qt::FocusReason)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setFocus(cpp_arg0);
    } else goto SbkQWidgetFunc_setFocus_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setFocus_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.Qt.FocusReason", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setFocus", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setFocusPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::FocusPolicy >::isConvertible(arg)) {
        Qt::FocusPolicy cpp_arg0 = Shiboken::Converter<Qt::FocusPolicy >::toCpp(arg);
        // setFocusPolicy(Qt::FocusPolicy)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setFocusPolicy(cpp_arg0);
    } else goto SbkQWidgetFunc_setFocusPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setFocusPolicy_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.FocusPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setFocusPolicy", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setFocusProxy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setFocusProxy(QWidget*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setFocusProxy(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQWidgetFunc_setFocusProxy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setFocusProxy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setFocusProxy", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!Shiboken::Converter<QFont& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setFont(QFont)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setFont(*cpp_arg0);
    } else goto SbkQWidgetFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setFont", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setForegroundRole(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPalette::ColorRole >::isConvertible(arg)) {
        QPalette::ColorRole cpp_arg0 = Shiboken::Converter<QPalette::ColorRole >::toCpp(arg);
        // setForegroundRole(QPalette::ColorRole)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setForegroundRole(cpp_arg0);
    } else goto SbkQWidgetFunc_setForegroundRole_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setForegroundRole_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette.ColorRole", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setForegroundRole", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setGeometry(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQWidgetFunc_setGeometry_TypeError;

    if (!PyArg_UnpackTuple(args, "setGeometry", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // setGeometry(int,int,int,int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setGeometry(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (numArgs == 1 && Shiboken::Converter<QRect& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // setGeometry(QRect)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setGeometry(*cpp_arg0);
    } else goto SbkQWidgetFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setGeometry", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setGraphicsEffect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsEffect* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsEffect* cpp_arg0 = Shiboken::Converter<QGraphicsEffect* >::toCpp(arg);
        // setGraphicsEffect(QGraphicsEffect*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setGraphicsEffect(cpp_arg0);
    } else goto SbkQWidgetFunc_setGraphicsEffect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setGraphicsEffect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsEffect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setGraphicsEffect", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setHidden(bool)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setHidden(cpp_arg0);
    } else goto SbkQWidgetFunc_setHidden_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setHidden_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setHidden", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setInputContext(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputContext* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QInputContext* cpp_arg0 = Shiboken::Converter<QInputContext* >::toCpp(arg);
        // setInputContext(QInputContext*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setInputContext(cpp_arg0);

        // Ownership transferences.
        BindingManager::instance().transferOwnershipToCpp(arg);
    } else goto SbkQWidgetFunc_setInputContext_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setInputContext_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputContext", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setInputContext", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setInputMethodHints(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_InputMethodHint_Check(arg)) {
        QFlags<Qt::InputMethodHint> cpp_arg0 = Shiboken::Converter<QFlags<Qt::InputMethodHint> >::toCpp(arg);
        // setInputMethodHints(QFlags<Qt::InputMethodHint>)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setInputMethodHints(cpp_arg0);
    } else goto SbkQWidgetFunc_setInputMethodHints_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setInputMethodHints_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodHints", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setInputMethodHints", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setLayout(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLayout* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLayout* cpp_arg0 = Shiboken::Converter<QLayout* >::toCpp(arg);
        // setLayout(QLayout*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        // Begin code injection
        
        qwidgetSetLayout(cppSelf, cpp_arg0);
        
        // End of code injection

        cppSelf->QWidget::setLayout(cpp_arg0);

    } else goto SbkQWidgetFunc_setLayout_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setLayout_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayout", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setLayout", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setLayoutDirection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::LayoutDirection >::isConvertible(arg)) {
        Qt::LayoutDirection cpp_arg0 = Shiboken::Converter<Qt::LayoutDirection >::toCpp(arg);
        // setLayoutDirection(Qt::LayoutDirection)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setLayoutDirection(cpp_arg0);
    } else goto SbkQWidgetFunc_setLayoutDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setLayoutDirection_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.LayoutDirection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setLayoutDirection", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setLocale(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLocale& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLocale > cpp_arg0_auto_ptr;
        QLocale* cpp_arg0 = Shiboken::Converter<QLocale* >::toCpp(arg);
        if (!Shiboken::Converter<QLocale& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLocale >(cpp_arg0);
        // setLocale(QLocale)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setLocale(*cpp_arg0);
    } else goto SbkQWidgetFunc_setLocale_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setLocale_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLocale", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setLocale", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setMask(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBitmap& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBitmap > cpp_arg0_auto_ptr;
        QBitmap* cpp_arg0 = Shiboken::Converter<QBitmap* >::toCpp(arg);
        if (!Shiboken::Converter<QBitmap& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBitmap >(cpp_arg0);
        // setMask(QBitmap)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setMask(*cpp_arg0);
    } else if (Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // setMask(QRegion)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setMask(*cpp_arg0);
    } else goto SbkQWidgetFunc_setMask_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setMask_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBitmap", "PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setMask", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setMaximumHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaximumHeight(int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setMaximumHeight(cpp_arg0);
    } else goto SbkQWidgetFunc_setMaximumHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setMaximumHeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setMaximumHeight", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setMaximumSize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setMaximumSize", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setMaximumSize(int,int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setMaximumSize(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QSize& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // setMaximumSize(QSize)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setMaximumSize(*cpp_arg0);
    } else goto SbkQWidgetFunc_setMaximumSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setMaximumSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setMaximumSize", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setMaximumWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaximumWidth(int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setMaximumWidth(cpp_arg0);
    } else goto SbkQWidgetFunc_setMaximumWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setMaximumWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setMaximumWidth", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setMinimumHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMinimumHeight(int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setMinimumHeight(cpp_arg0);
    } else goto SbkQWidgetFunc_setMinimumHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setMinimumHeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setMinimumHeight", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setMinimumSize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setMinimumSize", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setMinimumSize(int,int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setMinimumSize(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QSize& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // setMinimumSize(QSize)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setMinimumSize(*cpp_arg0);
    } else goto SbkQWidgetFunc_setMinimumSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setMinimumSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setMinimumSize", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setMinimumWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMinimumWidth(int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setMinimumWidth(cpp_arg0);
    } else goto SbkQWidgetFunc_setMinimumWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setMinimumWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setMinimumWidth", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setMouseTracking(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setMouseTracking(bool)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setMouseTracking(cpp_arg0);
    } else goto SbkQWidgetFunc_setMouseTracking_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setMouseTracking_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setMouseTracking", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setPalette(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPalette& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(arg);
        if (!Shiboken::Converter<QPalette& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // setPalette(QPalette)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setPalette(*cpp_arg0);
    } else goto SbkQWidgetFunc_setPalette_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setPalette_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setPalette", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setParent(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setParent", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setParent(QWidget*)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::setParent(cpp_arg0);
        } else if (numArgs == 2 && SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // setParent(QWidget*,QFlags<Qt::WindowType>)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::setParent(cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[0], self);
        } else goto SbkQWidgetFunc_setParent_TypeError;
    } else goto SbkQWidgetFunc_setParent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setParent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", "PySide.QtGui.QWidget, PySide.QtCore.Qt.WindowFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setParent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setShortcutAutoRepeat(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setShortcutAutoRepeat", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setShortcutAutoRepeat(int,bool)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::setShortcutAutoRepeat(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setShortcutAutoRepeat(int,bool)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::setShortcutAutoRepeat(cpp_arg0, cpp_arg1);
        } else goto SbkQWidgetFunc_setShortcutAutoRepeat_TypeError;
    } else goto SbkQWidgetFunc_setShortcutAutoRepeat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setShortcutAutoRepeat_TypeError:
        const char* overloads[] = {"int, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setShortcutAutoRepeat", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setShortcutEnabled(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setShortcutEnabled", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setShortcutEnabled(int,bool)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::setShortcutEnabled(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setShortcutEnabled(int,bool)
            QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
            cppSelf->QWidget::setShortcutEnabled(cpp_arg0, cpp_arg1);
        } else goto SbkQWidgetFunc_setShortcutEnabled_TypeError;
    } else goto SbkQWidgetFunc_setShortcutEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setShortcutEnabled_TypeError:
        const char* overloads[] = {"int, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setShortcutEnabled", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setSizeIncrement(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setSizeIncrement", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setSizeIncrement(int,int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setSizeIncrement(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QSize& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // setSizeIncrement(QSize)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setSizeIncrement(*cpp_arg0);
    } else goto SbkQWidgetFunc_setSizeIncrement_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setSizeIncrement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setSizeIncrement", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setSizePolicy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setSizePolicy", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QSizePolicy::Policy >::isConvertible(pyargs[0]) && Shiboken::Converter<QSizePolicy::Policy >::isConvertible(pyargs[1])) {
        QSizePolicy::Policy cpp_arg0 = Shiboken::Converter<QSizePolicy::Policy >::toCpp(pyargs[0]);
        QSizePolicy::Policy cpp_arg1 = Shiboken::Converter<QSizePolicy::Policy >::toCpp(pyargs[1]);
        // setSizePolicy(QSizePolicy::Policy,QSizePolicy::Policy)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setSizePolicy(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QSizePolicy >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSizePolicy* cpp_arg0 = Shiboken::Converter<QSizePolicy* >::toCpp(pyargs[0]);
        // setSizePolicy(QSizePolicy)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setSizePolicy(*cpp_arg0);
    } else goto SbkQWidgetFunc_setSizePolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setSizePolicy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSizePolicy", "PySide.QtGui.QSizePolicy.Policy, PySide.QtGui.QSizePolicy.Policy", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setSizePolicy", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setStatusTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setStatusTip(QString)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setStatusTip(*cpp_arg0);
    } else goto SbkQWidgetFunc_setStatusTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setStatusTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setStatusTip", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStyle* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStyle* cpp_arg0 = Shiboken::Converter<QStyle* >::toCpp(arg);
        // setStyle(QStyle*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setStyle(cpp_arg0);
    } else goto SbkQWidgetFunc_setStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setStyle_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setStyle", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setStyleSheet(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setStyleSheet(QString)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setStyleSheet(*cpp_arg0);
    } else goto SbkQWidgetFunc_setStyleSheet_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setStyleSheet_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setStyleSheet", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setTabOrder(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabOrder", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        // setTabOrder(QWidget*,QWidget*)
        QWidget::setTabOrder(cpp_arg0, cpp_arg1);
    } else goto SbkQWidgetFunc_setTabOrder_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setTabOrder_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.setTabOrder", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setToolTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setToolTip(QString)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setToolTip(*cpp_arg0);
    } else goto SbkQWidgetFunc_setToolTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setToolTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setToolTip", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setUpdatesEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUpdatesEnabled(bool)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setUpdatesEnabled(cpp_arg0);
    } else goto SbkQWidgetFunc_setUpdatesEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setUpdatesEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setUpdatesEnabled", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setVisible(bool)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setVisible(cpp_arg0);
    } else goto SbkQWidgetFunc_setVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setVisible", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setWhatsThis(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWhatsThis(QString)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setWhatsThis(*cpp_arg0);
    } else goto SbkQWidgetFunc_setWhatsThis_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setWhatsThis_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setWhatsThis", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setWindowFilePath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWindowFilePath(QString)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setWindowFilePath(*cpp_arg0);
    } else goto SbkQWidgetFunc_setWindowFilePath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setWindowFilePath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setWindowFilePath", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setWindowFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_WindowType_Check(arg)) {
        QFlags<Qt::WindowType> cpp_arg0 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(arg);
        // setWindowFlags(QFlags<Qt::WindowType>)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setWindowFlags(cpp_arg0);
    } else goto SbkQWidgetFunc_setWindowFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setWindowFlags_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.WindowFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setWindowFlags", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setWindowIcon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIcon& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(arg);
        if (!Shiboken::Converter<QIcon& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        // setWindowIcon(QIcon)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setWindowIcon(*cpp_arg0);
    } else goto SbkQWidgetFunc_setWindowIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setWindowIcon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setWindowIcon", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setWindowIconText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWindowIconText(QString)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setWindowIconText(*cpp_arg0);
    } else goto SbkQWidgetFunc_setWindowIconText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setWindowIconText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setWindowIconText", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setWindowModality(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::WindowModality >::isConvertible(arg)) {
        Qt::WindowModality cpp_arg0 = Shiboken::Converter<Qt::WindowModality >::toCpp(arg);
        // setWindowModality(Qt::WindowModality)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setWindowModality(cpp_arg0);
    } else goto SbkQWidgetFunc_setWindowModality_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setWindowModality_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.WindowModality", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setWindowModality", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setWindowModified(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setWindowModified(bool)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setWindowModified(cpp_arg0);
    } else goto SbkQWidgetFunc_setWindowModified_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setWindowModified_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setWindowModified", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setWindowOpacity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setWindowOpacity(qreal)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setWindowOpacity(cpp_arg0);
    } else goto SbkQWidgetFunc_setWindowOpacity_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setWindowOpacity_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setWindowOpacity", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setWindowRole(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWindowRole(QString)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setWindowRole(*cpp_arg0);
    } else goto SbkQWidgetFunc_setWindowRole_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setWindowRole_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setWindowRole", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setWindowState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_WindowState_Check(arg)) {
        QFlags<Qt::WindowState> cpp_arg0 = Shiboken::Converter<QFlags<Qt::WindowState> >::toCpp(arg);
        // setWindowState(QFlags<Qt::WindowState>)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setWindowState(cpp_arg0);
    } else goto SbkQWidgetFunc_setWindowState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setWindowState_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.WindowStates", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setWindowState", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_setWindowTitle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWindowTitle(QString)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::setWindowTitle(*cpp_arg0);
    } else goto SbkQWidgetFunc_setWindowTitle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_setWindowTitle_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.setWindowTitle", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_show(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // show()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::show();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::showEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.showEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_showFullScreen(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showFullScreen()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::showFullScreen();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_showMaximized(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showMaximized()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::showMaximized();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_showMinimized(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showMinimized()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::showMinimized();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_showNormal(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showNormal()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::showNormal();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWidget::size();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWidget::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_sizeIncrement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeIncrement()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWidget::sizeIncrement();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_sizePolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizePolicy()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QSizePolicy cpp_result = cppSelf->QWidget::sizePolicy();
    py_result = Shiboken::Converter<QSizePolicy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_stackUnder(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // stackUnder(QWidget*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::stackUnder(cpp_arg0);
    } else goto SbkQWidgetFunc_stackUnder_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_stackUnder_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.stackUnder", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_statusTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // statusTip()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWidget::statusTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_style(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // style()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QStyle * cpp_result = cppSelf->QWidget::style();
    py_result = Shiboken::Converter<QStyle* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_styleSheet(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // styleSheet()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWidget::styleSheet();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_tabletEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTabletEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTabletEvent* cpp_arg0 = Shiboken::Converter<QTabletEvent* >::toCpp(arg);
        // tabletEvent(QTabletEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::tabletEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_tabletEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_tabletEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTabletEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.tabletEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_testAttribute(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::WidgetAttribute >::isConvertible(arg)) {
        Qt::WidgetAttribute cpp_arg0 = Shiboken::Converter<Qt::WidgetAttribute >::toCpp(arg);
        // testAttribute(Qt::WidgetAttribute)const
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWidget::testAttribute(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQWidgetFunc_testAttribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWidgetFunc_testAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.WidgetAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.testAttribute", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_toolTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toolTip()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWidget::toolTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_underMouse(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // underMouse()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::underMouse();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_ungrabGesture(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::GestureType >::isConvertible(arg)) {
        Qt::GestureType cpp_arg0 = Shiboken::Converter<Qt::GestureType >::toCpp(arg);
        // ungrabGesture(Qt::GestureType)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::ungrabGesture(cpp_arg0);
    } else goto SbkQWidgetFunc_ungrabGesture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_ungrabGesture_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.GestureType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.ungrabGesture", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_unsetCursor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // unsetCursor()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::unsetCursor();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_unsetLayoutDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // unsetLayoutDirection()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::unsetLayoutDirection();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_unsetLocale(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // unsetLocale()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::unsetLocale();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_update(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQWidgetFunc_update_TypeError;

    if (!PyArg_UnpackTuple(args, "update", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 0) {
        // update()
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::update();
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // update(int,int,int,int)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::update(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (numArgs == 1 && Shiboken::Converter<QRect& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // update(QRect)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::update(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QRegion& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRegion& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // update(QRegion)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::update(*cpp_arg0);
    } else goto SbkQWidgetFunc_update_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_update_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QRect", "PySide.QtGui.QRegion", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWidget.update", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_updateGeometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateGeometry()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::updateGeometry();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_updateMicroFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateMicroFocus()
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    cppSelf->QWidget::updateMicroFocus();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWidgetFunc_updatesEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // updatesEnabled()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWidget::updatesEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_visibleRegion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // visibleRegion()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QRegion cpp_result = cppSelf->QWidget::visibleRegion();
    py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_whatsThis(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // whatsThis()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWidget::whatsThis();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWheelEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWheelEvent* cpp_arg0 = Shiboken::Converter<QWheelEvent* >::toCpp(arg);
        // wheelEvent(QWheelEvent*)
        QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
        cppSelf->QWidget::wheelEvent(cpp_arg0);
    } else goto SbkQWidgetFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWidgetFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWidget.wheelEvent", overloads);
        return 0;
}

static PyObject*
SbkQWidgetFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWidget::width();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_winId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // winId()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    WId cpp_result = cppSelf->QWidget::winId();
    py_result = Shiboken::Converter<unsigned long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_window(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // window()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QWidget::window();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_windowFilePath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowFilePath()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWidget::windowFilePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_windowFlags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowFlags()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QFlags<Qt::WindowType> cpp_result = cppSelf->QWidget::windowFlags();
    py_result = Shiboken::Converter<QFlags<Qt::WindowType> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_windowIcon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowIcon()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QIcon cpp_result = cppSelf->QWidget::windowIcon();
    py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_windowIconText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowIconText()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWidget::windowIconText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_windowModality(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowModality()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    Qt::WindowModality cpp_result = cppSelf->QWidget::windowModality();
    py_result = Shiboken::Converter<Qt::WindowModality >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_windowOpacity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowOpacity()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QWidget::windowOpacity();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_windowRole(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowRole()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWidget::windowRole();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_windowState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowState()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QFlags<Qt::WindowState> cpp_result = cppSelf->QWidget::windowState();
    py_result = Shiboken::Converter<QFlags<Qt::WindowState> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_windowTitle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowTitle()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWidget::windowTitle();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_windowType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // windowType()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    Qt::WindowType cpp_result = cppSelf->QWidget::windowType();
    py_result = Shiboken::Converter<Qt::WindowType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWidget::x();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_x11Info(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x11Info()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    const QX11Info & cpp_result = cppSelf->QWidget::x11Info();
    py_result = Shiboken::Converter<QX11Info& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_x11PictureHandle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x11PictureHandle()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    Qt::HANDLE cpp_result = cppSelf->QWidget::x11PictureHandle();
    py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWidgetFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QWidget* cppSelf = Shiboken::Converter<QWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWidget::y();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQWidget_methods[] = {
    {"acceptDrops", (PyCFunction)SbkQWidgetFunc_acceptDrops, METH_NOARGS},
    {"accessibleDescription", (PyCFunction)SbkQWidgetFunc_accessibleDescription, METH_NOARGS},
    {"accessibleName", (PyCFunction)SbkQWidgetFunc_accessibleName, METH_NOARGS},
    {"actionEvent", (PyCFunction)SbkQWidgetFunc_actionEvent, METH_O},
    {"actions", (PyCFunction)SbkQWidgetFunc_actions, METH_NOARGS},
    {"activateWindow", (PyCFunction)SbkQWidgetFunc_activateWindow, METH_NOARGS},
    {"addAction", (PyCFunction)SbkQWidgetFunc_addAction, METH_O},
    {"addActions", (PyCFunction)SbkQWidgetFunc_addActions, METH_O},
    {"adjustSize", (PyCFunction)SbkQWidgetFunc_adjustSize, METH_NOARGS},
    {"autoFillBackground", (PyCFunction)SbkQWidgetFunc_autoFillBackground, METH_NOARGS},
    {"backgroundRole", (PyCFunction)SbkQWidgetFunc_backgroundRole, METH_NOARGS},
    {"baseSize", (PyCFunction)SbkQWidgetFunc_baseSize, METH_NOARGS},
    {"changeEvent", (PyCFunction)SbkQWidgetFunc_changeEvent, METH_O},
    {"childAt", (PyCFunction)SbkQWidgetFunc_childAt, METH_VARARGS},
    {"childrenRect", (PyCFunction)SbkQWidgetFunc_childrenRect, METH_NOARGS},
    {"childrenRegion", (PyCFunction)SbkQWidgetFunc_childrenRegion, METH_NOARGS},
    {"clearFocus", (PyCFunction)SbkQWidgetFunc_clearFocus, METH_NOARGS},
    {"clearMask", (PyCFunction)SbkQWidgetFunc_clearMask, METH_NOARGS},
    {"close", (PyCFunction)SbkQWidgetFunc_close, METH_NOARGS},
    {"closeEvent", (PyCFunction)SbkQWidgetFunc_closeEvent, METH_O},
    {"contentsMargins", (PyCFunction)SbkQWidgetFunc_contentsMargins, METH_NOARGS},
    {"contentsRect", (PyCFunction)SbkQWidgetFunc_contentsRect, METH_NOARGS},
    {"contextMenuEvent", (PyCFunction)SbkQWidgetFunc_contextMenuEvent, METH_O},
    {"contextMenuPolicy", (PyCFunction)SbkQWidgetFunc_contextMenuPolicy, METH_NOARGS},
    {"createWinId", (PyCFunction)SbkQWidgetFunc_createWinId, METH_NOARGS},
    {"cursor", (PyCFunction)SbkQWidgetFunc_cursor, METH_NOARGS},
    {"destroy", (PyCFunction)SbkQWidgetFunc_destroy, METH_VARARGS},
    {"devType", (PyCFunction)SbkQWidgetFunc_devType, METH_NOARGS},
    {"dragEnterEvent", (PyCFunction)SbkQWidgetFunc_dragEnterEvent, METH_O},
    {"dragLeaveEvent", (PyCFunction)SbkQWidgetFunc_dragLeaveEvent, METH_O},
    {"dragMoveEvent", (PyCFunction)SbkQWidgetFunc_dragMoveEvent, METH_O},
    {"dropEvent", (PyCFunction)SbkQWidgetFunc_dropEvent, METH_O},
    {"effectiveWinId", (PyCFunction)SbkQWidgetFunc_effectiveWinId, METH_NOARGS},
    {"ensurePolished", (PyCFunction)SbkQWidgetFunc_ensurePolished, METH_NOARGS},
    {"enterEvent", (PyCFunction)SbkQWidgetFunc_enterEvent, METH_O},
    {"event", (PyCFunction)SbkQWidgetFunc_event, METH_O},
    {"focusInEvent", (PyCFunction)SbkQWidgetFunc_focusInEvent, METH_O},
    {"focusNextChild", (PyCFunction)SbkQWidgetFunc_focusNextChild, METH_NOARGS},
    {"focusNextPrevChild", (PyCFunction)SbkQWidgetFunc_focusNextPrevChild, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQWidgetFunc_focusOutEvent, METH_O},
    {"focusPolicy", (PyCFunction)SbkQWidgetFunc_focusPolicy, METH_NOARGS},
    {"focusPreviousChild", (PyCFunction)SbkQWidgetFunc_focusPreviousChild, METH_NOARGS},
    {"focusProxy", (PyCFunction)SbkQWidgetFunc_focusProxy, METH_NOARGS},
    {"focusWidget", (PyCFunction)SbkQWidgetFunc_focusWidget, METH_NOARGS},
    {"font", (PyCFunction)SbkQWidgetFunc_font, METH_NOARGS},
    {"foregroundRole", (PyCFunction)SbkQWidgetFunc_foregroundRole, METH_NOARGS},
    {"frameGeometry", (PyCFunction)SbkQWidgetFunc_frameGeometry, METH_NOARGS},
    {"frameSize", (PyCFunction)SbkQWidgetFunc_frameSize, METH_NOARGS},
    {"geometry", (PyCFunction)SbkQWidgetFunc_geometry, METH_NOARGS},
    {"grabGesture", (PyCFunction)SbkQWidgetFunc_grabGesture, METH_VARARGS},
    {"grabKeyboard", (PyCFunction)SbkQWidgetFunc_grabKeyboard, METH_NOARGS},
    {"grabMouse", (PyCFunction)SbkQWidgetFunc_grabMouse, METH_NOARGS|METH_O},
    {"grabShortcut", (PyCFunction)SbkQWidgetFunc_grabShortcut, METH_VARARGS},
    {"graphicsEffect", (PyCFunction)SbkQWidgetFunc_graphicsEffect, METH_NOARGS},
    {"graphicsProxyWidget", (PyCFunction)SbkQWidgetFunc_graphicsProxyWidget, METH_NOARGS},
    {"hasFocus", (PyCFunction)SbkQWidgetFunc_hasFocus, METH_NOARGS},
    {"hasMouseTracking", (PyCFunction)SbkQWidgetFunc_hasMouseTracking, METH_NOARGS},
    {"height", (PyCFunction)SbkQWidgetFunc_height, METH_NOARGS},
    {"heightForWidth", (PyCFunction)SbkQWidgetFunc_heightForWidth, METH_O},
    {"hide", (PyCFunction)SbkQWidgetFunc_hide, METH_NOARGS},
    {"hideEvent", (PyCFunction)SbkQWidgetFunc_hideEvent, METH_O},
    {"inputContext", (PyCFunction)SbkQWidgetFunc_inputContext, METH_NOARGS},
    {"inputMethodEvent", (PyCFunction)SbkQWidgetFunc_inputMethodEvent, METH_O},
    {"inputMethodHints", (PyCFunction)SbkQWidgetFunc_inputMethodHints, METH_NOARGS},
    {"inputMethodQuery", (PyCFunction)SbkQWidgetFunc_inputMethodQuery, METH_O},
    {"insertAction", (PyCFunction)SbkQWidgetFunc_insertAction, METH_VARARGS},
    {"insertActions", (PyCFunction)SbkQWidgetFunc_insertActions, METH_VARARGS},
    {"isActiveWindow", (PyCFunction)SbkQWidgetFunc_isActiveWindow, METH_NOARGS},
    {"isAncestorOf", (PyCFunction)SbkQWidgetFunc_isAncestorOf, METH_O},
    {"isEnabled", (PyCFunction)SbkQWidgetFunc_isEnabled, METH_NOARGS},
    {"isEnabledTo", (PyCFunction)SbkQWidgetFunc_isEnabledTo, METH_O},
    {"isFullScreen", (PyCFunction)SbkQWidgetFunc_isFullScreen, METH_NOARGS},
    {"isHidden", (PyCFunction)SbkQWidgetFunc_isHidden, METH_NOARGS},
    {"isLeftToRight", (PyCFunction)SbkQWidgetFunc_isLeftToRight, METH_NOARGS},
    {"isMaximized", (PyCFunction)SbkQWidgetFunc_isMaximized, METH_NOARGS},
    {"isMinimized", (PyCFunction)SbkQWidgetFunc_isMinimized, METH_NOARGS},
    {"isModal", (PyCFunction)SbkQWidgetFunc_isModal, METH_NOARGS},
    {"isRightToLeft", (PyCFunction)SbkQWidgetFunc_isRightToLeft, METH_NOARGS},
    {"isVisible", (PyCFunction)SbkQWidgetFunc_isVisible, METH_NOARGS},
    {"isVisibleTo", (PyCFunction)SbkQWidgetFunc_isVisibleTo, METH_O},
    {"isWindow", (PyCFunction)SbkQWidgetFunc_isWindow, METH_NOARGS},
    {"isWindowModified", (PyCFunction)SbkQWidgetFunc_isWindowModified, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQWidgetFunc_keyPressEvent, METH_O},
    {"keyReleaseEvent", (PyCFunction)SbkQWidgetFunc_keyReleaseEvent, METH_O},
    {"keyboardGrabber", (PyCFunction)SbkQWidgetFunc_keyboardGrabber, METH_NOARGS|METH_STATIC},
    {"languageChange", (PyCFunction)SbkQWidgetFunc_languageChange, METH_NOARGS},
    {"layout", (PyCFunction)SbkQWidgetFunc_layout, METH_NOARGS},
    {"layoutDirection", (PyCFunction)SbkQWidgetFunc_layoutDirection, METH_NOARGS},
    {"leaveEvent", (PyCFunction)SbkQWidgetFunc_leaveEvent, METH_O},
    {"locale", (PyCFunction)SbkQWidgetFunc_locale, METH_NOARGS},
    {"lower", (PyCFunction)SbkQWidgetFunc_lower, METH_NOARGS},
    {"mapFrom", (PyCFunction)SbkQWidgetFunc_mapFrom, METH_VARARGS},
    {"mapFromGlobal", (PyCFunction)SbkQWidgetFunc_mapFromGlobal, METH_O},
    {"mapFromParent", (PyCFunction)SbkQWidgetFunc_mapFromParent, METH_O},
    {"mapTo", (PyCFunction)SbkQWidgetFunc_mapTo, METH_VARARGS},
    {"mapToGlobal", (PyCFunction)SbkQWidgetFunc_mapToGlobal, METH_O},
    {"mapToParent", (PyCFunction)SbkQWidgetFunc_mapToParent, METH_O},
    {"mask", (PyCFunction)SbkQWidgetFunc_mask, METH_NOARGS},
    {"maximumHeight", (PyCFunction)SbkQWidgetFunc_maximumHeight, METH_NOARGS},
    {"maximumSize", (PyCFunction)SbkQWidgetFunc_maximumSize, METH_NOARGS},
    {"maximumWidth", (PyCFunction)SbkQWidgetFunc_maximumWidth, METH_NOARGS},
    {"metric", (PyCFunction)SbkQWidgetFunc_metric, METH_O},
    {"minimumHeight", (PyCFunction)SbkQWidgetFunc_minimumHeight, METH_NOARGS},
    {"minimumSize", (PyCFunction)SbkQWidgetFunc_minimumSize, METH_NOARGS},
    {"minimumSizeHint", (PyCFunction)SbkQWidgetFunc_minimumSizeHint, METH_NOARGS},
    {"minimumWidth", (PyCFunction)SbkQWidgetFunc_minimumWidth, METH_NOARGS},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQWidgetFunc_mouseDoubleClickEvent, METH_O},
    {"mouseGrabber", (PyCFunction)SbkQWidgetFunc_mouseGrabber, METH_NOARGS|METH_STATIC},
    {"mouseMoveEvent", (PyCFunction)SbkQWidgetFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQWidgetFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQWidgetFunc_mouseReleaseEvent, METH_O},
    {"move", (PyCFunction)SbkQWidgetFunc_move, METH_VARARGS},
    {"moveEvent", (PyCFunction)SbkQWidgetFunc_moveEvent, METH_O},
    {"nativeParentWidget", (PyCFunction)SbkQWidgetFunc_nativeParentWidget, METH_NOARGS},
    {"nextInFocusChain", (PyCFunction)SbkQWidgetFunc_nextInFocusChain, METH_NOARGS},
    {"normalGeometry", (PyCFunction)SbkQWidgetFunc_normalGeometry, METH_NOARGS},
    {"overrideWindowFlags", (PyCFunction)SbkQWidgetFunc_overrideWindowFlags, METH_O},
    {"overrideWindowState", (PyCFunction)SbkQWidgetFunc_overrideWindowState, METH_O},
    {"paintEngine", (PyCFunction)SbkQWidgetFunc_paintEngine, METH_NOARGS},
    {"paintEvent", (PyCFunction)SbkQWidgetFunc_paintEvent, METH_O},
    {"palette", (PyCFunction)SbkQWidgetFunc_palette, METH_NOARGS},
    {"parentWidget", (PyCFunction)SbkQWidgetFunc_parentWidget, METH_NOARGS},
    {"pos", (PyCFunction)SbkQWidgetFunc_pos, METH_NOARGS},
    {"previousInFocusChain", (PyCFunction)SbkQWidgetFunc_previousInFocusChain, METH_NOARGS},
    {"raise_", (PyCFunction)SbkQWidgetFunc_raise_, METH_NOARGS},
    {"rect", (PyCFunction)SbkQWidgetFunc_rect, METH_NOARGS},
    {"releaseKeyboard", (PyCFunction)SbkQWidgetFunc_releaseKeyboard, METH_NOARGS},
    {"releaseMouse", (PyCFunction)SbkQWidgetFunc_releaseMouse, METH_NOARGS},
    {"releaseShortcut", (PyCFunction)SbkQWidgetFunc_releaseShortcut, METH_O},
    {"removeAction", (PyCFunction)SbkQWidgetFunc_removeAction, METH_O},
    {"render", (PyCFunction)SbkQWidgetFunc_render, METH_VARARGS},
    {"repaint", (PyCFunction)SbkQWidgetFunc_repaint, METH_VARARGS},
    {"resetInputContext", (PyCFunction)SbkQWidgetFunc_resetInputContext, METH_NOARGS},
    {"resize", (PyCFunction)SbkQWidgetFunc_resize, METH_VARARGS},
    {"resizeEvent", (PyCFunction)SbkQWidgetFunc_resizeEvent, METH_O},
    {"restoreGeometry", (PyCFunction)SbkQWidgetFunc_restoreGeometry, METH_O},
    {"saveGeometry", (PyCFunction)SbkQWidgetFunc_saveGeometry, METH_NOARGS},
    {"scroll", (PyCFunction)SbkQWidgetFunc_scroll, METH_VARARGS},
    {"setAcceptDrops", (PyCFunction)SbkQWidgetFunc_setAcceptDrops, METH_O},
    {"setAccessibleDescription", (PyCFunction)SbkQWidgetFunc_setAccessibleDescription, METH_O},
    {"setAccessibleName", (PyCFunction)SbkQWidgetFunc_setAccessibleName, METH_O},
    {"setAttribute", (PyCFunction)SbkQWidgetFunc_setAttribute, METH_VARARGS},
    {"setAutoFillBackground", (PyCFunction)SbkQWidgetFunc_setAutoFillBackground, METH_O},
    {"setBackgroundRole", (PyCFunction)SbkQWidgetFunc_setBackgroundRole, METH_O},
    {"setBaseSize", (PyCFunction)SbkQWidgetFunc_setBaseSize, METH_VARARGS},
    {"setContentsMargins", (PyCFunction)SbkQWidgetFunc_setContentsMargins, METH_VARARGS},
    {"setContextMenuPolicy", (PyCFunction)SbkQWidgetFunc_setContextMenuPolicy, METH_O},
    {"setCursor", (PyCFunction)SbkQWidgetFunc_setCursor, METH_O},
    {"setDisabled", (PyCFunction)SbkQWidgetFunc_setDisabled, METH_O},
    {"setEnabled", (PyCFunction)SbkQWidgetFunc_setEnabled, METH_O},
    {"setFixedHeight", (PyCFunction)SbkQWidgetFunc_setFixedHeight, METH_O},
    {"setFixedSize", (PyCFunction)SbkQWidgetFunc_setFixedSize, METH_VARARGS},
    {"setFixedWidth", (PyCFunction)SbkQWidgetFunc_setFixedWidth, METH_O},
    {"setFocus", (PyCFunction)SbkQWidgetFunc_setFocus, METH_NOARGS|METH_O},
    {"setFocusPolicy", (PyCFunction)SbkQWidgetFunc_setFocusPolicy, METH_O},
    {"setFocusProxy", (PyCFunction)SbkQWidgetFunc_setFocusProxy, METH_O},
    {"setFont", (PyCFunction)SbkQWidgetFunc_setFont, METH_O},
    {"setForegroundRole", (PyCFunction)SbkQWidgetFunc_setForegroundRole, METH_O},
    {"setGeometry", (PyCFunction)SbkQWidgetFunc_setGeometry, METH_VARARGS},
    {"setGraphicsEffect", (PyCFunction)SbkQWidgetFunc_setGraphicsEffect, METH_O},
    {"setHidden", (PyCFunction)SbkQWidgetFunc_setHidden, METH_O},
    {"setInputContext", (PyCFunction)SbkQWidgetFunc_setInputContext, METH_O},
    {"setInputMethodHints", (PyCFunction)SbkQWidgetFunc_setInputMethodHints, METH_O},
    {"setLayout", (PyCFunction)SbkQWidgetFunc_setLayout, METH_O},
    {"setLayoutDirection", (PyCFunction)SbkQWidgetFunc_setLayoutDirection, METH_O},
    {"setLocale", (PyCFunction)SbkQWidgetFunc_setLocale, METH_O},
    {"setMask", (PyCFunction)SbkQWidgetFunc_setMask, METH_O},
    {"setMaximumHeight", (PyCFunction)SbkQWidgetFunc_setMaximumHeight, METH_O},
    {"setMaximumSize", (PyCFunction)SbkQWidgetFunc_setMaximumSize, METH_VARARGS},
    {"setMaximumWidth", (PyCFunction)SbkQWidgetFunc_setMaximumWidth, METH_O},
    {"setMinimumHeight", (PyCFunction)SbkQWidgetFunc_setMinimumHeight, METH_O},
    {"setMinimumSize", (PyCFunction)SbkQWidgetFunc_setMinimumSize, METH_VARARGS},
    {"setMinimumWidth", (PyCFunction)SbkQWidgetFunc_setMinimumWidth, METH_O},
    {"setMouseTracking", (PyCFunction)SbkQWidgetFunc_setMouseTracking, METH_O},
    {"setPalette", (PyCFunction)SbkQWidgetFunc_setPalette, METH_O},
    {"setParent", (PyCFunction)SbkQWidgetFunc_setParent, METH_VARARGS},
    {"setShortcutAutoRepeat", (PyCFunction)SbkQWidgetFunc_setShortcutAutoRepeat, METH_VARARGS},
    {"setShortcutEnabled", (PyCFunction)SbkQWidgetFunc_setShortcutEnabled, METH_VARARGS},
    {"setSizeIncrement", (PyCFunction)SbkQWidgetFunc_setSizeIncrement, METH_VARARGS},
    {"setSizePolicy", (PyCFunction)SbkQWidgetFunc_setSizePolicy, METH_VARARGS},
    {"setStatusTip", (PyCFunction)SbkQWidgetFunc_setStatusTip, METH_O},
    {"setStyle", (PyCFunction)SbkQWidgetFunc_setStyle, METH_O},
    {"setStyleSheet", (PyCFunction)SbkQWidgetFunc_setStyleSheet, METH_O},
    {"setTabOrder", (PyCFunction)SbkQWidgetFunc_setTabOrder, METH_VARARGS|METH_STATIC},
    {"setToolTip", (PyCFunction)SbkQWidgetFunc_setToolTip, METH_O},
    {"setUpdatesEnabled", (PyCFunction)SbkQWidgetFunc_setUpdatesEnabled, METH_O},
    {"setVisible", (PyCFunction)SbkQWidgetFunc_setVisible, METH_O},
    {"setWhatsThis", (PyCFunction)SbkQWidgetFunc_setWhatsThis, METH_O},
    {"setWindowFilePath", (PyCFunction)SbkQWidgetFunc_setWindowFilePath, METH_O},
    {"setWindowFlags", (PyCFunction)SbkQWidgetFunc_setWindowFlags, METH_O},
    {"setWindowIcon", (PyCFunction)SbkQWidgetFunc_setWindowIcon, METH_O},
    {"setWindowIconText", (PyCFunction)SbkQWidgetFunc_setWindowIconText, METH_O},
    {"setWindowModality", (PyCFunction)SbkQWidgetFunc_setWindowModality, METH_O},
    {"setWindowModified", (PyCFunction)SbkQWidgetFunc_setWindowModified, METH_O},
    {"setWindowOpacity", (PyCFunction)SbkQWidgetFunc_setWindowOpacity, METH_O},
    {"setWindowRole", (PyCFunction)SbkQWidgetFunc_setWindowRole, METH_O},
    {"setWindowState", (PyCFunction)SbkQWidgetFunc_setWindowState, METH_O},
    {"setWindowTitle", (PyCFunction)SbkQWidgetFunc_setWindowTitle, METH_O},
    {"show", (PyCFunction)SbkQWidgetFunc_show, METH_NOARGS},
    {"showEvent", (PyCFunction)SbkQWidgetFunc_showEvent, METH_O},
    {"showFullScreen", (PyCFunction)SbkQWidgetFunc_showFullScreen, METH_NOARGS},
    {"showMaximized", (PyCFunction)SbkQWidgetFunc_showMaximized, METH_NOARGS},
    {"showMinimized", (PyCFunction)SbkQWidgetFunc_showMinimized, METH_NOARGS},
    {"showNormal", (PyCFunction)SbkQWidgetFunc_showNormal, METH_NOARGS},
    {"size", (PyCFunction)SbkQWidgetFunc_size, METH_NOARGS},
    {"sizeHint", (PyCFunction)SbkQWidgetFunc_sizeHint, METH_NOARGS},
    {"sizeIncrement", (PyCFunction)SbkQWidgetFunc_sizeIncrement, METH_NOARGS},
    {"sizePolicy", (PyCFunction)SbkQWidgetFunc_sizePolicy, METH_NOARGS},
    {"stackUnder", (PyCFunction)SbkQWidgetFunc_stackUnder, METH_O},
    {"statusTip", (PyCFunction)SbkQWidgetFunc_statusTip, METH_NOARGS},
    {"style", (PyCFunction)SbkQWidgetFunc_style, METH_NOARGS},
    {"styleSheet", (PyCFunction)SbkQWidgetFunc_styleSheet, METH_NOARGS},
    {"tabletEvent", (PyCFunction)SbkQWidgetFunc_tabletEvent, METH_O},
    {"testAttribute", (PyCFunction)SbkQWidgetFunc_testAttribute, METH_O},
    {"toolTip", (PyCFunction)SbkQWidgetFunc_toolTip, METH_NOARGS},
    {"underMouse", (PyCFunction)SbkQWidgetFunc_underMouse, METH_NOARGS},
    {"ungrabGesture", (PyCFunction)SbkQWidgetFunc_ungrabGesture, METH_O},
    {"unsetCursor", (PyCFunction)SbkQWidgetFunc_unsetCursor, METH_NOARGS},
    {"unsetLayoutDirection", (PyCFunction)SbkQWidgetFunc_unsetLayoutDirection, METH_NOARGS},
    {"unsetLocale", (PyCFunction)SbkQWidgetFunc_unsetLocale, METH_NOARGS},
    {"update", (PyCFunction)SbkQWidgetFunc_update, METH_VARARGS},
    {"updateGeometry", (PyCFunction)SbkQWidgetFunc_updateGeometry, METH_NOARGS},
    {"updateMicroFocus", (PyCFunction)SbkQWidgetFunc_updateMicroFocus, METH_NOARGS},
    {"updatesEnabled", (PyCFunction)SbkQWidgetFunc_updatesEnabled, METH_NOARGS},
    {"visibleRegion", (PyCFunction)SbkQWidgetFunc_visibleRegion, METH_NOARGS},
    {"whatsThis", (PyCFunction)SbkQWidgetFunc_whatsThis, METH_NOARGS},
    {"wheelEvent", (PyCFunction)SbkQWidgetFunc_wheelEvent, METH_O},
    {"width", (PyCFunction)SbkQWidgetFunc_width, METH_NOARGS},
    {"winId", (PyCFunction)SbkQWidgetFunc_winId, METH_NOARGS},
    {"window", (PyCFunction)SbkQWidgetFunc_window, METH_NOARGS},
    {"windowFilePath", (PyCFunction)SbkQWidgetFunc_windowFilePath, METH_NOARGS},
    {"windowFlags", (PyCFunction)SbkQWidgetFunc_windowFlags, METH_NOARGS},
    {"windowIcon", (PyCFunction)SbkQWidgetFunc_windowIcon, METH_NOARGS},
    {"windowIconText", (PyCFunction)SbkQWidgetFunc_windowIconText, METH_NOARGS},
    {"windowModality", (PyCFunction)SbkQWidgetFunc_windowModality, METH_NOARGS},
    {"windowOpacity", (PyCFunction)SbkQWidgetFunc_windowOpacity, METH_NOARGS},
    {"windowRole", (PyCFunction)SbkQWidgetFunc_windowRole, METH_NOARGS},
    {"windowState", (PyCFunction)SbkQWidgetFunc_windowState, METH_NOARGS},
    {"windowTitle", (PyCFunction)SbkQWidgetFunc_windowTitle, METH_NOARGS},
    {"windowType", (PyCFunction)SbkQWidgetFunc_windowType, METH_NOARGS},
    {"x", (PyCFunction)SbkQWidgetFunc_x, METH_NOARGS},
    {"x11Info", (PyCFunction)SbkQWidgetFunc_x11Info, METH_NOARGS},
    {"x11PictureHandle", (PyCFunction)SbkQWidgetFunc_x11PictureHandle, METH_NOARGS},
    {"y", (PyCFunction)SbkQWidgetFunc_y, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static int mi_offsets[] = { -1, -1, -1, -1, -1 };
int*
SbkQWidget_mi_init(const void* cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        std::set<int>::iterator it;
        const QWidget* class_ptr = reinterpret_cast<const QWidget*>(cptr);
        size_t base = (size_t) class_ptr;
        offsets.insert(((size_t) static_cast<const QObject*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QObject*>((QWidget*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QPaintDevice*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QPaintDevice*>((QWidget*)((void*)class_ptr))) - base);

        offsets.erase(0);

        int i = 0;
        for (it = offsets.begin(); it != offsets.end(); it++) {
            mi_offsets[i] = *it;
            i++;
        }
    }
    return mi_offsets;
}
static void* SbkQWidgetSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QWidget* me = reinterpret_cast<QWidget*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWidget_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QWidget",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QWidgetWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWidget_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWidget_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             SbkQWidget_mi_init,
    /*mi_specialcast*/      &SbkQWidgetSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

PyObject*
SbkPySide_QtGui_QWidget_RenderFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWidget::RenderFlags >::toPython(
        ((QWidget::RenderFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QWidget::RenderFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QWidget_RenderFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWidget::RenderFlags >::toPython(
        ((QWidget::RenderFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QWidget::RenderFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QWidget_RenderFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWidget::RenderFlags >::toPython(
        ((QWidget::RenderFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QWidget::RenderFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QWidget_RenderFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWidget::RenderFlags >::toPython(
        ~ Shiboken::Converter< QWidget::RenderFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QWidget_RenderFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QWidget_RenderFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QWidget_RenderFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QWidget_RenderFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QWidget_RenderFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QWidget_RenderFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QWidget_RenderFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QWidget_RenderFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RenderFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QWidget_RenderFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QWidget_RenderFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QWidget_RenderFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QWidget_RenderFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QWidget_RenderFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QWidget_RenderFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RenderFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QWidget_RenderFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QWidget_RenderFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QWidget_RenderFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QWidget_RenderFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void)
init_QWidget(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWidget_Type);

    SbkQWidget_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX];
    SbkQWidget_Type.super.ht_type.tp_bases = PyTuple_Pack(2,
        (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX], (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]);

    // Fill type discovery information
    SbkQWidget_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQWidget_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWidget_Type));
    PyModule_AddObject(module, "QWidget",
        ((PyObject*)&SbkQWidget_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: RenderFlag
    SbkPySide_QtGuiTypes[SBK_QWIDGET_RENDERFLAG_IDX] = &SbkPySide_QtGui_QWidget_RenderFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QWidget_RenderFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QWidget_RenderFlag_Type);
    PyDict_SetItemString(SbkQWidget_Type.super.ht_type.tp_dict,
            "RenderFlag",((PyObject*)&SbkPySide_QtGui_QWidget_RenderFlag_Type));

    // init flags class: QFlags<QWidget::RenderFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QWIDGET_RENDERFLAG__IDX] = &SbkPySide_QtGui_QWidget_RenderFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QWidget_RenderFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QWidget_RenderFlags_Type);
    PyDict_SetItemString(SbkQWidget_Type.super.ht_type.tp_dict,
            "RenderFlags",((PyObject*)&SbkPySide_QtGui_QWidget_RenderFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWidget_RenderFlag_Type,
        (long) QWidget::DrawWindowBackground, "DrawWindowBackground");
    PyDict_SetItemString(SbkQWidget_Type.super.ht_type.tp_dict,
        "DrawWindowBackground", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWidget_RenderFlag_Type.tp_dict,
        "DrawWindowBackground", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWidget_RenderFlag_Type,
        (long) QWidget::DrawChildren, "DrawChildren");
    PyDict_SetItemString(SbkQWidget_Type.super.ht_type.tp_dict,
        "DrawChildren", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWidget_RenderFlag_Type.tp_dict,
        "DrawChildren", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWidget_RenderFlag_Type,
        (long) QWidget::IgnoreMask, "IgnoreMask");
    PyDict_SetItemString(SbkQWidget_Type.super.ht_type.tp_dict,
        "IgnoreMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWidget_RenderFlag_Type.tp_dict,
        "IgnoreMask", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWidget::RenderFlag");

    Shiboken::TypeResolver::createObjectTypeResolver<QWidget >("QWidget*");
    Shiboken::TypeResolver::createObjectTypeResolver<QWidget >(typeid(QWidget).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

