/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qwhatsthis_wrapper.h"

// Extra includes
#include <qaction.h>
#include <qobject.h>
#include <qpoint.h>
#include <qstring.h>
#include <qwidget.h>

using namespace Shiboken;

static PyObject*
SbkQWhatsThisFunc_createAction(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // createAction(QObject*)
        QAction * cpp_result = QWhatsThis::createAction();
        py_result = Shiboken::Converter<QAction* >::toPython(cpp_result);
    } else if (Shiboken::Converter<QObject* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // createAction(QObject*)
        QAction * cpp_result = QWhatsThis::createAction(cpp_arg0);
        py_result = Shiboken::Converter<QAction* >::toPython(cpp_result);
    } else goto SbkQWhatsThisFunc_createAction_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQWhatsThisFunc_createAction_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWhatsThis.createAction", overloads);
        return 0;
}

static PyObject*
SbkQWhatsThisFunc_enterWhatsThisMode(PyObject* self)
{

    // enterWhatsThisMode()
    QWhatsThis::enterWhatsThisMode();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWhatsThisFunc_hideText(PyObject* self)
{

    // hideText()
    QWhatsThis::hideText();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWhatsThisFunc_inWhatsThisMode(PyObject* self)
{
    PyObject* py_result = 0;

    // inWhatsThisMode()
    bool cpp_result = QWhatsThis::inWhatsThisMode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQWhatsThisFunc_leaveWhatsThisMode(PyObject* self)
{

    // leaveWhatsThisMode()
    QWhatsThis::leaveWhatsThisMode();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQWhatsThisFunc_showText(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "showText", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // showText(QPoint,QString,QWidget*)
            QWhatsThis::showText(*cpp_arg0, *cpp_arg1);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            // showText(QPoint,QString,QWidget*)
            QWhatsThis::showText(*cpp_arg0, *cpp_arg1, cpp_arg2);
        } else goto SbkQWhatsThisFunc_showText_TypeError;
    } else goto SbkQWhatsThisFunc_showText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWhatsThisFunc_showText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.QString, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWhatsThis.showText", overloads);
        return 0;
}

static PyMethodDef SbkQWhatsThis_methods[] = {
    {"createAction", (PyCFunction)SbkQWhatsThisFunc_createAction, METH_NOARGS|METH_O|METH_STATIC},
    {"enterWhatsThisMode", (PyCFunction)SbkQWhatsThisFunc_enterWhatsThisMode, METH_NOARGS|METH_STATIC},
    {"hideText", (PyCFunction)SbkQWhatsThisFunc_hideText, METH_NOARGS|METH_STATIC},
    {"inWhatsThisMode", (PyCFunction)SbkQWhatsThisFunc_inWhatsThisMode, METH_NOARGS|METH_STATIC},
    {"leaveWhatsThisMode", (PyCFunction)SbkQWhatsThisFunc_leaveWhatsThisMode, METH_NOARGS|METH_STATIC},
    {"showText", (PyCFunction)SbkQWhatsThisFunc_showText, METH_VARARGS|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWhatsThis_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QWhatsThis",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QWhatsThis >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWhatsThis_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QWhatsThis(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QWHATSTHIS_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWhatsThis_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQWhatsThis_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWhatsThis_Type));
    PyModule_AddObject(module, "QWhatsThis",
        ((PyObject*)&SbkQWhatsThis_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QWhatsThis >("QWhatsThis*");
    Shiboken::TypeResolver::createObjectTypeResolver<QWhatsThis >(typeid(QWhatsThis).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

