/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextobjectinterface_wrapper.h"

// Extra includes
#include <qpainter.h>
#include <qrect.h>
#include <qsize.h>
#include <qtextdocument.h>
#include <qtextformat.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextObjectInterfaceWrapper::QTextObjectInterfaceWrapper() : QTextObjectInterface() {
    // ... middle
}

void QTextObjectInterfaceWrapper::drawObject(QPainter * painter, const QRectF & rect, QTextDocument * doc, int posInDocument, const QTextFormat & format)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawObject"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextObjectInterface.drawObject()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOiO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRectF& >::toPython(rect),
        Shiboken::Converter<QTextDocument* >::toPython(doc),
        posInDocument,
        Shiboken::Converter<QTextFormat& >::toPython(format)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSizeF QTextObjectInterfaceWrapper::intrinsicSize(QTextDocument * doc, int posInDocument, const QTextFormat & format)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "intrinsicSize"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextObjectInterface.intrinsicSize()' not implemented.");
        return QSizeF();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiO)",
        Shiboken::Converter<QTextDocument* >::toPython(doc),
        posInDocument,
        Shiboken::Converter<QTextFormat& >::toPython(format)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSizeF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSizeF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTextObjectInterface.intrinsicSize");
        return QSizeF()        ;
    }
    QSizeF cpp_result(Shiboken::Converter<QSizeF >::toCpp(py_result));
    return cpp_result;
}

QTextObjectInterfaceWrapper::~QTextObjectInterfaceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTextObjectInterface_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextObjectInterfaceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QTEXTOBJECTINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QTextObjectInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QTextObjectInterface()
    cptr = new QTextObjectInterfaceWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQTextObjectInterfaceFunc_drawObject(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawObject", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]) && Shiboken::Converter<QTextDocument* >::isConvertible(pyargs[2]) && PyNumber_Check(pyargs[3]) && Shiboken::Converter<QTextFormat& >::isConvertible(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg1_auto_ptr;
        QRectF* cpp_arg1 = Shiboken::Converter<QRectF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QRectF >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QTextDocument* cpp_arg2 = Shiboken::Converter<QTextDocument* >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        QTextFormat* cpp_arg4 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[4]);
        // drawObject(QPainter*,QRectF,QTextDocument*,int,QTextFormat)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextObjectInterface.drawObject()' not implemented.");
            return 0;
        }
        QTextObjectInterface* cppSelf = Shiboken::Converter<QTextObjectInterface* >::toCpp((PyObject*)self);
        cppSelf->drawObject(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
    } else goto SbkQTextObjectInterfaceFunc_drawObject_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextObjectInterfaceFunc_drawObject_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRectF, PySide.QtGui.QTextDocument, int, PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextObjectInterface.drawObject", overloads);
        return 0;
}

static PyObject*
SbkQTextObjectInterfaceFunc_intrinsicSize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "intrinsicSize", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QTextDocument* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QTextFormat& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTextDocument* cpp_arg0 = Shiboken::Converter<QTextDocument* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QTextFormat* cpp_arg2 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[2]);
        // intrinsicSize(QTextDocument*,int,QTextFormat)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextObjectInterface.intrinsicSize()' not implemented.");
            return 0;
        }
        QTextObjectInterface* cppSelf = Shiboken::Converter<QTextObjectInterface* >::toCpp((PyObject*)self);
        QSizeF cpp_result = cppSelf->intrinsicSize(cpp_arg0, cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    } else goto SbkQTextObjectInterfaceFunc_intrinsicSize_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextObjectInterfaceFunc_intrinsicSize_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextDocument, int, PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextObjectInterface.intrinsicSize", overloads);
        return 0;
}

static PyMethodDef SbkQTextObjectInterface_methods[] = {
    {"drawObject", (PyCFunction)SbkQTextObjectInterfaceFunc_drawObject, METH_VARARGS},
    {"intrinsicSize", (PyCFunction)SbkQTextObjectInterfaceFunc_intrinsicSize, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextObjectInterface_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextObjectInterface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextObjectInterfaceWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextObjectInterface_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextObjectInterface_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQTextObjectInterface_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQTextObjectInterface_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QTextObjectInterface*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QTextObjectInterface(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTOBJECTINTERFACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextObjectInterface_Type);

    // Fill type discovery information
    SbkQTextObjectInterface_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQTextObjectInterface_Type.type_discovery->addTypeDiscoveryFunction(&SbkQTextObjectInterface_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQTextObjectInterface_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextObjectInterface_Type));
    PyModule_AddObject(module, "QTextObjectInterface",
        ((PyObject*)&SbkQTextObjectInterface_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QTextObjectInterface >("QTextObjectInterface*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTextObjectInterface >(typeid(QTextObjectInterface).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

