/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextcursor_wrapper.h"

// Extra includes
#include <QTextBlock>
#include <QTextDocumentFragment>
#include <qimage.h>
#include <qstring.h>
#include <qtextcursor.h>
#include <qtextdocument.h>
#include <qtextdocumentfragment.h>
#include <qtextformat.h>
#include <qtextlist.h>
#include <qtextobject.h>
#include <qtexttable.h>

using namespace Shiboken;

static int
SbkQTextCursor_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextCursor* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextCursor", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextCursor()
        cptr = new QTextCursor();
    } else if (numArgs == 1 && Shiboken::Converter<QTextCursor& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextCursor* cpp_arg0 = Shiboken::Converter<QTextCursor* >::toCpp(pyargs[0]);
        // QTextCursor(QTextCursor)
        cptr = new QTextCursor(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QTextBlock& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextBlock* cpp_arg0 = Shiboken::Converter<QTextBlock* >::toCpp(pyargs[0]);
        // QTextCursor(QTextBlock)
        cptr = new QTextCursor(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QTextFrame* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextFrame* cpp_arg0 = Shiboken::Converter<QTextFrame* >::toCpp(pyargs[0]);
        // QTextCursor(QTextFrame*)
        cptr = new QTextCursor(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QTextDocument* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextDocument* cpp_arg0 = Shiboken::Converter<QTextDocument* >::toCpp(pyargs[0]);
        // QTextCursor(QTextDocument*)
        cptr = new QTextCursor(cpp_arg0);
    } else goto SbkQTextCursor_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextCursor_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTextCursor_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextDocument", "PySide.QtGui.QTextFrame", "PySide.QtGui.QTextBlock", "PySide.QtGui.QTextCursor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextCursor", overloads);
        return -1;
}

static PyObject*
SbkQTextCursorFunc_anchor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // anchor()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextCursor::anchor();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_atBlockEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atBlockEnd()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCursor::atBlockEnd();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_atBlockStart(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atBlockStart()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCursor::atBlockStart();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_atEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atEnd()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCursor::atEnd();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_atStart(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atStart()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCursor::atStart();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_beginEditBlock(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // beginEditBlock()
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    cppSelf->QTextCursor::beginEditBlock();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextCursorFunc_block(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // block()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    QTextBlock cpp_result = cppSelf->QTextCursor::block();
    py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_blockCharFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blockCharFormat()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    QTextCharFormat cpp_result = cppSelf->QTextCursor::blockCharFormat();
    py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_blockFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blockFormat()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    QTextBlockFormat cpp_result = cppSelf->QTextCursor::blockFormat();
    py_result = Shiboken::Converter<QTextBlockFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_blockNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blockNumber()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextCursor::blockNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_charFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // charFormat()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    QTextCharFormat cpp_result = cppSelf->QTextCursor::charFormat();
    py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_clearSelection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearSelection()
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    cppSelf->QTextCursor::clearSelection();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextCursorFunc_columnNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnNumber()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextCursor::columnNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_createList(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextListFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextListFormat* cpp_arg0 = Shiboken::Converter<QTextListFormat* >::toCpp(arg);
        // createList(QTextListFormat)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        QTextList * cpp_result = cppSelf->QTextCursor::createList(*cpp_arg0);
        py_result = Shiboken::Converter<QTextList* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QTextListFormat::Style >::isConvertible(arg)) {
        QTextListFormat::Style cpp_arg0 = Shiboken::Converter<QTextListFormat::Style >::toCpp(arg);
        // createList(QTextListFormat::Style)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        QTextList * cpp_result = cppSelf->QTextCursor::createList(cpp_arg0);
        py_result = Shiboken::Converter<QTextList* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextCursorFunc_createList_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextCursorFunc_createList_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextListFormat.Style", "PySide.QtGui.QTextListFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.createList", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_currentFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentFrame()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    QTextFrame * cpp_result = cppSelf->QTextCursor::currentFrame();
    py_result = Shiboken::Converter<QTextFrame* >::toPython(cpp_result);

    // Ownership transferences.

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_currentList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentList()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    QTextList * cpp_result = cppSelf->QTextCursor::currentList();
    py_result = Shiboken::Converter<QTextList* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_currentTable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentTable()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    QTextTable * cpp_result = cppSelf->QTextCursor::currentTable();
    py_result = Shiboken::Converter<QTextTable* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_deleteChar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // deleteChar()
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    cppSelf->QTextCursor::deleteChar();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextCursorFunc_deletePreviousChar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // deletePreviousChar()
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    cppSelf->QTextCursor::deletePreviousChar();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextCursorFunc_document(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // document()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    QTextDocument * cpp_result = cppSelf->QTextCursor::document();
    py_result = Shiboken::Converter<QTextDocument* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_endEditBlock(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endEditBlock()
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    cppSelf->QTextCursor::endEditBlock();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextCursorFunc_hasComplexSelection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasComplexSelection()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCursor::hasComplexSelection();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_hasSelection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasSelection()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCursor::hasSelection();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_insertBlock(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertBlock", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // insertBlock()
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::insertBlock();
    } else if (Shiboken::Converter<QTextBlockFormat& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTextBlockFormat* cpp_arg0 = Shiboken::Converter<QTextBlockFormat* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // insertBlock(QTextBlockFormat)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            cppSelf->QTextCursor::insertBlock(*cpp_arg0);
        } else if (numArgs == 2 && Shiboken::Converter<QTextCharFormat& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QTextCharFormat* cpp_arg1 = Shiboken::Converter<QTextCharFormat* >::toCpp(pyargs[1]);
            // insertBlock(QTextBlockFormat,QTextCharFormat)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            cppSelf->QTextCursor::insertBlock(*cpp_arg0, *cpp_arg1);
        } else goto SbkQTextCursorFunc_insertBlock_TypeError;
    } else goto SbkQTextCursorFunc_insertBlock_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_insertBlock_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextBlockFormat", "PySide.QtGui.QTextBlockFormat, PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextCursor.insertBlock", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_insertFragment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextDocumentFragment& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextDocumentFragment* cpp_arg0 = Shiboken::Converter<QTextDocumentFragment* >::toCpp(arg);
        // insertFragment(QTextDocumentFragment)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::insertFragment(*cpp_arg0);
    } else goto SbkQTextCursorFunc_insertFragment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_insertFragment_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextDocumentFragment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.insertFragment", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_insertFrame(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextFrameFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextFrameFormat* cpp_arg0 = Shiboken::Converter<QTextFrameFormat* >::toCpp(arg);
        // insertFrame(QTextFrameFormat)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        QTextFrame * cpp_result = cppSelf->QTextCursor::insertFrame(*cpp_arg0);
        py_result = Shiboken::Converter<QTextFrame* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextCursorFunc_insertFrame_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextCursorFunc_insertFrame_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextFrameFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.insertFrame", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_insertHtml(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // insertHtml(QString)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::insertHtml(*cpp_arg0);
    } else goto SbkQTextCursorFunc_insertHtml_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_insertHtml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.insertHtml", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_insertImage(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertImage", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTextImageFormat& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTextImageFormat* cpp_arg0 = Shiboken::Converter<QTextImageFormat* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // insertImage(QTextImageFormat)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            cppSelf->QTextCursor::insertImage(*cpp_arg0);
        } else if (numArgs == 2 && Shiboken::Converter<QTextFrameFormat::Position >::isConvertible(pyargs[1])) {
            QTextFrameFormat::Position cpp_arg1 = Shiboken::Converter<QTextFrameFormat::Position >::toCpp(pyargs[1]);
            // insertImage(QTextImageFormat,QTextFrameFormat::Position)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            cppSelf->QTextCursor::insertImage(*cpp_arg0, cpp_arg1);
        } else goto SbkQTextCursorFunc_insertImage_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // insertImage(QString)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::insertImage(*cpp_arg0);
    } else if (Shiboken::Converter<QImage& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // insertImage(QImage,QString)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            cppSelf->QTextCursor::insertImage(*cpp_arg0);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // insertImage(QImage,QString)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            cppSelf->QTextCursor::insertImage(*cpp_arg0, *cpp_arg1);
        } else goto SbkQTextCursorFunc_insertImage_TypeError;
    } else goto SbkQTextCursorFunc_insertImage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_insertImage_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage, PySide.QtCore.QString = QString()", "PySide.QtCore.QString", "PySide.QtGui.QTextImageFormat", "PySide.QtGui.QTextImageFormat, PySide.QtGui.QTextFrameFormat.Position", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextCursor.insertImage", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_insertList(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextListFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextListFormat* cpp_arg0 = Shiboken::Converter<QTextListFormat* >::toCpp(arg);
        // insertList(QTextListFormat)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        QTextList * cpp_result = cppSelf->QTextCursor::insertList(*cpp_arg0);
        py_result = Shiboken::Converter<QTextList* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QTextListFormat::Style >::isConvertible(arg)) {
        QTextListFormat::Style cpp_arg0 = Shiboken::Converter<QTextListFormat::Style >::toCpp(arg);
        // insertList(QTextListFormat::Style)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        QTextList * cpp_result = cppSelf->QTextCursor::insertList(cpp_arg0);
        py_result = Shiboken::Converter<QTextList* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextCursorFunc_insertList_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextCursorFunc_insertList_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextListFormat.Style", "PySide.QtGui.QTextListFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.insertList", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_insertTable(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertTable", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // insertTable(int,int)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            QTextTable * cpp_result = cppSelf->QTextCursor::insertTable(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QTextTable* >::toPython(cpp_result);

            // Ownership transferences.
        } else if (numArgs == 3 && Shiboken::Converter<QTextTableFormat& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QTextTableFormat* cpp_arg2 = Shiboken::Converter<QTextTableFormat* >::toCpp(pyargs[2]);
            // insertTable(int,int,QTextTableFormat)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            QTextTable * cpp_result = cppSelf->QTextCursor::insertTable(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QTextTable* >::toPython(cpp_result);

            // Ownership transferences.
        } else goto SbkQTextCursorFunc_insertTable_TypeError;
    } else goto SbkQTextCursorFunc_insertTable_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextCursorFunc_insertTable_TypeError:
        const char* overloads[] = {"int, int", "int, int, PySide.QtGui.QTextTableFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextCursor.insertTable", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_insertText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertText", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // insertText(QString)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            cppSelf->QTextCursor::insertText(*cpp_arg0);
        } else if (numArgs == 2 && Shiboken::Converter<QTextCharFormat& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QTextCharFormat* cpp_arg1 = Shiboken::Converter<QTextCharFormat* >::toCpp(pyargs[1]);
            // insertText(QString,QTextCharFormat)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            cppSelf->QTextCursor::insertText(*cpp_arg0, *cpp_arg1);
        } else goto SbkQTextCursorFunc_insertText_TypeError;
    } else goto SbkQTextCursorFunc_insertText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_insertText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextCursor.insertText", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_isCopyOf(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextCursor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCursor* cpp_arg0 = Shiboken::Converter<QTextCursor* >::toCpp(arg);
        // isCopyOf(QTextCursor)const
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTextCursor::isCopyOf(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTextCursorFunc_isCopyOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextCursorFunc_isCopyOf_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCursor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.isCopyOf", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCursor::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_joinPreviousEditBlock(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // joinPreviousEditBlock()
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    cppSelf->QTextCursor::joinPreviousEditBlock();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextCursorFunc_mergeBlockCharFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCharFormat* cpp_arg0 = Shiboken::Converter<QTextCharFormat* >::toCpp(arg);
        // mergeBlockCharFormat(QTextCharFormat)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::mergeBlockCharFormat(*cpp_arg0);
    } else goto SbkQTextCursorFunc_mergeBlockCharFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_mergeBlockCharFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.mergeBlockCharFormat", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_mergeBlockFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextBlockFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextBlockFormat* cpp_arg0 = Shiboken::Converter<QTextBlockFormat* >::toCpp(arg);
        // mergeBlockFormat(QTextBlockFormat)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::mergeBlockFormat(*cpp_arg0);
    } else goto SbkQTextCursorFunc_mergeBlockFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_mergeBlockFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextBlockFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.mergeBlockFormat", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_mergeCharFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCharFormat* cpp_arg0 = Shiboken::Converter<QTextCharFormat* >::toCpp(arg);
        // mergeCharFormat(QTextCharFormat)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::mergeCharFormat(*cpp_arg0);
    } else goto SbkQTextCursorFunc_mergeCharFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_mergeCharFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.mergeCharFormat", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_movePosition(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "movePosition", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QTextCursor::MoveOperation >::isConvertible(pyargs[0])) {
        QTextCursor::MoveOperation cpp_arg0 = Shiboken::Converter<QTextCursor::MoveOperation >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // movePosition(QTextCursor::MoveOperation,QTextCursor::MoveMode,int)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QTextCursor::movePosition(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QTextCursor::MoveMode >::isConvertible(pyargs[1])) {
            QTextCursor::MoveMode cpp_arg1 = Shiboken::Converter<QTextCursor::MoveMode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // movePosition(QTextCursor::MoveOperation,QTextCursor::MoveMode,int)
                QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QTextCursor::movePosition(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // movePosition(QTextCursor::MoveOperation,QTextCursor::MoveMode,int)
                QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
                bool cpp_result = cppSelf->QTextCursor::movePosition(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else goto SbkQTextCursorFunc_movePosition_TypeError;
        } else goto SbkQTextCursorFunc_movePosition_TypeError;
    } else goto SbkQTextCursorFunc_movePosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTextCursorFunc_movePosition_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCursor.MoveOperation, PySide.QtGui.QTextCursor.MoveMode = MoveAnchor, int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextCursor.movePosition", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_position(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // position()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextCursor::position();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_removeSelectedText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // removeSelectedText()
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    cppSelf->QTextCursor::removeSelectedText();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextCursorFunc_select(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCursor::SelectionType >::isConvertible(arg)) {
        QTextCursor::SelectionType cpp_arg0 = Shiboken::Converter<QTextCursor::SelectionType >::toCpp(arg);
        // select(QTextCursor::SelectionType)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::select(cpp_arg0);
    } else goto SbkQTextCursorFunc_select_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_select_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCursor.SelectionType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.select", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_selectedText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedText()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextCursor::selectedText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_selection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selection()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    QTextDocumentFragment cpp_result = cppSelf->QTextCursor::selection();
    py_result = Shiboken::Converter<QTextDocumentFragment >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_selectionEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectionEnd()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextCursor::selectionEnd();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_selectionStart(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectionStart()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextCursor::selectionStart();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextCursorFunc_setBlockCharFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCharFormat* cpp_arg0 = Shiboken::Converter<QTextCharFormat* >::toCpp(arg);
        // setBlockCharFormat(QTextCharFormat)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::setBlockCharFormat(*cpp_arg0);
    } else goto SbkQTextCursorFunc_setBlockCharFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_setBlockCharFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.setBlockCharFormat", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_setBlockFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextBlockFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextBlockFormat* cpp_arg0 = Shiboken::Converter<QTextBlockFormat* >::toCpp(arg);
        // setBlockFormat(QTextBlockFormat)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::setBlockFormat(*cpp_arg0);
    } else goto SbkQTextCursorFunc_setBlockFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_setBlockFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextBlockFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.setBlockFormat", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_setCharFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCharFormat* cpp_arg0 = Shiboken::Converter<QTextCharFormat* >::toCpp(arg);
        // setCharFormat(QTextCharFormat)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::setCharFormat(*cpp_arg0);
    } else goto SbkQTextCursorFunc_setCharFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_setCharFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.setCharFormat", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_setPosition(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPosition", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setPosition(int,QTextCursor::MoveMode)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            cppSelf->QTextCursor::setPosition(cpp_arg0);
        } else if (Shiboken::Converter<QTextCursor::MoveMode >::isConvertible(pyargs[1])) {
            QTextCursor::MoveMode cpp_arg1 = Shiboken::Converter<QTextCursor::MoveMode >::toCpp(pyargs[1]);
            // setPosition(int,QTextCursor::MoveMode)
            QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
            cppSelf->QTextCursor::setPosition(cpp_arg0, cpp_arg1);
        } else goto SbkQTextCursorFunc_setPosition_TypeError;
    } else goto SbkQTextCursorFunc_setPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_setPosition_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QTextCursor.MoveMode = MoveAnchor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextCursor.setPosition", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_setVisualNavigation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setVisualNavigation(bool)
        QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
        cppSelf->QTextCursor::setVisualNavigation(cpp_arg0);
    } else goto SbkQTextCursorFunc_setVisualNavigation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCursorFunc_setVisualNavigation_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCursor.setVisualNavigation", overloads);
        return 0;
}

static PyObject*
SbkQTextCursorFunc_visualNavigation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // visualNavigation()const
    QTextCursor* cppSelf = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCursor::visualNavigation();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTextCursor_methods[] = {
    {"anchor", (PyCFunction)SbkQTextCursorFunc_anchor, METH_NOARGS},
    {"atBlockEnd", (PyCFunction)SbkQTextCursorFunc_atBlockEnd, METH_NOARGS},
    {"atBlockStart", (PyCFunction)SbkQTextCursorFunc_atBlockStart, METH_NOARGS},
    {"atEnd", (PyCFunction)SbkQTextCursorFunc_atEnd, METH_NOARGS},
    {"atStart", (PyCFunction)SbkQTextCursorFunc_atStart, METH_NOARGS},
    {"beginEditBlock", (PyCFunction)SbkQTextCursorFunc_beginEditBlock, METH_NOARGS},
    {"block", (PyCFunction)SbkQTextCursorFunc_block, METH_NOARGS},
    {"blockCharFormat", (PyCFunction)SbkQTextCursorFunc_blockCharFormat, METH_NOARGS},
    {"blockFormat", (PyCFunction)SbkQTextCursorFunc_blockFormat, METH_NOARGS},
    {"blockNumber", (PyCFunction)SbkQTextCursorFunc_blockNumber, METH_NOARGS},
    {"charFormat", (PyCFunction)SbkQTextCursorFunc_charFormat, METH_NOARGS},
    {"clearSelection", (PyCFunction)SbkQTextCursorFunc_clearSelection, METH_NOARGS},
    {"columnNumber", (PyCFunction)SbkQTextCursorFunc_columnNumber, METH_NOARGS},
    {"createList", (PyCFunction)SbkQTextCursorFunc_createList, METH_O},
    {"currentFrame", (PyCFunction)SbkQTextCursorFunc_currentFrame, METH_NOARGS},
    {"currentList", (PyCFunction)SbkQTextCursorFunc_currentList, METH_NOARGS},
    {"currentTable", (PyCFunction)SbkQTextCursorFunc_currentTable, METH_NOARGS},
    {"deleteChar", (PyCFunction)SbkQTextCursorFunc_deleteChar, METH_NOARGS},
    {"deletePreviousChar", (PyCFunction)SbkQTextCursorFunc_deletePreviousChar, METH_NOARGS},
    {"document", (PyCFunction)SbkQTextCursorFunc_document, METH_NOARGS},
    {"endEditBlock", (PyCFunction)SbkQTextCursorFunc_endEditBlock, METH_NOARGS},
    {"hasComplexSelection", (PyCFunction)SbkQTextCursorFunc_hasComplexSelection, METH_NOARGS},
    {"hasSelection", (PyCFunction)SbkQTextCursorFunc_hasSelection, METH_NOARGS},
    {"insertBlock", (PyCFunction)SbkQTextCursorFunc_insertBlock, METH_VARARGS},
    {"insertFragment", (PyCFunction)SbkQTextCursorFunc_insertFragment, METH_O},
    {"insertFrame", (PyCFunction)SbkQTextCursorFunc_insertFrame, METH_O},
    {"insertHtml", (PyCFunction)SbkQTextCursorFunc_insertHtml, METH_O},
    {"insertImage", (PyCFunction)SbkQTextCursorFunc_insertImage, METH_VARARGS},
    {"insertList", (PyCFunction)SbkQTextCursorFunc_insertList, METH_O},
    {"insertTable", (PyCFunction)SbkQTextCursorFunc_insertTable, METH_VARARGS},
    {"insertText", (PyCFunction)SbkQTextCursorFunc_insertText, METH_VARARGS},
    {"isCopyOf", (PyCFunction)SbkQTextCursorFunc_isCopyOf, METH_O},
    {"isNull", (PyCFunction)SbkQTextCursorFunc_isNull, METH_NOARGS},
    {"joinPreviousEditBlock", (PyCFunction)SbkQTextCursorFunc_joinPreviousEditBlock, METH_NOARGS},
    {"mergeBlockCharFormat", (PyCFunction)SbkQTextCursorFunc_mergeBlockCharFormat, METH_O},
    {"mergeBlockFormat", (PyCFunction)SbkQTextCursorFunc_mergeBlockFormat, METH_O},
    {"mergeCharFormat", (PyCFunction)SbkQTextCursorFunc_mergeCharFormat, METH_O},
    {"movePosition", (PyCFunction)SbkQTextCursorFunc_movePosition, METH_VARARGS},
    {"position", (PyCFunction)SbkQTextCursorFunc_position, METH_NOARGS},
    {"removeSelectedText", (PyCFunction)SbkQTextCursorFunc_removeSelectedText, METH_NOARGS},
    {"select", (PyCFunction)SbkQTextCursorFunc_select, METH_O},
    {"selectedText", (PyCFunction)SbkQTextCursorFunc_selectedText, METH_NOARGS},
    {"selection", (PyCFunction)SbkQTextCursorFunc_selection, METH_NOARGS},
    {"selectionEnd", (PyCFunction)SbkQTextCursorFunc_selectionEnd, METH_NOARGS},
    {"selectionStart", (PyCFunction)SbkQTextCursorFunc_selectionStart, METH_NOARGS},
    {"setBlockCharFormat", (PyCFunction)SbkQTextCursorFunc_setBlockCharFormat, METH_O},
    {"setBlockFormat", (PyCFunction)SbkQTextCursorFunc_setBlockFormat, METH_O},
    {"setCharFormat", (PyCFunction)SbkQTextCursorFunc_setCharFormat, METH_O},
    {"setPosition", (PyCFunction)SbkQTextCursorFunc_setPosition, METH_VARARGS},
    {"setVisualNavigation", (PyCFunction)SbkQTextCursorFunc_setVisualNavigation, METH_O},
    {"visualNavigation", (PyCFunction)SbkQTextCursorFunc_visualNavigation, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQTextCursor_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QTextCursor& cpp_self = *Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QTextCursor& >::isConvertible(other)) {
                QTextCursor* cpp_other = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQTextCursor_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QTextCursor& >::isConvertible(other)) {
                QTextCursor* cpp_other = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQTextCursor_RichComparison_TypeError;

            break;
        case Py_LE:
            if (Shiboken::Converter<QTextCursor& >::isConvertible(other)) {
                QTextCursor* cpp_other = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)other);
                result = (cpp_self <= (*cpp_other));
            } else goto SbkQTextCursor_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QTextCursor& >::isConvertible(other)) {
                QTextCursor* cpp_other = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQTextCursor_RichComparison_TypeError;

            break;
        case Py_GT:
            if (Shiboken::Converter<QTextCursor& >::isConvertible(other)) {
                QTextCursor* cpp_other = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)other);
                result = (cpp_self > (*cpp_other));
            } else goto SbkQTextCursor_RichComparison_TypeError;

            break;
        case Py_GE:
            if (Shiboken::Converter<QTextCursor& >::isConvertible(other)) {
                QTextCursor* cpp_other = Shiboken::Converter<QTextCursor* >::toCpp((PyObject*)other);
                result = (cpp_self >= (*cpp_other));
            } else goto SbkQTextCursor_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQTextCursor_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextCursor_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextCursor",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextCursor >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQTextCursor_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextCursor_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextCursor_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QTextCursor_MoveMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextCursor_MoveMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextCursor_MoveMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MoveMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextCursor_MoveMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextCursor_MoveMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTextCursor_MoveMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTextCursor_MoveOperation_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextCursor_MoveOperation_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextCursor_MoveOperation_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MoveOperation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextCursor_MoveOperation_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextCursor_MoveOperation_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTextCursor_MoveOperation_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTextCursor_SelectionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextCursor_SelectionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextCursor_SelectionType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SelectionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextCursor_SelectionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextCursor_SelectionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QTextCursor_SelectionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QTextCursor(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextCursor_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextCursor_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextCursor_Type));
    PyModule_AddObject(module, "QTextCursor",
        ((PyObject*)&SbkQTextCursor_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: MoveMode
    SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX] = &SbkPySide_QtGui_QTextCursor_MoveMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextCursor_MoveMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextCursor_MoveMode_Type);
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
            "MoveMode",((PyObject*)&SbkPySide_QtGui_QTextCursor_MoveMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveMode_Type,
        (long) QTextCursor::MoveAnchor, "MoveAnchor");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "MoveAnchor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveMode_Type.tp_dict,
        "MoveAnchor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveMode_Type,
        (long) QTextCursor::KeepAnchor, "KeepAnchor");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "KeepAnchor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveMode_Type.tp_dict,
        "KeepAnchor", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextCursor::MoveMode");

    // init enum class: MoveOperation
    SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX] = &SbkPySide_QtGui_QTextCursor_MoveOperation_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextCursor_MoveOperation_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type);
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
            "MoveOperation",((PyObject*)&SbkPySide_QtGui_QTextCursor_MoveOperation_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::NoMove, "NoMove");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "NoMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "NoMove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::Start, "Start");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "Start", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "Start", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::Up, "Up");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "Up", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "Up", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::StartOfLine, "StartOfLine");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "StartOfLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "StartOfLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::StartOfBlock, "StartOfBlock");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "StartOfBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "StartOfBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::StartOfWord, "StartOfWord");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "StartOfWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "StartOfWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::PreviousBlock, "PreviousBlock");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "PreviousBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "PreviousBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::PreviousCharacter, "PreviousCharacter");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "PreviousCharacter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "PreviousCharacter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::PreviousWord, "PreviousWord");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "PreviousWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "PreviousWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::Left, "Left");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "Left", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "Left", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::WordLeft, "WordLeft");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "WordLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "WordLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::End, "End");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "End", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "End", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::Down, "Down");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "Down", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "Down", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::EndOfLine, "EndOfLine");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "EndOfLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "EndOfLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::EndOfWord, "EndOfWord");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "EndOfWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "EndOfWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::EndOfBlock, "EndOfBlock");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "EndOfBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "EndOfBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::NextBlock, "NextBlock");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "NextBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "NextBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::NextCharacter, "NextCharacter");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "NextCharacter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "NextCharacter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::NextWord, "NextWord");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "NextWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "NextWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::Right, "Right");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "Right", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "Right", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::WordRight, "WordRight");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "WordRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "WordRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::NextCell, "NextCell");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "NextCell", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "NextCell", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::PreviousCell, "PreviousCell");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "PreviousCell", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "PreviousCell", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::NextRow, "NextRow");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "NextRow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "NextRow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_MoveOperation_Type,
        (long) QTextCursor::PreviousRow, "PreviousRow");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "PreviousRow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_MoveOperation_Type.tp_dict,
        "PreviousRow", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextCursor::MoveOperation");

    // init enum class: SelectionType
    SbkPySide_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX] = &SbkPySide_QtGui_QTextCursor_SelectionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextCursor_SelectionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextCursor_SelectionType_Type);
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
            "SelectionType",((PyObject*)&SbkPySide_QtGui_QTextCursor_SelectionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_SelectionType_Type,
        (long) QTextCursor::WordUnderCursor, "WordUnderCursor");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "WordUnderCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_SelectionType_Type.tp_dict,
        "WordUnderCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_SelectionType_Type,
        (long) QTextCursor::LineUnderCursor, "LineUnderCursor");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "LineUnderCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_SelectionType_Type.tp_dict,
        "LineUnderCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_SelectionType_Type,
        (long) QTextCursor::BlockUnderCursor, "BlockUnderCursor");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "BlockUnderCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_SelectionType_Type.tp_dict,
        "BlockUnderCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCursor_SelectionType_Type,
        (long) QTextCursor::Document, "Document");
    PyDict_SetItemString(SbkQTextCursor_Type.super.ht_type.tp_dict,
        "Document", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCursor_SelectionType_Type.tp_dict,
        "Document", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextCursor::SelectionType");

    Shiboken::TypeResolver::createValueTypeResolver<QTextCursor >("QTextCursor");
    Shiboken::TypeResolver::createValueTypeResolver<QTextCursor >(typeid(QTextCursor).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

