/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtablewidgetselectionrange_wrapper.h"

// Extra includes
#include <qtablewidget.h>

using namespace Shiboken;

static int
SbkQTableWidgetSelectionRange_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTableWidgetSelectionRange* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQTableWidgetSelectionRange_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QTableWidgetSelectionRange", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QTableWidgetSelectionRange()
        cptr = new QTableWidgetSelectionRange();
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // QTableWidgetSelectionRange(int,int,int,int)
        cptr = new QTableWidgetSelectionRange(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (numArgs == 1 && Shiboken::Converter<QTableWidgetSelectionRange& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTableWidgetSelectionRange* cpp_arg0 = Shiboken::Converter<QTableWidgetSelectionRange* >::toCpp(pyargs[0]);
        // QTableWidgetSelectionRange(QTableWidgetSelectionRange)
        cptr = new QTableWidgetSelectionRange(*cpp_arg0);
    } else goto SbkQTableWidgetSelectionRange_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTableWidgetSelectionRange_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTableWidgetSelectionRange_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTableWidgetSelectionRange", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidgetSelectionRange", overloads);
        return -1;
}

static PyObject*
SbkQTableWidgetSelectionRangeFunc_bottomRow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottomRow()const
    QTableWidgetSelectionRange* cppSelf = Shiboken::Converter<QTableWidgetSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidgetSelectionRange::bottomRow();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetSelectionRangeFunc_columnCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnCount()const
    QTableWidgetSelectionRange* cppSelf = Shiboken::Converter<QTableWidgetSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidgetSelectionRange::columnCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetSelectionRangeFunc_leftColumn(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // leftColumn()const
    QTableWidgetSelectionRange* cppSelf = Shiboken::Converter<QTableWidgetSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidgetSelectionRange::leftColumn();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetSelectionRangeFunc_rightColumn(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rightColumn()const
    QTableWidgetSelectionRange* cppSelf = Shiboken::Converter<QTableWidgetSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidgetSelectionRange::rightColumn();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetSelectionRangeFunc_rowCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rowCount()const
    QTableWidgetSelectionRange* cppSelf = Shiboken::Converter<QTableWidgetSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidgetSelectionRange::rowCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTableWidgetSelectionRangeFunc_topRow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // topRow()const
    QTableWidgetSelectionRange* cppSelf = Shiboken::Converter<QTableWidgetSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidgetSelectionRange::topRow();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTableWidgetSelectionRange_methods[] = {
    {"bottomRow", (PyCFunction)SbkQTableWidgetSelectionRangeFunc_bottomRow, METH_NOARGS},
    {"columnCount", (PyCFunction)SbkQTableWidgetSelectionRangeFunc_columnCount, METH_NOARGS},
    {"leftColumn", (PyCFunction)SbkQTableWidgetSelectionRangeFunc_leftColumn, METH_NOARGS},
    {"rightColumn", (PyCFunction)SbkQTableWidgetSelectionRangeFunc_rightColumn, METH_NOARGS},
    {"rowCount", (PyCFunction)SbkQTableWidgetSelectionRangeFunc_rowCount, METH_NOARGS},
    {"topRow", (PyCFunction)SbkQTableWidgetSelectionRangeFunc_topRow, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTableWidgetSelectionRange_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTableWidgetSelectionRange",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTableWidgetSelectionRange >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTableWidgetSelectionRange_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTableWidgetSelectionRange_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTableWidgetSelectionRange(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTableWidgetSelectionRange_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTableWidgetSelectionRange_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTableWidgetSelectionRange_Type));
    PyModule_AddObject(module, "QTableWidgetSelectionRange",
        ((PyObject*)&SbkQTableWidgetSelectionRange_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTableWidgetSelectionRange >("QTableWidgetSelectionRange");
    Shiboken::TypeResolver::createValueTypeResolver<QTableWidgetSelectionRange >(typeid(QTableWidgetSelectionRange).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

