/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qswipegesture_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpoint.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSwipeGestureWrapper::QSwipeGestureWrapper(QObject * parent) : QSwipeGesture(parent), m_metaObject(0) {
    // ... middle
}

void QSwipeGestureWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSwipeGestureWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSwipeGestureWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSwipeGestureWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSwipeGestureWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSwipeGesture.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QSwipeGestureWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSwipeGesture.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QSwipeGestureWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSwipeGestureWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QSwipeGesture::staticMetaObject);
}
    return m_metaObject;
}

int QSwipeGestureWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QSwipeGesture::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSwipeGestureWrapper::~QSwipeGestureWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQSwipeGesture_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSwipeGestureWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSwipeGesture", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QSwipeGesture(QObject*)
        cptr = new QSwipeGestureWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QSwipeGesture(QObject*)
        cptr = new QSwipeGestureWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQSwipeGesture_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSwipeGesture_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSwipeGesture_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSwipeGesture", overloads);
        return -1;
}

static PyObject*
SbkQSwipeGestureFunc_horizontalDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalDirection()const
    QSwipeGesture* cppSelf = Shiboken::Converter<QSwipeGesture* >::toCpp((PyObject*)self);
    QSwipeGesture::SwipeDirection cpp_result = cppSelf->QSwipeGesture::horizontalDirection();
    py_result = Shiboken::Converter<QSwipeGesture::SwipeDirection >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSwipeGestureFunc_setSwipeAngle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setSwipeAngle(qreal)
        QSwipeGesture* cppSelf = Shiboken::Converter<QSwipeGesture* >::toCpp((PyObject*)self);
        cppSelf->QSwipeGesture::setSwipeAngle(cpp_arg0);
    } else goto SbkQSwipeGestureFunc_setSwipeAngle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSwipeGestureFunc_setSwipeAngle_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSwipeGesture.setSwipeAngle", overloads);
        return 0;
}

static PyObject*
SbkQSwipeGestureFunc_swipeAngle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // swipeAngle()const
    QSwipeGesture* cppSelf = Shiboken::Converter<QSwipeGesture* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QSwipeGesture::swipeAngle();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSwipeGestureFunc_verticalDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalDirection()const
    QSwipeGesture* cppSelf = Shiboken::Converter<QSwipeGesture* >::toCpp((PyObject*)self);
    QSwipeGesture::SwipeDirection cpp_result = cppSelf->QSwipeGesture::verticalDirection();
    py_result = Shiboken::Converter<QSwipeGesture::SwipeDirection >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSwipeGesture_methods[] = {
    {"horizontalDirection", (PyCFunction)SbkQSwipeGestureFunc_horizontalDirection, METH_NOARGS},
    {"setSwipeAngle", (PyCFunction)SbkQSwipeGestureFunc_setSwipeAngle, METH_O},
    {"swipeAngle", (PyCFunction)SbkQSwipeGestureFunc_swipeAngle, METH_NOARGS},
    {"verticalDirection", (PyCFunction)SbkQSwipeGestureFunc_verticalDirection, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSwipeGesture_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QSwipeGesture",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSwipeGestureWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSwipeGesture_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSwipeGesture_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QSwipeGesture_SwipeDirection_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QSwipeGesture_SwipeDirection_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SwipeDirection",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QSwipeGesture_SwipeDirection_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QSwipeGesture_SwipeDirection_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QSwipeGesture_SwipeDirection_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSwipeGesture(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSWIPEGESTURE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSwipeGesture_Type);

    SbkQSwipeGesture_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGESTURE_IDX];
    // Fill type discovery information
    SbkQSwipeGesture_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSwipeGesture_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSwipeGesture_Type));
    PyModule_AddObject(module, "QSwipeGesture",
        ((PyObject*)&SbkQSwipeGesture_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SwipeDirection
    SbkPySide_QtGuiTypes[SBK_QSWIPEGESTURE_SWIPEDIRECTION_IDX] = &SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type);
    PyDict_SetItemString(SbkQSwipeGesture_Type.super.ht_type.tp_dict,
            "SwipeDirection",((PyObject*)&SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type,
        (long) QSwipeGesture::NoDirection, "NoDirection");
    PyDict_SetItemString(SbkQSwipeGesture_Type.super.ht_type.tp_dict,
        "NoDirection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type.tp_dict,
        "NoDirection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type,
        (long) QSwipeGesture::Left, "Left");
    PyDict_SetItemString(SbkQSwipeGesture_Type.super.ht_type.tp_dict,
        "Left", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type.tp_dict,
        "Left", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type,
        (long) QSwipeGesture::Right, "Right");
    PyDict_SetItemString(SbkQSwipeGesture_Type.super.ht_type.tp_dict,
        "Right", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type.tp_dict,
        "Right", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type,
        (long) QSwipeGesture::Up, "Up");
    PyDict_SetItemString(SbkQSwipeGesture_Type.super.ht_type.tp_dict,
        "Up", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type.tp_dict,
        "Up", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type,
        (long) QSwipeGesture::Down, "Down");
    PyDict_SetItemString(SbkQSwipeGesture_Type.super.ht_type.tp_dict,
        "Down", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSwipeGesture_SwipeDirection_Type.tp_dict,
        "Down", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSwipeGesture::SwipeDirection");

    Shiboken::TypeResolver::createObjectTypeResolver<QSwipeGesture >("QSwipeGesture*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSwipeGesture >(typeid(QSwipeGesture).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

