/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptiontoolbutton_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionToolButton_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionToolButton* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionToolButton", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionToolButton()
        cptr = new QStyleOptionToolButton();
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionToolButton(int)
        cptr = new QStyleOptionToolButton(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionToolButton& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionToolButton* cpp_arg0 = Shiboken::Converter<QStyleOptionToolButton* >::toCpp(pyargs[0]);
        // QStyleOptionToolButton(QStyleOptionToolButton)
        cptr = new QStyleOptionToolButton(*cpp_arg0);
    } else goto SbkQStyleOptionToolButton_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionToolButton_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStyleOptionToolButton_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionToolButton", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionToolButton", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionToolButton_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionToolButton_get_iconSize(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QSize >::toPython(Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->iconSize);
}
static int SbkQStyleOptionToolButton_set_iconSize(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'iconSize' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QSize >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'iconSize', 'QSize' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->iconSize = Shiboken::Converter<QSize >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolButton_get_toolButtonStyle(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::ToolButtonStyle >::toPython(Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->toolButtonStyle);
}
static int SbkQStyleOptionToolButton_set_toolButtonStyle(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'toolButtonStyle' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::ToolButtonStyle >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'toolButtonStyle', 'ToolButtonStyle' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->toolButtonStyle = Shiboken::Converter<Qt::ToolButtonStyle >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolButton_get_features(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<QStyleOptionToolButton::ToolButtonFeature> >::toPython(Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->features);
}
static int SbkQStyleOptionToolButton_set_features(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'features' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'features', 'ToolButtonFeatures' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->features = Shiboken::Converter<QFlags<QStyleOptionToolButton::ToolButtonFeature> >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolButton_get_arrowType(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::ArrowType >::toPython(Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->arrowType);
}
static int SbkQStyleOptionToolButton_set_arrowType(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'arrowType' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::ArrowType >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'arrowType', 'ArrowType' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->arrowType = Shiboken::Converter<Qt::ArrowType >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolButton_get_icon(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QIcon >::toPython(Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->icon);
}
static int SbkQStyleOptionToolButton_set_icon(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QIcon >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->icon = Shiboken::Converter<QIcon >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolButton_get_pos(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->pos);
}
static int SbkQStyleOptionToolButton_set_pos(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'pos' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'pos', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->pos = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolButton_get_text(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QString >::toPython(Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->text);
}
static int SbkQStyleOptionToolButton_set_text(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'text' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QString >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'text', 'QString' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->text = Shiboken::Converter<QString >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolButton_get_font(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFont >::toPython(Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->font);
}
static int SbkQStyleOptionToolButton_set_font(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'font' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QFont >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'font', 'QFont' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolButton* >::toCpp((PyObject*)self)->font = Shiboken::Converter<QFont >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionToolButton
static PyGetSetDef SbkQStyleOptionToolButton_getsetlist[] = {
    {const_cast<char*>("iconSize"), (getter)SbkQStyleOptionToolButton_get_iconSize, (setter)SbkQStyleOptionToolButton_set_iconSize},
    {const_cast<char*>("toolButtonStyle"), (getter)SbkQStyleOptionToolButton_get_toolButtonStyle, (setter)SbkQStyleOptionToolButton_set_toolButtonStyle},
    {const_cast<char*>("features"), (getter)SbkQStyleOptionToolButton_get_features, (setter)SbkQStyleOptionToolButton_set_features},
    {const_cast<char*>("arrowType"), (getter)SbkQStyleOptionToolButton_get_arrowType, (setter)SbkQStyleOptionToolButton_set_arrowType},
    {const_cast<char*>("icon"), (getter)SbkQStyleOptionToolButton_get_icon, (setter)SbkQStyleOptionToolButton_set_icon},
    {const_cast<char*>("pos"), (getter)SbkQStyleOptionToolButton_get_pos, (setter)SbkQStyleOptionToolButton_set_pos},
    {const_cast<char*>("text"), (getter)SbkQStyleOptionToolButton_get_text, (setter)SbkQStyleOptionToolButton_set_text},
    {const_cast<char*>("font"), (getter)SbkQStyleOptionToolButton_get_font, (setter)SbkQStyleOptionToolButton_set_font},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionToolButton_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionToolButton",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStyleOptionToolButton >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionToolButton_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionToolButton_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionToolButton_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionToolButton::ToolButtonFeatures >::toPython(
        ((QStyleOptionToolButton::ToolButtonFeatures) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QStyleOptionToolButton::ToolButtonFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionToolButton::ToolButtonFeatures >::toPython(
        ((QStyleOptionToolButton::ToolButtonFeatures) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QStyleOptionToolButton::ToolButtonFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionToolButton::ToolButtonFeatures >::toPython(
        ((QStyleOptionToolButton::ToolButtonFeatures) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QStyleOptionToolButton::ToolButtonFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionToolButton::ToolButtonFeatures >::toPython(
        ~ Shiboken::Converter< QStyleOptionToolButton::ToolButtonFeatures >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ToolButtonFeature",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeatures_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeatures_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ToolButtonFeatures",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeatures_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeatures_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeatures_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QStyleOptionToolButton(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionToolButton_Type);

    SbkQStyleOptionToolButton_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionToolButton_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionToolButton_Type));
    PyModule_AddObject(module, "QStyleOptionToolButton",
        ((PyObject*)&SbkQStyleOptionToolButton_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_Type,
        (long) QStyleOptionToolButton::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionToolButton::StyleOptionVersion");

    // init enum class: ToolButtonFeature
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX] = &SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type);
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
            "ToolButtonFeature",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type));

    // init flags class: QFlags<QStyleOptionToolButton::ToolButtonFeature>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE__IDX] = &SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeatures_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeatures_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeatures_Type);
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
            "ToolButtonFeatures",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeatures_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type,
        (long) QStyleOptionToolButton::None, "None");
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
        "None", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type.tp_dict,
        "None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type,
        (long) QStyleOptionToolButton::Arrow, "Arrow");
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
        "Arrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type.tp_dict,
        "Arrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type,
        (long) QStyleOptionToolButton::Menu, "Menu");
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
        "Menu", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type.tp_dict,
        "Menu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type,
        (long) QStyleOptionToolButton::MenuButtonPopup, "MenuButtonPopup");
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
        "MenuButtonPopup", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type.tp_dict,
        "MenuButtonPopup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type,
        (long) QStyleOptionToolButton::PopupDelay, "PopupDelay");
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
        "PopupDelay", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type.tp_dict,
        "PopupDelay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type,
        (long) QStyleOptionToolButton::HasMenu, "HasMenu");
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
        "HasMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolButton_ToolButtonFeature_Type.tp_dict,
        "HasMenu", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionToolButton::ToolButtonFeature");

    // init enum class: StyleOptionType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONTYPE_IDX] = &SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_Type);
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
            "StyleOptionType",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_Type,
        (long) QStyleOptionToolButton::Type, "Type");
    PyDict_SetItemString(SbkQStyleOptionToolButton_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolButton_StyleOptionType_Type.tp_dict,
        "Type", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionToolButton::StyleOptionType");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionToolButton >("QStyleOptionToolButton");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionToolButton >(typeid(QStyleOptionToolButton).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

