/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptiontoolboxv2_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionToolBoxV2_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionToolBoxV2* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionToolBoxV2", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionToolBoxV2()
        cptr = new QStyleOptionToolBoxV2();
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionToolBoxV2(int)
        cptr = new QStyleOptionToolBoxV2(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionToolBox& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionToolBox* cpp_arg0 = Shiboken::Converter<QStyleOptionToolBox* >::toCpp(pyargs[0]);
        // QStyleOptionToolBoxV2(QStyleOptionToolBox)
        cptr = new QStyleOptionToolBoxV2(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionToolBoxV2& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QStyleOptionToolBoxV2 > cpp_arg0_auto_ptr;
        QStyleOptionToolBoxV2* cpp_arg0 = Shiboken::Converter<QStyleOptionToolBoxV2* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QStyleOptionToolBoxV2& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStyleOptionToolBoxV2 >(cpp_arg0);
        // QStyleOptionToolBoxV2(QStyleOptionToolBoxV2)
        cptr = new QStyleOptionToolBoxV2(*cpp_arg0);
    } else goto SbkQStyleOptionToolBoxV2_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionToolBoxV2_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStyleOptionToolBoxV2_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionToolBox", "PySide.QtGui.QStyleOptionToolBoxV2", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionToolBoxV2", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionToolBoxV2_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionToolBoxV2_get_position(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionToolBoxV2::TabPosition >::toPython(Shiboken::Converter<QStyleOptionToolBoxV2* >::toCpp((PyObject*)self)->position);
}
static int SbkQStyleOptionToolBoxV2_set_position(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'position' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionToolBoxV2::TabPosition >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'position', 'TabPosition' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolBoxV2* >::toCpp((PyObject*)self)->position = Shiboken::Converter<QStyleOptionToolBoxV2::TabPosition >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolBoxV2_get_selectedPosition(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionToolBoxV2::SelectedPosition >::toPython(Shiboken::Converter<QStyleOptionToolBoxV2* >::toCpp((PyObject*)self)->selectedPosition);
}
static int SbkQStyleOptionToolBoxV2_set_selectedPosition(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'selectedPosition' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionToolBoxV2::SelectedPosition >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selectedPosition', 'SelectedPosition' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolBoxV2* >::toCpp((PyObject*)self)->selectedPosition = Shiboken::Converter<QStyleOptionToolBoxV2::SelectedPosition >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionToolBoxV2
static PyGetSetDef SbkQStyleOptionToolBoxV2_getsetlist[] = {
    {const_cast<char*>("position"), (getter)SbkQStyleOptionToolBoxV2_get_position, (setter)SbkQStyleOptionToolBoxV2_set_position},
    {const_cast<char*>("selectedPosition"), (getter)SbkQStyleOptionToolBoxV2_get_selectedPosition, (setter)SbkQStyleOptionToolBoxV2_set_selectedPosition},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionToolBoxV2_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionToolBoxV2",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStyleOptionToolBoxV2 >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionToolBoxV2_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionToolBoxV2_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionToolBoxV2_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TabPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SelectedPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QStyleOptionToolBoxV2(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionToolBoxV2_Type);

    SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionToolBoxV2_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionToolBoxV2_Type));
    PyModule_AddObject(module, "QStyleOptionToolBoxV2",
        ((PyObject*)&SbkQStyleOptionToolBoxV2_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_Type,
        (long) QStyleOptionToolBoxV2::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBoxV2_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionToolBoxV2::StyleOptionVersion");

    // init enum class: TabPosition
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_TABPOSITION_IDX] = &SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type);
    PyDict_SetItemString(SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_dict,
            "TabPosition",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type,
        (long) QStyleOptionToolBoxV2::Beginning, "Beginning");
    PyDict_SetItemString(SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_dict,
        "Beginning", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type.tp_dict,
        "Beginning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type,
        (long) QStyleOptionToolBoxV2::Middle, "Middle");
    PyDict_SetItemString(SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_dict,
        "Middle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type.tp_dict,
        "Middle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type,
        (long) QStyleOptionToolBoxV2::End, "End");
    PyDict_SetItemString(SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_dict,
        "End", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type.tp_dict,
        "End", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type,
        (long) QStyleOptionToolBoxV2::OnlyOneTab, "OnlyOneTab");
    PyDict_SetItemString(SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_dict,
        "OnlyOneTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBoxV2_TabPosition_Type.tp_dict,
        "OnlyOneTab", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionToolBoxV2::TabPosition");

    // init enum class: SelectedPosition
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBOXV2_SELECTEDPOSITION_IDX] = &SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Type);
    PyDict_SetItemString(SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_dict,
            "SelectedPosition",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Type,
        (long) QStyleOptionToolBoxV2::NotAdjacent, "NotAdjacent");
    PyDict_SetItemString(SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_dict,
        "NotAdjacent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Type.tp_dict,
        "NotAdjacent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Type,
        (long) QStyleOptionToolBoxV2::NextIsSelected, "NextIsSelected");
    PyDict_SetItemString(SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_dict,
        "NextIsSelected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Type.tp_dict,
        "NextIsSelected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Type,
        (long) QStyleOptionToolBoxV2::PreviousIsSelected, "PreviousIsSelected");
    PyDict_SetItemString(SbkQStyleOptionToolBoxV2_Type.super.ht_type.tp_dict,
        "PreviousIsSelected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBoxV2_SelectedPosition_Type.tp_dict,
        "PreviousIsSelected", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionToolBoxV2::SelectedPosition");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionToolBoxV2 >("QStyleOptionToolBoxV2");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionToolBoxV2 >(typeid(QStyleOptionToolBoxV2).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

