/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptiontoolbar_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionToolBar_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionToolBar* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionToolBar", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionToolBar()
        cptr = new QStyleOptionToolBar();
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionToolBar(int)
        cptr = new QStyleOptionToolBar(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionToolBar& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionToolBar* cpp_arg0 = Shiboken::Converter<QStyleOptionToolBar* >::toCpp(pyargs[0]);
        // QStyleOptionToolBar(QStyleOptionToolBar)
        cptr = new QStyleOptionToolBar(*cpp_arg0);
    } else goto SbkQStyleOptionToolBar_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionToolBar_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStyleOptionToolBar_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionToolBar", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionToolBar", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionToolBar_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionToolBar_get_lineWidth(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->lineWidth);
}
static int SbkQStyleOptionToolBar_set_lineWidth(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'lineWidth' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'lineWidth', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->lineWidth = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolBar_get_positionWithinLine(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionToolBar::ToolBarPosition >::toPython(Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->positionWithinLine);
}
static int SbkQStyleOptionToolBar_set_positionWithinLine(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'positionWithinLine' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionToolBar::ToolBarPosition >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'positionWithinLine', 'ToolBarPosition' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->positionWithinLine = Shiboken::Converter<QStyleOptionToolBar::ToolBarPosition >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolBar_get_positionOfLine(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionToolBar::ToolBarPosition >::toPython(Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->positionOfLine);
}
static int SbkQStyleOptionToolBar_set_positionOfLine(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'positionOfLine' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionToolBar::ToolBarPosition >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'positionOfLine', 'ToolBarPosition' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->positionOfLine = Shiboken::Converter<QStyleOptionToolBar::ToolBarPosition >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolBar_get_features(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<QStyleOptionToolBar::ToolBarFeature> >::toPython(Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->features);
}
static int SbkQStyleOptionToolBar_set_features(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'features' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'features', 'ToolBarFeatures' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->features = Shiboken::Converter<QFlags<QStyleOptionToolBar::ToolBarFeature> >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolBar_get_toolBarArea(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::ToolBarArea >::toPython(Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->toolBarArea);
}
static int SbkQStyleOptionToolBar_set_toolBarArea(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'toolBarArea' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::ToolBarArea >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'toolBarArea', 'ToolBarArea' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->toolBarArea = Shiboken::Converter<Qt::ToolBarArea >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionToolBar_get_midLineWidth(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->midLineWidth);
}
static int SbkQStyleOptionToolBar_set_midLineWidth(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'midLineWidth' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'midLineWidth', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionToolBar* >::toCpp((PyObject*)self)->midLineWidth = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionToolBar
static PyGetSetDef SbkQStyleOptionToolBar_getsetlist[] = {
    {const_cast<char*>("lineWidth"), (getter)SbkQStyleOptionToolBar_get_lineWidth, (setter)SbkQStyleOptionToolBar_set_lineWidth},
    {const_cast<char*>("positionWithinLine"), (getter)SbkQStyleOptionToolBar_get_positionWithinLine, (setter)SbkQStyleOptionToolBar_set_positionWithinLine},
    {const_cast<char*>("positionOfLine"), (getter)SbkQStyleOptionToolBar_get_positionOfLine, (setter)SbkQStyleOptionToolBar_set_positionOfLine},
    {const_cast<char*>("features"), (getter)SbkQStyleOptionToolBar_get_features, (setter)SbkQStyleOptionToolBar_set_features},
    {const_cast<char*>("toolBarArea"), (getter)SbkQStyleOptionToolBar_get_toolBarArea, (setter)SbkQStyleOptionToolBar_set_toolBarArea},
    {const_cast<char*>("midLineWidth"), (getter)SbkQStyleOptionToolBar_get_midLineWidth, (setter)SbkQStyleOptionToolBar_set_midLineWidth},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionToolBar_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionToolBar",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStyleOptionToolBar >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionToolBar_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionToolBar_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionToolBar_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ToolBarPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionToolBar::ToolBarFeatures >::toPython(
        ((QStyleOptionToolBar::ToolBarFeatures) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QStyleOptionToolBar::ToolBarFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionToolBar::ToolBarFeatures >::toPython(
        ((QStyleOptionToolBar::ToolBarFeatures) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QStyleOptionToolBar::ToolBarFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionToolBar::ToolBarFeatures >::toPython(
        ((QStyleOptionToolBar::ToolBarFeatures) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QStyleOptionToolBar::ToolBarFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionToolBar::ToolBarFeatures >::toPython(
        ~ Shiboken::Converter< QStyleOptionToolBar::ToolBarFeatures >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ToolBarFeature",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeatures_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeatures_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ToolBarFeatures",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeatures_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeatures_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeatures_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void)
init_QStyleOptionToolBar(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionToolBar_Type);

    SbkQStyleOptionToolBar_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionToolBar_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionToolBar_Type));
    PyModule_AddObject(module, "QStyleOptionToolBar",
        ((PyObject*)&SbkQStyleOptionToolBar_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_Type,
        (long) QStyleOptionToolBar::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionToolBar::StyleOptionVersion");

    // init enum class: StyleOptionType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONTYPE_IDX] = &SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_Type);
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
            "StyleOptionType",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_Type,
        (long) QStyleOptionToolBar::Type, "Type");
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBar_StyleOptionType_Type.tp_dict,
        "Type", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionToolBar::StyleOptionType");

    // init enum class: ToolBarPosition
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX] = &SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type);
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
            "ToolBarPosition",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type,
        (long) QStyleOptionToolBar::Beginning, "Beginning");
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
        "Beginning", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type.tp_dict,
        "Beginning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type,
        (long) QStyleOptionToolBar::Middle, "Middle");
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
        "Middle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type.tp_dict,
        "Middle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type,
        (long) QStyleOptionToolBar::End, "End");
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
        "End", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type.tp_dict,
        "End", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type,
        (long) QStyleOptionToolBar::OnlyOne, "OnlyOne");
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
        "OnlyOne", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBar_ToolBarPosition_Type.tp_dict,
        "OnlyOne", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionToolBar::ToolBarPosition");

    // init enum class: ToolBarFeature
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX] = &SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Type);
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
            "ToolBarFeature",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Type));

    // init flags class: QFlags<QStyleOptionToolBar::ToolBarFeature>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE__IDX] = &SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeatures_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeatures_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeatures_Type);
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
            "ToolBarFeatures",((PyObject*)&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeatures_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Type,
        (long) QStyleOptionToolBar::None, "None");
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
        "None", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Type.tp_dict,
        "None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Type,
        (long) QStyleOptionToolBar::Movable, "Movable");
    PyDict_SetItemString(SbkQStyleOptionToolBar_Type.super.ht_type.tp_dict,
        "Movable", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionToolBar_ToolBarFeature_Type.tp_dict,
        "Movable", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionToolBar::ToolBarFeature");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionToolBar >("QStyleOptionToolBar");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionToolBar >(typeid(QStyleOptionToolBar).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

