/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptiongraphicsitem_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qtransform.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionGraphicsItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionGraphicsItem* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionGraphicsItem", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionGraphicsItem()
        cptr = new QStyleOptionGraphicsItem();
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionGraphicsItem(int)
        cptr = new QStyleOptionGraphicsItem(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionGraphicsItem& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionGraphicsItem* cpp_arg0 = Shiboken::Converter<QStyleOptionGraphicsItem* >::toCpp(pyargs[0]);
        // QStyleOptionGraphicsItem(QStyleOptionGraphicsItem)
        cptr = new QStyleOptionGraphicsItem(*cpp_arg0);
    } else goto SbkQStyleOptionGraphicsItem_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionGraphicsItem_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStyleOptionGraphicsItem_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionGraphicsItem", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionGraphicsItem", overloads);
        return -1;
}

static PyObject*
SbkQStyleOptionGraphicsItemFunc_levelOfDetailFromTransform(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QTransform& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // levelOfDetailFromTransform(QTransform)
        qreal cpp_result = QStyleOptionGraphicsItem::levelOfDetailFromTransform(*cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
    } else goto SbkQStyleOptionGraphicsItemFunc_levelOfDetailFromTransform_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStyleOptionGraphicsItemFunc_levelOfDetailFromTransform_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStyleOptionGraphicsItem.levelOfDetailFromTransform", overloads);
        return 0;
}

static PyMethodDef SbkQStyleOptionGraphicsItem_methods[] = {
    {"levelOfDetailFromTransform", (PyCFunction)SbkQStyleOptionGraphicsItemFunc_levelOfDetailFromTransform, METH_O|METH_STATIC},
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionGraphicsItem_get_exposedRect(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QRectF >::toPython(Shiboken::Converter<QStyleOptionGraphicsItem* >::toCpp((PyObject*)self)->exposedRect);
}
static int SbkQStyleOptionGraphicsItem_set_exposedRect(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'exposedRect' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QRectF >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'exposedRect', 'QRectF' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionGraphicsItem* >::toCpp((PyObject*)self)->exposedRect = Shiboken::Converter<QRectF >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionGraphicsItem_get_matrix(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QMatrix >::toPython(Shiboken::Converter<QStyleOptionGraphicsItem* >::toCpp((PyObject*)self)->matrix);
}
static int SbkQStyleOptionGraphicsItem_set_matrix(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'matrix' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QMatrix >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'matrix', 'QMatrix' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionGraphicsItem* >::toCpp((PyObject*)self)->matrix = Shiboken::Converter<QMatrix >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionGraphicsItem_get_levelOfDetail(SbkBaseWrapper* self)
{
    return Shiboken::Converter<double >::toPython(Shiboken::Converter<QStyleOptionGraphicsItem* >::toCpp((PyObject*)self)->levelOfDetail);
}
static int SbkQStyleOptionGraphicsItem_set_levelOfDetail(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'levelOfDetail' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'levelOfDetail', 'qreal' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionGraphicsItem* >::toCpp((PyObject*)self)->levelOfDetail = Shiboken::Converter<double >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionGraphicsItem
static PyGetSetDef SbkQStyleOptionGraphicsItem_getsetlist[] = {
    {const_cast<char*>("exposedRect"), (getter)SbkQStyleOptionGraphicsItem_get_exposedRect, (setter)SbkQStyleOptionGraphicsItem_set_exposedRect},
    {const_cast<char*>("matrix"), (getter)SbkQStyleOptionGraphicsItem_get_matrix, (setter)SbkQStyleOptionGraphicsItem_set_matrix},
    {const_cast<char*>("levelOfDetail"), (getter)SbkQStyleOptionGraphicsItem_get_levelOfDetail, (setter)SbkQStyleOptionGraphicsItem_set_levelOfDetail},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionGraphicsItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionGraphicsItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStyleOptionGraphicsItem >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionGraphicsItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionGraphicsItem_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionGraphicsItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QStyleOptionGraphicsItem(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionGraphicsItem_Type);

    SbkQStyleOptionGraphicsItem_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionGraphicsItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionGraphicsItem_Type));
    PyModule_AddObject(module, "QStyleOptionGraphicsItem",
        ((PyObject*)&SbkQStyleOptionGraphicsItem_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionGraphicsItem_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_Type,
        (long) QStyleOptionGraphicsItem::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionGraphicsItem_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionGraphicsItem::StyleOptionVersion");

    // init enum class: StyleOptionType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_STYLEOPTIONTYPE_IDX] = &SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_Type);
    PyDict_SetItemString(SbkQStyleOptionGraphicsItem_Type.super.ht_type.tp_dict,
            "StyleOptionType",((PyObject*)&SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_Type,
        (long) QStyleOptionGraphicsItem::Type, "Type");
    PyDict_SetItemString(SbkQStyleOptionGraphicsItem_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionGraphicsItem_StyleOptionType_Type.tp_dict,
        "Type", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionGraphicsItem::StyleOptionType");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionGraphicsItem >("QStyleOptionGraphicsItem");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionGraphicsItem >(typeid(QStyleOptionGraphicsItem).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

