/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptionframev2_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionFrameV2_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionFrameV2* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionFrameV2", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionFrameV2()
        cptr = new QStyleOptionFrameV2();
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionFrameV2(int)
        cptr = new QStyleOptionFrameV2(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionFrame& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionFrame* cpp_arg0 = Shiboken::Converter<QStyleOptionFrame* >::toCpp(pyargs[0]);
        // QStyleOptionFrameV2(QStyleOptionFrame)
        cptr = new QStyleOptionFrameV2(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionFrameV2& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QStyleOptionFrameV2 > cpp_arg0_auto_ptr;
        QStyleOptionFrameV2* cpp_arg0 = Shiboken::Converter<QStyleOptionFrameV2* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QStyleOptionFrameV2& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStyleOptionFrameV2 >(cpp_arg0);
        // QStyleOptionFrameV2(QStyleOptionFrameV2)
        cptr = new QStyleOptionFrameV2(*cpp_arg0);
    } else goto SbkQStyleOptionFrameV2_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionFrameV2_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStyleOptionFrameV2_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionFrame", "PySide.QtGui.QStyleOptionFrameV2", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionFrameV2", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionFrameV2_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionFrameV2_get_features(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<QStyleOptionFrameV2::FrameFeature> >::toPython(Shiboken::Converter<QStyleOptionFrameV2* >::toCpp((PyObject*)self)->features);
}
static int SbkQStyleOptionFrameV2_set_features(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'features' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'features', 'FrameFeatures' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionFrameV2* >::toCpp((PyObject*)self)->features = Shiboken::Converter<QFlags<QStyleOptionFrameV2::FrameFeature> >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionFrameV2
static PyGetSetDef SbkQStyleOptionFrameV2_getsetlist[] = {
    {const_cast<char*>("features"), (getter)SbkQStyleOptionFrameV2_get_features, (setter)SbkQStyleOptionFrameV2_set_features},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionFrameV2_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionFrameV2",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStyleOptionFrameV2 >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionFrameV2_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionFrameV2_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionFrameV2_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionFrameV2::FrameFeatures >::toPython(
        ((QStyleOptionFrameV2::FrameFeatures) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QStyleOptionFrameV2::FrameFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionFrameV2::FrameFeatures >::toPython(
        ((QStyleOptionFrameV2::FrameFeatures) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QStyleOptionFrameV2::FrameFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionFrameV2::FrameFeatures >::toPython(
        ((QStyleOptionFrameV2::FrameFeatures) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QStyleOptionFrameV2::FrameFeatures >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionFrameV2::FrameFeatures >::toPython(
        ~ Shiboken::Converter< QStyleOptionFrameV2::FrameFeatures >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FrameFeature",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeatures_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeatures_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FrameFeatures",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeatures_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeatures_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeatures_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void)
init_QStyleOptionFrameV2(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV2_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionFrameV2_Type);

    SbkQStyleOptionFrameV2_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAME_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionFrameV2_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionFrameV2_Type));
    PyModule_AddObject(module, "QStyleOptionFrameV2",
        ((PyObject*)&SbkQStyleOptionFrameV2_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV2_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionFrameV2_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_Type,
        (long) QStyleOptionFrameV2::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionFrameV2_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionFrameV2_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionFrameV2::StyleOptionVersion");

    // init enum class: FrameFeature
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONFRAMEV2_FRAMEFEATURE_IDX] = &SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Type);
    PyDict_SetItemString(SbkQStyleOptionFrameV2_Type.super.ht_type.tp_dict,
            "FrameFeature",((PyObject*)&SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Type));

    // init flags class: QFlags<QStyleOptionFrameV2::FrameFeature>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONFRAMEV2_FRAMEFEATURE__IDX] = &SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeatures_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeatures_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeatures_Type);
    PyDict_SetItemString(SbkQStyleOptionFrameV2_Type.super.ht_type.tp_dict,
            "FrameFeatures",((PyObject*)&SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeatures_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Type,
        (long) QStyleOptionFrameV2::None, "None");
    PyDict_SetItemString(SbkQStyleOptionFrameV2_Type.super.ht_type.tp_dict,
        "None", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Type.tp_dict,
        "None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Type,
        (long) QStyleOptionFrameV2::Flat, "Flat");
    PyDict_SetItemString(SbkQStyleOptionFrameV2_Type.super.ht_type.tp_dict,
        "Flat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionFrameV2_FrameFeature_Type.tp_dict,
        "Flat", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionFrameV2::FrameFeature");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionFrameV2 >("QStyleOptionFrameV2");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionFrameV2 >(typeid(QStyleOptionFrameV2).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

