/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qstringlistmodel_wrapper.h"

// Extra includes
#include <QList>
#include <QMap>
#include <pysideconversions.h>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatastream.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsize.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qstringlistmodel.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QStringListModelWrapper::QStringListModelWrapper(QObject * parent) : QStringListModel(parent), m_metaObject(0) {
    // ... middle
}

QStringListModelWrapper::QStringListModelWrapper(const QStringList & strings, QObject * parent) : QStringListModel(strings, parent), m_metaObject(0) {
    // ... middle
}

QModelIndex QStringListModelWrapper::buddy(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "buddy"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::buddy(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.buddy");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QStringListModelWrapper::canFetchMore(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canFetchMore"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::canFetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.canFetchMore");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QStringListModelWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStringListModelWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStringListModelWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QStringListModelWrapper::data(const QModelIndex & index, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        return this->QStringListModel::data(index, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oi)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.data");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QStringListModelWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QStringListModelWrapper::dropMimeData(const QMimeData * data, Qt::DropAction action, int row, int column, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropMimeData"));
    if (py_override.isNull()) {
        return this->QAbstractListModel::dropMimeData(data, action, row, column, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOiiO)",
        Shiboken::Converter<QMimeData* >::toPython(data),
        Shiboken::Converter<Qt::DropAction >::toPython(action),
        row,
        column,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.dropMimeData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStringListModelWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QStringListModelWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QStringListModelWrapper::fetchMore(const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetchMore"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::fetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<Qt::ItemFlag> QStringListModelWrapper::flags(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "flags"));
    if (py_override.isNull()) {
        return this->QStringListModel::flags(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::ItemFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::ItemFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.flags");
        return QFlags<Qt::ItemFlag>()        ;
    }
    QFlags<Qt::ItemFlag> cpp_result(Shiboken::Converter<QFlags<Qt::ItemFlag> >::toCpp(py_result));
    return cpp_result;
}

QVariant QStringListModelWrapper::headerData(int section, Qt::Orientation orientation, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "headerData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::headerData(section, orientation, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iOi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.headerData");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QStringListModelWrapper::index(int row, int column, const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "index"));
    if (py_override.isNull()) {
        return this->QAbstractListModel::index(row, column, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        column,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.index");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QStringListModelWrapper::insertColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertColumns"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::insertColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        column,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.insertColumns");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStringListModelWrapper::insertRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertRows"));
    if (py_override.isNull()) {
        return this->QStringListModel::insertRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.insertRows");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QMap<int, QVariant > QStringListModelWrapper::itemData(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::itemData(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QMap<int, QVariant >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMap<int, QVariant > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.itemData");
        return QMap<int, QVariant >()        ;
    }
    QMap<int, QVariant > cpp_result(Shiboken::Converter<QMap<int, QVariant > >::toCpp(py_result));
    return cpp_result;
}

QList<QModelIndex > QStringListModelWrapper::match(const QModelIndex & start, int role, const QVariant & value, int hits, QFlags<Qt::MatchFlag> flags) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "match"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::match(start, role, value, hits, flags);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiOiO)",
        Shiboken::Converter<QModelIndex& >::toPython(start),
        role,
        Shiboken::Converter<QVariant& >::toPython(value),
        hits,
        Shiboken::Converter<QFlags<Qt::MatchFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.match");
        return QList<QModelIndex >()        ;
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

QMimeData * QStringListModelWrapper::mimeData(const QList<QModelIndex > & indexes) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::mimeData(indexes);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QList<QModelIndex >  >::toPython(indexes)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMimeData* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.mimeData");
        return 0        ;
    }
    QMimeData* cpp_result(Shiboken::Converter<QMimeData* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QStringList QStringListModelWrapper::mimeTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeTypes"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::mimeTypes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.mimeTypes");
        return QStringList()        ;
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

bool QStringListModelWrapper::removeColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeColumns"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::removeColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        column,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.removeColumns");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStringListModelWrapper::removeRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeRows"));
    if (py_override.isNull()) {
        return this->QStringListModel::removeRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.removeRows");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QStringListModelWrapper::revert()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "revert"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::revert();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QStringListModelWrapper::rowCount(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowCount"));
    if (py_override.isNull()) {
        return this->QStringListModel::rowCount(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.rowCount");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QStringListModelWrapper::setData(const QModelIndex & index, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QStringListModel::setData(index, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOi)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QVariant& >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.setData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStringListModelWrapper::setHeaderData(int section, Qt::Orientation orientation, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setHeaderData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::setHeaderData(section, orientation, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iOOi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        Shiboken::Converter<QVariant& >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.setHeaderData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStringListModelWrapper::setItemData(const QModelIndex & index, const QMap<int, QVariant > & roles)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setItemData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::setItemData(index, roles);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QMap<int, QVariant >  >::toPython(roles)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.setItemData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QStringListModelWrapper::sort(int column, Qt::SortOrder order)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sort"));
    if (py_override.isNull()) {
        return this->QStringListModel::sort(column, order);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iO)",
        column,
        Shiboken::Converter<Qt::SortOrder >::toPython(order)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QStringListModelWrapper::span(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "span"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::span(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.span");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

bool QStringListModelWrapper::submit()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "submit"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::submit();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.submit");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::DropAction> QStringListModelWrapper::supportedDropActions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedDropActions"));
    if (py_override.isNull()) {
        return this->QStringListModel::supportedDropActions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::DropAction>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::DropAction> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStringListModel.supportedDropActions");
        return QFlags<Qt::DropAction>()        ;
    }
    QFlags<Qt::DropAction> cpp_result(Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(py_result));
    return cpp_result;
}

void QStringListModelWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QStringListModelWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QStringListModel::staticMetaObject);
}
    return m_metaObject;
}

int QStringListModelWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QStringListModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QStringListModelWrapper::~QStringListModelWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQStringListModel_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStringListModelWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QStringListModel", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QStringListModel(QObject*)
        cptr = new QStringListModelWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QStringList& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QStringList& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        if (numArgs == 1) {
            // QStringListModel(QStringList,QObject*)
            cptr = new QStringListModelWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QStringListModel(QStringList,QObject*)
            cptr = new QStringListModelWrapper(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQStringListModel_Init_TypeError;
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QStringListModel(QObject*)
        cptr = new QStringListModelWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQStringListModel_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStringListModel_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStringListModel_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "PySide.QtCore.QStringList, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStringListModel", overloads);
        return -1;
}

static PyObject*
SbkQStringListModelFunc_data(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "data", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // data(QModelIndex,int)const
        QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QStringListModel::data(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQStringListModelFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStringListModelFunc_data_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStringListModel.data", overloads);
        return 0;
}

static PyObject*
SbkQStringListModelFunc_flags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // flags(QModelIndex)const
        QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
        QFlags<Qt::ItemFlag> cpp_result = cppSelf->QStringListModel::flags(*cpp_arg0);
        py_result = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toPython(cpp_result);
    } else goto SbkQStringListModelFunc_flags_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStringListModelFunc_flags_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStringListModel.flags", overloads);
        return 0;
}

static PyObject*
SbkQStringListModelFunc_insertRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertRows", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // insertRows(int,int,QModelIndex)
            QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStringListModel::insertRows(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // insertRows(int,int,QModelIndex)
            QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStringListModel::insertRows(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQStringListModelFunc_insertRows_TypeError;
    } else goto SbkQStringListModelFunc_insertRows_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStringListModelFunc_insertRows_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStringListModel.insertRows", overloads);
        return 0;
}

static PyObject*
SbkQStringListModelFunc_removeRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "removeRows", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // removeRows(int,int,QModelIndex)
            QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStringListModel::removeRows(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // removeRows(int,int,QModelIndex)
            QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStringListModel::removeRows(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQStringListModelFunc_removeRows_TypeError;
    } else goto SbkQStringListModelFunc_removeRows_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStringListModelFunc_removeRows_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStringListModel.removeRows", overloads);
        return 0;
}

static PyObject*
SbkQStringListModelFunc_rowCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // rowCount(QModelIndex)const
        QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QStringListModel::rowCount();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // rowCount(QModelIndex)const
        QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QStringListModel::rowCount(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQStringListModelFunc_rowCount_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStringListModelFunc_rowCount_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStringListModel.rowCount", overloads);
        return 0;
}

static PyObject*
SbkQStringListModelFunc_setData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setData", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        if (numArgs == 2) {
            // setData(QModelIndex,QVariant,int)
            QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStringListModel::setData(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setData(QModelIndex,QVariant,int)
            QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStringListModel::setData(*cpp_arg0, *cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQStringListModelFunc_setData_TypeError;
    } else goto SbkQStringListModelFunc_setData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStringListModelFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QVariant, int = Qt.EditRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStringListModel.setData", overloads);
        return 0;
}

static PyObject*
SbkQStringListModelFunc_setStringList(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setStringList(QStringList)
        QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
        cppSelf->QStringListModel::setStringList(*cpp_arg0);
    } else goto SbkQStringListModelFunc_setStringList_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringListModelFunc_setStringList_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStringListModel.setStringList", overloads);
        return 0;
}

static PyObject*
SbkQStringListModelFunc_sort(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sort", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sort(int,Qt::SortOrder)
            QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
            cppSelf->QStringListModel::sort(cpp_arg0);
        } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[1])) {
            Qt::SortOrder cpp_arg1 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[1]);
            // sort(int,Qt::SortOrder)
            QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
            cppSelf->QStringListModel::sort(cpp_arg0, cpp_arg1);
        } else goto SbkQStringListModelFunc_sort_TypeError;
    } else goto SbkQStringListModelFunc_sort_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringListModelFunc_sort_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStringListModel.sort", overloads);
        return 0;
}

static PyObject*
SbkQStringListModelFunc_stringList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stringList()const
    QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QStringListModel::stringList();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStringListModelFunc_supportedDropActions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedDropActions()const
    QStringListModel* cppSelf = Shiboken::Converter<QStringListModel* >::toCpp((PyObject*)self);
    QFlags<Qt::DropAction> cpp_result = cppSelf->QStringListModel::supportedDropActions();
    py_result = Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQStringListModel_methods[] = {
    {"data", (PyCFunction)SbkQStringListModelFunc_data, METH_VARARGS},
    {"flags", (PyCFunction)SbkQStringListModelFunc_flags, METH_O},
    {"insertRows", (PyCFunction)SbkQStringListModelFunc_insertRows, METH_VARARGS},
    {"removeRows", (PyCFunction)SbkQStringListModelFunc_removeRows, METH_VARARGS},
    {"rowCount", (PyCFunction)SbkQStringListModelFunc_rowCount, METH_NOARGS|METH_O},
    {"setData", (PyCFunction)SbkQStringListModelFunc_setData, METH_VARARGS},
    {"setStringList", (PyCFunction)SbkQStringListModelFunc_setStringList, METH_O},
    {"sort", (PyCFunction)SbkQStringListModelFunc_sort, METH_VARARGS},
    {"stringList", (PyCFunction)SbkQStringListModelFunc_stringList, METH_NOARGS},
    {"supportedDropActions", (PyCFunction)SbkQStringListModelFunc_supportedDropActions, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStringListModel_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStringListModel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStringListModelWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStringListModel_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStringListModel_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QStringListModel(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTRINGLISTMODEL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStringListModel_Type);

    SbkQStringListModel_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QABSTRACTLISTMODEL_IDX];
    // Fill type discovery information
    SbkQStringListModel_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQStringListModel_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStringListModel_Type));
    PyModule_AddObject(module, "QStringListModel",
        ((PyObject*)&SbkQStringListModel_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QStringListModel >("QStringListModel*");
    Shiboken::TypeResolver::createObjectTypeResolver<QStringListModel >(typeid(QStringListModel).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

