/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstandarditem_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemmodel.h>
#include <qbrush.h>
#include <qdatastream.h>
#include <qfont.h>
#include <qicon.h>
#include <qsize.h>
#include <qstandarditemmodel.h>
#include <qstring.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QStandardItemWrapper::QStandardItemWrapper() : QStandardItem() {
    // ... middle
}

QStandardItemWrapper::QStandardItemWrapper(const QIcon & icon, const QString & text) : QStandardItem(icon, text) {
    // ... middle
}

QStandardItemWrapper::QStandardItemWrapper(const QString & text) : QStandardItem(text) {
    // ... middle
}

QStandardItemWrapper::QStandardItemWrapper(int rows, int columns) : QStandardItem(rows, columns) {
    // ... middle
}

QStandardItem * QStandardItemWrapper::clone() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "clone"));
    if (py_override.isNull()) {
        return this->QStandardItem::clone();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStandardItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStandardItem.clone");
        return 0        ;
    }
    QStandardItem* cpp_result(Shiboken::Converter<QStandardItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QVariant QStandardItemWrapper::data(int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        return this->QStandardItem::data(role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStandardItem.data");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QStandardItemWrapper::setData(const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QStandardItem::setData(value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oi)",
        Shiboken::Converter<QVariant& >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QStandardItemWrapper::type() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "type"));
    if (py_override.isNull()) {
        return this->QStandardItem::type();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStandardItem.type");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QStandardItemWrapper::~QStandardItemWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQStandardItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStandardItemWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QStandardItem", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QStandardItem()
        cptr = new QStandardItemWrapper();
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QStandardItem(int,int)
            cptr = new QStandardItemWrapper(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // QStandardItem(int,int)
            cptr = new QStandardItemWrapper(cpp_arg0, cpp_arg1);
        } else goto SbkQStandardItem_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QStandardItem(QString)
        cptr = new QStandardItemWrapper(*cpp_arg0);
    } else if (numArgs == 2 && Shiboken::Converter<QIcon& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QIcon& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // QStandardItem(QIcon,QString)
        cptr = new QStandardItemWrapper(*cpp_arg0, *cpp_arg1);
    } else goto SbkQStandardItem_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStandardItem_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStandardItem_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QIcon, PySide.QtCore.QString", "PySide.QtCore.QString", "int, int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem", overloads);
        return -1;
}

static PyObject*
SbkQStandardItemFunc_accessibleDescription(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // accessibleDescription()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QStandardItem::accessibleDescription();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_accessibleText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // accessibleText()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QStandardItem::accessibleText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_appendColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QStandardItem * >  >::isConvertible(arg)) {
        QList<QStandardItem * >  cpp_arg0 = Shiboken::Converter<QList<QStandardItem * >  >::toCpp(arg);
        // appendColumn(QList<QStandardItem*>)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::appendColumn(cpp_arg0);
    } else goto SbkQStandardItemFunc_appendColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_appendColumn_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.appendColumn", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_appendRow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStandardItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStandardItem* cpp_arg0 = Shiboken::Converter<QStandardItem* >::toCpp(arg);
        // appendRow(QStandardItem*)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::appendRow(cpp_arg0);
    } else if (Shiboken::Converter<QList<QStandardItem * >  >::isConvertible(arg)) {
        QList<QStandardItem * >  cpp_arg0 = Shiboken::Converter<QList<QStandardItem * >  >::toCpp(arg);
        // appendRow(QList<QStandardItem*>)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::appendRow(cpp_arg0);
    } else goto SbkQStandardItemFunc_appendRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_appendRow_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStandardItem", "list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.appendRow", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_appendRows(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QStandardItem * >  >::isConvertible(arg)) {
        QList<QStandardItem * >  cpp_arg0 = Shiboken::Converter<QList<QStandardItem * >  >::toCpp(arg);
        // appendRows(QList<QStandardItem*>)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::appendRows(cpp_arg0);
    } else goto SbkQStandardItemFunc_appendRows_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_appendRows_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.appendRows", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_background(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // background()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QStandardItem::background();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_checkState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // checkState()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    Qt::CheckState cpp_result = cppSelf->QStandardItem::checkState();
    py_result = Shiboken::Converter<Qt::CheckState >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_child(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "child", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // child(int,int)const
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            QStandardItem * cpp_result = cppSelf->QStandardItem::child(cpp_arg0);
            py_result = Shiboken::Converter<QStandardItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // child(int,int)const
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            QStandardItem * cpp_result = cppSelf->QStandardItem::child(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QStandardItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQStandardItemFunc_child_TypeError;
    } else goto SbkQStandardItemFunc_child_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStandardItemFunc_child_TypeError:
        const char* overloads[] = {"int, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem.child", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_clone(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clone()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QStandardItem * cpp_result = cppSelf->QStandardItem::clone();
    py_result = Shiboken::Converter<QStandardItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_column(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // column()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStandardItem::column();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_columnCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnCount()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStandardItem::columnCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_data(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // data(int)const
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QStandardItem::data();
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // data(int)const
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QStandardItem::data(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQStandardItemFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStandardItemFunc_data_TypeError:
        const char* overloads[] = {"int = Qt.UserRole + 1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.data", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_emitDataChanged(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // emitDataChanged()
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    cppSelf->QStandardItem::emitDataChanged();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQStandardItemFunc_flags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // flags()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QFlags<Qt::ItemFlag> cpp_result = cppSelf->QStandardItem::flags();
    py_result = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QStandardItem::font();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_foreground(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // foreground()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QStandardItem::foreground();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_hasChildren(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasChildren()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStandardItem::hasChildren();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_icon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // icon()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QIcon cpp_result = cppSelf->QStandardItem::icon();
    py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_index(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // index()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QModelIndex cpp_result = cppSelf->QStandardItem::index();
    py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_insertColumn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertColumn", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QList<QStandardItem * >  >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QList<QStandardItem * >  cpp_arg1 = Shiboken::Converter<QList<QStandardItem * >  >::toCpp(pyargs[1]);
        // insertColumn(int,QList<QStandardItem*>)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::insertColumn(cpp_arg0, cpp_arg1);
    } else goto SbkQStandardItemFunc_insertColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_insertColumn_TypeError:
        const char* overloads[] = {"int, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem.insertColumn", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_insertColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertColumns", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // insertColumns(int,int)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::insertColumns(cpp_arg0, cpp_arg1);
    } else goto SbkQStandardItemFunc_insertColumns_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_insertColumns_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem.insertColumns", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_insertRow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertRow", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<QStandardItem* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStandardItem* cpp_arg1 = Shiboken::Converter<QStandardItem* >::toCpp(pyargs[1]);
            // insertRow(int,QStandardItem*)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            cppSelf->QStandardItem::insertRow(cpp_arg0, cpp_arg1);
        } else if (numArgs == 2 && Shiboken::Converter<QList<QStandardItem * >  >::isConvertible(pyargs[1])) {
            QList<QStandardItem * >  cpp_arg1 = Shiboken::Converter<QList<QStandardItem * >  >::toCpp(pyargs[1]);
            // insertRow(int,QList<QStandardItem*>)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            cppSelf->QStandardItem::insertRow(cpp_arg0, cpp_arg1);
        } else goto SbkQStandardItemFunc_insertRow_TypeError;
    } else goto SbkQStandardItemFunc_insertRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_insertRow_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QStandardItem", "int, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem.insertRow", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_insertRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertRows", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // insertRows(int,int)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            cppSelf->QStandardItem::insertRows(cpp_arg0, cpp_arg1);
        } else if (numArgs == 2 && Shiboken::Converter<QList<QStandardItem * >  >::isConvertible(pyargs[1])) {
            QList<QStandardItem * >  cpp_arg1 = Shiboken::Converter<QList<QStandardItem * >  >::toCpp(pyargs[1]);
            // insertRows(int,QList<QStandardItem*>)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            cppSelf->QStandardItem::insertRows(cpp_arg0, cpp_arg1);
        } else goto SbkQStandardItemFunc_insertRows_TypeError;
    } else goto SbkQStandardItemFunc_insertRows_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_insertRows_TypeError:
        const char* overloads[] = {"int, list", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem.insertRows", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_isCheckable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCheckable()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStandardItem::isCheckable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_isDragEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDragEnabled()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStandardItem::isDragEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_isDropEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDropEnabled()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStandardItem::isDropEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_isEditable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEditable()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStandardItem::isEditable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_isEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEnabled()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStandardItem::isEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_isSelectable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSelectable()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStandardItem::isSelectable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_isTristate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isTristate()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStandardItem::isTristate();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_model(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // model()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QStandardItemModel * cpp_result = cppSelf->QStandardItem::model();
    py_result = Shiboken::Converter<QStandardItemModel* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_parent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parent()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QStandardItem * cpp_result = cppSelf->QStandardItem::parent();
    py_result = Shiboken::Converter<QStandardItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_removeColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeColumn(int)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::removeColumn(cpp_arg0);
    } else goto SbkQStandardItemFunc_removeColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_removeColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.removeColumn", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_removeColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removeColumns", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // removeColumns(int,int)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::removeColumns(cpp_arg0, cpp_arg1);
    } else goto SbkQStandardItemFunc_removeColumns_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_removeColumns_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem.removeColumns", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_removeRow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeRow(int)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::removeRow(cpp_arg0);
    } else goto SbkQStandardItemFunc_removeRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_removeRow_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.removeRow", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_removeRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removeRows", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // removeRows(int,int)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::removeRows(cpp_arg0, cpp_arg1);
    } else goto SbkQStandardItemFunc_removeRows_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_removeRows_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem.removeRows", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_row(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // row()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStandardItem::row();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_rowCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rowCount()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStandardItem::rowCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_setAccessibleDescription(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setAccessibleDescription(QString)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setAccessibleDescription(*cpp_arg0);
    } else goto SbkQStandardItemFunc_setAccessibleDescription_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setAccessibleDescription_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setAccessibleDescription", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setAccessibleText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setAccessibleText(QString)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setAccessibleText(*cpp_arg0);
    } else goto SbkQStandardItemFunc_setAccessibleText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setAccessibleText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setAccessibleText", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setBackground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!Shiboken::Converter<QBrush& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setBackground(QBrush)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setBackground(*cpp_arg0);
    } else goto SbkQStandardItemFunc_setBackground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setBackground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setBackground", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setCheckState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::CheckState >::isConvertible(arg)) {
        Qt::CheckState cpp_arg0 = Shiboken::Converter<Qt::CheckState >::toCpp(arg);
        // setCheckState(Qt::CheckState)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setCheckState(cpp_arg0);
    } else goto SbkQStandardItemFunc_setCheckState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setCheckState_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CheckState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setCheckState", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setCheckable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setCheckable(bool)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setCheckable(cpp_arg0);
    } else goto SbkQStandardItemFunc_setCheckable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setCheckable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setCheckable", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setChild(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setChild", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 3 && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QStandardItem* >::isConvertible(pyargs[2])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QStandardItem* cpp_arg2 = Shiboken::Converter<QStandardItem* >::toCpp(pyargs[2]);
            // setChild(int,int,QStandardItem*)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            cppSelf->QStandardItem::setChild(cpp_arg0, cpp_arg1, cpp_arg2);
        } else if (numArgs == 2 && Shiboken::Converter<QStandardItem* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStandardItem* cpp_arg1 = Shiboken::Converter<QStandardItem* >::toCpp(pyargs[1]);
            // setChild(int,QStandardItem*)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            cppSelf->QStandardItem::setChild(cpp_arg0, cpp_arg1);
        } else goto SbkQStandardItemFunc_setChild_TypeError;
    } else goto SbkQStandardItemFunc_setChild_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setChild_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QStandardItem", "int, int, PySide.QtGui.QStandardItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem.setChild", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setColumnCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setColumnCount(int)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setColumnCount(cpp_arg0);
    } else goto SbkQStandardItemFunc_setColumnCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setColumnCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setColumnCount", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setData", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QVariant& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        if (numArgs == 1) {
            // setData(QVariant,int)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            cppSelf->QStandardItem::setData(*cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // setData(QVariant,int)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            cppSelf->QStandardItem::setData(*cpp_arg0, cpp_arg1);
        } else goto SbkQStandardItemFunc_setData_TypeError;
    } else goto SbkQStandardItemFunc_setData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant, int = Qt.UserRole + 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem.setData", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setDragEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDragEnabled(bool)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setDragEnabled(cpp_arg0);
    } else goto SbkQStandardItemFunc_setDragEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setDragEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setDragEnabled", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setDropEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDropEnabled(bool)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setDropEnabled(cpp_arg0);
    } else goto SbkQStandardItemFunc_setDropEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setDropEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setDropEnabled", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setEditable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setEditable(bool)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setEditable(cpp_arg0);
    } else goto SbkQStandardItemFunc_setEditable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setEditable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setEditable", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setEnabled(bool)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setEnabled(cpp_arg0);
    } else goto SbkQStandardItemFunc_setEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setEnabled", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_ItemFlag_Check(arg)) {
        QFlags<Qt::ItemFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toCpp(arg);
        // setFlags(QFlags<Qt::ItemFlag>)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setFlags(cpp_arg0);
    } else goto SbkQStandardItemFunc_setFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setFlags_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ItemFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setFlags", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!Shiboken::Converter<QFont& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setFont(QFont)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setFont(*cpp_arg0);
    } else goto SbkQStandardItemFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setFont", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setForeground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!Shiboken::Converter<QBrush& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setForeground(QBrush)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setForeground(*cpp_arg0);
    } else goto SbkQStandardItemFunc_setForeground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setForeground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setForeground", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setIcon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIcon& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(arg);
        if (!Shiboken::Converter<QIcon& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        // setIcon(QIcon)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setIcon(*cpp_arg0);
    } else goto SbkQStandardItemFunc_setIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setIcon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setIcon", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setRowCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setRowCount(int)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setRowCount(cpp_arg0);
    } else goto SbkQStandardItemFunc_setRowCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setRowCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setRowCount", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setSelectable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSelectable(bool)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setSelectable(cpp_arg0);
    } else goto SbkQStandardItemFunc_setSelectable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setSelectable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setSelectable", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setSizeHint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setSizeHint(QSize)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setSizeHint(*cpp_arg0);
    } else goto SbkQStandardItemFunc_setSizeHint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setSizeHint_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setSizeHint", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setStatusTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setStatusTip(QString)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setStatusTip(*cpp_arg0);
    } else goto SbkQStandardItemFunc_setStatusTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setStatusTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setStatusTip", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setText(QString)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setText(*cpp_arg0);
    } else goto SbkQStandardItemFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setText", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setTextAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setTextAlignment(QFlags<Qt::AlignmentFlag>)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setTextAlignment(cpp_arg0);
    } else goto SbkQStandardItemFunc_setTextAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setTextAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setTextAlignment", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setToolTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setToolTip(QString)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setToolTip(*cpp_arg0);
    } else goto SbkQStandardItemFunc_setToolTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setToolTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setToolTip", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setTristate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setTristate(bool)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setTristate(cpp_arg0);
    } else goto SbkQStandardItemFunc_setTristate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setTristate_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setTristate", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_setWhatsThis(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWhatsThis(QString)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        cppSelf->QStandardItem::setWhatsThis(*cpp_arg0);
    } else goto SbkQStandardItemFunc_setWhatsThis_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_setWhatsThis_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.setWhatsThis", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QStandardItem::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_sortChildren(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sortChildren", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sortChildren(int,Qt::SortOrder)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            cppSelf->QStandardItem::sortChildren(cpp_arg0);
        } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[1])) {
            Qt::SortOrder cpp_arg1 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[1]);
            // sortChildren(int,Qt::SortOrder)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            cppSelf->QStandardItem::sortChildren(cpp_arg0, cpp_arg1);
        } else goto SbkQStandardItemFunc_sortChildren_TypeError;
    } else goto SbkQStandardItemFunc_sortChildren_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemFunc_sortChildren_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem.sortChildren", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_statusTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // statusTip()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QStandardItem::statusTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_takeChild(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "takeChild", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // takeChild(int,int)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            QStandardItem * cpp_result = cppSelf->QStandardItem::takeChild(cpp_arg0);
            py_result = Shiboken::Converter<QStandardItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // takeChild(int,int)
            QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
            QStandardItem * cpp_result = cppSelf->QStandardItem::takeChild(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QStandardItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQStandardItemFunc_takeChild_TypeError;
    } else goto SbkQStandardItemFunc_takeChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStandardItemFunc_takeChild_TypeError:
        const char* overloads[] = {"int, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItem.takeChild", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_takeColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeColumn(int)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        QList<QStandardItem * > cpp_result = cppSelf->QStandardItem::takeColumn(cpp_arg0);
        py_result = Shiboken::Converter<QList<QStandardItem * > >::toPython(cpp_result);
    } else goto SbkQStandardItemFunc_takeColumn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStandardItemFunc_takeColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.takeColumn", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_takeRow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeRow(int)
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        QList<QStandardItem * > cpp_result = cppSelf->QStandardItem::takeRow(cpp_arg0);
        py_result = Shiboken::Converter<QList<QStandardItem * > >::toPython(cpp_result);
    } else goto SbkQStandardItemFunc_takeRow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStandardItemFunc_takeRow_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.takeRow", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QStandardItem::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_textAlignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textAlignment()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QStandardItem::textAlignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_toolTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toolTip()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QStandardItem::toolTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStandardItem::type();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStandardItemFunc_whatsThis(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // whatsThis()const
    QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QStandardItem::whatsThis();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQStandardItem_methods[] = {
    {"accessibleDescription", (PyCFunction)SbkQStandardItemFunc_accessibleDescription, METH_NOARGS},
    {"accessibleText", (PyCFunction)SbkQStandardItemFunc_accessibleText, METH_NOARGS},
    {"appendColumn", (PyCFunction)SbkQStandardItemFunc_appendColumn, METH_O},
    {"appendRow", (PyCFunction)SbkQStandardItemFunc_appendRow, METH_O},
    {"appendRows", (PyCFunction)SbkQStandardItemFunc_appendRows, METH_O},
    {"background", (PyCFunction)SbkQStandardItemFunc_background, METH_NOARGS},
    {"checkState", (PyCFunction)SbkQStandardItemFunc_checkState, METH_NOARGS},
    {"child", (PyCFunction)SbkQStandardItemFunc_child, METH_VARARGS},
    {"clone", (PyCFunction)SbkQStandardItemFunc_clone, METH_NOARGS},
    {"column", (PyCFunction)SbkQStandardItemFunc_column, METH_NOARGS},
    {"columnCount", (PyCFunction)SbkQStandardItemFunc_columnCount, METH_NOARGS},
    {"data", (PyCFunction)SbkQStandardItemFunc_data, METH_NOARGS|METH_O},
    {"emitDataChanged", (PyCFunction)SbkQStandardItemFunc_emitDataChanged, METH_NOARGS},
    {"flags", (PyCFunction)SbkQStandardItemFunc_flags, METH_NOARGS},
    {"font", (PyCFunction)SbkQStandardItemFunc_font, METH_NOARGS},
    {"foreground", (PyCFunction)SbkQStandardItemFunc_foreground, METH_NOARGS},
    {"hasChildren", (PyCFunction)SbkQStandardItemFunc_hasChildren, METH_NOARGS},
    {"icon", (PyCFunction)SbkQStandardItemFunc_icon, METH_NOARGS},
    {"index", (PyCFunction)SbkQStandardItemFunc_index, METH_NOARGS},
    {"insertColumn", (PyCFunction)SbkQStandardItemFunc_insertColumn, METH_VARARGS},
    {"insertColumns", (PyCFunction)SbkQStandardItemFunc_insertColumns, METH_VARARGS},
    {"insertRow", (PyCFunction)SbkQStandardItemFunc_insertRow, METH_VARARGS},
    {"insertRows", (PyCFunction)SbkQStandardItemFunc_insertRows, METH_VARARGS},
    {"isCheckable", (PyCFunction)SbkQStandardItemFunc_isCheckable, METH_NOARGS},
    {"isDragEnabled", (PyCFunction)SbkQStandardItemFunc_isDragEnabled, METH_NOARGS},
    {"isDropEnabled", (PyCFunction)SbkQStandardItemFunc_isDropEnabled, METH_NOARGS},
    {"isEditable", (PyCFunction)SbkQStandardItemFunc_isEditable, METH_NOARGS},
    {"isEnabled", (PyCFunction)SbkQStandardItemFunc_isEnabled, METH_NOARGS},
    {"isSelectable", (PyCFunction)SbkQStandardItemFunc_isSelectable, METH_NOARGS},
    {"isTristate", (PyCFunction)SbkQStandardItemFunc_isTristate, METH_NOARGS},
    {"model", (PyCFunction)SbkQStandardItemFunc_model, METH_NOARGS},
    {"parent", (PyCFunction)SbkQStandardItemFunc_parent, METH_NOARGS},
    {"removeColumn", (PyCFunction)SbkQStandardItemFunc_removeColumn, METH_O},
    {"removeColumns", (PyCFunction)SbkQStandardItemFunc_removeColumns, METH_VARARGS},
    {"removeRow", (PyCFunction)SbkQStandardItemFunc_removeRow, METH_O},
    {"removeRows", (PyCFunction)SbkQStandardItemFunc_removeRows, METH_VARARGS},
    {"row", (PyCFunction)SbkQStandardItemFunc_row, METH_NOARGS},
    {"rowCount", (PyCFunction)SbkQStandardItemFunc_rowCount, METH_NOARGS},
    {"setAccessibleDescription", (PyCFunction)SbkQStandardItemFunc_setAccessibleDescription, METH_O},
    {"setAccessibleText", (PyCFunction)SbkQStandardItemFunc_setAccessibleText, METH_O},
    {"setBackground", (PyCFunction)SbkQStandardItemFunc_setBackground, METH_O},
    {"setCheckState", (PyCFunction)SbkQStandardItemFunc_setCheckState, METH_O},
    {"setCheckable", (PyCFunction)SbkQStandardItemFunc_setCheckable, METH_O},
    {"setChild", (PyCFunction)SbkQStandardItemFunc_setChild, METH_VARARGS},
    {"setColumnCount", (PyCFunction)SbkQStandardItemFunc_setColumnCount, METH_O},
    {"setData", (PyCFunction)SbkQStandardItemFunc_setData, METH_VARARGS},
    {"setDragEnabled", (PyCFunction)SbkQStandardItemFunc_setDragEnabled, METH_O},
    {"setDropEnabled", (PyCFunction)SbkQStandardItemFunc_setDropEnabled, METH_O},
    {"setEditable", (PyCFunction)SbkQStandardItemFunc_setEditable, METH_O},
    {"setEnabled", (PyCFunction)SbkQStandardItemFunc_setEnabled, METH_O},
    {"setFlags", (PyCFunction)SbkQStandardItemFunc_setFlags, METH_O},
    {"setFont", (PyCFunction)SbkQStandardItemFunc_setFont, METH_O},
    {"setForeground", (PyCFunction)SbkQStandardItemFunc_setForeground, METH_O},
    {"setIcon", (PyCFunction)SbkQStandardItemFunc_setIcon, METH_O},
    {"setRowCount", (PyCFunction)SbkQStandardItemFunc_setRowCount, METH_O},
    {"setSelectable", (PyCFunction)SbkQStandardItemFunc_setSelectable, METH_O},
    {"setSizeHint", (PyCFunction)SbkQStandardItemFunc_setSizeHint, METH_O},
    {"setStatusTip", (PyCFunction)SbkQStandardItemFunc_setStatusTip, METH_O},
    {"setText", (PyCFunction)SbkQStandardItemFunc_setText, METH_O},
    {"setTextAlignment", (PyCFunction)SbkQStandardItemFunc_setTextAlignment, METH_O},
    {"setToolTip", (PyCFunction)SbkQStandardItemFunc_setToolTip, METH_O},
    {"setTristate", (PyCFunction)SbkQStandardItemFunc_setTristate, METH_O},
    {"setWhatsThis", (PyCFunction)SbkQStandardItemFunc_setWhatsThis, METH_O},
    {"sizeHint", (PyCFunction)SbkQStandardItemFunc_sizeHint, METH_NOARGS},
    {"sortChildren", (PyCFunction)SbkQStandardItemFunc_sortChildren, METH_VARARGS},
    {"statusTip", (PyCFunction)SbkQStandardItemFunc_statusTip, METH_NOARGS},
    {"takeChild", (PyCFunction)SbkQStandardItemFunc_takeChild, METH_VARARGS},
    {"takeColumn", (PyCFunction)SbkQStandardItemFunc_takeColumn, METH_O},
    {"takeRow", (PyCFunction)SbkQStandardItemFunc_takeRow, METH_O},
    {"text", (PyCFunction)SbkQStandardItemFunc_text, METH_NOARGS},
    {"textAlignment", (PyCFunction)SbkQStandardItemFunc_textAlignment, METH_NOARGS},
    {"toolTip", (PyCFunction)SbkQStandardItemFunc_toolTip, METH_NOARGS},
    {"type", (PyCFunction)SbkQStandardItemFunc_type, METH_NOARGS},
    {"whatsThis", (PyCFunction)SbkQStandardItemFunc_whatsThis, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQStandardItemFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQStandardItem_Check(arg) && !SbkQStandardItem_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QStandardItem) [reverse operator]
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQStandardItemFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStandardItemFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQStandardItemFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQStandardItem_Check(arg) && !SbkQStandardItem_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QStandardItem&) [reverse operator]
        QStandardItem* cppSelf = Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQStandardItemFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStandardItemFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItem.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQStandardItem_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQStandardItemFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQStandardItemFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQStandardItem_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QStandardItem& cpp_self = *Shiboken::Converter<QStandardItem* >::toCpp((PyObject*)self);

    switch (op) {
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQStandardItem_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStandardItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStandardItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStandardItemWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQStandardItem_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQStandardItem_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStandardItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStandardItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQStandardItem_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQStandardItem_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QStandardItem*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtGui_QStandardItem_ItemType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStandardItem_ItemType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStandardItem_ItemType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ItemType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStandardItem_ItemType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStandardItem_ItemType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QStandardItem_ItemType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QStandardItem(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTANDARDITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStandardItem_Type);

    // Fill type discovery information
    SbkQStandardItem_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQStandardItem_Type.type_discovery->addTypeDiscoveryFunction(&SbkQStandardItem_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQStandardItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStandardItem_Type));
    PyModule_AddObject(module, "QStandardItem",
        ((PyObject*)&SbkQStandardItem_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ItemType
    SbkPySide_QtGuiTypes[SBK_QSTANDARDITEM_ITEMTYPE_IDX] = &SbkPySide_QtGui_QStandardItem_ItemType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStandardItem_ItemType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStandardItem_ItemType_Type);
    PyDict_SetItemString(SbkQStandardItem_Type.super.ht_type.tp_dict,
            "ItemType",((PyObject*)&SbkPySide_QtGui_QStandardItem_ItemType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStandardItem_ItemType_Type,
        (long) QStandardItem::Type, "Type");
    PyDict_SetItemString(SbkQStandardItem_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStandardItem_ItemType_Type.tp_dict,
        "Type", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStandardItem_ItemType_Type,
        (long) QStandardItem::UserType, "UserType");
    PyDict_SetItemString(SbkQStandardItem_Type.super.ht_type.tp_dict,
        "UserType", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStandardItem_ItemType_Type.tp_dict,
        "UserType", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStandardItem::ItemType");

    Shiboken::TypeResolver::createObjectTypeResolver<QStandardItem >("QStandardItem*");
    Shiboken::TypeResolver::createObjectTypeResolver<QStandardItem >(typeid(QStandardItem).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

