/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qsessionmanager_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

static PyObject*
SbkQSessionManagerFunc_allowsErrorInteraction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // allowsErrorInteraction()
    QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSessionManager::allowsErrorInteraction();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSessionManagerFunc_allowsInteraction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // allowsInteraction()
    QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSessionManager::allowsInteraction();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSessionManagerFunc_cancel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // cancel()
    QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
    cppSelf->QSessionManager::cancel();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSessionManagerFunc_discardCommand(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // discardCommand()const
    QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QSessionManager::discardCommand();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSessionManagerFunc_isPhase2(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isPhase2()const
    QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSessionManager::isPhase2();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSessionManagerFunc_release(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // release()
    QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
    cppSelf->QSessionManager::release();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSessionManagerFunc_requestPhase2(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // requestPhase2()
    QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
    cppSelf->QSessionManager::requestPhase2();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSessionManagerFunc_restartCommand(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // restartCommand()const
    QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QSessionManager::restartCommand();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSessionManagerFunc_restartHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // restartHint()const
    QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
    QSessionManager::RestartHint cpp_result = cppSelf->QSessionManager::restartHint();
    py_result = Shiboken::Converter<QSessionManager::RestartHint >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSessionManagerFunc_sessionId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sessionId()const
    QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSessionManager::sessionId();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSessionManagerFunc_sessionKey(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sessionKey()const
    QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSessionManager::sessionKey();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSessionManagerFunc_setDiscardCommand(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setDiscardCommand(QStringList)
        QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
        cppSelf->QSessionManager::setDiscardCommand(*cpp_arg0);
    } else goto SbkQSessionManagerFunc_setDiscardCommand_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSessionManagerFunc_setDiscardCommand_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSessionManager.setDiscardCommand", overloads);
        return 0;
}

static PyObject*
SbkQSessionManagerFunc_setManagerProperty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setManagerProperty", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 2 && Shiboken::Converter<QStringList& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
            QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QStringList& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
            // setManagerProperty(QString,QStringList)
            QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
            cppSelf->QSessionManager::setManagerProperty(*cpp_arg0, *cpp_arg1);
        } else if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // setManagerProperty(QString,QString)
            QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
            cppSelf->QSessionManager::setManagerProperty(*cpp_arg0, *cpp_arg1);
        } else goto SbkQSessionManagerFunc_setManagerProperty_TypeError;
    } else goto SbkQSessionManagerFunc_setManagerProperty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSessionManagerFunc_setManagerProperty_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSessionManager.setManagerProperty", overloads);
        return 0;
}

static PyObject*
SbkQSessionManagerFunc_setRestartCommand(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setRestartCommand(QStringList)
        QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
        cppSelf->QSessionManager::setRestartCommand(*cpp_arg0);
    } else goto SbkQSessionManagerFunc_setRestartCommand_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSessionManagerFunc_setRestartCommand_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSessionManager.setRestartCommand", overloads);
        return 0;
}

static PyObject*
SbkQSessionManagerFunc_setRestartHint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSessionManager::RestartHint >::isConvertible(arg)) {
        QSessionManager::RestartHint cpp_arg0 = Shiboken::Converter<QSessionManager::RestartHint >::toCpp(arg);
        // setRestartHint(QSessionManager::RestartHint)
        QSessionManager* cppSelf = Shiboken::Converter<QSessionManager* >::toCpp((PyObject*)self);
        cppSelf->QSessionManager::setRestartHint(cpp_arg0);
    } else goto SbkQSessionManagerFunc_setRestartHint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSessionManagerFunc_setRestartHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSessionManager.RestartHint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSessionManager.setRestartHint", overloads);
        return 0;
}

static PyMethodDef SbkQSessionManager_methods[] = {
    {"allowsErrorInteraction", (PyCFunction)SbkQSessionManagerFunc_allowsErrorInteraction, METH_NOARGS},
    {"allowsInteraction", (PyCFunction)SbkQSessionManagerFunc_allowsInteraction, METH_NOARGS},
    {"cancel", (PyCFunction)SbkQSessionManagerFunc_cancel, METH_NOARGS},
    {"discardCommand", (PyCFunction)SbkQSessionManagerFunc_discardCommand, METH_NOARGS},
    {"isPhase2", (PyCFunction)SbkQSessionManagerFunc_isPhase2, METH_NOARGS},
    {"release", (PyCFunction)SbkQSessionManagerFunc_release, METH_NOARGS},
    {"requestPhase2", (PyCFunction)SbkQSessionManagerFunc_requestPhase2, METH_NOARGS},
    {"restartCommand", (PyCFunction)SbkQSessionManagerFunc_restartCommand, METH_NOARGS},
    {"restartHint", (PyCFunction)SbkQSessionManagerFunc_restartHint, METH_NOARGS},
    {"sessionId", (PyCFunction)SbkQSessionManagerFunc_sessionId, METH_NOARGS},
    {"sessionKey", (PyCFunction)SbkQSessionManagerFunc_sessionKey, METH_NOARGS},
    {"setDiscardCommand", (PyCFunction)SbkQSessionManagerFunc_setDiscardCommand, METH_O},
    {"setManagerProperty", (PyCFunction)SbkQSessionManagerFunc_setManagerProperty, METH_VARARGS},
    {"setRestartCommand", (PyCFunction)SbkQSessionManagerFunc_setRestartCommand, METH_O},
    {"setRestartHint", (PyCFunction)SbkQSessionManagerFunc_setRestartHint, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSessionManager_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QSessionManager",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          Shiboken::SbkBaseWrapper_Dealloc_PrivateDtor,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSessionManager_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QSessionManager_RestartHint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QSessionManager_RestartHint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QSessionManager_RestartHint_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RestartHint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QSessionManager_RestartHint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QSessionManager_RestartHint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QSessionManager_RestartHint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSessionManager(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSESSIONMANAGER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSessionManager_Type);

    SbkQSessionManager_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQSessionManager_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSessionManager_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSessionManager_Type));
    PyModule_AddObject(module, "QSessionManager",
        ((PyObject*)&SbkQSessionManager_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: RestartHint
    SbkPySide_QtGuiTypes[SBK_QSESSIONMANAGER_RESTARTHINT_IDX] = &SbkPySide_QtGui_QSessionManager_RestartHint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QSessionManager_RestartHint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QSessionManager_RestartHint_Type);
    PyDict_SetItemString(SbkQSessionManager_Type.super.ht_type.tp_dict,
            "RestartHint",((PyObject*)&SbkPySide_QtGui_QSessionManager_RestartHint_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSessionManager_RestartHint_Type,
        (long) QSessionManager::RestartIfRunning, "RestartIfRunning");
    PyDict_SetItemString(SbkQSessionManager_Type.super.ht_type.tp_dict,
        "RestartIfRunning", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSessionManager_RestartHint_Type.tp_dict,
        "RestartIfRunning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSessionManager_RestartHint_Type,
        (long) QSessionManager::RestartAnyway, "RestartAnyway");
    PyDict_SetItemString(SbkQSessionManager_Type.super.ht_type.tp_dict,
        "RestartAnyway", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSessionManager_RestartHint_Type.tp_dict,
        "RestartAnyway", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSessionManager_RestartHint_Type,
        (long) QSessionManager::RestartImmediately, "RestartImmediately");
    PyDict_SetItemString(SbkQSessionManager_Type.super.ht_type.tp_dict,
        "RestartImmediately", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSessionManager_RestartHint_Type.tp_dict,
        "RestartImmediately", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSessionManager_RestartHint_Type,
        (long) QSessionManager::RestartNever, "RestartNever");
    PyDict_SetItemString(SbkQSessionManager_Type.super.ht_type.tp_dict,
        "RestartNever", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSessionManager_RestartHint_Type.tp_dict,
        "RestartNever", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSessionManager::RestartHint");

    Shiboken::TypeResolver::createObjectTypeResolver<QSessionManager >("QSessionManager*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSessionManager >(typeid(QSessionManager).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

