/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qradialgradient_wrapper.h"

// Extra includes
#include <QPair>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qpoint.h>

using namespace Shiboken;

static int
SbkQRadialGradient_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QRadialGradient* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 1 || numArgs == 4)
        goto SbkQRadialGradient_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QRadialGradient", 0, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return -1;

    if (numArgs == 0) {
        // QRadialGradient()
        cptr = new QRadialGradient();
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // QRadialGradient(qreal,qreal,qreal)
            cptr = new QRadialGradient(cpp_arg0, cpp_arg1, cpp_arg2);
        } else if (numArgs == 5 && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4])) {
            qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
            qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
            // QRadialGradient(qreal,qreal,qreal,qreal,qreal)
            cptr = new QRadialGradient(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
        } else goto SbkQRadialGradient_Init_TypeError;
    } else if (Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QRadialGradient(QPointF,qreal)
            cptr = new QRadialGradient(*cpp_arg0, cpp_arg1);
        } else if (numArgs == 3 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            std::auto_ptr<QPointF > cpp_arg2_auto_ptr;
            QPointF* cpp_arg2 = Shiboken::Converter<QPointF* >::toCpp(pyargs[2]);
            if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QPointF >(cpp_arg2);
            // QRadialGradient(QPointF,qreal,QPointF)
            cptr = new QRadialGradient(*cpp_arg0, cpp_arg1, *cpp_arg2);
        } else goto SbkQRadialGradient_Init_TypeError;
    } else goto SbkQRadialGradient_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQRadialGradient_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQRadialGradient_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QPointF, float", "PySide.QtCore.QPointF, float, PySide.QtCore.QPointF", "float, float, float", "float, float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QRadialGradient", overloads);
        return -1;
}

static PyObject*
SbkQRadialGradientFunc_center(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // center()const
    QRadialGradient* cppSelf = Shiboken::Converter<QRadialGradient* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QRadialGradient::center();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQRadialGradientFunc_focalPoint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // focalPoint()const
    QRadialGradient* cppSelf = Shiboken::Converter<QRadialGradient* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QRadialGradient::focalPoint();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQRadialGradientFunc_radius(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // radius()const
    QRadialGradient* cppSelf = Shiboken::Converter<QRadialGradient* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QRadialGradient::radius();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQRadialGradientFunc_setCenter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setCenter", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setCenter(qreal,qreal)
        QRadialGradient* cppSelf = Shiboken::Converter<QRadialGradient* >::toCpp((PyObject*)self);
        cppSelf->QRadialGradient::setCenter(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setCenter(QPointF)
        QRadialGradient* cppSelf = Shiboken::Converter<QRadialGradient* >::toCpp((PyObject*)self);
        cppSelf->QRadialGradient::setCenter(*cpp_arg0);
    } else goto SbkQRadialGradientFunc_setCenter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRadialGradientFunc_setCenter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QRadialGradient.setCenter", overloads);
        return 0;
}

static PyObject*
SbkQRadialGradientFunc_setFocalPoint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFocalPoint", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setFocalPoint(qreal,qreal)
        QRadialGradient* cppSelf = Shiboken::Converter<QRadialGradient* >::toCpp((PyObject*)self);
        cppSelf->QRadialGradient::setFocalPoint(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setFocalPoint(QPointF)
        QRadialGradient* cppSelf = Shiboken::Converter<QRadialGradient* >::toCpp((PyObject*)self);
        cppSelf->QRadialGradient::setFocalPoint(*cpp_arg0);
    } else goto SbkQRadialGradientFunc_setFocalPoint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRadialGradientFunc_setFocalPoint_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QRadialGradient.setFocalPoint", overloads);
        return 0;
}

static PyObject*
SbkQRadialGradientFunc_setRadius(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setRadius(qreal)
        QRadialGradient* cppSelf = Shiboken::Converter<QRadialGradient* >::toCpp((PyObject*)self);
        cppSelf->QRadialGradient::setRadius(cpp_arg0);
    } else goto SbkQRadialGradientFunc_setRadius_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRadialGradientFunc_setRadius_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRadialGradient.setRadius", overloads);
        return 0;
}

static PyMethodDef SbkQRadialGradient_methods[] = {
    {"center", (PyCFunction)SbkQRadialGradientFunc_center, METH_NOARGS},
    {"focalPoint", (PyCFunction)SbkQRadialGradientFunc_focalPoint, METH_NOARGS},
    {"radius", (PyCFunction)SbkQRadialGradientFunc_radius, METH_NOARGS},
    {"setCenter", (PyCFunction)SbkQRadialGradientFunc_setCenter, METH_VARARGS},
    {"setFocalPoint", (PyCFunction)SbkQRadialGradientFunc_setFocalPoint, METH_VARARGS},
    {"setRadius", (PyCFunction)SbkQRadialGradientFunc_setRadius, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQRadialGradient_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QRadialGradient",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QRadialGradient >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQRadialGradient_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQRadialGradient_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QRadialGradient(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QRADIALGRADIENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQRadialGradient_Type);

    SbkQRadialGradient_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRADIENT_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQRadialGradient_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQRadialGradient_Type));
    PyModule_AddObject(module, "QRadialGradient",
        ((PyObject*)&SbkQRadialGradient_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QRadialGradient >("QRadialGradient");
    Shiboken::TypeResolver::createValueTypeResolver<QRadialGradient >(typeid(QRadialGradient).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

