/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qprinter_wrapper.h"

// Extra includes
#include <QList>
#include <QPrinterInfo>
#include <qpaintengine.h>
#include <qprintengine.h>
#include <qprinter.h>
#include <qprinterinfo.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPrinterWrapper::QPrinterWrapper(QPrinter::PrinterMode mode) : QPrinter(mode) {
    // ... middle
}

QPrinterWrapper::QPrinterWrapper(const QPrinterInfo & printer, QPrinter::PrinterMode mode) : QPrinter(printer, mode) {
    // ... middle
}

int QPrinterWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QPrinter::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPrinter.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QPrinterWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QPrinter::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPrinter.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QPaintEngine * QPrinterWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QPrinter::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPrinter.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QPrinterWrapper::~QPrinterWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQPrinter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPrinterWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QPrinter", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QPrinter(QPrinter::PrinterMode)
        cptr = new QPrinterWrapper();
    } else if (Shiboken::Converter<QPrinterInfo& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPrinterInfo > cpp_arg0_auto_ptr;
        QPrinterInfo* cpp_arg0 = Shiboken::Converter<QPrinterInfo* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPrinterInfo& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPrinterInfo >(cpp_arg0);
        if (numArgs == 1) {
            // QPrinter(QPrinterInfo,QPrinter::PrinterMode)
            cptr = new QPrinterWrapper(*cpp_arg0);
        } else if (Shiboken::Converter<QPrinter::PrinterMode >::isConvertible(pyargs[1])) {
            QPrinter::PrinterMode cpp_arg1 = Shiboken::Converter<QPrinter::PrinterMode >::toCpp(pyargs[1]);
            // QPrinter(QPrinterInfo,QPrinter::PrinterMode)
            cptr = new QPrinterWrapper(*cpp_arg0, cpp_arg1);
        } else goto SbkQPrinter_Init_TypeError;
    } else if (Shiboken::Converter<QPrinter::PrinterMode >::isConvertible(pyargs[0])) {
        QPrinter::PrinterMode cpp_arg0 = Shiboken::Converter<QPrinter::PrinterMode >::toCpp(pyargs[0]);
        // QPrinter(QPrinter::PrinterMode)
        cptr = new QPrinterWrapper(cpp_arg0);
    } else goto SbkQPrinter_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPrinter_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQPrinter_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter.PrinterMode = ScreenResolution", "PySide.QtGui.QPrinterInfo, PySide.QtGui.QPrinter.PrinterMode = ScreenResolution", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPrinter", overloads);
        return -1;
}

static PyObject*
SbkQPrinterFunc_abort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // abort()
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPrinter::abort();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_actualNumCopies(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // actualNumCopies()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPrinter::actualNumCopies();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_collateCopies(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // collateCopies()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPrinter::collateCopies();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_colorMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // colorMode()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QPrinter::ColorMode cpp_result = cppSelf->QPrinter::colorMode();
    py_result = Shiboken::Converter<QPrinter::ColorMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_creator(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // creator()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QPrinter::creator();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_devType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // devType()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPrinter::devType();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_docName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // docName()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QPrinter::docName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_doubleSidedPrinting(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // doubleSidedPrinting()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPrinter::doubleSidedPrinting();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_duplex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // duplex()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QPrinter::DuplexMode cpp_result = cppSelf->QPrinter::duplex();
    py_result = Shiboken::Converter<QPrinter::DuplexMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_fontEmbeddingEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontEmbeddingEnabled()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPrinter::fontEmbeddingEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_fromPage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fromPage()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPrinter::fromPage();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_fullPage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fullPage()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPrinter::fullPage();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPrinter::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_metric(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::isConvertible(arg)) {
        QPaintDevice::PaintDeviceMetric cpp_arg0 = Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toCpp(arg);
        // metric(QPaintDevice::PaintDeviceMetric)const
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QPrinter::metric(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQPrinterFunc_metric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPrinterFunc_metric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice.PaintDeviceMetric", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.metric", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_newPage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // newPage()
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPrinter::newPage();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_numCopies(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numCopies()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPrinter::numCopies();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_orientation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // orientation()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QPrinter::Orientation cpp_result = cppSelf->QPrinter::orientation();
    py_result = Shiboken::Converter<QPrinter::Orientation >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_outputFileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // outputFileName()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QPrinter::outputFileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_outputFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // outputFormat()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QPrinter::OutputFormat cpp_result = cppSelf->QPrinter::outputFormat();
    py_result = Shiboken::Converter<QPrinter::OutputFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_pageOrder(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pageOrder()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QPrinter::PageOrder cpp_result = cppSelf->QPrinter::pageOrder();
    py_result = Shiboken::Converter<QPrinter::PageOrder >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_pageRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // pageRect()const
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QPrinter::pageRect();
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPrinter::Unit >::isConvertible(arg)) {
        QPrinter::Unit cpp_arg0 = Shiboken::Converter<QPrinter::Unit >::toCpp(arg);
        // pageRect(QPrinter::Unit)const
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QPrinter::pageRect(cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQPrinterFunc_pageRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPrinterFunc_pageRect_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPrinter.Unit", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.pageRect", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_pageSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pageSize()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QPrinter::PageSize cpp_result = cppSelf->QPrinter::pageSize();
    py_result = Shiboken::Converter<QPrinter::PageSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_paintEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintEngine()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QPaintEngine * cpp_result = cppSelf->QPrinter::paintEngine();
    py_result = Shiboken::Converter<QPaintEngine* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_paperRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // paperRect()const
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QPrinter::paperRect();
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPrinter::Unit >::isConvertible(arg)) {
        QPrinter::Unit cpp_arg0 = Shiboken::Converter<QPrinter::Unit >::toCpp(arg);
        // paperRect(QPrinter::Unit)const
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QPrinter::paperRect(cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQPrinterFunc_paperRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPrinterFunc_paperRect_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPrinter.Unit", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.paperRect", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_paperSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // paperSize()const
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        QPrinter::PageSize cpp_result = cppSelf->QPrinter::paperSize();
        py_result = Shiboken::Converter<QPrinter::PageSize >::toPython(cpp_result);
    } else if (Shiboken::Converter<QPrinter::Unit >::isConvertible(arg)) {
        QPrinter::Unit cpp_arg0 = Shiboken::Converter<QPrinter::Unit >::toCpp(arg);
        // paperSize(QPrinter::Unit)const
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        QSizeF cpp_result = cppSelf->QPrinter::paperSize(cpp_arg0);
        py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    } else goto SbkQPrinterFunc_paperSize_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPrinterFunc_paperSize_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPrinter.Unit", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.paperSize", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_paperSource(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paperSource()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QPrinter::PaperSource cpp_result = cppSelf->QPrinter::paperSource();
    py_result = Shiboken::Converter<QPrinter::PaperSource >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_printEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // printEngine()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QPrintEngine * cpp_result = cppSelf->QPrinter::printEngine();
    py_result = Shiboken::Converter<QPrintEngine* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_printProgram(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // printProgram()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QPrinter::printProgram();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_printRange(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // printRange()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QPrinter::PrintRange cpp_result = cppSelf->QPrinter::printRange();
    py_result = Shiboken::Converter<QPrinter::PrintRange >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_printerName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // printerName()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QPrinter::printerName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_printerState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // printerState()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QPrinter::PrinterState cpp_result = cppSelf->QPrinter::printerState();
    py_result = Shiboken::Converter<QPrinter::PrinterState >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_resolution(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // resolution()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPrinter::resolution();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_setCollateCopies(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setCollateCopies(bool)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setCollateCopies(cpp_arg0);
    } else goto SbkQPrinterFunc_setCollateCopies_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setCollateCopies_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setCollateCopies", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setColorMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter::ColorMode >::isConvertible(arg)) {
        QPrinter::ColorMode cpp_arg0 = Shiboken::Converter<QPrinter::ColorMode >::toCpp(arg);
        // setColorMode(QPrinter::ColorMode)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setColorMode(cpp_arg0);
    } else goto SbkQPrinterFunc_setColorMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setColorMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter.ColorMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setColorMode", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setCreator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setCreator(QString)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setCreator(*cpp_arg0);
    } else goto SbkQPrinterFunc_setCreator_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setCreator_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setCreator", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setDocName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDocName(QString)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setDocName(*cpp_arg0);
    } else goto SbkQPrinterFunc_setDocName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setDocName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setDocName", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setDoubleSidedPrinting(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDoubleSidedPrinting(bool)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setDoubleSidedPrinting(cpp_arg0);
    } else goto SbkQPrinterFunc_setDoubleSidedPrinting_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setDoubleSidedPrinting_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setDoubleSidedPrinting", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setDuplex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter::DuplexMode >::isConvertible(arg)) {
        QPrinter::DuplexMode cpp_arg0 = Shiboken::Converter<QPrinter::DuplexMode >::toCpp(arg);
        // setDuplex(QPrinter::DuplexMode)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setDuplex(cpp_arg0);
    } else goto SbkQPrinterFunc_setDuplex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setDuplex_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter.DuplexMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setDuplex", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setEngines(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setEngines", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPrintEngine* >::isConvertible(pyargs[0]) && Shiboken::Converter<QPaintEngine* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPrintEngine* cpp_arg0 = Shiboken::Converter<QPrintEngine* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QPaintEngine* cpp_arg1 = Shiboken::Converter<QPaintEngine* >::toCpp(pyargs[1]);
        // setEngines(QPrintEngine*,QPaintEngine*)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setEngines(cpp_arg0, cpp_arg1);
        Shiboken::setParent(self, pyargs[0]);
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQPrinterFunc_setEngines_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setEngines_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrintEngine, PySide.QtGui.QPaintEngine", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPrinter.setEngines", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setFontEmbeddingEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFontEmbeddingEnabled(bool)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setFontEmbeddingEnabled(cpp_arg0);
    } else goto SbkQPrinterFunc_setFontEmbeddingEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setFontEmbeddingEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setFontEmbeddingEnabled", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setFromTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFromTo", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setFromTo(int,int)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setFromTo(cpp_arg0, cpp_arg1);
    } else goto SbkQPrinterFunc_setFromTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setFromTo_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPrinter.setFromTo", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setFullPage(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFullPage(bool)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setFullPage(cpp_arg0);
    } else goto SbkQPrinterFunc_setFullPage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setFullPage_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setFullPage", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setNumCopies(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setNumCopies(int)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setNumCopies(cpp_arg0);
    } else goto SbkQPrinterFunc_setNumCopies_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setNumCopies_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setNumCopies", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setOrientation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter::Orientation >::isConvertible(arg)) {
        QPrinter::Orientation cpp_arg0 = Shiboken::Converter<QPrinter::Orientation >::toCpp(arg);
        // setOrientation(QPrinter::Orientation)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setOrientation(cpp_arg0);
    } else goto SbkQPrinterFunc_setOrientation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setOrientation_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setOrientation", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setOutputFileName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setOutputFileName(QString)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setOutputFileName(*cpp_arg0);
    } else goto SbkQPrinterFunc_setOutputFileName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setOutputFileName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setOutputFileName", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setOutputFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter::OutputFormat >::isConvertible(arg)) {
        QPrinter::OutputFormat cpp_arg0 = Shiboken::Converter<QPrinter::OutputFormat >::toCpp(arg);
        // setOutputFormat(QPrinter::OutputFormat)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setOutputFormat(cpp_arg0);
    } else goto SbkQPrinterFunc_setOutputFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setOutputFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter.OutputFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setOutputFormat", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setPageMargins(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setPageMargins", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && Shiboken::Converter<QPrinter::Unit >::isConvertible(pyargs[4])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        QPrinter::Unit cpp_arg4 = Shiboken::Converter<QPrinter::Unit >::toCpp(pyargs[4]);
        // setPageMargins(qreal,qreal,qreal,qreal,QPrinter::Unit)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setPageMargins(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
    } else goto SbkQPrinterFunc_setPageMargins_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setPageMargins_TypeError:
        const char* overloads[] = {"float, float, float, float, PySide.QtGui.QPrinter.Unit", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPrinter.setPageMargins", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setPageOrder(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter::PageOrder >::isConvertible(arg)) {
        QPrinter::PageOrder cpp_arg0 = Shiboken::Converter<QPrinter::PageOrder >::toCpp(arg);
        // setPageOrder(QPrinter::PageOrder)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setPageOrder(cpp_arg0);
    } else goto SbkQPrinterFunc_setPageOrder_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setPageOrder_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter.PageOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setPageOrder", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setPageSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter::PageSize >::isConvertible(arg)) {
        QPrinter::PageSize cpp_arg0 = Shiboken::Converter<QPrinter::PageSize >::toCpp(arg);
        // setPageSize(QPrinter::PageSize)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setPageSize(cpp_arg0);
    } else goto SbkQPrinterFunc_setPageSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setPageSize_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter.PageSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setPageSize", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setPaperSize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPaperSize", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QSizeF& >::isConvertible(pyargs[0]) && Shiboken::Converter<QPrinter::Unit >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QSizeF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        QPrinter::Unit cpp_arg1 = Shiboken::Converter<QPrinter::Unit >::toCpp(pyargs[1]);
        // setPaperSize(QSizeF,QPrinter::Unit)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setPaperSize(*cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && Shiboken::Converter<QPrinter::PageSize >::isConvertible(pyargs[0])) {
        QPrinter::PageSize cpp_arg0 = Shiboken::Converter<QPrinter::PageSize >::toCpp(pyargs[0]);
        // setPaperSize(QPrinter::PageSize)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setPaperSize(cpp_arg0);
    } else goto SbkQPrinterFunc_setPaperSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setPaperSize_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter.PageSize", "PySide.QtCore.QSizeF, PySide.QtGui.QPrinter.Unit", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPrinter.setPaperSize", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setPaperSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter::PaperSource >::isConvertible(arg)) {
        QPrinter::PaperSource cpp_arg0 = Shiboken::Converter<QPrinter::PaperSource >::toCpp(arg);
        // setPaperSource(QPrinter::PaperSource)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setPaperSource(cpp_arg0);
    } else goto SbkQPrinterFunc_setPaperSource_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setPaperSource_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter.PaperSource", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setPaperSource", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setPrintProgram(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPrintProgram(QString)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setPrintProgram(*cpp_arg0);
    } else goto SbkQPrinterFunc_setPrintProgram_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setPrintProgram_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setPrintProgram", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setPrintRange(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter::PrintRange >::isConvertible(arg)) {
        QPrinter::PrintRange cpp_arg0 = Shiboken::Converter<QPrinter::PrintRange >::toCpp(arg);
        // setPrintRange(QPrinter::PrintRange)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setPrintRange(cpp_arg0);
    } else goto SbkQPrinterFunc_setPrintRange_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setPrintRange_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter.PrintRange", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setPrintRange", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setPrinterName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPrinterName(QString)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setPrinterName(*cpp_arg0);
    } else goto SbkQPrinterFunc_setPrinterName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setPrinterName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setPrinterName", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_setResolution(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setResolution(int)
        QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
        cppSelf->QPrinter::setResolution(cpp_arg0);
    } else goto SbkQPrinterFunc_setResolution_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrinterFunc_setResolution_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrinter.setResolution", overloads);
        return 0;
}

static PyObject*
SbkQPrinterFunc_supportedResolutions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedResolutions()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    QList<int > cpp_result = cppSelf->QPrinter::supportedResolutions();
    py_result = Shiboken::Converter<QList<int > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPrinterFunc_toPage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPage()const
    QPrinter* cppSelf = Shiboken::Converter<QPrinter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPrinter::toPage();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQPrinter_methods[] = {
    {"abort", (PyCFunction)SbkQPrinterFunc_abort, METH_NOARGS},
    {"actualNumCopies", (PyCFunction)SbkQPrinterFunc_actualNumCopies, METH_NOARGS},
    {"collateCopies", (PyCFunction)SbkQPrinterFunc_collateCopies, METH_NOARGS},
    {"colorMode", (PyCFunction)SbkQPrinterFunc_colorMode, METH_NOARGS},
    {"creator", (PyCFunction)SbkQPrinterFunc_creator, METH_NOARGS},
    {"devType", (PyCFunction)SbkQPrinterFunc_devType, METH_NOARGS},
    {"docName", (PyCFunction)SbkQPrinterFunc_docName, METH_NOARGS},
    {"doubleSidedPrinting", (PyCFunction)SbkQPrinterFunc_doubleSidedPrinting, METH_NOARGS},
    {"duplex", (PyCFunction)SbkQPrinterFunc_duplex, METH_NOARGS},
    {"fontEmbeddingEnabled", (PyCFunction)SbkQPrinterFunc_fontEmbeddingEnabled, METH_NOARGS},
    {"fromPage", (PyCFunction)SbkQPrinterFunc_fromPage, METH_NOARGS},
    {"fullPage", (PyCFunction)SbkQPrinterFunc_fullPage, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQPrinterFunc_isValid, METH_NOARGS},
    {"metric", (PyCFunction)SbkQPrinterFunc_metric, METH_O},
    {"newPage", (PyCFunction)SbkQPrinterFunc_newPage, METH_NOARGS},
    {"numCopies", (PyCFunction)SbkQPrinterFunc_numCopies, METH_NOARGS},
    {"orientation", (PyCFunction)SbkQPrinterFunc_orientation, METH_NOARGS},
    {"outputFileName", (PyCFunction)SbkQPrinterFunc_outputFileName, METH_NOARGS},
    {"outputFormat", (PyCFunction)SbkQPrinterFunc_outputFormat, METH_NOARGS},
    {"pageOrder", (PyCFunction)SbkQPrinterFunc_pageOrder, METH_NOARGS},
    {"pageRect", (PyCFunction)SbkQPrinterFunc_pageRect, METH_NOARGS|METH_O},
    {"pageSize", (PyCFunction)SbkQPrinterFunc_pageSize, METH_NOARGS},
    {"paintEngine", (PyCFunction)SbkQPrinterFunc_paintEngine, METH_NOARGS},
    {"paperRect", (PyCFunction)SbkQPrinterFunc_paperRect, METH_NOARGS|METH_O},
    {"paperSize", (PyCFunction)SbkQPrinterFunc_paperSize, METH_NOARGS|METH_O},
    {"paperSource", (PyCFunction)SbkQPrinterFunc_paperSource, METH_NOARGS},
    {"printEngine", (PyCFunction)SbkQPrinterFunc_printEngine, METH_NOARGS},
    {"printProgram", (PyCFunction)SbkQPrinterFunc_printProgram, METH_NOARGS},
    {"printRange", (PyCFunction)SbkQPrinterFunc_printRange, METH_NOARGS},
    {"printerName", (PyCFunction)SbkQPrinterFunc_printerName, METH_NOARGS},
    {"printerState", (PyCFunction)SbkQPrinterFunc_printerState, METH_NOARGS},
    {"resolution", (PyCFunction)SbkQPrinterFunc_resolution, METH_NOARGS},
    {"setCollateCopies", (PyCFunction)SbkQPrinterFunc_setCollateCopies, METH_O},
    {"setColorMode", (PyCFunction)SbkQPrinterFunc_setColorMode, METH_O},
    {"setCreator", (PyCFunction)SbkQPrinterFunc_setCreator, METH_O},
    {"setDocName", (PyCFunction)SbkQPrinterFunc_setDocName, METH_O},
    {"setDoubleSidedPrinting", (PyCFunction)SbkQPrinterFunc_setDoubleSidedPrinting, METH_O},
    {"setDuplex", (PyCFunction)SbkQPrinterFunc_setDuplex, METH_O},
    {"setEngines", (PyCFunction)SbkQPrinterFunc_setEngines, METH_VARARGS},
    {"setFontEmbeddingEnabled", (PyCFunction)SbkQPrinterFunc_setFontEmbeddingEnabled, METH_O},
    {"setFromTo", (PyCFunction)SbkQPrinterFunc_setFromTo, METH_VARARGS},
    {"setFullPage", (PyCFunction)SbkQPrinterFunc_setFullPage, METH_O},
    {"setNumCopies", (PyCFunction)SbkQPrinterFunc_setNumCopies, METH_O},
    {"setOrientation", (PyCFunction)SbkQPrinterFunc_setOrientation, METH_O},
    {"setOutputFileName", (PyCFunction)SbkQPrinterFunc_setOutputFileName, METH_O},
    {"setOutputFormat", (PyCFunction)SbkQPrinterFunc_setOutputFormat, METH_O},
    {"setPageMargins", (PyCFunction)SbkQPrinterFunc_setPageMargins, METH_VARARGS},
    {"setPageOrder", (PyCFunction)SbkQPrinterFunc_setPageOrder, METH_O},
    {"setPageSize", (PyCFunction)SbkQPrinterFunc_setPageSize, METH_O},
    {"setPaperSize", (PyCFunction)SbkQPrinterFunc_setPaperSize, METH_VARARGS},
    {"setPaperSource", (PyCFunction)SbkQPrinterFunc_setPaperSource, METH_O},
    {"setPrintProgram", (PyCFunction)SbkQPrinterFunc_setPrintProgram, METH_O},
    {"setPrintRange", (PyCFunction)SbkQPrinterFunc_setPrintRange, METH_O},
    {"setPrinterName", (PyCFunction)SbkQPrinterFunc_setPrinterName, METH_O},
    {"setResolution", (PyCFunction)SbkQPrinterFunc_setResolution, METH_O},
    {"supportedResolutions", (PyCFunction)SbkQPrinterFunc_supportedResolutions, METH_NOARGS},
    {"toPage", (PyCFunction)SbkQPrinterFunc_toPage, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPrinter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPrinter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPrinterWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPrinter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPrinter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QPrinter_OutputFormat_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrinter_OutputFormat_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrinter_OutputFormat_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "OutputFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrinter_OutputFormat_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrinter_OutputFormat_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPrinter_OutputFormat_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPrinter_DuplexMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrinter_DuplexMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrinter_DuplexMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DuplexMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrinter_DuplexMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrinter_DuplexMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPrinter_DuplexMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPrinter_PrintRange_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrinter_PrintRange_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrinter_PrintRange_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PrintRange",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrinter_PrintRange_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrinter_PrintRange_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPrinter_PrintRange_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPrinter_Unit_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrinter_Unit_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrinter_Unit_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Unit",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrinter_Unit_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrinter_Unit_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPrinter_Unit_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPrinter_PrinterMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrinter_PrinterMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrinter_PrinterMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PrinterMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrinter_PrinterMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrinter_PrinterMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPrinter_PrinterMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPrinter_Orientation_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrinter_Orientation_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrinter_Orientation_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Orientation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrinter_Orientation_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrinter_Orientation_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPrinter_Orientation_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPrinter_PrinterState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrinter_PrinterState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrinter_PrinterState_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PrinterState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrinter_PrinterState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrinter_PrinterState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPrinter_PrinterState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPrinter_ColorMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrinter_ColorMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrinter_ColorMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ColorMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrinter_ColorMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrinter_ColorMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPrinter_ColorMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPrinter_PaperSource_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrinter_PaperSource_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrinter_PaperSource_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PaperSource",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrinter_PaperSource_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrinter_PaperSource_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPrinter_PaperSource_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPrinter_PageOrder_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrinter_PageOrder_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrinter_PageOrder_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PageOrder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrinter_PageOrder_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrinter_PageOrder_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPrinter_PageOrder_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPrinter_PageSize_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrinter_PageSize_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrinter_PageSize_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PageSize",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrinter_PageSize_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrinter_PageSize_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPrinter_PageSize_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QPrinter(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPRINTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPrinter_Type);

    SbkQPrinter_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX];
    // Fill type discovery information
    SbkQPrinter_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQPrinter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPrinter_Type));
    PyModule_AddObject(module, "QPrinter",
        ((PyObject*)&SbkQPrinter_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: OutputFormat
    SbkPySide_QtGuiTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX] = &SbkPySide_QtGui_QPrinter_OutputFormat_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrinter_OutputFormat_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrinter_OutputFormat_Type);
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
            "OutputFormat",((PyObject*)&SbkPySide_QtGui_QPrinter_OutputFormat_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_OutputFormat_Type,
        (long) QPrinter::NativeFormat, "NativeFormat");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "NativeFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_OutputFormat_Type.tp_dict,
        "NativeFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_OutputFormat_Type,
        (long) QPrinter::PdfFormat, "PdfFormat");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "PdfFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_OutputFormat_Type.tp_dict,
        "PdfFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_OutputFormat_Type,
        (long) QPrinter::PostScriptFormat, "PostScriptFormat");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "PostScriptFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_OutputFormat_Type.tp_dict,
        "PostScriptFormat", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrinter::OutputFormat");

    // init enum class: DuplexMode
    SbkPySide_QtGuiTypes[SBK_QPRINTER_DUPLEXMODE_IDX] = &SbkPySide_QtGui_QPrinter_DuplexMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrinter_DuplexMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrinter_DuplexMode_Type);
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
            "DuplexMode",((PyObject*)&SbkPySide_QtGui_QPrinter_DuplexMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_DuplexMode_Type,
        (long) QPrinter::DuplexNone, "DuplexNone");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "DuplexNone", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_DuplexMode_Type.tp_dict,
        "DuplexNone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_DuplexMode_Type,
        (long) QPrinter::DuplexAuto, "DuplexAuto");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "DuplexAuto", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_DuplexMode_Type.tp_dict,
        "DuplexAuto", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_DuplexMode_Type,
        (long) QPrinter::DuplexLongSide, "DuplexLongSide");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "DuplexLongSide", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_DuplexMode_Type.tp_dict,
        "DuplexLongSide", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_DuplexMode_Type,
        (long) QPrinter::DuplexShortSide, "DuplexShortSide");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "DuplexShortSide", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_DuplexMode_Type.tp_dict,
        "DuplexShortSide", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrinter::DuplexMode");

    // init enum class: PrintRange
    SbkPySide_QtGuiTypes[SBK_QPRINTER_PRINTRANGE_IDX] = &SbkPySide_QtGui_QPrinter_PrintRange_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrinter_PrintRange_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrinter_PrintRange_Type);
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
            "PrintRange",((PyObject*)&SbkPySide_QtGui_QPrinter_PrintRange_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PrintRange_Type,
        (long) QPrinter::AllPages, "AllPages");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "AllPages", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PrintRange_Type.tp_dict,
        "AllPages", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PrintRange_Type,
        (long) QPrinter::Selection, "Selection");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Selection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PrintRange_Type.tp_dict,
        "Selection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PrintRange_Type,
        (long) QPrinter::PageRange, "PageRange");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "PageRange", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PrintRange_Type.tp_dict,
        "PageRange", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrinter::PrintRange");

    // init enum class: Unit
    SbkPySide_QtGuiTypes[SBK_QPRINTER_UNIT_IDX] = &SbkPySide_QtGui_QPrinter_Unit_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrinter_Unit_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrinter_Unit_Type);
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
            "Unit",((PyObject*)&SbkPySide_QtGui_QPrinter_Unit_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_Unit_Type,
        (long) QPrinter::Millimeter, "Millimeter");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Millimeter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_Unit_Type.tp_dict,
        "Millimeter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_Unit_Type,
        (long) QPrinter::Point, "Point");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Point", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_Unit_Type.tp_dict,
        "Point", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_Unit_Type,
        (long) QPrinter::Inch, "Inch");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Inch", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_Unit_Type.tp_dict,
        "Inch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_Unit_Type,
        (long) QPrinter::Pica, "Pica");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Pica", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_Unit_Type.tp_dict,
        "Pica", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_Unit_Type,
        (long) QPrinter::Didot, "Didot");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Didot", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_Unit_Type.tp_dict,
        "Didot", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_Unit_Type,
        (long) QPrinter::Cicero, "Cicero");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Cicero", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_Unit_Type.tp_dict,
        "Cicero", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_Unit_Type,
        (long) QPrinter::DevicePixel, "DevicePixel");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "DevicePixel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_Unit_Type.tp_dict,
        "DevicePixel", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrinter::Unit");

    // init enum class: PrinterMode
    SbkPySide_QtGuiTypes[SBK_QPRINTER_PRINTERMODE_IDX] = &SbkPySide_QtGui_QPrinter_PrinterMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrinter_PrinterMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrinter_PrinterMode_Type);
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
            "PrinterMode",((PyObject*)&SbkPySide_QtGui_QPrinter_PrinterMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PrinterMode_Type,
        (long) QPrinter::ScreenResolution, "ScreenResolution");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "ScreenResolution", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PrinterMode_Type.tp_dict,
        "ScreenResolution", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PrinterMode_Type,
        (long) QPrinter::PrinterResolution, "PrinterResolution");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "PrinterResolution", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PrinterMode_Type.tp_dict,
        "PrinterResolution", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PrinterMode_Type,
        (long) QPrinter::HighResolution, "HighResolution");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "HighResolution", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PrinterMode_Type.tp_dict,
        "HighResolution", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrinter::PrinterMode");

    // init enum class: Orientation
    SbkPySide_QtGuiTypes[SBK_QPRINTER_ORIENTATION_IDX] = &SbkPySide_QtGui_QPrinter_Orientation_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrinter_Orientation_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrinter_Orientation_Type);
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
            "Orientation",((PyObject*)&SbkPySide_QtGui_QPrinter_Orientation_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_Orientation_Type,
        (long) QPrinter::Portrait, "Portrait");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Portrait", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_Orientation_Type.tp_dict,
        "Portrait", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_Orientation_Type,
        (long) QPrinter::Landscape, "Landscape");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Landscape", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_Orientation_Type.tp_dict,
        "Landscape", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrinter::Orientation");

    // init enum class: PrinterState
    SbkPySide_QtGuiTypes[SBK_QPRINTER_PRINTERSTATE_IDX] = &SbkPySide_QtGui_QPrinter_PrinterState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrinter_PrinterState_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrinter_PrinterState_Type);
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
            "PrinterState",((PyObject*)&SbkPySide_QtGui_QPrinter_PrinterState_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PrinterState_Type,
        (long) QPrinter::Idle, "Idle");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Idle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PrinterState_Type.tp_dict,
        "Idle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PrinterState_Type,
        (long) QPrinter::Active, "Active");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Active", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PrinterState_Type.tp_dict,
        "Active", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PrinterState_Type,
        (long) QPrinter::Aborted, "Aborted");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Aborted", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PrinterState_Type.tp_dict,
        "Aborted", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PrinterState_Type,
        (long) QPrinter::Error, "Error");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Error", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PrinterState_Type.tp_dict,
        "Error", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrinter::PrinterState");

    // init enum class: ColorMode
    SbkPySide_QtGuiTypes[SBK_QPRINTER_COLORMODE_IDX] = &SbkPySide_QtGui_QPrinter_ColorMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrinter_ColorMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrinter_ColorMode_Type);
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
            "ColorMode",((PyObject*)&SbkPySide_QtGui_QPrinter_ColorMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_ColorMode_Type,
        (long) QPrinter::GrayScale, "GrayScale");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "GrayScale", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_ColorMode_Type.tp_dict,
        "GrayScale", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_ColorMode_Type,
        (long) QPrinter::Color, "Color");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Color", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_ColorMode_Type.tp_dict,
        "Color", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrinter::ColorMode");

    // init enum class: PaperSource
    SbkPySide_QtGuiTypes[SBK_QPRINTER_PAPERSOURCE_IDX] = &SbkPySide_QtGui_QPrinter_PaperSource_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrinter_PaperSource_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrinter_PaperSource_Type);
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
            "PaperSource",((PyObject*)&SbkPySide_QtGui_QPrinter_PaperSource_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::OnlyOne, "OnlyOne");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "OnlyOne", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "OnlyOne", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::Lower, "Lower");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Lower", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "Lower", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::Middle, "Middle");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Middle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "Middle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::Manual, "Manual");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Manual", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "Manual", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::Envelope, "Envelope");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Envelope", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "Envelope", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::EnvelopeManual, "EnvelopeManual");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "EnvelopeManual", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "EnvelopeManual", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::Auto, "Auto");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Auto", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "Auto", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::Tractor, "Tractor");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Tractor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "Tractor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::SmallFormat, "SmallFormat");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "SmallFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "SmallFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::LargeFormat, "LargeFormat");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "LargeFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "LargeFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::LargeCapacity, "LargeCapacity");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "LargeCapacity", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "LargeCapacity", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::Cassette, "Cassette");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Cassette", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "Cassette", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::FormSource, "FormSource");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "FormSource", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "FormSource", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PaperSource_Type,
        (long) QPrinter::MaxPageSource, "MaxPageSource");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "MaxPageSource", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PaperSource_Type.tp_dict,
        "MaxPageSource", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrinter::PaperSource");

    // init enum class: PageOrder
    SbkPySide_QtGuiTypes[SBK_QPRINTER_PAGEORDER_IDX] = &SbkPySide_QtGui_QPrinter_PageOrder_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrinter_PageOrder_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrinter_PageOrder_Type);
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
            "PageOrder",((PyObject*)&SbkPySide_QtGui_QPrinter_PageOrder_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageOrder_Type,
        (long) QPrinter::FirstPageFirst, "FirstPageFirst");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "FirstPageFirst", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageOrder_Type.tp_dict,
        "FirstPageFirst", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageOrder_Type,
        (long) QPrinter::LastPageFirst, "LastPageFirst");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "LastPageFirst", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageOrder_Type.tp_dict,
        "LastPageFirst", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrinter::PageOrder");

    // init enum class: PageSize
    SbkPySide_QtGuiTypes[SBK_QPRINTER_PAGESIZE_IDX] = &SbkPySide_QtGui_QPrinter_PageSize_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrinter_PageSize_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrinter_PageSize_Type);
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
            "PageSize",((PyObject*)&SbkPySide_QtGui_QPrinter_PageSize_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::A4, "A4");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "A4", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "A4", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::B5, "B5");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "B5", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "B5", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::Letter, "Letter");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Letter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "Letter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::Legal, "Legal");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Legal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "Legal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::Executive, "Executive");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Executive", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "Executive", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::A0, "A0");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "A0", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "A0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::A1, "A1");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "A1", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "A1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::A2, "A2");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "A2", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "A2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::A3, "A3");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "A3", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "A3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::A5, "A5");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "A5", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "A5", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::A6, "A6");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "A6", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "A6", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::A7, "A7");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "A7", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "A7", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::A8, "A8");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "A8", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "A8", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::A9, "A9");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "A9", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "A9", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::B0, "B0");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "B0", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "B0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::B1, "B1");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "B1", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "B1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::B10, "B10");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "B10", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "B10", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::B2, "B2");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "B2", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "B2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::B3, "B3");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "B3", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "B3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::B4, "B4");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "B4", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "B4", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::B6, "B6");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "B6", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "B6", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::B7, "B7");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "B7", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "B7", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::B8, "B8");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "B8", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "B8", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::B9, "B9");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "B9", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "B9", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::C5E, "C5E");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "C5E", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "C5E", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::Comm10E, "Comm10E");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Comm10E", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "Comm10E", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::DLE, "DLE");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "DLE", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "DLE", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::Folio, "Folio");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Folio", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "Folio", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::Ledger, "Ledger");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Ledger", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "Ledger", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::Tabloid, "Tabloid");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Tabloid", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "Tabloid", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::Custom, "Custom");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "Custom", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "Custom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::NPageSize, "NPageSize");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "NPageSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "NPageSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrinter_PageSize_Type,
        (long) QPrinter::NPaperSize, "NPaperSize");
    PyDict_SetItemString(SbkQPrinter_Type.super.ht_type.tp_dict,
        "NPaperSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrinter_PageSize_Type.tp_dict,
        "NPaperSize", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrinter::PageSize");

    Shiboken::TypeResolver::createObjectTypeResolver<QPrinter >("QPrinter*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPrinter >(typeid(QPrinter).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

