/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qplaintextedit_wrapper.h"

// Extra includes
#include <QAbstractTextDocumentLayout>
#include <QList>
#include <QTextEdit>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qmenu.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qplaintextedit.h>
#include <qpoint.h>
#include <qprinter.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qtextcursor.h>
#include <qtextdocument.h>
#include <qtextformat.h>
#include <qtextobject.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPlainTextEditWrapper::QPlainTextEditWrapper(QWidget * parent) : QPlainTextEdit(parent), m_metaObject(0) {
    // ... middle
}

QPlainTextEditWrapper::QPlainTextEditWrapper(const QString & text, QWidget * parent) : QPlainTextEdit(text, parent), m_metaObject(0) {
    // ... middle
}

void QPlainTextEditWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QPlainTextEditWrapper::canInsertFromMimeData(const QMimeData * source) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canInsertFromMimeData"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::canInsertFromMimeData(source);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMimeData* >::toPython(source)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.canInsertFromMimeData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QPlainTextEditWrapper::changeEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::changeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPlainTextEditWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::contextMenuEvent(QContextMenuEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::contextMenuEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QMimeData * QPlainTextEditWrapper::createMimeDataFromSelection() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createMimeDataFromSelection"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::createMimeDataFromSelection();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMimeData* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.createMimeDataFromSelection");
        return 0        ;
    }
    QMimeData* cpp_result(Shiboken::Converter<QMimeData* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QPlainTextEditWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QPlainTextEditWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QPlainTextEditWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::dragEnterEvent(QDragEnterEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::dragEnterEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::dragLeaveEvent(QDragLeaveEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::dragLeaveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::dragMoveEvent(QDragMoveEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::dragMoveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::dropEvent(QDropEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::dropEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QPlainTextEditWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QPlainTextEditWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QPlainTextEditWrapper::focusInEvent(QFocusEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::focusInEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QPlainTextEditWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QPlainTextEditWrapper::focusOutEvent(QFocusEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::focusOutEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QPlainTextEditWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QPlainTextEditWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPlainTextEditWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QPlainTextEditWrapper::inputMethodQuery(Qt::InputMethodQuery property) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::inputMethodQuery(property);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(property)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QPlainTextEditWrapper::insertFromMimeData(const QMimeData * source)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertFromMimeData"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::insertFromMimeData(source);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMimeData* >::toPython(source)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::keyPressEvent(QKeyEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::keyPressEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::keyReleaseEvent(QKeyEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::keyReleaseEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QPlainTextEditWrapper::loadResource(int type, const QUrl & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "loadResource"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::loadResource(type, name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iO)",
        type,
        Shiboken::Converter<QUrl& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.loadResource");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

int QPlainTextEditWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QPlainTextEditWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QPlainTextEditWrapper::mouseDoubleClickEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::mouseDoubleClickEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::mouseMoveEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::mouseMoveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::mousePressEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::mousePressEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::mouseReleaseEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::mouseReleaseEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QPlainTextEditWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QPlainTextEditWrapper::paintEvent(QPaintEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::paintEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::resizeEvent(QResizeEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::resizeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPlainTextEditWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QPlainTextEditWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QPlainTextEditWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPlainTextEditWrapper::timerEvent(QTimerEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::timerEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QPlainTextEditWrapper::viewportEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::viewportEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPlainTextEdit.viewportEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

void QPlainTextEditWrapper::wheelEvent(QWheelEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QPlainTextEdit::wheelEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QPlainTextEditWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QPlainTextEdit::staticMetaObject);
}
    return m_metaObject;
}

int QPlainTextEditWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QPlainTextEdit::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QPlainTextEditWrapper::~QPlainTextEditWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQPlainTextEdit_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPlainTextEditWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QPlainTextEdit", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QPlainTextEdit(QWidget*)
        cptr = new QPlainTextEditWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QPlainTextEdit(QString,QWidget*)
            cptr = new QPlainTextEditWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // QPlainTextEdit(QString,QWidget*)
            cptr = new QPlainTextEditWrapper(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQPlainTextEdit_Init_TypeError;
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QPlainTextEdit(QWidget*)
        cptr = new QPlainTextEditWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQPlainTextEdit_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPlainTextEdit_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQPlainTextEdit_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", "PySide.QtCore.QString, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPlainTextEdit", overloads);
        return -1;
}

static PyObject*
SbkQPlainTextEditFunc_appendHtml(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // appendHtml(QString)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::appendHtml(*cpp_arg0);
    } else goto SbkQPlainTextEditFunc_appendHtml_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_appendHtml_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.appendHtml", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_appendPlainText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // appendPlainText(QString)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::appendPlainText(*cpp_arg0);
    } else goto SbkQPlainTextEditFunc_appendPlainText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_appendPlainText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.appendPlainText", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_backgroundVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // backgroundVisible()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPlainTextEdit::backgroundVisible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_blockBoundingGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextBlock& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextBlock* cpp_arg0 = Shiboken::Converter<QTextBlock* >::toCpp(arg);
        // blockBoundingGeometry(QTextBlock)const
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QPlainTextEdit::blockBoundingGeometry(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQPlainTextEditFunc_blockBoundingGeometry_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextEditFunc_blockBoundingGeometry_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextBlock", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.blockBoundingGeometry", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_blockBoundingRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextBlock& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextBlock* cpp_arg0 = Shiboken::Converter<QTextBlock* >::toCpp(arg);
        // blockBoundingRect(QTextBlock)const
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QPlainTextEdit::blockBoundingRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    } else goto SbkQPlainTextEditFunc_blockBoundingRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextEditFunc_blockBoundingRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextBlock", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.blockBoundingRect", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_blockCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blockCount()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPlainTextEdit::blockCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_canInsertFromMimeData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QMimeData* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMimeData* cpp_arg0 = Shiboken::Converter<QMimeData* >::toCpp(arg);
        // canInsertFromMimeData(const QMimeData*)const
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPlainTextEdit::canInsertFromMimeData(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQPlainTextEditFunc_canInsertFromMimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextEditFunc_canInsertFromMimeData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMimeData", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.canInsertFromMimeData", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_canPaste(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canPaste()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPlainTextEdit::canPaste();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_centerCursor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // centerCursor()
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QPlainTextEdit::centerCursor();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQPlainTextEditFunc_centerOnScroll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // centerOnScroll()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPlainTextEdit::centerOnScroll();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::changeEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.changeEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QPlainTextEdit::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQPlainTextEditFunc_contentOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contentOffset()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QPlainTextEdit::contentOffset();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QContextMenuEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QContextMenuEvent* cpp_arg0 = Shiboken::Converter<QContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QContextMenuEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::contextMenuEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.contextMenuEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_copy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // copy()
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QPlainTextEdit::copy();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQPlainTextEditFunc_createMimeDataFromSelection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // createMimeDataFromSelection()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QMimeData * cpp_result = cppSelf->QPlainTextEdit::createMimeDataFromSelection();
    py_result = Shiboken::Converter<QMimeData* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_createStandardContextMenu(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // createStandardContextMenu()
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QMenu * cpp_result = cppSelf->QPlainTextEdit::createStandardContextMenu();
    py_result = Shiboken::Converter<QMenu* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_currentCharFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentCharFormat()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QTextCharFormat cpp_result = cppSelf->QPlainTextEdit::currentCharFormat();
    py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_cursorForPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // cursorForPosition(QPoint)const
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        QTextCursor cpp_result = cppSelf->QPlainTextEdit::cursorForPosition(*cpp_arg0);
        py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
    } else goto SbkQPlainTextEditFunc_cursorForPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextEditFunc_cursorForPosition_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.cursorForPosition", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_cursorRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // cursorRect()const
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QPlainTextEdit::cursorRect();
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else if (Shiboken::Converter<QTextCursor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCursor* cpp_arg0 = Shiboken::Converter<QTextCursor* >::toCpp(arg);
        // cursorRect(QTextCursor)const
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QPlainTextEdit::cursorRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQPlainTextEditFunc_cursorRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextEditFunc_cursorRect_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextCursor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.cursorRect", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_cursorWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cursorWidth()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPlainTextEdit::cursorWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_cut(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // cut()
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QPlainTextEdit::cut();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQPlainTextEditFunc_document(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // document()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QTextDocument * cpp_result = cppSelf->QPlainTextEdit::document();
    py_result = Shiboken::Converter<QTextDocument* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_documentTitle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentTitle()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QPlainTextEdit::documentTitle();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_dragEnterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragEnterEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragEnterEvent* cpp_arg0 = Shiboken::Converter<QDragEnterEvent* >::toCpp(arg);
        // dragEnterEvent(QDragEnterEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::dragEnterEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_dragEnterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_dragEnterEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragEnterEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.dragEnterEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_dragLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragLeaveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragLeaveEvent* cpp_arg0 = Shiboken::Converter<QDragLeaveEvent* >::toCpp(arg);
        // dragLeaveEvent(QDragLeaveEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::dragLeaveEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_dragLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_dragLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragLeaveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.dragLeaveEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragMoveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragMoveEvent* cpp_arg0 = Shiboken::Converter<QDragMoveEvent* >::toCpp(arg);
        // dragMoveEvent(QDragMoveEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::dragMoveEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.dragMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // dropEvent(QDropEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::dropEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.dropEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_ensureCursorVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // ensureCursorVisible()
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QPlainTextEdit::ensureCursorVisible();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQPlainTextEditFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPlainTextEdit::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQPlainTextEditFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextEditFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.event", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_extraSelections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // extraSelections()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QList<QTextEdit::ExtraSelection > cpp_result = cppSelf->QPlainTextEdit::extraSelections();
    py_result = Shiboken::Converter<QList<QTextEdit::ExtraSelection > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_find(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "find", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // find(QString,QFlags<QTextDocument::FindFlag>)
            QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QPlainTextEdit::find(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (SbkPySide_QtGui_QTextDocument_FindFlag_Check(pyargs[1])) {
            QFlags<QTextDocument::FindFlag> cpp_arg1 = Shiboken::Converter<QFlags<QTextDocument::FindFlag> >::toCpp(pyargs[1]);
            // find(QString,QFlags<QTextDocument::FindFlag>)
            QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QPlainTextEdit::find(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQPlainTextEditFunc_find_TypeError;
    } else goto SbkQPlainTextEditFunc_find_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextEditFunc_find_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtGui.QTextDocument.FindFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPlainTextEdit.find", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_firstVisibleBlock(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // firstVisibleBlock()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QTextBlock cpp_result = cppSelf->QPlainTextEdit::firstVisibleBlock();
    py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::focusInEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.focusInEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPlainTextEdit::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQPlainTextEditFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextEditFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.focusNextPrevChild", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::focusOutEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.focusOutEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_getPaintContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // getPaintContext()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QAbstractTextDocumentLayout::PaintContext cpp_result = cppSelf->QPlainTextEdit::getPaintContext();
    py_result = Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_inputMethodEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputMethodEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QInputMethodEvent* cpp_arg0 = Shiboken::Converter<QInputMethodEvent* >::toCpp(arg);
        // inputMethodEvent(QInputMethodEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::inputMethodEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_inputMethodEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_inputMethodEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputMethodEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.inputMethodEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_inputMethodQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::InputMethodQuery >::isConvertible(arg)) {
        Qt::InputMethodQuery cpp_arg0 = Shiboken::Converter<Qt::InputMethodQuery >::toCpp(arg);
        // inputMethodQuery(Qt::InputMethodQuery)const
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QPlainTextEdit::inputMethodQuery(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQPlainTextEditFunc_inputMethodQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextEditFunc_inputMethodQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodQuery", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.inputMethodQuery", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_insertFromMimeData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMimeData* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMimeData* cpp_arg0 = Shiboken::Converter<QMimeData* >::toCpp(arg);
        // insertFromMimeData(const QMimeData*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::insertFromMimeData(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQPlainTextEditFunc_insertFromMimeData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_insertFromMimeData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMimeData", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.insertFromMimeData", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_insertPlainText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // insertPlainText(QString)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::insertPlainText(*cpp_arg0);
    } else goto SbkQPlainTextEditFunc_insertPlainText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_insertPlainText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.insertPlainText", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_isReadOnly(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadOnly()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPlainTextEdit::isReadOnly();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_isUndoRedoEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isUndoRedoEnabled()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPlainTextEdit::isUndoRedoEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::keyPressEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.keyPressEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_keyReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyReleaseEvent(QKeyEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::keyReleaseEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_keyReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_keyReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.keyReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_lineWrapMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineWrapMode()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QPlainTextEdit::LineWrapMode cpp_result = cppSelf->QPlainTextEdit::lineWrapMode();
    py_result = Shiboken::Converter<QPlainTextEdit::LineWrapMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_loadResource(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "loadResource", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QUrl& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
        QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QUrl& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
        // loadResource(int,QUrl)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QPlainTextEdit::loadResource(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQPlainTextEditFunc_loadResource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPlainTextEditFunc_loadResource_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPlainTextEdit.loadResource", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_maximumBlockCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumBlockCount()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPlainTextEdit::maximumBlockCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_mergeCurrentCharFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCharFormat* cpp_arg0 = Shiboken::Converter<QTextCharFormat* >::toCpp(arg);
        // mergeCurrentCharFormat(QTextCharFormat)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::mergeCurrentCharFormat(*cpp_arg0);
    } else goto SbkQPlainTextEditFunc_mergeCurrentCharFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_mergeCurrentCharFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.mergeCurrentCharFormat", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QMouseEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::mouseDoubleClickEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::mouseMoveEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.mouseMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::mousePressEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.mousePressEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::mouseReleaseEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_moveCursor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "moveCursor", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTextCursor::MoveOperation >::isConvertible(pyargs[0])) {
        QTextCursor::MoveOperation cpp_arg0 = Shiboken::Converter<QTextCursor::MoveOperation >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // moveCursor(QTextCursor::MoveOperation,QTextCursor::MoveMode)
            QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
            cppSelf->QPlainTextEdit::moveCursor(cpp_arg0);
        } else if (Shiboken::Converter<QTextCursor::MoveMode >::isConvertible(pyargs[1])) {
            QTextCursor::MoveMode cpp_arg1 = Shiboken::Converter<QTextCursor::MoveMode >::toCpp(pyargs[1]);
            // moveCursor(QTextCursor::MoveOperation,QTextCursor::MoveMode)
            QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
            cppSelf->QPlainTextEdit::moveCursor(cpp_arg0, cpp_arg1);
        } else goto SbkQPlainTextEditFunc_moveCursor_TypeError;
    } else goto SbkQPlainTextEditFunc_moveCursor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_moveCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCursor.MoveOperation, PySide.QtGui.QTextCursor.MoveMode = QTextCursor.MoveAnchor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPlainTextEdit.moveCursor", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_overwriteMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // overwriteMode()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPlainTextEdit::overwriteMode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::paintEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.paintEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_paste(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // paste()
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QPlainTextEdit::paste();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQPlainTextEditFunc_print(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPrinter* cpp_arg0 = Shiboken::Converter<QPrinter* >::toCpp(arg);
        // print(QPrinter*)const
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::print(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_print_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_print_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.print", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_redo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // redo()
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QPlainTextEdit::redo();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQPlainTextEditFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::resizeEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.resizeEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_scrollContentsBy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollContentsBy", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // scrollContentsBy(int,int)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::scrollContentsBy(cpp_arg0, cpp_arg1);
    } else goto SbkQPlainTextEditFunc_scrollContentsBy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_scrollContentsBy_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPlainTextEdit.scrollContentsBy", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_selectAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // selectAll()
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QPlainTextEdit::selectAll();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQPlainTextEditFunc_setBackgroundVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setBackgroundVisible(bool)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setBackgroundVisible(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setBackgroundVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setBackgroundVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setBackgroundVisible", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setCenterOnScroll(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setCenterOnScroll(bool)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setCenterOnScroll(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setCenterOnScroll_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setCenterOnScroll_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setCenterOnScroll", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setCurrentCharFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCharFormat* cpp_arg0 = Shiboken::Converter<QTextCharFormat* >::toCpp(arg);
        // setCurrentCharFormat(QTextCharFormat)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setCurrentCharFormat(*cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setCurrentCharFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setCurrentCharFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setCurrentCharFormat", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setCursorWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCursorWidth(int)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setCursorWidth(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setCursorWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setCursorWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setCursorWidth", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setDocument(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextDocument* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextDocument* cpp_arg0 = Shiboken::Converter<QTextDocument* >::toCpp(arg);
        // setDocument(QTextDocument*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setDocument(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQPlainTextEditFunc_setDocument_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setDocument_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextDocument", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setDocument", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setDocumentTitle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDocumentTitle(QString)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setDocumentTitle(*cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setDocumentTitle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setDocumentTitle_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setDocumentTitle", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setExtraSelections(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QTextEdit::ExtraSelection >  >::isConvertible(arg)) {
        QList<QTextEdit::ExtraSelection >  cpp_arg0 = Shiboken::Converter<QList<QTextEdit::ExtraSelection >  >::toCpp(arg);
        // setExtraSelections(QList<QTextEdit::ExtraSelection>)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setExtraSelections(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setExtraSelections_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setExtraSelections_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setExtraSelections", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setLineWrapMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPlainTextEdit::LineWrapMode >::isConvertible(arg)) {
        QPlainTextEdit::LineWrapMode cpp_arg0 = Shiboken::Converter<QPlainTextEdit::LineWrapMode >::toCpp(arg);
        // setLineWrapMode(QPlainTextEdit::LineWrapMode)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setLineWrapMode(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setLineWrapMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setLineWrapMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPlainTextEdit.LineWrapMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setLineWrapMode", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setMaximumBlockCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaximumBlockCount(int)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setMaximumBlockCount(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setMaximumBlockCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setMaximumBlockCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setMaximumBlockCount", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setOverwriteMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setOverwriteMode(bool)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setOverwriteMode(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setOverwriteMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setOverwriteMode_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setOverwriteMode", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setPlainText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPlainText(QString)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setPlainText(*cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setPlainText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setPlainText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setPlainText", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setReadOnly(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setReadOnly(bool)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setReadOnly(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setReadOnly_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setReadOnly_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setReadOnly", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setTabChangesFocus(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setTabChangesFocus(bool)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setTabChangesFocus(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setTabChangesFocus_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setTabChangesFocus_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setTabChangesFocus", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setTabStopWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setTabStopWidth(int)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setTabStopWidth(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setTabStopWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setTabStopWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setTabStopWidth", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setTextCursor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCursor& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCursor* cpp_arg0 = Shiboken::Converter<QTextCursor* >::toCpp(arg);
        // setTextCursor(QTextCursor)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setTextCursor(*cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setTextCursor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setTextCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCursor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setTextCursor", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setTextInteractionFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_TextInteractionFlag_Check(arg)) {
        QFlags<Qt::TextInteractionFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::TextInteractionFlag> >::toCpp(arg);
        // setTextInteractionFlags(QFlags<Qt::TextInteractionFlag>)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setTextInteractionFlags(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setTextInteractionFlags_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setTextInteractionFlags_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.TextInteractionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setTextInteractionFlags", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setUndoRedoEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUndoRedoEnabled(bool)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setUndoRedoEnabled(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setUndoRedoEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setUndoRedoEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setUndoRedoEnabled", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_setWordWrapMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextOption::WrapMode >::isConvertible(arg)) {
        QTextOption::WrapMode cpp_arg0 = Shiboken::Converter<QTextOption::WrapMode >::toCpp(arg);
        // setWordWrapMode(QTextOption::WrapMode)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::setWordWrapMode(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_setWordWrapMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_setWordWrapMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextOption.WrapMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.setWordWrapMode", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::showEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.showEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_tabChangesFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabChangesFocus()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPlainTextEdit::tabChangesFocus();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_tabStopWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabStopWidth()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPlainTextEdit::tabStopWidth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_textCursor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textCursor()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QTextCursor cpp_result = cppSelf->QPlainTextEdit::textCursor();
    py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_textInteractionFlags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textInteractionFlags()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QFlags<Qt::TextInteractionFlag> cpp_result = cppSelf->QPlainTextEdit::textInteractionFlags();
    py_result = Shiboken::Converter<QFlags<Qt::TextInteractionFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::timerEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.timerEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_toPlainText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPlainText()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QPlainTextEdit::toPlainText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPlainTextEditFunc_undo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // undo()
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    cppSelf->QPlainTextEdit::undo();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQPlainTextEditFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWheelEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWheelEvent* cpp_arg0 = Shiboken::Converter<QWheelEvent* >::toCpp(arg);
        // wheelEvent(QWheelEvent*)
        QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
        cppSelf->QPlainTextEdit::wheelEvent(cpp_arg0);
    } else goto SbkQPlainTextEditFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPlainTextEditFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPlainTextEdit.wheelEvent", overloads);
        return 0;
}

static PyObject*
SbkQPlainTextEditFunc_wordWrapMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // wordWrapMode()const
    QPlainTextEdit* cppSelf = Shiboken::Converter<QPlainTextEdit* >::toCpp((PyObject*)self);
    QTextOption::WrapMode cpp_result = cppSelf->QPlainTextEdit::wordWrapMode();
    py_result = Shiboken::Converter<QTextOption::WrapMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQPlainTextEdit_methods[] = {
    {"appendHtml", (PyCFunction)SbkQPlainTextEditFunc_appendHtml, METH_O},
    {"appendPlainText", (PyCFunction)SbkQPlainTextEditFunc_appendPlainText, METH_O},
    {"backgroundVisible", (PyCFunction)SbkQPlainTextEditFunc_backgroundVisible, METH_NOARGS},
    {"blockBoundingGeometry", (PyCFunction)SbkQPlainTextEditFunc_blockBoundingGeometry, METH_O},
    {"blockBoundingRect", (PyCFunction)SbkQPlainTextEditFunc_blockBoundingRect, METH_O},
    {"blockCount", (PyCFunction)SbkQPlainTextEditFunc_blockCount, METH_NOARGS},
    {"canInsertFromMimeData", (PyCFunction)SbkQPlainTextEditFunc_canInsertFromMimeData, METH_O},
    {"canPaste", (PyCFunction)SbkQPlainTextEditFunc_canPaste, METH_NOARGS},
    {"centerCursor", (PyCFunction)SbkQPlainTextEditFunc_centerCursor, METH_NOARGS},
    {"centerOnScroll", (PyCFunction)SbkQPlainTextEditFunc_centerOnScroll, METH_NOARGS},
    {"changeEvent", (PyCFunction)SbkQPlainTextEditFunc_changeEvent, METH_O},
    {"clear", (PyCFunction)SbkQPlainTextEditFunc_clear, METH_NOARGS},
    {"contentOffset", (PyCFunction)SbkQPlainTextEditFunc_contentOffset, METH_NOARGS},
    {"contextMenuEvent", (PyCFunction)SbkQPlainTextEditFunc_contextMenuEvent, METH_O},
    {"copy", (PyCFunction)SbkQPlainTextEditFunc_copy, METH_NOARGS},
    {"createMimeDataFromSelection", (PyCFunction)SbkQPlainTextEditFunc_createMimeDataFromSelection, METH_NOARGS},
    {"createStandardContextMenu", (PyCFunction)SbkQPlainTextEditFunc_createStandardContextMenu, METH_NOARGS},
    {"currentCharFormat", (PyCFunction)SbkQPlainTextEditFunc_currentCharFormat, METH_NOARGS},
    {"cursorForPosition", (PyCFunction)SbkQPlainTextEditFunc_cursorForPosition, METH_O},
    {"cursorRect", (PyCFunction)SbkQPlainTextEditFunc_cursorRect, METH_NOARGS|METH_O},
    {"cursorWidth", (PyCFunction)SbkQPlainTextEditFunc_cursorWidth, METH_NOARGS},
    {"cut", (PyCFunction)SbkQPlainTextEditFunc_cut, METH_NOARGS},
    {"document", (PyCFunction)SbkQPlainTextEditFunc_document, METH_NOARGS},
    {"documentTitle", (PyCFunction)SbkQPlainTextEditFunc_documentTitle, METH_NOARGS},
    {"dragEnterEvent", (PyCFunction)SbkQPlainTextEditFunc_dragEnterEvent, METH_O},
    {"dragLeaveEvent", (PyCFunction)SbkQPlainTextEditFunc_dragLeaveEvent, METH_O},
    {"dragMoveEvent", (PyCFunction)SbkQPlainTextEditFunc_dragMoveEvent, METH_O},
    {"dropEvent", (PyCFunction)SbkQPlainTextEditFunc_dropEvent, METH_O},
    {"ensureCursorVisible", (PyCFunction)SbkQPlainTextEditFunc_ensureCursorVisible, METH_NOARGS},
    {"event", (PyCFunction)SbkQPlainTextEditFunc_event, METH_O},
    {"extraSelections", (PyCFunction)SbkQPlainTextEditFunc_extraSelections, METH_NOARGS},
    {"find", (PyCFunction)SbkQPlainTextEditFunc_find, METH_VARARGS},
    {"firstVisibleBlock", (PyCFunction)SbkQPlainTextEditFunc_firstVisibleBlock, METH_NOARGS},
    {"focusInEvent", (PyCFunction)SbkQPlainTextEditFunc_focusInEvent, METH_O},
    {"focusNextPrevChild", (PyCFunction)SbkQPlainTextEditFunc_focusNextPrevChild, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQPlainTextEditFunc_focusOutEvent, METH_O},
    {"getPaintContext", (PyCFunction)SbkQPlainTextEditFunc_getPaintContext, METH_NOARGS},
    {"inputMethodEvent", (PyCFunction)SbkQPlainTextEditFunc_inputMethodEvent, METH_O},
    {"inputMethodQuery", (PyCFunction)SbkQPlainTextEditFunc_inputMethodQuery, METH_O},
    {"insertFromMimeData", (PyCFunction)SbkQPlainTextEditFunc_insertFromMimeData, METH_O},
    {"insertPlainText", (PyCFunction)SbkQPlainTextEditFunc_insertPlainText, METH_O},
    {"isReadOnly", (PyCFunction)SbkQPlainTextEditFunc_isReadOnly, METH_NOARGS},
    {"isUndoRedoEnabled", (PyCFunction)SbkQPlainTextEditFunc_isUndoRedoEnabled, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQPlainTextEditFunc_keyPressEvent, METH_O},
    {"keyReleaseEvent", (PyCFunction)SbkQPlainTextEditFunc_keyReleaseEvent, METH_O},
    {"lineWrapMode", (PyCFunction)SbkQPlainTextEditFunc_lineWrapMode, METH_NOARGS},
    {"loadResource", (PyCFunction)SbkQPlainTextEditFunc_loadResource, METH_VARARGS},
    {"maximumBlockCount", (PyCFunction)SbkQPlainTextEditFunc_maximumBlockCount, METH_NOARGS},
    {"mergeCurrentCharFormat", (PyCFunction)SbkQPlainTextEditFunc_mergeCurrentCharFormat, METH_O},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQPlainTextEditFunc_mouseDoubleClickEvent, METH_O},
    {"mouseMoveEvent", (PyCFunction)SbkQPlainTextEditFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQPlainTextEditFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQPlainTextEditFunc_mouseReleaseEvent, METH_O},
    {"moveCursor", (PyCFunction)SbkQPlainTextEditFunc_moveCursor, METH_VARARGS},
    {"overwriteMode", (PyCFunction)SbkQPlainTextEditFunc_overwriteMode, METH_NOARGS},
    {"paintEvent", (PyCFunction)SbkQPlainTextEditFunc_paintEvent, METH_O},
    {"paste", (PyCFunction)SbkQPlainTextEditFunc_paste, METH_NOARGS},
    {"print", (PyCFunction)SbkQPlainTextEditFunc_print, METH_O},
    {"redo", (PyCFunction)SbkQPlainTextEditFunc_redo, METH_NOARGS},
    {"resizeEvent", (PyCFunction)SbkQPlainTextEditFunc_resizeEvent, METH_O},
    {"scrollContentsBy", (PyCFunction)SbkQPlainTextEditFunc_scrollContentsBy, METH_VARARGS},
    {"selectAll", (PyCFunction)SbkQPlainTextEditFunc_selectAll, METH_NOARGS},
    {"setBackgroundVisible", (PyCFunction)SbkQPlainTextEditFunc_setBackgroundVisible, METH_O},
    {"setCenterOnScroll", (PyCFunction)SbkQPlainTextEditFunc_setCenterOnScroll, METH_O},
    {"setCurrentCharFormat", (PyCFunction)SbkQPlainTextEditFunc_setCurrentCharFormat, METH_O},
    {"setCursorWidth", (PyCFunction)SbkQPlainTextEditFunc_setCursorWidth, METH_O},
    {"setDocument", (PyCFunction)SbkQPlainTextEditFunc_setDocument, METH_O},
    {"setDocumentTitle", (PyCFunction)SbkQPlainTextEditFunc_setDocumentTitle, METH_O},
    {"setExtraSelections", (PyCFunction)SbkQPlainTextEditFunc_setExtraSelections, METH_O},
    {"setLineWrapMode", (PyCFunction)SbkQPlainTextEditFunc_setLineWrapMode, METH_O},
    {"setMaximumBlockCount", (PyCFunction)SbkQPlainTextEditFunc_setMaximumBlockCount, METH_O},
    {"setOverwriteMode", (PyCFunction)SbkQPlainTextEditFunc_setOverwriteMode, METH_O},
    {"setPlainText", (PyCFunction)SbkQPlainTextEditFunc_setPlainText, METH_O},
    {"setReadOnly", (PyCFunction)SbkQPlainTextEditFunc_setReadOnly, METH_O},
    {"setTabChangesFocus", (PyCFunction)SbkQPlainTextEditFunc_setTabChangesFocus, METH_O},
    {"setTabStopWidth", (PyCFunction)SbkQPlainTextEditFunc_setTabStopWidth, METH_O},
    {"setTextCursor", (PyCFunction)SbkQPlainTextEditFunc_setTextCursor, METH_O},
    {"setTextInteractionFlags", (PyCFunction)SbkQPlainTextEditFunc_setTextInteractionFlags, METH_O},
    {"setUndoRedoEnabled", (PyCFunction)SbkQPlainTextEditFunc_setUndoRedoEnabled, METH_O},
    {"setWordWrapMode", (PyCFunction)SbkQPlainTextEditFunc_setWordWrapMode, METH_O},
    {"showEvent", (PyCFunction)SbkQPlainTextEditFunc_showEvent, METH_O},
    {"tabChangesFocus", (PyCFunction)SbkQPlainTextEditFunc_tabChangesFocus, METH_NOARGS},
    {"tabStopWidth", (PyCFunction)SbkQPlainTextEditFunc_tabStopWidth, METH_NOARGS},
    {"textCursor", (PyCFunction)SbkQPlainTextEditFunc_textCursor, METH_NOARGS},
    {"textInteractionFlags", (PyCFunction)SbkQPlainTextEditFunc_textInteractionFlags, METH_NOARGS},
    {"timerEvent", (PyCFunction)SbkQPlainTextEditFunc_timerEvent, METH_O},
    {"toPlainText", (PyCFunction)SbkQPlainTextEditFunc_toPlainText, METH_NOARGS},
    {"undo", (PyCFunction)SbkQPlainTextEditFunc_undo, METH_NOARGS},
    {"wheelEvent", (PyCFunction)SbkQPlainTextEditFunc_wheelEvent, METH_O},
    {"wordWrapMode", (PyCFunction)SbkQPlainTextEditFunc_wordWrapMode, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQPlainTextEditSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QPlainTextEdit* me = reinterpret_cast<QPlainTextEdit*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast<QAbstractScrollArea*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPlainTextEdit_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPlainTextEdit",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPlainTextEditWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPlainTextEdit_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPlainTextEdit_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQPlainTextEditSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "LineWrapMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QPlainTextEdit(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPLAINTEXTEDIT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPlainTextEdit_Type);

    SbkQPlainTextEdit_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX];
    SbkQPlainTextEdit_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQPlainTextEdit_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQPlainTextEdit_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPlainTextEdit_Type));
    PyModule_AddObject(module, "QPlainTextEdit",
        ((PyObject*)&SbkQPlainTextEdit_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: LineWrapMode
    SbkPySide_QtGuiTypes[SBK_QPLAINTEXTEDIT_LINEWRAPMODE_IDX] = &SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_Type);
    PyDict_SetItemString(SbkQPlainTextEdit_Type.super.ht_type.tp_dict,
            "LineWrapMode",((PyObject*)&SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_Type,
        (long) QPlainTextEdit::NoWrap, "NoWrap");
    PyDict_SetItemString(SbkQPlainTextEdit_Type.super.ht_type.tp_dict,
        "NoWrap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_Type.tp_dict,
        "NoWrap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_Type,
        (long) QPlainTextEdit::WidgetWidth, "WidgetWidth");
    PyDict_SetItemString(SbkQPlainTextEdit_Type.super.ht_type.tp_dict,
        "WidgetWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPlainTextEdit_LineWrapMode_Type.tp_dict,
        "WidgetWidth", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPlainTextEdit::LineWrapMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QPlainTextEdit >("QPlainTextEdit*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPlainTextEdit >(typeid(QPlainTextEdit).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

