/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpictureio_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qiodevice.h>
#include <qpicture.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQPictureIO_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPictureIO* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QPictureIO()
    cptr = new QPictureIO();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQPictureIOFunc_description(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // description()const
    QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QPictureIO::description();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureIOFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QPictureIO::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureIOFunc_gamma(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // gamma()const
    QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
    float cpp_result = cppSelf->QPictureIO::gamma();
    py_result = Shiboken::Converter<float >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureIOFunc_inputFormats(PyObject* self)
{
    PyObject* py_result = 0;

    // inputFormats()
    QList<QByteArray > cpp_result = QPictureIO::inputFormats();
    py_result = Shiboken::Converter<QList<QByteArray > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureIOFunc_ioDevice(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ioDevice()const
    QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QPictureIO::ioDevice();
    py_result = Shiboken::Converter<QIODevice* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureIOFunc_outputFormats(PyObject* self)
{
    PyObject* py_result = 0;

    // outputFormats()
    QList<QByteArray > cpp_result = QPictureIO::outputFormats();
    py_result = Shiboken::Converter<QList<QByteArray > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureIOFunc_picture(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // picture()const
    QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
    const QPicture & cpp_result = cppSelf->QPictureIO::picture();
    py_result = Shiboken::Converter<QPicture& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureIOFunc_pictureFormat(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // pictureFormat(QString)
        QByteArray cpp_result = QPictureIO::pictureFormat(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else if (Shiboken::Converter<QIODevice* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // pictureFormat(QIODevice*)
        QByteArray cpp_result = QPictureIO::pictureFormat(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQPictureIOFunc_pictureFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPictureIOFunc_pictureFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPictureIO.pictureFormat", overloads);
        return 0;
}

static PyObject*
SbkQPictureIOFunc_quality(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // quality()const
    QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPictureIO::quality();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureIOFunc_read(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // read()
    QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPictureIO::read();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureIOFunc_setDescription(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDescription(QString)
        QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
        cppSelf->QPictureIO::setDescription(*cpp_arg0);
    } else goto SbkQPictureIOFunc_setDescription_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPictureIOFunc_setDescription_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPictureIO.setDescription", overloads);
        return 0;
}

static PyObject*
SbkQPictureIOFunc_setFileName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFileName(QString)
        QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
        cppSelf->QPictureIO::setFileName(*cpp_arg0);
    } else goto SbkQPictureIOFunc_setFileName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPictureIOFunc_setFileName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPictureIO.setFileName", overloads);
        return 0;
}

static PyObject*
SbkQPictureIOFunc_setGamma(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        float cpp_arg0 = Shiboken::Converter<float >::toCpp(arg);
        // setGamma(float)
        QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
        cppSelf->QPictureIO::setGamma(cpp_arg0);
    } else goto SbkQPictureIOFunc_setGamma_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPictureIOFunc_setGamma_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPictureIO.setGamma", overloads);
        return 0;
}

static PyObject*
SbkQPictureIOFunc_setIODevice(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIODevice* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // setIODevice(QIODevice*)
        QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
        cppSelf->QPictureIO::setIODevice(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQPictureIOFunc_setIODevice_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPictureIOFunc_setIODevice_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPictureIO.setIODevice", overloads);
        return 0;
}

static PyObject*
SbkQPictureIOFunc_setPicture(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPicture& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPicture* cpp_arg0 = Shiboken::Converter<QPicture* >::toCpp(arg);
        // setPicture(QPicture)
        QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
        cppSelf->QPictureIO::setPicture(*cpp_arg0);
    } else goto SbkQPictureIOFunc_setPicture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPictureIOFunc_setPicture_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPicture", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPictureIO.setPicture", overloads);
        return 0;
}

static PyObject*
SbkQPictureIOFunc_setQuality(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setQuality(int)
        QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
        cppSelf->QPictureIO::setQuality(cpp_arg0);
    } else goto SbkQPictureIOFunc_setQuality_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPictureIOFunc_setQuality_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPictureIO.setQuality", overloads);
        return 0;
}

static PyObject*
SbkQPictureIOFunc_setStatus(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setStatus(int)
        QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
        cppSelf->QPictureIO::setStatus(cpp_arg0);
    } else goto SbkQPictureIOFunc_setStatus_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPictureIOFunc_setStatus_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPictureIO.setStatus", overloads);
        return 0;
}

static PyObject*
SbkQPictureIOFunc_status(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // status()const
    QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPictureIO::status();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureIOFunc_write(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // write()
    QPictureIO* cppSelf = Shiboken::Converter<QPictureIO* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPictureIO::write();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQPictureIO_methods[] = {
    {"description", (PyCFunction)SbkQPictureIOFunc_description, METH_NOARGS},
    {"fileName", (PyCFunction)SbkQPictureIOFunc_fileName, METH_NOARGS},
    {"gamma", (PyCFunction)SbkQPictureIOFunc_gamma, METH_NOARGS},
    {"inputFormats", (PyCFunction)SbkQPictureIOFunc_inputFormats, METH_NOARGS|METH_STATIC},
    {"ioDevice", (PyCFunction)SbkQPictureIOFunc_ioDevice, METH_NOARGS},
    {"outputFormats", (PyCFunction)SbkQPictureIOFunc_outputFormats, METH_NOARGS|METH_STATIC},
    {"picture", (PyCFunction)SbkQPictureIOFunc_picture, METH_NOARGS},
    {"pictureFormat", (PyCFunction)SbkQPictureIOFunc_pictureFormat, METH_O|METH_STATIC},
    {"quality", (PyCFunction)SbkQPictureIOFunc_quality, METH_NOARGS},
    {"read", (PyCFunction)SbkQPictureIOFunc_read, METH_NOARGS},
    {"setDescription", (PyCFunction)SbkQPictureIOFunc_setDescription, METH_O},
    {"setFileName", (PyCFunction)SbkQPictureIOFunc_setFileName, METH_O},
    {"setGamma", (PyCFunction)SbkQPictureIOFunc_setGamma, METH_O},
    {"setIODevice", (PyCFunction)SbkQPictureIOFunc_setIODevice, METH_O},
    {"setPicture", (PyCFunction)SbkQPictureIOFunc_setPicture, METH_O},
    {"setQuality", (PyCFunction)SbkQPictureIOFunc_setQuality, METH_O},
    {"setStatus", (PyCFunction)SbkQPictureIOFunc_setStatus, METH_O},
    {"status", (PyCFunction)SbkQPictureIOFunc_status, METH_NOARGS},
    {"write", (PyCFunction)SbkQPictureIOFunc_write, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPictureIO_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPictureIO",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPictureIO >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPictureIO_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPictureIO_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QPictureIO(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPICTUREIO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPictureIO_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPictureIO_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPictureIO_Type));
    PyModule_AddObject(module, "QPictureIO",
        ((PyObject*)&SbkQPictureIO_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QPictureIO >("QPictureIO*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPictureIO >(typeid(QPictureIO).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

