/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpicture_wrapper.h"

// Extra includes
#include <qdatastream.h>
#include <qiodevice.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpicture.h>
#include <qrect.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPictureWrapper::QPictureWrapper(int formatVersion) : QPicture(formatVersion) {
    // ... middle
}

int QPictureWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QPicture::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPicture.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QPictureWrapper::metric(QPaintDevice::PaintDeviceMetric m) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QPicture::metric(m);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(m)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPicture.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QPaintEngine * QPictureWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QPicture::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QPicture.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QPictureWrapper::~QPictureWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQPicture_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPictureWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QPicture", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QPicture(int)
        cptr = new QPictureWrapper();
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QPicture(int)
        cptr = new QPictureWrapper(cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QPicture& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPicture* cpp_arg0 = Shiboken::Converter<QPicture* >::toCpp(pyargs[0]);
        // QPicture(QPicture)
        cptr = new QPictureWrapper(*cpp_arg0);
    } else goto SbkQPicture_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPicture_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQPicture_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPicture", "int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPicture", overloads);
        return -1;
}

static PyObject*
SbkQPictureFunc_boundingRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundingRect()const
    QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QPicture::boundingRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureFunc_data(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // data()const
    QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
    const char * cpp_result = cppSelf->QPicture::data();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureFunc_devType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // devType()const
    QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPicture::devType();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPicture::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureFunc_load(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "load", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // load(QString,const char*)
            QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QPicture::load(*cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            // load(QString,const char*)
            QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QPicture::load(*cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQPictureFunc_load_TypeError;
    } else if (Shiboken::Converter<QIODevice* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // load(QIODevice*,const char*)
            QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QPicture::load(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            // load(QIODevice*,const char*)
            QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QPicture::load(cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQPictureFunc_load_TypeError;
    } else goto SbkQPictureFunc_load_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPictureFunc_load_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice, str = None", "PySide.QtCore.QString, str = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPicture.load", overloads);
        return 0;
}

static PyObject*
SbkQPictureFunc_metric(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::isConvertible(arg)) {
        QPaintDevice::PaintDeviceMetric cpp_arg0 = Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toCpp(arg);
        // metric(QPaintDevice::PaintDeviceMetric)const
        QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QPicture::metric(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQPictureFunc_metric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPictureFunc_metric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice.PaintDeviceMetric", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPicture.metric", overloads);
        return 0;
}

static PyObject*
SbkQPictureFunc_paintEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintEngine()const
    QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
    QPaintEngine * cpp_result = cppSelf->QPicture::paintEngine();
    py_result = Shiboken::Converter<QPaintEngine* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPictureFunc_play(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPainter* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(arg);
        // play(QPainter*)
        QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPicture::play(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQPictureFunc_play_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPictureFunc_play_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPicture.play", overloads);
        return 0;
}

static PyObject*
SbkQPictureFunc_save(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "save", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // save(QString,const char*)
            QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QPicture::save(*cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            // save(QString,const char*)
            QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QPicture::save(*cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQPictureFunc_save_TypeError;
    } else if (Shiboken::Converter<QIODevice* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // save(QIODevice*,const char*)
            QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QPicture::save(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            // save(QIODevice*,const char*)
            QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QPicture::save(cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQPictureFunc_save_TypeError;
    } else goto SbkQPictureFunc_save_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPictureFunc_save_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice, str = None", "PySide.QtCore.QString, str = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPicture.save", overloads);
        return 0;
}

static PyObject*
SbkQPictureFunc_setBoundingRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setBoundingRect(QRect)
        QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
        cppSelf->QPicture::setBoundingRect(*cpp_arg0);
    } else goto SbkQPictureFunc_setBoundingRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPictureFunc_setBoundingRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPicture.setBoundingRect", overloads);
        return 0;
}

static PyObject*
SbkQPictureFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QPicture::size();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQPicture_methods[] = {
    {"boundingRect", (PyCFunction)SbkQPictureFunc_boundingRect, METH_NOARGS},
    {"data", (PyCFunction)SbkQPictureFunc_data, METH_NOARGS},
    {"devType", (PyCFunction)SbkQPictureFunc_devType, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQPictureFunc_isNull, METH_NOARGS},
    {"load", (PyCFunction)SbkQPictureFunc_load, METH_VARARGS},
    {"metric", (PyCFunction)SbkQPictureFunc_metric, METH_O},
    {"paintEngine", (PyCFunction)SbkQPictureFunc_paintEngine, METH_NOARGS},
    {"play", (PyCFunction)SbkQPictureFunc_play, METH_O},
    {"save", (PyCFunction)SbkQPictureFunc_save, METH_VARARGS},
    {"setBoundingRect", (PyCFunction)SbkQPictureFunc_setBoundingRect, METH_O},
    {"size", (PyCFunction)SbkQPictureFunc_size, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQPictureFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPicture_Check(arg) && !SbkQPicture_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QPicture) [reverse operator]
        QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQPictureFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPictureFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPicture.__lshift__", overloads);
        return 0;
}

static PyObject*
SbkQPictureFunc___rshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPicture_Check(arg) && !SbkQPicture_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rrshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QDataStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QPicture&) [reverse operator]
        QPicture* cppSelf = Shiboken::Converter<QPicture* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQPictureFunc___rshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPictureFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPicture.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQPicture_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQPictureFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQPictureFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

extern "C"
{

static void* SbkQPicture_ObjCopierFunc(const void* ptr){
    return new QPictureWrapper(*reinterpret_cast<const QPicture*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPicture_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPicture",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPictureWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQPicture_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPicture_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPicture_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQPicture_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QPicture(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPICTURE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPicture_Type);

    SbkQPicture_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX];
    // Fill type discovery information
    SbkQPicture_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQPicture_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPicture_Type));
    PyModule_AddObject(module, "QPicture",
        ((PyObject*)&SbkQPicture_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QPicture >("QPicture");
    Shiboken::TypeResolver::createValueTypeResolver<QPicture >(typeid(QPicture).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

