/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qmatrix2x2_wrapper.h"

// Extra includes

using namespace Shiboken;

// Native ---------------------------------------------------------

QMatrix2x2Wrapper::QMatrix2x2Wrapper() : QMatrix2x2() {
    // ... middle
}

QMatrix2x2Wrapper::~QMatrix2x2Wrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQMatrix2x2_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMatrix2x2Wrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QMatrix2x2()
    cptr = new QMatrix2x2Wrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyMethodDef SbkQMatrix2x2_methods[] = {
    {0} // Sentinel
};

extern "C"
{

static void* SbkQMatrix2x2_ObjCopierFunc(const void* ptr){
    return new QMatrix2x2Wrapper(*reinterpret_cast<const QMatrix2x2*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMatrix2x2_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMatrix2x2",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QMatrix2x2Wrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMatrix2x2_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMatrix2x2_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQMatrix2x2_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQMatrix2x2_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQMatrix2x2_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QMatrix2x2*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QMatrix2x2(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMATRIX2X2_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMatrix2x2_Type);

    // Fill type discovery information
    SbkQMatrix2x2_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQMatrix2x2_Type.type_discovery->addTypeDiscoveryFunction(&SbkQMatrix2x2_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQMatrix2x2_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMatrix2x2_Type));
    PyModule_AddObject(module, "QMatrix2x2",
        ((PyObject*)&SbkQMatrix2x2_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QMatrix2x2 >("QMatrix2x2");
    Shiboken::TypeResolver::createValueTypeResolver<QMatrix2x2 >(typeid(QMatrix2x2).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

