/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qlistview_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemdelegate.h>
#include <qabstractitemmodel.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qitemselectionmodel.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QListViewWrapper::QListViewWrapper(QWidget * parent) : QListView(parent), m_metaObject(0) {
    // ... middle
}

void QListViewWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QListViewWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QFrame::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::closeEditor(QWidget * editor, QAbstractItemDelegate::EndEditHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEditor"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::closeEditor(editor, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QWidget* >::toPython(editor),
        Shiboken::Converter<QAbstractItemDelegate::EndEditHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QListViewWrapper::commitData(QWidget * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "commitData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::commitData(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::currentChanged(const QModelIndex & current, const QModelIndex & previous)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "currentChanged"));
    if (py_override.isNull()) {
        return this->QListView::currentChanged(current, previous);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(current),
        Shiboken::Converter<QModelIndex& >::toPython(previous)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::dataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dataChanged"));
    if (py_override.isNull()) {
        return this->QListView::dataChanged(topLeft, bottomRight);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(topLeft),
        Shiboken::Converter<QModelIndex& >::toPython(bottomRight)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QListViewWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::doItemsLayout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "doItemsLayout"));
    if (py_override.isNull()) {
        return this->QListView::doItemsLayout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::dragEnterEvent(QDragEnterEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::dragLeaveEvent(QDragLeaveEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QListView::dragLeaveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::dragMoveEvent(QDragMoveEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QListView::dragMoveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::dropEvent(QDropEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QListView::dropEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QListViewWrapper::edit(const QModelIndex & index, QAbstractItemView::EditTrigger trigger, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "edit"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::edit(index, trigger, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QAbstractItemView::EditTrigger >::toPython(trigger),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.edit");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 2));
    return cpp_result;
}

void QListViewWrapper::editorDestroyed(QObject * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "editorDestroyed"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::editorDestroyed(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QObject* >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QListViewWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QListView::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QListViewWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QListViewWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QListViewWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QListViewWrapper::horizontalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalOffset"));
    if (py_override.isNull()) {
        return this->QListView::horizontalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.horizontalOffset");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::horizontalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::horizontalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::horizontalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::horizontalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QModelIndex QListViewWrapper::indexAt(const QPoint & p) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexAt"));
    if (py_override.isNull()) {
        return this->QListView::indexAt(p);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPoint& >::toPython(p)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.indexAt");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::inputMethodEvent(QInputMethodEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QListViewWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QListViewWrapper::isIndexHidden(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isIndexHidden"));
    if (py_override.isNull()) {
        return this->QListView::isIndexHidden(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.isIndexHidden");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QListViewWrapper::keyboardSearch(const QString & search)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyboardSearch"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::keyboardSearch(search);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(search)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QListViewWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QListViewWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::mouseDoubleClickEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::mouseMoveEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QListView::mouseMoveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::mousePressEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::mouseReleaseEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QListView::mouseReleaseEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QListViewWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QListViewWrapper::paintEvent(QPaintEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QListView::paintEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QListView::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::resizeEvent(QResizeEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QListView::resizeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::rowsAboutToBeRemoved(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsAboutToBeRemoved"));
    if (py_override.isNull()) {
        return this->QListView::rowsAboutToBeRemoved(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oii)",
        Shiboken::Converter<QModelIndex& >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::rowsInserted(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsInserted"));
    if (py_override.isNull()) {
        return this->QListView::rowsInserted(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oii)",
        Shiboken::Converter<QModelIndex& >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QListView::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::scrollTo(const QModelIndex & index, QAbstractItemView::ScrollHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollTo"));
    if (py_override.isNull()) {
        return this->QListView::scrollTo(index, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QAbstractItemView::ScrollHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::selectAll()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectAll"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectAll();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QList<QModelIndex > QListViewWrapper::selectedIndexes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectedIndexes"));
    if (py_override.isNull()) {
        return this->QListView::selectedIndexes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.selectedIndexes");
        return QList<QModelIndex >()        ;
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::selectionChanged(const QItemSelection & selected, const QItemSelection & deselected)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionChanged"));
    if (py_override.isNull()) {
        return this->QListView::selectionChanged(selected, deselected);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QItemSelection& >::toPython(selected),
        Shiboken::Converter<QItemSelection& >::toPython(deselected)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<QItemSelectionModel::SelectionFlag> QListViewWrapper::selectionCommand(const QModelIndex & index, const QEvent * event) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionCommand"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectionCommand(index, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<QItemSelectionModel::SelectionFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.selectionCommand");
        return QFlags<QItemSelectionModel::SelectionFlag>()        ;
    }
    QFlags<QItemSelectionModel::SelectionFlag> cpp_result(Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QListViewWrapper::setModel(QAbstractItemModel * model)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setModel"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::setModel(model);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QAbstractItemModel* >::toPython(model)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::setRootIndex(const QModelIndex & index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setRootIndex"));
    if (py_override.isNull()) {
        return this->QListView::setRootIndex(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::setSelection(const QRect & rect, QFlags<QItemSelectionModel::SelectionFlag> command)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelection"));
    if (py_override.isNull()) {
        return this->QListView::setSelection(rect, command);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QRect& >::toPython(rect),
        Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toPython(command)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::setSelectionModel(QItemSelectionModel * selectionModel)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelectionModel"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::setSelectionModel(selectionModel);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelectionModel* >::toPython(selectionModel)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QListViewWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QListViewWrapper::sizeHintForColumn(int column) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForColumn"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::sizeHintForColumn(column);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        column
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.sizeHintForColumn");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QListViewWrapper::sizeHintForRow(int row) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForRow"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::sizeHintForRow(row);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        row
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.sizeHintForRow");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::startDrag(QFlags<Qt::DropAction> supportedActions)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDrag"));
    if (py_override.isNull()) {
        return this->QListView::startDrag(supportedActions);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(supportedActions)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QListViewWrapper::timerEvent(QTimerEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QListView::timerEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::updateEditorData()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorData();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::updateEditorGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorGeometries"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::updateGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometries"));
    if (py_override.isNull()) {
        return this->QListView::updateGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QListViewWrapper::verticalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalOffset"));
    if (py_override.isNull()) {
        return this->QListView::verticalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.verticalOffset");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::verticalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QListViewWrapper::verticalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QStyleOptionViewItem QListViewWrapper::viewOptions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewOptions"));
    if (py_override.isNull()) {
        return this->QListView::viewOptions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStyleOptionViewItem();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStyleOptionViewItem >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.viewOptions");
        return QStyleOptionViewItem()        ;
    }
    QStyleOptionViewItem cpp_result(Shiboken::Converter<QStyleOptionViewItem >::toCpp(py_result));
    return cpp_result;
}

bool QListViewWrapper::viewportEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::viewportEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.viewportEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QRect QListViewWrapper::visualRect(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRect"));
    if (py_override.isNull()) {
        return this->QListView::visualRect(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.visualRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

QRegion QListViewWrapper::visualRegionForSelection(const QItemSelection & selection) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRegionForSelection"));
    if (py_override.isNull()) {
        return this->QListView::visualRegionForSelection(selection);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelection& >::toPython(selection)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRegion();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRegion >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QListView.visualRegionForSelection");
        return QRegion()        ;
    }
    QRegion cpp_result(Shiboken::Converter<QRegion >::toCpp(py_result));
    return cpp_result;
}

void QListViewWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QListViewWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QListView::staticMetaObject);
}
    return m_metaObject;
}

int QListViewWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QListView::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QListViewWrapper::~QListViewWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQListView_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QListViewWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QListView", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QListView(QWidget*)
        cptr = new QListViewWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QListView(QWidget*)
        cptr = new QListViewWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQListView_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQListView_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQListView_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView", overloads);
        return -1;
}

static PyObject*
SbkQListViewFunc_batchSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // batchSize()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QListView::batchSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_clearPropertyFlags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearPropertyFlags()
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    cppSelf->QListView::clearPropertyFlags();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQListViewFunc_contentsSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contentsSize()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QListView::contentsSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_currentChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "currentChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // currentChanged(QModelIndex,QModelIndex)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::currentChanged(*cpp_arg0, *cpp_arg1);
    } else goto SbkQListViewFunc_currentChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_currentChanged_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.currentChanged", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_dataChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "dataChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // dataChanged(QModelIndex,QModelIndex)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::dataChanged(*cpp_arg0, *cpp_arg1);
    } else goto SbkQListViewFunc_dataChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_dataChanged_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.dataChanged", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_doItemsLayout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // doItemsLayout()
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    cppSelf->QListView::doItemsLayout();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQListViewFunc_dragLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragLeaveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragLeaveEvent* cpp_arg0 = Shiboken::Converter<QDragLeaveEvent* >::toCpp(arg);
        // dragLeaveEvent(QDragLeaveEvent*)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::dragLeaveEvent(cpp_arg0);
    } else goto SbkQListViewFunc_dragLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_dragLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragLeaveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.dragLeaveEvent", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragMoveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragMoveEvent* cpp_arg0 = Shiboken::Converter<QDragMoveEvent* >::toCpp(arg);
        // dragMoveEvent(QDragMoveEvent*)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::dragMoveEvent(cpp_arg0);
    } else goto SbkQListViewFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.dragMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // dropEvent(QDropEvent*)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::dropEvent(cpp_arg0);
    } else goto SbkQListViewFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.dropEvent", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QListView::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQListViewFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListViewFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.event", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_flow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // flow()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    QListView::Flow cpp_result = cppSelf->QListView::flow();
    py_result = Shiboken::Converter<QListView::Flow >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_gridSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // gridSize()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QListView::gridSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_horizontalOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalOffset()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QListView::horizontalOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_indexAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // indexAt(QPoint)const
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QListView::indexAt(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQListViewFunc_indexAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListViewFunc_indexAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.indexAt", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_internalDrag(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_DropAction_Check(arg)) {
        QFlags<Qt::DropAction> cpp_arg0 = Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(arg);
        // internalDrag(QFlags<Qt::DropAction>)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::internalDrag(cpp_arg0);
    } else goto SbkQListViewFunc_internalDrag_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_internalDrag_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DropActions", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.internalDrag", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_internalDrop(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // internalDrop(QDropEvent*)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::internalDrop(cpp_arg0);
    } else goto SbkQListViewFunc_internalDrop_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_internalDrop_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.internalDrop", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_isIndexHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // isIndexHidden(QModelIndex)const
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QListView::isIndexHidden(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQListViewFunc_isIndexHidden_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListViewFunc_isIndexHidden_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.isIndexHidden", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_isRowHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isRowHidden(int)const
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QListView::isRowHidden(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQListViewFunc_isRowHidden_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListViewFunc_isRowHidden_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.isRowHidden", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_isSelectionRectVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSelectionRectVisible()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QListView::isSelectionRectVisible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_isWrapping(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isWrapping()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QListView::isWrapping();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_layoutMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // layoutMode()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    QListView::LayoutMode cpp_result = cppSelf->QListView::layoutMode();
    py_result = Shiboken::Converter<QListView::LayoutMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_modelColumn(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // modelColumn()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QListView::modelColumn();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::mouseMoveEvent(cpp_arg0);
    } else goto SbkQListViewFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.mouseMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::mouseReleaseEvent(cpp_arg0);
    } else goto SbkQListViewFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_moveCursor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "moveCursor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAbstractItemView::CursorAction >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[1])) {
        QAbstractItemView::CursorAction cpp_arg0 = Shiboken::Converter<QAbstractItemView::CursorAction >::toCpp(pyargs[0]);
        QFlags<Qt::KeyboardModifier> cpp_arg1 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[1]);
        // moveCursor(QAbstractItemView::CursorAction,QFlags<Qt::KeyboardModifier>)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QListView::moveCursor(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQListViewFunc_moveCursor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListViewFunc_moveCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView.CursorAction, PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.moveCursor", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_movement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // movement()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    QListView::Movement cpp_result = cppSelf->QListView::movement();
    py_result = Shiboken::Converter<QListView::Movement >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::paintEvent(cpp_arg0);
    } else goto SbkQListViewFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.paintEvent", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_rectForIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // rectForIndex(QModelIndex)const
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QListView::rectForIndex(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQListViewFunc_rectForIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListViewFunc_rectForIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.rectForIndex", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    cppSelf->QListView::reset();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQListViewFunc_resizeContents(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "resizeContents", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // resizeContents(int,int)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::resizeContents(cpp_arg0, cpp_arg1);
    } else goto SbkQListViewFunc_resizeContents_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_resizeContents_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.resizeContents", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::resizeEvent(cpp_arg0);
    } else goto SbkQListViewFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.resizeEvent", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_resizeMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // resizeMode()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    QListView::ResizeMode cpp_result = cppSelf->QListView::resizeMode();
    py_result = Shiboken::Converter<QListView::ResizeMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_rowsAboutToBeRemoved(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "rowsAboutToBeRemoved", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // rowsAboutToBeRemoved(QModelIndex,int,int)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::rowsAboutToBeRemoved(*cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQListViewFunc_rowsAboutToBeRemoved_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_rowsAboutToBeRemoved_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.rowsAboutToBeRemoved", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_rowsInserted(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "rowsInserted", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // rowsInserted(QModelIndex,int,int)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::rowsInserted(*cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQListViewFunc_rowsInserted_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_rowsInserted_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.rowsInserted", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_scrollContentsBy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollContentsBy", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // scrollContentsBy(int,int)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::scrollContentsBy(cpp_arg0, cpp_arg1);
    } else goto SbkQListViewFunc_scrollContentsBy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_scrollContentsBy_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.scrollContentsBy", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_scrollTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollTo", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // scrollTo(QModelIndex,QAbstractItemView::ScrollHint)
            QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
            cppSelf->QListView::scrollTo(*cpp_arg0);
        } else if (Shiboken::Converter<QAbstractItemView::ScrollHint >::isConvertible(pyargs[1])) {
            QAbstractItemView::ScrollHint cpp_arg1 = Shiboken::Converter<QAbstractItemView::ScrollHint >::toCpp(pyargs[1]);
            // scrollTo(QModelIndex,QAbstractItemView::ScrollHint)
            QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
            cppSelf->QListView::scrollTo(*cpp_arg0, cpp_arg1);
        } else goto SbkQListViewFunc_scrollTo_TypeError;
    } else goto SbkQListViewFunc_scrollTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_scrollTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtGui.QAbstractItemView.ScrollHint = EnsureVisible", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.scrollTo", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_selectedIndexes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedIndexes()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    QList<QModelIndex > cpp_result = cppSelf->QListView::selectedIndexes();
    py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_selectionChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "selectionChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QItemSelection& >::isConvertible(pyargs[0]) && Shiboken::Converter<QItemSelection& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QItemSelection* cpp_arg1 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[1]);
        // selectionChanged(QItemSelection,QItemSelection)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::selectionChanged(*cpp_arg0, *cpp_arg1);
    } else goto SbkQListViewFunc_selectionChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_selectionChanged_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection, PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.selectionChanged", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setBatchSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setBatchSize(int)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setBatchSize(cpp_arg0);
    } else goto SbkQListViewFunc_setBatchSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setBatchSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setBatchSize", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setFlow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QListView::Flow >::isConvertible(arg)) {
        QListView::Flow cpp_arg0 = Shiboken::Converter<QListView::Flow >::toCpp(arg);
        // setFlow(QListView::Flow)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setFlow(cpp_arg0);
    } else goto SbkQListViewFunc_setFlow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setFlow_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListView.Flow", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setFlow", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setGridSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setGridSize(QSize)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setGridSize(*cpp_arg0);
    } else goto SbkQListViewFunc_setGridSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setGridSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setGridSize", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setLayoutMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QListView::LayoutMode >::isConvertible(arg)) {
        QListView::LayoutMode cpp_arg0 = Shiboken::Converter<QListView::LayoutMode >::toCpp(arg);
        // setLayoutMode(QListView::LayoutMode)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setLayoutMode(cpp_arg0);
    } else goto SbkQListViewFunc_setLayoutMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setLayoutMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListView.LayoutMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setLayoutMode", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setModelColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setModelColumn(int)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setModelColumn(cpp_arg0);
    } else goto SbkQListViewFunc_setModelColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setModelColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setModelColumn", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setMovement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QListView::Movement >::isConvertible(arg)) {
        QListView::Movement cpp_arg0 = Shiboken::Converter<QListView::Movement >::toCpp(arg);
        // setMovement(QListView::Movement)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setMovement(cpp_arg0);
    } else goto SbkQListViewFunc_setMovement_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setMovement_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListView.Movement", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setMovement", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setPositionForIndex(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPositionForIndex", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // setPositionForIndex(QPoint,QModelIndex)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setPositionForIndex(*cpp_arg0, *cpp_arg1);
    } else goto SbkQListViewFunc_setPositionForIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setPositionForIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.setPositionForIndex", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setResizeMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QListView::ResizeMode >::isConvertible(arg)) {
        QListView::ResizeMode cpp_arg0 = Shiboken::Converter<QListView::ResizeMode >::toCpp(arg);
        // setResizeMode(QListView::ResizeMode)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setResizeMode(cpp_arg0);
    } else goto SbkQListViewFunc_setResizeMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setResizeMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListView.ResizeMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setResizeMode", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setRootIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // setRootIndex(QModelIndex)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setRootIndex(*cpp_arg0);
    } else goto SbkQListViewFunc_setRootIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setRootIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setRootIndex", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setRowHidden(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRowHidden", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setRowHidden(int,bool)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setRowHidden(cpp_arg0, cpp_arg1);
    } else goto SbkQListViewFunc_setRowHidden_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setRowHidden_TypeError:
        const char* overloads[] = {"int, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.setRowHidden", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setSelection(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setSelection", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QRect& >::isConvertible(pyargs[0]) && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        QFlags<QItemSelectionModel::SelectionFlag> cpp_arg1 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[1]);
        // setSelection(QRect,QFlags<QItemSelectionModel::SelectionFlag>)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setSelection(*cpp_arg0, cpp_arg1);
    } else goto SbkQListViewFunc_setSelection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setSelection_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QListView.setSelection", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setSelectionRectVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSelectionRectVisible(bool)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setSelectionRectVisible(cpp_arg0);
    } else goto SbkQListViewFunc_setSelectionRectVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setSelectionRectVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setSelectionRectVisible", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSpacing(int)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setSpacing(cpp_arg0);
    } else goto SbkQListViewFunc_setSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setSpacing", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setUniformItemSizes(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUniformItemSizes(bool)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setUniformItemSizes(cpp_arg0);
    } else goto SbkQListViewFunc_setUniformItemSizes_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setUniformItemSizes_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setUniformItemSizes", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setViewMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QListView::ViewMode >::isConvertible(arg)) {
        QListView::ViewMode cpp_arg0 = Shiboken::Converter<QListView::ViewMode >::toCpp(arg);
        // setViewMode(QListView::ViewMode)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setViewMode(cpp_arg0);
    } else goto SbkQListViewFunc_setViewMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setViewMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QListView.ViewMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setViewMode", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setWordWrap(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setWordWrap(bool)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setWordWrap(cpp_arg0);
    } else goto SbkQListViewFunc_setWordWrap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setWordWrap_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setWordWrap", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_setWrapping(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setWrapping(bool)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::setWrapping(cpp_arg0);
    } else goto SbkQListViewFunc_setWrapping_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_setWrapping_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.setWrapping", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_spacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // spacing()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QListView::spacing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_startDrag(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_DropAction_Check(arg)) {
        QFlags<Qt::DropAction> cpp_arg0 = Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(arg);
        // startDrag(QFlags<Qt::DropAction>)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::startDrag(cpp_arg0);
    } else goto SbkQListViewFunc_startDrag_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_startDrag_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DropActions", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.startDrag", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        cppSelf->QListView::timerEvent(cpp_arg0);
    } else goto SbkQListViewFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQListViewFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.timerEvent", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_uniformItemSizes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // uniformItemSizes()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QListView::uniformItemSizes();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_updateGeometries(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateGeometries()
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    cppSelf->QListView::updateGeometries();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQListViewFunc_verticalOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalOffset()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QListView::verticalOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_viewMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewMode()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    QListView::ViewMode cpp_result = cppSelf->QListView::viewMode();
    py_result = Shiboken::Converter<QListView::ViewMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_viewOptions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewOptions()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    QStyleOptionViewItem cpp_result = cppSelf->QListView::viewOptions();
    py_result = Shiboken::Converter<QStyleOptionViewItem >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQListViewFunc_visualRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // visualRect(QModelIndex)const
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QListView::visualRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQListViewFunc_visualRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListViewFunc_visualRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.visualRect", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_visualRegionForSelection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelection& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(arg);
        // visualRegionForSelection(QItemSelection)const
        QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QListView::visualRegionForSelection(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQListViewFunc_visualRegionForSelection_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQListViewFunc_visualRegionForSelection_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QListView.visualRegionForSelection", overloads);
        return 0;
}

static PyObject*
SbkQListViewFunc_wordWrap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // wordWrap()const
    QListView* cppSelf = Shiboken::Converter<QListView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QListView::wordWrap();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQListView_methods[] = {
    {"batchSize", (PyCFunction)SbkQListViewFunc_batchSize, METH_NOARGS},
    {"clearPropertyFlags", (PyCFunction)SbkQListViewFunc_clearPropertyFlags, METH_NOARGS},
    {"contentsSize", (PyCFunction)SbkQListViewFunc_contentsSize, METH_NOARGS},
    {"currentChanged", (PyCFunction)SbkQListViewFunc_currentChanged, METH_VARARGS},
    {"dataChanged", (PyCFunction)SbkQListViewFunc_dataChanged, METH_VARARGS},
    {"doItemsLayout", (PyCFunction)SbkQListViewFunc_doItemsLayout, METH_NOARGS},
    {"dragLeaveEvent", (PyCFunction)SbkQListViewFunc_dragLeaveEvent, METH_O},
    {"dragMoveEvent", (PyCFunction)SbkQListViewFunc_dragMoveEvent, METH_O},
    {"dropEvent", (PyCFunction)SbkQListViewFunc_dropEvent, METH_O},
    {"event", (PyCFunction)SbkQListViewFunc_event, METH_O},
    {"flow", (PyCFunction)SbkQListViewFunc_flow, METH_NOARGS},
    {"gridSize", (PyCFunction)SbkQListViewFunc_gridSize, METH_NOARGS},
    {"horizontalOffset", (PyCFunction)SbkQListViewFunc_horizontalOffset, METH_NOARGS},
    {"indexAt", (PyCFunction)SbkQListViewFunc_indexAt, METH_O},
    {"internalDrag", (PyCFunction)SbkQListViewFunc_internalDrag, METH_O},
    {"internalDrop", (PyCFunction)SbkQListViewFunc_internalDrop, METH_O},
    {"isIndexHidden", (PyCFunction)SbkQListViewFunc_isIndexHidden, METH_O},
    {"isRowHidden", (PyCFunction)SbkQListViewFunc_isRowHidden, METH_O},
    {"isSelectionRectVisible", (PyCFunction)SbkQListViewFunc_isSelectionRectVisible, METH_NOARGS},
    {"isWrapping", (PyCFunction)SbkQListViewFunc_isWrapping, METH_NOARGS},
    {"layoutMode", (PyCFunction)SbkQListViewFunc_layoutMode, METH_NOARGS},
    {"modelColumn", (PyCFunction)SbkQListViewFunc_modelColumn, METH_NOARGS},
    {"mouseMoveEvent", (PyCFunction)SbkQListViewFunc_mouseMoveEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQListViewFunc_mouseReleaseEvent, METH_O},
    {"moveCursor", (PyCFunction)SbkQListViewFunc_moveCursor, METH_VARARGS},
    {"movement", (PyCFunction)SbkQListViewFunc_movement, METH_NOARGS},
    {"paintEvent", (PyCFunction)SbkQListViewFunc_paintEvent, METH_O},
    {"rectForIndex", (PyCFunction)SbkQListViewFunc_rectForIndex, METH_O},
    {"reset", (PyCFunction)SbkQListViewFunc_reset, METH_NOARGS},
    {"resizeContents", (PyCFunction)SbkQListViewFunc_resizeContents, METH_VARARGS},
    {"resizeEvent", (PyCFunction)SbkQListViewFunc_resizeEvent, METH_O},
    {"resizeMode", (PyCFunction)SbkQListViewFunc_resizeMode, METH_NOARGS},
    {"rowsAboutToBeRemoved", (PyCFunction)SbkQListViewFunc_rowsAboutToBeRemoved, METH_VARARGS},
    {"rowsInserted", (PyCFunction)SbkQListViewFunc_rowsInserted, METH_VARARGS},
    {"scrollContentsBy", (PyCFunction)SbkQListViewFunc_scrollContentsBy, METH_VARARGS},
    {"scrollTo", (PyCFunction)SbkQListViewFunc_scrollTo, METH_VARARGS},
    {"selectedIndexes", (PyCFunction)SbkQListViewFunc_selectedIndexes, METH_NOARGS},
    {"selectionChanged", (PyCFunction)SbkQListViewFunc_selectionChanged, METH_VARARGS},
    {"setBatchSize", (PyCFunction)SbkQListViewFunc_setBatchSize, METH_O},
    {"setFlow", (PyCFunction)SbkQListViewFunc_setFlow, METH_O},
    {"setGridSize", (PyCFunction)SbkQListViewFunc_setGridSize, METH_O},
    {"setLayoutMode", (PyCFunction)SbkQListViewFunc_setLayoutMode, METH_O},
    {"setModelColumn", (PyCFunction)SbkQListViewFunc_setModelColumn, METH_O},
    {"setMovement", (PyCFunction)SbkQListViewFunc_setMovement, METH_O},
    {"setPositionForIndex", (PyCFunction)SbkQListViewFunc_setPositionForIndex, METH_VARARGS},
    {"setResizeMode", (PyCFunction)SbkQListViewFunc_setResizeMode, METH_O},
    {"setRootIndex", (PyCFunction)SbkQListViewFunc_setRootIndex, METH_O},
    {"setRowHidden", (PyCFunction)SbkQListViewFunc_setRowHidden, METH_VARARGS},
    {"setSelection", (PyCFunction)SbkQListViewFunc_setSelection, METH_VARARGS},
    {"setSelectionRectVisible", (PyCFunction)SbkQListViewFunc_setSelectionRectVisible, METH_O},
    {"setSpacing", (PyCFunction)SbkQListViewFunc_setSpacing, METH_O},
    {"setUniformItemSizes", (PyCFunction)SbkQListViewFunc_setUniformItemSizes, METH_O},
    {"setViewMode", (PyCFunction)SbkQListViewFunc_setViewMode, METH_O},
    {"setWordWrap", (PyCFunction)SbkQListViewFunc_setWordWrap, METH_O},
    {"setWrapping", (PyCFunction)SbkQListViewFunc_setWrapping, METH_O},
    {"spacing", (PyCFunction)SbkQListViewFunc_spacing, METH_NOARGS},
    {"startDrag", (PyCFunction)SbkQListViewFunc_startDrag, METH_O},
    {"timerEvent", (PyCFunction)SbkQListViewFunc_timerEvent, METH_O},
    {"uniformItemSizes", (PyCFunction)SbkQListViewFunc_uniformItemSizes, METH_NOARGS},
    {"updateGeometries", (PyCFunction)SbkQListViewFunc_updateGeometries, METH_NOARGS},
    {"verticalOffset", (PyCFunction)SbkQListViewFunc_verticalOffset, METH_NOARGS},
    {"viewMode", (PyCFunction)SbkQListViewFunc_viewMode, METH_NOARGS},
    {"viewOptions", (PyCFunction)SbkQListViewFunc_viewOptions, METH_NOARGS},
    {"visualRect", (PyCFunction)SbkQListViewFunc_visualRect, METH_O},
    {"visualRegionForSelection", (PyCFunction)SbkQListViewFunc_visualRegionForSelection, METH_O},
    {"wordWrap", (PyCFunction)SbkQListViewFunc_wordWrap, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQListViewSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QListView* me = reinterpret_cast<QListView*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX]))
        return static_cast<QAbstractItemView*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast<QAbstractScrollArea*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQListView_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QListView",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QListViewWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQListView_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQListView_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQListViewSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QListView_ResizeMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QListView_ResizeMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QListView_ResizeMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ResizeMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QListView_ResizeMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QListView_ResizeMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QListView_ResizeMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QListView_LayoutMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QListView_LayoutMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QListView_LayoutMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "LayoutMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QListView_LayoutMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QListView_LayoutMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QListView_LayoutMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QListView_ViewMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QListView_ViewMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QListView_ViewMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ViewMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QListView_ViewMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QListView_ViewMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QListView_ViewMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QListView_Flow_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QListView_Flow_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QListView_Flow_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Flow",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QListView_Flow_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QListView_Flow_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QListView_Flow_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QListView_Movement_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QListView_Movement_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QListView_Movement_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Movement",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QListView_Movement_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QListView_Movement_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QListView_Movement_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QListView(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QLISTVIEW_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQListView_Type);

    SbkQListView_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX];
    SbkQListView_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQListView_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQListView_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQListView_Type));
    PyModule_AddObject(module, "QListView",
        ((PyObject*)&SbkQListView_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ResizeMode
    SbkPySide_QtGuiTypes[SBK_QLISTVIEW_RESIZEMODE_IDX] = &SbkPySide_QtGui_QListView_ResizeMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QListView_ResizeMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QListView_ResizeMode_Type);
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
            "ResizeMode",((PyObject*)&SbkPySide_QtGui_QListView_ResizeMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListView_ResizeMode_Type,
        (long) QListView::Fixed, "Fixed");
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
        "Fixed", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListView_ResizeMode_Type.tp_dict,
        "Fixed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListView_ResizeMode_Type,
        (long) QListView::Adjust, "Adjust");
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
        "Adjust", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListView_ResizeMode_Type.tp_dict,
        "Adjust", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QListView::ResizeMode");

    // init enum class: LayoutMode
    SbkPySide_QtGuiTypes[SBK_QLISTVIEW_LAYOUTMODE_IDX] = &SbkPySide_QtGui_QListView_LayoutMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QListView_LayoutMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QListView_LayoutMode_Type);
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
            "LayoutMode",((PyObject*)&SbkPySide_QtGui_QListView_LayoutMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListView_LayoutMode_Type,
        (long) QListView::SinglePass, "SinglePass");
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
        "SinglePass", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListView_LayoutMode_Type.tp_dict,
        "SinglePass", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListView_LayoutMode_Type,
        (long) QListView::Batched, "Batched");
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
        "Batched", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListView_LayoutMode_Type.tp_dict,
        "Batched", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QListView::LayoutMode");

    // init enum class: ViewMode
    SbkPySide_QtGuiTypes[SBK_QLISTVIEW_VIEWMODE_IDX] = &SbkPySide_QtGui_QListView_ViewMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QListView_ViewMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QListView_ViewMode_Type);
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
            "ViewMode",((PyObject*)&SbkPySide_QtGui_QListView_ViewMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListView_ViewMode_Type,
        (long) QListView::ListMode, "ListMode");
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
        "ListMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListView_ViewMode_Type.tp_dict,
        "ListMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListView_ViewMode_Type,
        (long) QListView::IconMode, "IconMode");
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
        "IconMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListView_ViewMode_Type.tp_dict,
        "IconMode", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QListView::ViewMode");

    // init enum class: Flow
    SbkPySide_QtGuiTypes[SBK_QLISTVIEW_FLOW_IDX] = &SbkPySide_QtGui_QListView_Flow_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QListView_Flow_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QListView_Flow_Type);
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
            "Flow",((PyObject*)&SbkPySide_QtGui_QListView_Flow_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListView_Flow_Type,
        (long) QListView::LeftToRight, "LeftToRight");
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
        "LeftToRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListView_Flow_Type.tp_dict,
        "LeftToRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListView_Flow_Type,
        (long) QListView::TopToBottom, "TopToBottom");
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
        "TopToBottom", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListView_Flow_Type.tp_dict,
        "TopToBottom", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QListView::Flow");

    // init enum class: Movement
    SbkPySide_QtGuiTypes[SBK_QLISTVIEW_MOVEMENT_IDX] = &SbkPySide_QtGui_QListView_Movement_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QListView_Movement_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QListView_Movement_Type);
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
            "Movement",((PyObject*)&SbkPySide_QtGui_QListView_Movement_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListView_Movement_Type,
        (long) QListView::Static, "Static");
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
        "Static", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListView_Movement_Type.tp_dict,
        "Static", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListView_Movement_Type,
        (long) QListView::Free, "Free");
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
        "Free", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListView_Movement_Type.tp_dict,
        "Free", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QListView_Movement_Type,
        (long) QListView::Snap, "Snap");
    PyDict_SetItemString(SbkQListView_Type.super.ht_type.tp_dict,
        "Snap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QListView_Movement_Type.tp_dict,
        "Snap", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QListView::Movement");

    Shiboken::TypeResolver::createObjectTypeResolver<QListView >("QListView*");
    Shiboken::TypeResolver::createObjectTypeResolver<QListView >(typeid(QListView).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

