/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qlayoutitem_wrapper.h"

// Extra includes
#include <qlayout.h>
#include <qlayoutitem.h>
#include <qrect.h>
#include <qsize.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QLayoutItemWrapper::QLayoutItemWrapper(QFlags<Qt::AlignmentFlag> alignment) : QLayoutItem(alignment) {
    // ... middle
}

QFlags<Qt::Orientation> QLayoutItemWrapper::expandingDirections() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "expandingDirections"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.expandingDirections()' not implemented.");
        return QFlags<Qt::Orientation>();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::Orientation>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::Orientation> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.expandingDirections");
        return QFlags<Qt::Orientation>()        ;
    }
    QFlags<Qt::Orientation> cpp_result(Shiboken::Converter<QFlags<Qt::Orientation> >::toCpp(py_result));
    return cpp_result;
}

QRect QLayoutItemWrapper::geometry() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "geometry"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.geometry()' not implemented.");
        return QRect();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.geometry");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

bool QLayoutItemWrapper::hasHeightForWidth() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasHeightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.hasHeightForWidth");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

int QLayoutItemWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QLayoutItemWrapper::invalidate()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "invalidate"));
    if (py_override.isNull()) {
        return this->QLayoutItem::invalidate();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QLayoutItemWrapper::isEmpty() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isEmpty"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.isEmpty()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.isEmpty");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QLayout * QLayoutItemWrapper::layout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "layout"));
    if (py_override.isNull()) {
        return this->QLayoutItem::layout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayout* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.layout");
        return 0        ;
    }
    QLayout* cpp_result(Shiboken::Converter<QLayout* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QSize QLayoutItemWrapper::maximumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "maximumSize"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.maximumSize()' not implemented.");
        return QSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.maximumSize");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QLayoutItemWrapper::minimumHeightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumHeightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::minimumHeightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.minimumHeightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QLayoutItemWrapper::minimumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSize"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.minimumSize()' not implemented.");
        return QSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.minimumSize");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QLayoutItemWrapper::setGeometry(const QRect & arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.setGeometry()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QRect& >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QLayoutItemWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.sizeHint()' not implemented.");
        return QSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QSpacerItem * QLayoutItemWrapper::spacerItem()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "spacerItem"));
    if (py_override.isNull()) {
        return this->QLayoutItem::spacerItem();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSpacerItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.spacerItem");
        return 0        ;
    }
    QSpacerItem* cpp_result(Shiboken::Converter<QSpacerItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QWidget * QLayoutItemWrapper::widget()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widget"));
    if (py_override.isNull()) {
        return this->QLayoutItem::widget();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QLayoutItem.widget");
        return 0        ;
    }
    QWidget* cpp_result(Shiboken::Converter<QWidget* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QLayoutItemWrapper::~QLayoutItemWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQLayoutItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QLayoutItemWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QLayoutItem' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QLayoutItem", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QLayoutItem(QFlags<Qt::AlignmentFlag>)
        cptr = new QLayoutItemWrapper();
    } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[0])) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[0]);
        // QLayoutItem(QFlags<Qt::AlignmentFlag>)
        cptr = new QLayoutItemWrapper(cpp_arg0);
    } else goto SbkQLayoutItem_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQLayoutItem_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQLayoutItem_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLayoutItem", overloads);
        return -1;
}

static PyObject*
SbkQLayoutItemFunc_alignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alignment()const
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QLayoutItem::alignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLayoutItemFunc_controlTypes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // controlTypes()const
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    QFlags<QSizePolicy::ControlType> cpp_result = cppSelf->QLayoutItem::controlTypes();
    py_result = Shiboken::Converter<QFlags<QSizePolicy::ControlType> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLayoutItemFunc_expandingDirections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // expandingDirections()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.expandingDirections()' not implemented.");
        return 0;
    }
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    QFlags<Qt::Orientation> cpp_result = cppSelf->expandingDirections();
    py_result = Shiboken::Converter<QFlags<Qt::Orientation> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLayoutItemFunc_geometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // geometry()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.geometry()' not implemented.");
        return 0;
    }
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->geometry();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLayoutItemFunc_hasHeightForWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasHeightForWidth()const
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLayoutItem::hasHeightForWidth();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLayoutItemFunc_heightForWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // heightForWidth(int)const
        QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QLayoutItem::heightForWidth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQLayoutItemFunc_heightForWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQLayoutItemFunc_heightForWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayoutItem.heightForWidth", overloads);
        return 0;
}

static PyObject*
SbkQLayoutItemFunc_invalidate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // invalidate()
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    cppSelf->QLayoutItem::invalidate();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQLayoutItemFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.isEmpty()' not implemented.");
        return 0;
    }
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLayoutItemFunc_layout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // layout()
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    QLayout * cpp_result = cppSelf->QLayoutItem::layout();
    py_result = Shiboken::Converter<QLayout* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLayoutItemFunc_maximumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumSize()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.maximumSize()' not implemented.");
        return 0;
    }
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->maximumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLayoutItemFunc_minimumHeightForWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // minimumHeightForWidth(int)const
        QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QLayoutItem::minimumHeightForWidth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQLayoutItemFunc_minimumHeightForWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQLayoutItemFunc_minimumHeightForWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayoutItem.minimumHeightForWidth", overloads);
        return 0;
}

static PyObject*
SbkQLayoutItemFunc_minimumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSize()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.minimumSize()' not implemented.");
        return 0;
    }
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->minimumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLayoutItemFunc_setAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setAlignment(QFlags<Qt::AlignmentFlag>)
        QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
        cppSelf->QLayoutItem::setAlignment(cpp_arg0);
    } else goto SbkQLayoutItemFunc_setAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutItemFunc_setAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayoutItem.setAlignment", overloads);
        return 0;
}

static PyObject*
SbkQLayoutItemFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setGeometry(QRect)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.setGeometry()' not implemented.");
            return 0;
        }
        QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
        cppSelf->setGeometry(*cpp_arg0);
    } else goto SbkQLayoutItemFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutItemFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayoutItem.setGeometry", overloads);
        return 0;
}

static PyObject*
SbkQLayoutItemFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.sizeHint()' not implemented.");
        return 0;
    }
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLayoutItemFunc_spacerItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // spacerItem()
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    QSpacerItem * cpp_result = cppSelf->QLayoutItem::spacerItem();
    py_result = Shiboken::Converter<QSpacerItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQLayoutItemFunc_widget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // widget()
    QLayoutItem* cppSelf = Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QLayoutItem::widget();
    py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQLayoutItem_methods[] = {
    {"alignment", (PyCFunction)SbkQLayoutItemFunc_alignment, METH_NOARGS},
    {"controlTypes", (PyCFunction)SbkQLayoutItemFunc_controlTypes, METH_NOARGS},
    {"expandingDirections", (PyCFunction)SbkQLayoutItemFunc_expandingDirections, METH_NOARGS},
    {"geometry", (PyCFunction)SbkQLayoutItemFunc_geometry, METH_NOARGS},
    {"hasHeightForWidth", (PyCFunction)SbkQLayoutItemFunc_hasHeightForWidth, METH_NOARGS},
    {"heightForWidth", (PyCFunction)SbkQLayoutItemFunc_heightForWidth, METH_O},
    {"invalidate", (PyCFunction)SbkQLayoutItemFunc_invalidate, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQLayoutItemFunc_isEmpty, METH_NOARGS},
    {"layout", (PyCFunction)SbkQLayoutItemFunc_layout, METH_NOARGS},
    {"maximumSize", (PyCFunction)SbkQLayoutItemFunc_maximumSize, METH_NOARGS},
    {"minimumHeightForWidth", (PyCFunction)SbkQLayoutItemFunc_minimumHeightForWidth, METH_O},
    {"minimumSize", (PyCFunction)SbkQLayoutItemFunc_minimumSize, METH_NOARGS},
    {"setAlignment", (PyCFunction)SbkQLayoutItemFunc_setAlignment, METH_O},
    {"setGeometry", (PyCFunction)SbkQLayoutItemFunc_setGeometry, METH_O},
    {"sizeHint", (PyCFunction)SbkQLayoutItemFunc_sizeHint, METH_NOARGS},
    {"spacerItem", (PyCFunction)SbkQLayoutItemFunc_spacerItem, METH_NOARGS},
    {"widget", (PyCFunction)SbkQLayoutItemFunc_widget, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQLayoutItem_get_align(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self)->align);
}
static int SbkQLayoutItem_set_align(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'align' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtCore_Qt_AlignmentFlag_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'align', 'Alignment' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QLayoutItem* >::toCpp((PyObject*)self)->align = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(value);

    return 0;
}

// Getters and Setters for QLayoutItem
static PyGetSetDef SbkQLayoutItem_getsetlist[] = {
    {const_cast<char*>("align"), (getter)SbkQLayoutItem_get_align, (setter)SbkQLayoutItem_set_align},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQLayoutItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QLayoutItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QLayoutItemWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQLayoutItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQLayoutItem_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQLayoutItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQLayoutItem_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQLayoutItem_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QLayoutItem*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QLayoutItem(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQLayoutItem_Type);

    // Fill type discovery information
    SbkQLayoutItem_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQLayoutItem_Type.type_discovery->addTypeDiscoveryFunction(&SbkQLayoutItem_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQLayoutItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQLayoutItem_Type));
    PyModule_AddObject(module, "QLayoutItem",
        ((PyObject*)&SbkQLayoutItem_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QLayoutItem >("QLayoutItem*");
    Shiboken::TypeResolver::createObjectTypeResolver<QLayoutItem >(typeid(QLayoutItem).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

