/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qitemselectionrange_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemmodel.h>
#include <qitemselectionmodel.h>

using namespace Shiboken;

static int
SbkQItemSelectionRange_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QItemSelectionRange* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QItemSelectionRange", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QItemSelectionRange()
        cptr = new QItemSelectionRange();
    } else if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QItemSelectionRange(QModelIndex)
            cptr = new QItemSelectionRange(*cpp_arg0);
        } else if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
            // QItemSelectionRange(QModelIndex,QModelIndex)
            cptr = new QItemSelectionRange(*cpp_arg0, *cpp_arg1);
        } else goto SbkQItemSelectionRange_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QItemSelectionRange& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(pyargs[0]);
        // QItemSelectionRange(QItemSelectionRange)
        cptr = new QItemSelectionRange(*cpp_arg0);
    } else goto SbkQItemSelectionRange_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQItemSelectionRange_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQItemSelectionRange_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QItemSelectionRange", "PySide.QtCore.QModelIndex", "PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelectionRange", overloads);
        return -1;
}

static PyObject*
SbkQItemSelectionRangeFunc_bottom(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottom()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QItemSelectionRange::bottom();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionRangeFunc_bottomRight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottomRight()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    QModelIndex cpp_result = cppSelf->QItemSelectionRange::bottomRight();
    py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionRangeFunc_contains(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQItemSelectionRangeFunc_contains_TypeError;

    if (!PyArg_UnpackTuple(args, "contains", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // contains(int,int,QModelIndex)const
        QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelectionRange::contains(cpp_arg0, cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (numArgs == 1 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        // contains(QModelIndex)const
        QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelectionRange::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQItemSelectionRangeFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQItemSelectionRangeFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", "int, int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelectionRange.contains", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionRangeFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QItemSelectionRange::height();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionRangeFunc_indexes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // indexes()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    QList<QModelIndex > cpp_result = cppSelf->QItemSelectionRange::indexes();
    py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionRangeFunc_intersected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelectionRange& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(arg);
        // intersected(QItemSelectionRange)const
        QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
        QItemSelectionRange cpp_result = cppSelf->QItemSelectionRange::intersected(*cpp_arg0);
        py_result = Shiboken::Converter<QItemSelectionRange >::toPython(cpp_result);
    } else goto SbkQItemSelectionRangeFunc_intersected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQItemSelectionRangeFunc_intersected_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelectionRange.intersected", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionRangeFunc_intersects(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelectionRange& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(arg);
        // intersects(QItemSelectionRange)const
        QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelectionRange::intersects(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQItemSelectionRangeFunc_intersects_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQItemSelectionRangeFunc_intersects_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelectionRange.intersects", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionRangeFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QItemSelectionRange::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionRangeFunc_left(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // left()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QItemSelectionRange::left();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionRangeFunc_model(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // model()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    const QAbstractItemModel * cpp_result = cppSelf->QItemSelectionRange::model();
    py_result = Shiboken::Converter<QAbstractItemModel* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionRangeFunc_parent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parent()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    QModelIndex cpp_result = cppSelf->QItemSelectionRange::parent();
    py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionRangeFunc_right(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // right()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QItemSelectionRange::right();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionRangeFunc_top(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // top()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QItemSelectionRange::top();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionRangeFunc_topLeft(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // topLeft()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    QModelIndex cpp_result = cppSelf->QItemSelectionRange::topLeft();
    py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionRangeFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QItemSelectionRange* cppSelf = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QItemSelectionRange::width();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQItemSelectionRange_methods[] = {
    {"bottom", (PyCFunction)SbkQItemSelectionRangeFunc_bottom, METH_NOARGS},
    {"bottomRight", (PyCFunction)SbkQItemSelectionRangeFunc_bottomRight, METH_NOARGS},
    {"contains", (PyCFunction)SbkQItemSelectionRangeFunc_contains, METH_VARARGS},
    {"height", (PyCFunction)SbkQItemSelectionRangeFunc_height, METH_NOARGS},
    {"indexes", (PyCFunction)SbkQItemSelectionRangeFunc_indexes, METH_NOARGS},
    {"intersected", (PyCFunction)SbkQItemSelectionRangeFunc_intersected, METH_O},
    {"intersects", (PyCFunction)SbkQItemSelectionRangeFunc_intersects, METH_O},
    {"isValid", (PyCFunction)SbkQItemSelectionRangeFunc_isValid, METH_NOARGS},
    {"left", (PyCFunction)SbkQItemSelectionRangeFunc_left, METH_NOARGS},
    {"model", (PyCFunction)SbkQItemSelectionRangeFunc_model, METH_NOARGS},
    {"parent", (PyCFunction)SbkQItemSelectionRangeFunc_parent, METH_NOARGS},
    {"right", (PyCFunction)SbkQItemSelectionRangeFunc_right, METH_NOARGS},
    {"top", (PyCFunction)SbkQItemSelectionRangeFunc_top, METH_NOARGS},
    {"topLeft", (PyCFunction)SbkQItemSelectionRangeFunc_topLeft, METH_NOARGS},
    {"width", (PyCFunction)SbkQItemSelectionRangeFunc_width, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQItemSelectionRange_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QItemSelectionRange& cpp_self = *Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QItemSelectionRange& >::isConvertible(other)) {
                QItemSelectionRange* cpp_other = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQItemSelectionRange_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QItemSelectionRange& >::isConvertible(other)) {
                QItemSelectionRange* cpp_other = Shiboken::Converter<QItemSelectionRange* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQItemSelectionRange_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQItemSelectionRange_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

static long SbkQItemSelectionRange_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QItemSelectionRange >::toCpp(obj));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQItemSelectionRange_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QItemSelectionRange",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QItemSelectionRange >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQItemSelectionRange_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQItemSelectionRange_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQItemSelectionRange_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQItemSelectionRange_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QItemSelectionRange(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QITEMSELECTIONRANGE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQItemSelectionRange_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQItemSelectionRange_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQItemSelectionRange_Type));
    PyModule_AddObject(module, "QItemSelectionRange",
        ((PyObject*)&SbkQItemSelectionRange_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QItemSelectionRange >("QItemSelectionRange");
    Shiboken::TypeResolver::createValueTypeResolver<QItemSelectionRange >(typeid(QItemSelectionRange).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

