/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qitemselectionmodel_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qitemselectionmodel.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QItemSelectionModelWrapper::QItemSelectionModelWrapper(QAbstractItemModel * model) : QItemSelectionModel(model), m_metaObject(0) {
    // ... middle
}

QItemSelectionModelWrapper::QItemSelectionModelWrapper(QAbstractItemModel * model, QObject * parent) : QItemSelectionModel(model, parent), m_metaObject(0) {
    // ... middle
}

void QItemSelectionModelWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QItemSelectionModelWrapper::clear()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "clear"));
    if (py_override.isNull()) {
        return this->QItemSelectionModel::clear();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QItemSelectionModelWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QItemSelectionModelWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QItemSelectionModelWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QItemSelectionModelWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QItemSelectionModel.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QItemSelectionModelWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QItemSelectionModel.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QItemSelectionModelWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QItemSelectionModel::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QItemSelectionModelWrapper::select(const QItemSelection & selection, QFlags<QItemSelectionModel::SelectionFlag> command)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "select"));
    if (py_override.isNull()) {
        return this->QItemSelectionModel::select(selection, command);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QItemSelection& >::toPython(selection),
        Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toPython(command)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QItemSelectionModelWrapper::select(const QModelIndex & index, QFlags<QItemSelectionModel::SelectionFlag> command)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "select"));
    if (py_override.isNull()) {
        return this->QItemSelectionModel::select(index, command);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toPython(command)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QItemSelectionModelWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QItemSelectionModelWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QItemSelectionModel::staticMetaObject);
}
    return m_metaObject;
}

int QItemSelectionModelWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QItemSelectionModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QItemSelectionModelWrapper::~QItemSelectionModelWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQItemSelectionModel_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QItemSelectionModelWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QItemSelectionModel", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (Shiboken::Converter<QAbstractItemModel* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAbstractItemModel* cpp_arg0 = Shiboken::Converter<QAbstractItemModel* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QItemSelectionModel(QAbstractItemModel*)
            cptr = new QItemSelectionModelWrapper(cpp_arg0);
        } else if (numArgs == 2 && Shiboken::Converter<QObject* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QItemSelectionModel(QAbstractItemModel*,QObject*)
            cptr = new QItemSelectionModelWrapper(cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQItemSelectionModel_Init_TypeError;
    } else goto SbkQItemSelectionModel_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQItemSelectionModel_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQItemSelectionModel_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractItemModel", "PySide.QtCore.QAbstractItemModel, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelectionModel", overloads);
        return -1;
}

static PyObject*
SbkQItemSelectionModelFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
    cppSelf->QItemSelectionModel::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQItemSelectionModelFunc_clearSelection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearSelection()
    QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
    cppSelf->QItemSelectionModel::clearSelection();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQItemSelectionModelFunc_columnIntersectsSelection(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "columnIntersectsSelection", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // columnIntersectsSelection(int,QModelIndex)const
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelectionModel::columnIntersectsSelection(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQItemSelectionModelFunc_columnIntersectsSelection_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQItemSelectionModelFunc_columnIntersectsSelection_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelectionModel.columnIntersectsSelection", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionModelFunc_currentIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentIndex()const
    QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
    QModelIndex cpp_result = cppSelf->QItemSelectionModel::currentIndex();
    py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionModelFunc_emitSelectionChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "emitSelectionChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QItemSelection& >::isConvertible(pyargs[0]) && Shiboken::Converter<QItemSelection& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QItemSelection* cpp_arg1 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[1]);
        // emitSelectionChanged(QItemSelection,QItemSelection)
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        cppSelf->QItemSelectionModel::emitSelectionChanged(*cpp_arg0, *cpp_arg1);
    } else goto SbkQItemSelectionModelFunc_emitSelectionChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionModelFunc_emitSelectionChanged_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection, PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelectionModel.emitSelectionChanged", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionModelFunc_hasSelection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasSelection()const
    QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QItemSelectionModel::hasSelection();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionModelFunc_isColumnSelected(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isColumnSelected", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // isColumnSelected(int,QModelIndex)const
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelectionModel::isColumnSelected(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQItemSelectionModelFunc_isColumnSelected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQItemSelectionModelFunc_isColumnSelected_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelectionModel.isColumnSelected", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionModelFunc_isRowSelected(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isRowSelected", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // isRowSelected(int,QModelIndex)const
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelectionModel::isRowSelected(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQItemSelectionModelFunc_isRowSelected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQItemSelectionModelFunc_isRowSelected_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelectionModel.isRowSelected", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionModelFunc_isSelected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // isSelected(QModelIndex)const
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelectionModel::isSelected(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQItemSelectionModelFunc_isSelected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQItemSelectionModelFunc_isSelected_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelectionModel.isSelected", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionModelFunc_model(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // model()const
    QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
    const QAbstractItemModel * cpp_result = cppSelf->QItemSelectionModel::model();
    py_result = Shiboken::Converter<QAbstractItemModel* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionModelFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
    cppSelf->QItemSelectionModel::reset();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQItemSelectionModelFunc_rowIntersectsSelection(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "rowIntersectsSelection", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // rowIntersectsSelection(int,QModelIndex)const
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelectionModel::rowIntersectsSelection(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQItemSelectionModelFunc_rowIntersectsSelection_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQItemSelectionModelFunc_rowIntersectsSelection_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelectionModel.rowIntersectsSelection", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionModelFunc_select(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "select", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        QFlags<QItemSelectionModel::SelectionFlag> cpp_arg1 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[1]);
        // select(QModelIndex,QFlags<QItemSelectionModel::SelectionFlag>)
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        cppSelf->QItemSelectionModel::select(*cpp_arg0, cpp_arg1);
    } else if (numArgs == 2 && Shiboken::Converter<QItemSelection& >::isConvertible(pyargs[0]) && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[0]);
        QFlags<QItemSelectionModel::SelectionFlag> cpp_arg1 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[1]);
        // select(QItemSelection,QFlags<QItemSelectionModel::SelectionFlag>)
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        cppSelf->QItemSelectionModel::select(*cpp_arg0, cpp_arg1);
    } else goto SbkQItemSelectionModelFunc_select_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionModelFunc_select_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection, PySide.QtGui.QItemSelectionModel.SelectionFlags", "PySide.QtCore.QModelIndex, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelectionModel.select", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionModelFunc_selectedColumns(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // selectedColumns(int)const
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        QList<QModelIndex > cpp_result = cppSelf->QItemSelectionModel::selectedColumns();
        py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // selectedColumns(int)const
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        QList<QModelIndex > cpp_result = cppSelf->QItemSelectionModel::selectedColumns(cpp_arg0);
        py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
    } else goto SbkQItemSelectionModelFunc_selectedColumns_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQItemSelectionModelFunc_selectedColumns_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelectionModel.selectedColumns", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionModelFunc_selectedIndexes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedIndexes()const
    QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
    QList<QModelIndex > cpp_result = cppSelf->QItemSelectionModel::selectedIndexes();
    py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionModelFunc_selectedRows(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // selectedRows(int)const
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        QList<QModelIndex > cpp_result = cppSelf->QItemSelectionModel::selectedRows();
        py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // selectedRows(int)const
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        QList<QModelIndex > cpp_result = cppSelf->QItemSelectionModel::selectedRows(cpp_arg0);
        py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
    } else goto SbkQItemSelectionModelFunc_selectedRows_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQItemSelectionModelFunc_selectedRows_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelectionModel.selectedRows", overloads);
        return 0;
}

static PyObject*
SbkQItemSelectionModelFunc_selection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selection()const
    QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
    const QItemSelection cpp_result = cppSelf->QItemSelectionModel::selection();
    py_result = Shiboken::Converter<QItemSelection >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQItemSelectionModelFunc_setCurrentIndex(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setCurrentIndex", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        QFlags<QItemSelectionModel::SelectionFlag> cpp_arg1 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[1]);
        // setCurrentIndex(QModelIndex,QFlags<QItemSelectionModel::SelectionFlag>)
        QItemSelectionModel* cppSelf = Shiboken::Converter<QItemSelectionModel* >::toCpp((PyObject*)self);
        cppSelf->QItemSelectionModel::setCurrentIndex(*cpp_arg0, cpp_arg1);
    } else goto SbkQItemSelectionModelFunc_setCurrentIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionModelFunc_setCurrentIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelectionModel.setCurrentIndex", overloads);
        return 0;
}

static PyMethodDef SbkQItemSelectionModel_methods[] = {
    {"clear", (PyCFunction)SbkQItemSelectionModelFunc_clear, METH_NOARGS},
    {"clearSelection", (PyCFunction)SbkQItemSelectionModelFunc_clearSelection, METH_NOARGS},
    {"columnIntersectsSelection", (PyCFunction)SbkQItemSelectionModelFunc_columnIntersectsSelection, METH_VARARGS},
    {"currentIndex", (PyCFunction)SbkQItemSelectionModelFunc_currentIndex, METH_NOARGS},
    {"emitSelectionChanged", (PyCFunction)SbkQItemSelectionModelFunc_emitSelectionChanged, METH_VARARGS},
    {"hasSelection", (PyCFunction)SbkQItemSelectionModelFunc_hasSelection, METH_NOARGS},
    {"isColumnSelected", (PyCFunction)SbkQItemSelectionModelFunc_isColumnSelected, METH_VARARGS},
    {"isRowSelected", (PyCFunction)SbkQItemSelectionModelFunc_isRowSelected, METH_VARARGS},
    {"isSelected", (PyCFunction)SbkQItemSelectionModelFunc_isSelected, METH_O},
    {"model", (PyCFunction)SbkQItemSelectionModelFunc_model, METH_NOARGS},
    {"reset", (PyCFunction)SbkQItemSelectionModelFunc_reset, METH_NOARGS},
    {"rowIntersectsSelection", (PyCFunction)SbkQItemSelectionModelFunc_rowIntersectsSelection, METH_VARARGS},
    {"select", (PyCFunction)SbkQItemSelectionModelFunc_select, METH_VARARGS},
    {"selectedColumns", (PyCFunction)SbkQItemSelectionModelFunc_selectedColumns, METH_NOARGS|METH_O},
    {"selectedIndexes", (PyCFunction)SbkQItemSelectionModelFunc_selectedIndexes, METH_NOARGS},
    {"selectedRows", (PyCFunction)SbkQItemSelectionModelFunc_selectedRows, METH_NOARGS|METH_O},
    {"selection", (PyCFunction)SbkQItemSelectionModelFunc_selection, METH_NOARGS},
    {"setCurrentIndex", (PyCFunction)SbkQItemSelectionModelFunc_setCurrentIndex, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQItemSelectionModel_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QItemSelectionModel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QItemSelectionModelWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQItemSelectionModel_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQItemSelectionModel_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

PyObject*
SbkPySide_QtGui_QItemSelectionModel_SelectionFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QItemSelectionModel::SelectionFlags >::toPython(
        ((QItemSelectionModel::SelectionFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QItemSelectionModel::SelectionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QItemSelectionModel_SelectionFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QItemSelectionModel::SelectionFlags >::toPython(
        ((QItemSelectionModel::SelectionFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QItemSelectionModel::SelectionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QItemSelectionModel_SelectionFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QItemSelectionModel::SelectionFlags >::toPython(
        ((QItemSelectionModel::SelectionFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QItemSelectionModel::SelectionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QItemSelectionModel_SelectionFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QItemSelectionModel::SelectionFlags >::toPython(
        ~ Shiboken::Converter< QItemSelectionModel::SelectionFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QItemSelectionModel_SelectionFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QItemSelectionModel_SelectionFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QItemSelectionModel_SelectionFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QItemSelectionModel_SelectionFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SelectionFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QItemSelectionModel_SelectionFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QItemSelectionModel_SelectionFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SelectionFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QItemSelectionModel_SelectionFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QItemSelectionModel_SelectionFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QItemSelectionModel_SelectionFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void)
init_QItemSelectionModel(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QITEMSELECTIONMODEL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQItemSelectionModel_Type);

    SbkQItemSelectionModel_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQItemSelectionModel_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQItemSelectionModel_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQItemSelectionModel_Type));
    PyModule_AddObject(module, "QItemSelectionModel",
        ((PyObject*)&SbkQItemSelectionModel_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SelectionFlag
    SbkPySide_QtGuiTypes[SBK_QITEMSELECTIONMODEL_SELECTIONFLAG_IDX] = &SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type);
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
            "SelectionFlag",((PyObject*)&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type));

    // init flags class: QFlags<QItemSelectionModel::SelectionFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QITEMSELECTIONMODEL_SELECTIONFLAG__IDX] = &SbkPySide_QtGui_QItemSelectionModel_SelectionFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QItemSelectionModel_SelectionFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlags_Type);
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
            "SelectionFlags",((PyObject*)&SbkPySide_QtGui_QItemSelectionModel_SelectionFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
        (long) QItemSelectionModel::NoUpdate, "NoUpdate");
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
        "NoUpdate", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type.tp_dict,
        "NoUpdate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
        (long) QItemSelectionModel::Clear, "Clear");
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
        "Clear", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type.tp_dict,
        "Clear", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
        (long) QItemSelectionModel::Select, "Select");
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
        "Select", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type.tp_dict,
        "Select", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
        (long) QItemSelectionModel::Deselect, "Deselect");
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
        "Deselect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type.tp_dict,
        "Deselect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
        (long) QItemSelectionModel::Toggle, "Toggle");
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
        "Toggle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type.tp_dict,
        "Toggle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
        (long) QItemSelectionModel::Current, "Current");
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
        "Current", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type.tp_dict,
        "Current", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
        (long) QItemSelectionModel::Rows, "Rows");
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
        "Rows", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type.tp_dict,
        "Rows", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
        (long) QItemSelectionModel::Columns, "Columns");
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
        "Columns", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type.tp_dict,
        "Columns", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
        (long) QItemSelectionModel::SelectCurrent, "SelectCurrent");
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
        "SelectCurrent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type.tp_dict,
        "SelectCurrent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
        (long) QItemSelectionModel::ToggleCurrent, "ToggleCurrent");
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
        "ToggleCurrent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type.tp_dict,
        "ToggleCurrent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type,
        (long) QItemSelectionModel::ClearAndSelect, "ClearAndSelect");
    PyDict_SetItemString(SbkQItemSelectionModel_Type.super.ht_type.tp_dict,
        "ClearAndSelect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Type.tp_dict,
        "ClearAndSelect", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QItemSelectionModel::SelectionFlag");

    Shiboken::TypeResolver::createObjectTypeResolver<QItemSelectionModel >("QItemSelectionModel*");
    Shiboken::TypeResolver::createObjectTypeResolver<QItemSelectionModel >(typeid(QItemSelectionModel).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

