/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qiconengine_wrapper.h"

// Extra includes
#include <qpainter.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QIconEngineWrapper::QIconEngineWrapper() : QIconEngine() {
    // ... middle
}

QSize QIconEngineWrapper::actualSize(const QSize & size, QIcon::Mode mode, QIcon::State state)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actualSize"));
    if (py_override.isNull()) {
        return this->QIconEngine::actualSize(size, mode, state);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QSize& >::toPython(size),
        Shiboken::Converter<QIcon::Mode >::toPython(mode),
        Shiboken::Converter<QIcon::State >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIconEngine.actualSize");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QIconEngineWrapper::addFile(const QString & fileName, const QSize & size, QIcon::Mode mode, QIcon::State state)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "addFile"));
    if (py_override.isNull()) {
        return this->QIconEngine::addFile(fileName, size, mode, state);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QString& >::toPython(fileName),
        Shiboken::Converter<QSize& >::toPython(size),
        Shiboken::Converter<QIcon::Mode >::toPython(mode),
        Shiboken::Converter<QIcon::State >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QIconEngineWrapper::addPixmap(const QPixmap & pixmap, QIcon::Mode mode, QIcon::State state)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "addPixmap"));
    if (py_override.isNull()) {
        return this->QIconEngine::addPixmap(pixmap, mode, state);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QPixmap& >::toPython(pixmap),
        Shiboken::Converter<QIcon::Mode >::toPython(mode),
        Shiboken::Converter<QIcon::State >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QIconEngineWrapper::paint(QPainter * painter, const QRect & rect, QIcon::Mode mode, QIcon::State state)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paint"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIconEngine.paint()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRect& >::toPython(rect),
        Shiboken::Converter<QIcon::Mode >::toPython(mode),
        Shiboken::Converter<QIcon::State >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPixmap QIconEngineWrapper::pixmap(const QSize & size, QIcon::Mode mode, QIcon::State state)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pixmap"));
    if (py_override.isNull()) {
        return this->QIconEngine::pixmap(size, mode, state);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QSize& >::toPython(size),
        Shiboken::Converter<QIcon::Mode >::toPython(mode),
        Shiboken::Converter<QIcon::State >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPixmap();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPixmap >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QIconEngine.pixmap");
        return QPixmap()        ;
    }
    QPixmap cpp_result(Shiboken::Converter<QPixmap >::toCpp(py_result));
    return cpp_result;
}

QIconEngineWrapper::~QIconEngineWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQIconEngine_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QIconEngineWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QICONENGINE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QIconEngine' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QIconEngine()
    cptr = new QIconEngineWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQIconEngineFunc_actualSize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "actualSize", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QSize& >::isConvertible(pyargs[0]) && Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[1]) && Shiboken::Converter<QIcon::State >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        QIcon::Mode cpp_arg1 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[1]);
        QIcon::State cpp_arg2 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[2]);
        // actualSize(QSize,QIcon::Mode,QIcon::State)
        QIconEngine* cppSelf = Shiboken::Converter<QIconEngine* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QIconEngine::actualSize(*cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    } else goto SbkQIconEngineFunc_actualSize_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIconEngineFunc_actualSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize, PySide.QtGui.QIcon.Mode, PySide.QtGui.QIcon.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIconEngine.actualSize", overloads);
        return 0;
}

static PyObject*
SbkQIconEngineFunc_addFile(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addFile", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QSize& >::isConvertible(pyargs[1]) && Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[2]) && Shiboken::Converter<QIcon::State >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QSize* cpp_arg1 = Shiboken::Converter<QSize* >::toCpp(pyargs[1]);
        QIcon::Mode cpp_arg2 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[2]);
        QIcon::State cpp_arg3 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[3]);
        // addFile(QString,QSize,QIcon::Mode,QIcon::State)
        QIconEngine* cppSelf = Shiboken::Converter<QIconEngine* >::toCpp((PyObject*)self);
        cppSelf->QIconEngine::addFile(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
    } else goto SbkQIconEngineFunc_addFile_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIconEngineFunc_addFile_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QSize, PySide.QtGui.QIcon.Mode, PySide.QtGui.QIcon.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIconEngine.addFile", overloads);
        return 0;
}

static PyObject*
SbkQIconEngineFunc_addPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addPixmap", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0]) && Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[1]) && Shiboken::Converter<QIcon::State >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        QIcon::Mode cpp_arg1 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[1]);
        QIcon::State cpp_arg2 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[2]);
        // addPixmap(QPixmap,QIcon::Mode,QIcon::State)
        QIconEngine* cppSelf = Shiboken::Converter<QIconEngine* >::toCpp((PyObject*)self);
        cppSelf->QIconEngine::addPixmap(*cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQIconEngineFunc_addPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIconEngineFunc_addPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPixmap, PySide.QtGui.QIcon.Mode, PySide.QtGui.QIcon.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIconEngine.addPixmap", overloads);
        return 0;
}

static PyObject*
SbkQIconEngineFunc_paint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "paint", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect& >::isConvertible(pyargs[1]) && Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[2]) && Shiboken::Converter<QIcon::State >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        QIcon::Mode cpp_arg2 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[2]);
        QIcon::State cpp_arg3 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[3]);
        // paint(QPainter*,QRect,QIcon::Mode,QIcon::State)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QIconEngine.paint()' not implemented.");
            return 0;
        }
        QIconEngine* cppSelf = Shiboken::Converter<QIconEngine* >::toCpp((PyObject*)self);
        cppSelf->paint(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
    } else goto SbkQIconEngineFunc_paint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIconEngineFunc_paint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, PySide.QtGui.QIcon.Mode, PySide.QtGui.QIcon.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIconEngine.paint", overloads);
        return 0;
}

static PyObject*
SbkQIconEngineFunc_pixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "pixmap", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QSize& >::isConvertible(pyargs[0]) && Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[1]) && Shiboken::Converter<QIcon::State >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        QIcon::Mode cpp_arg1 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[1]);
        QIcon::State cpp_arg2 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[2]);
        // pixmap(QSize,QIcon::Mode,QIcon::State)
        QIconEngine* cppSelf = Shiboken::Converter<QIconEngine* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QIconEngine::pixmap(*cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    } else goto SbkQIconEngineFunc_pixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQIconEngineFunc_pixmap_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize, PySide.QtGui.QIcon.Mode, PySide.QtGui.QIcon.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIconEngine.pixmap", overloads);
        return 0;
}

static PyMethodDef SbkQIconEngine_methods[] = {
    {"actualSize", (PyCFunction)SbkQIconEngineFunc_actualSize, METH_VARARGS},
    {"addFile", (PyCFunction)SbkQIconEngineFunc_addFile, METH_VARARGS},
    {"addPixmap", (PyCFunction)SbkQIconEngineFunc_addPixmap, METH_VARARGS},
    {"paint", (PyCFunction)SbkQIconEngineFunc_paint, METH_VARARGS},
    {"pixmap", (PyCFunction)SbkQIconEngineFunc_pixmap, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQIconEngine_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QIconEngine",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QIconEngineWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQIconEngine_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQIconEngine_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQIconEngine_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQIconEngine_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QIconEngine*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QIconEngine(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QICONENGINE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQIconEngine_Type);

    // Fill type discovery information
    SbkQIconEngine_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQIconEngine_Type.type_discovery->addTypeDiscoveryFunction(&SbkQIconEngine_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQIconEngine_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQIconEngine_Type));
    PyModule_AddObject(module, "QIconEngine",
        ((PyObject*)&SbkQIconEngine_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QIconEngine >("QIconEngine*");
    Shiboken::TypeResolver::createObjectTypeResolver<QIconEngine >(typeid(QIconEngine).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

