/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qheaderview_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemdelegate.h>
#include <qabstractitemmodel.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qheaderview.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qitemselectionmodel.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QHeaderViewWrapper::QHeaderViewWrapper(Qt::Orientation orientation, QWidget * parent) : QHeaderView(orientation, parent), m_metaObject(0) {
    // ... middle
}

void QHeaderViewWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QHeaderViewWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QFrame::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::closeEditor(QWidget * editor, QAbstractItemDelegate::EndEditHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEditor"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::closeEditor(editor, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QWidget* >::toPython(editor),
        Shiboken::Converter<QAbstractItemDelegate::EndEditHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QHeaderViewWrapper::commitData(QWidget * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "commitData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::commitData(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::currentChanged(const QModelIndex & current, const QModelIndex & old)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "currentChanged"));
    if (py_override.isNull()) {
        return this->QHeaderView::currentChanged(current, old);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(current),
        Shiboken::Converter<QModelIndex& >::toPython(old)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::dataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dataChanged"));
    if (py_override.isNull()) {
        return this->QHeaderView::dataChanged(topLeft, bottomRight);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(topLeft),
        Shiboken::Converter<QModelIndex& >::toPython(bottomRight)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QHeaderViewWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::doItemsLayout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "doItemsLayout"));
    if (py_override.isNull()) {
        return this->QHeaderView::doItemsLayout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::dragEnterEvent(QDragEnterEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::dragLeaveEvent(QDragLeaveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::dragMoveEvent(QDragMoveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::dropEvent(QDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dropEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QHeaderViewWrapper::edit(const QModelIndex & index, QAbstractItemView::EditTrigger trigger, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "edit"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::edit(index, trigger, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QAbstractItemView::EditTrigger >::toPython(trigger),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.edit");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 2));
    return cpp_result;
}

void QHeaderViewWrapper::editorDestroyed(QObject * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "editorDestroyed"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::editorDestroyed(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QObject* >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QHeaderViewWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QHeaderView::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QHeaderViewWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QHeaderViewWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QHeaderViewWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QHeaderViewWrapper::horizontalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalOffset"));
    if (py_override.isNull()) {
        return this->QHeaderView::horizontalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.horizontalOffset");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::horizontalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::horizontalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::horizontalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::horizontalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QModelIndex QHeaderViewWrapper::indexAt(const QPoint & p) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexAt"));
    if (py_override.isNull()) {
        return this->QHeaderView::indexAt(p);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPoint& >::toPython(p)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.indexAt");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::inputMethodEvent(QInputMethodEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QHeaderViewWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QHeaderViewWrapper::isIndexHidden(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isIndexHidden"));
    if (py_override.isNull()) {
        return this->QHeaderView::isIndexHidden(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.isIndexHidden");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QHeaderViewWrapper::keyboardSearch(const QString & search)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyboardSearch"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::keyboardSearch(search);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(search)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QHeaderViewWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QHeaderViewWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::mouseDoubleClickEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QHeaderView::mouseDoubleClickEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::mouseMoveEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QHeaderView::mouseMoveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::mousePressEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QHeaderView::mousePressEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::mouseReleaseEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QHeaderView::mouseReleaseEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QHeaderViewWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QHeaderViewWrapper::paintEvent(QPaintEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QHeaderView::paintEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::paintSection(QPainter * painter, const QRect & rect, int logicalIndex) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintSection"));
    if (py_override.isNull()) {
        return this->QHeaderView::paintSection(painter, rect, logicalIndex);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOi)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRect& >::toPython(rect),
        logicalIndex
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QHeaderViewWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QHeaderView::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::resizeEvent(QResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::rowsAboutToBeRemoved(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsAboutToBeRemoved"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::rowsAboutToBeRemoved(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oii)",
        Shiboken::Converter<QModelIndex& >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::rowsInserted(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsInserted"));
    if (py_override.isNull()) {
        return this->QHeaderView::rowsInserted(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oii)",
        Shiboken::Converter<QModelIndex& >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QHeaderView::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::scrollTo(const QModelIndex & index, QAbstractItemView::ScrollHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollTo"));
    if (py_override.isNull()) {
        return this->QHeaderView::scrollTo(index, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QAbstractItemView::ScrollHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QHeaderViewWrapper::sectionSizeFromContents(int logicalIndex) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sectionSizeFromContents"));
    if (py_override.isNull()) {
        return this->QHeaderView::sectionSizeFromContents(logicalIndex);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        logicalIndex
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.sectionSizeFromContents");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::selectAll()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectAll"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectAll();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QList<QModelIndex > QHeaderViewWrapper::selectedIndexes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectedIndexes"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectedIndexes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.selectedIndexes");
        return QList<QModelIndex >()        ;
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::selectionChanged(const QItemSelection & selected, const QItemSelection & deselected)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectionChanged(selected, deselected);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QItemSelection& >::toPython(selected),
        Shiboken::Converter<QItemSelection& >::toPython(deselected)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<QItemSelectionModel::SelectionFlag> QHeaderViewWrapper::selectionCommand(const QModelIndex & index, const QEvent * event) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionCommand"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectionCommand(index, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<QItemSelectionModel::SelectionFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.selectionCommand");
        return QFlags<QItemSelectionModel::SelectionFlag>()        ;
    }
    QFlags<QItemSelectionModel::SelectionFlag> cpp_result(Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QHeaderViewWrapper::setModel(QAbstractItemModel * model)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setModel"));
    if (py_override.isNull()) {
        return this->QHeaderView::setModel(model);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QAbstractItemModel* >::toPython(model)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::setRootIndex(const QModelIndex & index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setRootIndex"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::setRootIndex(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::setSelection(const QRect & rect, QFlags<QItemSelectionModel::SelectionFlag> flags)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelection"));
    if (py_override.isNull()) {
        return this->QHeaderView::setSelection(rect, flags);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QRect& >::toPython(rect),
        Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::setSelectionModel(QItemSelectionModel * selectionModel)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelectionModel"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::setSelectionModel(selectionModel);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelectionModel* >::toPython(selectionModel)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QHeaderViewWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QHeaderView::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QHeaderViewWrapper::sizeHintForColumn(int column) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForColumn"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::sizeHintForColumn(column);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        column
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.sizeHintForColumn");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QHeaderViewWrapper::sizeHintForRow(int row) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForRow"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::sizeHintForRow(row);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        row
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.sizeHintForRow");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::startDrag(QFlags<Qt::DropAction> supportedActions)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDrag"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::startDrag(supportedActions);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(supportedActions)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QHeaderViewWrapper::timerEvent(QTimerEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::timerEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::updateEditorData()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorData();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::updateEditorGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorGeometries"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::updateGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometries"));
    if (py_override.isNull()) {
        return this->QHeaderView::updateGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QHeaderViewWrapper::verticalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalOffset"));
    if (py_override.isNull()) {
        return this->QHeaderView::verticalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.verticalOffset");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::verticalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QHeaderViewWrapper::verticalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QStyleOptionViewItem QHeaderViewWrapper::viewOptions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewOptions"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::viewOptions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStyleOptionViewItem();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStyleOptionViewItem >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.viewOptions");
        return QStyleOptionViewItem()        ;
    }
    QStyleOptionViewItem cpp_result(Shiboken::Converter<QStyleOptionViewItem >::toCpp(py_result));
    return cpp_result;
}

bool QHeaderViewWrapper::viewportEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QHeaderView::viewportEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.viewportEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QRect QHeaderViewWrapper::visualRect(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRect"));
    if (py_override.isNull()) {
        return this->QHeaderView::visualRect(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.visualRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

QRegion QHeaderViewWrapper::visualRegionForSelection(const QItemSelection & selection) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRegionForSelection"));
    if (py_override.isNull()) {
        return this->QHeaderView::visualRegionForSelection(selection);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelection& >::toPython(selection)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRegion();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRegion >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QHeaderView.visualRegionForSelection");
        return QRegion()        ;
    }
    QRegion cpp_result(Shiboken::Converter<QRegion >::toCpp(py_result));
    return cpp_result;
}

void QHeaderViewWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QHeaderViewWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QHeaderView::staticMetaObject);
}
    return m_metaObject;
}

int QHeaderViewWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QHeaderView::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QHeaderViewWrapper::~QHeaderViewWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQHeaderView_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QHeaderViewWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QHeaderView", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[0])) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QHeaderView(Qt::Orientation,QWidget*)
            cptr = new QHeaderViewWrapper(cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // QHeaderView(Qt::Orientation,QWidget*)
            cptr = new QHeaderViewWrapper(cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQHeaderView_Init_TypeError;
    } else goto SbkQHeaderView_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQHeaderView_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQHeaderView_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView", overloads);
        return -1;
}

static PyObject*
SbkQHeaderViewFunc_cascadingSectionResizes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cascadingSectionResizes()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHeaderView::cascadingSectionResizes();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHeaderView::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_currentChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "currentChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // currentChanged(QModelIndex,QModelIndex)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::currentChanged(*cpp_arg0, *cpp_arg1);
    } else goto SbkQHeaderViewFunc_currentChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_currentChanged_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.currentChanged", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_dataChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "dataChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // dataChanged(QModelIndex,QModelIndex)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::dataChanged(*cpp_arg0, *cpp_arg1);
    } else goto SbkQHeaderViewFunc_dataChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_dataChanged_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.dataChanged", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_defaultAlignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultAlignment()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QHeaderView::defaultAlignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_defaultSectionSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultSectionSize()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHeaderView::defaultSectionSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_doItemsLayout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // doItemsLayout()
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    cppSelf->QHeaderView::doItemsLayout();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQHeaderViewFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHeaderView::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.event", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_headerDataChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "headerDataChanged", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // headerDataChanged(Qt::Orientation,int,int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::headerDataChanged(cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQHeaderViewFunc_headerDataChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_headerDataChanged_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.headerDataChanged", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_hiddenSectionCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hiddenSectionCount()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHeaderView::hiddenSectionCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_hideSection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // hideSection(int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::hideSection(cpp_arg0);
    } else goto SbkQHeaderViewFunc_hideSection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_hideSection_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.hideSection", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_highlightSections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // highlightSections()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHeaderView::highlightSections();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_horizontalOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalOffset()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHeaderView::horizontalOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_indexAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // indexAt(QPoint)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QHeaderView::indexAt(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_indexAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_indexAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.indexAt", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_initialize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // initialize()
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    cppSelf->QHeaderView::initialize();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQHeaderViewFunc_initializeSections(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto SbkQHeaderViewFunc_initializeSections_TypeError;

    if (!PyArg_UnpackTuple(args, "initializeSections", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // initializeSections()
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::initializeSections();
    } else if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // initializeSections(int,int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::initializeSections(cpp_arg0, cpp_arg1);
    } else goto SbkQHeaderViewFunc_initializeSections_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_initializeSections_TypeError:
        const char* overloads[] = {"", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.initializeSections", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_isClickable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isClickable()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHeaderView::isClickable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_isIndexHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // isIndexHidden(QModelIndex)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHeaderView::isIndexHidden(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_isIndexHidden_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_isIndexHidden_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.isIndexHidden", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_isMovable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isMovable()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHeaderView::isMovable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_isSectionHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isSectionHidden(int)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHeaderView::isSectionHidden(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_isSectionHidden_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_isSectionHidden_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.isSectionHidden", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_isSortIndicatorShown(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSortIndicatorShown()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHeaderView::isSortIndicatorShown();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHeaderView::length();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_logicalIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // logicalIndex(int)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QHeaderView::logicalIndex(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_logicalIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_logicalIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.logicalIndex", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_logicalIndexAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "logicalIndexAt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // logicalIndexAt(int)const
            QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QHeaderView::logicalIndexAt(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // logicalIndexAt(int,int)const
            QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QHeaderView::logicalIndexAt(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else goto SbkQHeaderViewFunc_logicalIndexAt_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QPoint& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // logicalIndexAt(QPoint)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QHeaderView::logicalIndexAt(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_logicalIndexAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_logicalIndexAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.logicalIndexAt", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_minimumSectionSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSectionSize()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHeaderView::minimumSectionSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QMouseEvent*)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::mouseDoubleClickEvent(cpp_arg0);
    } else goto SbkQHeaderViewFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::mouseMoveEvent(cpp_arg0);
    } else goto SbkQHeaderViewFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.mouseMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::mousePressEvent(cpp_arg0);
    } else goto SbkQHeaderViewFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.mousePressEvent", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::mouseReleaseEvent(cpp_arg0);
    } else goto SbkQHeaderViewFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_moveCursor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "moveCursor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAbstractItemView::CursorAction >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[1])) {
        QAbstractItemView::CursorAction cpp_arg0 = Shiboken::Converter<QAbstractItemView::CursorAction >::toCpp(pyargs[0]);
        QFlags<Qt::KeyboardModifier> cpp_arg1 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[1]);
        // moveCursor(QAbstractItemView::CursorAction,QFlags<Qt::KeyboardModifier>)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QHeaderView::moveCursor(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_moveCursor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_moveCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView.CursorAction, PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.moveCursor", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_moveSection(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "moveSection", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // moveSection(int,int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::moveSection(cpp_arg0, cpp_arg1);
    } else goto SbkQHeaderViewFunc_moveSection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_moveSection_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.moveSection", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_offset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // offset()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHeaderView::offset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_orientation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // orientation()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    Qt::Orientation cpp_result = cppSelf->QHeaderView::orientation();
    py_result = Shiboken::Converter<Qt::Orientation >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::paintEvent(cpp_arg0);
    } else goto SbkQHeaderViewFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.paintEvent", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_paintSection(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "paintSection", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect& >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // paintSection(QPainter*,QRect,int)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::paintSection(cpp_arg0, *cpp_arg1, cpp_arg2);
    } else goto SbkQHeaderViewFunc_paintSection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_paintSection_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.paintSection", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    cppSelf->QHeaderView::reset();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQHeaderViewFunc_resizeMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // resizeMode(int)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        QHeaderView::ResizeMode cpp_result = cppSelf->QHeaderView::resizeMode(cpp_arg0);
        py_result = Shiboken::Converter<QHeaderView::ResizeMode >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_resizeMode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_resizeMode_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.resizeMode", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_resizeSection(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "resizeSection", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // resizeSection(int,int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::resizeSection(cpp_arg0, cpp_arg1);
    } else goto SbkQHeaderViewFunc_resizeSection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_resizeSection_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.resizeSection", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_resizeSections(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // resizeSections()
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::resizeSections();
    } else if (Shiboken::Converter<QHeaderView::ResizeMode >::isConvertible(arg)) {
        QHeaderView::ResizeMode cpp_arg0 = Shiboken::Converter<QHeaderView::ResizeMode >::toCpp(arg);
        // resizeSections(QHeaderView::ResizeMode)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::resizeSections(cpp_arg0);
    } else goto SbkQHeaderViewFunc_resizeSections_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_resizeSections_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QHeaderView.ResizeMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.resizeSections", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_restoreState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // restoreState(QByteArray)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHeaderView::restoreState(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_restoreState_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_restoreState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.restoreState", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_rowsInserted(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "rowsInserted", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // rowsInserted(QModelIndex,int,int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::rowsInserted(*cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQHeaderViewFunc_rowsInserted_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_rowsInserted_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.rowsInserted", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_saveState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // saveState()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QHeaderView::saveState();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_scrollContentsBy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollContentsBy", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // scrollContentsBy(int,int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::scrollContentsBy(cpp_arg0, cpp_arg1);
    } else goto SbkQHeaderViewFunc_scrollContentsBy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_scrollContentsBy_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.scrollContentsBy", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_scrollTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollTo", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractItemView::ScrollHint >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        QAbstractItemView::ScrollHint cpp_arg1 = Shiboken::Converter<QAbstractItemView::ScrollHint >::toCpp(pyargs[1]);
        // scrollTo(QModelIndex,QAbstractItemView::ScrollHint)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::scrollTo(*cpp_arg0, cpp_arg1);
    } else goto SbkQHeaderViewFunc_scrollTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_scrollTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtGui.QAbstractItemView.ScrollHint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.scrollTo", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_sectionPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // sectionPosition(int)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QHeaderView::sectionPosition(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_sectionPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_sectionPosition_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.sectionPosition", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_sectionSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // sectionSize(int)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QHeaderView::sectionSize(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_sectionSize_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_sectionSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.sectionSize", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_sectionSizeFromContents(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // sectionSizeFromContents(int)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QHeaderView::sectionSizeFromContents(cpp_arg0);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_sectionSizeFromContents_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_sectionSizeFromContents_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.sectionSizeFromContents", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_sectionSizeHint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // sectionSizeHint(int)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QHeaderView::sectionSizeHint(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_sectionSizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_sectionSizeHint_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.sectionSizeHint", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_sectionViewportPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // sectionViewportPosition(int)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QHeaderView::sectionViewportPosition(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_sectionViewportPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_sectionViewportPosition_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.sectionViewportPosition", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_sectionsAboutToBeRemoved(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sectionsAboutToBeRemoved", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // sectionsAboutToBeRemoved(QModelIndex,int,int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::sectionsAboutToBeRemoved(*cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQHeaderViewFunc_sectionsAboutToBeRemoved_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_sectionsAboutToBeRemoved_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.sectionsAboutToBeRemoved", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_sectionsHidden(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sectionsHidden()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHeaderView::sectionsHidden();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_sectionsInserted(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sectionsInserted", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // sectionsInserted(QModelIndex,int,int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::sectionsInserted(*cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQHeaderViewFunc_sectionsInserted_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_sectionsInserted_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.sectionsInserted", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_sectionsMoved(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sectionsMoved()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHeaderView::sectionsMoved();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_setCascadingSectionResizes(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setCascadingSectionResizes(bool)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setCascadingSectionResizes(cpp_arg0);
    } else goto SbkQHeaderViewFunc_setCascadingSectionResizes_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setCascadingSectionResizes_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setCascadingSectionResizes", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setClickable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setClickable(bool)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setClickable(cpp_arg0);
    } else goto SbkQHeaderViewFunc_setClickable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setClickable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setClickable", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setDefaultAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setDefaultAlignment(QFlags<Qt::AlignmentFlag>)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setDefaultAlignment(cpp_arg0);
    } else goto SbkQHeaderViewFunc_setDefaultAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setDefaultAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setDefaultAlignment", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setDefaultSectionSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setDefaultSectionSize(int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setDefaultSectionSize(cpp_arg0);
    } else goto SbkQHeaderViewFunc_setDefaultSectionSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setDefaultSectionSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setDefaultSectionSize", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setHighlightSections(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setHighlightSections(bool)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setHighlightSections(cpp_arg0);
    } else goto SbkQHeaderViewFunc_setHighlightSections_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setHighlightSections_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setHighlightSections", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setMinimumSectionSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMinimumSectionSize(int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setMinimumSectionSize(cpp_arg0);
    } else goto SbkQHeaderViewFunc_setMinimumSectionSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setMinimumSectionSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setMinimumSectionSize", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemModel* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemModel* cpp_arg0 = Shiboken::Converter<QAbstractItemModel* >::toCpp(arg);
        // setModel(QAbstractItemModel*)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setModel(cpp_arg0);
        Shiboken::SbkBaseWrapper_keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "setModel(QAbstractItemModel*)1", arg);
    } else goto SbkQHeaderViewFunc_setModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setModel_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractItemModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setModel", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setMovable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setMovable(bool)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setMovable(cpp_arg0);
    } else goto SbkQHeaderViewFunc_setMovable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setMovable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setMovable", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setOffset(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setOffset(int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setOffset(cpp_arg0);
    } else goto SbkQHeaderViewFunc_setOffset_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setOffset_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setOffset", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setOffsetToLastSection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // setOffsetToLastSection()
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    cppSelf->QHeaderView::setOffsetToLastSection();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQHeaderViewFunc_setOffsetToSectionPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setOffsetToSectionPosition(int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setOffsetToSectionPosition(cpp_arg0);
    } else goto SbkQHeaderViewFunc_setOffsetToSectionPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setOffsetToSectionPosition_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setOffsetToSectionPosition", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setResizeMode(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setResizeMode", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QHeaderView::ResizeMode >::isConvertible(pyargs[0])) {
        QHeaderView::ResizeMode cpp_arg0 = Shiboken::Converter<QHeaderView::ResizeMode >::toCpp(pyargs[0]);
        // setResizeMode(QHeaderView::ResizeMode)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setResizeMode(cpp_arg0);
    } else if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QHeaderView::ResizeMode >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QHeaderView::ResizeMode cpp_arg1 = Shiboken::Converter<QHeaderView::ResizeMode >::toCpp(pyargs[1]);
        // setResizeMode(int,QHeaderView::ResizeMode)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setResizeMode(cpp_arg0, cpp_arg1);
    } else goto SbkQHeaderViewFunc_setResizeMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setResizeMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QHeaderView.ResizeMode", "int, PySide.QtGui.QHeaderView.ResizeMode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.setResizeMode", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setSectionHidden(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setSectionHidden", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setSectionHidden(int,bool)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setSectionHidden(cpp_arg0, cpp_arg1);
    } else goto SbkQHeaderViewFunc_setSectionHidden_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setSectionHidden_TypeError:
        const char* overloads[] = {"int, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.setSectionHidden", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setSelection(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setSelection", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QRect& >::isConvertible(pyargs[0]) && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        QFlags<QItemSelectionModel::SelectionFlag> cpp_arg1 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[1]);
        // setSelection(QRect,QFlags<QItemSelectionModel::SelectionFlag>)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setSelection(*cpp_arg0, cpp_arg1);
    } else goto SbkQHeaderViewFunc_setSelection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setSelection_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.setSelection", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setSortIndicator(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setSortIndicator", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::SortOrder cpp_arg1 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[1]);
        // setSortIndicator(int,Qt::SortOrder)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setSortIndicator(cpp_arg0, cpp_arg1);
    } else goto SbkQHeaderViewFunc_setSortIndicator_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setSortIndicator_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.SortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.setSortIndicator", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setSortIndicatorShown(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSortIndicatorShown(bool)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setSortIndicatorShown(cpp_arg0);
    } else goto SbkQHeaderViewFunc_setSortIndicatorShown_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setSortIndicatorShown_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setSortIndicatorShown", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_setStretchLastSection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setStretchLastSection(bool)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::setStretchLastSection(cpp_arg0);
    } else goto SbkQHeaderViewFunc_setStretchLastSection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_setStretchLastSection_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.setStretchLastSection", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_showSection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // showSection(int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::showSection(cpp_arg0);
    } else goto SbkQHeaderViewFunc_showSection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_showSection_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.showSection", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QHeaderView::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_sortIndicatorOrder(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sortIndicatorOrder()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    Qt::SortOrder cpp_result = cppSelf->QHeaderView::sortIndicatorOrder();
    py_result = Shiboken::Converter<Qt::SortOrder >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_sortIndicatorSection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sortIndicatorSection()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHeaderView::sortIndicatorSection();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_stretchLastSection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stretchLastSection()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHeaderView::stretchLastSection();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_stretchSectionCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stretchSectionCount()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHeaderView::stretchSectionCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_swapSections(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "swapSections", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // swapSections(int,int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::swapSections(cpp_arg0, cpp_arg1);
    } else goto SbkQHeaderViewFunc_swapSections_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_swapSections_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QHeaderView.swapSections", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_updateGeometries(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateGeometries()
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    cppSelf->QHeaderView::updateGeometries();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQHeaderViewFunc_updateSection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // updateSection(int)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        cppSelf->QHeaderView::updateSection(cpp_arg0);
    } else goto SbkQHeaderViewFunc_updateSection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHeaderViewFunc_updateSection_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.updateSection", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_verticalOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalOffset()const
    QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QHeaderView::verticalOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQHeaderViewFunc_viewportEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // viewportEvent(QEvent*)
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHeaderView::viewportEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_viewportEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_viewportEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.viewportEvent", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_visualIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // visualIndex(int)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QHeaderView::visualIndex(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_visualIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_visualIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.visualIndex", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_visualIndexAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // visualIndexAt(int)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QHeaderView::visualIndexAt(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_visualIndexAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_visualIndexAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.visualIndexAt", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_visualRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // visualRect(QModelIndex)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QHeaderView::visualRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_visualRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_visualRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.visualRect", overloads);
        return 0;
}

static PyObject*
SbkQHeaderViewFunc_visualRegionForSelection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelection& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(arg);
        // visualRegionForSelection(QItemSelection)const
        QHeaderView* cppSelf = Shiboken::Converter<QHeaderView* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QHeaderView::visualRegionForSelection(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQHeaderViewFunc_visualRegionForSelection_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQHeaderViewFunc_visualRegionForSelection_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QHeaderView.visualRegionForSelection", overloads);
        return 0;
}

static PyMethodDef SbkQHeaderView_methods[] = {
    {"cascadingSectionResizes", (PyCFunction)SbkQHeaderViewFunc_cascadingSectionResizes, METH_NOARGS},
    {"count", (PyCFunction)SbkQHeaderViewFunc_count, METH_NOARGS},
    {"currentChanged", (PyCFunction)SbkQHeaderViewFunc_currentChanged, METH_VARARGS},
    {"dataChanged", (PyCFunction)SbkQHeaderViewFunc_dataChanged, METH_VARARGS},
    {"defaultAlignment", (PyCFunction)SbkQHeaderViewFunc_defaultAlignment, METH_NOARGS},
    {"defaultSectionSize", (PyCFunction)SbkQHeaderViewFunc_defaultSectionSize, METH_NOARGS},
    {"doItemsLayout", (PyCFunction)SbkQHeaderViewFunc_doItemsLayout, METH_NOARGS},
    {"event", (PyCFunction)SbkQHeaderViewFunc_event, METH_O},
    {"headerDataChanged", (PyCFunction)SbkQHeaderViewFunc_headerDataChanged, METH_VARARGS},
    {"hiddenSectionCount", (PyCFunction)SbkQHeaderViewFunc_hiddenSectionCount, METH_NOARGS},
    {"hideSection", (PyCFunction)SbkQHeaderViewFunc_hideSection, METH_O},
    {"highlightSections", (PyCFunction)SbkQHeaderViewFunc_highlightSections, METH_NOARGS},
    {"horizontalOffset", (PyCFunction)SbkQHeaderViewFunc_horizontalOffset, METH_NOARGS},
    {"indexAt", (PyCFunction)SbkQHeaderViewFunc_indexAt, METH_O},
    {"initialize", (PyCFunction)SbkQHeaderViewFunc_initialize, METH_NOARGS},
    {"initializeSections", (PyCFunction)SbkQHeaderViewFunc_initializeSections, METH_VARARGS},
    {"isClickable", (PyCFunction)SbkQHeaderViewFunc_isClickable, METH_NOARGS},
    {"isIndexHidden", (PyCFunction)SbkQHeaderViewFunc_isIndexHidden, METH_O},
    {"isMovable", (PyCFunction)SbkQHeaderViewFunc_isMovable, METH_NOARGS},
    {"isSectionHidden", (PyCFunction)SbkQHeaderViewFunc_isSectionHidden, METH_O},
    {"isSortIndicatorShown", (PyCFunction)SbkQHeaderViewFunc_isSortIndicatorShown, METH_NOARGS},
    {"length", (PyCFunction)SbkQHeaderViewFunc_length, METH_NOARGS},
    {"logicalIndex", (PyCFunction)SbkQHeaderViewFunc_logicalIndex, METH_O},
    {"logicalIndexAt", (PyCFunction)SbkQHeaderViewFunc_logicalIndexAt, METH_VARARGS},
    {"minimumSectionSize", (PyCFunction)SbkQHeaderViewFunc_minimumSectionSize, METH_NOARGS},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQHeaderViewFunc_mouseDoubleClickEvent, METH_O},
    {"mouseMoveEvent", (PyCFunction)SbkQHeaderViewFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQHeaderViewFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQHeaderViewFunc_mouseReleaseEvent, METH_O},
    {"moveCursor", (PyCFunction)SbkQHeaderViewFunc_moveCursor, METH_VARARGS},
    {"moveSection", (PyCFunction)SbkQHeaderViewFunc_moveSection, METH_VARARGS},
    {"offset", (PyCFunction)SbkQHeaderViewFunc_offset, METH_NOARGS},
    {"orientation", (PyCFunction)SbkQHeaderViewFunc_orientation, METH_NOARGS},
    {"paintEvent", (PyCFunction)SbkQHeaderViewFunc_paintEvent, METH_O},
    {"paintSection", (PyCFunction)SbkQHeaderViewFunc_paintSection, METH_VARARGS},
    {"reset", (PyCFunction)SbkQHeaderViewFunc_reset, METH_NOARGS},
    {"resizeMode", (PyCFunction)SbkQHeaderViewFunc_resizeMode, METH_O},
    {"resizeSection", (PyCFunction)SbkQHeaderViewFunc_resizeSection, METH_VARARGS},
    {"resizeSections", (PyCFunction)SbkQHeaderViewFunc_resizeSections, METH_NOARGS|METH_O},
    {"restoreState", (PyCFunction)SbkQHeaderViewFunc_restoreState, METH_O},
    {"rowsInserted", (PyCFunction)SbkQHeaderViewFunc_rowsInserted, METH_VARARGS},
    {"saveState", (PyCFunction)SbkQHeaderViewFunc_saveState, METH_NOARGS},
    {"scrollContentsBy", (PyCFunction)SbkQHeaderViewFunc_scrollContentsBy, METH_VARARGS},
    {"scrollTo", (PyCFunction)SbkQHeaderViewFunc_scrollTo, METH_VARARGS},
    {"sectionPosition", (PyCFunction)SbkQHeaderViewFunc_sectionPosition, METH_O},
    {"sectionSize", (PyCFunction)SbkQHeaderViewFunc_sectionSize, METH_O},
    {"sectionSizeFromContents", (PyCFunction)SbkQHeaderViewFunc_sectionSizeFromContents, METH_O},
    {"sectionSizeHint", (PyCFunction)SbkQHeaderViewFunc_sectionSizeHint, METH_O},
    {"sectionViewportPosition", (PyCFunction)SbkQHeaderViewFunc_sectionViewportPosition, METH_O},
    {"sectionsAboutToBeRemoved", (PyCFunction)SbkQHeaderViewFunc_sectionsAboutToBeRemoved, METH_VARARGS},
    {"sectionsHidden", (PyCFunction)SbkQHeaderViewFunc_sectionsHidden, METH_NOARGS},
    {"sectionsInserted", (PyCFunction)SbkQHeaderViewFunc_sectionsInserted, METH_VARARGS},
    {"sectionsMoved", (PyCFunction)SbkQHeaderViewFunc_sectionsMoved, METH_NOARGS},
    {"setCascadingSectionResizes", (PyCFunction)SbkQHeaderViewFunc_setCascadingSectionResizes, METH_O},
    {"setClickable", (PyCFunction)SbkQHeaderViewFunc_setClickable, METH_O},
    {"setDefaultAlignment", (PyCFunction)SbkQHeaderViewFunc_setDefaultAlignment, METH_O},
    {"setDefaultSectionSize", (PyCFunction)SbkQHeaderViewFunc_setDefaultSectionSize, METH_O},
    {"setHighlightSections", (PyCFunction)SbkQHeaderViewFunc_setHighlightSections, METH_O},
    {"setMinimumSectionSize", (PyCFunction)SbkQHeaderViewFunc_setMinimumSectionSize, METH_O},
    {"setModel", (PyCFunction)SbkQHeaderViewFunc_setModel, METH_O},
    {"setMovable", (PyCFunction)SbkQHeaderViewFunc_setMovable, METH_O},
    {"setOffset", (PyCFunction)SbkQHeaderViewFunc_setOffset, METH_O},
    {"setOffsetToLastSection", (PyCFunction)SbkQHeaderViewFunc_setOffsetToLastSection, METH_NOARGS},
    {"setOffsetToSectionPosition", (PyCFunction)SbkQHeaderViewFunc_setOffsetToSectionPosition, METH_O},
    {"setResizeMode", (PyCFunction)SbkQHeaderViewFunc_setResizeMode, METH_VARARGS},
    {"setSectionHidden", (PyCFunction)SbkQHeaderViewFunc_setSectionHidden, METH_VARARGS},
    {"setSelection", (PyCFunction)SbkQHeaderViewFunc_setSelection, METH_VARARGS},
    {"setSortIndicator", (PyCFunction)SbkQHeaderViewFunc_setSortIndicator, METH_VARARGS},
    {"setSortIndicatorShown", (PyCFunction)SbkQHeaderViewFunc_setSortIndicatorShown, METH_O},
    {"setStretchLastSection", (PyCFunction)SbkQHeaderViewFunc_setStretchLastSection, METH_O},
    {"showSection", (PyCFunction)SbkQHeaderViewFunc_showSection, METH_O},
    {"sizeHint", (PyCFunction)SbkQHeaderViewFunc_sizeHint, METH_NOARGS},
    {"sortIndicatorOrder", (PyCFunction)SbkQHeaderViewFunc_sortIndicatorOrder, METH_NOARGS},
    {"sortIndicatorSection", (PyCFunction)SbkQHeaderViewFunc_sortIndicatorSection, METH_NOARGS},
    {"stretchLastSection", (PyCFunction)SbkQHeaderViewFunc_stretchLastSection, METH_NOARGS},
    {"stretchSectionCount", (PyCFunction)SbkQHeaderViewFunc_stretchSectionCount, METH_NOARGS},
    {"swapSections", (PyCFunction)SbkQHeaderViewFunc_swapSections, METH_VARARGS},
    {"updateGeometries", (PyCFunction)SbkQHeaderViewFunc_updateGeometries, METH_NOARGS},
    {"updateSection", (PyCFunction)SbkQHeaderViewFunc_updateSection, METH_O},
    {"verticalOffset", (PyCFunction)SbkQHeaderViewFunc_verticalOffset, METH_NOARGS},
    {"viewportEvent", (PyCFunction)SbkQHeaderViewFunc_viewportEvent, METH_O},
    {"visualIndex", (PyCFunction)SbkQHeaderViewFunc_visualIndex, METH_O},
    {"visualIndexAt", (PyCFunction)SbkQHeaderViewFunc_visualIndexAt, METH_O},
    {"visualRect", (PyCFunction)SbkQHeaderViewFunc_visualRect, METH_O},
    {"visualRegionForSelection", (PyCFunction)SbkQHeaderViewFunc_visualRegionForSelection, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQHeaderViewSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QHeaderView* me = reinterpret_cast<QHeaderView*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX]))
        return static_cast<QAbstractItemView*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast<QAbstractScrollArea*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQHeaderView_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QHeaderView",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QHeaderViewWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQHeaderView_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQHeaderView_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQHeaderViewSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QHeaderView_ResizeMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QHeaderView_ResizeMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QHeaderView_ResizeMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ResizeMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QHeaderView_ResizeMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QHeaderView_ResizeMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QHeaderView_ResizeMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QHeaderView(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QHEADERVIEW_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQHeaderView_Type);

    SbkQHeaderView_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX];
    SbkQHeaderView_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQHeaderView_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQHeaderView_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQHeaderView_Type));
    PyModule_AddObject(module, "QHeaderView",
        ((PyObject*)&SbkQHeaderView_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ResizeMode
    SbkPySide_QtGuiTypes[SBK_QHEADERVIEW_RESIZEMODE_IDX] = &SbkPySide_QtGui_QHeaderView_ResizeMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QHeaderView_ResizeMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QHeaderView_ResizeMode_Type);
    PyDict_SetItemString(SbkQHeaderView_Type.super.ht_type.tp_dict,
            "ResizeMode",((PyObject*)&SbkPySide_QtGui_QHeaderView_ResizeMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QHeaderView_ResizeMode_Type,
        (long) QHeaderView::Interactive, "Interactive");
    PyDict_SetItemString(SbkQHeaderView_Type.super.ht_type.tp_dict,
        "Interactive", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QHeaderView_ResizeMode_Type.tp_dict,
        "Interactive", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QHeaderView_ResizeMode_Type,
        (long) QHeaderView::Stretch, "Stretch");
    PyDict_SetItemString(SbkQHeaderView_Type.super.ht_type.tp_dict,
        "Stretch", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QHeaderView_ResizeMode_Type.tp_dict,
        "Stretch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QHeaderView_ResizeMode_Type,
        (long) QHeaderView::Fixed, "Fixed");
    PyDict_SetItemString(SbkQHeaderView_Type.super.ht_type.tp_dict,
        "Fixed", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QHeaderView_ResizeMode_Type.tp_dict,
        "Fixed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QHeaderView_ResizeMode_Type,
        (long) QHeaderView::ResizeToContents, "ResizeToContents");
    PyDict_SetItemString(SbkQHeaderView_Type.super.ht_type.tp_dict,
        "ResizeToContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QHeaderView_ResizeMode_Type.tp_dict,
        "ResizeToContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QHeaderView_ResizeMode_Type,
        (long) QHeaderView::Custom, "Custom");
    PyDict_SetItemString(SbkQHeaderView_Type.super.ht_type.tp_dict,
        "Custom", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QHeaderView_ResizeMode_Type.tp_dict,
        "Custom", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QHeaderView::ResizeMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QHeaderView >("QHeaderView*");
    Shiboken::TypeResolver::createObjectTypeResolver<QHeaderView >(typeid(QHeaderView).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

