/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qgraphicsscene_wrapper.h"

// Extra includes
#include <QList>
#include <QVarLengthArray>
#include <qbrush.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicsitem.h>
#include <qgraphicsproxywidget.h>
#include <qgraphicsscene.h>
#include <qgraphicssceneevent.h>
#include <qgraphicsview.h>
#include <qgraphicswidget.h>
#include <qline.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpainterpath.h>
#include <qpalette.h>
#include <qpen.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qpolygon.h>
#include <qrect.h>
#include <qstring.h>
#include <qstyle.h>
#include <qthread.h>
#include <qtransform.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsSceneWrapper::QGraphicsSceneWrapper(QObject * parent) : QGraphicsScene(parent), m_metaObject(0) {
    // ... middle
}

QGraphicsSceneWrapper::QGraphicsSceneWrapper(const QRectF & sceneRect, QObject * parent) : QGraphicsScene(sceneRect, parent), m_metaObject(0) {
    // ... middle
}

QGraphicsSceneWrapper::QGraphicsSceneWrapper(qreal x, qreal y, qreal width, qreal height, QObject * parent) : QGraphicsScene(x, y, width, height, parent), m_metaObject(0) {
    // ... middle
}

void QGraphicsSceneWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsSceneWrapper::contextMenuEvent(QGraphicsSceneContextMenuEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::contextMenuEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsSceneWrapper::dragEnterEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::dragLeaveEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::dragMoveEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::drawBackground(QPainter * painter, const QRectF & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawBackground"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::drawBackground(painter, rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRectF& >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::drawForeground(QPainter * painter, const QRectF & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawForeground"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::drawForeground(painter, rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRectF& >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::dropEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::dropEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QGraphicsSceneWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsScene.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsSceneWrapper::eventFilter(QObject * watched, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(watched),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsScene.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsSceneWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::helpEvent(QGraphicsSceneHelpEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "helpEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::helpEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneHelpEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::inputMethodEvent(QInputMethodEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QGraphicsSceneWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGraphicsScene.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsSceneWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::keyReleaseEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::mouseDoubleClickEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::mouseMoveEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::mousePressEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::mouseReleaseEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsSceneWrapper::wheelEvent(QGraphicsSceneWheelEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsScene::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGraphicsSceneWheelEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QGraphicsSceneWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGraphicsScene::staticMetaObject);
}
    return m_metaObject;
}

int QGraphicsSceneWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGraphicsScene::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGraphicsSceneWrapper::~QGraphicsSceneWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsScene_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsSceneWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQGraphicsScene_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QGraphicsScene", 0, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsScene(QObject*)
        cptr = new QGraphicsSceneWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // QGraphicsScene(qreal,qreal,qreal,qreal,QObject*)
            cptr = new QGraphicsSceneWrapper(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            Shiboken::setParent(pyargs[4], self);
        } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[4])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                return -1;
            QObject* cpp_arg4 = Shiboken::Converter<QObject* >::toCpp(pyargs[4]);
            // QGraphicsScene(qreal,qreal,qreal,qreal,QObject*)
            cptr = new QGraphicsSceneWrapper(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            Shiboken::setParent(pyargs[4], self);
        } else goto SbkQGraphicsScene_Init_TypeError;
    } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 1) {
            // QGraphicsScene(QRectF,QObject*)
            cptr = new QGraphicsSceneWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QGraphicsScene(QRectF,QObject*)
            cptr = new QGraphicsSceneWrapper(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQGraphicsScene_Init_TypeError;
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QGraphicsScene(QObject*)
        cptr = new QGraphicsSceneWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQGraphicsScene_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsScene_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGraphicsScene_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "PySide.QtCore.QRectF, PySide.QtCore.QObject = None", "float, float, float, float, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene", overloads);
        return -1;
}

static PyObject*
SbkQGraphicsSceneFunc_activePanel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // activePanel()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QGraphicsItem * cpp_result = cppSelf->QGraphicsScene::activePanel();
    py_result = Shiboken::Converter<QGraphicsItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_activeWindow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // activeWindow()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QGraphicsWidget * cpp_result = cppSelf->QGraphicsScene::activeWindow();
    py_result = Shiboken::Converter<QGraphicsWidget* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_addEllipse(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addEllipse", 1, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // addEllipse(qreal,qreal,qreal,qreal,QPen,QBrush)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsEllipseItem * cpp_result = cppSelf->QGraphicsScene::addEllipse(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QGraphicsEllipseItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QPen& >::isConvertible(pyargs[4])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                return 0;
            std::auto_ptr<QPen > cpp_arg4_auto_ptr;
            QPen* cpp_arg4 = Shiboken::Converter<QPen* >::toCpp(pyargs[4]);
            if (!Shiboken::Converter<QPen& >::isConvertible(pyargs[4]))
                cpp_arg4_auto_ptr = std::auto_ptr<QPen >(cpp_arg4);
            if (numArgs == 5) {
                // addEllipse(qreal,qreal,qreal,qreal,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsEllipseItem * cpp_result = cppSelf->QGraphicsScene::addEllipse(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
                py_result = Shiboken::Converter<QGraphicsEllipseItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else if (Shiboken::Converter<QBrush& >::isConvertible(pyargs[5])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[5]))
                    return 0;
                std::auto_ptr<QBrush > cpp_arg5_auto_ptr;
                QBrush* cpp_arg5 = Shiboken::Converter<QBrush* >::toCpp(pyargs[5]);
                if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[5]))
                    cpp_arg5_auto_ptr = std::auto_ptr<QBrush >(cpp_arg5);
                // addEllipse(qreal,qreal,qreal,qreal,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsEllipseItem * cpp_result = cppSelf->QGraphicsScene::addEllipse(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4, *cpp_arg5);
                py_result = Shiboken::Converter<QGraphicsEllipseItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else goto SbkQGraphicsSceneFunc_addEllipse_TypeError;
        } else goto SbkQGraphicsSceneFunc_addEllipse_TypeError;
    } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 1) {
            // addEllipse(QRectF,QPen,QBrush)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsEllipseItem * cpp_result = cppSelf->QGraphicsScene::addEllipse(*cpp_arg0);
            py_result = Shiboken::Converter<QGraphicsEllipseItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QPen& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QPen > cpp_arg1_auto_ptr;
            QPen* cpp_arg1 = Shiboken::Converter<QPen* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QPen& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPen >(cpp_arg1);
            if (numArgs == 2) {
                // addEllipse(QRectF,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsEllipseItem * cpp_result = cppSelf->QGraphicsScene::addEllipse(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<QGraphicsEllipseItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else if (Shiboken::Converter<QBrush& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QBrush > cpp_arg2_auto_ptr;
                QBrush* cpp_arg2 = Shiboken::Converter<QBrush* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QBrush >(cpp_arg2);
                // addEllipse(QRectF,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsEllipseItem * cpp_result = cppSelf->QGraphicsScene::addEllipse(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                py_result = Shiboken::Converter<QGraphicsEllipseItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else goto SbkQGraphicsSceneFunc_addEllipse_TypeError;
        } else goto SbkQGraphicsSceneFunc_addEllipse_TypeError;
    } else goto SbkQGraphicsSceneFunc_addEllipse_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_addEllipse_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF, PySide.QtGui.QPen = QPen(), PySide.QtGui.QBrush = QBrush()", "float, float, float, float, PySide.QtGui.QPen = QPen(), PySide.QtGui.QBrush = QBrush()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.addEllipse", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_addItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(arg);
        // addItem(QGraphicsItem*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::addItem(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQGraphicsSceneFunc_addItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_addItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.addItem", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_addLine(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQGraphicsSceneFunc_addLine_TypeError;

    if (!PyArg_UnpackTuple(args, "addLine", 1, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // addLine(qreal,qreal,qreal,qreal,QPen)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsLineItem * cpp_result = cppSelf->QGraphicsScene::addLine(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QGraphicsLineItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QPen& >::isConvertible(pyargs[4])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                return 0;
            std::auto_ptr<QPen > cpp_arg4_auto_ptr;
            QPen* cpp_arg4 = Shiboken::Converter<QPen* >::toCpp(pyargs[4]);
            if (!Shiboken::Converter<QPen& >::isConvertible(pyargs[4]))
                cpp_arg4_auto_ptr = std::auto_ptr<QPen >(cpp_arg4);
            // addLine(qreal,qreal,qreal,qreal,QPen)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsLineItem * cpp_result = cppSelf->QGraphicsScene::addLine(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
            py_result = Shiboken::Converter<QGraphicsLineItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQGraphicsSceneFunc_addLine_TypeError;
    } else if (Shiboken::Converter<QLineF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QLineF > cpp_arg0_auto_ptr;
        QLineF* cpp_arg0 = Shiboken::Converter<QLineF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QLineF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QLineF >(cpp_arg0);
        if (numArgs == 1) {
            // addLine(QLineF,QPen)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsLineItem * cpp_result = cppSelf->QGraphicsScene::addLine(*cpp_arg0);
            py_result = Shiboken::Converter<QGraphicsLineItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QPen& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QPen > cpp_arg1_auto_ptr;
            QPen* cpp_arg1 = Shiboken::Converter<QPen* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QPen& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPen >(cpp_arg1);
            // addLine(QLineF,QPen)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsLineItem * cpp_result = cppSelf->QGraphicsScene::addLine(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QGraphicsLineItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQGraphicsSceneFunc_addLine_TypeError;
    } else goto SbkQGraphicsSceneFunc_addLine_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_addLine_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLineF, PySide.QtGui.QPen = QPen()", "float, float, float, float, PySide.QtGui.QPen = QPen()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.addLine", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_addPath(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addPath", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPainterPath& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // addPath(QPainterPath,QPen,QBrush)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsPathItem * cpp_result = cppSelf->QGraphicsScene::addPath(*cpp_arg0);
            py_result = Shiboken::Converter<QGraphicsPathItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QPen& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QPen > cpp_arg1_auto_ptr;
            QPen* cpp_arg1 = Shiboken::Converter<QPen* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QPen& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPen >(cpp_arg1);
            if (numArgs == 2) {
                // addPath(QPainterPath,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsPathItem * cpp_result = cppSelf->QGraphicsScene::addPath(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<QGraphicsPathItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else if (Shiboken::Converter<QBrush& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QBrush > cpp_arg2_auto_ptr;
                QBrush* cpp_arg2 = Shiboken::Converter<QBrush* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QBrush >(cpp_arg2);
                // addPath(QPainterPath,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsPathItem * cpp_result = cppSelf->QGraphicsScene::addPath(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                py_result = Shiboken::Converter<QGraphicsPathItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else goto SbkQGraphicsSceneFunc_addPath_TypeError;
        } else goto SbkQGraphicsSceneFunc_addPath_TypeError;
    } else goto SbkQGraphicsSceneFunc_addPath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_addPath_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath, PySide.QtGui.QPen = QPen(), PySide.QtGui.QBrush = QBrush()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.addPath", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_addPixmap(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPixmap& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(arg);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        // addPixmap(QPixmap)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        QGraphicsPixmapItem * cpp_result = cppSelf->QGraphicsScene::addPixmap(*cpp_arg0);
        py_result = Shiboken::Converter<QGraphicsPixmapItem* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQGraphicsSceneFunc_addPixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_addPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.addPixmap", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_addPolygon(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addPolygon", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        if (numArgs == 1) {
            // addPolygon(QPolygonF,QPen,QBrush)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsPolygonItem * cpp_result = cppSelf->QGraphicsScene::addPolygon(*cpp_arg0);
            py_result = Shiboken::Converter<QGraphicsPolygonItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QPen& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QPen > cpp_arg1_auto_ptr;
            QPen* cpp_arg1 = Shiboken::Converter<QPen* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QPen& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPen >(cpp_arg1);
            if (numArgs == 2) {
                // addPolygon(QPolygonF,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsPolygonItem * cpp_result = cppSelf->QGraphicsScene::addPolygon(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<QGraphicsPolygonItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else if (Shiboken::Converter<QBrush& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QBrush > cpp_arg2_auto_ptr;
                QBrush* cpp_arg2 = Shiboken::Converter<QBrush* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QBrush >(cpp_arg2);
                // addPolygon(QPolygonF,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsPolygonItem * cpp_result = cppSelf->QGraphicsScene::addPolygon(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                py_result = Shiboken::Converter<QGraphicsPolygonItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else goto SbkQGraphicsSceneFunc_addPolygon_TypeError;
        } else goto SbkQGraphicsSceneFunc_addPolygon_TypeError;
    } else goto SbkQGraphicsSceneFunc_addPolygon_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_addPolygon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygonF, PySide.QtGui.QPen = QPen(), PySide.QtGui.QBrush = QBrush()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.addPolygon", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_addRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addRect", 1, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // addRect(qreal,qreal,qreal,qreal,QPen,QBrush)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsRectItem * cpp_result = cppSelf->QGraphicsScene::addRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QGraphicsRectItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QPen& >::isConvertible(pyargs[4])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                return 0;
            std::auto_ptr<QPen > cpp_arg4_auto_ptr;
            QPen* cpp_arg4 = Shiboken::Converter<QPen* >::toCpp(pyargs[4]);
            if (!Shiboken::Converter<QPen& >::isConvertible(pyargs[4]))
                cpp_arg4_auto_ptr = std::auto_ptr<QPen >(cpp_arg4);
            if (numArgs == 5) {
                // addRect(qreal,qreal,qreal,qreal,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsRectItem * cpp_result = cppSelf->QGraphicsScene::addRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
                py_result = Shiboken::Converter<QGraphicsRectItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else if (Shiboken::Converter<QBrush& >::isConvertible(pyargs[5])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[5]))
                    return 0;
                std::auto_ptr<QBrush > cpp_arg5_auto_ptr;
                QBrush* cpp_arg5 = Shiboken::Converter<QBrush* >::toCpp(pyargs[5]);
                if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[5]))
                    cpp_arg5_auto_ptr = std::auto_ptr<QBrush >(cpp_arg5);
                // addRect(qreal,qreal,qreal,qreal,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsRectItem * cpp_result = cppSelf->QGraphicsScene::addRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4, *cpp_arg5);
                py_result = Shiboken::Converter<QGraphicsRectItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else goto SbkQGraphicsSceneFunc_addRect_TypeError;
        } else goto SbkQGraphicsSceneFunc_addRect_TypeError;
    } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 1) {
            // addRect(QRectF,QPen,QBrush)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsRectItem * cpp_result = cppSelf->QGraphicsScene::addRect(*cpp_arg0);
            py_result = Shiboken::Converter<QGraphicsRectItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QPen& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QPen > cpp_arg1_auto_ptr;
            QPen* cpp_arg1 = Shiboken::Converter<QPen* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QPen& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPen >(cpp_arg1);
            if (numArgs == 2) {
                // addRect(QRectF,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsRectItem * cpp_result = cppSelf->QGraphicsScene::addRect(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<QGraphicsRectItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else if (Shiboken::Converter<QBrush& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QBrush > cpp_arg2_auto_ptr;
                QBrush* cpp_arg2 = Shiboken::Converter<QBrush* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QBrush& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QBrush >(cpp_arg2);
                // addRect(QRectF,QPen,QBrush)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QGraphicsRectItem * cpp_result = cppSelf->QGraphicsScene::addRect(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                py_result = Shiboken::Converter<QGraphicsRectItem* >::toPython(cpp_result);
                Shiboken::setParent(self, py_result);
                Shiboken::setParent(self, py_result);
            } else goto SbkQGraphicsSceneFunc_addRect_TypeError;
        } else goto SbkQGraphicsSceneFunc_addRect_TypeError;
    } else goto SbkQGraphicsSceneFunc_addRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_addRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF, PySide.QtGui.QPen = QPen(), PySide.QtGui.QBrush = QBrush()", "float, float, float, float, PySide.QtGui.QPen = QPen(), PySide.QtGui.QBrush = QBrush()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.addRect", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_addSimpleText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addSimpleText", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // addSimpleText(QString,QFont)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsSimpleTextItem * cpp_result = cppSelf->QGraphicsScene::addSimpleText(*cpp_arg0);
            py_result = Shiboken::Converter<QGraphicsSimpleTextItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QFont& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QFont > cpp_arg1_auto_ptr;
            QFont* cpp_arg1 = Shiboken::Converter<QFont* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QFont& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QFont >(cpp_arg1);
            // addSimpleText(QString,QFont)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsSimpleTextItem * cpp_result = cppSelf->QGraphicsScene::addSimpleText(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QGraphicsSimpleTextItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQGraphicsSceneFunc_addSimpleText_TypeError;
    } else goto SbkQGraphicsSceneFunc_addSimpleText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_addSimpleText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtGui.QFont = QFont()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.addSimpleText", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_addText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addText", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // addText(QString,QFont)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsTextItem * cpp_result = cppSelf->QGraphicsScene::addText(*cpp_arg0);
            py_result = Shiboken::Converter<QGraphicsTextItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QFont& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QFont > cpp_arg1_auto_ptr;
            QFont* cpp_arg1 = Shiboken::Converter<QFont* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QFont& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QFont >(cpp_arg1);
            // addText(QString,QFont)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsTextItem * cpp_result = cppSelf->QGraphicsScene::addText(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QGraphicsTextItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQGraphicsSceneFunc_addText_TypeError;
    } else goto SbkQGraphicsSceneFunc_addText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_addText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtGui.QFont = QFont()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.addText", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_addWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addWidget", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // addWidget(QWidget*,QFlags<Qt::WindowType>)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsProxyWidget * cpp_result = cppSelf->QGraphicsScene::addWidget(cpp_arg0);
            py_result = Shiboken::Converter<QGraphicsProxyWidget* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // addWidget(QWidget*,QFlags<Qt::WindowType>)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsProxyWidget * cpp_result = cppSelf->QGraphicsScene::addWidget(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QGraphicsProxyWidget* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQGraphicsSceneFunc_addWidget_TypeError;
    } else goto SbkQGraphicsSceneFunc_addWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_addWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.addWidget", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_advance(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // advance()
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsScene::advance();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsSceneFunc_backgroundBrush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // backgroundBrush()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QGraphicsScene::backgroundBrush();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_bspTreeDepth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bspTreeDepth()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGraphicsScene::bspTreeDepth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_clearFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearFocus()
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsScene::clearFocus();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsSceneFunc_clearSelection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearSelection()
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsScene::clearSelection();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQGraphicsSceneFunc_collidingItems(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "collidingItems", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QGraphicsItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // collidingItems(const QGraphicsItem*,Qt::ItemSelectionMode)const
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::collidingItems(cpp_arg0);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(pyargs[1])) {
            Qt::ItemSelectionMode cpp_arg1 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(pyargs[1]);
            // collidingItems(const QGraphicsItem*,Qt::ItemSelectionMode)const
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::collidingItems(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else goto SbkQGraphicsSceneFunc_collidingItems_TypeError;
    } else goto SbkQGraphicsSceneFunc_collidingItems_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_collidingItems_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem, PySide.QtCore.Qt.ItemSelectionMode = Qt.IntersectsItemShape", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.collidingItems", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneContextMenuEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QGraphicsSceneContextMenuEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::contextMenuEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.contextMenuEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_dragEnterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dragEnterEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::dragEnterEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_dragEnterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_dragEnterEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.dragEnterEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_dragLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dragLeaveEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::dragLeaveEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_dragLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_dragLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.dragLeaveEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dragMoveEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::dragMoveEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.dragMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_drawBackground(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "drawBackground", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRectF& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg1_auto_ptr;
        QRectF* cpp_arg1 = Shiboken::Converter<QRectF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QRectF >(cpp_arg1);
        // drawBackground(QPainter*,QRectF)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::drawBackground(cpp_arg0, *cpp_arg1);
    } else goto SbkQGraphicsSceneFunc_drawBackground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_drawBackground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.drawBackground", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_drawForeground(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "drawForeground", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRectF& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg1_auto_ptr;
        QRectF* cpp_arg1 = Shiboken::Converter<QRectF* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QRectF >(cpp_arg1);
        // drawForeground(QPainter*,QRectF)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::drawForeground(cpp_arg0, *cpp_arg1);
    } else goto SbkQGraphicsSceneFunc_drawForeground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_drawForeground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.drawForeground", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dropEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::dropEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.dropEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsScene::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGraphicsSceneFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.event", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_eventFilter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // eventFilter(QObject*,QEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsScene::eventFilter(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGraphicsSceneFunc_eventFilter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_eventFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.eventFilter", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::focusInEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.focusInEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_focusItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // focusItem()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QGraphicsItem * cpp_result = cppSelf->QGraphicsScene::focusItem();
    py_result = Shiboken::Converter<QGraphicsItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsScene::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGraphicsSceneFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.focusNextPrevChild", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::focusOutEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.focusOutEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QGraphicsScene::font();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_foregroundBrush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // foregroundBrush()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QGraphicsScene::foregroundBrush();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_hasFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasFocus()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGraphicsScene::hasFocus();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsScene::height();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_helpEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneHelpEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneHelpEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneHelpEvent* >::toCpp(arg);
        // helpEvent(QGraphicsSceneHelpEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::helpEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_helpEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_helpEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneHelpEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.helpEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_inputMethodEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputMethodEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QInputMethodEvent* cpp_arg0 = Shiboken::Converter<QInputMethodEvent* >::toCpp(arg);
        // inputMethodEvent(QInputMethodEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::inputMethodEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_inputMethodEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_inputMethodEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputMethodEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.inputMethodEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_inputMethodQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::InputMethodQuery >::isConvertible(arg)) {
        Qt::InputMethodQuery cpp_arg0 = Shiboken::Converter<Qt::InputMethodQuery >::toCpp(arg);
        // inputMethodQuery(Qt::InputMethodQuery)const
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QGraphicsScene::inputMethodQuery(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQGraphicsSceneFunc_inputMethodQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_inputMethodQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodQuery", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.inputMethodQuery", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_invalidate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQGraphicsSceneFunc_invalidate_TypeError;

    if (!PyArg_UnpackTuple(args, "invalidate", 0, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 0) {
        // invalidate(QRectF,QFlags<QGraphicsScene::SceneLayer>)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::invalidate();
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // invalidate(qreal,qreal,qreal,qreal,QFlags<QGraphicsScene::SceneLayer>)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsScene::invalidate(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        } else if (SbkPySide_QtGui_QGraphicsScene_SceneLayer_Check(pyargs[4])) {
            QFlags<QGraphicsScene::SceneLayer> cpp_arg4 = Shiboken::Converter<QFlags<QGraphicsScene::SceneLayer> >::toCpp(pyargs[4]);
            // invalidate(qreal,qreal,qreal,qreal,QFlags<QGraphicsScene::SceneLayer>)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsScene::invalidate(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
        } else goto SbkQGraphicsSceneFunc_invalidate_TypeError;
    } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 1) {
            // invalidate(QRectF,QFlags<QGraphicsScene::SceneLayer>)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsScene::invalidate(*cpp_arg0);
        } else if (SbkPySide_QtGui_QGraphicsScene_SceneLayer_Check(pyargs[1])) {
            QFlags<QGraphicsScene::SceneLayer> cpp_arg1 = Shiboken::Converter<QFlags<QGraphicsScene::SceneLayer> >::toCpp(pyargs[1]);
            // invalidate(QRectF,QFlags<QGraphicsScene::SceneLayer>)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsScene::invalidate(*cpp_arg0, cpp_arg1);
        } else goto SbkQGraphicsSceneFunc_invalidate_TypeError;
    } else goto SbkQGraphicsSceneFunc_invalidate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_invalidate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF = QRectF(), PySide.QtGui.QGraphicsScene.SceneLayers = QGraphicsScene.AllLayers", "float, float, float, float, PySide.QtGui.QGraphicsScene.SceneLayers = QGraphicsScene.AllLayers", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.invalidate", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_isActive(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isActive()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGraphicsScene::isActive();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_isSortCacheEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSortCacheEnabled()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGraphicsScene::isSortCacheEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_itemAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "itemAt", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // itemAt(qreal,qreal)const
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsItem * cpp_result = cppSelf->QGraphicsScene::itemAt(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QGraphicsItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else if (numArgs == 3 && Shiboken::Converter<QTransform& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QTransform* cpp_arg2 = Shiboken::Converter<QTransform* >::toCpp(pyargs[2]);
            // itemAt(qreal,qreal,QTransform)const
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsItem * cpp_result = cppSelf->QGraphicsScene::itemAt(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QGraphicsItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQGraphicsSceneFunc_itemAt_TypeError;
    } else if (Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (numArgs == 1) {
            // itemAt(QPointF)const
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsItem * cpp_result = cppSelf->QGraphicsScene::itemAt(*cpp_arg0);
            py_result = Shiboken::Converter<QGraphicsItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else if (numArgs == 2 && Shiboken::Converter<QTransform& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QTransform* cpp_arg1 = Shiboken::Converter<QTransform* >::toCpp(pyargs[1]);
            // itemAt(QPointF,QTransform)const
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QGraphicsItem * cpp_result = cppSelf->QGraphicsScene::itemAt(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QGraphicsItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQGraphicsSceneFunc_itemAt_TypeError;
    } else goto SbkQGraphicsSceneFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_itemAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "PySide.QtCore.QPointF, PySide.QtGui.QTransform", "float, float", "float, float, PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.itemAt", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_itemIndexMethod(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // itemIndexMethod()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QGraphicsScene::ItemIndexMethod cpp_result = cppSelf->QGraphicsScene::itemIndexMethod();
    py_result = Shiboken::Converter<QGraphicsScene::ItemIndexMethod >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_items(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "items", 0, 7, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6])))
        return 0;

    if (numArgs == 0) {
        // items()const
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items();
        py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // items(qreal,qreal,qreal,qreal,Qt::ItemSelectionMode)const
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(pyargs[4])) {
            Qt::ItemSelectionMode cpp_arg4 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(pyargs[4]);
            if (numArgs == 5) {
                // items(qreal,qreal,qreal,qreal,Qt::ItemSelectionMode)const
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
            } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[5])) {
                Qt::SortOrder cpp_arg5 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[5]);
                if (numArgs == 6) {
                    // items(qreal,qreal,qreal,qreal,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                    QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                    py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
                } else if (Shiboken::Converter<QTransform& >::isConvertible(pyargs[6])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[6]))
                        return 0;
                    QTransform* cpp_arg6 = Shiboken::Converter<QTransform* >::toCpp(pyargs[6]);
                    // items(qreal,qreal,qreal,qreal,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                    QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, *cpp_arg6);
                    py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
                } else goto SbkQGraphicsSceneFunc_items_TypeError;
            } else goto SbkQGraphicsSceneFunc_items_TypeError;
        } else goto SbkQGraphicsSceneFunc_items_TypeError;
    } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 1) {
            // items(QRectF,Qt::ItemSelectionMode)const
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(pyargs[1])) {
            Qt::ItemSelectionMode cpp_arg1 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // items(QRectF,Qt::ItemSelectionMode)const
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
            } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[2])) {
                Qt::SortOrder cpp_arg2 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // items(QRectF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                    QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0, cpp_arg1, cpp_arg2);
                    py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
                } else if (Shiboken::Converter<QTransform& >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    QTransform* cpp_arg3 = Shiboken::Converter<QTransform* >::toCpp(pyargs[3]);
                    // items(QRectF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                    QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                    py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
                } else goto SbkQGraphicsSceneFunc_items_TypeError;
            } else goto SbkQGraphicsSceneFunc_items_TypeError;
        } else goto SbkQGraphicsSceneFunc_items_TypeError;
    } else if (Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPolygonF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        if (numArgs == 1) {
            // items(QPolygonF,Qt::ItemSelectionMode)const
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(pyargs[1])) {
            Qt::ItemSelectionMode cpp_arg1 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // items(QPolygonF,Qt::ItemSelectionMode)const
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
            } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[2])) {
                Qt::SortOrder cpp_arg2 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // items(QPolygonF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                    QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0, cpp_arg1, cpp_arg2);
                    py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
                } else if (Shiboken::Converter<QTransform& >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    QTransform* cpp_arg3 = Shiboken::Converter<QTransform* >::toCpp(pyargs[3]);
                    // items(QPolygonF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                    QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                    py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
                } else goto SbkQGraphicsSceneFunc_items_TypeError;
            } else goto SbkQGraphicsSceneFunc_items_TypeError;
        } else goto SbkQGraphicsSceneFunc_items_TypeError;
    } else if (Shiboken::Converter<QPointF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QPointF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (numArgs == 1) {
            // items(QPointF)const
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(pyargs[1]) && Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[2])) {
            Qt::ItemSelectionMode cpp_arg1 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(pyargs[1]);
            Qt::SortOrder cpp_arg2 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // items(QPointF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
            } else if (Shiboken::Converter<QTransform& >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QTransform* cpp_arg3 = Shiboken::Converter<QTransform* >::toCpp(pyargs[3]);
                // items(QPointF,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
            } else goto SbkQGraphicsSceneFunc_items_TypeError;
        } else goto SbkQGraphicsSceneFunc_items_TypeError;
    } else if (Shiboken::Converter<QPainterPath& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // items(QPainterPath,Qt::ItemSelectionMode)const
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0);
            py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
        } else if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(pyargs[1])) {
            Qt::ItemSelectionMode cpp_arg1 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // items(QPainterPath,Qt::ItemSelectionMode)const
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
            } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[2])) {
                Qt::SortOrder cpp_arg2 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // items(QPainterPath,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                    QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0, cpp_arg1, cpp_arg2);
                    py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
                } else if (Shiboken::Converter<QTransform& >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    QTransform* cpp_arg3 = Shiboken::Converter<QTransform* >::toCpp(pyargs[3]);
                    // items(QPainterPath,Qt::ItemSelectionMode,Qt::SortOrder,QTransform)const
                    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                    QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(*cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                    py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
                } else goto SbkQGraphicsSceneFunc_items_TypeError;
            } else goto SbkQGraphicsSceneFunc_items_TypeError;
        } else goto SbkQGraphicsSceneFunc_items_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[0])) {
        Qt::SortOrder cpp_arg0 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[0]);
        // items(Qt::SortOrder)const
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::items(cpp_arg0);
        py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);
    } else goto SbkQGraphicsSceneFunc_items_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_items_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.Qt.SortOrder", "PySide.QtGui.QPainterPath, PySide.QtCore.Qt.ItemSelectionMode = Qt.IntersectsItemShape", "PySide.QtGui.QPainterPath, PySide.QtCore.Qt.ItemSelectionMode, PySide.QtCore.Qt.SortOrder, PySide.QtGui.QTransform = QTransform()", "PySide.QtCore.QPointF", "PySide.QtCore.QPointF, PySide.QtCore.Qt.ItemSelectionMode, PySide.QtCore.Qt.SortOrder, PySide.QtGui.QTransform = QTransform()", "PySide.QtGui.QPolygonF, PySide.QtCore.Qt.ItemSelectionMode = Qt.IntersectsItemShape", "PySide.QtGui.QPolygonF, PySide.QtCore.Qt.ItemSelectionMode, PySide.QtCore.Qt.SortOrder, PySide.QtGui.QTransform = QTransform()", "PySide.QtCore.QRectF, PySide.QtCore.Qt.ItemSelectionMode = Qt.IntersectsItemShape", "PySide.QtCore.QRectF, PySide.QtCore.Qt.ItemSelectionMode, PySide.QtCore.Qt.SortOrder, PySide.QtGui.QTransform = QTransform()", "float, float, float, float, PySide.QtCore.Qt.ItemSelectionMode = Qt.IntersectsItemShape", "float, float, float, float, PySide.QtCore.Qt.ItemSelectionMode, PySide.QtCore.Qt.SortOrder, PySide.QtGui.QTransform = QTransform()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.items", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_itemsBoundingRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // itemsBoundingRect()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QGraphicsScene::itemsBoundingRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::keyPressEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.keyPressEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_keyReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyReleaseEvent(QKeyEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::keyReleaseEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_keyReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_keyReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.keyReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::mouseDoubleClickEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_mouseGrabberItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mouseGrabberItem()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QGraphicsItem * cpp_result = cppSelf->QGraphicsScene::mouseGrabberItem();
    py_result = Shiboken::Converter<QGraphicsItem* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QGraphicsSceneMouseEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::mouseMoveEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.mouseMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mousePressEvent(QGraphicsSceneMouseEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::mousePressEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.mousePressEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QGraphicsSceneMouseEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::mouseReleaseEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_palette(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // palette()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QPalette cpp_result = cppSelf->QGraphicsScene::palette();
    py_result = Shiboken::Converter<QPalette >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_removeItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(arg);
        // removeItem(QGraphicsItem*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::removeItem(cpp_arg0);
        Shiboken::setParent(self, 0);
    } else goto SbkQGraphicsSceneFunc_removeItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_removeItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.removeItem", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_render(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "render", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QPainter* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // render(QPainter*,QRectF,QRectF,Qt::AspectRatioMode)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsScene::render(cpp_arg0);
        } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QRectF > cpp_arg1_auto_ptr;
            QRectF* cpp_arg1 = Shiboken::Converter<QRectF* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QRectF >(cpp_arg1);
            if (numArgs == 2) {
                // render(QPainter*,QRectF,QRectF,Qt::AspectRatioMode)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsScene::render(cpp_arg0, *cpp_arg1);
            } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QRectF > cpp_arg2_auto_ptr;
                QRectF* cpp_arg2 = Shiboken::Converter<QRectF* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QRectF >(cpp_arg2);
                if (numArgs == 3) {
                    // render(QPainter*,QRectF,QRectF,Qt::AspectRatioMode)
                    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                    cppSelf->QGraphicsScene::render(cpp_arg0, *cpp_arg1, *cpp_arg2);
                } else if (Shiboken::Converter<Qt::AspectRatioMode >::isConvertible(pyargs[3])) {
                    Qt::AspectRatioMode cpp_arg3 = Shiboken::Converter<Qt::AspectRatioMode >::toCpp(pyargs[3]);
                    // render(QPainter*,QRectF,QRectF,Qt::AspectRatioMode)
                    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                    cppSelf->QGraphicsScene::render(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                } else goto SbkQGraphicsSceneFunc_render_TypeError;
            } else goto SbkQGraphicsSceneFunc_render_TypeError;
        } else goto SbkQGraphicsSceneFunc_render_TypeError;
    } else goto SbkQGraphicsSceneFunc_render_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_render_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRectF = QRectF(), PySide.QtCore.QRectF = QRectF(), PySide.QtCore.Qt.AspectRatioMode = Qt.KeepAspectRatio", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.render", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_sceneRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sceneRect()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QGraphicsScene::sceneRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_selectedItems(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedItems()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QList<QGraphicsItem * > cpp_result = cppSelf->QGraphicsScene::selectedItems();
    py_result = Shiboken::Converter<QList<QGraphicsItem * > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_selectionArea(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectionArea()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QPainterPath cpp_result = cppSelf->QGraphicsScene::selectionArea();
    py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_sendEvent(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sendEvent", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QGraphicsItem* >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // sendEvent(QGraphicsItem*,QEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsScene::sendEvent(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQGraphicsSceneFunc_sendEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGraphicsSceneFunc_sendEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.sendEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setActivePanel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(arg);
        // setActivePanel(QGraphicsItem*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setActivePanel(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setActivePanel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setActivePanel_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setActivePanel", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setActiveWindow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsWidget* cpp_arg0 = Shiboken::Converter<QGraphicsWidget* >::toCpp(arg);
        // setActiveWindow(QGraphicsWidget*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setActiveWindow(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setActiveWindow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setActiveWindow_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setActiveWindow", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setBackgroundBrush(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!Shiboken::Converter<QBrush& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setBackgroundBrush(QBrush)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setBackgroundBrush(*cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setBackgroundBrush_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setBackgroundBrush_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setBackgroundBrush", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setBspTreeDepth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setBspTreeDepth(int)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setBspTreeDepth(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setBspTreeDepth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setBspTreeDepth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setBspTreeDepth", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setFocus(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // setFocus(Qt::FocusReason)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setFocus();
    } else if (Shiboken::Converter<Qt::FocusReason >::isConvertible(arg)) {
        Qt::FocusReason cpp_arg0 = Shiboken::Converter<Qt::FocusReason >::toCpp(arg);
        // setFocus(Qt::FocusReason)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setFocus(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setFocus_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setFocus_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.FocusReason = Qt.OtherFocusReason", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setFocus", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setFocusItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFocusItem", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QGraphicsItem* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setFocusItem(QGraphicsItem*,Qt::FocusReason)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsScene::setFocusItem(cpp_arg0);
            Shiboken::setParent(self, pyargs[0]);
        } else if (Shiboken::Converter<Qt::FocusReason >::isConvertible(pyargs[1])) {
            Qt::FocusReason cpp_arg1 = Shiboken::Converter<Qt::FocusReason >::toCpp(pyargs[1]);
            // setFocusItem(QGraphicsItem*,Qt::FocusReason)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsScene::setFocusItem(cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkQGraphicsSceneFunc_setFocusItem_TypeError;
    } else goto SbkQGraphicsSceneFunc_setFocusItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setFocusItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem, PySide.QtCore.Qt.FocusReason = Qt.OtherFocusReason", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.setFocusItem", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!Shiboken::Converter<QFont& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setFont(QFont)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setFont(*cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setFont", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setForegroundBrush(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!Shiboken::Converter<QBrush& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setForegroundBrush(QBrush)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setForegroundBrush(*cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setForegroundBrush_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setForegroundBrush_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setForegroundBrush", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setItemIndexMethod(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsScene::ItemIndexMethod >::isConvertible(arg)) {
        QGraphicsScene::ItemIndexMethod cpp_arg0 = Shiboken::Converter<QGraphicsScene::ItemIndexMethod >::toCpp(arg);
        // setItemIndexMethod(QGraphicsScene::ItemIndexMethod)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setItemIndexMethod(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setItemIndexMethod_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setItemIndexMethod_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsScene.ItemIndexMethod", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setItemIndexMethod", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setPalette(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPalette& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(arg);
        if (!Shiboken::Converter<QPalette& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // setPalette(QPalette)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setPalette(*cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setPalette_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setPalette_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPalette", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setPalette", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setSceneRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQGraphicsSceneFunc_setSceneRect_TypeError;

    if (!PyArg_UnpackTuple(args, "setSceneRect", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // setSceneRect(qreal,qreal,qreal,qreal)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setSceneRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (numArgs == 1 && Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setSceneRect(QRectF)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setSceneRect(*cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setSceneRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setSceneRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.setSceneRect", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setSelectionArea(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setSelectionArea", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPainterPath& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setSelectionArea(QPainterPath)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsScene::setSelectionArea(*cpp_arg0);
        } else if (numArgs == 2 && Shiboken::Converter<QTransform& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QTransform* cpp_arg1 = Shiboken::Converter<QTransform* >::toCpp(pyargs[1]);
            // setSelectionArea(QPainterPath,QTransform)
            QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsScene::setSelectionArea(*cpp_arg0, *cpp_arg1);
        } else if (Shiboken::Converter<Qt::ItemSelectionMode >::isConvertible(pyargs[1])) {
            Qt::ItemSelectionMode cpp_arg1 = Shiboken::Converter<Qt::ItemSelectionMode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setSelectionArea(QPainterPath,Qt::ItemSelectionMode)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsScene::setSelectionArea(*cpp_arg0, cpp_arg1);
            } else if (numArgs == 3 && Shiboken::Converter<QTransform& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QTransform* cpp_arg2 = Shiboken::Converter<QTransform* >::toCpp(pyargs[2]);
                // setSelectionArea(QPainterPath,Qt::ItemSelectionMode,QTransform)
                QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsScene::setSelectionArea(*cpp_arg0, cpp_arg1, *cpp_arg2);
            } else goto SbkQGraphicsSceneFunc_setSelectionArea_TypeError;
        } else goto SbkQGraphicsSceneFunc_setSelectionArea_TypeError;
    } else goto SbkQGraphicsSceneFunc_setSelectionArea_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setSelectionArea_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", "PySide.QtGui.QPainterPath, PySide.QtCore.Qt.ItemSelectionMode", "PySide.QtGui.QPainterPath, PySide.QtCore.Qt.ItemSelectionMode, PySide.QtGui.QTransform", "PySide.QtGui.QPainterPath, PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.setSelectionArea", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setSortCacheEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSortCacheEnabled(bool)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setSortCacheEnabled(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setSortCacheEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setSortCacheEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setSortCacheEnabled", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setStickyFocus(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setStickyFocus(bool)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setStickyFocus(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setStickyFocus_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setStickyFocus_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setStickyFocus", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_setStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStyle* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStyle* cpp_arg0 = Shiboken::Converter<QStyle* >::toCpp(arg);
        // setStyle(QStyle*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::setStyle(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_setStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_setStyle_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.setStyle", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_stickyFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stickyFocus()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGraphicsScene::stickyFocus();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_style(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // style()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QStyle * cpp_result = cppSelf->QGraphicsScene::style();
    py_result = Shiboken::Converter<QStyle* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_update(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQGraphicsSceneFunc_update_TypeError;

    if (!PyArg_UnpackTuple(args, "update", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 0) {
        // update(QRectF)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::update();
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // update(qreal,qreal,qreal,qreal)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::update(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else if (Shiboken::Converter<QRectF& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QRectF& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // update(QRectF)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::update(*cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_update_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_update_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF = QRectF()", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsScene.update", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_views(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // views()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    QList<QGraphicsView * > cpp_result = cppSelf->QGraphicsScene::views();
    py_result = Shiboken::Converter<QList<QGraphicsView * > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGraphicsSceneFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneWheelEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneWheelEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp(arg);
        // wheelEvent(QGraphicsSceneWheelEvent*)
        QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsScene::wheelEvent(cpp_arg0);
    } else goto SbkQGraphicsSceneFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsScene.wheelEvent", overloads);
        return 0;
}

static PyObject*
SbkQGraphicsSceneFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QGraphicsScene* cppSelf = Shiboken::Converter<QGraphicsScene* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsScene::width();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQGraphicsScene_methods[] = {
    {"activePanel", (PyCFunction)SbkQGraphicsSceneFunc_activePanel, METH_NOARGS},
    {"activeWindow", (PyCFunction)SbkQGraphicsSceneFunc_activeWindow, METH_NOARGS},
    {"addEllipse", (PyCFunction)SbkQGraphicsSceneFunc_addEllipse, METH_VARARGS},
    {"addItem", (PyCFunction)SbkQGraphicsSceneFunc_addItem, METH_O},
    {"addLine", (PyCFunction)SbkQGraphicsSceneFunc_addLine, METH_VARARGS},
    {"addPath", (PyCFunction)SbkQGraphicsSceneFunc_addPath, METH_VARARGS},
    {"addPixmap", (PyCFunction)SbkQGraphicsSceneFunc_addPixmap, METH_O},
    {"addPolygon", (PyCFunction)SbkQGraphicsSceneFunc_addPolygon, METH_VARARGS},
    {"addRect", (PyCFunction)SbkQGraphicsSceneFunc_addRect, METH_VARARGS},
    {"addSimpleText", (PyCFunction)SbkQGraphicsSceneFunc_addSimpleText, METH_VARARGS},
    {"addText", (PyCFunction)SbkQGraphicsSceneFunc_addText, METH_VARARGS},
    {"addWidget", (PyCFunction)SbkQGraphicsSceneFunc_addWidget, METH_VARARGS},
    {"advance", (PyCFunction)SbkQGraphicsSceneFunc_advance, METH_NOARGS},
    {"backgroundBrush", (PyCFunction)SbkQGraphicsSceneFunc_backgroundBrush, METH_NOARGS},
    {"bspTreeDepth", (PyCFunction)SbkQGraphicsSceneFunc_bspTreeDepth, METH_NOARGS},
    {"clearFocus", (PyCFunction)SbkQGraphicsSceneFunc_clearFocus, METH_NOARGS},
    {"clearSelection", (PyCFunction)SbkQGraphicsSceneFunc_clearSelection, METH_NOARGS},
    {"collidingItems", (PyCFunction)SbkQGraphicsSceneFunc_collidingItems, METH_VARARGS},
    {"contextMenuEvent", (PyCFunction)SbkQGraphicsSceneFunc_contextMenuEvent, METH_O},
    {"dragEnterEvent", (PyCFunction)SbkQGraphicsSceneFunc_dragEnterEvent, METH_O},
    {"dragLeaveEvent", (PyCFunction)SbkQGraphicsSceneFunc_dragLeaveEvent, METH_O},
    {"dragMoveEvent", (PyCFunction)SbkQGraphicsSceneFunc_dragMoveEvent, METH_O},
    {"drawBackground", (PyCFunction)SbkQGraphicsSceneFunc_drawBackground, METH_VARARGS},
    {"drawForeground", (PyCFunction)SbkQGraphicsSceneFunc_drawForeground, METH_VARARGS},
    {"dropEvent", (PyCFunction)SbkQGraphicsSceneFunc_dropEvent, METH_O},
    {"event", (PyCFunction)SbkQGraphicsSceneFunc_event, METH_O},
    {"eventFilter", (PyCFunction)SbkQGraphicsSceneFunc_eventFilter, METH_VARARGS},
    {"focusInEvent", (PyCFunction)SbkQGraphicsSceneFunc_focusInEvent, METH_O},
    {"focusItem", (PyCFunction)SbkQGraphicsSceneFunc_focusItem, METH_NOARGS},
    {"focusNextPrevChild", (PyCFunction)SbkQGraphicsSceneFunc_focusNextPrevChild, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQGraphicsSceneFunc_focusOutEvent, METH_O},
    {"font", (PyCFunction)SbkQGraphicsSceneFunc_font, METH_NOARGS},
    {"foregroundBrush", (PyCFunction)SbkQGraphicsSceneFunc_foregroundBrush, METH_NOARGS},
    {"hasFocus", (PyCFunction)SbkQGraphicsSceneFunc_hasFocus, METH_NOARGS},
    {"height", (PyCFunction)SbkQGraphicsSceneFunc_height, METH_NOARGS},
    {"helpEvent", (PyCFunction)SbkQGraphicsSceneFunc_helpEvent, METH_O},
    {"inputMethodEvent", (PyCFunction)SbkQGraphicsSceneFunc_inputMethodEvent, METH_O},
    {"inputMethodQuery", (PyCFunction)SbkQGraphicsSceneFunc_inputMethodQuery, METH_O},
    {"invalidate", (PyCFunction)SbkQGraphicsSceneFunc_invalidate, METH_VARARGS},
    {"isActive", (PyCFunction)SbkQGraphicsSceneFunc_isActive, METH_NOARGS},
    {"isSortCacheEnabled", (PyCFunction)SbkQGraphicsSceneFunc_isSortCacheEnabled, METH_NOARGS},
    {"itemAt", (PyCFunction)SbkQGraphicsSceneFunc_itemAt, METH_VARARGS},
    {"itemIndexMethod", (PyCFunction)SbkQGraphicsSceneFunc_itemIndexMethod, METH_NOARGS},
    {"items", (PyCFunction)SbkQGraphicsSceneFunc_items, METH_VARARGS},
    {"itemsBoundingRect", (PyCFunction)SbkQGraphicsSceneFunc_itemsBoundingRect, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQGraphicsSceneFunc_keyPressEvent, METH_O},
    {"keyReleaseEvent", (PyCFunction)SbkQGraphicsSceneFunc_keyReleaseEvent, METH_O},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQGraphicsSceneFunc_mouseDoubleClickEvent, METH_O},
    {"mouseGrabberItem", (PyCFunction)SbkQGraphicsSceneFunc_mouseGrabberItem, METH_NOARGS},
    {"mouseMoveEvent", (PyCFunction)SbkQGraphicsSceneFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQGraphicsSceneFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQGraphicsSceneFunc_mouseReleaseEvent, METH_O},
    {"palette", (PyCFunction)SbkQGraphicsSceneFunc_palette, METH_NOARGS},
    {"removeItem", (PyCFunction)SbkQGraphicsSceneFunc_removeItem, METH_O},
    {"render", (PyCFunction)SbkQGraphicsSceneFunc_render, METH_VARARGS},
    {"sceneRect", (PyCFunction)SbkQGraphicsSceneFunc_sceneRect, METH_NOARGS},
    {"selectedItems", (PyCFunction)SbkQGraphicsSceneFunc_selectedItems, METH_NOARGS},
    {"selectionArea", (PyCFunction)SbkQGraphicsSceneFunc_selectionArea, METH_NOARGS},
    {"sendEvent", (PyCFunction)SbkQGraphicsSceneFunc_sendEvent, METH_VARARGS},
    {"setActivePanel", (PyCFunction)SbkQGraphicsSceneFunc_setActivePanel, METH_O},
    {"setActiveWindow", (PyCFunction)SbkQGraphicsSceneFunc_setActiveWindow, METH_O},
    {"setBackgroundBrush", (PyCFunction)SbkQGraphicsSceneFunc_setBackgroundBrush, METH_O},
    {"setBspTreeDepth", (PyCFunction)SbkQGraphicsSceneFunc_setBspTreeDepth, METH_O},
    {"setFocus", (PyCFunction)SbkQGraphicsSceneFunc_setFocus, METH_NOARGS|METH_O},
    {"setFocusItem", (PyCFunction)SbkQGraphicsSceneFunc_setFocusItem, METH_VARARGS},
    {"setFont", (PyCFunction)SbkQGraphicsSceneFunc_setFont, METH_O},
    {"setForegroundBrush", (PyCFunction)SbkQGraphicsSceneFunc_setForegroundBrush, METH_O},
    {"setItemIndexMethod", (PyCFunction)SbkQGraphicsSceneFunc_setItemIndexMethod, METH_O},
    {"setPalette", (PyCFunction)SbkQGraphicsSceneFunc_setPalette, METH_O},
    {"setSceneRect", (PyCFunction)SbkQGraphicsSceneFunc_setSceneRect, METH_VARARGS},
    {"setSelectionArea", (PyCFunction)SbkQGraphicsSceneFunc_setSelectionArea, METH_VARARGS},
    {"setSortCacheEnabled", (PyCFunction)SbkQGraphicsSceneFunc_setSortCacheEnabled, METH_O},
    {"setStickyFocus", (PyCFunction)SbkQGraphicsSceneFunc_setStickyFocus, METH_O},
    {"setStyle", (PyCFunction)SbkQGraphicsSceneFunc_setStyle, METH_O},
    {"stickyFocus", (PyCFunction)SbkQGraphicsSceneFunc_stickyFocus, METH_NOARGS},
    {"style", (PyCFunction)SbkQGraphicsSceneFunc_style, METH_NOARGS},
    {"update", (PyCFunction)SbkQGraphicsSceneFunc_update, METH_VARARGS},
    {"views", (PyCFunction)SbkQGraphicsSceneFunc_views, METH_NOARGS},
    {"wheelEvent", (PyCFunction)SbkQGraphicsSceneFunc_wheelEvent, METH_O},
    {"width", (PyCFunction)SbkQGraphicsSceneFunc_width, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsScene_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsScene",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGraphicsSceneWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsScene_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsScene_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

PyObject*
SbkPySide_QtGui_QGraphicsScene_SceneLayer___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsScene::SceneLayers >::toPython(
        ((QGraphicsScene::SceneLayers) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QGraphicsScene::SceneLayers >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsScene_SceneLayer___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsScene::SceneLayers >::toPython(
        ((QGraphicsScene::SceneLayers) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QGraphicsScene::SceneLayers >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsScene_SceneLayer___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsScene::SceneLayers >::toPython(
        ((QGraphicsScene::SceneLayers) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QGraphicsScene::SceneLayers >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsScene_SceneLayer___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsScene::SceneLayers >::toPython(
        ~ Shiboken::Converter< QGraphicsScene::SceneLayers >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QGraphicsScene_SceneLayer_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QGraphicsScene_SceneLayer___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QGraphicsScene_SceneLayer___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QGraphicsScene_SceneLayer___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QGraphicsScene_SceneLayer___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QGraphicsScene_SceneLayer_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsScene_SceneLayer_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SceneLayer",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QGraphicsScene_SceneLayer_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGraphicsScene_SceneLayer_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsScene_SceneLayer_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGraphicsScene_SceneLayer_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsScene_SceneLayers_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsScene_SceneLayers_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SceneLayers",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsScene_SceneLayers_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGraphicsScene_SceneLayers_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QGraphicsScene_SceneLayers_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ItemIndexMethod",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QGraphicsScene(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsScene_Type);

    SbkQGraphicsScene_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQGraphicsScene_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsScene_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsScene_Type));
    PyModule_AddObject(module, "QGraphicsScene",
        ((PyObject*)&SbkQGraphicsScene_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SceneLayer
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENE_SCENELAYER_IDX] = &SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type);
    PyDict_SetItemString(SbkQGraphicsScene_Type.super.ht_type.tp_dict,
            "SceneLayer",((PyObject*)&SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type));

    // init flags class: QFlags<QGraphicsScene::SceneLayer>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSSCENE_SCENELAYER__IDX] = &SbkPySide_QtGui_QGraphicsScene_SceneLayers_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsScene_SceneLayers_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsScene_SceneLayers_Type);
    PyDict_SetItemString(SbkQGraphicsScene_Type.super.ht_type.tp_dict,
            "SceneLayers",((PyObject*)&SbkPySide_QtGui_QGraphicsScene_SceneLayers_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type,
        (long) QGraphicsScene::ItemLayer, "ItemLayer");
    PyDict_SetItemString(SbkQGraphicsScene_Type.super.ht_type.tp_dict,
        "ItemLayer", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type.tp_dict,
        "ItemLayer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type,
        (long) QGraphicsScene::BackgroundLayer, "BackgroundLayer");
    PyDict_SetItemString(SbkQGraphicsScene_Type.super.ht_type.tp_dict,
        "BackgroundLayer", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type.tp_dict,
        "BackgroundLayer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type,
        (long) QGraphicsScene::ForegroundLayer, "ForegroundLayer");
    PyDict_SetItemString(SbkQGraphicsScene_Type.super.ht_type.tp_dict,
        "ForegroundLayer", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type.tp_dict,
        "ForegroundLayer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type,
        (long) QGraphicsScene::AllLayers, "AllLayers");
    PyDict_SetItemString(SbkQGraphicsScene_Type.super.ht_type.tp_dict,
        "AllLayers", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsScene_SceneLayer_Type.tp_dict,
        "AllLayers", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGraphicsScene::SceneLayer");

    // init enum class: ItemIndexMethod
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENE_ITEMINDEXMETHOD_IDX] = &SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_Type);
    PyDict_SetItemString(SbkQGraphicsScene_Type.super.ht_type.tp_dict,
            "ItemIndexMethod",((PyObject*)&SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_Type,
        (long) QGraphicsScene::BspTreeIndex, "BspTreeIndex");
    PyDict_SetItemString(SbkQGraphicsScene_Type.super.ht_type.tp_dict,
        "BspTreeIndex", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_Type.tp_dict,
        "BspTreeIndex", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_Type,
        (long) QGraphicsScene::NoIndex, "NoIndex");
    PyDict_SetItemString(SbkQGraphicsScene_Type.super.ht_type.tp_dict,
        "NoIndex", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsScene_ItemIndexMethod_Type.tp_dict,
        "NoIndex", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGraphicsScene::ItemIndexMethod");

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsScene >("QGraphicsScene*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsScene >(typeid(QGraphicsScene).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

